/*! For license information please see three.core.js.LICENSE.txt */
const REVISION="176",MOUSE={LEFT:0,MIDDLE:1,RIGHT:2,ROTATE:0,DOLLY:1,PAN:2},TOUCH={ROTATE:0,PAN:1,DOLLY_PAN:2,DOLLY_ROTATE:3},CullFaceNone=0,CullFaceBack=1,CullFaceFront=2,CullFaceFrontBack=3,BasicShadowMap=0,PCFShadowMap=1,PCFSoftShadowMap=2,VSMShadowMap=3,FrontSide=0,BackSide=1,DoubleSide=2,NoBlending=0,NormalBlending=1,AdditiveBlending=2,SubtractiveBlending=3,MultiplyBlending=4,CustomBlending=5,AddEquation=100,SubtractEquation=101,ReverseSubtractEquation=102,MinEquation=103,MaxEquation=104,ZeroFactor=200,OneFactor=201,SrcColorFactor=202,OneMinusSrcColorFactor=203,SrcAlphaFactor=204,OneMinusSrcAlphaFactor=205,DstAlphaFactor=206,OneMinusDstAlphaFactor=207,DstColorFactor=208,OneMinusDstColorFactor=209,SrcAlphaSaturateFactor=210,ConstantColorFactor=211,OneMinusConstantColorFactor=212,ConstantAlphaFactor=213,OneMinusConstantAlphaFactor=214,NeverDepth=0,AlwaysDepth=1,LessDepth=2,LessEqualDepth=3,EqualDepth=4,GreaterEqualDepth=5,GreaterDepth=6,NotEqualDepth=7,MultiplyOperation=0,MixOperation=1,AddOperation=2,NoToneMapping=0,LinearToneMapping=1,ReinhardToneMapping=2,CineonToneMapping=3,ACESFilmicToneMapping=4,CustomToneMapping=5,AgXToneMapping=6,NeutralToneMapping=7,AttachedBindMode="attached",DetachedBindMode="detached",UVMapping=300,CubeReflectionMapping=301,CubeRefractionMapping=302,EquirectangularReflectionMapping=303,EquirectangularRefractionMapping=304,CubeUVReflectionMapping=306,RepeatWrapping=1e3,ClampToEdgeWrapping=1001,MirroredRepeatWrapping=1002,NearestFilter=1003,NearestMipmapNearestFilter=1004,NearestMipMapNearestFilter=1004,NearestMipmapLinearFilter=1005,NearestMipMapLinearFilter=1005,LinearFilter=1006,LinearMipmapNearestFilter=1007,LinearMipMapNearestFilter=1007,LinearMipmapLinearFilter=1008,LinearMipMapLinearFilter=1008,UnsignedByteType=1009,ByteType=1010,ShortType=1011,UnsignedShortType=1012,IntType=1013,UnsignedIntType=1014,FloatType=1015,HalfFloatType=1016,UnsignedShort4444Type=1017,UnsignedShort5551Type=1018,UnsignedInt248Type=1020,UnsignedInt5999Type=35902,AlphaFormat=1021,RGBFormat=1022,RGBAFormat=1023,DepthFormat=1026,DepthStencilFormat=1027,RedFormat=1028,RedIntegerFormat=1029,RGFormat=1030,RGIntegerFormat=1031,RGBIntegerFormat=1032,RGBAIntegerFormat=1033,RGB_S3TC_DXT1_Format=33776,RGBA_S3TC_DXT1_Format=33777,RGBA_S3TC_DXT3_Format=33778,RGBA_S3TC_DXT5_Format=33779,RGB_PVRTC_4BPPV1_Format=35840,RGB_PVRTC_2BPPV1_Format=35841,RGBA_PVRTC_4BPPV1_Format=35842,RGBA_PVRTC_2BPPV1_Format=35843,RGB_ETC1_Format=36196,RGB_ETC2_Format=37492,RGBA_ETC2_EAC_Format=37496,RGBA_ASTC_4x4_Format=37808,RGBA_ASTC_5x4_Format=37809,RGBA_ASTC_5x5_Format=37810,RGBA_ASTC_6x5_Format=37811,RGBA_ASTC_6x6_Format=37812,RGBA_ASTC_8x5_Format=37813,RGBA_ASTC_8x6_Format=37814,RGBA_ASTC_8x8_Format=37815,RGBA_ASTC_10x5_Format=37816,RGBA_ASTC_10x6_Format=37817,RGBA_ASTC_10x8_Format=37818,RGBA_ASTC_10x10_Format=37819,RGBA_ASTC_12x10_Format=37820,RGBA_ASTC_12x12_Format=37821,RGBA_BPTC_Format=36492,RGB_BPTC_SIGNED_Format=36494,RGB_BPTC_UNSIGNED_Format=36495,RED_RGTC1_Format=36283,SIGNED_RED_RGTC1_Format=36284,RED_GREEN_RGTC2_Format=36285,SIGNED_RED_GREEN_RGTC2_Format=36286,LoopOnce=2200,LoopRepeat=2201,LoopPingPong=2202,InterpolateDiscrete=2300,InterpolateLinear=2301,InterpolateSmooth=2302,ZeroCurvatureEnding=2400,ZeroSlopeEnding=2401,WrapAroundEnding=2402,NormalAnimationBlendMode=2500,AdditiveAnimationBlendMode=2501,TrianglesDrawMode=0,TriangleStripDrawMode=1,TriangleFanDrawMode=2,BasicDepthPacking=3200,RGBADepthPacking=3201,RGBDepthPacking=3202,RGDepthPacking=3203,TangentSpaceNormalMap=0,ObjectSpaceNormalMap=1,NoColorSpace="",SRGBColorSpace="srgb",LinearSRGBColorSpace="srgb-linear",LinearTransfer="linear",SRGBTransfer="srgb",ZeroStencilOp=0,KeepStencilOp=7680,ReplaceStencilOp=7681,IncrementStencilOp=7682,DecrementStencilOp=7683,IncrementWrapStencilOp=34055,DecrementWrapStencilOp=34056,InvertStencilOp=5386,NeverStencilFunc=512,LessStencilFunc=513,EqualStencilFunc=514,LessEqualStencilFunc=515,GreaterStencilFunc=516,NotEqualStencilFunc=517,GreaterEqualStencilFunc=518,AlwaysStencilFunc=519,NeverCompare=512,LessCompare=513,EqualCompare=514,LessEqualCompare=515,GreaterCompare=516,NotEqualCompare=517,GreaterEqualCompare=518,AlwaysCompare=519,StaticDrawUsage=35044,DynamicDrawUsage=35048,StreamDrawUsage=35040,StaticReadUsage=35045,DynamicReadUsage=35049,StreamReadUsage=35041,StaticCopyUsage=35046,DynamicCopyUsage=35050,StreamCopyUsage=35042,GLSL1="100",GLSL3="300 es",WebGLCoordinateSystem=2e3,WebGPUCoordinateSystem=2001,TimestampQuery={COMPUTE:"compute",RENDER:"render"},InterpolationSamplingType={PERSPECTIVE:"perspective",LINEAR:"linear",FLAT:"flat"},InterpolationSamplingMode={NORMAL:"normal",CENTROID:"centroid",SAMPLE:"sample",FLAT_FIRST:"flat first",FLAT_EITHER:"flat either"};class EventDispatcher{addEventListener(t,e){void 0===this._listeners&&(this._listeners={});const i=this._listeners;void 0===i[t]&&(i[t]=[]),-1===i[t].indexOf(e)&&i[t].push(e)}hasEventListener(t,e){const i=this._listeners;return void 0!==i&&(void 0!==i[t]&&-1!==i[t].indexOf(e))}removeEventListener(t,e){const i=this._listeners;if(void 0===i)return;const r=i[t];if(void 0!==r){const t=r.indexOf(e);-1!==t&&r.splice(t,1)}}dispatchEvent(t){const e=this._listeners;if(void 0===e)return;const i=e[t.type];if(void 0!==i){t.target=this;const e=i.slice(0);for(let i=0,r=e.length;i<r;i++)e[i].call(this,t);t.target=null}}}const _lut=["00","01","02","03","04","05","06","07","08","09","0a","0b","0c","0d","0e","0f","10","11","12","13","14","15","16","17","18","19","1a","1b","1c","1d","1e","1f","20","21","22","23","24","25","26","27","28","29","2a","2b","2c","2d","2e","2f","30","31","32","33","34","35","36","37","38","39","3a","3b","3c","3d","3e","3f","40","41","42","43","44","45","46","47","48","49","4a","4b","4c","4d","4e","4f","50","51","52","53","54","55","56","57","58","59","5a","5b","5c","5d","5e","5f","60","61","62","63","64","65","66","67","68","69","6a","6b","6c","6d","6e","6f","70","71","72","73","74","75","76","77","78","79","7a","7b","7c","7d","7e","7f","80","81","82","83","84","85","86","87","88","89","8a","8b","8c","8d","8e","8f","90","91","92","93","94","95","96","97","98","99","9a","9b","9c","9d","9e","9f","a0","a1","a2","a3","a4","a5","a6","a7","a8","a9","aa","ab","ac","ad","ae","af","b0","b1","b2","b3","b4","b5","b6","b7","b8","b9","ba","bb","bc","bd","be","bf","c0","c1","c2","c3","c4","c5","c6","c7","c8","c9","ca","cb","cc","cd","ce","cf","d0","d1","d2","d3","d4","d5","d6","d7","d8","d9","da","db","dc","dd","de","df","e0","e1","e2","e3","e4","e5","e6","e7","e8","e9","ea","eb","ec","ed","ee","ef","f0","f1","f2","f3","f4","f5","f6","f7","f8","f9","fa","fb","fc","fd","fe","ff"];let _seed=1234567;const DEG2RAD=Math.PI/180,RAD2DEG=180/Math.PI;function generateUUID(){const t=4294967295*Math.random()|0,e=4294967295*Math.random()|0,i=4294967295*Math.random()|0,r=4294967295*Math.random()|0;return(_lut[255&t]+_lut[t>>8&255]+_lut[t>>16&255]+_lut[t>>24&255]+"-"+_lut[255&e]+_lut[e>>8&255]+"-"+_lut[e>>16&15|64]+_lut[e>>24&255]+"-"+_lut[63&i|128]+_lut[i>>8&255]+"-"+_lut[i>>16&255]+_lut[i>>24&255]+_lut[255&r]+_lut[r>>8&255]+_lut[r>>16&255]+_lut[r>>24&255]).toLowerCase()}function clamp(t,e,i){return Math.max(e,Math.min(i,t))}function euclideanModulo(t,e){return(t%e+e)%e}function mapLinear(t,e,i,r,s){return r+(t-e)*(s-r)/(i-e)}function inverseLerp(t,e,i){return t!==e?(i-t)/(e-t):0}function lerp(t,e,i){return(1-i)*t+i*e}function damp(t,e,i,r){return lerp(t,e,1-Math.exp(-i*r))}function pingpong(t,e=1){return e-Math.abs(euclideanModulo(t,2*e)-e)}function smoothstep(t,e,i){return t<=e?0:t>=i?1:(t=(t-e)/(i-e))*t*(3-2*t)}function smootherstep(t,e,i){return t<=e?0:t>=i?1:(t=(t-e)/(i-e))*t*t*(t*(6*t-15)+10)}function randInt(t,e){return t+Math.floor(Math.random()*(e-t+1))}function randFloat(t,e){return t+Math.random()*(e-t)}function randFloatSpread(t){return t*(.5-Math.random())}function seededRandom(t){void 0!==t&&(_seed=t);let e=_seed+=1831565813;return e=Math.imul(e^e>>>15,1|e),e^=e+Math.imul(e^e>>>7,61|e),((e^e>>>14)>>>0)/4294967296}function degToRad(t){return t*DEG2RAD}function radToDeg(t){return t*RAD2DEG}function isPowerOfTwo(t){return!(t&t-1)&&0!==t}function ceilPowerOfTwo(t){return Math.pow(2,Math.ceil(Math.log(t)/Math.LN2))}function floorPowerOfTwo(t){return Math.pow(2,Math.floor(Math.log(t)/Math.LN2))}function setQuaternionFromProperEuler(t,e,i,r,s){const n=Math.cos,a=Math.sin,o=n(i/2),h=a(i/2),c=n((e+r)/2),l=a((e+r)/2),u=n((e-r)/2),p=a((e-r)/2),d=n((r-e)/2),m=a((r-e)/2);switch(s){case"XYX":t.set(o*l,h*u,h*p,o*c);break;case"YZY":t.set(h*p,o*l,h*u,o*c);break;case"ZXZ":t.set(h*u,h*p,o*l,o*c);break;case"XZX":t.set(o*l,h*m,h*d,o*c);break;case"YXY":t.set(h*d,o*l,h*m,o*c);break;case"ZYZ":t.set(h*m,h*d,o*l,o*c);break;default:console.warn("THREE.MathUtils: .setQuaternionFromProperEuler() encountered an unknown order: "+s)}}function denormalize(t,e){switch(e.constructor){case Float32Array:return t;case Uint32Array:return t/4294967295;case Uint16Array:return t/65535;case Uint8Array:return t/255;case Int32Array:return Math.max(t/2147483647,-1);case Int16Array:return Math.max(t/32767,-1);case Int8Array:return Math.max(t/127,-1);default:throw new Error("Invalid component type.")}}function normalize(t,e){switch(e.constructor){case Float32Array:return t;case Uint32Array:return Math.round(4294967295*t);case Uint16Array:return Math.round(65535*t);case Uint8Array:return Math.round(255*t);case Int32Array:return Math.round(2147483647*t);case Int16Array:return Math.round(32767*t);case Int8Array:return Math.round(127*t);default:throw new Error("Invalid component type.")}}const MathUtils={DEG2RAD,RAD2DEG,generateUUID,clamp,euclideanModulo,mapLinear,inverseLerp,lerp,damp,pingpong,smoothstep,smootherstep,randInt,randFloat,randFloatSpread,seededRandom,degToRad,radToDeg,isPowerOfTwo,ceilPowerOfTwo,floorPowerOfTwo,setQuaternionFromProperEuler,normalize,denormalize};class Vector2{constructor(t=0,e=0){Vector2.prototype.isVector2=!0,this.x=t,this.y=e}get width(){return this.x}set width(t){this.x=t}get height(){return this.y}set height(t){this.y=t}set(t,e){return this.x=t,this.y=e,this}setScalar(t){return this.x=t,this.y=t,this}setX(t){return this.x=t,this}setY(t){return this.y=t,this}setComponent(t,e){switch(t){case 0:this.x=e;break;case 1:this.y=e;break;default:throw new Error("index is out of range: "+t)}return this}getComponent(t){switch(t){case 0:return this.x;case 1:return this.y;default:throw new Error("index is out of range: "+t)}}clone(){return new this.constructor(this.x,this.y)}copy(t){return this.x=t.x,this.y=t.y,this}add(t){return this.x+=t.x,this.y+=t.y,this}addScalar(t){return this.x+=t,this.y+=t,this}addVectors(t,e){return this.x=t.x+e.x,this.y=t.y+e.y,this}addScaledVector(t,e){return this.x+=t.x*e,this.y+=t.y*e,this}sub(t){return this.x-=t.x,this.y-=t.y,this}subScalar(t){return this.x-=t,this.y-=t,this}subVectors(t,e){return this.x=t.x-e.x,this.y=t.y-e.y,this}multiply(t){return this.x*=t.x,this.y*=t.y,this}multiplyScalar(t){return this.x*=t,this.y*=t,this}divide(t){return this.x/=t.x,this.y/=t.y,this}divideScalar(t){return this.multiplyScalar(1/t)}applyMatrix3(t){const e=this.x,i=this.y,r=t.elements;return this.x=r[0]*e+r[3]*i+r[6],this.y=r[1]*e+r[4]*i+r[7],this}min(t){return this.x=Math.min(this.x,t.x),this.y=Math.min(this.y,t.y),this}max(t){return this.x=Math.max(this.x,t.x),this.y=Math.max(this.y,t.y),this}clamp(t,e){return this.x=clamp(this.x,t.x,e.x),this.y=clamp(this.y,t.y,e.y),this}clampScalar(t,e){return this.x=clamp(this.x,t,e),this.y=clamp(this.y,t,e),this}clampLength(t,e){const i=this.length();return this.divideScalar(i||1).multiplyScalar(clamp(i,t,e))}floor(){return this.x=Math.floor(this.x),this.y=Math.floor(this.y),this}ceil(){return this.x=Math.ceil(this.x),this.y=Math.ceil(this.y),this}round(){return this.x=Math.round(this.x),this.y=Math.round(this.y),this}roundToZero(){return this.x=Math.trunc(this.x),this.y=Math.trunc(this.y),this}negate(){return this.x=-this.x,this.y=-this.y,this}dot(t){return this.x*t.x+this.y*t.y}cross(t){return this.x*t.y-this.y*t.x}lengthSq(){return this.x*this.x+this.y*this.y}length(){return Math.sqrt(this.x*this.x+this.y*this.y)}manhattanLength(){return Math.abs(this.x)+Math.abs(this.y)}normalize(){return this.divideScalar(this.length()||1)}angle(){return Math.atan2(-this.y,-this.x)+Math.PI}angleTo(t){const e=Math.sqrt(this.lengthSq()*t.lengthSq());if(0===e)return Math.PI/2;const i=this.dot(t)/e;return Math.acos(clamp(i,-1,1))}distanceTo(t){return Math.sqrt(this.distanceToSquared(t))}distanceToSquared(t){const e=this.x-t.x,i=this.y-t.y;return e*e+i*i}manhattanDistanceTo(t){return Math.abs(this.x-t.x)+Math.abs(this.y-t.y)}setLength(t){return this.normalize().multiplyScalar(t)}lerp(t,e){return this.x+=(t.x-this.x)*e,this.y+=(t.y-this.y)*e,this}lerpVectors(t,e,i){return this.x=t.x+(e.x-t.x)*i,this.y=t.y+(e.y-t.y)*i,this}equals(t){return t.x===this.x&&t.y===this.y}fromArray(t,e=0){return this.x=t[e],this.y=t[e+1],this}toArray(t=[],e=0){return t[e]=this.x,t[e+1]=this.y,t}fromBufferAttribute(t,e){return this.x=t.getX(e),this.y=t.getY(e),this}rotateAround(t,e){const i=Math.cos(e),r=Math.sin(e),s=this.x-t.x,n=this.y-t.y;return this.x=s*i-n*r+t.x,this.y=s*r+n*i+t.y,this}random(){return this.x=Math.random(),this.y=Math.random(),this}*[Symbol.iterator](){yield this.x,yield this.y}}class Matrix3{constructor(t,e,i,r,s,n,a,o,h){Matrix3.prototype.isMatrix3=!0,this.elements=[1,0,0,0,1,0,0,0,1],void 0!==t&&this.set(t,e,i,r,s,n,a,o,h)}set(t,e,i,r,s,n,a,o,h){const c=this.elements;return c[0]=t,c[1]=r,c[2]=a,c[3]=e,c[4]=s,c[5]=o,c[6]=i,c[7]=n,c[8]=h,this}identity(){return this.set(1,0,0,0,1,0,0,0,1),this}copy(t){const e=this.elements,i=t.elements;return e[0]=i[0],e[1]=i[1],e[2]=i[2],e[3]=i[3],e[4]=i[4],e[5]=i[5],e[6]=i[6],e[7]=i[7],e[8]=i[8],this}extractBasis(t,e,i){return t.setFromMatrix3Column(this,0),e.setFromMatrix3Column(this,1),i.setFromMatrix3Column(this,2),this}setFromMatrix4(t){const e=t.elements;return this.set(e[0],e[4],e[8],e[1],e[5],e[9],e[2],e[6],e[10]),this}multiply(t){return this.multiplyMatrices(this,t)}premultiply(t){return this.multiplyMatrices(t,this)}multiplyMatrices(t,e){const i=t.elements,r=e.elements,s=this.elements,n=i[0],a=i[3],o=i[6],h=i[1],c=i[4],l=i[7],u=i[2],p=i[5],d=i[8],m=r[0],y=r[3],f=r[6],g=r[1],x=r[4],_=r[7],v=r[2],b=r[5],M=r[8];return s[0]=n*m+a*g+o*v,s[3]=n*y+a*x+o*b,s[6]=n*f+a*_+o*M,s[1]=h*m+c*g+l*v,s[4]=h*y+c*x+l*b,s[7]=h*f+c*_+l*M,s[2]=u*m+p*g+d*v,s[5]=u*y+p*x+d*b,s[8]=u*f+p*_+d*M,this}multiplyScalar(t){const e=this.elements;return e[0]*=t,e[3]*=t,e[6]*=t,e[1]*=t,e[4]*=t,e[7]*=t,e[2]*=t,e[5]*=t,e[8]*=t,this}determinant(){const t=this.elements,e=t[0],i=t[1],r=t[2],s=t[3],n=t[4],a=t[5],o=t[6],h=t[7],c=t[8];return e*n*c-e*a*h-i*s*c+i*a*o+r*s*h-r*n*o}invert(){const t=this.elements,e=t[0],i=t[1],r=t[2],s=t[3],n=t[4],a=t[5],o=t[6],h=t[7],c=t[8],l=c*n-a*h,u=a*o-c*s,p=h*s-n*o,d=e*l+i*u+r*p;if(0===d)return this.set(0,0,0,0,0,0,0,0,0);const m=1/d;return t[0]=l*m,t[1]=(r*h-c*i)*m,t[2]=(a*i-r*n)*m,t[3]=u*m,t[4]=(c*e-r*o)*m,t[5]=(r*s-a*e)*m,t[6]=p*m,t[7]=(i*o-h*e)*m,t[8]=(n*e-i*s)*m,this}transpose(){let t;const e=this.elements;return t=e[1],e[1]=e[3],e[3]=t,t=e[2],e[2]=e[6],e[6]=t,t=e[5],e[5]=e[7],e[7]=t,this}getNormalMatrix(t){return this.setFromMatrix4(t).invert().transpose()}transposeIntoArray(t){const e=this.elements;return t[0]=e[0],t[1]=e[3],t[2]=e[6],t[3]=e[1],t[4]=e[4],t[5]=e[7],t[6]=e[2],t[7]=e[5],t[8]=e[8],this}setUvTransform(t,e,i,r,s,n,a){const o=Math.cos(s),h=Math.sin(s);return this.set(i*o,i*h,-i*(o*n+h*a)+n+t,-r*h,r*o,-r*(-h*n+o*a)+a+e,0,0,1),this}scale(t,e){return this.premultiply(_m3.makeScale(t,e)),this}rotate(t){return this.premultiply(_m3.makeRotation(-t)),this}translate(t,e){return this.premultiply(_m3.makeTranslation(t,e)),this}makeTranslation(t,e){return t.isVector2?this.set(1,0,t.x,0,1,t.y,0,0,1):this.set(1,0,t,0,1,e,0,0,1),this}makeRotation(t){const e=Math.cos(t),i=Math.sin(t);return this.set(e,-i,0,i,e,0,0,0,1),this}makeScale(t,e){return this.set(t,0,0,0,e,0,0,0,1),this}equals(t){const e=this.elements,i=t.elements;for(let t=0;t<9;t++)if(e[t]!==i[t])return!1;return!0}fromArray(t,e=0){for(let i=0;i<9;i++)this.elements[i]=t[i+e];return this}toArray(t=[],e=0){const i=this.elements;return t[e]=i[0],t[e+1]=i[1],t[e+2]=i[2],t[e+3]=i[3],t[e+4]=i[4],t[e+5]=i[5],t[e+6]=i[6],t[e+7]=i[7],t[e+8]=i[8],t}clone(){return(new this.constructor).fromArray(this.elements)}}const _m3=new Matrix3;function arrayNeedsUint32(t){for(let e=t.length-1;e>=0;--e)if(t[e]>=65535)return!0;return!1}const TYPED_ARRAYS={Int8Array,Uint8Array,Uint8ClampedArray,Int16Array,Uint16Array,Int32Array,Uint32Array,Float32Array,Float64Array};function getTypedArray(t,e){return new TYPED_ARRAYS[t](e)}function createElementNS(t){return document.createElementNS("http://www.w3.org/1999/xhtml",t)}function createCanvasElement(){const t=createElementNS("canvas");return t.style.display="block",t}const _cache={};function warnOnce(t){t in _cache||(_cache[t]=!0,console.warn(t))}function probeAsync(t,e,i){return new Promise((function(r,s){setTimeout((function n(){switch(t.clientWaitSync(e,t.SYNC_FLUSH_COMMANDS_BIT,0)){case t.WAIT_FAILED:s();break;case t.TIMEOUT_EXPIRED:setTimeout(n,i);break;default:r()}}),i)}))}function toNormalizedProjectionMatrix(t){const e=t.elements;e[2]=.5*e[2]+.5*e[3],e[6]=.5*e[6]+.5*e[7],e[10]=.5*e[10]+.5*e[11],e[14]=.5*e[14]+.5*e[15]}function toReversedProjectionMatrix(t){const e=t.elements;-1===e[11]?(e[10]=-e[10]-1,e[14]=-e[14]):(e[10]=-e[10],e[14]=1-e[14])}const LINEAR_REC709_TO_XYZ=(new Matrix3).set(.4123908,.3575843,.1804808,.212639,.7151687,.0721923,.0193308,.1191948,.9505322),XYZ_TO_LINEAR_REC709=(new Matrix3).set(3.2409699,-1.5373832,-.4986108,-.9692436,1.8759675,.0415551,.0556301,-.203977,1.0569715);function createColorManagement(){const t={enabled:!0,workingColorSpace:"srgb-linear",spaces:{},convert:function(t,e,i){return!1!==this.enabled&&e!==i&&e&&i?("srgb"===this.spaces[e].transfer&&(t.r=SRGBToLinear(t.r),t.g=SRGBToLinear(t.g),t.b=SRGBToLinear(t.b)),this.spaces[e].primaries!==this.spaces[i].primaries&&(t.applyMatrix3(this.spaces[e].toXYZ),t.applyMatrix3(this.spaces[i].fromXYZ)),"srgb"===this.spaces[i].transfer&&(t.r=LinearToSRGB(t.r),t.g=LinearToSRGB(t.g),t.b=LinearToSRGB(t.b)),t):t},fromWorkingColorSpace:function(t,e){return this.convert(t,this.workingColorSpace,e)},toWorkingColorSpace:function(t,e){return this.convert(t,e,this.workingColorSpace)},getPrimaries:function(t){return this.spaces[t].primaries},getTransfer:function(t){return""===t?"linear":this.spaces[t].transfer},getLuminanceCoefficients:function(t,e=this.workingColorSpace){return t.fromArray(this.spaces[e].luminanceCoefficients)},define:function(t){Object.assign(this.spaces,t)},_getMatrix:function(t,e,i){return t.copy(this.spaces[e].toXYZ).multiply(this.spaces[i].fromXYZ)},_getDrawingBufferColorSpace:function(t){return this.spaces[t].outputColorSpaceConfig.drawingBufferColorSpace},_getUnpackColorSpace:function(t=this.workingColorSpace){return this.spaces[t].workingColorSpaceConfig.unpackColorSpace}},e=[.64,.33,.3,.6,.15,.06],i=[.2126,.7152,.0722],r=[.3127,.329];return t.define({[LinearSRGBColorSpace]:{primaries:e,whitePoint:r,transfer:"linear",toXYZ:LINEAR_REC709_TO_XYZ,fromXYZ:XYZ_TO_LINEAR_REC709,luminanceCoefficients:i,workingColorSpaceConfig:{unpackColorSpace:"srgb"},outputColorSpaceConfig:{drawingBufferColorSpace:"srgb"}},[SRGBColorSpace]:{primaries:e,whitePoint:r,transfer:"srgb",toXYZ:LINEAR_REC709_TO_XYZ,fromXYZ:XYZ_TO_LINEAR_REC709,luminanceCoefficients:i,outputColorSpaceConfig:{drawingBufferColorSpace:"srgb"}}}),t}const ColorManagement=createColorManagement();function SRGBToLinear(t){return t<.04045?.0773993808*t:Math.pow(.9478672986*t+.0521327014,2.4)}function LinearToSRGB(t){return t<.0031308?12.92*t:1.055*Math.pow(t,.41666)-.055}let _canvas;class ImageUtils{static getDataURL(t,e="image/png"){if(/^data:/i.test(t.src))return t.src;if("undefined"==typeof HTMLCanvasElement)return t.src;let i;if(t instanceof HTMLCanvasElement)i=t;else{void 0===_canvas&&(_canvas=createElementNS("canvas")),_canvas.width=t.width,_canvas.height=t.height;const e=_canvas.getContext("2d");t instanceof ImageData?e.putImageData(t,0,0):e.drawImage(t,0,0,t.width,t.height),i=_canvas}return i.toDataURL(e)}static sRGBToLinear(t){if("undefined"!=typeof HTMLImageElement&&t instanceof HTMLImageElement||"undefined"!=typeof HTMLCanvasElement&&t instanceof HTMLCanvasElement||"undefined"!=typeof ImageBitmap&&t instanceof ImageBitmap){const e=createElementNS("canvas");e.width=t.width,e.height=t.height;const i=e.getContext("2d");i.drawImage(t,0,0,t.width,t.height);const r=i.getImageData(0,0,t.width,t.height),s=r.data;for(let t=0;t<s.length;t++)s[t]=255*SRGBToLinear(s[t]/255);return i.putImageData(r,0,0),e}if(t.data){const e=t.data.slice(0);for(let t=0;t<e.length;t++)e instanceof Uint8Array||e instanceof Uint8ClampedArray?e[t]=Math.floor(255*SRGBToLinear(e[t]/255)):e[t]=SRGBToLinear(e[t]);return{data:e,width:t.width,height:t.height}}return console.warn("THREE.ImageUtils.sRGBToLinear(): Unsupported image type. No color space conversion applied."),t}}let _sourceId=0;class Source{constructor(t=null){this.isSource=!0,Object.defineProperty(this,"id",{value:_sourceId++}),this.uuid=generateUUID(),this.data=t,this.dataReady=!0,this.version=0}set needsUpdate(t){!0===t&&this.version++}toJSON(t){const e=void 0===t||"string"==typeof t;if(!e&&void 0!==t.images[this.uuid])return t.images[this.uuid];const i={uuid:this.uuid,url:""},r=this.data;if(null!==r){let t;if(Array.isArray(r)){t=[];for(let e=0,i=r.length;e<i;e++)r[e].isDataTexture?t.push(serializeImage(r[e].image)):t.push(serializeImage(r[e]))}else t=serializeImage(r);i.url=t}return e||(t.images[this.uuid]=i),i}}function serializeImage(t){return"undefined"!=typeof HTMLImageElement&&t instanceof HTMLImageElement||"undefined"!=typeof HTMLCanvasElement&&t instanceof HTMLCanvasElement||"undefined"!=typeof ImageBitmap&&t instanceof ImageBitmap?ImageUtils.getDataURL(t):t.data?{data:Array.from(t.data),width:t.width,height:t.height,type:t.data.constructor.name}:(console.warn("THREE.Texture: Unable to serialize Texture."),{})}let _textureId=0;class Texture extends EventDispatcher{constructor(t=Texture.DEFAULT_IMAGE,e=Texture.DEFAULT_MAPPING,i=1001,r=1001,s=1006,n=1008,a=1023,o=1009,h=Texture.DEFAULT_ANISOTROPY,c=""){super(),this.isTexture=!0,Object.defineProperty(this,"id",{value:_textureId++}),this.uuid=generateUUID(),this.name="",this.source=new Source(t),this.mipmaps=[],this.mapping=e,this.channel=0,this.wrapS=i,this.wrapT=r,this.magFilter=s,this.minFilter=n,this.anisotropy=h,this.format=a,this.internalFormat=null,this.type=o,this.offset=new Vector2(0,0),this.repeat=new Vector2(1,1),this.center=new Vector2(0,0),this.rotation=0,this.matrixAutoUpdate=!0,this.matrix=new Matrix3,this.generateMipmaps=!0,this.premultiplyAlpha=!1,this.flipY=!0,this.unpackAlignment=4,this.colorSpace=c,this.userData={},this.version=0,this.onUpdate=null,this.renderTarget=null,this.isRenderTargetTexture=!1,this.isTextureArray=!1,this.pmremVersion=0}get image(){return this.source.data}set image(t=null){this.source.data=t}updateMatrix(){this.matrix.setUvTransform(this.offset.x,this.offset.y,this.repeat.x,this.repeat.y,this.rotation,this.center.x,this.center.y)}clone(){return(new this.constructor).copy(this)}copy(t){return this.name=t.name,this.source=t.source,this.mipmaps=t.mipmaps.slice(0),this.mapping=t.mapping,this.channel=t.channel,this.wrapS=t.wrapS,this.wrapT=t.wrapT,this.magFilter=t.magFilter,this.minFilter=t.minFilter,this.anisotropy=t.anisotropy,this.format=t.format,this.internalFormat=t.internalFormat,this.type=t.type,this.offset.copy(t.offset),this.repeat.copy(t.repeat),this.center.copy(t.center),this.rotation=t.rotation,this.matrixAutoUpdate=t.matrixAutoUpdate,this.matrix.copy(t.matrix),this.generateMipmaps=t.generateMipmaps,this.premultiplyAlpha=t.premultiplyAlpha,this.flipY=t.flipY,this.unpackAlignment=t.unpackAlignment,this.colorSpace=t.colorSpace,this.renderTarget=t.renderTarget,this.isRenderTargetTexture=t.isRenderTargetTexture,this.isTextureArray=t.isTextureArray,this.userData=JSON.parse(JSON.stringify(t.userData)),this.needsUpdate=!0,this}toJSON(t){const e=void 0===t||"string"==typeof t;if(!e&&void 0!==t.textures[this.uuid])return t.textures[this.uuid];const i={metadata:{version:4.6,type:"Texture",generator:"Texture.toJSON"},uuid:this.uuid,name:this.name,image:this.source.toJSON(t).uuid,mapping:this.mapping,channel:this.channel,repeat:[this.repeat.x,this.repeat.y],offset:[this.offset.x,this.offset.y],center:[this.center.x,this.center.y],rotation:this.rotation,wrap:[this.wrapS,this.wrapT],format:this.format,internalFormat:this.internalFormat,type:this.type,colorSpace:this.colorSpace,minFilter:this.minFilter,magFilter:this.magFilter,anisotropy:this.anisotropy,flipY:this.flipY,generateMipmaps:this.generateMipmaps,premultiplyAlpha:this.premultiplyAlpha,unpackAlignment:this.unpackAlignment};return Object.keys(this.userData).length>0&&(i.userData=this.userData),e||(t.textures[this.uuid]=i),i}dispose(){this.dispatchEvent({type:"dispose"})}transformUv(t){if(300!==this.mapping)return t;if(t.applyMatrix3(this.matrix),t.x<0||t.x>1)switch(this.wrapS){case 1e3:t.x=t.x-Math.floor(t.x);break;case 1001:t.x=t.x<0?0:1;break;case 1002:1===Math.abs(Math.floor(t.x)%2)?t.x=Math.ceil(t.x)-t.x:t.x=t.x-Math.floor(t.x)}if(t.y<0||t.y>1)switch(this.wrapT){case 1e3:t.y=t.y-Math.floor(t.y);break;case 1001:t.y=t.y<0?0:1;break;case 1002:1===Math.abs(Math.floor(t.y)%2)?t.y=Math.ceil(t.y)-t.y:t.y=t.y-Math.floor(t.y)}return this.flipY&&(t.y=1-t.y),t}set needsUpdate(t){!0===t&&(this.version++,this.source.needsUpdate=!0)}set needsPMREMUpdate(t){!0===t&&this.pmremVersion++}}Texture.DEFAULT_IMAGE=null,Texture.DEFAULT_MAPPING=300,Texture.DEFAULT_ANISOTROPY=1;class Vector4{constructor(t=0,e=0,i=0,r=1){Vector4.prototype.isVector4=!0,this.x=t,this.y=e,this.z=i,this.w=r}get width(){return this.z}set width(t){this.z=t}get height(){return this.w}set height(t){this.w=t}set(t,e,i,r){return this.x=t,this.y=e,this.z=i,this.w=r,this}setScalar(t){return this.x=t,this.y=t,this.z=t,this.w=t,this}setX(t){return this.x=t,this}setY(t){return this.y=t,this}setZ(t){return this.z=t,this}setW(t){return this.w=t,this}setComponent(t,e){switch(t){case 0:this.x=e;break;case 1:this.y=e;break;case 2:this.z=e;break;case 3:this.w=e;break;default:throw new Error("index is out of range: "+t)}return this}getComponent(t){switch(t){case 0:return this.x;case 1:return this.y;case 2:return this.z;case 3:return this.w;default:throw new Error("index is out of range: "+t)}}clone(){return new this.constructor(this.x,this.y,this.z,this.w)}copy(t){return this.x=t.x,this.y=t.y,this.z=t.z,this.w=void 0!==t.w?t.w:1,this}add(t){return this.x+=t.x,this.y+=t.y,this.z+=t.z,this.w+=t.w,this}addScalar(t){return this.x+=t,this.y+=t,this.z+=t,this.w+=t,this}addVectors(t,e){return this.x=t.x+e.x,this.y=t.y+e.y,this.z=t.z+e.z,this.w=t.w+e.w,this}addScaledVector(t,e){return this.x+=t.x*e,this.y+=t.y*e,this.z+=t.z*e,this.w+=t.w*e,this}sub(t){return this.x-=t.x,this.y-=t.y,this.z-=t.z,this.w-=t.w,this}subScalar(t){return this.x-=t,this.y-=t,this.z-=t,this.w-=t,this}subVectors(t,e){return this.x=t.x-e.x,this.y=t.y-e.y,this.z=t.z-e.z,this.w=t.w-e.w,this}multiply(t){return this.x*=t.x,this.y*=t.y,this.z*=t.z,this.w*=t.w,this}multiplyScalar(t){return this.x*=t,this.y*=t,this.z*=t,this.w*=t,this}applyMatrix4(t){const e=this.x,i=this.y,r=this.z,s=this.w,n=t.elements;return this.x=n[0]*e+n[4]*i+n[8]*r+n[12]*s,this.y=n[1]*e+n[5]*i+n[9]*r+n[13]*s,this.z=n[2]*e+n[6]*i+n[10]*r+n[14]*s,this.w=n[3]*e+n[7]*i+n[11]*r+n[15]*s,this}divide(t){return this.x/=t.x,this.y/=t.y,this.z/=t.z,this.w/=t.w,this}divideScalar(t){return this.multiplyScalar(1/t)}setAxisAngleFromQuaternion(t){this.w=2*Math.acos(t.w);const e=Math.sqrt(1-t.w*t.w);return e<1e-4?(this.x=1,this.y=0,this.z=0):(this.x=t.x/e,this.y=t.y/e,this.z=t.z/e),this}setAxisAngleFromRotationMatrix(t){let e,i,r,s;const n=.01,a=.1,o=t.elements,h=o[0],c=o[4],l=o[8],u=o[1],p=o[5],d=o[9],m=o[2],y=o[6],f=o[10];if(Math.abs(c-u)<n&&Math.abs(l-m)<n&&Math.abs(d-y)<n){if(Math.abs(c+u)<a&&Math.abs(l+m)<a&&Math.abs(d+y)<a&&Math.abs(h+p+f-3)<a)return this.set(1,0,0,0),this;e=Math.PI;const t=(h+1)/2,o=(p+1)/2,g=(f+1)/2,x=(c+u)/4,_=(l+m)/4,v=(d+y)/4;return t>o&&t>g?t<n?(i=0,r=.707106781,s=.707106781):(i=Math.sqrt(t),r=x/i,s=_/i):o>g?o<n?(i=.707106781,r=0,s=.707106781):(r=Math.sqrt(o),i=x/r,s=v/r):g<n?(i=.707106781,r=.707106781,s=0):(s=Math.sqrt(g),i=_/s,r=v/s),this.set(i,r,s,e),this}let g=Math.sqrt((y-d)*(y-d)+(l-m)*(l-m)+(u-c)*(u-c));return Math.abs(g)<.001&&(g=1),this.x=(y-d)/g,this.y=(l-m)/g,this.z=(u-c)/g,this.w=Math.acos((h+p+f-1)/2),this}setFromMatrixPosition(t){const e=t.elements;return this.x=e[12],this.y=e[13],this.z=e[14],this.w=e[15],this}min(t){return this.x=Math.min(this.x,t.x),this.y=Math.min(this.y,t.y),this.z=Math.min(this.z,t.z),this.w=Math.min(this.w,t.w),this}max(t){return this.x=Math.max(this.x,t.x),this.y=Math.max(this.y,t.y),this.z=Math.max(this.z,t.z),this.w=Math.max(this.w,t.w),this}clamp(t,e){return this.x=clamp(this.x,t.x,e.x),this.y=clamp(this.y,t.y,e.y),this.z=clamp(this.z,t.z,e.z),this.w=clamp(this.w,t.w,e.w),this}clampScalar(t,e){return this.x=clamp(this.x,t,e),this.y=clamp(this.y,t,e),this.z=clamp(this.z,t,e),this.w=clamp(this.w,t,e),this}clampLength(t,e){const i=this.length();return this.divideScalar(i||1).multiplyScalar(clamp(i,t,e))}floor(){return this.x=Math.floor(this.x),this.y=Math.floor(this.y),this.z=Math.floor(this.z),this.w=Math.floor(this.w),this}ceil(){return this.x=Math.ceil(this.x),this.y=Math.ceil(this.y),this.z=Math.ceil(this.z),this.w=Math.ceil(this.w),this}round(){return this.x=Math.round(this.x),this.y=Math.round(this.y),this.z=Math.round(this.z),this.w=Math.round(this.w),this}roundToZero(){return this.x=Math.trunc(this.x),this.y=Math.trunc(this.y),this.z=Math.trunc(this.z),this.w=Math.trunc(this.w),this}negate(){return this.x=-this.x,this.y=-this.y,this.z=-this.z,this.w=-this.w,this}dot(t){return this.x*t.x+this.y*t.y+this.z*t.z+this.w*t.w}lengthSq(){return this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w}length(){return Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w)}manhattanLength(){return Math.abs(this.x)+Math.abs(this.y)+Math.abs(this.z)+Math.abs(this.w)}normalize(){return this.divideScalar(this.length()||1)}setLength(t){return this.normalize().multiplyScalar(t)}lerp(t,e){return this.x+=(t.x-this.x)*e,this.y+=(t.y-this.y)*e,this.z+=(t.z-this.z)*e,this.w+=(t.w-this.w)*e,this}lerpVectors(t,e,i){return this.x=t.x+(e.x-t.x)*i,this.y=t.y+(e.y-t.y)*i,this.z=t.z+(e.z-t.z)*i,this.w=t.w+(e.w-t.w)*i,this}equals(t){return t.x===this.x&&t.y===this.y&&t.z===this.z&&t.w===this.w}fromArray(t,e=0){return this.x=t[e],this.y=t[e+1],this.z=t[e+2],this.w=t[e+3],this}toArray(t=[],e=0){return t[e]=this.x,t[e+1]=this.y,t[e+2]=this.z,t[e+3]=this.w,t}fromBufferAttribute(t,e){return this.x=t.getX(e),this.y=t.getY(e),this.z=t.getZ(e),this.w=t.getW(e),this}random(){return this.x=Math.random(),this.y=Math.random(),this.z=Math.random(),this.w=Math.random(),this}*[Symbol.iterator](){yield this.x,yield this.y,yield this.z,yield this.w}}class RenderTarget extends EventDispatcher{constructor(t=1,e=1,i={}){super(),this.isRenderTarget=!0,this.width=t,this.height=e,this.depth=i.depth?i.depth:1,this.scissor=new Vector4(0,0,t,e),this.scissorTest=!1,this.viewport=new Vector4(0,0,t,e);const r={width:t,height:e,depth:this.depth};i=Object.assign({generateMipmaps:!1,internalFormat:null,minFilter:1006,depthBuffer:!0,stencilBuffer:!1,resolveDepthBuffer:!0,resolveStencilBuffer:!0,depthTexture:null,samples:0,count:1,multiview:!1},i);const s=new Texture(r,i.mapping,i.wrapS,i.wrapT,i.magFilter,i.minFilter,i.format,i.type,i.anisotropy,i.colorSpace);s.flipY=!1,s.generateMipmaps=i.generateMipmaps,s.internalFormat=i.internalFormat,this.textures=[];const n=i.count;for(let t=0;t<n;t++)this.textures[t]=s.clone(),this.textures[t].isRenderTargetTexture=!0,this.textures[t].renderTarget=this;this.depthBuffer=i.depthBuffer,this.stencilBuffer=i.stencilBuffer,this.resolveDepthBuffer=i.resolveDepthBuffer,this.resolveStencilBuffer=i.resolveStencilBuffer,this._depthTexture=null,this.depthTexture=i.depthTexture,this.samples=i.samples,this.multiview=i.multiview}get texture(){return this.textures[0]}set texture(t){this.textures[0]=t}set depthTexture(t){null!==this._depthTexture&&(this._depthTexture.renderTarget=null),null!==t&&(t.renderTarget=this),this._depthTexture=t}get depthTexture(){return this._depthTexture}setSize(t,e,i=1){if(this.width!==t||this.height!==e||this.depth!==i){this.width=t,this.height=e,this.depth=i;for(let r=0,s=this.textures.length;r<s;r++)this.textures[r].image.width=t,this.textures[r].image.height=e,this.textures[r].image.depth=i;this.dispose()}this.viewport.set(0,0,t,e),this.scissor.set(0,0,t,e)}clone(){return(new this.constructor).copy(this)}copy(t){this.width=t.width,this.height=t.height,this.depth=t.depth,this.scissor.copy(t.scissor),this.scissorTest=t.scissorTest,this.viewport.copy(t.viewport),this.textures.length=0;for(let e=0,i=t.textures.length;e<i;e++){this.textures[e]=t.textures[e].clone(),this.textures[e].isRenderTargetTexture=!0,this.textures[e].renderTarget=this;const i=Object.assign({},t.textures[e].image);this.textures[e].source=new Source(i)}return this.depthBuffer=t.depthBuffer,this.stencilBuffer=t.stencilBuffer,this.resolveDepthBuffer=t.resolveDepthBuffer,this.resolveStencilBuffer=t.resolveStencilBuffer,null!==t.depthTexture&&(this.depthTexture=t.depthTexture.clone()),this.samples=t.samples,this}dispose(){this.dispatchEvent({type:"dispose"})}}class WebGLRenderTarget extends RenderTarget{constructor(t=1,e=1,i={}){super(t,e,i),this.isWebGLRenderTarget=!0}}class DataArrayTexture extends Texture{constructor(t=null,e=1,i=1,r=1){super(null),this.isDataArrayTexture=!0,this.image={data:t,width:e,height:i,depth:r},this.magFilter=1003,this.minFilter=1003,this.wrapR=1001,this.generateMipmaps=!1,this.flipY=!1,this.unpackAlignment=1,this.layerUpdates=new Set}addLayerUpdate(t){this.layerUpdates.add(t)}clearLayerUpdates(){this.layerUpdates.clear()}}class WebGLArrayRenderTarget extends WebGLRenderTarget{constructor(t=1,e=1,i=1,r={}){super(t,e,r),this.isWebGLArrayRenderTarget=!0,this.depth=i,this.texture=new DataArrayTexture(null,t,e,i),this.texture.isRenderTargetTexture=!0}}class Data3DTexture extends Texture{constructor(t=null,e=1,i=1,r=1){super(null),this.isData3DTexture=!0,this.image={data:t,width:e,height:i,depth:r},this.magFilter=1003,this.minFilter=1003,this.wrapR=1001,this.generateMipmaps=!1,this.flipY=!1,this.unpackAlignment=1}}class WebGL3DRenderTarget extends WebGLRenderTarget{constructor(t=1,e=1,i=1,r={}){super(t,e,r),this.isWebGL3DRenderTarget=!0,this.depth=i,this.texture=new Data3DTexture(null,t,e,i),this.texture.isRenderTargetTexture=!0}}class Quaternion{constructor(t=0,e=0,i=0,r=1){this.isQuaternion=!0,this._x=t,this._y=e,this._z=i,this._w=r}static slerpFlat(t,e,i,r,s,n,a){let o=i[r+0],h=i[r+1],c=i[r+2],l=i[r+3];const u=s[n+0],p=s[n+1],d=s[n+2],m=s[n+3];if(0===a)return t[e+0]=o,t[e+1]=h,t[e+2]=c,void(t[e+3]=l);if(1===a)return t[e+0]=u,t[e+1]=p,t[e+2]=d,void(t[e+3]=m);if(l!==m||o!==u||h!==p||c!==d){let t=1-a;const e=o*u+h*p+c*d+l*m,i=e>=0?1:-1,r=1-e*e;if(r>Number.EPSILON){const s=Math.sqrt(r),n=Math.atan2(s,e*i);t=Math.sin(t*n)/s,a=Math.sin(a*n)/s}const s=a*i;if(o=o*t+u*s,h=h*t+p*s,c=c*t+d*s,l=l*t+m*s,t===1-a){const t=1/Math.sqrt(o*o+h*h+c*c+l*l);o*=t,h*=t,c*=t,l*=t}}t[e]=o,t[e+1]=h,t[e+2]=c,t[e+3]=l}static multiplyQuaternionsFlat(t,e,i,r,s,n){const a=i[r],o=i[r+1],h=i[r+2],c=i[r+3],l=s[n],u=s[n+1],p=s[n+2],d=s[n+3];return t[e]=a*d+c*l+o*p-h*u,t[e+1]=o*d+c*u+h*l-a*p,t[e+2]=h*d+c*p+a*u-o*l,t[e+3]=c*d-a*l-o*u-h*p,t}get x(){return this._x}set x(t){this._x=t,this._onChangeCallback()}get y(){return this._y}set y(t){this._y=t,this._onChangeCallback()}get z(){return this._z}set z(t){this._z=t,this._onChangeCallback()}get w(){return this._w}set w(t){this._w=t,this._onChangeCallback()}set(t,e,i,r){return this._x=t,this._y=e,this._z=i,this._w=r,this._onChangeCallback(),this}clone(){return new this.constructor(this._x,this._y,this._z,this._w)}copy(t){return this._x=t.x,this._y=t.y,this._z=t.z,this._w=t.w,this._onChangeCallback(),this}setFromEuler(t,e=!0){const i=t._x,r=t._y,s=t._z,n=t._order,a=Math.cos,o=Math.sin,h=a(i/2),c=a(r/2),l=a(s/2),u=o(i/2),p=o(r/2),d=o(s/2);switch(n){case"XYZ":this._x=u*c*l+h*p*d,this._y=h*p*l-u*c*d,this._z=h*c*d+u*p*l,this._w=h*c*l-u*p*d;break;case"YXZ":this._x=u*c*l+h*p*d,this._y=h*p*l-u*c*d,this._z=h*c*d-u*p*l,this._w=h*c*l+u*p*d;break;case"ZXY":this._x=u*c*l-h*p*d,this._y=h*p*l+u*c*d,this._z=h*c*d+u*p*l,this._w=h*c*l-u*p*d;break;case"ZYX":this._x=u*c*l-h*p*d,this._y=h*p*l+u*c*d,this._z=h*c*d-u*p*l,this._w=h*c*l+u*p*d;break;case"YZX":this._x=u*c*l+h*p*d,this._y=h*p*l+u*c*d,this._z=h*c*d-u*p*l,this._w=h*c*l-u*p*d;break;case"XZY":this._x=u*c*l-h*p*d,this._y=h*p*l-u*c*d,this._z=h*c*d+u*p*l,this._w=h*c*l+u*p*d;break;default:console.warn("THREE.Quaternion: .setFromEuler() encountered an unknown order: "+n)}return!0===e&&this._onChangeCallback(),this}setFromAxisAngle(t,e){const i=e/2,r=Math.sin(i);return this._x=t.x*r,this._y=t.y*r,this._z=t.z*r,this._w=Math.cos(i),this._onChangeCallback(),this}setFromRotationMatrix(t){const e=t.elements,i=e[0],r=e[4],s=e[8],n=e[1],a=e[5],o=e[9],h=e[2],c=e[6],l=e[10],u=i+a+l;if(u>0){const t=.5/Math.sqrt(u+1);this._w=.25/t,this._x=(c-o)*t,this._y=(s-h)*t,this._z=(n-r)*t}else if(i>a&&i>l){const t=2*Math.sqrt(1+i-a-l);this._w=(c-o)/t,this._x=.25*t,this._y=(r+n)/t,this._z=(s+h)/t}else if(a>l){const t=2*Math.sqrt(1+a-i-l);this._w=(s-h)/t,this._x=(r+n)/t,this._y=.25*t,this._z=(o+c)/t}else{const t=2*Math.sqrt(1+l-i-a);this._w=(n-r)/t,this._x=(s+h)/t,this._y=(o+c)/t,this._z=.25*t}return this._onChangeCallback(),this}setFromUnitVectors(t,e){let i=t.dot(e)+1;return i<Number.EPSILON?(i=0,Math.abs(t.x)>Math.abs(t.z)?(this._x=-t.y,this._y=t.x,this._z=0,this._w=i):(this._x=0,this._y=-t.z,this._z=t.y,this._w=i)):(this._x=t.y*e.z-t.z*e.y,this._y=t.z*e.x-t.x*e.z,this._z=t.x*e.y-t.y*e.x,this._w=i),this.normalize()}angleTo(t){return 2*Math.acos(Math.abs(clamp(this.dot(t),-1,1)))}rotateTowards(t,e){const i=this.angleTo(t);if(0===i)return this;const r=Math.min(1,e/i);return this.slerp(t,r),this}identity(){return this.set(0,0,0,1)}invert(){return this.conjugate()}conjugate(){return this._x*=-1,this._y*=-1,this._z*=-1,this._onChangeCallback(),this}dot(t){return this._x*t._x+this._y*t._y+this._z*t._z+this._w*t._w}lengthSq(){return this._x*this._x+this._y*this._y+this._z*this._z+this._w*this._w}length(){return Math.sqrt(this._x*this._x+this._y*this._y+this._z*this._z+this._w*this._w)}normalize(){let t=this.length();return 0===t?(this._x=0,this._y=0,this._z=0,this._w=1):(t=1/t,this._x=this._x*t,this._y=this._y*t,this._z=this._z*t,this._w=this._w*t),this._onChangeCallback(),this}multiply(t){return this.multiplyQuaternions(this,t)}premultiply(t){return this.multiplyQuaternions(t,this)}multiplyQuaternions(t,e){const i=t._x,r=t._y,s=t._z,n=t._w,a=e._x,o=e._y,h=e._z,c=e._w;return this._x=i*c+n*a+r*h-s*o,this._y=r*c+n*o+s*a-i*h,this._z=s*c+n*h+i*o-r*a,this._w=n*c-i*a-r*o-s*h,this._onChangeCallback(),this}slerp(t,e){if(0===e)return this;if(1===e)return this.copy(t);const i=this._x,r=this._y,s=this._z,n=this._w;let a=n*t._w+i*t._x+r*t._y+s*t._z;if(a<0?(this._w=-t._w,this._x=-t._x,this._y=-t._y,this._z=-t._z,a=-a):this.copy(t),a>=1)return this._w=n,this._x=i,this._y=r,this._z=s,this;const o=1-a*a;if(o<=Number.EPSILON){const t=1-e;return this._w=t*n+e*this._w,this._x=t*i+e*this._x,this._y=t*r+e*this._y,this._z=t*s+e*this._z,this.normalize(),this}const h=Math.sqrt(o),c=Math.atan2(h,a),l=Math.sin((1-e)*c)/h,u=Math.sin(e*c)/h;return this._w=n*l+this._w*u,this._x=i*l+this._x*u,this._y=r*l+this._y*u,this._z=s*l+this._z*u,this._onChangeCallback(),this}slerpQuaternions(t,e,i){return this.copy(t).slerp(e,i)}random(){const t=2*Math.PI*Math.random(),e=2*Math.PI*Math.random(),i=Math.random(),r=Math.sqrt(1-i),s=Math.sqrt(i);return this.set(r*Math.sin(t),r*Math.cos(t),s*Math.sin(e),s*Math.cos(e))}equals(t){return t._x===this._x&&t._y===this._y&&t._z===this._z&&t._w===this._w}fromArray(t,e=0){return this._x=t[e],this._y=t[e+1],this._z=t[e+2],this._w=t[e+3],this._onChangeCallback(),this}toArray(t=[],e=0){return t[e]=this._x,t[e+1]=this._y,t[e+2]=this._z,t[e+3]=this._w,t}fromBufferAttribute(t,e){return this._x=t.getX(e),this._y=t.getY(e),this._z=t.getZ(e),this._w=t.getW(e),this._onChangeCallback(),this}toJSON(){return this.toArray()}_onChange(t){return this._onChangeCallback=t,this}_onChangeCallback(){}*[Symbol.iterator](){yield this._x,yield this._y,yield this._z,yield this._w}}class Vector3{constructor(t=0,e=0,i=0){Vector3.prototype.isVector3=!0,this.x=t,this.y=e,this.z=i}set(t,e,i){return void 0===i&&(i=this.z),this.x=t,this.y=e,this.z=i,this}setScalar(t){return this.x=t,this.y=t,this.z=t,this}setX(t){return this.x=t,this}setY(t){return this.y=t,this}setZ(t){return this.z=t,this}setComponent(t,e){switch(t){case 0:this.x=e;break;case 1:this.y=e;break;case 2:this.z=e;break;default:throw new Error("index is out of range: "+t)}return this}getComponent(t){switch(t){case 0:return this.x;case 1:return this.y;case 2:return this.z;default:throw new Error("index is out of range: "+t)}}clone(){return new this.constructor(this.x,this.y,this.z)}copy(t){return this.x=t.x,this.y=t.y,this.z=t.z,this}add(t){return this.x+=t.x,this.y+=t.y,this.z+=t.z,this}addScalar(t){return this.x+=t,this.y+=t,this.z+=t,this}addVectors(t,e){return this.x=t.x+e.x,this.y=t.y+e.y,this.z=t.z+e.z,this}addScaledVector(t,e){return this.x+=t.x*e,this.y+=t.y*e,this.z+=t.z*e,this}sub(t){return this.x-=t.x,this.y-=t.y,this.z-=t.z,this}subScalar(t){return this.x-=t,this.y-=t,this.z-=t,this}subVectors(t,e){return this.x=t.x-e.x,this.y=t.y-e.y,this.z=t.z-e.z,this}multiply(t){return this.x*=t.x,this.y*=t.y,this.z*=t.z,this}multiplyScalar(t){return this.x*=t,this.y*=t,this.z*=t,this}multiplyVectors(t,e){return this.x=t.x*e.x,this.y=t.y*e.y,this.z=t.z*e.z,this}applyEuler(t){return this.applyQuaternion(_quaternion$4.setFromEuler(t))}applyAxisAngle(t,e){return this.applyQuaternion(_quaternion$4.setFromAxisAngle(t,e))}applyMatrix3(t){const e=this.x,i=this.y,r=this.z,s=t.elements;return this.x=s[0]*e+s[3]*i+s[6]*r,this.y=s[1]*e+s[4]*i+s[7]*r,this.z=s[2]*e+s[5]*i+s[8]*r,this}applyNormalMatrix(t){return this.applyMatrix3(t).normalize()}applyMatrix4(t){const e=this.x,i=this.y,r=this.z,s=t.elements,n=1/(s[3]*e+s[7]*i+s[11]*r+s[15]);return this.x=(s[0]*e+s[4]*i+s[8]*r+s[12])*n,this.y=(s[1]*e+s[5]*i+s[9]*r+s[13])*n,this.z=(s[2]*e+s[6]*i+s[10]*r+s[14])*n,this}applyQuaternion(t){const e=this.x,i=this.y,r=this.z,s=t.x,n=t.y,a=t.z,o=t.w,h=2*(n*r-a*i),c=2*(a*e-s*r),l=2*(s*i-n*e);return this.x=e+o*h+n*l-a*c,this.y=i+o*c+a*h-s*l,this.z=r+o*l+s*c-n*h,this}project(t){return this.applyMatrix4(t.matrixWorldInverse).applyMatrix4(t.projectionMatrix)}unproject(t){return this.applyMatrix4(t.projectionMatrixInverse).applyMatrix4(t.matrixWorld)}transformDirection(t){const e=this.x,i=this.y,r=this.z,s=t.elements;return this.x=s[0]*e+s[4]*i+s[8]*r,this.y=s[1]*e+s[5]*i+s[9]*r,this.z=s[2]*e+s[6]*i+s[10]*r,this.normalize()}divide(t){return this.x/=t.x,this.y/=t.y,this.z/=t.z,this}divideScalar(t){return this.multiplyScalar(1/t)}min(t){return this.x=Math.min(this.x,t.x),this.y=Math.min(this.y,t.y),this.z=Math.min(this.z,t.z),this}max(t){return this.x=Math.max(this.x,t.x),this.y=Math.max(this.y,t.y),this.z=Math.max(this.z,t.z),this}clamp(t,e){return this.x=clamp(this.x,t.x,e.x),this.y=clamp(this.y,t.y,e.y),this.z=clamp(this.z,t.z,e.z),this}clampScalar(t,e){return this.x=clamp(this.x,t,e),this.y=clamp(this.y,t,e),this.z=clamp(this.z,t,e),this}clampLength(t,e){const i=this.length();return this.divideScalar(i||1).multiplyScalar(clamp(i,t,e))}floor(){return this.x=Math.floor(this.x),this.y=Math.floor(this.y),this.z=Math.floor(this.z),this}ceil(){return this.x=Math.ceil(this.x),this.y=Math.ceil(this.y),this.z=Math.ceil(this.z),this}round(){return this.x=Math.round(this.x),this.y=Math.round(this.y),this.z=Math.round(this.z),this}roundToZero(){return this.x=Math.trunc(this.x),this.y=Math.trunc(this.y),this.z=Math.trunc(this.z),this}negate(){return this.x=-this.x,this.y=-this.y,this.z=-this.z,this}dot(t){return this.x*t.x+this.y*t.y+this.z*t.z}lengthSq(){return this.x*this.x+this.y*this.y+this.z*this.z}length(){return Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z)}manhattanLength(){return Math.abs(this.x)+Math.abs(this.y)+Math.abs(this.z)}normalize(){return this.divideScalar(this.length()||1)}setLength(t){return this.normalize().multiplyScalar(t)}lerp(t,e){return this.x+=(t.x-this.x)*e,this.y+=(t.y-this.y)*e,this.z+=(t.z-this.z)*e,this}lerpVectors(t,e,i){return this.x=t.x+(e.x-t.x)*i,this.y=t.y+(e.y-t.y)*i,this.z=t.z+(e.z-t.z)*i,this}cross(t){return this.crossVectors(this,t)}crossVectors(t,e){const i=t.x,r=t.y,s=t.z,n=e.x,a=e.y,o=e.z;return this.x=r*o-s*a,this.y=s*n-i*o,this.z=i*a-r*n,this}projectOnVector(t){const e=t.lengthSq();if(0===e)return this.set(0,0,0);const i=t.dot(this)/e;return this.copy(t).multiplyScalar(i)}projectOnPlane(t){return _vector$c.copy(this).projectOnVector(t),this.sub(_vector$c)}reflect(t){return this.sub(_vector$c.copy(t).multiplyScalar(2*this.dot(t)))}angleTo(t){const e=Math.sqrt(this.lengthSq()*t.lengthSq());if(0===e)return Math.PI/2;const i=this.dot(t)/e;return Math.acos(clamp(i,-1,1))}distanceTo(t){return Math.sqrt(this.distanceToSquared(t))}distanceToSquared(t){const e=this.x-t.x,i=this.y-t.y,r=this.z-t.z;return e*e+i*i+r*r}manhattanDistanceTo(t){return Math.abs(this.x-t.x)+Math.abs(this.y-t.y)+Math.abs(this.z-t.z)}setFromSpherical(t){return this.setFromSphericalCoords(t.radius,t.phi,t.theta)}setFromSphericalCoords(t,e,i){const r=Math.sin(e)*t;return this.x=r*Math.sin(i),this.y=Math.cos(e)*t,this.z=r*Math.cos(i),this}setFromCylindrical(t){return this.setFromCylindricalCoords(t.radius,t.theta,t.y)}setFromCylindricalCoords(t,e,i){return this.x=t*Math.sin(e),this.y=i,this.z=t*Math.cos(e),this}setFromMatrixPosition(t){const e=t.elements;return this.x=e[12],this.y=e[13],this.z=e[14],this}setFromMatrixScale(t){const e=this.setFromMatrixColumn(t,0).length(),i=this.setFromMatrixColumn(t,1).length(),r=this.setFromMatrixColumn(t,2).length();return this.x=e,this.y=i,this.z=r,this}setFromMatrixColumn(t,e){return this.fromArray(t.elements,4*e)}setFromMatrix3Column(t,e){return this.fromArray(t.elements,3*e)}setFromEuler(t){return this.x=t._x,this.y=t._y,this.z=t._z,this}setFromColor(t){return this.x=t.r,this.y=t.g,this.z=t.b,this}equals(t){return t.x===this.x&&t.y===this.y&&t.z===this.z}fromArray(t,e=0){return this.x=t[e],this.y=t[e+1],this.z=t[e+2],this}toArray(t=[],e=0){return t[e]=this.x,t[e+1]=this.y,t[e+2]=this.z,t}fromBufferAttribute(t,e){return this.x=t.getX(e),this.y=t.getY(e),this.z=t.getZ(e),this}random(){return this.x=Math.random(),this.y=Math.random(),this.z=Math.random(),this}randomDirection(){const t=Math.random()*Math.PI*2,e=2*Math.random()-1,i=Math.sqrt(1-e*e);return this.x=i*Math.cos(t),this.y=e,this.z=i*Math.sin(t),this}*[Symbol.iterator](){yield this.x,yield this.y,yield this.z}}const _vector$c=new Vector3,_quaternion$4=new Quaternion;class Box3{constructor(t=new Vector3(1/0,1/0,1/0),e=new Vector3(-1/0,-1/0,-1/0)){this.isBox3=!0,this.min=t,this.max=e}set(t,e){return this.min.copy(t),this.max.copy(e),this}setFromArray(t){this.makeEmpty();for(let e=0,i=t.length;e<i;e+=3)this.expandByPoint(_vector$b.fromArray(t,e));return this}setFromBufferAttribute(t){this.makeEmpty();for(let e=0,i=t.count;e<i;e++)this.expandByPoint(_vector$b.fromBufferAttribute(t,e));return this}setFromPoints(t){this.makeEmpty();for(let e=0,i=t.length;e<i;e++)this.expandByPoint(t[e]);return this}setFromCenterAndSize(t,e){const i=_vector$b.copy(e).multiplyScalar(.5);return this.min.copy(t).sub(i),this.max.copy(t).add(i),this}setFromObject(t,e=!1){return this.makeEmpty(),this.expandByObject(t,e)}clone(){return(new this.constructor).copy(this)}copy(t){return this.min.copy(t.min),this.max.copy(t.max),this}makeEmpty(){return this.min.x=this.min.y=this.min.z=1/0,this.max.x=this.max.y=this.max.z=-1/0,this}isEmpty(){return this.max.x<this.min.x||this.max.y<this.min.y||this.max.z<this.min.z}getCenter(t){return this.isEmpty()?t.set(0,0,0):t.addVectors(this.min,this.max).multiplyScalar(.5)}getSize(t){return this.isEmpty()?t.set(0,0,0):t.subVectors(this.max,this.min)}expandByPoint(t){return this.min.min(t),this.max.max(t),this}expandByVector(t){return this.min.sub(t),this.max.add(t),this}expandByScalar(t){return this.min.addScalar(-t),this.max.addScalar(t),this}expandByObject(t,e=!1){t.updateWorldMatrix(!1,!1);const i=t.geometry;if(void 0!==i){const r=i.getAttribute("position");if(!0===e&&void 0!==r&&!0!==t.isInstancedMesh)for(let e=0,i=r.count;e<i;e++)!0===t.isMesh?t.getVertexPosition(e,_vector$b):_vector$b.fromBufferAttribute(r,e),_vector$b.applyMatrix4(t.matrixWorld),this.expandByPoint(_vector$b);else void 0!==t.boundingBox?(null===t.boundingBox&&t.computeBoundingBox(),_box$4.copy(t.boundingBox)):(null===i.boundingBox&&i.computeBoundingBox(),_box$4.copy(i.boundingBox)),_box$4.applyMatrix4(t.matrixWorld),this.union(_box$4)}const r=t.children;for(let t=0,i=r.length;t<i;t++)this.expandByObject(r[t],e);return this}containsPoint(t){return t.x>=this.min.x&&t.x<=this.max.x&&t.y>=this.min.y&&t.y<=this.max.y&&t.z>=this.min.z&&t.z<=this.max.z}containsBox(t){return this.min.x<=t.min.x&&t.max.x<=this.max.x&&this.min.y<=t.min.y&&t.max.y<=this.max.y&&this.min.z<=t.min.z&&t.max.z<=this.max.z}getParameter(t,e){return e.set((t.x-this.min.x)/(this.max.x-this.min.x),(t.y-this.min.y)/(this.max.y-this.min.y),(t.z-this.min.z)/(this.max.z-this.min.z))}intersectsBox(t){return t.max.x>=this.min.x&&t.min.x<=this.max.x&&t.max.y>=this.min.y&&t.min.y<=this.max.y&&t.max.z>=this.min.z&&t.min.z<=this.max.z}intersectsSphere(t){return this.clampPoint(t.center,_vector$b),_vector$b.distanceToSquared(t.center)<=t.radius*t.radius}intersectsPlane(t){let e,i;return t.normal.x>0?(e=t.normal.x*this.min.x,i=t.normal.x*this.max.x):(e=t.normal.x*this.max.x,i=t.normal.x*this.min.x),t.normal.y>0?(e+=t.normal.y*this.min.y,i+=t.normal.y*this.max.y):(e+=t.normal.y*this.max.y,i+=t.normal.y*this.min.y),t.normal.z>0?(e+=t.normal.z*this.min.z,i+=t.normal.z*this.max.z):(e+=t.normal.z*this.max.z,i+=t.normal.z*this.min.z),e<=-t.constant&&i>=-t.constant}intersectsTriangle(t){if(this.isEmpty())return!1;this.getCenter(_center),_extents.subVectors(this.max,_center),_v0$2.subVectors(t.a,_center),_v1$7.subVectors(t.b,_center),_v2$4.subVectors(t.c,_center),_f0.subVectors(_v1$7,_v0$2),_f1.subVectors(_v2$4,_v1$7),_f2.subVectors(_v0$2,_v2$4);let e=[0,-_f0.z,_f0.y,0,-_f1.z,_f1.y,0,-_f2.z,_f2.y,_f0.z,0,-_f0.x,_f1.z,0,-_f1.x,_f2.z,0,-_f2.x,-_f0.y,_f0.x,0,-_f1.y,_f1.x,0,-_f2.y,_f2.x,0];return!!satForAxes(e,_v0$2,_v1$7,_v2$4,_extents)&&(e=[1,0,0,0,1,0,0,0,1],!!satForAxes(e,_v0$2,_v1$7,_v2$4,_extents)&&(_triangleNormal.crossVectors(_f0,_f1),e=[_triangleNormal.x,_triangleNormal.y,_triangleNormal.z],satForAxes(e,_v0$2,_v1$7,_v2$4,_extents)))}clampPoint(t,e){return e.copy(t).clamp(this.min,this.max)}distanceToPoint(t){return this.clampPoint(t,_vector$b).distanceTo(t)}getBoundingSphere(t){return this.isEmpty()?t.makeEmpty():(this.getCenter(t.center),t.radius=.5*this.getSize(_vector$b).length()),t}intersect(t){return this.min.max(t.min),this.max.min(t.max),this.isEmpty()&&this.makeEmpty(),this}union(t){return this.min.min(t.min),this.max.max(t.max),this}applyMatrix4(t){return this.isEmpty()||(_points[0].set(this.min.x,this.min.y,this.min.z).applyMatrix4(t),_points[1].set(this.min.x,this.min.y,this.max.z).applyMatrix4(t),_points[2].set(this.min.x,this.max.y,this.min.z).applyMatrix4(t),_points[3].set(this.min.x,this.max.y,this.max.z).applyMatrix4(t),_points[4].set(this.max.x,this.min.y,this.min.z).applyMatrix4(t),_points[5].set(this.max.x,this.min.y,this.max.z).applyMatrix4(t),_points[6].set(this.max.x,this.max.y,this.min.z).applyMatrix4(t),_points[7].set(this.max.x,this.max.y,this.max.z).applyMatrix4(t),this.setFromPoints(_points)),this}translate(t){return this.min.add(t),this.max.add(t),this}equals(t){return t.min.equals(this.min)&&t.max.equals(this.max)}}const _points=[new Vector3,new Vector3,new Vector3,new Vector3,new Vector3,new Vector3,new Vector3,new Vector3],_vector$b=new Vector3,_box$4=new Box3,_v0$2=new Vector3,_v1$7=new Vector3,_v2$4=new Vector3,_f0=new Vector3,_f1=new Vector3,_f2=new Vector3,_center=new Vector3,_extents=new Vector3,_triangleNormal=new Vector3,_testAxis=new Vector3;function satForAxes(t,e,i,r,s){for(let n=0,a=t.length-3;n<=a;n+=3){_testAxis.fromArray(t,n);const a=s.x*Math.abs(_testAxis.x)+s.y*Math.abs(_testAxis.y)+s.z*Math.abs(_testAxis.z),o=e.dot(_testAxis),h=i.dot(_testAxis),c=r.dot(_testAxis);if(Math.max(-Math.max(o,h,c),Math.min(o,h,c))>a)return!1}return!0}const _box$3=new Box3,_v1$6=new Vector3,_v2$3=new Vector3;class Sphere{constructor(t=new Vector3,e=-1){this.isSphere=!0,this.center=t,this.radius=e}set(t,e){return this.center.copy(t),this.radius=e,this}setFromPoints(t,e){const i=this.center;void 0!==e?i.copy(e):_box$3.setFromPoints(t).getCenter(i);let r=0;for(let e=0,s=t.length;e<s;e++)r=Math.max(r,i.distanceToSquared(t[e]));return this.radius=Math.sqrt(r),this}copy(t){return this.center.copy(t.center),this.radius=t.radius,this}isEmpty(){return this.radius<0}makeEmpty(){return this.center.set(0,0,0),this.radius=-1,this}containsPoint(t){return t.distanceToSquared(this.center)<=this.radius*this.radius}distanceToPoint(t){return t.distanceTo(this.center)-this.radius}intersectsSphere(t){const e=this.radius+t.radius;return t.center.distanceToSquared(this.center)<=e*e}intersectsBox(t){return t.intersectsSphere(this)}intersectsPlane(t){return Math.abs(t.distanceToPoint(this.center))<=this.radius}clampPoint(t,e){const i=this.center.distanceToSquared(t);return e.copy(t),i>this.radius*this.radius&&(e.sub(this.center).normalize(),e.multiplyScalar(this.radius).add(this.center)),e}getBoundingBox(t){return this.isEmpty()?(t.makeEmpty(),t):(t.set(this.center,this.center),t.expandByScalar(this.radius),t)}applyMatrix4(t){return this.center.applyMatrix4(t),this.radius=this.radius*t.getMaxScaleOnAxis(),this}translate(t){return this.center.add(t),this}expandByPoint(t){if(this.isEmpty())return this.center.copy(t),this.radius=0,this;_v1$6.subVectors(t,this.center);const e=_v1$6.lengthSq();if(e>this.radius*this.radius){const t=Math.sqrt(e),i=.5*(t-this.radius);this.center.addScaledVector(_v1$6,i/t),this.radius+=i}return this}union(t){return t.isEmpty()?this:this.isEmpty()?(this.copy(t),this):(!0===this.center.equals(t.center)?this.radius=Math.max(this.radius,t.radius):(_v2$3.subVectors(t.center,this.center).setLength(t.radius),this.expandByPoint(_v1$6.copy(t.center).add(_v2$3)),this.expandByPoint(_v1$6.copy(t.center).sub(_v2$3))),this)}equals(t){return t.center.equals(this.center)&&t.radius===this.radius}clone(){return(new this.constructor).copy(this)}}const _vector$a=new Vector3,_segCenter=new Vector3,_segDir=new Vector3,_diff=new Vector3,_edge1=new Vector3,_edge2=new Vector3,_normal$1=new Vector3;class Ray{constructor(t=new Vector3,e=new Vector3(0,0,-1)){this.origin=t,this.direction=e}set(t,e){return this.origin.copy(t),this.direction.copy(e),this}copy(t){return this.origin.copy(t.origin),this.direction.copy(t.direction),this}at(t,e){return e.copy(this.origin).addScaledVector(this.direction,t)}lookAt(t){return this.direction.copy(t).sub(this.origin).normalize(),this}recast(t){return this.origin.copy(this.at(t,_vector$a)),this}closestPointToPoint(t,e){e.subVectors(t,this.origin);const i=e.dot(this.direction);return i<0?e.copy(this.origin):e.copy(this.origin).addScaledVector(this.direction,i)}distanceToPoint(t){return Math.sqrt(this.distanceSqToPoint(t))}distanceSqToPoint(t){const e=_vector$a.subVectors(t,this.origin).dot(this.direction);return e<0?this.origin.distanceToSquared(t):(_vector$a.copy(this.origin).addScaledVector(this.direction,e),_vector$a.distanceToSquared(t))}distanceSqToSegment(t,e,i,r){_segCenter.copy(t).add(e).multiplyScalar(.5),_segDir.copy(e).sub(t).normalize(),_diff.copy(this.origin).sub(_segCenter);const s=.5*t.distanceTo(e),n=-this.direction.dot(_segDir),a=_diff.dot(this.direction),o=-_diff.dot(_segDir),h=_diff.lengthSq(),c=Math.abs(1-n*n);let l,u,p,d;if(c>0)if(l=n*o-a,u=n*a-o,d=s*c,l>=0)if(u>=-d)if(u<=d){const t=1/c;l*=t,u*=t,p=l*(l+n*u+2*a)+u*(n*l+u+2*o)+h}else u=s,l=Math.max(0,-(n*u+a)),p=-l*l+u*(u+2*o)+h;else u=-s,l=Math.max(0,-(n*u+a)),p=-l*l+u*(u+2*o)+h;else u<=-d?(l=Math.max(0,-(-n*s+a)),u=l>0?-s:Math.min(Math.max(-s,-o),s),p=-l*l+u*(u+2*o)+h):u<=d?(l=0,u=Math.min(Math.max(-s,-o),s),p=u*(u+2*o)+h):(l=Math.max(0,-(n*s+a)),u=l>0?s:Math.min(Math.max(-s,-o),s),p=-l*l+u*(u+2*o)+h);else u=n>0?-s:s,l=Math.max(0,-(n*u+a)),p=-l*l+u*(u+2*o)+h;return i&&i.copy(this.origin).addScaledVector(this.direction,l),r&&r.copy(_segCenter).addScaledVector(_segDir,u),p}intersectSphere(t,e){_vector$a.subVectors(t.center,this.origin);const i=_vector$a.dot(this.direction),r=_vector$a.dot(_vector$a)-i*i,s=t.radius*t.radius;if(r>s)return null;const n=Math.sqrt(s-r),a=i-n,o=i+n;return o<0?null:a<0?this.at(o,e):this.at(a,e)}intersectsSphere(t){return this.distanceSqToPoint(t.center)<=t.radius*t.radius}distanceToPlane(t){const e=t.normal.dot(this.direction);if(0===e)return 0===t.distanceToPoint(this.origin)?0:null;const i=-(this.origin.dot(t.normal)+t.constant)/e;return i>=0?i:null}intersectPlane(t,e){const i=this.distanceToPlane(t);return null===i?null:this.at(i,e)}intersectsPlane(t){const e=t.distanceToPoint(this.origin);if(0===e)return!0;return t.normal.dot(this.direction)*e<0}intersectBox(t,e){let i,r,s,n,a,o;const h=1/this.direction.x,c=1/this.direction.y,l=1/this.direction.z,u=this.origin;return h>=0?(i=(t.min.x-u.x)*h,r=(t.max.x-u.x)*h):(i=(t.max.x-u.x)*h,r=(t.min.x-u.x)*h),c>=0?(s=(t.min.y-u.y)*c,n=(t.max.y-u.y)*c):(s=(t.max.y-u.y)*c,n=(t.min.y-u.y)*c),i>n||s>r?null:((s>i||isNaN(i))&&(i=s),(n<r||isNaN(r))&&(r=n),l>=0?(a=(t.min.z-u.z)*l,o=(t.max.z-u.z)*l):(a=(t.max.z-u.z)*l,o=(t.min.z-u.z)*l),i>o||a>r?null:((a>i||i!=i)&&(i=a),(o<r||r!=r)&&(r=o),r<0?null:this.at(i>=0?i:r,e)))}intersectsBox(t){return null!==this.intersectBox(t,_vector$a)}intersectTriangle(t,e,i,r,s){_edge1.subVectors(e,t),_edge2.subVectors(i,t),_normal$1.crossVectors(_edge1,_edge2);let n,a=this.direction.dot(_normal$1);if(a>0){if(r)return null;n=1}else{if(!(a<0))return null;n=-1,a=-a}_diff.subVectors(this.origin,t);const o=n*this.direction.dot(_edge2.crossVectors(_diff,_edge2));if(o<0)return null;const h=n*this.direction.dot(_edge1.cross(_diff));if(h<0)return null;if(o+h>a)return null;const c=-n*_diff.dot(_normal$1);return c<0?null:this.at(c/a,s)}applyMatrix4(t){return this.origin.applyMatrix4(t),this.direction.transformDirection(t),this}equals(t){return t.origin.equals(this.origin)&&t.direction.equals(this.direction)}clone(){return(new this.constructor).copy(this)}}class Matrix4{constructor(t,e,i,r,s,n,a,o,h,c,l,u,p,d,m,y){Matrix4.prototype.isMatrix4=!0,this.elements=[1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1],void 0!==t&&this.set(t,e,i,r,s,n,a,o,h,c,l,u,p,d,m,y)}set(t,e,i,r,s,n,a,o,h,c,l,u,p,d,m,y){const f=this.elements;return f[0]=t,f[4]=e,f[8]=i,f[12]=r,f[1]=s,f[5]=n,f[9]=a,f[13]=o,f[2]=h,f[6]=c,f[10]=l,f[14]=u,f[3]=p,f[7]=d,f[11]=m,f[15]=y,this}identity(){return this.set(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1),this}clone(){return(new Matrix4).fromArray(this.elements)}copy(t){const e=this.elements,i=t.elements;return e[0]=i[0],e[1]=i[1],e[2]=i[2],e[3]=i[3],e[4]=i[4],e[5]=i[5],e[6]=i[6],e[7]=i[7],e[8]=i[8],e[9]=i[9],e[10]=i[10],e[11]=i[11],e[12]=i[12],e[13]=i[13],e[14]=i[14],e[15]=i[15],this}copyPosition(t){const e=this.elements,i=t.elements;return e[12]=i[12],e[13]=i[13],e[14]=i[14],this}setFromMatrix3(t){const e=t.elements;return this.set(e[0],e[3],e[6],0,e[1],e[4],e[7],0,e[2],e[5],e[8],0,0,0,0,1),this}extractBasis(t,e,i){return t.setFromMatrixColumn(this,0),e.setFromMatrixColumn(this,1),i.setFromMatrixColumn(this,2),this}makeBasis(t,e,i){return this.set(t.x,e.x,i.x,0,t.y,e.y,i.y,0,t.z,e.z,i.z,0,0,0,0,1),this}extractRotation(t){const e=this.elements,i=t.elements,r=1/_v1$5.setFromMatrixColumn(t,0).length(),s=1/_v1$5.setFromMatrixColumn(t,1).length(),n=1/_v1$5.setFromMatrixColumn(t,2).length();return e[0]=i[0]*r,e[1]=i[1]*r,e[2]=i[2]*r,e[3]=0,e[4]=i[4]*s,e[5]=i[5]*s,e[6]=i[6]*s,e[7]=0,e[8]=i[8]*n,e[9]=i[9]*n,e[10]=i[10]*n,e[11]=0,e[12]=0,e[13]=0,e[14]=0,e[15]=1,this}makeRotationFromEuler(t){const e=this.elements,i=t.x,r=t.y,s=t.z,n=Math.cos(i),a=Math.sin(i),o=Math.cos(r),h=Math.sin(r),c=Math.cos(s),l=Math.sin(s);if("XYZ"===t.order){const t=n*c,i=n*l,r=a*c,s=a*l;e[0]=o*c,e[4]=-o*l,e[8]=h,e[1]=i+r*h,e[5]=t-s*h,e[9]=-a*o,e[2]=s-t*h,e[6]=r+i*h,e[10]=n*o}else if("YXZ"===t.order){const t=o*c,i=o*l,r=h*c,s=h*l;e[0]=t+s*a,e[4]=r*a-i,e[8]=n*h,e[1]=n*l,e[5]=n*c,e[9]=-a,e[2]=i*a-r,e[6]=s+t*a,e[10]=n*o}else if("ZXY"===t.order){const t=o*c,i=o*l,r=h*c,s=h*l;e[0]=t-s*a,e[4]=-n*l,e[8]=r+i*a,e[1]=i+r*a,e[5]=n*c,e[9]=s-t*a,e[2]=-n*h,e[6]=a,e[10]=n*o}else if("ZYX"===t.order){const t=n*c,i=n*l,r=a*c,s=a*l;e[0]=o*c,e[4]=r*h-i,e[8]=t*h+s,e[1]=o*l,e[5]=s*h+t,e[9]=i*h-r,e[2]=-h,e[6]=a*o,e[10]=n*o}else if("YZX"===t.order){const t=n*o,i=n*h,r=a*o,s=a*h;e[0]=o*c,e[4]=s-t*l,e[8]=r*l+i,e[1]=l,e[5]=n*c,e[9]=-a*c,e[2]=-h*c,e[6]=i*l+r,e[10]=t-s*l}else if("XZY"===t.order){const t=n*o,i=n*h,r=a*o,s=a*h;e[0]=o*c,e[4]=-l,e[8]=h*c,e[1]=t*l+s,e[5]=n*c,e[9]=i*l-r,e[2]=r*l-i,e[6]=a*c,e[10]=s*l+t}return e[3]=0,e[7]=0,e[11]=0,e[12]=0,e[13]=0,e[14]=0,e[15]=1,this}makeRotationFromQuaternion(t){return this.compose(_zero,t,_one)}lookAt(t,e,i){const r=this.elements;return _z.subVectors(t,e),0===_z.lengthSq()&&(_z.z=1),_z.normalize(),_x.crossVectors(i,_z),0===_x.lengthSq()&&(1===Math.abs(i.z)?_z.x+=1e-4:_z.z+=1e-4,_z.normalize(),_x.crossVectors(i,_z)),_x.normalize(),_y.crossVectors(_z,_x),r[0]=_x.x,r[4]=_y.x,r[8]=_z.x,r[1]=_x.y,r[5]=_y.y,r[9]=_z.y,r[2]=_x.z,r[6]=_y.z,r[10]=_z.z,this}multiply(t){return this.multiplyMatrices(this,t)}premultiply(t){return this.multiplyMatrices(t,this)}multiplyMatrices(t,e){const i=t.elements,r=e.elements,s=this.elements,n=i[0],a=i[4],o=i[8],h=i[12],c=i[1],l=i[5],u=i[9],p=i[13],d=i[2],m=i[6],y=i[10],f=i[14],g=i[3],x=i[7],_=i[11],v=i[15],b=r[0],M=r[4],w=r[8],S=r[12],A=r[1],T=r[5],C=r[9],B=r[13],I=r[2],z=r[6],P=r[10],R=r[14],V=r[3],E=r[7],F=r[11],L=r[15];return s[0]=n*b+a*A+o*I+h*V,s[4]=n*M+a*T+o*z+h*E,s[8]=n*w+a*C+o*P+h*F,s[12]=n*S+a*B+o*R+h*L,s[1]=c*b+l*A+u*I+p*V,s[5]=c*M+l*T+u*z+p*E,s[9]=c*w+l*C+u*P+p*F,s[13]=c*S+l*B+u*R+p*L,s[2]=d*b+m*A+y*I+f*V,s[6]=d*M+m*T+y*z+f*E,s[10]=d*w+m*C+y*P+f*F,s[14]=d*S+m*B+y*R+f*L,s[3]=g*b+x*A+_*I+v*V,s[7]=g*M+x*T+_*z+v*E,s[11]=g*w+x*C+_*P+v*F,s[15]=g*S+x*B+_*R+v*L,this}multiplyScalar(t){const e=this.elements;return e[0]*=t,e[4]*=t,e[8]*=t,e[12]*=t,e[1]*=t,e[5]*=t,e[9]*=t,e[13]*=t,e[2]*=t,e[6]*=t,e[10]*=t,e[14]*=t,e[3]*=t,e[7]*=t,e[11]*=t,e[15]*=t,this}determinant(){const t=this.elements,e=t[0],i=t[4],r=t[8],s=t[12],n=t[1],a=t[5],o=t[9],h=t[13],c=t[2],l=t[6],u=t[10],p=t[14];return t[3]*(+s*o*l-r*h*l-s*a*u+i*h*u+r*a*p-i*o*p)+t[7]*(+e*o*p-e*h*u+s*n*u-r*n*p+r*h*c-s*o*c)+t[11]*(+e*h*l-e*a*p-s*n*l+i*n*p+s*a*c-i*h*c)+t[15]*(-r*a*c-e*o*l+e*a*u+r*n*l-i*n*u+i*o*c)}transpose(){const t=this.elements;let e;return e=t[1],t[1]=t[4],t[4]=e,e=t[2],t[2]=t[8],t[8]=e,e=t[6],t[6]=t[9],t[9]=e,e=t[3],t[3]=t[12],t[12]=e,e=t[7],t[7]=t[13],t[13]=e,e=t[11],t[11]=t[14],t[14]=e,this}setPosition(t,e,i){const r=this.elements;return t.isVector3?(r[12]=t.x,r[13]=t.y,r[14]=t.z):(r[12]=t,r[13]=e,r[14]=i),this}invert(){const t=this.elements,e=t[0],i=t[1],r=t[2],s=t[3],n=t[4],a=t[5],o=t[6],h=t[7],c=t[8],l=t[9],u=t[10],p=t[11],d=t[12],m=t[13],y=t[14],f=t[15],g=l*y*h-m*u*h+m*o*p-a*y*p-l*o*f+a*u*f,x=d*u*h-c*y*h-d*o*p+n*y*p+c*o*f-n*u*f,_=c*m*h-d*l*h+d*a*p-n*m*p-c*a*f+n*l*f,v=d*l*o-c*m*o-d*a*u+n*m*u+c*a*y-n*l*y,b=e*g+i*x+r*_+s*v;if(0===b)return this.set(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);const M=1/b;return t[0]=g*M,t[1]=(m*u*s-l*y*s-m*r*p+i*y*p+l*r*f-i*u*f)*M,t[2]=(a*y*s-m*o*s+m*r*h-i*y*h-a*r*f+i*o*f)*M,t[3]=(l*o*s-a*u*s-l*r*h+i*u*h+a*r*p-i*o*p)*M,t[4]=x*M,t[5]=(c*y*s-d*u*s+d*r*p-e*y*p-c*r*f+e*u*f)*M,t[6]=(d*o*s-n*y*s-d*r*h+e*y*h+n*r*f-e*o*f)*M,t[7]=(n*u*s-c*o*s+c*r*h-e*u*h-n*r*p+e*o*p)*M,t[8]=_*M,t[9]=(d*l*s-c*m*s-d*i*p+e*m*p+c*i*f-e*l*f)*M,t[10]=(n*m*s-d*a*s+d*i*h-e*m*h-n*i*f+e*a*f)*M,t[11]=(c*a*s-n*l*s-c*i*h+e*l*h+n*i*p-e*a*p)*M,t[12]=v*M,t[13]=(c*m*r-d*l*r+d*i*u-e*m*u-c*i*y+e*l*y)*M,t[14]=(d*a*r-n*m*r-d*i*o+e*m*o+n*i*y-e*a*y)*M,t[15]=(n*l*r-c*a*r+c*i*o-e*l*o-n*i*u+e*a*u)*M,this}scale(t){const e=this.elements,i=t.x,r=t.y,s=t.z;return e[0]*=i,e[4]*=r,e[8]*=s,e[1]*=i,e[5]*=r,e[9]*=s,e[2]*=i,e[6]*=r,e[10]*=s,e[3]*=i,e[7]*=r,e[11]*=s,this}getMaxScaleOnAxis(){const t=this.elements,e=t[0]*t[0]+t[1]*t[1]+t[2]*t[2],i=t[4]*t[4]+t[5]*t[5]+t[6]*t[6],r=t[8]*t[8]+t[9]*t[9]+t[10]*t[10];return Math.sqrt(Math.max(e,i,r))}makeTranslation(t,e,i){return t.isVector3?this.set(1,0,0,t.x,0,1,0,t.y,0,0,1,t.z,0,0,0,1):this.set(1,0,0,t,0,1,0,e,0,0,1,i,0,0,0,1),this}makeRotationX(t){const e=Math.cos(t),i=Math.sin(t);return this.set(1,0,0,0,0,e,-i,0,0,i,e,0,0,0,0,1),this}makeRotationY(t){const e=Math.cos(t),i=Math.sin(t);return this.set(e,0,i,0,0,1,0,0,-i,0,e,0,0,0,0,1),this}makeRotationZ(t){const e=Math.cos(t),i=Math.sin(t);return this.set(e,-i,0,0,i,e,0,0,0,0,1,0,0,0,0,1),this}makeRotationAxis(t,e){const i=Math.cos(e),r=Math.sin(e),s=1-i,n=t.x,a=t.y,o=t.z,h=s*n,c=s*a;return this.set(h*n+i,h*a-r*o,h*o+r*a,0,h*a+r*o,c*a+i,c*o-r*n,0,h*o-r*a,c*o+r*n,s*o*o+i,0,0,0,0,1),this}makeScale(t,e,i){return this.set(t,0,0,0,0,e,0,0,0,0,i,0,0,0,0,1),this}makeShear(t,e,i,r,s,n){return this.set(1,i,s,0,t,1,n,0,e,r,1,0,0,0,0,1),this}compose(t,e,i){const r=this.elements,s=e._x,n=e._y,a=e._z,o=e._w,h=s+s,c=n+n,l=a+a,u=s*h,p=s*c,d=s*l,m=n*c,y=n*l,f=a*l,g=o*h,x=o*c,_=o*l,v=i.x,b=i.y,M=i.z;return r[0]=(1-(m+f))*v,r[1]=(p+_)*v,r[2]=(d-x)*v,r[3]=0,r[4]=(p-_)*b,r[5]=(1-(u+f))*b,r[6]=(y+g)*b,r[7]=0,r[8]=(d+x)*M,r[9]=(y-g)*M,r[10]=(1-(u+m))*M,r[11]=0,r[12]=t.x,r[13]=t.y,r[14]=t.z,r[15]=1,this}decompose(t,e,i){const r=this.elements;let s=_v1$5.set(r[0],r[1],r[2]).length();const n=_v1$5.set(r[4],r[5],r[6]).length(),a=_v1$5.set(r[8],r[9],r[10]).length();this.determinant()<0&&(s=-s),t.x=r[12],t.y=r[13],t.z=r[14],_m1$2.copy(this);const o=1/s,h=1/n,c=1/a;return _m1$2.elements[0]*=o,_m1$2.elements[1]*=o,_m1$2.elements[2]*=o,_m1$2.elements[4]*=h,_m1$2.elements[5]*=h,_m1$2.elements[6]*=h,_m1$2.elements[8]*=c,_m1$2.elements[9]*=c,_m1$2.elements[10]*=c,e.setFromRotationMatrix(_m1$2),i.x=s,i.y=n,i.z=a,this}makePerspective(t,e,i,r,s,n,a=2e3){const o=this.elements,h=2*s/(e-t),c=2*s/(i-r),l=(e+t)/(e-t),u=(i+r)/(i-r);let p,d;if(2e3===a)p=-(n+s)/(n-s),d=-2*n*s/(n-s);else{if(2001!==a)throw new Error("THREE.Matrix4.makePerspective(): Invalid coordinate system: "+a);p=-n/(n-s),d=-n*s/(n-s)}return o[0]=h,o[4]=0,o[8]=l,o[12]=0,o[1]=0,o[5]=c,o[9]=u,o[13]=0,o[2]=0,o[6]=0,o[10]=p,o[14]=d,o[3]=0,o[7]=0,o[11]=-1,o[15]=0,this}makeOrthographic(t,e,i,r,s,n,a=2e3){const o=this.elements,h=1/(e-t),c=1/(i-r),l=1/(n-s),u=(e+t)*h,p=(i+r)*c;let d,m;if(2e3===a)d=(n+s)*l,m=-2*l;else{if(2001!==a)throw new Error("THREE.Matrix4.makeOrthographic(): Invalid coordinate system: "+a);d=s*l,m=-1*l}return o[0]=2*h,o[4]=0,o[8]=0,o[12]=-u,o[1]=0,o[5]=2*c,o[9]=0,o[13]=-p,o[2]=0,o[6]=0,o[10]=m,o[14]=-d,o[3]=0,o[7]=0,o[11]=0,o[15]=1,this}equals(t){const e=this.elements,i=t.elements;for(let t=0;t<16;t++)if(e[t]!==i[t])return!1;return!0}fromArray(t,e=0){for(let i=0;i<16;i++)this.elements[i]=t[i+e];return this}toArray(t=[],e=0){const i=this.elements;return t[e]=i[0],t[e+1]=i[1],t[e+2]=i[2],t[e+3]=i[3],t[e+4]=i[4],t[e+5]=i[5],t[e+6]=i[6],t[e+7]=i[7],t[e+8]=i[8],t[e+9]=i[9],t[e+10]=i[10],t[e+11]=i[11],t[e+12]=i[12],t[e+13]=i[13],t[e+14]=i[14],t[e+15]=i[15],t}}const _v1$5=new Vector3,_m1$2=new Matrix4,_zero=new Vector3(0,0,0),_one=new Vector3(1,1,1),_x=new Vector3,_y=new Vector3,_z=new Vector3,_matrix$2=new Matrix4,_quaternion$3=new Quaternion;class Euler{constructor(t=0,e=0,i=0,r=Euler.DEFAULT_ORDER){this.isEuler=!0,this._x=t,this._y=e,this._z=i,this._order=r}get x(){return this._x}set x(t){this._x=t,this._onChangeCallback()}get y(){return this._y}set y(t){this._y=t,this._onChangeCallback()}get z(){return this._z}set z(t){this._z=t,this._onChangeCallback()}get order(){return this._order}set order(t){this._order=t,this._onChangeCallback()}set(t,e,i,r=this._order){return this._x=t,this._y=e,this._z=i,this._order=r,this._onChangeCallback(),this}clone(){return new this.constructor(this._x,this._y,this._z,this._order)}copy(t){return this._x=t._x,this._y=t._y,this._z=t._z,this._order=t._order,this._onChangeCallback(),this}setFromRotationMatrix(t,e=this._order,i=!0){const r=t.elements,s=r[0],n=r[4],a=r[8],o=r[1],h=r[5],c=r[9],l=r[2],u=r[6],p=r[10];switch(e){case"XYZ":this._y=Math.asin(clamp(a,-1,1)),Math.abs(a)<.9999999?(this._x=Math.atan2(-c,p),this._z=Math.atan2(-n,s)):(this._x=Math.atan2(u,h),this._z=0);break;case"YXZ":this._x=Math.asin(-clamp(c,-1,1)),Math.abs(c)<.9999999?(this._y=Math.atan2(a,p),this._z=Math.atan2(o,h)):(this._y=Math.atan2(-l,s),this._z=0);break;case"ZXY":this._x=Math.asin(clamp(u,-1,1)),Math.abs(u)<.9999999?(this._y=Math.atan2(-l,p),this._z=Math.atan2(-n,h)):(this._y=0,this._z=Math.atan2(o,s));break;case"ZYX":this._y=Math.asin(-clamp(l,-1,1)),Math.abs(l)<.9999999?(this._x=Math.atan2(u,p),this._z=Math.atan2(o,s)):(this._x=0,this._z=Math.atan2(-n,h));break;case"YZX":this._z=Math.asin(clamp(o,-1,1)),Math.abs(o)<.9999999?(this._x=Math.atan2(-c,h),this._y=Math.atan2(-l,s)):(this._x=0,this._y=Math.atan2(a,p));break;case"XZY":this._z=Math.asin(-clamp(n,-1,1)),Math.abs(n)<.9999999?(this._x=Math.atan2(u,h),this._y=Math.atan2(a,s)):(this._x=Math.atan2(-c,p),this._y=0);break;default:console.warn("THREE.Euler: .setFromRotationMatrix() encountered an unknown order: "+e)}return this._order=e,!0===i&&this._onChangeCallback(),this}setFromQuaternion(t,e,i){return _matrix$2.makeRotationFromQuaternion(t),this.setFromRotationMatrix(_matrix$2,e,i)}setFromVector3(t,e=this._order){return this.set(t.x,t.y,t.z,e)}reorder(t){return _quaternion$3.setFromEuler(this),this.setFromQuaternion(_quaternion$3,t)}equals(t){return t._x===this._x&&t._y===this._y&&t._z===this._z&&t._order===this._order}fromArray(t){return this._x=t[0],this._y=t[1],this._z=t[2],void 0!==t[3]&&(this._order=t[3]),this._onChangeCallback(),this}toArray(t=[],e=0){return t[e]=this._x,t[e+1]=this._y,t[e+2]=this._z,t[e+3]=this._order,t}_onChange(t){return this._onChangeCallback=t,this}_onChangeCallback(){}*[Symbol.iterator](){yield this._x,yield this._y,yield this._z,yield this._order}}Euler.DEFAULT_ORDER="XYZ";class Layers{constructor(){this.mask=1}set(t){this.mask=1<<t>>>0}enable(t){this.mask|=1<<t}enableAll(){this.mask=-1}toggle(t){this.mask^=1<<t}disable(t){this.mask&=~(1<<t)}disableAll(){this.mask=0}test(t){return!!(this.mask&t.mask)}isEnabled(t){return!!(this.mask&1<<t)}}let _object3DId=0;const _v1$4=new Vector3,_q1=new Quaternion,_m1$1=new Matrix4,_target=new Vector3,_position$3=new Vector3,_scale$2=new Vector3,_quaternion$2=new Quaternion,_xAxis=new Vector3(1,0,0),_yAxis=new Vector3(0,1,0),_zAxis=new Vector3(0,0,1),_addedEvent={type:"added"},_removedEvent={type:"removed"},_childaddedEvent={type:"childadded",child:null},_childremovedEvent={type:"childremoved",child:null};class Object3D extends EventDispatcher{constructor(){super(),this.isObject3D=!0,Object.defineProperty(this,"id",{value:_object3DId++}),this.uuid=generateUUID(),this.name="",this.type="Object3D",this.parent=null,this.children=[],this.up=Object3D.DEFAULT_UP.clone();const t=new Vector3,e=new Euler,i=new Quaternion,r=new Vector3(1,1,1);e._onChange((function(){i.setFromEuler(e,!1)})),i._onChange((function(){e.setFromQuaternion(i,void 0,!1)})),Object.defineProperties(this,{position:{configurable:!0,enumerable:!0,value:t},rotation:{configurable:!0,enumerable:!0,value:e},quaternion:{configurable:!0,enumerable:!0,value:i},scale:{configurable:!0,enumerable:!0,value:r},modelViewMatrix:{value:new Matrix4},normalMatrix:{value:new Matrix3}}),this.matrix=new Matrix4,this.matrixWorld=new Matrix4,this.matrixAutoUpdate=Object3D.DEFAULT_MATRIX_AUTO_UPDATE,this.matrixWorldAutoUpdate=Object3D.DEFAULT_MATRIX_WORLD_AUTO_UPDATE,this.matrixWorldNeedsUpdate=!1,this.layers=new Layers,this.visible=!0,this.castShadow=!1,this.receiveShadow=!1,this.frustumCulled=!0,this.renderOrder=0,this.animations=[],this.customDepthMaterial=void 0,this.customDistanceMaterial=void 0,this.userData={}}onBeforeShadow(){}onAfterShadow(){}onBeforeRender(){}onAfterRender(){}applyMatrix4(t){this.matrixAutoUpdate&&this.updateMatrix(),this.matrix.premultiply(t),this.matrix.decompose(this.position,this.quaternion,this.scale)}applyQuaternion(t){return this.quaternion.premultiply(t),this}setRotationFromAxisAngle(t,e){this.quaternion.setFromAxisAngle(t,e)}setRotationFromEuler(t){this.quaternion.setFromEuler(t,!0)}setRotationFromMatrix(t){this.quaternion.setFromRotationMatrix(t)}setRotationFromQuaternion(t){this.quaternion.copy(t)}rotateOnAxis(t,e){return _q1.setFromAxisAngle(t,e),this.quaternion.multiply(_q1),this}rotateOnWorldAxis(t,e){return _q1.setFromAxisAngle(t,e),this.quaternion.premultiply(_q1),this}rotateX(t){return this.rotateOnAxis(_xAxis,t)}rotateY(t){return this.rotateOnAxis(_yAxis,t)}rotateZ(t){return this.rotateOnAxis(_zAxis,t)}translateOnAxis(t,e){return _v1$4.copy(t).applyQuaternion(this.quaternion),this.position.add(_v1$4.multiplyScalar(e)),this}translateX(t){return this.translateOnAxis(_xAxis,t)}translateY(t){return this.translateOnAxis(_yAxis,t)}translateZ(t){return this.translateOnAxis(_zAxis,t)}localToWorld(t){return this.updateWorldMatrix(!0,!1),t.applyMatrix4(this.matrixWorld)}worldToLocal(t){return this.updateWorldMatrix(!0,!1),t.applyMatrix4(_m1$1.copy(this.matrixWorld).invert())}lookAt(t,e,i){t.isVector3?_target.copy(t):_target.set(t,e,i);const r=this.parent;this.updateWorldMatrix(!0,!1),_position$3.setFromMatrixPosition(this.matrixWorld),this.isCamera||this.isLight?_m1$1.lookAt(_position$3,_target,this.up):_m1$1.lookAt(_target,_position$3,this.up),this.quaternion.setFromRotationMatrix(_m1$1),r&&(_m1$1.extractRotation(r.matrixWorld),_q1.setFromRotationMatrix(_m1$1),this.quaternion.premultiply(_q1.invert()))}add(t){if(arguments.length>1){for(let t=0;t<arguments.length;t++)this.add(arguments[t]);return this}return t===this?(console.error("THREE.Object3D.add: object can't be added as a child of itself.",t),this):(t&&t.isObject3D?(t.removeFromParent(),t.parent=this,this.children.push(t),t.dispatchEvent(_addedEvent),_childaddedEvent.child=t,this.dispatchEvent(_childaddedEvent),_childaddedEvent.child=null):console.error("THREE.Object3D.add: object not an instance of THREE.Object3D.",t),this)}remove(t){if(arguments.length>1){for(let t=0;t<arguments.length;t++)this.remove(arguments[t]);return this}const e=this.children.indexOf(t);return-1!==e&&(t.parent=null,this.children.splice(e,1),t.dispatchEvent(_removedEvent),_childremovedEvent.child=t,this.dispatchEvent(_childremovedEvent),_childremovedEvent.child=null),this}removeFromParent(){const t=this.parent;return null!==t&&t.remove(this),this}clear(){return this.remove(...this.children)}attach(t){return this.updateWorldMatrix(!0,!1),_m1$1.copy(this.matrixWorld).invert(),null!==t.parent&&(t.parent.updateWorldMatrix(!0,!1),_m1$1.multiply(t.parent.matrixWorld)),t.applyMatrix4(_m1$1),t.removeFromParent(),t.parent=this,this.children.push(t),t.updateWorldMatrix(!1,!0),t.dispatchEvent(_addedEvent),_childaddedEvent.child=t,this.dispatchEvent(_childaddedEvent),_childaddedEvent.child=null,this}getObjectById(t){return this.getObjectByProperty("id",t)}getObjectByName(t){return this.getObjectByProperty("name",t)}getObjectByProperty(t,e){if(this[t]===e)return this;for(let i=0,r=this.children.length;i<r;i++){const r=this.children[i].getObjectByProperty(t,e);if(void 0!==r)return r}}getObjectsByProperty(t,e,i=[]){this[t]===e&&i.push(this);const r=this.children;for(let s=0,n=r.length;s<n;s++)r[s].getObjectsByProperty(t,e,i);return i}getWorldPosition(t){return this.updateWorldMatrix(!0,!1),t.setFromMatrixPosition(this.matrixWorld)}getWorldQuaternion(t){return this.updateWorldMatrix(!0,!1),this.matrixWorld.decompose(_position$3,t,_scale$2),t}getWorldScale(t){return this.updateWorldMatrix(!0,!1),this.matrixWorld.decompose(_position$3,_quaternion$2,t),t}getWorldDirection(t){this.updateWorldMatrix(!0,!1);const e=this.matrixWorld.elements;return t.set(e[8],e[9],e[10]).normalize()}raycast(){}traverse(t){t(this);const e=this.children;for(let i=0,r=e.length;i<r;i++)e[i].traverse(t)}traverseVisible(t){if(!1===this.visible)return;t(this);const e=this.children;for(let i=0,r=e.length;i<r;i++)e[i].traverseVisible(t)}traverseAncestors(t){const e=this.parent;null!==e&&(t(e),e.traverseAncestors(t))}updateMatrix(){this.matrix.compose(this.position,this.quaternion,this.scale),this.matrixWorldNeedsUpdate=!0}updateMatrixWorld(t){this.matrixAutoUpdate&&this.updateMatrix(),(this.matrixWorldNeedsUpdate||t)&&(!0===this.matrixWorldAutoUpdate&&(null===this.parent?this.matrixWorld.copy(this.matrix):this.matrixWorld.multiplyMatrices(this.parent.matrixWorld,this.matrix)),this.matrixWorldNeedsUpdate=!1,t=!0);const e=this.children;for(let i=0,r=e.length;i<r;i++){e[i].updateMatrixWorld(t)}}updateWorldMatrix(t,e){const i=this.parent;if(!0===t&&null!==i&&i.updateWorldMatrix(!0,!1),this.matrixAutoUpdate&&this.updateMatrix(),!0===this.matrixWorldAutoUpdate&&(null===this.parent?this.matrixWorld.copy(this.matrix):this.matrixWorld.multiplyMatrices(this.parent.matrixWorld,this.matrix)),!0===e){const t=this.children;for(let e=0,i=t.length;e<i;e++){t[e].updateWorldMatrix(!1,!0)}}}toJSON(t){const e=void 0===t||"string"==typeof t,i={};e&&(t={geometries:{},materials:{},textures:{},images:{},shapes:{},skeletons:{},animations:{},nodes:{}},i.metadata={version:4.6,type:"Object",generator:"Object3D.toJSON"});const r={};function s(e,i){return void 0===e[i.uuid]&&(e[i.uuid]=i.toJSON(t)),i.uuid}if(r.uuid=this.uuid,r.type=this.type,""!==this.name&&(r.name=this.name),!0===this.castShadow&&(r.castShadow=!0),!0===this.receiveShadow&&(r.receiveShadow=!0),!1===this.visible&&(r.visible=!1),!1===this.frustumCulled&&(r.frustumCulled=!1),0!==this.renderOrder&&(r.renderOrder=this.renderOrder),Object.keys(this.userData).length>0&&(r.userData=this.userData),r.layers=this.layers.mask,r.matrix=this.matrix.toArray(),r.up=this.up.toArray(),!1===this.matrixAutoUpdate&&(r.matrixAutoUpdate=!1),this.isInstancedMesh&&(r.type="InstancedMesh",r.count=this.count,r.instanceMatrix=this.instanceMatrix.toJSON(),null!==this.instanceColor&&(r.instanceColor=this.instanceColor.toJSON())),this.isBatchedMesh&&(r.type="BatchedMesh",r.perObjectFrustumCulled=this.perObjectFrustumCulled,r.sortObjects=this.sortObjects,r.drawRanges=this._drawRanges,r.reservedRanges=this._reservedRanges,r.geometryInfo=this._geometryInfo.map((t=>({...t,boundingBox:t.boundingBox?{min:t.boundingBox.min.toArray(),max:t.boundingBox.max.toArray()}:void 0,boundingSphere:t.boundingSphere?{radius:t.boundingSphere.radius,center:t.boundingSphere.center.toArray()}:void 0}))),r.instanceInfo=this._instanceInfo.map((t=>({...t}))),r.availableInstanceIds=this._availableInstanceIds.slice(),r.availableGeometryIds=this._availableGeometryIds.slice(),r.nextIndexStart=this._nextIndexStart,r.nextVertexStart=this._nextVertexStart,r.geometryCount=this._geometryCount,r.maxInstanceCount=this._maxInstanceCount,r.maxVertexCount=this._maxVertexCount,r.maxIndexCount=this._maxIndexCount,r.geometryInitialized=this._geometryInitialized,r.matricesTexture=this._matricesTexture.toJSON(t),r.indirectTexture=this._indirectTexture.toJSON(t),null!==this._colorsTexture&&(r.colorsTexture=this._colorsTexture.toJSON(t)),null!==this.boundingSphere&&(r.boundingSphere={center:this.boundingSphere.center.toArray(),radius:this.boundingSphere.radius}),null!==this.boundingBox&&(r.boundingBox={min:this.boundingBox.min.toArray(),max:this.boundingBox.max.toArray()})),this.isScene)this.background&&(this.background.isColor?r.background=this.background.toJSON():this.background.isTexture&&(r.background=this.background.toJSON(t).uuid)),this.environment&&this.environment.isTexture&&!0!==this.environment.isRenderTargetTexture&&(r.environment=this.environment.toJSON(t).uuid);else if(this.isMesh||this.isLine||this.isPoints){r.geometry=s(t.geometries,this.geometry);const e=this.geometry.parameters;if(void 0!==e&&void 0!==e.shapes){const i=e.shapes;if(Array.isArray(i))for(let e=0,r=i.length;e<r;e++){const r=i[e];s(t.shapes,r)}else s(t.shapes,i)}}if(this.isSkinnedMesh&&(r.bindMode=this.bindMode,r.bindMatrix=this.bindMatrix.toArray(),void 0!==this.skeleton&&(s(t.skeletons,this.skeleton),r.skeleton=this.skeleton.uuid)),void 0!==this.material)if(Array.isArray(this.material)){const e=[];for(let i=0,r=this.material.length;i<r;i++)e.push(s(t.materials,this.material[i]));r.material=e}else r.material=s(t.materials,this.material);if(this.children.length>0){r.children=[];for(let e=0;e<this.children.length;e++)r.children.push(this.children[e].toJSON(t).object)}if(this.animations.length>0){r.animations=[];for(let e=0;e<this.animations.length;e++){const i=this.animations[e];r.animations.push(s(t.animations,i))}}if(e){const e=n(t.geometries),r=n(t.materials),s=n(t.textures),a=n(t.images),o=n(t.shapes),h=n(t.skeletons),c=n(t.animations),l=n(t.nodes);e.length>0&&(i.geometries=e),r.length>0&&(i.materials=r),s.length>0&&(i.textures=s),a.length>0&&(i.images=a),o.length>0&&(i.shapes=o),h.length>0&&(i.skeletons=h),c.length>0&&(i.animations=c),l.length>0&&(i.nodes=l)}return i.object=r,i;function n(t){const e=[];for(const i in t){const r=t[i];delete r.metadata,e.push(r)}return e}}clone(t){return(new this.constructor).copy(this,t)}copy(t,e=!0){if(this.name=t.name,this.up.copy(t.up),this.position.copy(t.position),this.rotation.order=t.rotation.order,this.quaternion.copy(t.quaternion),this.scale.copy(t.scale),this.matrix.copy(t.matrix),this.matrixWorld.copy(t.matrixWorld),this.matrixAutoUpdate=t.matrixAutoUpdate,this.matrixWorldAutoUpdate=t.matrixWorldAutoUpdate,this.matrixWorldNeedsUpdate=t.matrixWorldNeedsUpdate,this.layers.mask=t.layers.mask,this.visible=t.visible,this.castShadow=t.castShadow,this.receiveShadow=t.receiveShadow,this.frustumCulled=t.frustumCulled,this.renderOrder=t.renderOrder,this.animations=t.animations.slice(),this.userData=JSON.parse(JSON.stringify(t.userData)),!0===e)for(let e=0;e<t.children.length;e++){const i=t.children[e];this.add(i.clone())}return this}}Object3D.DEFAULT_UP=new Vector3(0,1,0),Object3D.DEFAULT_MATRIX_AUTO_UPDATE=!0,Object3D.DEFAULT_MATRIX_WORLD_AUTO_UPDATE=!0;const _v0$1=new Vector3,_v1$3=new Vector3,_v2$2=new Vector3,_v3$2=new Vector3,_vab=new Vector3,_vac=new Vector3,_vbc=new Vector3,_vap=new Vector3,_vbp=new Vector3,_vcp=new Vector3,_v40=new Vector4,_v41=new Vector4,_v42=new Vector4;class Triangle{constructor(t=new Vector3,e=new Vector3,i=new Vector3){this.a=t,this.b=e,this.c=i}static getNormal(t,e,i,r){r.subVectors(i,e),_v0$1.subVectors(t,e),r.cross(_v0$1);const s=r.lengthSq();return s>0?r.multiplyScalar(1/Math.sqrt(s)):r.set(0,0,0)}static getBarycoord(t,e,i,r,s){_v0$1.subVectors(r,e),_v1$3.subVectors(i,e),_v2$2.subVectors(t,e);const n=_v0$1.dot(_v0$1),a=_v0$1.dot(_v1$3),o=_v0$1.dot(_v2$2),h=_v1$3.dot(_v1$3),c=_v1$3.dot(_v2$2),l=n*h-a*a;if(0===l)return s.set(0,0,0),null;const u=1/l,p=(h*o-a*c)*u,d=(n*c-a*o)*u;return s.set(1-p-d,d,p)}static containsPoint(t,e,i,r){return null!==this.getBarycoord(t,e,i,r,_v3$2)&&(_v3$2.x>=0&&_v3$2.y>=0&&_v3$2.x+_v3$2.y<=1)}static getInterpolation(t,e,i,r,s,n,a,o){return null===this.getBarycoord(t,e,i,r,_v3$2)?(o.x=0,o.y=0,"z"in o&&(o.z=0),"w"in o&&(o.w=0),null):(o.setScalar(0),o.addScaledVector(s,_v3$2.x),o.addScaledVector(n,_v3$2.y),o.addScaledVector(a,_v3$2.z),o)}static getInterpolatedAttribute(t,e,i,r,s,n){return _v40.setScalar(0),_v41.setScalar(0),_v42.setScalar(0),_v40.fromBufferAttribute(t,e),_v41.fromBufferAttribute(t,i),_v42.fromBufferAttribute(t,r),n.setScalar(0),n.addScaledVector(_v40,s.x),n.addScaledVector(_v41,s.y),n.addScaledVector(_v42,s.z),n}static isFrontFacing(t,e,i,r){return _v0$1.subVectors(i,e),_v1$3.subVectors(t,e),_v0$1.cross(_v1$3).dot(r)<0}set(t,e,i){return this.a.copy(t),this.b.copy(e),this.c.copy(i),this}setFromPointsAndIndices(t,e,i,r){return this.a.copy(t[e]),this.b.copy(t[i]),this.c.copy(t[r]),this}setFromAttributeAndIndices(t,e,i,r){return this.a.fromBufferAttribute(t,e),this.b.fromBufferAttribute(t,i),this.c.fromBufferAttribute(t,r),this}clone(){return(new this.constructor).copy(this)}copy(t){return this.a.copy(t.a),this.b.copy(t.b),this.c.copy(t.c),this}getArea(){return _v0$1.subVectors(this.c,this.b),_v1$3.subVectors(this.a,this.b),.5*_v0$1.cross(_v1$3).length()}getMidpoint(t){return t.addVectors(this.a,this.b).add(this.c).multiplyScalar(1/3)}getNormal(t){return Triangle.getNormal(this.a,this.b,this.c,t)}getPlane(t){return t.setFromCoplanarPoints(this.a,this.b,this.c)}getBarycoord(t,e){return Triangle.getBarycoord(t,this.a,this.b,this.c,e)}getInterpolation(t,e,i,r,s){return Triangle.getInterpolation(t,this.a,this.b,this.c,e,i,r,s)}containsPoint(t){return Triangle.containsPoint(t,this.a,this.b,this.c)}isFrontFacing(t){return Triangle.isFrontFacing(this.a,this.b,this.c,t)}intersectsBox(t){return t.intersectsTriangle(this)}closestPointToPoint(t,e){const i=this.a,r=this.b,s=this.c;let n,a;_vab.subVectors(r,i),_vac.subVectors(s,i),_vap.subVectors(t,i);const o=_vab.dot(_vap),h=_vac.dot(_vap);if(o<=0&&h<=0)return e.copy(i);_vbp.subVectors(t,r);const c=_vab.dot(_vbp),l=_vac.dot(_vbp);if(c>=0&&l<=c)return e.copy(r);const u=o*l-c*h;if(u<=0&&o>=0&&c<=0)return n=o/(o-c),e.copy(i).addScaledVector(_vab,n);_vcp.subVectors(t,s);const p=_vab.dot(_vcp),d=_vac.dot(_vcp);if(d>=0&&p<=d)return e.copy(s);const m=p*h-o*d;if(m<=0&&h>=0&&d<=0)return a=h/(h-d),e.copy(i).addScaledVector(_vac,a);const y=c*d-p*l;if(y<=0&&l-c>=0&&p-d>=0)return _vbc.subVectors(s,r),a=(l-c)/(l-c+(p-d)),e.copy(r).addScaledVector(_vbc,a);const f=1/(y+m+u);return n=m*f,a=u*f,e.copy(i).addScaledVector(_vab,n).addScaledVector(_vac,a)}equals(t){return t.a.equals(this.a)&&t.b.equals(this.b)&&t.c.equals(this.c)}}const _colorKeywords={aliceblue:15792383,antiquewhite:16444375,aqua:65535,aquamarine:8388564,azure:15794175,beige:16119260,bisque:16770244,black:0,blanchedalmond:16772045,blue:255,blueviolet:9055202,brown:10824234,burlywood:14596231,cadetblue:6266528,chartreuse:8388352,chocolate:13789470,coral:16744272,cornflowerblue:6591981,cornsilk:16775388,crimson:14423100,cyan:65535,darkblue:139,darkcyan:35723,darkgoldenrod:12092939,darkgray:11119017,darkgreen:25600,darkgrey:11119017,darkkhaki:12433259,darkmagenta:9109643,darkolivegreen:5597999,darkorange:16747520,darkorchid:10040012,darkred:9109504,darksalmon:15308410,darkseagreen:9419919,darkslateblue:4734347,darkslategray:3100495,darkslategrey:3100495,darkturquoise:52945,darkviolet:9699539,deeppink:16716947,deepskyblue:49151,dimgray:6908265,dimgrey:6908265,dodgerblue:2003199,firebrick:11674146,floralwhite:16775920,forestgreen:2263842,fuchsia:16711935,gainsboro:14474460,ghostwhite:16316671,gold:16766720,goldenrod:14329120,gray:8421504,green:32768,greenyellow:11403055,grey:8421504,honeydew:15794160,hotpink:16738740,indianred:13458524,indigo:4915330,ivory:16777200,khaki:15787660,lavender:15132410,lavenderblush:16773365,lawngreen:8190976,lemonchiffon:16775885,lightblue:11393254,lightcoral:15761536,lightcyan:14745599,lightgoldenrodyellow:16448210,lightgray:13882323,lightgreen:9498256,lightgrey:13882323,lightpink:16758465,lightsalmon:16752762,lightseagreen:2142890,lightskyblue:8900346,lightslategray:7833753,lightslategrey:7833753,lightsteelblue:11584734,lightyellow:16777184,lime:65280,limegreen:3329330,linen:16445670,magenta:16711935,maroon:8388608,mediumaquamarine:6737322,mediumblue:205,mediumorchid:12211667,mediumpurple:9662683,mediumseagreen:3978097,mediumslateblue:8087790,mediumspringgreen:64154,mediumturquoise:4772300,mediumvioletred:13047173,midnightblue:1644912,mintcream:16121850,mistyrose:16770273,moccasin:16770229,navajowhite:16768685,navy:128,oldlace:16643558,olive:8421376,olivedrab:7048739,orange:16753920,orangered:16729344,orchid:14315734,palegoldenrod:15657130,palegreen:10025880,paleturquoise:11529966,palevioletred:14381203,papayawhip:16773077,peachpuff:16767673,peru:13468991,pink:16761035,plum:14524637,powderblue:11591910,purple:8388736,rebeccapurple:6697881,red:16711680,rosybrown:12357519,royalblue:4286945,saddlebrown:9127187,salmon:16416882,sandybrown:16032864,seagreen:3050327,seashell:16774638,sienna:10506797,silver:12632256,skyblue:8900331,slateblue:6970061,slategray:7372944,slategrey:7372944,snow:16775930,springgreen:65407,steelblue:4620980,tan:13808780,teal:32896,thistle:14204888,tomato:16737095,turquoise:4251856,violet:15631086,wheat:16113331,white:16777215,whitesmoke:16119285,yellow:16776960,yellowgreen:10145074},_hslA={h:0,s:0,l:0},_hslB={h:0,s:0,l:0};function hue2rgb(t,e,i){return i<0&&(i+=1),i>1&&(i-=1),i<1/6?t+6*(e-t)*i:i<.5?e:i<2/3?t+6*(e-t)*(2/3-i):t}class Color{constructor(t,e,i){return this.isColor=!0,this.r=1,this.g=1,this.b=1,this.set(t,e,i)}set(t,e,i){if(void 0===e&&void 0===i){const e=t;e&&e.isColor?this.copy(e):"number"==typeof e?this.setHex(e):"string"==typeof e&&this.setStyle(e)}else this.setRGB(t,e,i);return this}setScalar(t){return this.r=t,this.g=t,this.b=t,this}setHex(t,e="srgb"){return t=Math.floor(t),this.r=(t>>16&255)/255,this.g=(t>>8&255)/255,this.b=(255&t)/255,ColorManagement.toWorkingColorSpace(this,e),this}setRGB(t,e,i,r=ColorManagement.workingColorSpace){return this.r=t,this.g=e,this.b=i,ColorManagement.toWorkingColorSpace(this,r),this}setHSL(t,e,i,r=ColorManagement.workingColorSpace){if(t=euclideanModulo(t,1),e=clamp(e,0,1),i=clamp(i,0,1),0===e)this.r=this.g=this.b=i;else{const r=i<=.5?i*(1+e):i+e-i*e,s=2*i-r;this.r=hue2rgb(s,r,t+1/3),this.g=hue2rgb(s,r,t),this.b=hue2rgb(s,r,t-1/3)}return ColorManagement.toWorkingColorSpace(this,r),this}setStyle(t,e="srgb"){function i(e){void 0!==e&&parseFloat(e)<1&&console.warn("THREE.Color: Alpha component of "+t+" will be ignored.")}let r;if(r=/^(\w+)\(([^\)]*)\)/.exec(t)){let s;const n=r[1],a=r[2];switch(n){case"rgb":case"rgba":if(s=/^\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*(?:,\s*(\d*\.?\d+)\s*)?$/.exec(a))return i(s[4]),this.setRGB(Math.min(255,parseInt(s[1],10))/255,Math.min(255,parseInt(s[2],10))/255,Math.min(255,parseInt(s[3],10))/255,e);if(s=/^\s*(\d+)\%\s*,\s*(\d+)\%\s*,\s*(\d+)\%\s*(?:,\s*(\d*\.?\d+)\s*)?$/.exec(a))return i(s[4]),this.setRGB(Math.min(100,parseInt(s[1],10))/100,Math.min(100,parseInt(s[2],10))/100,Math.min(100,parseInt(s[3],10))/100,e);break;case"hsl":case"hsla":if(s=/^\s*(\d*\.?\d+)\s*,\s*(\d*\.?\d+)\%\s*,\s*(\d*\.?\d+)\%\s*(?:,\s*(\d*\.?\d+)\s*)?$/.exec(a))return i(s[4]),this.setHSL(parseFloat(s[1])/360,parseFloat(s[2])/100,parseFloat(s[3])/100,e);break;default:console.warn("THREE.Color: Unknown color model "+t)}}else if(r=/^\#([A-Fa-f\d]+)$/.exec(t)){const i=r[1],s=i.length;if(3===s)return this.setRGB(parseInt(i.charAt(0),16)/15,parseInt(i.charAt(1),16)/15,parseInt(i.charAt(2),16)/15,e);if(6===s)return this.setHex(parseInt(i,16),e);console.warn("THREE.Color: Invalid hex color "+t)}else if(t&&t.length>0)return this.setColorName(t,e);return this}setColorName(t,e="srgb"){const i=_colorKeywords[t.toLowerCase()];return void 0!==i?this.setHex(i,e):console.warn("THREE.Color: Unknown color "+t),this}clone(){return new this.constructor(this.r,this.g,this.b)}copy(t){return this.r=t.r,this.g=t.g,this.b=t.b,this}copySRGBToLinear(t){return this.r=SRGBToLinear(t.r),this.g=SRGBToLinear(t.g),this.b=SRGBToLinear(t.b),this}copyLinearToSRGB(t){return this.r=LinearToSRGB(t.r),this.g=LinearToSRGB(t.g),this.b=LinearToSRGB(t.b),this}convertSRGBToLinear(){return this.copySRGBToLinear(this),this}convertLinearToSRGB(){return this.copyLinearToSRGB(this),this}getHex(t="srgb"){return ColorManagement.fromWorkingColorSpace(_color.copy(this),t),65536*Math.round(clamp(255*_color.r,0,255))+256*Math.round(clamp(255*_color.g,0,255))+Math.round(clamp(255*_color.b,0,255))}getHexString(t="srgb"){return("000000"+this.getHex(t).toString(16)).slice(-6)}getHSL(t,e=ColorManagement.workingColorSpace){ColorManagement.fromWorkingColorSpace(_color.copy(this),e);const i=_color.r,r=_color.g,s=_color.b,n=Math.max(i,r,s),a=Math.min(i,r,s);let o,h;const c=(a+n)/2;if(a===n)o=0,h=0;else{const t=n-a;switch(h=c<=.5?t/(n+a):t/(2-n-a),n){case i:o=(r-s)/t+(r<s?6:0);break;case r:o=(s-i)/t+2;break;case s:o=(i-r)/t+4}o/=6}return t.h=o,t.s=h,t.l=c,t}getRGB(t,e=ColorManagement.workingColorSpace){return ColorManagement.fromWorkingColorSpace(_color.copy(this),e),t.r=_color.r,t.g=_color.g,t.b=_color.b,t}getStyle(t="srgb"){ColorManagement.fromWorkingColorSpace(_color.copy(this),t);const e=_color.r,i=_color.g,r=_color.b;return"srgb"!==t?`color(${t} ${e.toFixed(3)} ${i.toFixed(3)} ${r.toFixed(3)})`:`rgb(${Math.round(255*e)},${Math.round(255*i)},${Math.round(255*r)})`}offsetHSL(t,e,i){return this.getHSL(_hslA),this.setHSL(_hslA.h+t,_hslA.s+e,_hslA.l+i)}add(t){return this.r+=t.r,this.g+=t.g,this.b+=t.b,this}addColors(t,e){return this.r=t.r+e.r,this.g=t.g+e.g,this.b=t.b+e.b,this}addScalar(t){return this.r+=t,this.g+=t,this.b+=t,this}sub(t){return this.r=Math.max(0,this.r-t.r),this.g=Math.max(0,this.g-t.g),this.b=Math.max(0,this.b-t.b),this}multiply(t){return this.r*=t.r,this.g*=t.g,this.b*=t.b,this}multiplyScalar(t){return this.r*=t,this.g*=t,this.b*=t,this}lerp(t,e){return this.r+=(t.r-this.r)*e,this.g+=(t.g-this.g)*e,this.b+=(t.b-this.b)*e,this}lerpColors(t,e,i){return this.r=t.r+(e.r-t.r)*i,this.g=t.g+(e.g-t.g)*i,this.b=t.b+(e.b-t.b)*i,this}lerpHSL(t,e){this.getHSL(_hslA),t.getHSL(_hslB);const i=lerp(_hslA.h,_hslB.h,e),r=lerp(_hslA.s,_hslB.s,e),s=lerp(_hslA.l,_hslB.l,e);return this.setHSL(i,r,s),this}setFromVector3(t){return this.r=t.x,this.g=t.y,this.b=t.z,this}applyMatrix3(t){const e=this.r,i=this.g,r=this.b,s=t.elements;return this.r=s[0]*e+s[3]*i+s[6]*r,this.g=s[1]*e+s[4]*i+s[7]*r,this.b=s[2]*e+s[5]*i+s[8]*r,this}equals(t){return t.r===this.r&&t.g===this.g&&t.b===this.b}fromArray(t,e=0){return this.r=t[e],this.g=t[e+1],this.b=t[e+2],this}toArray(t=[],e=0){return t[e]=this.r,t[e+1]=this.g,t[e+2]=this.b,t}fromBufferAttribute(t,e){return this.r=t.getX(e),this.g=t.getY(e),this.b=t.getZ(e),this}toJSON(){return this.getHex()}*[Symbol.iterator](){yield this.r,yield this.g,yield this.b}}const _color=new Color;Color.NAMES=_colorKeywords;let _materialId=0;class Material extends EventDispatcher{constructor(){super(),this.isMaterial=!0,Object.defineProperty(this,"id",{value:_materialId++}),this.uuid=generateUUID(),this.name="",this.type="Material",this.blending=1,this.side=0,this.vertexColors=!1,this.opacity=1,this.transparent=!1,this.alphaHash=!1,this.blendSrc=204,this.blendDst=205,this.blendEquation=100,this.blendSrcAlpha=null,this.blendDstAlpha=null,this.blendEquationAlpha=null,this.blendColor=new Color(0,0,0),this.blendAlpha=0,this.depthFunc=3,this.depthTest=!0,this.depthWrite=!0,this.stencilWriteMask=255,this.stencilFunc=519,this.stencilRef=0,this.stencilFuncMask=255,this.stencilFail=7680,this.stencilZFail=7680,this.stencilZPass=7680,this.stencilWrite=!1,this.clippingPlanes=null,this.clipIntersection=!1,this.clipShadows=!1,this.shadowSide=null,this.colorWrite=!0,this.precision=null,this.polygonOffset=!1,this.polygonOffsetFactor=0,this.polygonOffsetUnits=0,this.dithering=!1,this.alphaToCoverage=!1,this.premultipliedAlpha=!1,this.forceSinglePass=!1,this.allowOverride=!0,this.visible=!0,this.toneMapped=!0,this.userData={},this.version=0,this._alphaTest=0}get alphaTest(){return this._alphaTest}set alphaTest(t){this._alphaTest>0!=t>0&&this.version++,this._alphaTest=t}onBeforeRender(){}onBeforeCompile(){}customProgramCacheKey(){return this.onBeforeCompile.toString()}setValues(t){if(void 0!==t)for(const e in t){const i=t[e];if(void 0===i){console.warn(`THREE.Material: parameter '${e}' has value of undefined.`);continue}const r=this[e];void 0!==r?r&&r.isColor?r.set(i):r&&r.isVector3&&i&&i.isVector3?r.copy(i):this[e]=i:console.warn(`THREE.Material: '${e}' is not a property of THREE.${this.type}.`)}}toJSON(t){const e=void 0===t||"string"==typeof t;e&&(t={textures:{},images:{}});const i={metadata:{version:4.6,type:"Material",generator:"Material.toJSON"}};function r(t){const e=[];for(const i in t){const r=t[i];delete r.metadata,e.push(r)}return e}if(i.uuid=this.uuid,i.type=this.type,""!==this.name&&(i.name=this.name),this.color&&this.color.isColor&&(i.color=this.color.getHex()),void 0!==this.roughness&&(i.roughness=this.roughness),void 0!==this.metalness&&(i.metalness=this.metalness),void 0!==this.sheen&&(i.sheen=this.sheen),this.sheenColor&&this.sheenColor.isColor&&(i.sheenColor=this.sheenColor.getHex()),void 0!==this.sheenRoughness&&(i.sheenRoughness=this.sheenRoughness),this.emissive&&this.emissive.isColor&&(i.emissive=this.emissive.getHex()),void 0!==this.emissiveIntensity&&1!==this.emissiveIntensity&&(i.emissiveIntensity=this.emissiveIntensity),this.specular&&this.specular.isColor&&(i.specular=this.specular.getHex()),void 0!==this.specularIntensity&&(i.specularIntensity=this.specularIntensity),this.specularColor&&this.specularColor.isColor&&(i.specularColor=this.specularColor.getHex()),void 0!==this.shininess&&(i.shininess=this.shininess),void 0!==this.clearcoat&&(i.clearcoat=this.clearcoat),void 0!==this.clearcoatRoughness&&(i.clearcoatRoughness=this.clearcoatRoughness),this.clearcoatMap&&this.clearcoatMap.isTexture&&(i.clearcoatMap=this.clearcoatMap.toJSON(t).uuid),this.clearcoatRoughnessMap&&this.clearcoatRoughnessMap.isTexture&&(i.clearcoatRoughnessMap=this.clearcoatRoughnessMap.toJSON(t).uuid),this.clearcoatNormalMap&&this.clearcoatNormalMap.isTexture&&(i.clearcoatNormalMap=this.clearcoatNormalMap.toJSON(t).uuid,i.clearcoatNormalScale=this.clearcoatNormalScale.toArray()),void 0!==this.dispersion&&(i.dispersion=this.dispersion),void 0!==this.iridescence&&(i.iridescence=this.iridescence),void 0!==this.iridescenceIOR&&(i.iridescenceIOR=this.iridescenceIOR),void 0!==this.iridescenceThicknessRange&&(i.iridescenceThicknessRange=this.iridescenceThicknessRange),this.iridescenceMap&&this.iridescenceMap.isTexture&&(i.iridescenceMap=this.iridescenceMap.toJSON(t).uuid),this.iridescenceThicknessMap&&this.iridescenceThicknessMap.isTexture&&(i.iridescenceThicknessMap=this.iridescenceThicknessMap.toJSON(t).uuid),void 0!==this.anisotropy&&(i.anisotropy=this.anisotropy),void 0!==this.anisotropyRotation&&(i.anisotropyRotation=this.anisotropyRotation),this.anisotropyMap&&this.anisotropyMap.isTexture&&(i.anisotropyMap=this.anisotropyMap.toJSON(t).uuid),this.map&&this.map.isTexture&&(i.map=this.map.toJSON(t).uuid),this.matcap&&this.matcap.isTexture&&(i.matcap=this.matcap.toJSON(t).uuid),this.alphaMap&&this.alphaMap.isTexture&&(i.alphaMap=this.alphaMap.toJSON(t).uuid),this.lightMap&&this.lightMap.isTexture&&(i.lightMap=this.lightMap.toJSON(t).uuid,i.lightMapIntensity=this.lightMapIntensity),this.aoMap&&this.aoMap.isTexture&&(i.aoMap=this.aoMap.toJSON(t).uuid,i.aoMapIntensity=this.aoMapIntensity),this.bumpMap&&this.bumpMap.isTexture&&(i.bumpMap=this.bumpMap.toJSON(t).uuid,i.bumpScale=this.bumpScale),this.normalMap&&this.normalMap.isTexture&&(i.normalMap=this.normalMap.toJSON(t).uuid,i.normalMapType=this.normalMapType,i.normalScale=this.normalScale.toArray()),this.displacementMap&&this.displacementMap.isTexture&&(i.displacementMap=this.displacementMap.toJSON(t).uuid,i.displacementScale=this.displacementScale,i.displacementBias=this.displacementBias),this.roughnessMap&&this.roughnessMap.isTexture&&(i.roughnessMap=this.roughnessMap.toJSON(t).uuid),this.metalnessMap&&this.metalnessMap.isTexture&&(i.metalnessMap=this.metalnessMap.toJSON(t).uuid),this.emissiveMap&&this.emissiveMap.isTexture&&(i.emissiveMap=this.emissiveMap.toJSON(t).uuid),this.specularMap&&this.specularMap.isTexture&&(i.specularMap=this.specularMap.toJSON(t).uuid),this.specularIntensityMap&&this.specularIntensityMap.isTexture&&(i.specularIntensityMap=this.specularIntensityMap.toJSON(t).uuid),this.specularColorMap&&this.specularColorMap.isTexture&&(i.specularColorMap=this.specularColorMap.toJSON(t).uuid),this.envMap&&this.envMap.isTexture&&(i.envMap=this.envMap.toJSON(t).uuid,void 0!==this.combine&&(i.combine=this.combine)),void 0!==this.envMapRotation&&(i.envMapRotation=this.envMapRotation.toArray()),void 0!==this.envMapIntensity&&(i.envMapIntensity=this.envMapIntensity),void 0!==this.reflectivity&&(i.reflectivity=this.reflectivity),void 0!==this.refractionRatio&&(i.refractionRatio=this.refractionRatio),this.gradientMap&&this.gradientMap.isTexture&&(i.gradientMap=this.gradientMap.toJSON(t).uuid),void 0!==this.transmission&&(i.transmission=this.transmission),this.transmissionMap&&this.transmissionMap.isTexture&&(i.transmissionMap=this.transmissionMap.toJSON(t).uuid),void 0!==this.thickness&&(i.thickness=this.thickness),this.thicknessMap&&this.thicknessMap.isTexture&&(i.thicknessMap=this.thicknessMap.toJSON(t).uuid),void 0!==this.attenuationDistance&&this.attenuationDistance!==1/0&&(i.attenuationDistance=this.attenuationDistance),void 0!==this.attenuationColor&&(i.attenuationColor=this.attenuationColor.getHex()),void 0!==this.size&&(i.size=this.size),null!==this.shadowSide&&(i.shadowSide=this.shadowSide),void 0!==this.sizeAttenuation&&(i.sizeAttenuation=this.sizeAttenuation),1!==this.blending&&(i.blending=this.blending),0!==this.side&&(i.side=this.side),!0===this.vertexColors&&(i.vertexColors=!0),this.opacity<1&&(i.opacity=this.opacity),!0===this.transparent&&(i.transparent=!0),204!==this.blendSrc&&(i.blendSrc=this.blendSrc),205!==this.blendDst&&(i.blendDst=this.blendDst),100!==this.blendEquation&&(i.blendEquation=this.blendEquation),null!==this.blendSrcAlpha&&(i.blendSrcAlpha=this.blendSrcAlpha),null!==this.blendDstAlpha&&(i.blendDstAlpha=this.blendDstAlpha),null!==this.blendEquationAlpha&&(i.blendEquationAlpha=this.blendEquationAlpha),this.blendColor&&this.blendColor.isColor&&(i.blendColor=this.blendColor.getHex()),0!==this.blendAlpha&&(i.blendAlpha=this.blendAlpha),3!==this.depthFunc&&(i.depthFunc=this.depthFunc),!1===this.depthTest&&(i.depthTest=this.depthTest),!1===this.depthWrite&&(i.depthWrite=this.depthWrite),!1===this.colorWrite&&(i.colorWrite=this.colorWrite),255!==this.stencilWriteMask&&(i.stencilWriteMask=this.stencilWriteMask),519!==this.stencilFunc&&(i.stencilFunc=this.stencilFunc),0!==this.stencilRef&&(i.stencilRef=this.stencilRef),255!==this.stencilFuncMask&&(i.stencilFuncMask=this.stencilFuncMask),7680!==this.stencilFail&&(i.stencilFail=this.stencilFail),7680!==this.stencilZFail&&(i.stencilZFail=this.stencilZFail),7680!==this.stencilZPass&&(i.stencilZPass=this.stencilZPass),!0===this.stencilWrite&&(i.stencilWrite=this.stencilWrite),void 0!==this.rotation&&0!==this.rotation&&(i.rotation=this.rotation),!0===this.polygonOffset&&(i.polygonOffset=!0),0!==this.polygonOffsetFactor&&(i.polygonOffsetFactor=this.polygonOffsetFactor),0!==this.polygonOffsetUnits&&(i.polygonOffsetUnits=this.polygonOffsetUnits),void 0!==this.linewidth&&1!==this.linewidth&&(i.linewidth=this.linewidth),void 0!==this.dashSize&&(i.dashSize=this.dashSize),void 0!==this.gapSize&&(i.gapSize=this.gapSize),void 0!==this.scale&&(i.scale=this.scale),!0===this.dithering&&(i.dithering=!0),this.alphaTest>0&&(i.alphaTest=this.alphaTest),!0===this.alphaHash&&(i.alphaHash=!0),!0===this.alphaToCoverage&&(i.alphaToCoverage=!0),!0===this.premultipliedAlpha&&(i.premultipliedAlpha=!0),!0===this.forceSinglePass&&(i.forceSinglePass=!0),!0===this.wireframe&&(i.wireframe=!0),this.wireframeLinewidth>1&&(i.wireframeLinewidth=this.wireframeLinewidth),"round"!==this.wireframeLinecap&&(i.wireframeLinecap=this.wireframeLinecap),"round"!==this.wireframeLinejoin&&(i.wireframeLinejoin=this.wireframeLinejoin),!0===this.flatShading&&(i.flatShading=!0),!1===this.visible&&(i.visible=!1),!1===this.toneMapped&&(i.toneMapped=!1),!1===this.fog&&(i.fog=!1),Object.keys(this.userData).length>0&&(i.userData=this.userData),e){const e=r(t.textures),s=r(t.images);e.length>0&&(i.textures=e),s.length>0&&(i.images=s)}return i}clone(){return(new this.constructor).copy(this)}copy(t){this.name=t.name,this.blending=t.blending,this.side=t.side,this.vertexColors=t.vertexColors,this.opacity=t.opacity,this.transparent=t.transparent,this.blendSrc=t.blendSrc,this.blendDst=t.blendDst,this.blendEquation=t.blendEquation,this.blendSrcAlpha=t.blendSrcAlpha,this.blendDstAlpha=t.blendDstAlpha,this.blendEquationAlpha=t.blendEquationAlpha,this.blendColor.copy(t.blendColor),this.blendAlpha=t.blendAlpha,this.depthFunc=t.depthFunc,this.depthTest=t.depthTest,this.depthWrite=t.depthWrite,this.stencilWriteMask=t.stencilWriteMask,this.stencilFunc=t.stencilFunc,this.stencilRef=t.stencilRef,this.stencilFuncMask=t.stencilFuncMask,this.stencilFail=t.stencilFail,this.stencilZFail=t.stencilZFail,this.stencilZPass=t.stencilZPass,this.stencilWrite=t.stencilWrite;const e=t.clippingPlanes;let i=null;if(null!==e){const t=e.length;i=new Array(t);for(let r=0;r!==t;++r)i[r]=e[r].clone()}return this.clippingPlanes=i,this.clipIntersection=t.clipIntersection,this.clipShadows=t.clipShadows,this.shadowSide=t.shadowSide,this.colorWrite=t.colorWrite,this.precision=t.precision,this.polygonOffset=t.polygonOffset,this.polygonOffsetFactor=t.polygonOffsetFactor,this.polygonOffsetUnits=t.polygonOffsetUnits,this.dithering=t.dithering,this.alphaTest=t.alphaTest,this.alphaHash=t.alphaHash,this.alphaToCoverage=t.alphaToCoverage,this.premultipliedAlpha=t.premultipliedAlpha,this.forceSinglePass=t.forceSinglePass,this.visible=t.visible,this.toneMapped=t.toneMapped,this.userData=JSON.parse(JSON.stringify(t.userData)),this}dispose(){this.dispatchEvent({type:"dispose"})}set needsUpdate(t){!0===t&&this.version++}}class MeshBasicMaterial extends Material{constructor(t){super(),this.isMeshBasicMaterial=!0,this.type="MeshBasicMaterial",this.color=new Color(16777215),this.map=null,this.lightMap=null,this.lightMapIntensity=1,this.aoMap=null,this.aoMapIntensity=1,this.specularMap=null,this.alphaMap=null,this.envMap=null,this.envMapRotation=new Euler,this.combine=0,this.reflectivity=1,this.refractionRatio=.98,this.wireframe=!1,this.wireframeLinewidth=1,this.wireframeLinecap="round",this.wireframeLinejoin="round",this.fog=!0,this.setValues(t)}copy(t){return super.copy(t),this.color.copy(t.color),this.map=t.map,this.lightMap=t.lightMap,this.lightMapIntensity=t.lightMapIntensity,this.aoMap=t.aoMap,this.aoMapIntensity=t.aoMapIntensity,this.specularMap=t.specularMap,this.alphaMap=t.alphaMap,this.envMap=t.envMap,this.envMapRotation.copy(t.envMapRotation),this.combine=t.combine,this.reflectivity=t.reflectivity,this.refractionRatio=t.refractionRatio,this.wireframe=t.wireframe,this.wireframeLinewidth=t.wireframeLinewidth,this.wireframeLinecap=t.wireframeLinecap,this.wireframeLinejoin=t.wireframeLinejoin,this.fog=t.fog,this}}const _tables=_generateTables();function _generateTables(){const t=new ArrayBuffer(4),e=new Float32Array(t),i=new Uint32Array(t),r=new Uint32Array(512),s=new Uint32Array(512);for(let t=0;t<256;++t){const e=t-127;e<-27?(r[t]=0,r[256|t]=32768,s[t]=24,s[256|t]=24):e<-14?(r[t]=1024>>-e-14,r[256|t]=1024>>-e-14|32768,s[t]=-e-1,s[256|t]=-e-1):e<=15?(r[t]=e+15<<10,r[256|t]=e+15<<10|32768,s[t]=13,s[256|t]=13):e<128?(r[t]=31744,r[256|t]=64512,s[t]=24,s[256|t]=24):(r[t]=31744,r[256|t]=64512,s[t]=13,s[256|t]=13)}const n=new Uint32Array(2048),a=new Uint32Array(64),o=new Uint32Array(64);for(let t=1;t<1024;++t){let e=t<<13,i=0;for(;!(8388608&e);)e<<=1,i-=8388608;e&=-8388609,i+=947912704,n[t]=e|i}for(let t=1024;t<2048;++t)n[t]=939524096+(t-1024<<13);for(let t=1;t<31;++t)a[t]=t<<23;a[31]=1199570944,a[32]=2147483648;for(let t=33;t<63;++t)a[t]=2147483648+(t-32<<23);a[63]=3347054592;for(let t=1;t<64;++t)32!==t&&(o[t]=1024);return{floatView:e,uint32View:i,baseTable:r,shiftTable:s,mantissaTable:n,exponentTable:a,offsetTable:o}}function toHalfFloat(t){Math.abs(t)>65504&&console.warn("THREE.DataUtils.toHalfFloat(): Value out of range."),t=clamp(t,-65504,65504),_tables.floatView[0]=t;const e=_tables.uint32View[0],i=e>>23&511;return _tables.baseTable[i]+((8388607&e)>>_tables.shiftTable[i])}function fromHalfFloat(t){const e=t>>10;return _tables.uint32View[0]=_tables.mantissaTable[_tables.offsetTable[e]+(1023&t)]+_tables.exponentTable[e],_tables.floatView[0]}class DataUtils{static toHalfFloat(t){return toHalfFloat(t)}static fromHalfFloat(t){return fromHalfFloat(t)}}const _vector$9=new Vector3,_vector2$1=new Vector2;let _id$2=0;class BufferAttribute{constructor(t,e,i=!1){if(Array.isArray(t))throw new TypeError("THREE.BufferAttribute: array should be a Typed Array.");this.isBufferAttribute=!0,Object.defineProperty(this,"id",{value:_id$2++}),this.name="",this.array=t,this.itemSize=e,this.count=void 0!==t?t.length/e:0,this.normalized=i,this.usage=35044,this.updateRanges=[],this.gpuType=1015,this.version=0}onUploadCallback(){}set needsUpdate(t){!0===t&&this.version++}setUsage(t){return this.usage=t,this}addUpdateRange(t,e){this.updateRanges.push({start:t,count:e})}clearUpdateRanges(){this.updateRanges.length=0}copy(t){return this.name=t.name,this.array=new t.array.constructor(t.array),this.itemSize=t.itemSize,this.count=t.count,this.normalized=t.normalized,this.usage=t.usage,this.gpuType=t.gpuType,this}copyAt(t,e,i){t*=this.itemSize,i*=e.itemSize;for(let r=0,s=this.itemSize;r<s;r++)this.array[t+r]=e.array[i+r];return this}copyArray(t){return this.array.set(t),this}applyMatrix3(t){if(2===this.itemSize)for(let e=0,i=this.count;e<i;e++)_vector2$1.fromBufferAttribute(this,e),_vector2$1.applyMatrix3(t),this.setXY(e,_vector2$1.x,_vector2$1.y);else if(3===this.itemSize)for(let e=0,i=this.count;e<i;e++)_vector$9.fromBufferAttribute(this,e),_vector$9.applyMatrix3(t),this.setXYZ(e,_vector$9.x,_vector$9.y,_vector$9.z);return this}applyMatrix4(t){for(let e=0,i=this.count;e<i;e++)_vector$9.fromBufferAttribute(this,e),_vector$9.applyMatrix4(t),this.setXYZ(e,_vector$9.x,_vector$9.y,_vector$9.z);return this}applyNormalMatrix(t){for(let e=0,i=this.count;e<i;e++)_vector$9.fromBufferAttribute(this,e),_vector$9.applyNormalMatrix(t),this.setXYZ(e,_vector$9.x,_vector$9.y,_vector$9.z);return this}transformDirection(t){for(let e=0,i=this.count;e<i;e++)_vector$9.fromBufferAttribute(this,e),_vector$9.transformDirection(t),this.setXYZ(e,_vector$9.x,_vector$9.y,_vector$9.z);return this}set(t,e=0){return this.array.set(t,e),this}getComponent(t,e){let i=this.array[t*this.itemSize+e];return this.normalized&&(i=denormalize(i,this.array)),i}setComponent(t,e,i){return this.normalized&&(i=normalize(i,this.array)),this.array[t*this.itemSize+e]=i,this}getX(t){let e=this.array[t*this.itemSize];return this.normalized&&(e=denormalize(e,this.array)),e}setX(t,e){return this.normalized&&(e=normalize(e,this.array)),this.array[t*this.itemSize]=e,this}getY(t){let e=this.array[t*this.itemSize+1];return this.normalized&&(e=denormalize(e,this.array)),e}setY(t,e){return this.normalized&&(e=normalize(e,this.array)),this.array[t*this.itemSize+1]=e,this}getZ(t){let e=this.array[t*this.itemSize+2];return this.normalized&&(e=denormalize(e,this.array)),e}setZ(t,e){return this.normalized&&(e=normalize(e,this.array)),this.array[t*this.itemSize+2]=e,this}getW(t){let e=this.array[t*this.itemSize+3];return this.normalized&&(e=denormalize(e,this.array)),e}setW(t,e){return this.normalized&&(e=normalize(e,this.array)),this.array[t*this.itemSize+3]=e,this}setXY(t,e,i){return t*=this.itemSize,this.normalized&&(e=normalize(e,this.array),i=normalize(i,this.array)),this.array[t+0]=e,this.array[t+1]=i,this}setXYZ(t,e,i,r){return t*=this.itemSize,this.normalized&&(e=normalize(e,this.array),i=normalize(i,this.array),r=normalize(r,this.array)),this.array[t+0]=e,this.array[t+1]=i,this.array[t+2]=r,this}setXYZW(t,e,i,r,s){return t*=this.itemSize,this.normalized&&(e=normalize(e,this.array),i=normalize(i,this.array),r=normalize(r,this.array),s=normalize(s,this.array)),this.array[t+0]=e,this.array[t+1]=i,this.array[t+2]=r,this.array[t+3]=s,this}onUpload(t){return this.onUploadCallback=t,this}clone(){return new this.constructor(this.array,this.itemSize).copy(this)}toJSON(){const t={itemSize:this.itemSize,type:this.array.constructor.name,array:Array.from(this.array),normalized:this.normalized};return""!==this.name&&(t.name=this.name),35044!==this.usage&&(t.usage=this.usage),t}}class Int8BufferAttribute extends BufferAttribute{constructor(t,e,i){super(new Int8Array(t),e,i)}}class Uint8BufferAttribute extends BufferAttribute{constructor(t,e,i){super(new Uint8Array(t),e,i)}}class Uint8ClampedBufferAttribute extends BufferAttribute{constructor(t,e,i){super(new Uint8ClampedArray(t),e,i)}}class Int16BufferAttribute extends BufferAttribute{constructor(t,e,i){super(new Int16Array(t),e,i)}}class Uint16BufferAttribute extends BufferAttribute{constructor(t,e,i){super(new Uint16Array(t),e,i)}}class Int32BufferAttribute extends BufferAttribute{constructor(t,e,i){super(new Int32Array(t),e,i)}}class Uint32BufferAttribute extends BufferAttribute{constructor(t,e,i){super(new Uint32Array(t),e,i)}}class Float16BufferAttribute extends BufferAttribute{constructor(t,e,i){super(new Uint16Array(t),e,i),this.isFloat16BufferAttribute=!0}getX(t){let e=fromHalfFloat(this.array[t*this.itemSize]);return this.normalized&&(e=denormalize(e,this.array)),e}setX(t,e){return this.normalized&&(e=normalize(e,this.array)),this.array[t*this.itemSize]=toHalfFloat(e),this}getY(t){let e=fromHalfFloat(this.array[t*this.itemSize+1]);return this.normalized&&(e=denormalize(e,this.array)),e}setY(t,e){return this.normalized&&(e=normalize(e,this.array)),this.array[t*this.itemSize+1]=toHalfFloat(e),this}getZ(t){let e=fromHalfFloat(this.array[t*this.itemSize+2]);return this.normalized&&(e=denormalize(e,this.array)),e}setZ(t,e){return this.normalized&&(e=normalize(e,this.array)),this.array[t*this.itemSize+2]=toHalfFloat(e),this}getW(t){let e=fromHalfFloat(this.array[t*this.itemSize+3]);return this.normalized&&(e=denormalize(e,this.array)),e}setW(t,e){return this.normalized&&(e=normalize(e,this.array)),this.array[t*this.itemSize+3]=toHalfFloat(e),this}setXY(t,e,i){return t*=this.itemSize,this.normalized&&(e=normalize(e,this.array),i=normalize(i,this.array)),this.array[t+0]=toHalfFloat(e),this.array[t+1]=toHalfFloat(i),this}setXYZ(t,e,i,r){return t*=this.itemSize,this.normalized&&(e=normalize(e,this.array),i=normalize(i,this.array),r=normalize(r,this.array)),this.array[t+0]=toHalfFloat(e),this.array[t+1]=toHalfFloat(i),this.array[t+2]=toHalfFloat(r),this}setXYZW(t,e,i,r,s){return t*=this.itemSize,this.normalized&&(e=normalize(e,this.array),i=normalize(i,this.array),r=normalize(r,this.array),s=normalize(s,this.array)),this.array[t+0]=toHalfFloat(e),this.array[t+1]=toHalfFloat(i),this.array[t+2]=toHalfFloat(r),this.array[t+3]=toHalfFloat(s),this}}class Float32BufferAttribute extends BufferAttribute{constructor(t,e,i){super(new Float32Array(t),e,i)}}let _id$1=0;const _m1=new Matrix4,_obj=new Object3D,_offset=new Vector3,_box$2=new Box3,_boxMorphTargets=new Box3,_vector$8=new Vector3;class BufferGeometry extends EventDispatcher{constructor(){super(),this.isBufferGeometry=!0,Object.defineProperty(this,"id",{value:_id$1++}),this.uuid=generateUUID(),this.name="",this.type="BufferGeometry",this.index=null,this.indirect=null,this.attributes={},this.morphAttributes={},this.morphTargetsRelative=!1,this.groups=[],this.boundingBox=null,this.boundingSphere=null,this.drawRange={start:0,count:1/0},this.userData={}}getIndex(){return this.index}setIndex(t){return Array.isArray(t)?this.index=new(arrayNeedsUint32(t)?Uint32BufferAttribute:Uint16BufferAttribute)(t,1):this.index=t,this}setIndirect(t){return this.indirect=t,this}getIndirect(){return this.indirect}getAttribute(t){return this.attributes[t]}setAttribute(t,e){return this.attributes[t]=e,this}deleteAttribute(t){return delete this.attributes[t],this}hasAttribute(t){return void 0!==this.attributes[t]}addGroup(t,e,i=0){this.groups.push({start:t,count:e,materialIndex:i})}clearGroups(){this.groups=[]}setDrawRange(t,e){this.drawRange.start=t,this.drawRange.count=e}applyMatrix4(t){const e=this.attributes.position;void 0!==e&&(e.applyMatrix4(t),e.needsUpdate=!0);const i=this.attributes.normal;if(void 0!==i){const e=(new Matrix3).getNormalMatrix(t);i.applyNormalMatrix(e),i.needsUpdate=!0}const r=this.attributes.tangent;return void 0!==r&&(r.transformDirection(t),r.needsUpdate=!0),null!==this.boundingBox&&this.computeBoundingBox(),null!==this.boundingSphere&&this.computeBoundingSphere(),this}applyQuaternion(t){return _m1.makeRotationFromQuaternion(t),this.applyMatrix4(_m1),this}rotateX(t){return _m1.makeRotationX(t),this.applyMatrix4(_m1),this}rotateY(t){return _m1.makeRotationY(t),this.applyMatrix4(_m1),this}rotateZ(t){return _m1.makeRotationZ(t),this.applyMatrix4(_m1),this}translate(t,e,i){return _m1.makeTranslation(t,e,i),this.applyMatrix4(_m1),this}scale(t,e,i){return _m1.makeScale(t,e,i),this.applyMatrix4(_m1),this}lookAt(t){return _obj.lookAt(t),_obj.updateMatrix(),this.applyMatrix4(_obj.matrix),this}center(){return this.computeBoundingBox(),this.boundingBox.getCenter(_offset).negate(),this.translate(_offset.x,_offset.y,_offset.z),this}setFromPoints(t){const e=this.getAttribute("position");if(void 0===e){const e=[];for(let i=0,r=t.length;i<r;i++){const r=t[i];e.push(r.x,r.y,r.z||0)}this.setAttribute("position",new Float32BufferAttribute(e,3))}else{const i=Math.min(t.length,e.count);for(let r=0;r<i;r++){const i=t[r];e.setXYZ(r,i.x,i.y,i.z||0)}t.length>e.count&&console.warn("THREE.BufferGeometry: Buffer size too small for points data. Use .dispose() and create a new geometry."),e.needsUpdate=!0}return this}computeBoundingBox(){null===this.boundingBox&&(this.boundingBox=new Box3);const t=this.attributes.position,e=this.morphAttributes.position;if(t&&t.isGLBufferAttribute)return console.error("THREE.BufferGeometry.computeBoundingBox(): GLBufferAttribute requires a manual bounding box.",this),void this.boundingBox.set(new Vector3(-1/0,-1/0,-1/0),new Vector3(1/0,1/0,1/0));if(void 0!==t){if(this.boundingBox.setFromBufferAttribute(t),e)for(let t=0,i=e.length;t<i;t++){const i=e[t];_box$2.setFromBufferAttribute(i),this.morphTargetsRelative?(_vector$8.addVectors(this.boundingBox.min,_box$2.min),this.boundingBox.expandByPoint(_vector$8),_vector$8.addVectors(this.boundingBox.max,_box$2.max),this.boundingBox.expandByPoint(_vector$8)):(this.boundingBox.expandByPoint(_box$2.min),this.boundingBox.expandByPoint(_box$2.max))}}else this.boundingBox.makeEmpty();(isNaN(this.boundingBox.min.x)||isNaN(this.boundingBox.min.y)||isNaN(this.boundingBox.min.z))&&console.error('THREE.BufferGeometry.computeBoundingBox(): Computed min/max have NaN values. The "position" attribute is likely to have NaN values.',this)}computeBoundingSphere(){null===this.boundingSphere&&(this.boundingSphere=new Sphere);const t=this.attributes.position,e=this.morphAttributes.position;if(t&&t.isGLBufferAttribute)return console.error("THREE.BufferGeometry.computeBoundingSphere(): GLBufferAttribute requires a manual bounding sphere.",this),void this.boundingSphere.set(new Vector3,1/0);if(t){const i=this.boundingSphere.center;if(_box$2.setFromBufferAttribute(t),e)for(let t=0,i=e.length;t<i;t++){const i=e[t];_boxMorphTargets.setFromBufferAttribute(i),this.morphTargetsRelative?(_vector$8.addVectors(_box$2.min,_boxMorphTargets.min),_box$2.expandByPoint(_vector$8),_vector$8.addVectors(_box$2.max,_boxMorphTargets.max),_box$2.expandByPoint(_vector$8)):(_box$2.expandByPoint(_boxMorphTargets.min),_box$2.expandByPoint(_boxMorphTargets.max))}_box$2.getCenter(i);let r=0;for(let e=0,s=t.count;e<s;e++)_vector$8.fromBufferAttribute(t,e),r=Math.max(r,i.distanceToSquared(_vector$8));if(e)for(let s=0,n=e.length;s<n;s++){const n=e[s],a=this.morphTargetsRelative;for(let e=0,s=n.count;e<s;e++)_vector$8.fromBufferAttribute(n,e),a&&(_offset.fromBufferAttribute(t,e),_vector$8.add(_offset)),r=Math.max(r,i.distanceToSquared(_vector$8))}this.boundingSphere.radius=Math.sqrt(r),isNaN(this.boundingSphere.radius)&&console.error('THREE.BufferGeometry.computeBoundingSphere(): Computed radius is NaN. The "position" attribute is likely to have NaN values.',this)}}computeTangents(){const t=this.index,e=this.attributes;if(null===t||void 0===e.position||void 0===e.normal||void 0===e.uv)return void console.error("THREE.BufferGeometry: .computeTangents() failed. Missing required attributes (index, position, normal or uv)");const i=e.position,r=e.normal,s=e.uv;!1===this.hasAttribute("tangent")&&this.setAttribute("tangent",new BufferAttribute(new Float32Array(4*i.count),4));const n=this.getAttribute("tangent"),a=[],o=[];for(let t=0;t<i.count;t++)a[t]=new Vector3,o[t]=new Vector3;const h=new Vector3,c=new Vector3,l=new Vector3,u=new Vector2,p=new Vector2,d=new Vector2,m=new Vector3,y=new Vector3;function f(t,e,r){h.fromBufferAttribute(i,t),c.fromBufferAttribute(i,e),l.fromBufferAttribute(i,r),u.fromBufferAttribute(s,t),p.fromBufferAttribute(s,e),d.fromBufferAttribute(s,r),c.sub(h),l.sub(h),p.sub(u),d.sub(u);const n=1/(p.x*d.y-d.x*p.y);isFinite(n)&&(m.copy(c).multiplyScalar(d.y).addScaledVector(l,-p.y).multiplyScalar(n),y.copy(l).multiplyScalar(p.x).addScaledVector(c,-d.x).multiplyScalar(n),a[t].add(m),a[e].add(m),a[r].add(m),o[t].add(y),o[e].add(y),o[r].add(y))}let g=this.groups;0===g.length&&(g=[{start:0,count:t.count}]);for(let e=0,i=g.length;e<i;++e){const i=g[e],r=i.start;for(let e=r,s=r+i.count;e<s;e+=3)f(t.getX(e+0),t.getX(e+1),t.getX(e+2))}const x=new Vector3,_=new Vector3,v=new Vector3,b=new Vector3;function M(t){v.fromBufferAttribute(r,t),b.copy(v);const e=a[t];x.copy(e),x.sub(v.multiplyScalar(v.dot(e))).normalize(),_.crossVectors(b,e);const i=_.dot(o[t])<0?-1:1;n.setXYZW(t,x.x,x.y,x.z,i)}for(let e=0,i=g.length;e<i;++e){const i=g[e],r=i.start;for(let e=r,s=r+i.count;e<s;e+=3)M(t.getX(e+0)),M(t.getX(e+1)),M(t.getX(e+2))}}computeVertexNormals(){const t=this.index,e=this.getAttribute("position");if(void 0!==e){let i=this.getAttribute("normal");if(void 0===i)i=new BufferAttribute(new Float32Array(3*e.count),3),this.setAttribute("normal",i);else for(let t=0,e=i.count;t<e;t++)i.setXYZ(t,0,0,0);const r=new Vector3,s=new Vector3,n=new Vector3,a=new Vector3,o=new Vector3,h=new Vector3,c=new Vector3,l=new Vector3;if(t)for(let u=0,p=t.count;u<p;u+=3){const p=t.getX(u+0),d=t.getX(u+1),m=t.getX(u+2);r.fromBufferAttribute(e,p),s.fromBufferAttribute(e,d),n.fromBufferAttribute(e,m),c.subVectors(n,s),l.subVectors(r,s),c.cross(l),a.fromBufferAttribute(i,p),o.fromBufferAttribute(i,d),h.fromBufferAttribute(i,m),a.add(c),o.add(c),h.add(c),i.setXYZ(p,a.x,a.y,a.z),i.setXYZ(d,o.x,o.y,o.z),i.setXYZ(m,h.x,h.y,h.z)}else for(let t=0,a=e.count;t<a;t+=3)r.fromBufferAttribute(e,t+0),s.fromBufferAttribute(e,t+1),n.fromBufferAttribute(e,t+2),c.subVectors(n,s),l.subVectors(r,s),c.cross(l),i.setXYZ(t+0,c.x,c.y,c.z),i.setXYZ(t+1,c.x,c.y,c.z),i.setXYZ(t+2,c.x,c.y,c.z);this.normalizeNormals(),i.needsUpdate=!0}}normalizeNormals(){const t=this.attributes.normal;for(let e=0,i=t.count;e<i;e++)_vector$8.fromBufferAttribute(t,e),_vector$8.normalize(),t.setXYZ(e,_vector$8.x,_vector$8.y,_vector$8.z)}toNonIndexed(){function t(t,e){const i=t.array,r=t.itemSize,s=t.normalized,n=new i.constructor(e.length*r);let a=0,o=0;for(let s=0,h=e.length;s<h;s++){a=t.isInterleavedBufferAttribute?e[s]*t.data.stride+t.offset:e[s]*r;for(let t=0;t<r;t++)n[o++]=i[a++]}return new BufferAttribute(n,r,s)}if(null===this.index)return console.warn("THREE.BufferGeometry.toNonIndexed(): BufferGeometry is already non-indexed."),this;const e=new BufferGeometry,i=this.index.array,r=this.attributes;for(const s in r){const n=t(r[s],i);e.setAttribute(s,n)}const s=this.morphAttributes;for(const r in s){const n=[],a=s[r];for(let e=0,r=a.length;e<r;e++){const r=t(a[e],i);n.push(r)}e.morphAttributes[r]=n}e.morphTargetsRelative=this.morphTargetsRelative;const n=this.groups;for(let t=0,i=n.length;t<i;t++){const i=n[t];e.addGroup(i.start,i.count,i.materialIndex)}return e}toJSON(){const t={metadata:{version:4.6,type:"BufferGeometry",generator:"BufferGeometry.toJSON"}};if(t.uuid=this.uuid,t.type=this.type,""!==this.name&&(t.name=this.name),Object.keys(this.userData).length>0&&(t.userData=this.userData),void 0!==this.parameters){const e=this.parameters;for(const i in e)void 0!==e[i]&&(t[i]=e[i]);return t}t.data={attributes:{}};const e=this.index;null!==e&&(t.data.index={type:e.array.constructor.name,array:Array.prototype.slice.call(e.array)});const i=this.attributes;for(const e in i){const r=i[e];t.data.attributes[e]=r.toJSON(t.data)}const r={};let s=!1;for(const e in this.morphAttributes){const i=this.morphAttributes[e],n=[];for(let e=0,r=i.length;e<r;e++){const r=i[e];n.push(r.toJSON(t.data))}n.length>0&&(r[e]=n,s=!0)}s&&(t.data.morphAttributes=r,t.data.morphTargetsRelative=this.morphTargetsRelative);const n=this.groups;n.length>0&&(t.data.groups=JSON.parse(JSON.stringify(n)));const a=this.boundingSphere;return null!==a&&(t.data.boundingSphere={center:a.center.toArray(),radius:a.radius}),t}clone(){return(new this.constructor).copy(this)}copy(t){this.index=null,this.attributes={},this.morphAttributes={},this.groups=[],this.boundingBox=null,this.boundingSphere=null;const e={};this.name=t.name;const i=t.index;null!==i&&this.setIndex(i.clone());const r=t.attributes;for(const t in r){const i=r[t];this.setAttribute(t,i.clone(e))}const s=t.morphAttributes;for(const t in s){const i=[],r=s[t];for(let t=0,s=r.length;t<s;t++)i.push(r[t].clone(e));this.morphAttributes[t]=i}this.morphTargetsRelative=t.morphTargetsRelative;const n=t.groups;for(let t=0,e=n.length;t<e;t++){const e=n[t];this.addGroup(e.start,e.count,e.materialIndex)}const a=t.boundingBox;null!==a&&(this.boundingBox=a.clone());const o=t.boundingSphere;return null!==o&&(this.boundingSphere=o.clone()),this.drawRange.start=t.drawRange.start,this.drawRange.count=t.drawRange.count,this.userData=t.userData,this}dispose(){this.dispatchEvent({type:"dispose"})}}const _inverseMatrix$3=new Matrix4,_ray$3=new Ray,_sphere$6=new Sphere,_sphereHitAt=new Vector3,_vA$1=new Vector3,_vB$1=new Vector3,_vC$1=new Vector3,_tempA=new Vector3,_morphA=new Vector3,_intersectionPoint=new Vector3,_intersectionPointWorld=new Vector3;class Mesh extends Object3D{constructor(t=new BufferGeometry,e=new MeshBasicMaterial){super(),this.isMesh=!0,this.type="Mesh",this.geometry=t,this.material=e,this.morphTargetDictionary=void 0,this.morphTargetInfluences=void 0,this.updateMorphTargets()}copy(t,e){return super.copy(t,e),void 0!==t.morphTargetInfluences&&(this.morphTargetInfluences=t.morphTargetInfluences.slice()),void 0!==t.morphTargetDictionary&&(this.morphTargetDictionary=Object.assign({},t.morphTargetDictionary)),this.material=Array.isArray(t.material)?t.material.slice():t.material,this.geometry=t.geometry,this}updateMorphTargets(){const t=this.geometry.morphAttributes,e=Object.keys(t);if(e.length>0){const i=t[e[0]];if(void 0!==i){this.morphTargetInfluences=[],this.morphTargetDictionary={};for(let t=0,e=i.length;t<e;t++){const e=i[t].name||String(t);this.morphTargetInfluences.push(0),this.morphTargetDictionary[e]=t}}}}getVertexPosition(t,e){const i=this.geometry,r=i.attributes.position,s=i.morphAttributes.position,n=i.morphTargetsRelative;e.fromBufferAttribute(r,t);const a=this.morphTargetInfluences;if(s&&a){_morphA.set(0,0,0);for(let i=0,r=s.length;i<r;i++){const r=a[i],o=s[i];0!==r&&(_tempA.fromBufferAttribute(o,t),n?_morphA.addScaledVector(_tempA,r):_morphA.addScaledVector(_tempA.sub(e),r))}e.add(_morphA)}return e}raycast(t,e){const i=this.geometry,r=this.material,s=this.matrixWorld;if(void 0!==r){if(null===i.boundingSphere&&i.computeBoundingSphere(),_sphere$6.copy(i.boundingSphere),_sphere$6.applyMatrix4(s),_ray$3.copy(t.ray).recast(t.near),!1===_sphere$6.containsPoint(_ray$3.origin)){if(null===_ray$3.intersectSphere(_sphere$6,_sphereHitAt))return;if(_ray$3.origin.distanceToSquared(_sphereHitAt)>(t.far-t.near)**2)return}_inverseMatrix$3.copy(s).invert(),_ray$3.copy(t.ray).applyMatrix4(_inverseMatrix$3),null!==i.boundingBox&&!1===_ray$3.intersectsBox(i.boundingBox)||this._computeIntersections(t,e,_ray$3)}}_computeIntersections(t,e,i){let r;const s=this.geometry,n=this.material,a=s.index,o=s.attributes.position,h=s.attributes.uv,c=s.attributes.uv1,l=s.attributes.normal,u=s.groups,p=s.drawRange;if(null!==a)if(Array.isArray(n))for(let s=0,o=u.length;s<o;s++){const o=u[s],d=n[o.materialIndex];for(let s=Math.max(o.start,p.start),n=Math.min(a.count,Math.min(o.start+o.count,p.start+p.count));s<n;s+=3){r=checkGeometryIntersection(this,d,t,i,h,c,l,a.getX(s),a.getX(s+1),a.getX(s+2)),r&&(r.faceIndex=Math.floor(s/3),r.face.materialIndex=o.materialIndex,e.push(r))}}else{for(let s=Math.max(0,p.start),o=Math.min(a.count,p.start+p.count);s<o;s+=3){r=checkGeometryIntersection(this,n,t,i,h,c,l,a.getX(s),a.getX(s+1),a.getX(s+2)),r&&(r.faceIndex=Math.floor(s/3),e.push(r))}}else if(void 0!==o)if(Array.isArray(n))for(let s=0,a=u.length;s<a;s++){const a=u[s],d=n[a.materialIndex];for(let s=Math.max(a.start,p.start),n=Math.min(o.count,Math.min(a.start+a.count,p.start+p.count));s<n;s+=3){r=checkGeometryIntersection(this,d,t,i,h,c,l,s,s+1,s+2),r&&(r.faceIndex=Math.floor(s/3),r.face.materialIndex=a.materialIndex,e.push(r))}}else{for(let s=Math.max(0,p.start),a=Math.min(o.count,p.start+p.count);s<a;s+=3){r=checkGeometryIntersection(this,n,t,i,h,c,l,s,s+1,s+2),r&&(r.faceIndex=Math.floor(s/3),e.push(r))}}}}function checkIntersection$1(t,e,i,r,s,n,a,o){let h;if(h=1===e.side?r.intersectTriangle(a,n,s,!0,o):r.intersectTriangle(s,n,a,0===e.side,o),null===h)return null;_intersectionPointWorld.copy(o),_intersectionPointWorld.applyMatrix4(t.matrixWorld);const c=i.ray.origin.distanceTo(_intersectionPointWorld);return c<i.near||c>i.far?null:{distance:c,point:_intersectionPointWorld.clone(),object:t}}function checkGeometryIntersection(t,e,i,r,s,n,a,o,h,c){t.getVertexPosition(o,_vA$1),t.getVertexPosition(h,_vB$1),t.getVertexPosition(c,_vC$1);const l=checkIntersection$1(t,e,i,r,_vA$1,_vB$1,_vC$1,_intersectionPoint);if(l){const t=new Vector3;Triangle.getBarycoord(_intersectionPoint,_vA$1,_vB$1,_vC$1,t),s&&(l.uv=Triangle.getInterpolatedAttribute(s,o,h,c,t,new Vector2)),n&&(l.uv1=Triangle.getInterpolatedAttribute(n,o,h,c,t,new Vector2)),a&&(l.normal=Triangle.getInterpolatedAttribute(a,o,h,c,t,new Vector3),l.normal.dot(r.direction)>0&&l.normal.multiplyScalar(-1));const e={a:o,b:h,c,normal:new Vector3,materialIndex:0};Triangle.getNormal(_vA$1,_vB$1,_vC$1,e.normal),l.face=e,l.barycoord=t}return l}class BoxGeometry extends BufferGeometry{constructor(t=1,e=1,i=1,r=1,s=1,n=1){super(),this.type="BoxGeometry",this.parameters={width:t,height:e,depth:i,widthSegments:r,heightSegments:s,depthSegments:n};const a=this;r=Math.floor(r),s=Math.floor(s),n=Math.floor(n);const o=[],h=[],c=[],l=[];let u=0,p=0;function d(t,e,i,r,s,n,d,m,y,f,g){const x=n/y,_=d/f,v=n/2,b=d/2,M=m/2,w=y+1,S=f+1;let A=0,T=0;const C=new Vector3;for(let n=0;n<S;n++){const a=n*_-b;for(let o=0;o<w;o++){const u=o*x-v;C[t]=u*r,C[e]=a*s,C[i]=M,h.push(C.x,C.y,C.z),C[t]=0,C[e]=0,C[i]=m>0?1:-1,c.push(C.x,C.y,C.z),l.push(o/y),l.push(1-n/f),A+=1}}for(let t=0;t<f;t++)for(let e=0;e<y;e++){const i=u+e+w*t,r=u+e+w*(t+1),s=u+(e+1)+w*(t+1),n=u+(e+1)+w*t;o.push(i,r,n),o.push(r,s,n),T+=6}a.addGroup(p,T,g),p+=T,u+=A}d("z","y","x",-1,-1,i,e,t,n,s,0),d("z","y","x",1,-1,i,e,-t,n,s,1),d("x","z","y",1,1,t,i,e,r,n,2),d("x","z","y",1,-1,t,i,-e,r,n,3),d("x","y","z",1,-1,t,e,i,r,s,4),d("x","y","z",-1,-1,t,e,-i,r,s,5),this.setIndex(o),this.setAttribute("position",new Float32BufferAttribute(h,3)),this.setAttribute("normal",new Float32BufferAttribute(c,3)),this.setAttribute("uv",new Float32BufferAttribute(l,2))}copy(t){return super.copy(t),this.parameters=Object.assign({},t.parameters),this}static fromJSON(t){return new BoxGeometry(t.width,t.height,t.depth,t.widthSegments,t.heightSegments,t.depthSegments)}}function cloneUniforms(t){const e={};for(const i in t){e[i]={};for(const r in t[i]){const s=t[i][r];s&&(s.isColor||s.isMatrix3||s.isMatrix4||s.isVector2||s.isVector3||s.isVector4||s.isTexture||s.isQuaternion)?s.isRenderTargetTexture?(console.warn("UniformsUtils: Textures of render targets cannot be cloned via cloneUniforms() or mergeUniforms()."),e[i][r]=null):e[i][r]=s.clone():Array.isArray(s)?e[i][r]=s.slice():e[i][r]=s}}return e}function mergeUniforms(t){const e={};for(let i=0;i<t.length;i++){const r=cloneUniforms(t[i]);for(const t in r)e[t]=r[t]}return e}function cloneUniformsGroups(t){const e=[];for(let i=0;i<t.length;i++)e.push(t[i].clone());return e}function getUnlitUniformColorSpace(t){const e=t.getRenderTarget();return null===e?t.outputColorSpace:!0===e.isXRRenderTarget?e.texture.colorSpace:ColorManagement.workingColorSpace}const UniformsUtils={clone:cloneUniforms,merge:mergeUniforms};var default_vertex="void main() {\n\tgl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}",default_fragment="void main() {\n\tgl_FragColor = vec4( 1.0, 0.0, 0.0, 1.0 );\n}";class ShaderMaterial extends Material{constructor(t){super(),this.isShaderMaterial=!0,this.type="ShaderMaterial",this.defines={},this.uniforms={},this.uniformsGroups=[],this.vertexShader=default_vertex,this.fragmentShader=default_fragment,this.linewidth=1,this.wireframe=!1,this.wireframeLinewidth=1,this.fog=!1,this.lights=!1,this.clipping=!1,this.forceSinglePass=!0,this.extensions={clipCullDistance:!1,multiDraw:!1},this.defaultAttributeValues={color:[1,1,1],uv:[0,0],uv1:[0,0]},this.index0AttributeName=void 0,this.uniformsNeedUpdate=!1,this.glslVersion=null,void 0!==t&&this.setValues(t)}copy(t){return super.copy(t),this.fragmentShader=t.fragmentShader,this.vertexShader=t.vertexShader,this.uniforms=cloneUniforms(t.uniforms),this.uniformsGroups=cloneUniformsGroups(t.uniformsGroups),this.defines=Object.assign({},t.defines),this.wireframe=t.wireframe,this.wireframeLinewidth=t.wireframeLinewidth,this.fog=t.fog,this.lights=t.lights,this.clipping=t.clipping,this.extensions=Object.assign({},t.extensions),this.glslVersion=t.glslVersion,this}toJSON(t){const e=super.toJSON(t);e.glslVersion=this.glslVersion,e.uniforms={};for(const i in this.uniforms){const r=this.uniforms[i].value;r&&r.isTexture?e.uniforms[i]={type:"t",value:r.toJSON(t).uuid}:r&&r.isColor?e.uniforms[i]={type:"c",value:r.getHex()}:r&&r.isVector2?e.uniforms[i]={type:"v2",value:r.toArray()}:r&&r.isVector3?e.uniforms[i]={type:"v3",value:r.toArray()}:r&&r.isVector4?e.uniforms[i]={type:"v4",value:r.toArray()}:r&&r.isMatrix3?e.uniforms[i]={type:"m3",value:r.toArray()}:r&&r.isMatrix4?e.uniforms[i]={type:"m4",value:r.toArray()}:e.uniforms[i]={value:r}}Object.keys(this.defines).length>0&&(e.defines=this.defines),e.vertexShader=this.vertexShader,e.fragmentShader=this.fragmentShader,e.lights=this.lights,e.clipping=this.clipping;const i={};for(const t in this.extensions)!0===this.extensions[t]&&(i[t]=!0);return Object.keys(i).length>0&&(e.extensions=i),e}}class Camera extends Object3D{constructor(){super(),this.isCamera=!0,this.type="Camera",this.matrixWorldInverse=new Matrix4,this.projectionMatrix=new Matrix4,this.projectionMatrixInverse=new Matrix4,this.coordinateSystem=2e3}copy(t,e){return super.copy(t,e),this.matrixWorldInverse.copy(t.matrixWorldInverse),this.projectionMatrix.copy(t.projectionMatrix),this.projectionMatrixInverse.copy(t.projectionMatrixInverse),this.coordinateSystem=t.coordinateSystem,this}getWorldDirection(t){return super.getWorldDirection(t).negate()}updateMatrixWorld(t){super.updateMatrixWorld(t),this.matrixWorldInverse.copy(this.matrixWorld).invert()}updateWorldMatrix(t,e){super.updateWorldMatrix(t,e),this.matrixWorldInverse.copy(this.matrixWorld).invert()}clone(){return(new this.constructor).copy(this)}}const _v3$1=new Vector3,_minTarget=new Vector2,_maxTarget=new Vector2;class PerspectiveCamera extends Camera{constructor(t=50,e=1,i=.1,r=2e3){super(),this.isPerspectiveCamera=!0,this.type="PerspectiveCamera",this.fov=t,this.zoom=1,this.near=i,this.far=r,this.focus=10,this.aspect=e,this.view=null,this.filmGauge=35,this.filmOffset=0,this.updateProjectionMatrix()}copy(t,e){return super.copy(t,e),this.fov=t.fov,this.zoom=t.zoom,this.near=t.near,this.far=t.far,this.focus=t.focus,this.aspect=t.aspect,this.view=null===t.view?null:Object.assign({},t.view),this.filmGauge=t.filmGauge,this.filmOffset=t.filmOffset,this}setFocalLength(t){const e=.5*this.getFilmHeight()/t;this.fov=2*RAD2DEG*Math.atan(e),this.updateProjectionMatrix()}getFocalLength(){const t=Math.tan(.5*DEG2RAD*this.fov);return.5*this.getFilmHeight()/t}getEffectiveFOV(){return 2*RAD2DEG*Math.atan(Math.tan(.5*DEG2RAD*this.fov)/this.zoom)}getFilmWidth(){return this.filmGauge*Math.min(this.aspect,1)}getFilmHeight(){return this.filmGauge/Math.max(this.aspect,1)}getViewBounds(t,e,i){_v3$1.set(-1,-1,.5).applyMatrix4(this.projectionMatrixInverse),e.set(_v3$1.x,_v3$1.y).multiplyScalar(-t/_v3$1.z),_v3$1.set(1,1,.5).applyMatrix4(this.projectionMatrixInverse),i.set(_v3$1.x,_v3$1.y).multiplyScalar(-t/_v3$1.z)}getViewSize(t,e){return this.getViewBounds(t,_minTarget,_maxTarget),e.subVectors(_maxTarget,_minTarget)}setViewOffset(t,e,i,r,s,n){this.aspect=t/e,null===this.view&&(this.view={enabled:!0,fullWidth:1,fullHeight:1,offsetX:0,offsetY:0,width:1,height:1}),this.view.enabled=!0,this.view.fullWidth=t,this.view.fullHeight=e,this.view.offsetX=i,this.view.offsetY=r,this.view.width=s,this.view.height=n,this.updateProjectionMatrix()}clearViewOffset(){null!==this.view&&(this.view.enabled=!1),this.updateProjectionMatrix()}updateProjectionMatrix(){const t=this.near;let e=t*Math.tan(.5*DEG2RAD*this.fov)/this.zoom,i=2*e,r=this.aspect*i,s=-.5*r;const n=this.view;if(null!==this.view&&this.view.enabled){const t=n.fullWidth,a=n.fullHeight;s+=n.offsetX*r/t,e-=n.offsetY*i/a,r*=n.width/t,i*=n.height/a}const a=this.filmOffset;0!==a&&(s+=t*a/this.getFilmWidth()),this.projectionMatrix.makePerspective(s,s+r,e,e-i,t,this.far,this.coordinateSystem),this.projectionMatrixInverse.copy(this.projectionMatrix).invert()}toJSON(t){const e=super.toJSON(t);return e.object.fov=this.fov,e.object.zoom=this.zoom,e.object.near=this.near,e.object.far=this.far,e.object.focus=this.focus,e.object.aspect=this.aspect,null!==this.view&&(e.object.view=Object.assign({},this.view)),e.object.filmGauge=this.filmGauge,e.object.filmOffset=this.filmOffset,e}}const fov=-90,aspect=1;class CubeCamera extends Object3D{constructor(t,e,i){super(),this.type="CubeCamera",this.renderTarget=i,this.coordinateSystem=null,this.activeMipmapLevel=0;const r=new PerspectiveCamera(-90,1,t,e);r.layers=this.layers,this.add(r);const s=new PerspectiveCamera(-90,1,t,e);s.layers=this.layers,this.add(s);const n=new PerspectiveCamera(-90,1,t,e);n.layers=this.layers,this.add(n);const a=new PerspectiveCamera(-90,1,t,e);a.layers=this.layers,this.add(a);const o=new PerspectiveCamera(-90,1,t,e);o.layers=this.layers,this.add(o);const h=new PerspectiveCamera(-90,1,t,e);h.layers=this.layers,this.add(h)}updateCoordinateSystem(){const t=this.coordinateSystem,e=this.children.concat(),[i,r,s,n,a,o]=e;for(const t of e)this.remove(t);if(2e3===t)i.up.set(0,1,0),i.lookAt(1,0,0),r.up.set(0,1,0),r.lookAt(-1,0,0),s.up.set(0,0,-1),s.lookAt(0,1,0),n.up.set(0,0,1),n.lookAt(0,-1,0),a.up.set(0,1,0),a.lookAt(0,0,1),o.up.set(0,1,0),o.lookAt(0,0,-1);else{if(2001!==t)throw new Error("THREE.CubeCamera.updateCoordinateSystem(): Invalid coordinate system: "+t);i.up.set(0,-1,0),i.lookAt(-1,0,0),r.up.set(0,-1,0),r.lookAt(1,0,0),s.up.set(0,0,1),s.lookAt(0,1,0),n.up.set(0,0,-1),n.lookAt(0,-1,0),a.up.set(0,-1,0),a.lookAt(0,0,1),o.up.set(0,-1,0),o.lookAt(0,0,-1)}for(const t of e)this.add(t),t.updateMatrixWorld()}update(t,e){null===this.parent&&this.updateMatrixWorld();const{renderTarget:i,activeMipmapLevel:r}=this;this.coordinateSystem!==t.coordinateSystem&&(this.coordinateSystem=t.coordinateSystem,this.updateCoordinateSystem());const[s,n,a,o,h,c]=this.children,l=t.getRenderTarget(),u=t.getActiveCubeFace(),p=t.getActiveMipmapLevel(),d=t.xr.enabled;t.xr.enabled=!1;const m=i.texture.generateMipmaps;i.texture.generateMipmaps=!1,t.setRenderTarget(i,0,r),t.render(e,s),t.setRenderTarget(i,1,r),t.render(e,n),t.setRenderTarget(i,2,r),t.render(e,a),t.setRenderTarget(i,3,r),t.render(e,o),t.setRenderTarget(i,4,r),t.render(e,h),i.texture.generateMipmaps=m,t.setRenderTarget(i,5,r),t.render(e,c),t.setRenderTarget(l,u,p),t.xr.enabled=d,i.texture.needsPMREMUpdate=!0}}class CubeTexture extends Texture{constructor(t=[],e=301,i,r,s,n,a,o,h,c){super(t,e,i,r,s,n,a,o,h,c),this.isCubeTexture=!0,this.flipY=!1}get images(){return this.image}set images(t){this.image=t}}class WebGLCubeRenderTarget extends WebGLRenderTarget{constructor(t=1,e={}){super(t,t,e),this.isWebGLCubeRenderTarget=!0;const i={width:t,height:t,depth:1},r=[i,i,i,i,i,i];this.texture=new CubeTexture(r,e.mapping,e.wrapS,e.wrapT,e.magFilter,e.minFilter,e.format,e.type,e.anisotropy,e.colorSpace),this.texture.isRenderTargetTexture=!0,this.texture.generateMipmaps=void 0!==e.generateMipmaps&&e.generateMipmaps,this.texture.minFilter=void 0!==e.minFilter?e.minFilter:1006}fromEquirectangularTexture(t,e){this.texture.type=e.type,this.texture.colorSpace=e.colorSpace,this.texture.generateMipmaps=e.generateMipmaps,this.texture.minFilter=e.minFilter,this.texture.magFilter=e.magFilter;const i={uniforms:{tEquirect:{value:null}},vertexShader:"\n\n\t\t\t\tvarying vec3 vWorldDirection;\n\n\t\t\t\tvec3 transformDirection( in vec3 dir, in mat4 matrix ) {\n\n\t\t\t\t\treturn normalize( ( matrix * vec4( dir, 0.0 ) ).xyz );\n\n\t\t\t\t}\n\n\t\t\t\tvoid main() {\n\n\t\t\t\t\tvWorldDirection = transformDirection( position, modelMatrix );\n\n\t\t\t\t\t#include <begin_vertex>\n\t\t\t\t\t#include <project_vertex>\n\n\t\t\t\t}\n\t\t\t",fragmentShader:"\n\n\t\t\t\tuniform sampler2D tEquirect;\n\n\t\t\t\tvarying vec3 vWorldDirection;\n\n\t\t\t\t#include <common>\n\n\t\t\t\tvoid main() {\n\n\t\t\t\t\tvec3 direction = normalize( vWorldDirection );\n\n\t\t\t\t\tvec2 sampleUV = equirectUv( direction );\n\n\t\t\t\t\tgl_FragColor = texture2D( tEquirect, sampleUV );\n\n\t\t\t\t}\n\t\t\t"},r=new BoxGeometry(5,5,5),s=new ShaderMaterial({name:"CubemapFromEquirect",uniforms:cloneUniforms(i.uniforms),vertexShader:i.vertexShader,fragmentShader:i.fragmentShader,side:1,blending:0});s.uniforms.tEquirect.value=e;const n=new Mesh(r,s),a=e.minFilter;1008===e.minFilter&&(e.minFilter=1006);return new CubeCamera(1,10,this).update(t,n),e.minFilter=a,n.geometry.dispose(),n.material.dispose(),this}clear(t,e=!0,i=!0,r=!0){const s=t.getRenderTarget();for(let s=0;s<6;s++)t.setRenderTarget(this,s),t.clear(e,i,r);t.setRenderTarget(s)}}class Group extends Object3D{constructor(){super(),this.isGroup=!0,this.type="Group"}}const _moveEvent={type:"move"};class WebXRController{constructor(){this._targetRay=null,this._grip=null,this._hand=null}getHandSpace(){return null===this._hand&&(this._hand=new Group,this._hand.matrixAutoUpdate=!1,this._hand.visible=!1,this._hand.joints={},this._hand.inputState={pinching:!1}),this._hand}getTargetRaySpace(){return null===this._targetRay&&(this._targetRay=new Group,this._targetRay.matrixAutoUpdate=!1,this._targetRay.visible=!1,this._targetRay.hasLinearVelocity=!1,this._targetRay.linearVelocity=new Vector3,this._targetRay.hasAngularVelocity=!1,this._targetRay.angularVelocity=new Vector3),this._targetRay}getGripSpace(){return null===this._grip&&(this._grip=new Group,this._grip.matrixAutoUpdate=!1,this._grip.visible=!1,this._grip.hasLinearVelocity=!1,this._grip.linearVelocity=new Vector3,this._grip.hasAngularVelocity=!1,this._grip.angularVelocity=new Vector3),this._grip}dispatchEvent(t){return null!==this._targetRay&&this._targetRay.dispatchEvent(t),null!==this._grip&&this._grip.dispatchEvent(t),null!==this._hand&&this._hand.dispatchEvent(t),this}connect(t){if(t&&t.hand){const e=this._hand;if(e)for(const i of t.hand.values())this._getHandJoint(e,i)}return this.dispatchEvent({type:"connected",data:t}),this}disconnect(t){return this.dispatchEvent({type:"disconnected",data:t}),null!==this._targetRay&&(this._targetRay.visible=!1),null!==this._grip&&(this._grip.visible=!1),null!==this._hand&&(this._hand.visible=!1),this}update(t,e,i){let r=null,s=null,n=null;const a=this._targetRay,o=this._grip,h=this._hand;if(t&&"visible-blurred"!==e.session.visibilityState){if(h&&t.hand){n=!0;for(const r of t.hand.values()){const t=e.getJointPose(r,i),s=this._getHandJoint(h,r);null!==t&&(s.matrix.fromArray(t.transform.matrix),s.matrix.decompose(s.position,s.rotation,s.scale),s.matrixWorldNeedsUpdate=!0,s.jointRadius=t.radius),s.visible=null!==t}const r=h.joints["index-finger-tip"],s=h.joints["thumb-tip"],a=r.position.distanceTo(s.position),o=.02,c=.005;h.inputState.pinching&&a>o+c?(h.inputState.pinching=!1,this.dispatchEvent({type:"pinchend",handedness:t.handedness,target:this})):!h.inputState.pinching&&a<=o-c&&(h.inputState.pinching=!0,this.dispatchEvent({type:"pinchstart",handedness:t.handedness,target:this}))}else null!==o&&t.gripSpace&&(s=e.getPose(t.gripSpace,i),null!==s&&(o.matrix.fromArray(s.transform.matrix),o.matrix.decompose(o.position,o.rotation,o.scale),o.matrixWorldNeedsUpdate=!0,s.linearVelocity?(o.hasLinearVelocity=!0,o.linearVelocity.copy(s.linearVelocity)):o.hasLinearVelocity=!1,s.angularVelocity?(o.hasAngularVelocity=!0,o.angularVelocity.copy(s.angularVelocity)):o.hasAngularVelocity=!1));null!==a&&(r=e.getPose(t.targetRaySpace,i),null===r&&null!==s&&(r=s),null!==r&&(a.matrix.fromArray(r.transform.matrix),a.matrix.decompose(a.position,a.rotation,a.scale),a.matrixWorldNeedsUpdate=!0,r.linearVelocity?(a.hasLinearVelocity=!0,a.linearVelocity.copy(r.linearVelocity)):a.hasLinearVelocity=!1,r.angularVelocity?(a.hasAngularVelocity=!0,a.angularVelocity.copy(r.angularVelocity)):a.hasAngularVelocity=!1,this.dispatchEvent(_moveEvent)))}return null!==a&&(a.visible=null!==r),null!==o&&(o.visible=null!==s),null!==h&&(h.visible=null!==n),this}_getHandJoint(t,e){if(void 0===t.joints[e.jointName]){const i=new Group;i.matrixAutoUpdate=!1,i.visible=!1,t.joints[e.jointName]=i,t.add(i)}return t.joints[e.jointName]}}class FogExp2{constructor(t,e=25e-5){this.isFogExp2=!0,this.name="",this.color=new Color(t),this.density=e}clone(){return new FogExp2(this.color,this.density)}toJSON(){return{type:"FogExp2",name:this.name,color:this.color.getHex(),density:this.density}}}class Fog{constructor(t,e=1,i=1e3){this.isFog=!0,this.name="",this.color=new Color(t),this.near=e,this.far=i}clone(){return new Fog(this.color,this.near,this.far)}toJSON(){return{type:"Fog",name:this.name,color:this.color.getHex(),near:this.near,far:this.far}}}class Scene extends Object3D{constructor(){super(),this.isScene=!0,this.type="Scene",this.background=null,this.environment=null,this.fog=null,this.backgroundBlurriness=0,this.backgroundIntensity=1,this.backgroundRotation=new Euler,this.environmentIntensity=1,this.environmentRotation=new Euler,this.overrideMaterial=null,"undefined"!=typeof __THREE_DEVTOOLS__&&__THREE_DEVTOOLS__.dispatchEvent(new CustomEvent("observe",{detail:this}))}copy(t,e){return super.copy(t,e),null!==t.background&&(this.background=t.background.clone()),null!==t.environment&&(this.environment=t.environment.clone()),null!==t.fog&&(this.fog=t.fog.clone()),this.backgroundBlurriness=t.backgroundBlurriness,this.backgroundIntensity=t.backgroundIntensity,this.backgroundRotation.copy(t.backgroundRotation),this.environmentIntensity=t.environmentIntensity,this.environmentRotation.copy(t.environmentRotation),null!==t.overrideMaterial&&(this.overrideMaterial=t.overrideMaterial.clone()),this.matrixAutoUpdate=t.matrixAutoUpdate,this}toJSON(t){const e=super.toJSON(t);return null!==this.fog&&(e.object.fog=this.fog.toJSON()),this.backgroundBlurriness>0&&(e.object.backgroundBlurriness=this.backgroundBlurriness),1!==this.backgroundIntensity&&(e.object.backgroundIntensity=this.backgroundIntensity),e.object.backgroundRotation=this.backgroundRotation.toArray(),1!==this.environmentIntensity&&(e.object.environmentIntensity=this.environmentIntensity),e.object.environmentRotation=this.environmentRotation.toArray(),e}}class InterleavedBuffer{constructor(t,e){this.isInterleavedBuffer=!0,this.array=t,this.stride=e,this.count=void 0!==t?t.length/e:0,this.usage=35044,this.updateRanges=[],this.version=0,this.uuid=generateUUID()}onUploadCallback(){}set needsUpdate(t){!0===t&&this.version++}setUsage(t){return this.usage=t,this}addUpdateRange(t,e){this.updateRanges.push({start:t,count:e})}clearUpdateRanges(){this.updateRanges.length=0}copy(t){return this.array=new t.array.constructor(t.array),this.count=t.count,this.stride=t.stride,this.usage=t.usage,this}copyAt(t,e,i){t*=this.stride,i*=e.stride;for(let r=0,s=this.stride;r<s;r++)this.array[t+r]=e.array[i+r];return this}set(t,e=0){return this.array.set(t,e),this}clone(t){void 0===t.arrayBuffers&&(t.arrayBuffers={}),void 0===this.array.buffer._uuid&&(this.array.buffer._uuid=generateUUID()),void 0===t.arrayBuffers[this.array.buffer._uuid]&&(t.arrayBuffers[this.array.buffer._uuid]=this.array.slice(0).buffer);const e=new this.array.constructor(t.arrayBuffers[this.array.buffer._uuid]),i=new this.constructor(e,this.stride);return i.setUsage(this.usage),i}onUpload(t){return this.onUploadCallback=t,this}toJSON(t){return void 0===t.arrayBuffers&&(t.arrayBuffers={}),void 0===this.array.buffer._uuid&&(this.array.buffer._uuid=generateUUID()),void 0===t.arrayBuffers[this.array.buffer._uuid]&&(t.arrayBuffers[this.array.buffer._uuid]=Array.from(new Uint32Array(this.array.buffer))),{uuid:this.uuid,buffer:this.array.buffer._uuid,type:this.array.constructor.name,stride:this.stride}}}const _vector$7=new Vector3;class InterleavedBufferAttribute{constructor(t,e,i,r=!1){this.isInterleavedBufferAttribute=!0,this.name="",this.data=t,this.itemSize=e,this.offset=i,this.normalized=r}get count(){return this.data.count}get array(){return this.data.array}set needsUpdate(t){this.data.needsUpdate=t}applyMatrix4(t){for(let e=0,i=this.data.count;e<i;e++)_vector$7.fromBufferAttribute(this,e),_vector$7.applyMatrix4(t),this.setXYZ(e,_vector$7.x,_vector$7.y,_vector$7.z);return this}applyNormalMatrix(t){for(let e=0,i=this.count;e<i;e++)_vector$7.fromBufferAttribute(this,e),_vector$7.applyNormalMatrix(t),this.setXYZ(e,_vector$7.x,_vector$7.y,_vector$7.z);return this}transformDirection(t){for(let e=0,i=this.count;e<i;e++)_vector$7.fromBufferAttribute(this,e),_vector$7.transformDirection(t),this.setXYZ(e,_vector$7.x,_vector$7.y,_vector$7.z);return this}getComponent(t,e){let i=this.array[t*this.data.stride+this.offset+e];return this.normalized&&(i=denormalize(i,this.array)),i}setComponent(t,e,i){return this.normalized&&(i=normalize(i,this.array)),this.data.array[t*this.data.stride+this.offset+e]=i,this}setX(t,e){return this.normalized&&(e=normalize(e,this.array)),this.data.array[t*this.data.stride+this.offset]=e,this}setY(t,e){return this.normalized&&(e=normalize(e,this.array)),this.data.array[t*this.data.stride+this.offset+1]=e,this}setZ(t,e){return this.normalized&&(e=normalize(e,this.array)),this.data.array[t*this.data.stride+this.offset+2]=e,this}setW(t,e){return this.normalized&&(e=normalize(e,this.array)),this.data.array[t*this.data.stride+this.offset+3]=e,this}getX(t){let e=this.data.array[t*this.data.stride+this.offset];return this.normalized&&(e=denormalize(e,this.array)),e}getY(t){let e=this.data.array[t*this.data.stride+this.offset+1];return this.normalized&&(e=denormalize(e,this.array)),e}getZ(t){let e=this.data.array[t*this.data.stride+this.offset+2];return this.normalized&&(e=denormalize(e,this.array)),e}getW(t){let e=this.data.array[t*this.data.stride+this.offset+3];return this.normalized&&(e=denormalize(e,this.array)),e}setXY(t,e,i){return t=t*this.data.stride+this.offset,this.normalized&&(e=normalize(e,this.array),i=normalize(i,this.array)),this.data.array[t+0]=e,this.data.array[t+1]=i,this}setXYZ(t,e,i,r){return t=t*this.data.stride+this.offset,this.normalized&&(e=normalize(e,this.array),i=normalize(i,this.array),r=normalize(r,this.array)),this.data.array[t+0]=e,this.data.array[t+1]=i,this.data.array[t+2]=r,this}setXYZW(t,e,i,r,s){return t=t*this.data.stride+this.offset,this.normalized&&(e=normalize(e,this.array),i=normalize(i,this.array),r=normalize(r,this.array),s=normalize(s,this.array)),this.data.array[t+0]=e,this.data.array[t+1]=i,this.data.array[t+2]=r,this.data.array[t+3]=s,this}clone(t){if(void 0===t){console.log("THREE.InterleavedBufferAttribute.clone(): Cloning an interleaved buffer attribute will de-interleave buffer data.");const t=[];for(let e=0;e<this.count;e++){const i=e*this.data.stride+this.offset;for(let e=0;e<this.itemSize;e++)t.push(this.data.array[i+e])}return new BufferAttribute(new this.array.constructor(t),this.itemSize,this.normalized)}return void 0===t.interleavedBuffers&&(t.interleavedBuffers={}),void 0===t.interleavedBuffers[this.data.uuid]&&(t.interleavedBuffers[this.data.uuid]=this.data.clone(t)),new InterleavedBufferAttribute(t.interleavedBuffers[this.data.uuid],this.itemSize,this.offset,this.normalized)}toJSON(t){if(void 0===t){console.log("THREE.InterleavedBufferAttribute.toJSON(): Serializing an interleaved buffer attribute will de-interleave buffer data.");const t=[];for(let e=0;e<this.count;e++){const i=e*this.data.stride+this.offset;for(let e=0;e<this.itemSize;e++)t.push(this.data.array[i+e])}return{itemSize:this.itemSize,type:this.array.constructor.name,array:t,normalized:this.normalized}}return void 0===t.interleavedBuffers&&(t.interleavedBuffers={}),void 0===t.interleavedBuffers[this.data.uuid]&&(t.interleavedBuffers[this.data.uuid]=this.data.toJSON(t)),{isInterleavedBufferAttribute:!0,itemSize:this.itemSize,data:this.data.uuid,offset:this.offset,normalized:this.normalized}}}class SpriteMaterial extends Material{constructor(t){super(),this.isSpriteMaterial=!0,this.type="SpriteMaterial",this.color=new Color(16777215),this.map=null,this.alphaMap=null,this.rotation=0,this.sizeAttenuation=!0,this.transparent=!0,this.fog=!0,this.setValues(t)}copy(t){return super.copy(t),this.color.copy(t.color),this.map=t.map,this.alphaMap=t.alphaMap,this.rotation=t.rotation,this.sizeAttenuation=t.sizeAttenuation,this.fog=t.fog,this}}let _geometry;const _intersectPoint=new Vector3,_worldScale=new Vector3,_mvPosition=new Vector3,_alignedPosition=new Vector2,_rotatedPosition=new Vector2,_viewWorldMatrix=new Matrix4,_vA=new Vector3,_vB=new Vector3,_vC=new Vector3,_uvA=new Vector2,_uvB=new Vector2,_uvC=new Vector2;class Sprite extends Object3D{constructor(t=new SpriteMaterial){if(super(),this.isSprite=!0,this.type="Sprite",void 0===_geometry){_geometry=new BufferGeometry;const t=new Float32Array([-.5,-.5,0,0,0,.5,-.5,0,1,0,.5,.5,0,1,1,-.5,.5,0,0,1]),e=new InterleavedBuffer(t,5);_geometry.setIndex([0,1,2,0,2,3]),_geometry.setAttribute("position",new InterleavedBufferAttribute(e,3,0,!1)),_geometry.setAttribute("uv",new InterleavedBufferAttribute(e,2,3,!1))}this.geometry=_geometry,this.material=t,this.center=new Vector2(.5,.5)}raycast(t,e){null===t.camera&&console.error('THREE.Sprite: "Raycaster.camera" needs to be set in order to raycast against sprites.'),_worldScale.setFromMatrixScale(this.matrixWorld),_viewWorldMatrix.copy(t.camera.matrixWorld),this.modelViewMatrix.multiplyMatrices(t.camera.matrixWorldInverse,this.matrixWorld),_mvPosition.setFromMatrixPosition(this.modelViewMatrix),t.camera.isPerspectiveCamera&&!1===this.material.sizeAttenuation&&_worldScale.multiplyScalar(-_mvPosition.z);const i=this.material.rotation;let r,s;0!==i&&(s=Math.cos(i),r=Math.sin(i));const n=this.center;transformVertex(_vA.set(-.5,-.5,0),_mvPosition,n,_worldScale,r,s),transformVertex(_vB.set(.5,-.5,0),_mvPosition,n,_worldScale,r,s),transformVertex(_vC.set(.5,.5,0),_mvPosition,n,_worldScale,r,s),_uvA.set(0,0),_uvB.set(1,0),_uvC.set(1,1);let a=t.ray.intersectTriangle(_vA,_vB,_vC,!1,_intersectPoint);if(null===a&&(transformVertex(_vB.set(-.5,.5,0),_mvPosition,n,_worldScale,r,s),_uvB.set(0,1),a=t.ray.intersectTriangle(_vA,_vC,_vB,!1,_intersectPoint),null===a))return;const o=t.ray.origin.distanceTo(_intersectPoint);o<t.near||o>t.far||e.push({distance:o,point:_intersectPoint.clone(),uv:Triangle.getInterpolation(_intersectPoint,_vA,_vB,_vC,_uvA,_uvB,_uvC,new Vector2),face:null,object:this})}copy(t,e){return super.copy(t,e),void 0!==t.center&&this.center.copy(t.center),this.material=t.material,this}}function transformVertex(t,e,i,r,s,n){_alignedPosition.subVectors(t,i).addScalar(.5).multiply(r),void 0!==s?(_rotatedPosition.x=n*_alignedPosition.x-s*_alignedPosition.y,_rotatedPosition.y=s*_alignedPosition.x+n*_alignedPosition.y):_rotatedPosition.copy(_alignedPosition),t.copy(e),t.x+=_rotatedPosition.x,t.y+=_rotatedPosition.y,t.applyMatrix4(_viewWorldMatrix)}const _v1$2=new Vector3,_v2$1=new Vector3;class LOD extends Object3D{constructor(){super(),this.isLOD=!0,this._currentLevel=0,this.type="LOD",Object.defineProperties(this,{levels:{enumerable:!0,value:[]}}),this.autoUpdate=!0}copy(t){super.copy(t,!1);const e=t.levels;for(let t=0,i=e.length;t<i;t++){const i=e[t];this.addLevel(i.object.clone(),i.distance,i.hysteresis)}return this.autoUpdate=t.autoUpdate,this}addLevel(t,e=0,i=0){e=Math.abs(e);const r=this.levels;let s;for(s=0;s<r.length&&!(e<r[s].distance);s++);return r.splice(s,0,{distance:e,hysteresis:i,object:t}),this.add(t),this}removeLevel(t){const e=this.levels;for(let i=0;i<e.length;i++)if(e[i].distance===t){const t=e.splice(i,1);return this.remove(t[0].object),!0}return!1}getCurrentLevel(){return this._currentLevel}getObjectForDistance(t){const e=this.levels;if(e.length>0){let i,r;for(i=1,r=e.length;i<r;i++){let r=e[i].distance;if(e[i].object.visible&&(r-=r*e[i].hysteresis),t<r)break}return e[i-1].object}return null}raycast(t,e){if(this.levels.length>0){_v1$2.setFromMatrixPosition(this.matrixWorld);const i=t.ray.origin.distanceTo(_v1$2);this.getObjectForDistance(i).raycast(t,e)}}update(t){const e=this.levels;if(e.length>1){_v1$2.setFromMatrixPosition(t.matrixWorld),_v2$1.setFromMatrixPosition(this.matrixWorld);const i=_v1$2.distanceTo(_v2$1)/t.zoom;let r,s;for(e[0].object.visible=!0,r=1,s=e.length;r<s;r++){let t=e[r].distance;if(e[r].object.visible&&(t-=t*e[r].hysteresis),!(i>=t))break;e[r-1].object.visible=!1,e[r].object.visible=!0}for(this._currentLevel=r-1;r<s;r++)e[r].object.visible=!1}}toJSON(t){const e=super.toJSON(t);!1===this.autoUpdate&&(e.object.autoUpdate=!1),e.object.levels=[];const i=this.levels;for(let t=0,r=i.length;t<r;t++){const r=i[t];e.object.levels.push({object:r.object.uuid,distance:r.distance,hysteresis:r.hysteresis})}return e}}const _basePosition=new Vector3,_skinIndex=new Vector4,_skinWeight=new Vector4,_vector3=new Vector3,_matrix4=new Matrix4,_vertex=new Vector3,_sphere$5=new Sphere,_inverseMatrix$2=new Matrix4,_ray$2=new Ray;class SkinnedMesh extends Mesh{constructor(t,e){super(t,e),this.isSkinnedMesh=!0,this.type="SkinnedMesh",this.bindMode="attached",this.bindMatrix=new Matrix4,this.bindMatrixInverse=new Matrix4,this.boundingBox=null,this.boundingSphere=null}computeBoundingBox(){const t=this.geometry;null===this.boundingBox&&(this.boundingBox=new Box3),this.boundingBox.makeEmpty();const e=t.getAttribute("position");for(let t=0;t<e.count;t++)this.getVertexPosition(t,_vertex),this.boundingBox.expandByPoint(_vertex)}computeBoundingSphere(){const t=this.geometry;null===this.boundingSphere&&(this.boundingSphere=new Sphere),this.boundingSphere.makeEmpty();const e=t.getAttribute("position");for(let t=0;t<e.count;t++)this.getVertexPosition(t,_vertex),this.boundingSphere.expandByPoint(_vertex)}copy(t,e){return super.copy(t,e),this.bindMode=t.bindMode,this.bindMatrix.copy(t.bindMatrix),this.bindMatrixInverse.copy(t.bindMatrixInverse),this.skeleton=t.skeleton,null!==t.boundingBox&&(this.boundingBox=t.boundingBox.clone()),null!==t.boundingSphere&&(this.boundingSphere=t.boundingSphere.clone()),this}raycast(t,e){const i=this.material,r=this.matrixWorld;void 0!==i&&(null===this.boundingSphere&&this.computeBoundingSphere(),_sphere$5.copy(this.boundingSphere),_sphere$5.applyMatrix4(r),!1!==t.ray.intersectsSphere(_sphere$5)&&(_inverseMatrix$2.copy(r).invert(),_ray$2.copy(t.ray).applyMatrix4(_inverseMatrix$2),null!==this.boundingBox&&!1===_ray$2.intersectsBox(this.boundingBox)||this._computeIntersections(t,e,_ray$2)))}getVertexPosition(t,e){return super.getVertexPosition(t,e),this.applyBoneTransform(t,e),e}bind(t,e){this.skeleton=t,void 0===e&&(this.updateMatrixWorld(!0),this.skeleton.calculateInverses(),e=this.matrixWorld),this.bindMatrix.copy(e),this.bindMatrixInverse.copy(e).invert()}pose(){this.skeleton.pose()}normalizeSkinWeights(){const t=new Vector4,e=this.geometry.attributes.skinWeight;for(let i=0,r=e.count;i<r;i++){t.fromBufferAttribute(e,i);const r=1/t.manhattanLength();r!==1/0?t.multiplyScalar(r):t.set(1,0,0,0),e.setXYZW(i,t.x,t.y,t.z,t.w)}}updateMatrixWorld(t){super.updateMatrixWorld(t),"attached"===this.bindMode?this.bindMatrixInverse.copy(this.matrixWorld).invert():"detached"===this.bindMode?this.bindMatrixInverse.copy(this.bindMatrix).invert():console.warn("THREE.SkinnedMesh: Unrecognized bindMode: "+this.bindMode)}applyBoneTransform(t,e){const i=this.skeleton,r=this.geometry;_skinIndex.fromBufferAttribute(r.attributes.skinIndex,t),_skinWeight.fromBufferAttribute(r.attributes.skinWeight,t),_basePosition.copy(e).applyMatrix4(this.bindMatrix),e.set(0,0,0);for(let t=0;t<4;t++){const r=_skinWeight.getComponent(t);if(0!==r){const s=_skinIndex.getComponent(t);_matrix4.multiplyMatrices(i.bones[s].matrixWorld,i.boneInverses[s]),e.addScaledVector(_vector3.copy(_basePosition).applyMatrix4(_matrix4),r)}}return e.applyMatrix4(this.bindMatrixInverse)}}class Bone extends Object3D{constructor(){super(),this.isBone=!0,this.type="Bone"}}class DataTexture extends Texture{constructor(t=null,e=1,i=1,r,s,n,a,o,h=1003,c=1003,l,u){super(null,n,a,o,h,c,r,s,l,u),this.isDataTexture=!0,this.image={data:t,width:e,height:i},this.generateMipmaps=!1,this.flipY=!1,this.unpackAlignment=1}}const _offsetMatrix=new Matrix4,_identityMatrix=new Matrix4;class Skeleton{constructor(t=[],e=[]){this.uuid=generateUUID(),this.bones=t.slice(0),this.boneInverses=e,this.boneMatrices=null,this.boneTexture=null,this.init()}init(){const t=this.bones,e=this.boneInverses;if(this.boneMatrices=new Float32Array(16*t.length),0===e.length)this.calculateInverses();else if(t.length!==e.length){console.warn("THREE.Skeleton: Number of inverse bone matrices does not match amount of bones."),this.boneInverses=[];for(let t=0,e=this.bones.length;t<e;t++)this.boneInverses.push(new Matrix4)}}calculateInverses(){this.boneInverses.length=0;for(let t=0,e=this.bones.length;t<e;t++){const e=new Matrix4;this.bones[t]&&e.copy(this.bones[t].matrixWorld).invert(),this.boneInverses.push(e)}}pose(){for(let t=0,e=this.bones.length;t<e;t++){const e=this.bones[t];e&&e.matrixWorld.copy(this.boneInverses[t]).invert()}for(let t=0,e=this.bones.length;t<e;t++){const e=this.bones[t];e&&(e.parent&&e.parent.isBone?(e.matrix.copy(e.parent.matrixWorld).invert(),e.matrix.multiply(e.matrixWorld)):e.matrix.copy(e.matrixWorld),e.matrix.decompose(e.position,e.quaternion,e.scale))}}update(){const t=this.bones,e=this.boneInverses,i=this.boneMatrices,r=this.boneTexture;for(let r=0,s=t.length;r<s;r++){const s=t[r]?t[r].matrixWorld:_identityMatrix;_offsetMatrix.multiplyMatrices(s,e[r]),_offsetMatrix.toArray(i,16*r)}null!==r&&(r.needsUpdate=!0)}clone(){return new Skeleton(this.bones,this.boneInverses)}computeBoneTexture(){let t=Math.sqrt(4*this.bones.length);t=4*Math.ceil(t/4),t=Math.max(t,4);const e=new Float32Array(t*t*4);e.set(this.boneMatrices);const i=new DataTexture(e,t,t,1023,1015);return i.needsUpdate=!0,this.boneMatrices=e,this.boneTexture=i,this}getBoneByName(t){for(let e=0,i=this.bones.length;e<i;e++){const i=this.bones[e];if(i.name===t)return i}}dispose(){null!==this.boneTexture&&(this.boneTexture.dispose(),this.boneTexture=null)}fromJSON(t,e){this.uuid=t.uuid;for(let i=0,r=t.bones.length;i<r;i++){const r=t.bones[i];let s=e[r];void 0===s&&(console.warn("THREE.Skeleton: No bone found with UUID:",r),s=new Bone),this.bones.push(s),this.boneInverses.push((new Matrix4).fromArray(t.boneInverses[i]))}return this.init(),this}toJSON(){const t={metadata:{version:4.6,type:"Skeleton",generator:"Skeleton.toJSON"},bones:[],boneInverses:[]};t.uuid=this.uuid;const e=this.bones,i=this.boneInverses;for(let r=0,s=e.length;r<s;r++){const s=e[r];t.bones.push(s.uuid);const n=i[r];t.boneInverses.push(n.toArray())}return t}}class InstancedBufferAttribute extends BufferAttribute{constructor(t,e,i,r=1){super(t,e,i),this.isInstancedBufferAttribute=!0,this.meshPerAttribute=r}copy(t){return super.copy(t),this.meshPerAttribute=t.meshPerAttribute,this}toJSON(){const t=super.toJSON();return t.meshPerAttribute=this.meshPerAttribute,t.isInstancedBufferAttribute=!0,t}}const _instanceLocalMatrix=new Matrix4,_instanceWorldMatrix=new Matrix4,_instanceIntersects=[],_box3=new Box3,_identity=new Matrix4,_mesh$1=new Mesh,_sphere$4=new Sphere;class InstancedMesh extends Mesh{constructor(t,e,i){super(t,e),this.isInstancedMesh=!0,this.instanceMatrix=new InstancedBufferAttribute(new Float32Array(16*i),16),this.instanceColor=null,this.morphTexture=null,this.count=i,this.boundingBox=null,this.boundingSphere=null;for(let t=0;t<i;t++)this.setMatrixAt(t,_identity)}computeBoundingBox(){const t=this.geometry,e=this.count;null===this.boundingBox&&(this.boundingBox=new Box3),null===t.boundingBox&&t.computeBoundingBox(),this.boundingBox.makeEmpty();for(let i=0;i<e;i++)this.getMatrixAt(i,_instanceLocalMatrix),_box3.copy(t.boundingBox).applyMatrix4(_instanceLocalMatrix),this.boundingBox.union(_box3)}computeBoundingSphere(){const t=this.geometry,e=this.count;null===this.boundingSphere&&(this.boundingSphere=new Sphere),null===t.boundingSphere&&t.computeBoundingSphere(),this.boundingSphere.makeEmpty();for(let i=0;i<e;i++)this.getMatrixAt(i,_instanceLocalMatrix),_sphere$4.copy(t.boundingSphere).applyMatrix4(_instanceLocalMatrix),this.boundingSphere.union(_sphere$4)}copy(t,e){return super.copy(t,e),this.instanceMatrix.copy(t.instanceMatrix),null!==t.morphTexture&&(this.morphTexture=t.morphTexture.clone()),null!==t.instanceColor&&(this.instanceColor=t.instanceColor.clone()),this.count=t.count,null!==t.boundingBox&&(this.boundingBox=t.boundingBox.clone()),null!==t.boundingSphere&&(this.boundingSphere=t.boundingSphere.clone()),this}getColorAt(t,e){e.fromArray(this.instanceColor.array,3*t)}getMatrixAt(t,e){e.fromArray(this.instanceMatrix.array,16*t)}getMorphAt(t,e){const i=e.morphTargetInfluences,r=this.morphTexture.source.data.data,s=t*(i.length+1)+1;for(let t=0;t<i.length;t++)i[t]=r[s+t]}raycast(t,e){const i=this.matrixWorld,r=this.count;if(_mesh$1.geometry=this.geometry,_mesh$1.material=this.material,void 0!==_mesh$1.material&&(null===this.boundingSphere&&this.computeBoundingSphere(),_sphere$4.copy(this.boundingSphere),_sphere$4.applyMatrix4(i),!1!==t.ray.intersectsSphere(_sphere$4)))for(let s=0;s<r;s++){this.getMatrixAt(s,_instanceLocalMatrix),_instanceWorldMatrix.multiplyMatrices(i,_instanceLocalMatrix),_mesh$1.matrixWorld=_instanceWorldMatrix,_mesh$1.raycast(t,_instanceIntersects);for(let t=0,i=_instanceIntersects.length;t<i;t++){const i=_instanceIntersects[t];i.instanceId=s,i.object=this,e.push(i)}_instanceIntersects.length=0}}setColorAt(t,e){null===this.instanceColor&&(this.instanceColor=new InstancedBufferAttribute(new Float32Array(3*this.instanceMatrix.count).fill(1),3)),e.toArray(this.instanceColor.array,3*t)}setMatrixAt(t,e){e.toArray(this.instanceMatrix.array,16*t)}setMorphAt(t,e){const i=e.morphTargetInfluences,r=i.length+1;null===this.morphTexture&&(this.morphTexture=new DataTexture(new Float32Array(r*this.count),r,this.count,1028,1015));const s=this.morphTexture.source.data.data;let n=0;for(let t=0;t<i.length;t++)n+=i[t];const a=this.geometry.morphTargetsRelative?1:1-n,o=r*t;s[o]=a,s.set(i,o+1)}updateMorphTargets(){}dispose(){this.dispatchEvent({type:"dispose"}),null!==this.morphTexture&&(this.morphTexture.dispose(),this.morphTexture=null)}}const _vector1=new Vector3,_vector2=new Vector3,_normalMatrix=new Matrix3;class Plane{constructor(t=new Vector3(1,0,0),e=0){this.isPlane=!0,this.normal=t,this.constant=e}set(t,e){return this.normal.copy(t),this.constant=e,this}setComponents(t,e,i,r){return this.normal.set(t,e,i),this.constant=r,this}setFromNormalAndCoplanarPoint(t,e){return this.normal.copy(t),this.constant=-e.dot(this.normal),this}setFromCoplanarPoints(t,e,i){const r=_vector1.subVectors(i,e).cross(_vector2.subVectors(t,e)).normalize();return this.setFromNormalAndCoplanarPoint(r,t),this}copy(t){return this.normal.copy(t.normal),this.constant=t.constant,this}normalize(){const t=1/this.normal.length();return this.normal.multiplyScalar(t),this.constant*=t,this}negate(){return this.constant*=-1,this.normal.negate(),this}distanceToPoint(t){return this.normal.dot(t)+this.constant}distanceToSphere(t){return this.distanceToPoint(t.center)-t.radius}projectPoint(t,e){return e.copy(t).addScaledVector(this.normal,-this.distanceToPoint(t))}intersectLine(t,e){const i=t.delta(_vector1),r=this.normal.dot(i);if(0===r)return 0===this.distanceToPoint(t.start)?e.copy(t.start):null;const s=-(t.start.dot(this.normal)+this.constant)/r;return s<0||s>1?null:e.copy(t.start).addScaledVector(i,s)}intersectsLine(t){const e=this.distanceToPoint(t.start),i=this.distanceToPoint(t.end);return e<0&&i>0||i<0&&e>0}intersectsBox(t){return t.intersectsPlane(this)}intersectsSphere(t){return t.intersectsPlane(this)}coplanarPoint(t){return t.copy(this.normal).multiplyScalar(-this.constant)}applyMatrix4(t,e){const i=e||_normalMatrix.getNormalMatrix(t),r=this.coplanarPoint(_vector1).applyMatrix4(t),s=this.normal.applyMatrix3(i).normalize();return this.constant=-r.dot(s),this}translate(t){return this.constant-=t.dot(this.normal),this}equals(t){return t.normal.equals(this.normal)&&t.constant===this.constant}clone(){return(new this.constructor).copy(this)}}const _sphere$3=new Sphere,_vector$6=new Vector3;class Frustum{constructor(t=new Plane,e=new Plane,i=new Plane,r=new Plane,s=new Plane,n=new Plane){this.planes=[t,e,i,r,s,n]}set(t,e,i,r,s,n){const a=this.planes;return a[0].copy(t),a[1].copy(e),a[2].copy(i),a[3].copy(r),a[4].copy(s),a[5].copy(n),this}copy(t){const e=this.planes;for(let i=0;i<6;i++)e[i].copy(t.planes[i]);return this}setFromProjectionMatrix(t,e=2e3){const i=this.planes,r=t.elements,s=r[0],n=r[1],a=r[2],o=r[3],h=r[4],c=r[5],l=r[6],u=r[7],p=r[8],d=r[9],m=r[10],y=r[11],f=r[12],g=r[13],x=r[14],_=r[15];if(i[0].setComponents(o-s,u-h,y-p,_-f).normalize(),i[1].setComponents(o+s,u+h,y+p,_+f).normalize(),i[2].setComponents(o+n,u+c,y+d,_+g).normalize(),i[3].setComponents(o-n,u-c,y-d,_-g).normalize(),i[4].setComponents(o-a,u-l,y-m,_-x).normalize(),2e3===e)i[5].setComponents(o+a,u+l,y+m,_+x).normalize();else{if(2001!==e)throw new Error("THREE.Frustum.setFromProjectionMatrix(): Invalid coordinate system: "+e);i[5].setComponents(a,l,m,x).normalize()}return this}intersectsObject(t){if(void 0!==t.boundingSphere)null===t.boundingSphere&&t.computeBoundingSphere(),_sphere$3.copy(t.boundingSphere).applyMatrix4(t.matrixWorld);else{const e=t.geometry;null===e.boundingSphere&&e.computeBoundingSphere(),_sphere$3.copy(e.boundingSphere).applyMatrix4(t.matrixWorld)}return this.intersectsSphere(_sphere$3)}intersectsSprite(t){return _sphere$3.center.set(0,0,0),_sphere$3.radius=.7071067811865476,_sphere$3.applyMatrix4(t.matrixWorld),this.intersectsSphere(_sphere$3)}intersectsSphere(t){const e=this.planes,i=t.center,r=-t.radius;for(let t=0;t<6;t++){if(e[t].distanceToPoint(i)<r)return!1}return!0}intersectsBox(t){const e=this.planes;for(let i=0;i<6;i++){const r=e[i];if(_vector$6.x=r.normal.x>0?t.max.x:t.min.x,_vector$6.y=r.normal.y>0?t.max.y:t.min.y,_vector$6.z=r.normal.z>0?t.max.z:t.min.z,r.distanceToPoint(_vector$6)<0)return!1}return!0}containsPoint(t){const e=this.planes;for(let i=0;i<6;i++)if(e[i].distanceToPoint(t)<0)return!1;return!0}clone(){return(new this.constructor).copy(this)}}const _projScreenMatrix$2=new Matrix4,_frustum$1=new Frustum;class FrustumArray{constructor(){this.coordinateSystem=2e3}intersectsObject(t,e){if(!e.isArrayCamera||0===e.cameras.length)return!1;for(let i=0;i<e.cameras.length;i++){const r=e.cameras[i];if(_projScreenMatrix$2.multiplyMatrices(r.projectionMatrix,r.matrixWorldInverse),_frustum$1.setFromProjectionMatrix(_projScreenMatrix$2,this.coordinateSystem),_frustum$1.intersectsObject(t))return!0}return!1}intersectsSprite(t,e){if(!e||!e.cameras||0===e.cameras.length)return!1;for(let i=0;i<e.cameras.length;i++){const r=e.cameras[i];if(_projScreenMatrix$2.multiplyMatrices(r.projectionMatrix,r.matrixWorldInverse),_frustum$1.setFromProjectionMatrix(_projScreenMatrix$2,this.coordinateSystem),_frustum$1.intersectsSprite(t))return!0}return!1}intersectsSphere(t,e){if(!e||!e.cameras||0===e.cameras.length)return!1;for(let i=0;i<e.cameras.length;i++){const r=e.cameras[i];if(_projScreenMatrix$2.multiplyMatrices(r.projectionMatrix,r.matrixWorldInverse),_frustum$1.setFromProjectionMatrix(_projScreenMatrix$2,this.coordinateSystem),_frustum$1.intersectsSphere(t))return!0}return!1}intersectsBox(t,e){if(!e||!e.cameras||0===e.cameras.length)return!1;for(let i=0;i<e.cameras.length;i++){const r=e.cameras[i];if(_projScreenMatrix$2.multiplyMatrices(r.projectionMatrix,r.matrixWorldInverse),_frustum$1.setFromProjectionMatrix(_projScreenMatrix$2,this.coordinateSystem),_frustum$1.intersectsBox(t))return!0}return!1}containsPoint(t,e){if(!e||!e.cameras||0===e.cameras.length)return!1;for(let i=0;i<e.cameras.length;i++){const r=e.cameras[i];if(_projScreenMatrix$2.multiplyMatrices(r.projectionMatrix,r.matrixWorldInverse),_frustum$1.setFromProjectionMatrix(_projScreenMatrix$2,this.coordinateSystem),_frustum$1.containsPoint(t))return!0}return!1}clone(){return new FrustumArray}}function ascIdSort(t,e){return t-e}function sortOpaque(t,e){return t.z-e.z}function sortTransparent(t,e){return e.z-t.z}class MultiDrawRenderList{constructor(){this.index=0,this.pool=[],this.list=[]}push(t,e,i,r){const s=this.pool,n=this.list;this.index>=s.length&&s.push({start:-1,count:-1,z:-1,index:-1});const a=s[this.index];n.push(a),this.index++,a.start=t,a.count=e,a.z=i,a.index=r}reset(){this.list.length=0,this.index=0}}const _matrix$1=new Matrix4,_whiteColor=new Color(1,1,1),_frustum=new Frustum,_frustumArray=new FrustumArray,_box$1=new Box3,_sphere$2=new Sphere,_vector$5=new Vector3,_forward=new Vector3,_temp=new Vector3,_renderList=new MultiDrawRenderList,_mesh=new Mesh,_batchIntersects=[];function copyAttributeData(t,e,i=0){const r=e.itemSize;if(t.isInterleavedBufferAttribute||t.array.constructor!==e.array.constructor){const s=t.count;for(let n=0;n<s;n++)for(let s=0;s<r;s++)e.setComponent(n+i,s,t.getComponent(n,s))}else e.array.set(t.array,i*r);e.needsUpdate=!0}function copyArrayContents(t,e){if(t.constructor!==e.constructor){const i=Math.min(t.length,e.length);for(let r=0;r<i;r++)e[r]=t[r]}else{const i=Math.min(t.length,e.length);e.set(new t.constructor(t.buffer,0,i))}}class BatchedMesh extends Mesh{constructor(t,e,i=2*e,r){super(new BufferGeometry,r),this.isBatchedMesh=!0,this.perObjectFrustumCulled=!0,this.sortObjects=!0,this.boundingBox=null,this.boundingSphere=null,this.customSort=null,this._instanceInfo=[],this._geometryInfo=[],this._availableInstanceIds=[],this._availableGeometryIds=[],this._nextIndexStart=0,this._nextVertexStart=0,this._geometryCount=0,this._visibilityChanged=!0,this._geometryInitialized=!1,this._maxInstanceCount=t,this._maxVertexCount=e,this._maxIndexCount=i,this._multiDrawCounts=new Int32Array(t),this._multiDrawStarts=new Int32Array(t),this._multiDrawCount=0,this._multiDrawInstances=null,this._matricesTexture=null,this._indirectTexture=null,this._colorsTexture=null,this._initMatricesTexture(),this._initIndirectTexture()}get maxInstanceCount(){return this._maxInstanceCount}get instanceCount(){return this._instanceInfo.length-this._availableInstanceIds.length}get unusedVertexCount(){return this._maxVertexCount-this._nextVertexStart}get unusedIndexCount(){return this._maxIndexCount-this._nextIndexStart}_initMatricesTexture(){let t=Math.sqrt(4*this._maxInstanceCount);t=4*Math.ceil(t/4),t=Math.max(t,4);const e=new Float32Array(t*t*4),i=new DataTexture(e,t,t,1023,1015);this._matricesTexture=i}_initIndirectTexture(){let t=Math.sqrt(this._maxInstanceCount);t=Math.ceil(t);const e=new Uint32Array(t*t),i=new DataTexture(e,t,t,1029,1014);this._indirectTexture=i}_initColorsTexture(){let t=Math.sqrt(this._maxInstanceCount);t=Math.ceil(t);const e=new Float32Array(t*t*4).fill(1),i=new DataTexture(e,t,t,1023,1015);i.colorSpace=ColorManagement.workingColorSpace,this._colorsTexture=i}_initializeGeometry(t){const e=this.geometry,i=this._maxVertexCount,r=this._maxIndexCount;if(!1===this._geometryInitialized){for(const r in t.attributes){const s=t.getAttribute(r),{array:n,itemSize:a,normalized:o}=s,h=new n.constructor(i*a),c=new BufferAttribute(h,a,o);e.setAttribute(r,c)}if(null!==t.getIndex()){const t=i>65535?new Uint32Array(r):new Uint16Array(r);e.setIndex(new BufferAttribute(t,1))}this._geometryInitialized=!0}}_validateGeometry(t){const e=this.geometry;if(Boolean(t.getIndex())!==Boolean(e.getIndex()))throw new Error('THREE.BatchedMesh: All geometries must consistently have "index".');for(const i in e.attributes){if(!t.hasAttribute(i))throw new Error(`THREE.BatchedMesh: Added geometry missing "${i}". All geometries must have consistent attributes.`);const r=t.getAttribute(i),s=e.getAttribute(i);if(r.itemSize!==s.itemSize||r.normalized!==s.normalized)throw new Error("THREE.BatchedMesh: All attributes must have a consistent itemSize and normalized value.")}}validateInstanceId(t){const e=this._instanceInfo;if(t<0||t>=e.length||!1===e[t].active)throw new Error(`THREE.BatchedMesh: Invalid instanceId ${t}. Instance is either out of range or has been deleted.`)}validateGeometryId(t){const e=this._geometryInfo;if(t<0||t>=e.length||!1===e[t].active)throw new Error(`THREE.BatchedMesh: Invalid geometryId ${t}. Geometry is either out of range or has been deleted.`)}setCustomSort(t){return this.customSort=t,this}computeBoundingBox(){null===this.boundingBox&&(this.boundingBox=new Box3);const t=this.boundingBox,e=this._instanceInfo;t.makeEmpty();for(let i=0,r=e.length;i<r;i++){if(!1===e[i].active)continue;const r=e[i].geometryIndex;this.getMatrixAt(i,_matrix$1),this.getBoundingBoxAt(r,_box$1).applyMatrix4(_matrix$1),t.union(_box$1)}}computeBoundingSphere(){null===this.boundingSphere&&(this.boundingSphere=new Sphere);const t=this.boundingSphere,e=this._instanceInfo;t.makeEmpty();for(let i=0,r=e.length;i<r;i++){if(!1===e[i].active)continue;const r=e[i].geometryIndex;this.getMatrixAt(i,_matrix$1),this.getBoundingSphereAt(r,_sphere$2).applyMatrix4(_matrix$1),t.union(_sphere$2)}}addInstance(t){if(this._instanceInfo.length>=this.maxInstanceCount&&0===this._availableInstanceIds.length)throw new Error("THREE.BatchedMesh: Maximum item count reached.");const e={visible:!0,active:!0,geometryIndex:t};let i=null;this._availableInstanceIds.length>0?(this._availableInstanceIds.sort(ascIdSort),i=this._availableInstanceIds.shift(),this._instanceInfo[i]=e):(i=this._instanceInfo.length,this._instanceInfo.push(e));const r=this._matricesTexture;_matrix$1.identity().toArray(r.image.data,16*i),r.needsUpdate=!0;const s=this._colorsTexture;return s&&(_whiteColor.toArray(s.image.data,4*i),s.needsUpdate=!0),this._visibilityChanged=!0,i}addGeometry(t,e=-1,i=-1){this._initializeGeometry(t),this._validateGeometry(t);const r={vertexStart:-1,vertexCount:-1,reservedVertexCount:-1,indexStart:-1,indexCount:-1,reservedIndexCount:-1,start:-1,count:-1,boundingBox:null,boundingSphere:null,active:!0},s=this._geometryInfo;r.vertexStart=this._nextVertexStart,r.reservedVertexCount=-1===e?t.getAttribute("position").count:e;const n=t.getIndex();if(null!==n&&(r.indexStart=this._nextIndexStart,r.reservedIndexCount=-1===i?n.count:i),-1!==r.indexStart&&r.indexStart+r.reservedIndexCount>this._maxIndexCount||r.vertexStart+r.reservedVertexCount>this._maxVertexCount)throw new Error("THREE.BatchedMesh: Reserved space request exceeds the maximum buffer size.");let a;return this._availableGeometryIds.length>0?(this._availableGeometryIds.sort(ascIdSort),a=this._availableGeometryIds.shift(),s[a]=r):(a=this._geometryCount,this._geometryCount++,s.push(r)),this.setGeometryAt(a,t),this._nextIndexStart=r.indexStart+r.reservedIndexCount,this._nextVertexStart=r.vertexStart+r.reservedVertexCount,a}setGeometryAt(t,e){if(t>=this._geometryCount)throw new Error("THREE.BatchedMesh: Maximum geometry count reached.");this._validateGeometry(e);const i=this.geometry,r=null!==i.getIndex(),s=i.getIndex(),n=e.getIndex(),a=this._geometryInfo[t];if(r&&n.count>a.reservedIndexCount||e.attributes.position.count>a.reservedVertexCount)throw new Error("THREE.BatchedMesh: Reserved space not large enough for provided geometry.");const o=a.vertexStart,h=a.reservedVertexCount;a.vertexCount=e.getAttribute("position").count;for(const t in i.attributes){const r=e.getAttribute(t),s=i.getAttribute(t);copyAttributeData(r,s,o);const n=r.itemSize;for(let t=r.count,e=h;t<e;t++){const e=o+t;for(let t=0;t<n;t++)s.setComponent(e,t,0)}s.needsUpdate=!0,s.addUpdateRange(o*n,h*n)}if(r){const t=a.indexStart,i=a.reservedIndexCount;a.indexCount=e.getIndex().count;for(let e=0;e<n.count;e++)s.setX(t+e,o+n.getX(e));for(let e=n.count,r=i;e<r;e++)s.setX(t+e,o);s.needsUpdate=!0,s.addUpdateRange(t,a.reservedIndexCount)}return a.start=r?a.indexStart:a.vertexStart,a.count=r?a.indexCount:a.vertexCount,a.boundingBox=null,null!==e.boundingBox&&(a.boundingBox=e.boundingBox.clone()),a.boundingSphere=null,null!==e.boundingSphere&&(a.boundingSphere=e.boundingSphere.clone()),this._visibilityChanged=!0,t}deleteGeometry(t){const e=this._geometryInfo;if(t>=e.length||!1===e[t].active)return this;const i=this._instanceInfo;for(let e=0,r=i.length;e<r;e++)i[e].active&&i[e].geometryIndex===t&&this.deleteInstance(e);return e[t].active=!1,this._availableGeometryIds.push(t),this._visibilityChanged=!0,this}deleteInstance(t){return this.validateInstanceId(t),this._instanceInfo[t].active=!1,this._availableInstanceIds.push(t),this._visibilityChanged=!0,this}optimize(){let t=0,e=0;const i=this._geometryInfo,r=i.map(((t,e)=>e)).sort(((t,e)=>i[t].vertexStart-i[e].vertexStart)),s=this.geometry;for(let n=0,a=i.length;n<a;n++){const a=r[n],o=i[a];if(!1!==o.active){if(null!==s.index){if(o.indexStart!==e){const{indexStart:i,vertexStart:r,reservedIndexCount:n}=o,a=s.index,h=a.array,c=t-r;for(let t=i;t<i+n;t++)h[t]=h[t]+c;a.array.copyWithin(e,i,i+n),a.addUpdateRange(e,n),o.indexStart=e}e+=o.reservedIndexCount}if(o.vertexStart!==t){const{vertexStart:e,reservedVertexCount:i}=o,r=s.attributes;for(const s in r){const n=r[s],{array:a,itemSize:o}=n;a.copyWithin(t*o,e*o,(e+i)*o),n.addUpdateRange(t*o,i*o)}o.vertexStart=t}t+=o.reservedVertexCount,o.start=s.index?o.indexStart:o.vertexStart,this._nextIndexStart=s.index?o.indexStart+o.reservedIndexCount:0,this._nextVertexStart=o.vertexStart+o.reservedVertexCount}}return this}getBoundingBoxAt(t,e){if(t>=this._geometryCount)return null;const i=this.geometry,r=this._geometryInfo[t];if(null===r.boundingBox){const t=new Box3,e=i.index,s=i.attributes.position;for(let i=r.start,n=r.start+r.count;i<n;i++){let r=i;e&&(r=e.getX(r)),t.expandByPoint(_vector$5.fromBufferAttribute(s,r))}r.boundingBox=t}return e.copy(r.boundingBox),e}getBoundingSphereAt(t,e){if(t>=this._geometryCount)return null;const i=this.geometry,r=this._geometryInfo[t];if(null===r.boundingSphere){const e=new Sphere;this.getBoundingBoxAt(t,_box$1),_box$1.getCenter(e.center);const s=i.index,n=i.attributes.position;let a=0;for(let t=r.start,i=r.start+r.count;t<i;t++){let i=t;s&&(i=s.getX(i)),_vector$5.fromBufferAttribute(n,i),a=Math.max(a,e.center.distanceToSquared(_vector$5))}e.radius=Math.sqrt(a),r.boundingSphere=e}return e.copy(r.boundingSphere),e}setMatrixAt(t,e){this.validateInstanceId(t);const i=this._matricesTexture,r=this._matricesTexture.image.data;return e.toArray(r,16*t),i.needsUpdate=!0,this}getMatrixAt(t,e){return this.validateInstanceId(t),e.fromArray(this._matricesTexture.image.data,16*t)}setColorAt(t,e){return this.validateInstanceId(t),null===this._colorsTexture&&this._initColorsTexture(),e.toArray(this._colorsTexture.image.data,4*t),this._colorsTexture.needsUpdate=!0,this}getColorAt(t,e){return this.validateInstanceId(t),e.fromArray(this._colorsTexture.image.data,4*t)}setVisibleAt(t,e){return this.validateInstanceId(t),this._instanceInfo[t].visible===e||(this._instanceInfo[t].visible=e,this._visibilityChanged=!0),this}getVisibleAt(t){return this.validateInstanceId(t),this._instanceInfo[t].visible}setGeometryIdAt(t,e){return this.validateInstanceId(t),this.validateGeometryId(e),this._instanceInfo[t].geometryIndex=e,this}getGeometryIdAt(t){return this.validateInstanceId(t),this._instanceInfo[t].geometryIndex}getGeometryRangeAt(t,e={}){this.validateGeometryId(t);const i=this._geometryInfo[t];return e.vertexStart=i.vertexStart,e.vertexCount=i.vertexCount,e.reservedVertexCount=i.reservedVertexCount,e.indexStart=i.indexStart,e.indexCount=i.indexCount,e.reservedIndexCount=i.reservedIndexCount,e.start=i.start,e.count=i.count,e}setInstanceCount(t){const e=this._availableInstanceIds,i=this._instanceInfo;for(e.sort(ascIdSort);e[e.length-1]===i.length;)i.pop(),e.pop();if(t<i.length)throw new Error(`BatchedMesh: Instance ids outside the range ${t} are being used. Cannot shrink instance count.`);const r=new Int32Array(t),s=new Int32Array(t);copyArrayContents(this._multiDrawCounts,r),copyArrayContents(this._multiDrawStarts,s),this._multiDrawCounts=r,this._multiDrawStarts=s,this._maxInstanceCount=t;const n=this._indirectTexture,a=this._matricesTexture,o=this._colorsTexture;n.dispose(),this._initIndirectTexture(),copyArrayContents(n.image.data,this._indirectTexture.image.data),a.dispose(),this._initMatricesTexture(),copyArrayContents(a.image.data,this._matricesTexture.image.data),o&&(o.dispose(),this._initColorsTexture(),copyArrayContents(o.image.data,this._colorsTexture.image.data))}setGeometrySize(t,e){const i=[...this._geometryInfo].filter((t=>t.active));if(Math.max(...i.map((t=>t.vertexStart+t.reservedVertexCount)))>t)throw new Error(`BatchedMesh: Geometry vertex values are being used outside the range ${e}. Cannot shrink further.`);if(this.geometry.index){if(Math.max(...i.map((t=>t.indexStart+t.reservedIndexCount)))>e)throw new Error(`BatchedMesh: Geometry index values are being used outside the range ${e}. Cannot shrink further.`)}const r=this.geometry;r.dispose(),this._maxVertexCount=t,this._maxIndexCount=e,this._geometryInitialized&&(this._geometryInitialized=!1,this.geometry=new BufferGeometry,this._initializeGeometry(r));const s=this.geometry;r.index&&copyArrayContents(r.index.array,s.index.array);for(const t in r.attributes)copyArrayContents(r.attributes[t].array,s.attributes[t].array)}raycast(t,e){const i=this._instanceInfo,r=this._geometryInfo,s=this.matrixWorld,n=this.geometry;_mesh.material=this.material,_mesh.geometry.index=n.index,_mesh.geometry.attributes=n.attributes,null===_mesh.geometry.boundingBox&&(_mesh.geometry.boundingBox=new Box3),null===_mesh.geometry.boundingSphere&&(_mesh.geometry.boundingSphere=new Sphere);for(let n=0,a=i.length;n<a;n++){if(!i[n].visible||!i[n].active)continue;const a=i[n].geometryIndex,o=r[a];_mesh.geometry.setDrawRange(o.start,o.count),this.getMatrixAt(n,_mesh.matrixWorld).premultiply(s),this.getBoundingBoxAt(a,_mesh.geometry.boundingBox),this.getBoundingSphereAt(a,_mesh.geometry.boundingSphere),_mesh.raycast(t,_batchIntersects);for(let t=0,i=_batchIntersects.length;t<i;t++){const i=_batchIntersects[t];i.object=this,i.batchId=n,e.push(i)}_batchIntersects.length=0}_mesh.material=null,_mesh.geometry.index=null,_mesh.geometry.attributes={},_mesh.geometry.setDrawRange(0,1/0)}copy(t){return super.copy(t),this.geometry=t.geometry.clone(),this.perObjectFrustumCulled=t.perObjectFrustumCulled,this.sortObjects=t.sortObjects,this.boundingBox=null!==t.boundingBox?t.boundingBox.clone():null,this.boundingSphere=null!==t.boundingSphere?t.boundingSphere.clone():null,this._geometryInfo=t._geometryInfo.map((t=>({...t,boundingBox:null!==t.boundingBox?t.boundingBox.clone():null,boundingSphere:null!==t.boundingSphere?t.boundingSphere.clone():null}))),this._instanceInfo=t._instanceInfo.map((t=>({...t}))),this._availableInstanceIds=t._availableInstanceIds.slice(),this._availableGeometryIds=t._availableGeometryIds.slice(),this._nextIndexStart=t._nextIndexStart,this._nextVertexStart=t._nextVertexStart,this._geometryCount=t._geometryCount,this._maxInstanceCount=t._maxInstanceCount,this._maxVertexCount=t._maxVertexCount,this._maxIndexCount=t._maxIndexCount,this._geometryInitialized=t._geometryInitialized,this._multiDrawCounts=t._multiDrawCounts.slice(),this._multiDrawStarts=t._multiDrawStarts.slice(),this._indirectTexture=t._indirectTexture.clone(),this._indirectTexture.image.data=this._indirectTexture.image.data.slice(),this._matricesTexture=t._matricesTexture.clone(),this._matricesTexture.image.data=this._matricesTexture.image.data.slice(),null!==this._colorsTexture&&(this._colorsTexture=t._colorsTexture.clone(),this._colorsTexture.image.data=this._colorsTexture.image.data.slice()),this}dispose(){this.geometry.dispose(),this._matricesTexture.dispose(),this._matricesTexture=null,this._indirectTexture.dispose(),this._indirectTexture=null,null!==this._colorsTexture&&(this._colorsTexture.dispose(),this._colorsTexture=null)}onBeforeRender(t,e,i,r,s){if(!this._visibilityChanged&&!this.perObjectFrustumCulled&&!this.sortObjects)return;const n=r.getIndex(),a=null===n?1:n.array.BYTES_PER_ELEMENT,o=this._instanceInfo,h=this._multiDrawStarts,c=this._multiDrawCounts,l=this._geometryInfo,u=this.perObjectFrustumCulled,p=this._indirectTexture,d=p.image.data,m=i.isArrayCamera?_frustumArray:_frustum;u&&!i.isArrayCamera&&(_matrix$1.multiplyMatrices(i.projectionMatrix,i.matrixWorldInverse).multiply(this.matrixWorld),_frustum.setFromProjectionMatrix(_matrix$1,t.coordinateSystem));let y=0;if(this.sortObjects){_matrix$1.copy(this.matrixWorld).invert(),_vector$5.setFromMatrixPosition(i.matrixWorld).applyMatrix4(_matrix$1),_forward.set(0,0,-1).transformDirection(i.matrixWorld).transformDirection(_matrix$1);for(let t=0,e=o.length;t<e;t++)if(o[t].visible&&o[t].active){const e=o[t].geometryIndex;this.getMatrixAt(t,_matrix$1),this.getBoundingSphereAt(e,_sphere$2).applyMatrix4(_matrix$1);let r=!1;if(u&&(r=!m.intersectsSphere(_sphere$2,i)),!r){const i=l[e],r=_temp.subVectors(_sphere$2.center,_vector$5).dot(_forward);_renderList.push(i.start,i.count,r,t)}}const t=_renderList.list,e=this.customSort;null===e?t.sort(s.transparent?sortTransparent:sortOpaque):e.call(this,t,i);for(let e=0,i=t.length;e<i;e++){const i=t[e];h[y]=i.start*a,c[y]=i.count,d[y]=i.index,y++}_renderList.reset()}else for(let t=0,e=o.length;t<e;t++)if(o[t].visible&&o[t].active){const e=o[t].geometryIndex;let r=!1;if(u&&(this.getMatrixAt(t,_matrix$1),this.getBoundingSphereAt(e,_sphere$2).applyMatrix4(_matrix$1),r=!m.intersectsSphere(_sphere$2,i)),!r){const i=l[e];h[y]=i.start*a,c[y]=i.count,d[y]=t,y++}}p.needsUpdate=!0,this._multiDrawCount=y,this._visibilityChanged=!1}onBeforeShadow(t,e,i,r,s,n){this.onBeforeRender(t,null,r,s,n)}}class LineBasicMaterial extends Material{constructor(t){super(),this.isLineBasicMaterial=!0,this.type="LineBasicMaterial",this.color=new Color(16777215),this.map=null,this.linewidth=1,this.linecap="round",this.linejoin="round",this.fog=!0,this.setValues(t)}copy(t){return super.copy(t),this.color.copy(t.color),this.map=t.map,this.linewidth=t.linewidth,this.linecap=t.linecap,this.linejoin=t.linejoin,this.fog=t.fog,this}}const _vStart=new Vector3,_vEnd=new Vector3,_inverseMatrix$1=new Matrix4,_ray$1=new Ray,_sphere$1=new Sphere,_intersectPointOnRay=new Vector3,_intersectPointOnSegment=new Vector3;class Line extends Object3D{constructor(t=new BufferGeometry,e=new LineBasicMaterial){super(),this.isLine=!0,this.type="Line",this.geometry=t,this.material=e,this.morphTargetDictionary=void 0,this.morphTargetInfluences=void 0,this.updateMorphTargets()}copy(t,e){return super.copy(t,e),this.material=Array.isArray(t.material)?t.material.slice():t.material,this.geometry=t.geometry,this}computeLineDistances(){const t=this.geometry;if(null===t.index){const e=t.attributes.position,i=[0];for(let t=1,r=e.count;t<r;t++)_vStart.fromBufferAttribute(e,t-1),_vEnd.fromBufferAttribute(e,t),i[t]=i[t-1],i[t]+=_vStart.distanceTo(_vEnd);t.setAttribute("lineDistance",new Float32BufferAttribute(i,1))}else console.warn("THREE.Line.computeLineDistances(): Computation only possible with non-indexed BufferGeometry.");return this}raycast(t,e){const i=this.geometry,r=this.matrixWorld,s=t.params.Line.threshold,n=i.drawRange;if(null===i.boundingSphere&&i.computeBoundingSphere(),_sphere$1.copy(i.boundingSphere),_sphere$1.applyMatrix4(r),_sphere$1.radius+=s,!1===t.ray.intersectsSphere(_sphere$1))return;_inverseMatrix$1.copy(r).invert(),_ray$1.copy(t.ray).applyMatrix4(_inverseMatrix$1);const a=s/((this.scale.x+this.scale.y+this.scale.z)/3),o=a*a,h=this.isLineSegments?2:1,c=i.index,l=i.attributes.position;if(null!==c){const i=Math.max(0,n.start),r=Math.min(c.count,n.start+n.count);for(let s=i,n=r-1;s<n;s+=h){const i=c.getX(s),r=c.getX(s+1),n=checkIntersection(this,t,_ray$1,o,i,r,s);n&&e.push(n)}if(this.isLineLoop){const s=c.getX(r-1),n=c.getX(i),a=checkIntersection(this,t,_ray$1,o,s,n,r-1);a&&e.push(a)}}else{const i=Math.max(0,n.start),r=Math.min(l.count,n.start+n.count);for(let s=i,n=r-1;s<n;s+=h){const i=checkIntersection(this,t,_ray$1,o,s,s+1,s);i&&e.push(i)}if(this.isLineLoop){const s=checkIntersection(this,t,_ray$1,o,r-1,i,r-1);s&&e.push(s)}}}updateMorphTargets(){const t=this.geometry.morphAttributes,e=Object.keys(t);if(e.length>0){const i=t[e[0]];if(void 0!==i){this.morphTargetInfluences=[],this.morphTargetDictionary={};for(let t=0,e=i.length;t<e;t++){const e=i[t].name||String(t);this.morphTargetInfluences.push(0),this.morphTargetDictionary[e]=t}}}}}function checkIntersection(t,e,i,r,s,n,a){const o=t.geometry.attributes.position;_vStart.fromBufferAttribute(o,s),_vEnd.fromBufferAttribute(o,n);if(i.distanceSqToSegment(_vStart,_vEnd,_intersectPointOnRay,_intersectPointOnSegment)>r)return;_intersectPointOnRay.applyMatrix4(t.matrixWorld);const h=e.ray.origin.distanceTo(_intersectPointOnRay);return h<e.near||h>e.far?void 0:{distance:h,point:_intersectPointOnSegment.clone().applyMatrix4(t.matrixWorld),index:a,face:null,faceIndex:null,barycoord:null,object:t}}const _start=new Vector3,_end=new Vector3;class LineSegments extends Line{constructor(t,e){super(t,e),this.isLineSegments=!0,this.type="LineSegments"}computeLineDistances(){const t=this.geometry;if(null===t.index){const e=t.attributes.position,i=[];for(let t=0,r=e.count;t<r;t+=2)_start.fromBufferAttribute(e,t),_end.fromBufferAttribute(e,t+1),i[t]=0===t?0:i[t-1],i[t+1]=i[t]+_start.distanceTo(_end);t.setAttribute("lineDistance",new Float32BufferAttribute(i,1))}else console.warn("THREE.LineSegments.computeLineDistances(): Computation only possible with non-indexed BufferGeometry.");return this}}class LineLoop extends Line{constructor(t,e){super(t,e),this.isLineLoop=!0,this.type="LineLoop"}}class PointsMaterial extends Material{constructor(t){super(),this.isPointsMaterial=!0,this.type="PointsMaterial",this.color=new Color(16777215),this.map=null,this.alphaMap=null,this.size=1,this.sizeAttenuation=!0,this.fog=!0,this.setValues(t)}copy(t){return super.copy(t),this.color.copy(t.color),this.map=t.map,this.alphaMap=t.alphaMap,this.size=t.size,this.sizeAttenuation=t.sizeAttenuation,this.fog=t.fog,this}}const _inverseMatrix=new Matrix4,_ray=new Ray,_sphere=new Sphere,_position$2=new Vector3;class Points extends Object3D{constructor(t=new BufferGeometry,e=new PointsMaterial){super(),this.isPoints=!0,this.type="Points",this.geometry=t,this.material=e,this.morphTargetDictionary=void 0,this.morphTargetInfluences=void 0,this.updateMorphTargets()}copy(t,e){return super.copy(t,e),this.material=Array.isArray(t.material)?t.material.slice():t.material,this.geometry=t.geometry,this}raycast(t,e){const i=this.geometry,r=this.matrixWorld,s=t.params.Points.threshold,n=i.drawRange;if(null===i.boundingSphere&&i.computeBoundingSphere(),_sphere.copy(i.boundingSphere),_sphere.applyMatrix4(r),_sphere.radius+=s,!1===t.ray.intersectsSphere(_sphere))return;_inverseMatrix.copy(r).invert(),_ray.copy(t.ray).applyMatrix4(_inverseMatrix);const a=s/((this.scale.x+this.scale.y+this.scale.z)/3),o=a*a,h=i.index,c=i.attributes.position;if(null!==h){for(let i=Math.max(0,n.start),s=Math.min(h.count,n.start+n.count);i<s;i++){const s=h.getX(i);_position$2.fromBufferAttribute(c,s),testPoint(_position$2,s,o,r,t,e,this)}}else{for(let i=Math.max(0,n.start),s=Math.min(c.count,n.start+n.count);i<s;i++)_position$2.fromBufferAttribute(c,i),testPoint(_position$2,i,o,r,t,e,this)}}updateMorphTargets(){const t=this.geometry.morphAttributes,e=Object.keys(t);if(e.length>0){const i=t[e[0]];if(void 0!==i){this.morphTargetInfluences=[],this.morphTargetDictionary={};for(let t=0,e=i.length;t<e;t++){const e=i[t].name||String(t);this.morphTargetInfluences.push(0),this.morphTargetDictionary[e]=t}}}}}function testPoint(t,e,i,r,s,n,a){const o=_ray.distanceSqToPoint(t);if(o<i){const i=new Vector3;_ray.closestPointToPoint(t,i),i.applyMatrix4(r);const h=s.ray.origin.distanceTo(i);if(h<s.near||h>s.far)return;n.push({distance:h,distanceToRay:Math.sqrt(o),point:i,index:e,face:null,faceIndex:null,barycoord:null,object:a})}}class VideoTexture extends Texture{constructor(t,e,i,r,s=1006,n=1006,a,o,h){super(t,e,i,r,s,n,a,o,h),this.isVideoTexture=!0,this.generateMipmaps=!1;const c=this;"requestVideoFrameCallback"in t&&t.requestVideoFrameCallback((function e(){c.needsUpdate=!0,t.requestVideoFrameCallback(e)}))}clone(){return new this.constructor(this.image).copy(this)}update(){const t=this.image;!1==="requestVideoFrameCallback"in t&&t.readyState>=t.HAVE_CURRENT_DATA&&(this.needsUpdate=!0)}}class VideoFrameTexture extends VideoTexture{constructor(t,e,i,r,s,n,a,o){super({},t,e,i,r,s,n,a,o),this.isVideoFrameTexture=!0}update(){}clone(){return(new this.constructor).copy(this)}setFrame(t){this.image=t,this.needsUpdate=!0}}class FramebufferTexture extends Texture{constructor(t,e){super({width:t,height:e}),this.isFramebufferTexture=!0,this.magFilter=1003,this.minFilter=1003,this.generateMipmaps=!1,this.needsUpdate=!0}}class CompressedTexture extends Texture{constructor(t,e,i,r,s,n,a,o,h,c,l,u){super(null,n,a,o,h,c,r,s,l,u),this.isCompressedTexture=!0,this.image={width:e,height:i},this.mipmaps=t,this.flipY=!1,this.generateMipmaps=!1}}class CompressedArrayTexture extends CompressedTexture{constructor(t,e,i,r,s,n){super(t,e,i,s,n),this.isCompressedArrayTexture=!0,this.image.depth=r,this.wrapR=1001,this.layerUpdates=new Set}addLayerUpdate(t){this.layerUpdates.add(t)}clearLayerUpdates(){this.layerUpdates.clear()}}class CompressedCubeTexture extends CompressedTexture{constructor(t,e,i){super(void 0,t[0].width,t[0].height,e,i,301),this.isCompressedCubeTexture=!0,this.isCubeTexture=!0,this.image=t}}class CanvasTexture extends Texture{constructor(t,e,i,r,s,n,a,o,h){super(t,e,i,r,s,n,a,o,h),this.isCanvasTexture=!0,this.needsUpdate=!0}}class DepthTexture extends Texture{constructor(t,e,i=1014,r,s,n,a=1003,o=1003,h,c=1026){if(1026!==c&&1027!==c)throw new Error("DepthTexture format must be either THREE.DepthFormat or THREE.DepthStencilFormat");super(null,r,s,n,a,o,c,i,h),this.isDepthTexture=!0,this.image={width:t,height:e},this.flipY=!1,this.generateMipmaps=!1,this.compareFunction=null}copy(t){return super.copy(t),this.source=new Source(Object.assign({},t.image)),this.compareFunction=t.compareFunction,this}toJSON(t){const e=super.toJSON(t);return null!==this.compareFunction&&(e.compareFunction=this.compareFunction),e}}class DepthArrayTexture extends DepthTexture{constructor(t=1,e=1,i=1){super(t,e),this.isDepthArrayTexture=!0,this.image={width:t,height:e,depth:i},this.flipY=!1,this.generateMipmaps=!1,this.compareFunction=null,this.layerUpdates=new Set}addLayerUpdate(t){this.layerUpdates.add(t)}clearLayerUpdates(){this.layerUpdates.clear()}}class CapsuleGeometry extends BufferGeometry{constructor(t=1,e=1,i=4,r=8,s=1){super(),this.type="CapsuleGeometry",this.parameters={radius:t,height:e,capSegments:i,radialSegments:r,heightSegments:s},e=Math.max(0,e),i=Math.max(1,Math.floor(i)),r=Math.max(3,Math.floor(r)),s=Math.max(1,Math.floor(s));const n=[],a=[],o=[],h=[],c=e/2,l=Math.PI/2*t,u=e,p=2*l+u,d=2*i+s,m=r+1,y=new Vector3,f=new Vector3;for(let g=0;g<=d;g++){let x=0,_=0,v=0,b=0;if(g<=i){const e=g/i,r=e*Math.PI/2;_=-c-t*Math.cos(r),v=t*Math.sin(r),b=-t*Math.cos(r),x=e*l}else if(g<=i+s){const r=(g-i)/s;_=r*e-c,v=t,b=0,x=l+r*u}else{const e=(g-i-s)/i,r=e*Math.PI/2;_=c+t*Math.sin(r),v=t*Math.cos(r),b=t*Math.sin(r),x=l+u+e*l}const M=Math.max(0,Math.min(1,x/p));let w=0;0===g?w=.5/r:g===d&&(w=-.5/r);for(let t=0;t<=r;t++){const e=t/r,i=e*Math.PI*2,s=Math.sin(i),n=Math.cos(i);f.x=-v*n,f.y=_,f.z=v*s,a.push(f.x,f.y,f.z),y.set(-v*n,b,v*s),y.normalize(),o.push(y.x,y.y,y.z),h.push(e+w,M)}if(g>0){const t=(g-1)*m;for(let e=0;e<r;e++){const i=t+e,r=t+e+1,s=g*m+e,a=g*m+e+1;n.push(i,r,s),n.push(r,a,s)}}}this.setIndex(n),this.setAttribute("position",new Float32BufferAttribute(a,3)),this.setAttribute("normal",new Float32BufferAttribute(o,3)),this.setAttribute("uv",new Float32BufferAttribute(h,2))}copy(t){return super.copy(t),this.parameters=Object.assign({},t.parameters),this}static fromJSON(t){return new CapsuleGeometry(t.radius,t.height,t.capSegments,t.radialSegments,t.heightSegments)}}class CircleGeometry extends BufferGeometry{constructor(t=1,e=32,i=0,r=2*Math.PI){super(),this.type="CircleGeometry",this.parameters={radius:t,segments:e,thetaStart:i,thetaLength:r},e=Math.max(3,e);const s=[],n=[],a=[],o=[],h=new Vector3,c=new Vector2;n.push(0,0,0),a.push(0,0,1),o.push(.5,.5);for(let s=0,l=3;s<=e;s++,l+=3){const u=i+s/e*r;h.x=t*Math.cos(u),h.y=t*Math.sin(u),n.push(h.x,h.y,h.z),a.push(0,0,1),c.x=(n[l]/t+1)/2,c.y=(n[l+1]/t+1)/2,o.push(c.x,c.y)}for(let t=1;t<=e;t++)s.push(t,t+1,0);this.setIndex(s),this.setAttribute("position",new Float32BufferAttribute(n,3)),this.setAttribute("normal",new Float32BufferAttribute(a,3)),this.setAttribute("uv",new Float32BufferAttribute(o,2))}copy(t){return super.copy(t),this.parameters=Object.assign({},t.parameters),this}static fromJSON(t){return new CircleGeometry(t.radius,t.segments,t.thetaStart,t.thetaLength)}}class CylinderGeometry extends BufferGeometry{constructor(t=1,e=1,i=1,r=32,s=1,n=!1,a=0,o=2*Math.PI){super(),this.type="CylinderGeometry",this.parameters={radiusTop:t,radiusBottom:e,height:i,radialSegments:r,heightSegments:s,openEnded:n,thetaStart:a,thetaLength:o};const h=this;r=Math.floor(r),s=Math.floor(s);const c=[],l=[],u=[],p=[];let d=0;const m=[],y=i/2;let f=0;function g(i){const s=d,n=new Vector2,m=new Vector3;let g=0;const x=!0===i?t:e,_=!0===i?1:-1;for(let t=1;t<=r;t++)l.push(0,y*_,0),u.push(0,_,0),p.push(.5,.5),d++;const v=d;for(let t=0;t<=r;t++){const e=t/r*o+a,i=Math.cos(e),s=Math.sin(e);m.x=x*s,m.y=y*_,m.z=x*i,l.push(m.x,m.y,m.z),u.push(0,_,0),n.x=.5*i+.5,n.y=.5*s*_+.5,p.push(n.x,n.y),d++}for(let t=0;t<r;t++){const e=s+t,r=v+t;!0===i?c.push(r,r+1,e):c.push(r+1,r,e),g+=3}h.addGroup(f,g,!0===i?1:2),f+=g}!function(){const n=new Vector3,g=new Vector3;let x=0;const _=(e-t)/i;for(let h=0;h<=s;h++){const c=[],f=h/s,x=f*(e-t)+t;for(let t=0;t<=r;t++){const e=t/r,s=e*o+a,h=Math.sin(s),m=Math.cos(s);g.x=x*h,g.y=-f*i+y,g.z=x*m,l.push(g.x,g.y,g.z),n.set(h,_,m).normalize(),u.push(n.x,n.y,n.z),p.push(e,1-f),c.push(d++)}m.push(c)}for(let i=0;i<r;i++)for(let r=0;r<s;r++){const n=m[r][i],a=m[r+1][i],o=m[r+1][i+1],h=m[r][i+1];(t>0||0!==r)&&(c.push(n,a,h),x+=3),(e>0||r!==s-1)&&(c.push(a,o,h),x+=3)}h.addGroup(f,x,0),f+=x}(),!1===n&&(t>0&&g(!0),e>0&&g(!1)),this.setIndex(c),this.setAttribute("position",new Float32BufferAttribute(l,3)),this.setAttribute("normal",new Float32BufferAttribute(u,3)),this.setAttribute("uv",new Float32BufferAttribute(p,2))}copy(t){return super.copy(t),this.parameters=Object.assign({},t.parameters),this}static fromJSON(t){return new CylinderGeometry(t.radiusTop,t.radiusBottom,t.height,t.radialSegments,t.heightSegments,t.openEnded,t.thetaStart,t.thetaLength)}}class ConeGeometry extends CylinderGeometry{constructor(t=1,e=1,i=32,r=1,s=!1,n=0,a=2*Math.PI){super(0,t,e,i,r,s,n,a),this.type="ConeGeometry",this.parameters={radius:t,height:e,radialSegments:i,heightSegments:r,openEnded:s,thetaStart:n,thetaLength:a}}static fromJSON(t){return new ConeGeometry(t.radius,t.height,t.radialSegments,t.heightSegments,t.openEnded,t.thetaStart,t.thetaLength)}}class PolyhedronGeometry extends BufferGeometry{constructor(t=[],e=[],i=1,r=0){super(),this.type="PolyhedronGeometry",this.parameters={vertices:t,indices:e,radius:i,detail:r};const s=[],n=[];function a(t,e,i,r){const s=r+1,n=[];for(let r=0;r<=s;r++){n[r]=[];const a=t.clone().lerp(i,r/s),o=e.clone().lerp(i,r/s),h=s-r;for(let t=0;t<=h;t++)n[r][t]=0===t&&r===s?a:a.clone().lerp(o,t/h)}for(let t=0;t<s;t++)for(let e=0;e<2*(s-t)-1;e++){const i=Math.floor(e/2);e%2==0?(o(n[t][i+1]),o(n[t+1][i]),o(n[t][i])):(o(n[t][i+1]),o(n[t+1][i+1]),o(n[t+1][i]))}}function o(t){s.push(t.x,t.y,t.z)}function h(e,i){const r=3*e;i.x=t[r+0],i.y=t[r+1],i.z=t[r+2]}function c(t,e,i,r){r<0&&1===t.x&&(n[e]=t.x-1),0===i.x&&0===i.z&&(n[e]=r/2/Math.PI+.5)}function l(t){return Math.atan2(t.z,-t.x)}!function(t){const i=new Vector3,r=new Vector3,s=new Vector3;for(let n=0;n<e.length;n+=3)h(e[n+0],i),h(e[n+1],r),h(e[n+2],s),a(i,r,s,t)}(r),function(t){const e=new Vector3;for(let i=0;i<s.length;i+=3)e.x=s[i+0],e.y=s[i+1],e.z=s[i+2],e.normalize().multiplyScalar(t),s[i+0]=e.x,s[i+1]=e.y,s[i+2]=e.z}(i),function(){const t=new Vector3;for(let i=0;i<s.length;i+=3){t.x=s[i+0],t.y=s[i+1],t.z=s[i+2];const r=l(t)/2/Math.PI+.5,a=(e=t,Math.atan2(-e.y,Math.sqrt(e.x*e.x+e.z*e.z))/Math.PI+.5);n.push(r,1-a)}var e;(function(){const t=new Vector3,e=new Vector3,i=new Vector3,r=new Vector3,a=new Vector2,o=new Vector2,h=new Vector2;for(let u=0,p=0;u<s.length;u+=9,p+=6){t.set(s[u+0],s[u+1],s[u+2]),e.set(s[u+3],s[u+4],s[u+5]),i.set(s[u+6],s[u+7],s[u+8]),a.set(n[p+0],n[p+1]),o.set(n[p+2],n[p+3]),h.set(n[p+4],n[p+5]),r.copy(t).add(e).add(i).divideScalar(3);const d=l(r);c(a,p+0,t,d),c(o,p+2,e,d),c(h,p+4,i,d)}})(),function(){for(let t=0;t<n.length;t+=6){const e=n[t+0],i=n[t+2],r=n[t+4],s=Math.max(e,i,r),a=Math.min(e,i,r);s>.9&&a<.1&&(e<.2&&(n[t+0]+=1),i<.2&&(n[t+2]+=1),r<.2&&(n[t+4]+=1))}}()}(),this.setAttribute("position",new Float32BufferAttribute(s,3)),this.setAttribute("normal",new Float32BufferAttribute(s.slice(),3)),this.setAttribute("uv",new Float32BufferAttribute(n,2)),0===r?this.computeVertexNormals():this.normalizeNormals()}copy(t){return super.copy(t),this.parameters=Object.assign({},t.parameters),this}static fromJSON(t){return new PolyhedronGeometry(t.vertices,t.indices,t.radius,t.details)}}class DodecahedronGeometry extends PolyhedronGeometry{constructor(t=1,e=0){const i=(1+Math.sqrt(5))/2,r=1/i;super([-1,-1,-1,-1,-1,1,-1,1,-1,-1,1,1,1,-1,-1,1,-1,1,1,1,-1,1,1,1,0,-r,-i,0,-r,i,0,r,-i,0,r,i,-r,-i,0,-r,i,0,r,-i,0,r,i,0,-i,0,-r,i,0,-r,-i,0,r,i,0,r],[3,11,7,3,7,15,3,15,13,7,19,17,7,17,6,7,6,15,17,4,8,17,8,10,17,10,6,8,0,16,8,16,2,8,2,10,0,12,1,0,1,18,0,18,16,6,10,2,6,2,13,6,13,15,2,16,18,2,18,3,2,3,13,18,1,9,18,9,11,18,11,3,4,14,12,4,12,0,4,0,8,11,9,5,11,5,19,11,19,7,19,5,14,19,14,4,19,4,17,1,12,14,1,14,5,1,5,9],t,e),this.type="DodecahedronGeometry",this.parameters={radius:t,detail:e}}static fromJSON(t){return new DodecahedronGeometry(t.radius,t.detail)}}const _v0=new Vector3,_v1$1=new Vector3,_normal=new Vector3,_triangle=new Triangle;class EdgesGeometry extends BufferGeometry{constructor(t=null,e=1){if(super(),this.type="EdgesGeometry",this.parameters={geometry:t,thresholdAngle:e},null!==t){const i=4,r=Math.pow(10,i),s=Math.cos(DEG2RAD*e),n=t.getIndex(),a=t.getAttribute("position"),o=n?n.count:a.count,h=[0,0,0],c=["a","b","c"],l=new Array(3),u={},p=[];for(let t=0;t<o;t+=3){n?(h[0]=n.getX(t),h[1]=n.getX(t+1),h[2]=n.getX(t+2)):(h[0]=t,h[1]=t+1,h[2]=t+2);const{a:e,b:i,c:o}=_triangle;if(e.fromBufferAttribute(a,h[0]),i.fromBufferAttribute(a,h[1]),o.fromBufferAttribute(a,h[2]),_triangle.getNormal(_normal),l[0]=`${Math.round(e.x*r)},${Math.round(e.y*r)},${Math.round(e.z*r)}`,l[1]=`${Math.round(i.x*r)},${Math.round(i.y*r)},${Math.round(i.z*r)}`,l[2]=`${Math.round(o.x*r)},${Math.round(o.y*r)},${Math.round(o.z*r)}`,l[0]!==l[1]&&l[1]!==l[2]&&l[2]!==l[0])for(let t=0;t<3;t++){const e=(t+1)%3,i=l[t],r=l[e],n=_triangle[c[t]],a=_triangle[c[e]],o=`${i}_${r}`,d=`${r}_${i}`;d in u&&u[d]?(_normal.dot(u[d].normal)<=s&&(p.push(n.x,n.y,n.z),p.push(a.x,a.y,a.z)),u[d]=null):o in u||(u[o]={index0:h[t],index1:h[e],normal:_normal.clone()})}}for(const t in u)if(u[t]){const{index0:e,index1:i}=u[t];_v0.fromBufferAttribute(a,e),_v1$1.fromBufferAttribute(a,i),p.push(_v0.x,_v0.y,_v0.z),p.push(_v1$1.x,_v1$1.y,_v1$1.z)}this.setAttribute("position",new Float32BufferAttribute(p,3))}}copy(t){return super.copy(t),this.parameters=Object.assign({},t.parameters),this}}class Curve{constructor(){this.type="Curve",this.arcLengthDivisions=200,this.needsUpdate=!1,this.cacheArcLengths=null}getPoint(){console.warn("THREE.Curve: .getPoint() not implemented.")}getPointAt(t,e){const i=this.getUtoTmapping(t);return this.getPoint(i,e)}getPoints(t=5){const e=[];for(let i=0;i<=t;i++)e.push(this.getPoint(i/t));return e}getSpacedPoints(t=5){const e=[];for(let i=0;i<=t;i++)e.push(this.getPointAt(i/t));return e}getLength(){const t=this.getLengths();return t[t.length-1]}getLengths(t=this.arcLengthDivisions){if(this.cacheArcLengths&&this.cacheArcLengths.length===t+1&&!this.needsUpdate)return this.cacheArcLengths;this.needsUpdate=!1;const e=[];let i,r=this.getPoint(0),s=0;e.push(0);for(let n=1;n<=t;n++)i=this.getPoint(n/t),s+=i.distanceTo(r),e.push(s),r=i;return this.cacheArcLengths=e,e}updateArcLengths(){this.needsUpdate=!0,this.getLengths()}getUtoTmapping(t,e=null){const i=this.getLengths();let r=0;const s=i.length;let n;n=e||t*i[s-1];let a,o=0,h=s-1;for(;o<=h;)if(r=Math.floor(o+(h-o)/2),a=i[r]-n,a<0)o=r+1;else{if(!(a>0)){h=r;break}h=r-1}if(r=h,i[r]===n)return r/(s-1);const c=i[r];return(r+(n-c)/(i[r+1]-c))/(s-1)}getTangent(t,e){const i=1e-4;let r=t-i,s=t+i;r<0&&(r=0),s>1&&(s=1);const n=this.getPoint(r),a=this.getPoint(s),o=e||(n.isVector2?new Vector2:new Vector3);return o.copy(a).sub(n).normalize(),o}getTangentAt(t,e){const i=this.getUtoTmapping(t);return this.getTangent(i,e)}computeFrenetFrames(t,e=!1){const i=new Vector3,r=[],s=[],n=[],a=new Vector3,o=new Matrix4;for(let e=0;e<=t;e++){const i=e/t;r[e]=this.getTangentAt(i,new Vector3)}s[0]=new Vector3,n[0]=new Vector3;let h=Number.MAX_VALUE;const c=Math.abs(r[0].x),l=Math.abs(r[0].y),u=Math.abs(r[0].z);c<=h&&(h=c,i.set(1,0,0)),l<=h&&(h=l,i.set(0,1,0)),u<=h&&i.set(0,0,1),a.crossVectors(r[0],i).normalize(),s[0].crossVectors(r[0],a),n[0].crossVectors(r[0],s[0]);for(let e=1;e<=t;e++){if(s[e]=s[e-1].clone(),n[e]=n[e-1].clone(),a.crossVectors(r[e-1],r[e]),a.length()>Number.EPSILON){a.normalize();const t=Math.acos(clamp(r[e-1].dot(r[e]),-1,1));s[e].applyMatrix4(o.makeRotationAxis(a,t))}n[e].crossVectors(r[e],s[e])}if(!0===e){let e=Math.acos(clamp(s[0].dot(s[t]),-1,1));e/=t,r[0].dot(a.crossVectors(s[0],s[t]))>0&&(e=-e);for(let i=1;i<=t;i++)s[i].applyMatrix4(o.makeRotationAxis(r[i],e*i)),n[i].crossVectors(r[i],s[i])}return{tangents:r,normals:s,binormals:n}}clone(){return(new this.constructor).copy(this)}copy(t){return this.arcLengthDivisions=t.arcLengthDivisions,this}toJSON(){const t={metadata:{version:4.6,type:"Curve",generator:"Curve.toJSON"}};return t.arcLengthDivisions=this.arcLengthDivisions,t.type=this.type,t}fromJSON(t){return this.arcLengthDivisions=t.arcLengthDivisions,this}}class EllipseCurve extends Curve{constructor(t=0,e=0,i=1,r=1,s=0,n=2*Math.PI,a=!1,o=0){super(),this.isEllipseCurve=!0,this.type="EllipseCurve",this.aX=t,this.aY=e,this.xRadius=i,this.yRadius=r,this.aStartAngle=s,this.aEndAngle=n,this.aClockwise=a,this.aRotation=o}getPoint(t,e=new Vector2){const i=e,r=2*Math.PI;let s=this.aEndAngle-this.aStartAngle;const n=Math.abs(s)<Number.EPSILON;for(;s<0;)s+=r;for(;s>r;)s-=r;s<Number.EPSILON&&(s=n?0:r),!0!==this.aClockwise||n||(s===r?s=-r:s-=r);const a=this.aStartAngle+t*s;let o=this.aX+this.xRadius*Math.cos(a),h=this.aY+this.yRadius*Math.sin(a);if(0!==this.aRotation){const t=Math.cos(this.aRotation),e=Math.sin(this.aRotation),i=o-this.aX,r=h-this.aY;o=i*t-r*e+this.aX,h=i*e+r*t+this.aY}return i.set(o,h)}copy(t){return super.copy(t),this.aX=t.aX,this.aY=t.aY,this.xRadius=t.xRadius,this.yRadius=t.yRadius,this.aStartAngle=t.aStartAngle,this.aEndAngle=t.aEndAngle,this.aClockwise=t.aClockwise,this.aRotation=t.aRotation,this}toJSON(){const t=super.toJSON();return t.aX=this.aX,t.aY=this.aY,t.xRadius=this.xRadius,t.yRadius=this.yRadius,t.aStartAngle=this.aStartAngle,t.aEndAngle=this.aEndAngle,t.aClockwise=this.aClockwise,t.aRotation=this.aRotation,t}fromJSON(t){return super.fromJSON(t),this.aX=t.aX,this.aY=t.aY,this.xRadius=t.xRadius,this.yRadius=t.yRadius,this.aStartAngle=t.aStartAngle,this.aEndAngle=t.aEndAngle,this.aClockwise=t.aClockwise,this.aRotation=t.aRotation,this}}class ArcCurve extends EllipseCurve{constructor(t,e,i,r,s,n){super(t,e,i,i,r,s,n),this.isArcCurve=!0,this.type="ArcCurve"}}function CubicPoly(){let t=0,e=0,i=0,r=0;function s(s,n,a,o){t=s,e=a,i=-3*s+3*n-2*a-o,r=2*s-2*n+a+o}return{initCatmullRom:function(t,e,i,r,n){s(e,i,n*(i-t),n*(r-e))},initNonuniformCatmullRom:function(t,e,i,r,n,a,o){let h=(e-t)/n-(i-t)/(n+a)+(i-e)/a,c=(i-e)/a-(r-e)/(a+o)+(r-i)/o;h*=a,c*=a,s(e,i,h,c)},calc:function(s){const n=s*s;return t+e*s+i*n+r*(n*s)}}}const tmp=new Vector3,px=new CubicPoly,py=new CubicPoly,pz=new CubicPoly;class CatmullRomCurve3 extends Curve{constructor(t=[],e=!1,i="centripetal",r=.5){super(),this.isCatmullRomCurve3=!0,this.type="CatmullRomCurve3",this.points=t,this.closed=e,this.curveType=i,this.tension=r}getPoint(t,e=new Vector3){const i=e,r=this.points,s=r.length,n=(s-(this.closed?0:1))*t;let a,o,h=Math.floor(n),c=n-h;this.closed?h+=h>0?0:(Math.floor(Math.abs(h)/s)+1)*s:0===c&&h===s-1&&(h=s-2,c=1),this.closed||h>0?a=r[(h-1)%s]:(tmp.subVectors(r[0],r[1]).add(r[0]),a=tmp);const l=r[h%s],u=r[(h+1)%s];if(this.closed||h+2<s?o=r[(h+2)%s]:(tmp.subVectors(r[s-1],r[s-2]).add(r[s-1]),o=tmp),"centripetal"===this.curveType||"chordal"===this.curveType){const t="chordal"===this.curveType?.5:.25;let e=Math.pow(a.distanceToSquared(l),t),i=Math.pow(l.distanceToSquared(u),t),r=Math.pow(u.distanceToSquared(o),t);i<1e-4&&(i=1),e<1e-4&&(e=i),r<1e-4&&(r=i),px.initNonuniformCatmullRom(a.x,l.x,u.x,o.x,e,i,r),py.initNonuniformCatmullRom(a.y,l.y,u.y,o.y,e,i,r),pz.initNonuniformCatmullRom(a.z,l.z,u.z,o.z,e,i,r)}else"catmullrom"===this.curveType&&(px.initCatmullRom(a.x,l.x,u.x,o.x,this.tension),py.initCatmullRom(a.y,l.y,u.y,o.y,this.tension),pz.initCatmullRom(a.z,l.z,u.z,o.z,this.tension));return i.set(px.calc(c),py.calc(c),pz.calc(c)),i}copy(t){super.copy(t),this.points=[];for(let e=0,i=t.points.length;e<i;e++){const i=t.points[e];this.points.push(i.clone())}return this.closed=t.closed,this.curveType=t.curveType,this.tension=t.tension,this}toJSON(){const t=super.toJSON();t.points=[];for(let e=0,i=this.points.length;e<i;e++){const i=this.points[e];t.points.push(i.toArray())}return t.closed=this.closed,t.curveType=this.curveType,t.tension=this.tension,t}fromJSON(t){super.fromJSON(t),this.points=[];for(let e=0,i=t.points.length;e<i;e++){const i=t.points[e];this.points.push((new Vector3).fromArray(i))}return this.closed=t.closed,this.curveType=t.curveType,this.tension=t.tension,this}}function CatmullRom(t,e,i,r,s){const n=.5*(r-e),a=.5*(s-i),o=t*t;return(2*i-2*r+n+a)*(t*o)+(-3*i+3*r-2*n-a)*o+n*t+i}function QuadraticBezierP0(t,e){const i=1-t;return i*i*e}function QuadraticBezierP1(t,e){return 2*(1-t)*t*e}function QuadraticBezierP2(t,e){return t*t*e}function QuadraticBezier(t,e,i,r){return QuadraticBezierP0(t,e)+QuadraticBezierP1(t,i)+QuadraticBezierP2(t,r)}function CubicBezierP0(t,e){const i=1-t;return i*i*i*e}function CubicBezierP1(t,e){const i=1-t;return 3*i*i*t*e}function CubicBezierP2(t,e){return 3*(1-t)*t*t*e}function CubicBezierP3(t,e){return t*t*t*e}function CubicBezier(t,e,i,r,s){return CubicBezierP0(t,e)+CubicBezierP1(t,i)+CubicBezierP2(t,r)+CubicBezierP3(t,s)}class CubicBezierCurve extends Curve{constructor(t=new Vector2,e=new Vector2,i=new Vector2,r=new Vector2){super(),this.isCubicBezierCurve=!0,this.type="CubicBezierCurve",this.v0=t,this.v1=e,this.v2=i,this.v3=r}getPoint(t,e=new Vector2){const i=e,r=this.v0,s=this.v1,n=this.v2,a=this.v3;return i.set(CubicBezier(t,r.x,s.x,n.x,a.x),CubicBezier(t,r.y,s.y,n.y,a.y)),i}copy(t){return super.copy(t),this.v0.copy(t.v0),this.v1.copy(t.v1),this.v2.copy(t.v2),this.v3.copy(t.v3),this}toJSON(){const t=super.toJSON();return t.v0=this.v0.toArray(),t.v1=this.v1.toArray(),t.v2=this.v2.toArray(),t.v3=this.v3.toArray(),t}fromJSON(t){return super.fromJSON(t),this.v0.fromArray(t.v0),this.v1.fromArray(t.v1),this.v2.fromArray(t.v2),this.v3.fromArray(t.v3),this}}class CubicBezierCurve3 extends Curve{constructor(t=new Vector3,e=new Vector3,i=new Vector3,r=new Vector3){super(),this.isCubicBezierCurve3=!0,this.type="CubicBezierCurve3",this.v0=t,this.v1=e,this.v2=i,this.v3=r}getPoint(t,e=new Vector3){const i=e,r=this.v0,s=this.v1,n=this.v2,a=this.v3;return i.set(CubicBezier(t,r.x,s.x,n.x,a.x),CubicBezier(t,r.y,s.y,n.y,a.y),CubicBezier(t,r.z,s.z,n.z,a.z)),i}copy(t){return super.copy(t),this.v0.copy(t.v0),this.v1.copy(t.v1),this.v2.copy(t.v2),this.v3.copy(t.v3),this}toJSON(){const t=super.toJSON();return t.v0=this.v0.toArray(),t.v1=this.v1.toArray(),t.v2=this.v2.toArray(),t.v3=this.v3.toArray(),t}fromJSON(t){return super.fromJSON(t),this.v0.fromArray(t.v0),this.v1.fromArray(t.v1),this.v2.fromArray(t.v2),this.v3.fromArray(t.v3),this}}class LineCurve extends Curve{constructor(t=new Vector2,e=new Vector2){super(),this.isLineCurve=!0,this.type="LineCurve",this.v1=t,this.v2=e}getPoint(t,e=new Vector2){const i=e;return 1===t?i.copy(this.v2):(i.copy(this.v2).sub(this.v1),i.multiplyScalar(t).add(this.v1)),i}getPointAt(t,e){return this.getPoint(t,e)}getTangent(t,e=new Vector2){return e.subVectors(this.v2,this.v1).normalize()}getTangentAt(t,e){return this.getTangent(t,e)}copy(t){return super.copy(t),this.v1.copy(t.v1),this.v2.copy(t.v2),this}toJSON(){const t=super.toJSON();return t.v1=this.v1.toArray(),t.v2=this.v2.toArray(),t}fromJSON(t){return super.fromJSON(t),this.v1.fromArray(t.v1),this.v2.fromArray(t.v2),this}}class LineCurve3 extends Curve{constructor(t=new Vector3,e=new Vector3){super(),this.isLineCurve3=!0,this.type="LineCurve3",this.v1=t,this.v2=e}getPoint(t,e=new Vector3){const i=e;return 1===t?i.copy(this.v2):(i.copy(this.v2).sub(this.v1),i.multiplyScalar(t).add(this.v1)),i}getPointAt(t,e){return this.getPoint(t,e)}getTangent(t,e=new Vector3){return e.subVectors(this.v2,this.v1).normalize()}getTangentAt(t,e){return this.getTangent(t,e)}copy(t){return super.copy(t),this.v1.copy(t.v1),this.v2.copy(t.v2),this}toJSON(){const t=super.toJSON();return t.v1=this.v1.toArray(),t.v2=this.v2.toArray(),t}fromJSON(t){return super.fromJSON(t),this.v1.fromArray(t.v1),this.v2.fromArray(t.v2),this}}class QuadraticBezierCurve extends Curve{constructor(t=new Vector2,e=new Vector2,i=new Vector2){super(),this.isQuadraticBezierCurve=!0,this.type="QuadraticBezierCurve",this.v0=t,this.v1=e,this.v2=i}getPoint(t,e=new Vector2){const i=e,r=this.v0,s=this.v1,n=this.v2;return i.set(QuadraticBezier(t,r.x,s.x,n.x),QuadraticBezier(t,r.y,s.y,n.y)),i}copy(t){return super.copy(t),this.v0.copy(t.v0),this.v1.copy(t.v1),this.v2.copy(t.v2),this}toJSON(){const t=super.toJSON();return t.v0=this.v0.toArray(),t.v1=this.v1.toArray(),t.v2=this.v2.toArray(),t}fromJSON(t){return super.fromJSON(t),this.v0.fromArray(t.v0),this.v1.fromArray(t.v1),this.v2.fromArray(t.v2),this}}class QuadraticBezierCurve3 extends Curve{constructor(t=new Vector3,e=new Vector3,i=new Vector3){super(),this.isQuadraticBezierCurve3=!0,this.type="QuadraticBezierCurve3",this.v0=t,this.v1=e,this.v2=i}getPoint(t,e=new Vector3){const i=e,r=this.v0,s=this.v1,n=this.v2;return i.set(QuadraticBezier(t,r.x,s.x,n.x),QuadraticBezier(t,r.y,s.y,n.y),QuadraticBezier(t,r.z,s.z,n.z)),i}copy(t){return super.copy(t),this.v0.copy(t.v0),this.v1.copy(t.v1),this.v2.copy(t.v2),this}toJSON(){const t=super.toJSON();return t.v0=this.v0.toArray(),t.v1=this.v1.toArray(),t.v2=this.v2.toArray(),t}fromJSON(t){return super.fromJSON(t),this.v0.fromArray(t.v0),this.v1.fromArray(t.v1),this.v2.fromArray(t.v2),this}}class SplineCurve extends Curve{constructor(t=[]){super(),this.isSplineCurve=!0,this.type="SplineCurve",this.points=t}getPoint(t,e=new Vector2){const i=e,r=this.points,s=(r.length-1)*t,n=Math.floor(s),a=s-n,o=r[0===n?n:n-1],h=r[n],c=r[n>r.length-2?r.length-1:n+1],l=r[n>r.length-3?r.length-1:n+2];return i.set(CatmullRom(a,o.x,h.x,c.x,l.x),CatmullRom(a,o.y,h.y,c.y,l.y)),i}copy(t){super.copy(t),this.points=[];for(let e=0,i=t.points.length;e<i;e++){const i=t.points[e];this.points.push(i.clone())}return this}toJSON(){const t=super.toJSON();t.points=[];for(let e=0,i=this.points.length;e<i;e++){const i=this.points[e];t.points.push(i.toArray())}return t}fromJSON(t){super.fromJSON(t),this.points=[];for(let e=0,i=t.points.length;e<i;e++){const i=t.points[e];this.points.push((new Vector2).fromArray(i))}return this}}var Curves=Object.freeze({__proto__:null,ArcCurve,CatmullRomCurve3,CubicBezierCurve,CubicBezierCurve3,EllipseCurve,LineCurve,LineCurve3,QuadraticBezierCurve,QuadraticBezierCurve3,SplineCurve});class CurvePath extends Curve{constructor(){super(),this.type="CurvePath",this.curves=[],this.autoClose=!1}add(t){this.curves.push(t)}closePath(){const t=this.curves[0].getPoint(0),e=this.curves[this.curves.length-1].getPoint(1);if(!t.equals(e)){const i=!0===t.isVector2?"LineCurve":"LineCurve3";this.curves.push(new Curves[i](e,t))}return this}getPoint(t,e){const i=t*this.getLength(),r=this.getCurveLengths();let s=0;for(;s<r.length;){if(r[s]>=i){const t=r[s]-i,n=this.curves[s],a=n.getLength(),o=0===a?0:1-t/a;return n.getPointAt(o,e)}s++}return null}getLength(){const t=this.getCurveLengths();return t[t.length-1]}updateArcLengths(){this.needsUpdate=!0,this.cacheLengths=null,this.getCurveLengths()}getCurveLengths(){if(this.cacheLengths&&this.cacheLengths.length===this.curves.length)return this.cacheLengths;const t=[];let e=0;for(let i=0,r=this.curves.length;i<r;i++)e+=this.curves[i].getLength(),t.push(e);return this.cacheLengths=t,t}getSpacedPoints(t=40){const e=[];for(let i=0;i<=t;i++)e.push(this.getPoint(i/t));return this.autoClose&&e.push(e[0]),e}getPoints(t=12){const e=[];let i;for(let r=0,s=this.curves;r<s.length;r++){const n=s[r],a=n.isEllipseCurve?2*t:n.isLineCurve||n.isLineCurve3?1:n.isSplineCurve?t*n.points.length:t,o=n.getPoints(a);for(let t=0;t<o.length;t++){const r=o[t];i&&i.equals(r)||(e.push(r),i=r)}}return this.autoClose&&e.length>1&&!e[e.length-1].equals(e[0])&&e.push(e[0]),e}copy(t){super.copy(t),this.curves=[];for(let e=0,i=t.curves.length;e<i;e++){const i=t.curves[e];this.curves.push(i.clone())}return this.autoClose=t.autoClose,this}toJSON(){const t=super.toJSON();t.autoClose=this.autoClose,t.curves=[];for(let e=0,i=this.curves.length;e<i;e++){const i=this.curves[e];t.curves.push(i.toJSON())}return t}fromJSON(t){super.fromJSON(t),this.autoClose=t.autoClose,this.curves=[];for(let e=0,i=t.curves.length;e<i;e++){const i=t.curves[e];this.curves.push((new Curves[i.type]).fromJSON(i))}return this}}class Path extends CurvePath{constructor(t){super(),this.type="Path",this.currentPoint=new Vector2,t&&this.setFromPoints(t)}setFromPoints(t){this.moveTo(t[0].x,t[0].y);for(let e=1,i=t.length;e<i;e++)this.lineTo(t[e].x,t[e].y);return this}moveTo(t,e){return this.currentPoint.set(t,e),this}lineTo(t,e){const i=new LineCurve(this.currentPoint.clone(),new Vector2(t,e));return this.curves.push(i),this.currentPoint.set(t,e),this}quadraticCurveTo(t,e,i,r){const s=new QuadraticBezierCurve(this.currentPoint.clone(),new Vector2(t,e),new Vector2(i,r));return this.curves.push(s),this.currentPoint.set(i,r),this}bezierCurveTo(t,e,i,r,s,n){const a=new CubicBezierCurve(this.currentPoint.clone(),new Vector2(t,e),new Vector2(i,r),new Vector2(s,n));return this.curves.push(a),this.currentPoint.set(s,n),this}splineThru(t){const e=[this.currentPoint.clone()].concat(t),i=new SplineCurve(e);return this.curves.push(i),this.currentPoint.copy(t[t.length-1]),this}arc(t,e,i,r,s,n){const a=this.currentPoint.x,o=this.currentPoint.y;return this.absarc(t+a,e+o,i,r,s,n),this}absarc(t,e,i,r,s,n){return this.absellipse(t,e,i,i,r,s,n),this}ellipse(t,e,i,r,s,n,a,o){const h=this.currentPoint.x,c=this.currentPoint.y;return this.absellipse(t+h,e+c,i,r,s,n,a,o),this}absellipse(t,e,i,r,s,n,a,o){const h=new EllipseCurve(t,e,i,r,s,n,a,o);if(this.curves.length>0){const t=h.getPoint(0);t.equals(this.currentPoint)||this.lineTo(t.x,t.y)}this.curves.push(h);const c=h.getPoint(1);return this.currentPoint.copy(c),this}copy(t){return super.copy(t),this.currentPoint.copy(t.currentPoint),this}toJSON(){const t=super.toJSON();return t.currentPoint=this.currentPoint.toArray(),t}fromJSON(t){return super.fromJSON(t),this.currentPoint.fromArray(t.currentPoint),this}}class Shape extends Path{constructor(t){super(t),this.uuid=generateUUID(),this.type="Shape",this.holes=[]}getPointsHoles(t){const e=[];for(let i=0,r=this.holes.length;i<r;i++)e[i]=this.holes[i].getPoints(t);return e}extractPoints(t){return{shape:this.getPoints(t),holes:this.getPointsHoles(t)}}copy(t){super.copy(t),this.holes=[];for(let e=0,i=t.holes.length;e<i;e++){const i=t.holes[e];this.holes.push(i.clone())}return this}toJSON(){const t=super.toJSON();t.uuid=this.uuid,t.holes=[];for(let e=0,i=this.holes.length;e<i;e++){const i=this.holes[e];t.holes.push(i.toJSON())}return t}fromJSON(t){super.fromJSON(t),this.uuid=t.uuid,this.holes=[];for(let e=0,i=t.holes.length;e<i;e++){const i=t.holes[e];this.holes.push((new Path).fromJSON(i))}return this}}function earcut(t,e,i=2){const r=e&&e.length,s=r?e[0]*i:t.length;let n=linkedList(t,0,s,i,!0);const a=[];if(!n||n.next===n.prev)return a;let o,h,c;if(r&&(n=eliminateHoles(t,e,n,i)),t.length>80*i){o=1/0,h=1/0;let e=-1/0,r=-1/0;for(let n=i;n<s;n+=i){const i=t[n],s=t[n+1];i<o&&(o=i),s<h&&(h=s),i>e&&(e=i),s>r&&(r=s)}c=Math.max(e-o,r-h),c=0!==c?32767/c:0}return earcutLinked(n,a,i,o,h,c,0),a}function linkedList(t,e,i,r,s){let n;if(s===signedArea(t,e,i,r)>0)for(let s=e;s<i;s+=r)n=insertNode(s/r|0,t[s],t[s+1],n);else for(let s=i-r;s>=e;s-=r)n=insertNode(s/r|0,t[s],t[s+1],n);return n&&equals(n,n.next)&&(removeNode(n),n=n.next),n}function filterPoints(t,e){if(!t)return t;e||(e=t);let i,r=t;do{if(i=!1,r.steiner||!equals(r,r.next)&&0!==area(r.prev,r,r.next))r=r.next;else{if(removeNode(r),r=e=r.prev,r===r.next)break;i=!0}}while(i||r!==e);return e}function earcutLinked(t,e,i,r,s,n,a){if(!t)return;!a&&n&&indexCurve(t,r,s,n);let o=t;for(;t.prev!==t.next;){const h=t.prev,c=t.next;if(n?isEarHashed(t,r,s,n):isEar(t))e.push(h.i,t.i,c.i),removeNode(t),t=c.next,o=c.next;else if((t=c)===o){a?1===a?earcutLinked(t=cureLocalIntersections(filterPoints(t),e),e,i,r,s,n,2):2===a&&splitEarcut(t,e,i,r,s,n):earcutLinked(filterPoints(t),e,i,r,s,n,1);break}}}function isEar(t){const e=t.prev,i=t,r=t.next;if(area(e,i,r)>=0)return!1;const s=e.x,n=i.x,a=r.x,o=e.y,h=i.y,c=r.y,l=Math.min(s,n,a),u=Math.min(o,h,c),p=Math.max(s,n,a),d=Math.max(o,h,c);let m=r.next;for(;m!==e;){if(m.x>=l&&m.x<=p&&m.y>=u&&m.y<=d&&pointInTriangleExceptFirst(s,o,n,h,a,c,m.x,m.y)&&area(m.prev,m,m.next)>=0)return!1;m=m.next}return!0}function isEarHashed(t,e,i,r){const s=t.prev,n=t,a=t.next;if(area(s,n,a)>=0)return!1;const o=s.x,h=n.x,c=a.x,l=s.y,u=n.y,p=a.y,d=Math.min(o,h,c),m=Math.min(l,u,p),y=Math.max(o,h,c),f=Math.max(l,u,p),g=zOrder(d,m,e,i,r),x=zOrder(y,f,e,i,r);let _=t.prevZ,v=t.nextZ;for(;_&&_.z>=g&&v&&v.z<=x;){if(_.x>=d&&_.x<=y&&_.y>=m&&_.y<=f&&_!==s&&_!==a&&pointInTriangleExceptFirst(o,l,h,u,c,p,_.x,_.y)&&area(_.prev,_,_.next)>=0)return!1;if(_=_.prevZ,v.x>=d&&v.x<=y&&v.y>=m&&v.y<=f&&v!==s&&v!==a&&pointInTriangleExceptFirst(o,l,h,u,c,p,v.x,v.y)&&area(v.prev,v,v.next)>=0)return!1;v=v.nextZ}for(;_&&_.z>=g;){if(_.x>=d&&_.x<=y&&_.y>=m&&_.y<=f&&_!==s&&_!==a&&pointInTriangleExceptFirst(o,l,h,u,c,p,_.x,_.y)&&area(_.prev,_,_.next)>=0)return!1;_=_.prevZ}for(;v&&v.z<=x;){if(v.x>=d&&v.x<=y&&v.y>=m&&v.y<=f&&v!==s&&v!==a&&pointInTriangleExceptFirst(o,l,h,u,c,p,v.x,v.y)&&area(v.prev,v,v.next)>=0)return!1;v=v.nextZ}return!0}function cureLocalIntersections(t,e){let i=t;do{const r=i.prev,s=i.next.next;!equals(r,s)&&intersects(r,i,i.next,s)&&locallyInside(r,s)&&locallyInside(s,r)&&(e.push(r.i,i.i,s.i),removeNode(i),removeNode(i.next),i=t=s),i=i.next}while(i!==t);return filterPoints(i)}function splitEarcut(t,e,i,r,s,n){let a=t;do{let t=a.next.next;for(;t!==a.prev;){if(a.i!==t.i&&isValidDiagonal(a,t)){let o=splitPolygon(a,t);return a=filterPoints(a,a.next),o=filterPoints(o,o.next),earcutLinked(a,e,i,r,s,n,0),void earcutLinked(o,e,i,r,s,n,0)}t=t.next}a=a.next}while(a!==t)}function eliminateHoles(t,e,i,r){const s=[];for(let i=0,n=e.length;i<n;i++){const a=linkedList(t,e[i]*r,i<n-1?e[i+1]*r:t.length,r,!1);a===a.next&&(a.steiner=!0),s.push(getLeftmost(a))}s.sort(compareXYSlope);for(let t=0;t<s.length;t++)i=eliminateHole(s[t],i);return i}function compareXYSlope(t,e){let i=t.x-e.x;if(0===i&&(i=t.y-e.y,0===i)){i=(t.next.y-t.y)/(t.next.x-t.x)-(e.next.y-e.y)/(e.next.x-e.x)}return i}function eliminateHole(t,e){const i=findHoleBridge(t,e);if(!i)return e;const r=splitPolygon(i,t);return filterPoints(r,r.next),filterPoints(i,i.next)}function findHoleBridge(t,e){let i=e;const r=t.x,s=t.y;let n,a=-1/0;if(equals(t,i))return i;do{if(equals(t,i.next))return i.next;if(s<=i.y&&s>=i.next.y&&i.next.y!==i.y){const t=i.x+(s-i.y)*(i.next.x-i.x)/(i.next.y-i.y);if(t<=r&&t>a&&(a=t,n=i.x<i.next.x?i:i.next,t===r))return n}i=i.next}while(i!==e);if(!n)return null;const o=n,h=n.x,c=n.y;let l=1/0;i=n;do{if(r>=i.x&&i.x>=h&&r!==i.x&&pointInTriangle(s<c?r:a,s,h,c,s<c?a:r,s,i.x,i.y)){const e=Math.abs(s-i.y)/(r-i.x);locallyInside(i,t)&&(e<l||e===l&&(i.x>n.x||i.x===n.x&&sectorContainsSector(n,i)))&&(n=i,l=e)}i=i.next}while(i!==o);return n}function sectorContainsSector(t,e){return area(t.prev,t,e.prev)<0&&area(e.next,t,t.next)<0}function indexCurve(t,e,i,r){let s=t;do{0===s.z&&(s.z=zOrder(s.x,s.y,e,i,r)),s.prevZ=s.prev,s.nextZ=s.next,s=s.next}while(s!==t);s.prevZ.nextZ=null,s.prevZ=null,sortLinked(s)}function sortLinked(t){let e,i=1;do{let r,s=t;t=null;let n=null;for(e=0;s;){e++;let a=s,o=0;for(let t=0;t<i&&(o++,a=a.nextZ,a);t++);let h=i;for(;o>0||h>0&&a;)0!==o&&(0===h||!a||s.z<=a.z)?(r=s,s=s.nextZ,o--):(r=a,a=a.nextZ,h--),n?n.nextZ=r:t=r,r.prevZ=n,n=r;s=a}n.nextZ=null,i*=2}while(e>1);return t}function zOrder(t,e,i,r,s){return(t=1431655765&((t=858993459&((t=252645135&((t=16711935&((t=(t-i)*s|0)|t<<8))|t<<4))|t<<2))|t<<1))|(e=1431655765&((e=858993459&((e=252645135&((e=16711935&((e=(e-r)*s|0)|e<<8))|e<<4))|e<<2))|e<<1))<<1}function getLeftmost(t){let e=t,i=t;do{(e.x<i.x||e.x===i.x&&e.y<i.y)&&(i=e),e=e.next}while(e!==t);return i}function pointInTriangle(t,e,i,r,s,n,a,o){return(s-a)*(e-o)>=(t-a)*(n-o)&&(t-a)*(r-o)>=(i-a)*(e-o)&&(i-a)*(n-o)>=(s-a)*(r-o)}function pointInTriangleExceptFirst(t,e,i,r,s,n,a,o){return!(t===a&&e===o)&&pointInTriangle(t,e,i,r,s,n,a,o)}function isValidDiagonal(t,e){return t.next.i!==e.i&&t.prev.i!==e.i&&!intersectsPolygon(t,e)&&(locallyInside(t,e)&&locallyInside(e,t)&&middleInside(t,e)&&(area(t.prev,t,e.prev)||area(t,e.prev,e))||equals(t,e)&&area(t.prev,t,t.next)>0&&area(e.prev,e,e.next)>0)}function area(t,e,i){return(e.y-t.y)*(i.x-e.x)-(e.x-t.x)*(i.y-e.y)}function equals(t,e){return t.x===e.x&&t.y===e.y}function intersects(t,e,i,r){const s=sign(area(t,e,i)),n=sign(area(t,e,r)),a=sign(area(i,r,t)),o=sign(area(i,r,e));return s!==n&&a!==o||(!(0!==s||!onSegment(t,i,e))||(!(0!==n||!onSegment(t,r,e))||(!(0!==a||!onSegment(i,t,r))||!(0!==o||!onSegment(i,e,r)))))}function onSegment(t,e,i){return e.x<=Math.max(t.x,i.x)&&e.x>=Math.min(t.x,i.x)&&e.y<=Math.max(t.y,i.y)&&e.y>=Math.min(t.y,i.y)}function sign(t){return t>0?1:t<0?-1:0}function intersectsPolygon(t,e){let i=t;do{if(i.i!==t.i&&i.next.i!==t.i&&i.i!==e.i&&i.next.i!==e.i&&intersects(i,i.next,t,e))return!0;i=i.next}while(i!==t);return!1}function locallyInside(t,e){return area(t.prev,t,t.next)<0?area(t,e,t.next)>=0&&area(t,t.prev,e)>=0:area(t,e,t.prev)<0||area(t,t.next,e)<0}function middleInside(t,e){let i=t,r=!1;const s=(t.x+e.x)/2,n=(t.y+e.y)/2;do{i.y>n!=i.next.y>n&&i.next.y!==i.y&&s<(i.next.x-i.x)*(n-i.y)/(i.next.y-i.y)+i.x&&(r=!r),i=i.next}while(i!==t);return r}function splitPolygon(t,e){const i=createNode(t.i,t.x,t.y),r=createNode(e.i,e.x,e.y),s=t.next,n=e.prev;return t.next=e,e.prev=t,i.next=s,s.prev=i,r.next=i,i.prev=r,n.next=r,r.prev=n,r}function insertNode(t,e,i,r){const s=createNode(t,e,i);return r?(s.next=r.next,s.prev=r,r.next.prev=s,r.next=s):(s.prev=s,s.next=s),s}function removeNode(t){t.next.prev=t.prev,t.prev.next=t.next,t.prevZ&&(t.prevZ.nextZ=t.nextZ),t.nextZ&&(t.nextZ.prevZ=t.prevZ)}function createNode(t,e,i){return{i:t,x:e,y:i,prev:null,next:null,z:0,prevZ:null,nextZ:null,steiner:!1}}function signedArea(t,e,i,r){let s=0;for(let n=e,a=i-r;n<i;n+=r)s+=(t[a]-t[n])*(t[n+1]+t[a+1]),a=n;return s}class Earcut{static triangulate(t,e,i=2){return earcut(t,e,i)}}class ShapeUtils{static area(t){const e=t.length;let i=0;for(let r=e-1,s=0;s<e;r=s++)i+=t[r].x*t[s].y-t[s].x*t[r].y;return.5*i}static isClockWise(t){return ShapeUtils.area(t)<0}static triangulateShape(t,e){const i=[],r=[],s=[];removeDupEndPts(t),addContour(i,t);let n=t.length;e.forEach(removeDupEndPts);for(let t=0;t<e.length;t++)r.push(n),n+=e[t].length,addContour(i,e[t]);const a=Earcut.triangulate(i,r);for(let t=0;t<a.length;t+=3)s.push(a.slice(t,t+3));return s}}function removeDupEndPts(t){const e=t.length;e>2&&t[e-1].equals(t[0])&&t.pop()}function addContour(t,e){for(let i=0;i<e.length;i++)t.push(e[i].x),t.push(e[i].y)}class ExtrudeGeometry extends BufferGeometry{constructor(t=new Shape([new Vector2(.5,.5),new Vector2(-.5,.5),new Vector2(-.5,-.5),new Vector2(.5,-.5)]),e={}){super(),this.type="ExtrudeGeometry",this.parameters={shapes:t,options:e},t=Array.isArray(t)?t:[t];const i=this,r=[],s=[];for(let e=0,i=t.length;e<i;e++){n(t[e])}function n(t){const n=[],a=void 0!==e.curveSegments?e.curveSegments:12,o=void 0!==e.steps?e.steps:1,h=void 0!==e.depth?e.depth:1;let c=void 0===e.bevelEnabled||e.bevelEnabled,l=void 0!==e.bevelThickness?e.bevelThickness:.2,u=void 0!==e.bevelSize?e.bevelSize:l-.1,p=void 0!==e.bevelOffset?e.bevelOffset:0,d=void 0!==e.bevelSegments?e.bevelSegments:3;const m=e.extrudePath,y=void 0!==e.UVGenerator?e.UVGenerator:WorldUVGenerator;let f,g,x,_,v,b=!1;m&&(f=m.getSpacedPoints(o),b=!0,c=!1,g=m.computeFrenetFrames(o,!1),x=new Vector3,_=new Vector3,v=new Vector3),c||(d=0,l=0,u=0,p=0);const M=t.extractPoints(a);let w=M.shape;const S=M.holes;if(!ShapeUtils.isClockWise(w)){w=w.reverse();for(let t=0,e=S.length;t<e;t++){const e=S[t];ShapeUtils.isClockWise(e)&&(S[t]=e.reverse())}}function A(t){const e=1e-10*1e-10;let i=t[0];for(let r=1;r<=t.length;r++){const s=r%t.length,n=t[s],a=n.x-i.x,o=n.y-i.y,h=a*a+o*o,c=Math.max(Math.abs(n.x),Math.abs(n.y),Math.abs(i.x),Math.abs(i.y));h<=e*c*c?(t.splice(s,1),r--):i=n}}A(w),S.forEach(A);const T=S.length,C=w;for(let t=0;t<T;t++){const e=S[t];w=w.concat(e)}function B(t,e,i){return e||console.error("THREE.ExtrudeGeometry: vec does not exist"),t.clone().addScaledVector(e,i)}const I=w.length;function z(t,e,i){let r,s,n;const a=t.x-e.x,o=t.y-e.y,h=i.x-t.x,c=i.y-t.y,l=a*a+o*o,u=a*c-o*h;if(Math.abs(u)>Number.EPSILON){const u=Math.sqrt(l),p=Math.sqrt(h*h+c*c),d=e.x-o/u,m=e.y+a/u,y=((i.x-c/p-d)*c-(i.y+h/p-m)*h)/(a*c-o*h);r=d+a*y-t.x,s=m+o*y-t.y;const f=r*r+s*s;if(f<=2)return new Vector2(r,s);n=Math.sqrt(f/2)}else{let t=!1;a>Number.EPSILON?h>Number.EPSILON&&(t=!0):a<-Number.EPSILON?h<-Number.EPSILON&&(t=!0):Math.sign(o)===Math.sign(c)&&(t=!0),t?(r=-o,s=a,n=Math.sqrt(l)):(r=a,s=o,n=Math.sqrt(l/2))}return new Vector2(r/n,s/n)}const P=[];for(let t=0,e=C.length,i=e-1,r=t+1;t<e;t++,i++,r++)i===e&&(i=0),r===e&&(r=0),P[t]=z(C[t],C[i],C[r]);const R=[];let V,E,F=P.concat();for(let t=0,e=T;t<e;t++){const e=S[t];V=[];for(let t=0,i=e.length,r=i-1,s=t+1;t<i;t++,r++,s++)r===i&&(r=0),s===i&&(s=0),V[t]=z(e[t],e[r],e[s]);R.push(V),F=F.concat(V)}if(0===d)E=ShapeUtils.triangulateShape(C,S);else{const t=[],e=[];for(let i=0;i<d;i++){const r=i/d,s=l*Math.cos(r*Math.PI/2),n=u*Math.sin(r*Math.PI/2)+p;for(let e=0,i=C.length;e<i;e++){const i=B(C[e],P[e],n);D(i.x,i.y,-s),0===r&&t.push(i)}for(let t=0,i=T;t<i;t++){const i=S[t];V=R[t];const a=[];for(let t=0,e=i.length;t<e;t++){const e=B(i[t],V[t],n);D(e.x,e.y,-s),0===r&&a.push(e)}0===r&&e.push(a)}}E=ShapeUtils.triangulateShape(t,e)}const L=E.length,k=u+p;for(let t=0;t<I;t++){const e=c?B(w[t],F[t],k):w[t];b?(_.copy(g.normals[0]).multiplyScalar(e.x),x.copy(g.binormals[0]).multiplyScalar(e.y),v.copy(f[0]).add(_).add(x),D(v.x,v.y,v.z)):D(e.x,e.y,0)}for(let t=1;t<=o;t++)for(let e=0;e<I;e++){const i=c?B(w[e],F[e],k):w[e];b?(_.copy(g.normals[t]).multiplyScalar(i.x),x.copy(g.binormals[t]).multiplyScalar(i.y),v.copy(f[t]).add(_).add(x),D(v.x,v.y,v.z)):D(i.x,i.y,h/o*t)}for(let t=d-1;t>=0;t--){const e=t/d,i=l*Math.cos(e*Math.PI/2),r=u*Math.sin(e*Math.PI/2)+p;for(let t=0,e=C.length;t<e;t++){const e=B(C[t],P[t],r);D(e.x,e.y,h+i)}for(let t=0,e=S.length;t<e;t++){const e=S[t];V=R[t];for(let t=0,s=e.length;t<s;t++){const s=B(e[t],V[t],r);b?D(s.x,s.y+f[o-1].y,f[o-1].x+i):D(s.x,s.y,h+i)}}}function O(t,e){let i=t.length;for(;--i>=0;){const r=i;let s=i-1;s<0&&(s=t.length-1);for(let t=0,i=o+2*d;t<i;t++){const i=I*t,n=I*(t+1);G(e+r+i,e+s+i,e+s+n,e+r+n)}}}function D(t,e,i){n.push(t),n.push(e),n.push(i)}function N(t,e,s){$(t),$(e),$(s);const n=r.length/3,a=y.generateTopUV(i,r,n-3,n-2,n-1);U(a[0]),U(a[1]),U(a[2])}function G(t,e,s,n){$(t),$(e),$(n),$(e),$(s),$(n);const a=r.length/3,o=y.generateSideWallUV(i,r,a-6,a-3,a-2,a-1);U(o[0]),U(o[1]),U(o[3]),U(o[1]),U(o[2]),U(o[3])}function $(t){r.push(n[3*t+0]),r.push(n[3*t+1]),r.push(n[3*t+2])}function U(t){s.push(t.x),s.push(t.y)}!function(){const t=r.length/3;if(c){let t=0,e=I*t;for(let t=0;t<L;t++){const i=E[t];N(i[2]+e,i[1]+e,i[0]+e)}t=o+2*d,e=I*t;for(let t=0;t<L;t++){const i=E[t];N(i[0]+e,i[1]+e,i[2]+e)}}else{for(let t=0;t<L;t++){const e=E[t];N(e[2],e[1],e[0])}for(let t=0;t<L;t++){const e=E[t];N(e[0]+I*o,e[1]+I*o,e[2]+I*o)}}i.addGroup(t,r.length/3-t,0)}(),function(){const t=r.length/3;let e=0;O(C,e),e+=C.length;for(let t=0,i=S.length;t<i;t++){const i=S[t];O(i,e),e+=i.length}i.addGroup(t,r.length/3-t,1)}()}this.setAttribute("position",new Float32BufferAttribute(r,3)),this.setAttribute("uv",new Float32BufferAttribute(s,2)),this.computeVertexNormals()}copy(t){return super.copy(t),this.parameters=Object.assign({},t.parameters),this}toJSON(){const t=super.toJSON();return toJSON$1(this.parameters.shapes,this.parameters.options,t)}static fromJSON(t,e){const i=[];for(let r=0,s=t.shapes.length;r<s;r++){const s=e[t.shapes[r]];i.push(s)}const r=t.options.extrudePath;return void 0!==r&&(t.options.extrudePath=(new Curves[r.type]).fromJSON(r)),new ExtrudeGeometry(i,t.options)}}const WorldUVGenerator={generateTopUV:function(t,e,i,r,s){const n=e[3*i],a=e[3*i+1],o=e[3*r],h=e[3*r+1],c=e[3*s],l=e[3*s+1];return[new Vector2(n,a),new Vector2(o,h),new Vector2(c,l)]},generateSideWallUV:function(t,e,i,r,s,n){const a=e[3*i],o=e[3*i+1],h=e[3*i+2],c=e[3*r],l=e[3*r+1],u=e[3*r+2],p=e[3*s],d=e[3*s+1],m=e[3*s+2],y=e[3*n],f=e[3*n+1],g=e[3*n+2];return Math.abs(o-l)<Math.abs(a-c)?[new Vector2(a,1-h),new Vector2(c,1-u),new Vector2(p,1-m),new Vector2(y,1-g)]:[new Vector2(o,1-h),new Vector2(l,1-u),new Vector2(d,1-m),new Vector2(f,1-g)]}};function toJSON$1(t,e,i){if(i.shapes=[],Array.isArray(t))for(let e=0,r=t.length;e<r;e++){const r=t[e];i.shapes.push(r.uuid)}else i.shapes.push(t.uuid);return i.options=Object.assign({},e),void 0!==e.extrudePath&&(i.options.extrudePath=e.extrudePath.toJSON()),i}class IcosahedronGeometry extends PolyhedronGeometry{constructor(t=1,e=0){const i=(1+Math.sqrt(5))/2;super([-1,i,0,1,i,0,-1,-i,0,1,-i,0,0,-1,i,0,1,i,0,-1,-i,0,1,-i,i,0,-1,i,0,1,-i,0,-1,-i,0,1],[0,11,5,0,5,1,0,1,7,0,7,10,0,10,11,1,5,9,5,11,4,11,10,2,10,7,6,7,1,8,3,9,4,3,4,2,3,2,6,3,6,8,3,8,9,4,9,5,2,4,11,6,2,10,8,6,7,9,8,1],t,e),this.type="IcosahedronGeometry",this.parameters={radius:t,detail:e}}static fromJSON(t){return new IcosahedronGeometry(t.radius,t.detail)}}class LatheGeometry extends BufferGeometry{constructor(t=[new Vector2(0,-.5),new Vector2(.5,0),new Vector2(0,.5)],e=12,i=0,r=2*Math.PI){super(),this.type="LatheGeometry",this.parameters={points:t,segments:e,phiStart:i,phiLength:r},e=Math.floor(e),r=clamp(r,0,2*Math.PI);const s=[],n=[],a=[],o=[],h=[],c=1/e,l=new Vector3,u=new Vector2,p=new Vector3,d=new Vector3,m=new Vector3;let y=0,f=0;for(let e=0;e<=t.length-1;e++)switch(e){case 0:y=t[e+1].x-t[e].x,f=t[e+1].y-t[e].y,p.x=1*f,p.y=-y,p.z=0*f,m.copy(p),p.normalize(),o.push(p.x,p.y,p.z);break;case t.length-1:o.push(m.x,m.y,m.z);break;default:y=t[e+1].x-t[e].x,f=t[e+1].y-t[e].y,p.x=1*f,p.y=-y,p.z=0*f,d.copy(p),p.x+=m.x,p.y+=m.y,p.z+=m.z,p.normalize(),o.push(p.x,p.y,p.z),m.copy(d)}for(let s=0;s<=e;s++){const p=i+s*c*r,d=Math.sin(p),m=Math.cos(p);for(let i=0;i<=t.length-1;i++){l.x=t[i].x*d,l.y=t[i].y,l.z=t[i].x*m,n.push(l.x,l.y,l.z),u.x=s/e,u.y=i/(t.length-1),a.push(u.x,u.y);const r=o[3*i+0]*d,c=o[3*i+1],p=o[3*i+0]*m;h.push(r,c,p)}}for(let i=0;i<e;i++)for(let e=0;e<t.length-1;e++){const r=e+i*t.length,n=r,a=r+t.length,o=r+t.length+1,h=r+1;s.push(n,a,h),s.push(o,h,a)}this.setIndex(s),this.setAttribute("position",new Float32BufferAttribute(n,3)),this.setAttribute("uv",new Float32BufferAttribute(a,2)),this.setAttribute("normal",new Float32BufferAttribute(h,3))}copy(t){return super.copy(t),this.parameters=Object.assign({},t.parameters),this}static fromJSON(t){return new LatheGeometry(t.points,t.segments,t.phiStart,t.phiLength)}}class OctahedronGeometry extends PolyhedronGeometry{constructor(t=1,e=0){super([1,0,0,-1,0,0,0,1,0,0,-1,0,0,0,1,0,0,-1],[0,2,4,0,4,3,0,3,5,0,5,2,1,2,5,1,5,3,1,3,4,1,4,2],t,e),this.type="OctahedronGeometry",this.parameters={radius:t,detail:e}}static fromJSON(t){return new OctahedronGeometry(t.radius,t.detail)}}class PlaneGeometry extends BufferGeometry{constructor(t=1,e=1,i=1,r=1){super(),this.type="PlaneGeometry",this.parameters={width:t,height:e,widthSegments:i,heightSegments:r};const s=t/2,n=e/2,a=Math.floor(i),o=Math.floor(r),h=a+1,c=o+1,l=t/a,u=e/o,p=[],d=[],m=[],y=[];for(let t=0;t<c;t++){const e=t*u-n;for(let i=0;i<h;i++){const r=i*l-s;d.push(r,-e,0),m.push(0,0,1),y.push(i/a),y.push(1-t/o)}}for(let t=0;t<o;t++)for(let e=0;e<a;e++){const i=e+h*t,r=e+h*(t+1),s=e+1+h*(t+1),n=e+1+h*t;p.push(i,r,n),p.push(r,s,n)}this.setIndex(p),this.setAttribute("position",new Float32BufferAttribute(d,3)),this.setAttribute("normal",new Float32BufferAttribute(m,3)),this.setAttribute("uv",new Float32BufferAttribute(y,2))}copy(t){return super.copy(t),this.parameters=Object.assign({},t.parameters),this}static fromJSON(t){return new PlaneGeometry(t.width,t.height,t.widthSegments,t.heightSegments)}}class RingGeometry extends BufferGeometry{constructor(t=.5,e=1,i=32,r=1,s=0,n=2*Math.PI){super(),this.type="RingGeometry",this.parameters={innerRadius:t,outerRadius:e,thetaSegments:i,phiSegments:r,thetaStart:s,thetaLength:n},i=Math.max(3,i);const a=[],o=[],h=[],c=[];let l=t;const u=(e-t)/(r=Math.max(1,r)),p=new Vector3,d=new Vector2;for(let t=0;t<=r;t++){for(let t=0;t<=i;t++){const r=s+t/i*n;p.x=l*Math.cos(r),p.y=l*Math.sin(r),o.push(p.x,p.y,p.z),h.push(0,0,1),d.x=(p.x/e+1)/2,d.y=(p.y/e+1)/2,c.push(d.x,d.y)}l+=u}for(let t=0;t<r;t++){const e=t*(i+1);for(let t=0;t<i;t++){const r=t+e,s=r,n=r+i+1,o=r+i+2,h=r+1;a.push(s,n,h),a.push(n,o,h)}}this.setIndex(a),this.setAttribute("position",new Float32BufferAttribute(o,3)),this.setAttribute("normal",new Float32BufferAttribute(h,3)),this.setAttribute("uv",new Float32BufferAttribute(c,2))}copy(t){return super.copy(t),this.parameters=Object.assign({},t.parameters),this}static fromJSON(t){return new RingGeometry(t.innerRadius,t.outerRadius,t.thetaSegments,t.phiSegments,t.thetaStart,t.thetaLength)}}class ShapeGeometry extends BufferGeometry{constructor(t=new Shape([new Vector2(0,.5),new Vector2(-.5,-.5),new Vector2(.5,-.5)]),e=12){super(),this.type="ShapeGeometry",this.parameters={shapes:t,curveSegments:e};const i=[],r=[],s=[],n=[];let a=0,o=0;if(!1===Array.isArray(t))h(t);else for(let e=0;e<t.length;e++)h(t[e]),this.addGroup(a,o,e),a+=o,o=0;function h(t){const a=r.length/3,h=t.extractPoints(e);let c=h.shape;const l=h.holes;!1===ShapeUtils.isClockWise(c)&&(c=c.reverse());for(let t=0,e=l.length;t<e;t++){const e=l[t];!0===ShapeUtils.isClockWise(e)&&(l[t]=e.reverse())}const u=ShapeUtils.triangulateShape(c,l);for(let t=0,e=l.length;t<e;t++){const e=l[t];c=c.concat(e)}for(let t=0,e=c.length;t<e;t++){const e=c[t];r.push(e.x,e.y,0),s.push(0,0,1),n.push(e.x,e.y)}for(let t=0,e=u.length;t<e;t++){const e=u[t],r=e[0]+a,s=e[1]+a,n=e[2]+a;i.push(r,s,n),o+=3}}this.setIndex(i),this.setAttribute("position",new Float32BufferAttribute(r,3)),this.setAttribute("normal",new Float32BufferAttribute(s,3)),this.setAttribute("uv",new Float32BufferAttribute(n,2))}copy(t){return super.copy(t),this.parameters=Object.assign({},t.parameters),this}toJSON(){const t=super.toJSON();return toJSON(this.parameters.shapes,t)}static fromJSON(t,e){const i=[];for(let r=0,s=t.shapes.length;r<s;r++){const s=e[t.shapes[r]];i.push(s)}return new ShapeGeometry(i,t.curveSegments)}}function toJSON(t,e){if(e.shapes=[],Array.isArray(t))for(let i=0,r=t.length;i<r;i++){const r=t[i];e.shapes.push(r.uuid)}else e.shapes.push(t.uuid);return e}class SphereGeometry extends BufferGeometry{constructor(t=1,e=32,i=16,r=0,s=2*Math.PI,n=0,a=Math.PI){super(),this.type="SphereGeometry",this.parameters={radius:t,widthSegments:e,heightSegments:i,phiStart:r,phiLength:s,thetaStart:n,thetaLength:a},e=Math.max(3,Math.floor(e)),i=Math.max(2,Math.floor(i));const o=Math.min(n+a,Math.PI);let h=0;const c=[],l=new Vector3,u=new Vector3,p=[],d=[],m=[],y=[];for(let p=0;p<=i;p++){const f=[],g=p/i;let x=0;0===p&&0===n?x=.5/e:p===i&&o===Math.PI&&(x=-.5/e);for(let i=0;i<=e;i++){const o=i/e;l.x=-t*Math.cos(r+o*s)*Math.sin(n+g*a),l.y=t*Math.cos(n+g*a),l.z=t*Math.sin(r+o*s)*Math.sin(n+g*a),d.push(l.x,l.y,l.z),u.copy(l).normalize(),m.push(u.x,u.y,u.z),y.push(o+x,1-g),f.push(h++)}c.push(f)}for(let t=0;t<i;t++)for(let r=0;r<e;r++){const e=c[t][r+1],s=c[t][r],a=c[t+1][r],h=c[t+1][r+1];(0!==t||n>0)&&p.push(e,s,h),(t!==i-1||o<Math.PI)&&p.push(s,a,h)}this.setIndex(p),this.setAttribute("position",new Float32BufferAttribute(d,3)),this.setAttribute("normal",new Float32BufferAttribute(m,3)),this.setAttribute("uv",new Float32BufferAttribute(y,2))}copy(t){return super.copy(t),this.parameters=Object.assign({},t.parameters),this}static fromJSON(t){return new SphereGeometry(t.radius,t.widthSegments,t.heightSegments,t.phiStart,t.phiLength,t.thetaStart,t.thetaLength)}}class TetrahedronGeometry extends PolyhedronGeometry{constructor(t=1,e=0){super([1,1,1,-1,-1,1,-1,1,-1,1,-1,-1],[2,1,0,0,3,2,1,3,0,2,3,1],t,e),this.type="TetrahedronGeometry",this.parameters={radius:t,detail:e}}static fromJSON(t){return new TetrahedronGeometry(t.radius,t.detail)}}class TorusGeometry extends BufferGeometry{constructor(t=1,e=.4,i=12,r=48,s=2*Math.PI){super(),this.type="TorusGeometry",this.parameters={radius:t,tube:e,radialSegments:i,tubularSegments:r,arc:s},i=Math.floor(i),r=Math.floor(r);const n=[],a=[],o=[],h=[],c=new Vector3,l=new Vector3,u=new Vector3;for(let n=0;n<=i;n++)for(let p=0;p<=r;p++){const d=p/r*s,m=n/i*Math.PI*2;l.x=(t+e*Math.cos(m))*Math.cos(d),l.y=(t+e*Math.cos(m))*Math.sin(d),l.z=e*Math.sin(m),a.push(l.x,l.y,l.z),c.x=t*Math.cos(d),c.y=t*Math.sin(d),u.subVectors(l,c).normalize(),o.push(u.x,u.y,u.z),h.push(p/r),h.push(n/i)}for(let t=1;t<=i;t++)for(let e=1;e<=r;e++){const i=(r+1)*t+e-1,s=(r+1)*(t-1)+e-1,a=(r+1)*(t-1)+e,o=(r+1)*t+e;n.push(i,s,o),n.push(s,a,o)}this.setIndex(n),this.setAttribute("position",new Float32BufferAttribute(a,3)),this.setAttribute("normal",new Float32BufferAttribute(o,3)),this.setAttribute("uv",new Float32BufferAttribute(h,2))}copy(t){return super.copy(t),this.parameters=Object.assign({},t.parameters),this}static fromJSON(t){return new TorusGeometry(t.radius,t.tube,t.radialSegments,t.tubularSegments,t.arc)}}class TorusKnotGeometry extends BufferGeometry{constructor(t=1,e=.4,i=64,r=8,s=2,n=3){super(),this.type="TorusKnotGeometry",this.parameters={radius:t,tube:e,tubularSegments:i,radialSegments:r,p:s,q:n},i=Math.floor(i),r=Math.floor(r);const a=[],o=[],h=[],c=[],l=new Vector3,u=new Vector3,p=new Vector3,d=new Vector3,m=new Vector3,y=new Vector3,f=new Vector3;for(let a=0;a<=i;++a){const x=a/i*s*Math.PI*2;g(x,s,n,t,p),g(x+.01,s,n,t,d),y.subVectors(d,p),f.addVectors(d,p),m.crossVectors(y,f),f.crossVectors(m,y),m.normalize(),f.normalize();for(let t=0;t<=r;++t){const s=t/r*Math.PI*2,n=-e*Math.cos(s),d=e*Math.sin(s);l.x=p.x+(n*f.x+d*m.x),l.y=p.y+(n*f.y+d*m.y),l.z=p.z+(n*f.z+d*m.z),o.push(l.x,l.y,l.z),u.subVectors(l,p).normalize(),h.push(u.x,u.y,u.z),c.push(a/i),c.push(t/r)}}for(let t=1;t<=i;t++)for(let e=1;e<=r;e++){const i=(r+1)*(t-1)+(e-1),s=(r+1)*t+(e-1),n=(r+1)*t+e,o=(r+1)*(t-1)+e;a.push(i,s,o),a.push(s,n,o)}function g(t,e,i,r,s){const n=Math.cos(t),a=Math.sin(t),o=i/e*t,h=Math.cos(o);s.x=r*(2+h)*.5*n,s.y=r*(2+h)*a*.5,s.z=r*Math.sin(o)*.5}this.setIndex(a),this.setAttribute("position",new Float32BufferAttribute(o,3)),this.setAttribute("normal",new Float32BufferAttribute(h,3)),this.setAttribute("uv",new Float32BufferAttribute(c,2))}copy(t){return super.copy(t),this.parameters=Object.assign({},t.parameters),this}static fromJSON(t){return new TorusKnotGeometry(t.radius,t.tube,t.tubularSegments,t.radialSegments,t.p,t.q)}}class TubeGeometry extends BufferGeometry{constructor(t=new QuadraticBezierCurve3(new Vector3(-1,-1,0),new Vector3(-1,1,0),new Vector3(1,1,0)),e=64,i=1,r=8,s=!1){super(),this.type="TubeGeometry",this.parameters={path:t,tubularSegments:e,radius:i,radialSegments:r,closed:s};const n=t.computeFrenetFrames(e,s);this.tangents=n.tangents,this.normals=n.normals,this.binormals=n.binormals;const a=new Vector3,o=new Vector3,h=new Vector2;let c=new Vector3;const l=[],u=[],p=[],d=[];function m(s){c=t.getPointAt(s/e,c);const h=n.normals[s],p=n.binormals[s];for(let t=0;t<=r;t++){const e=t/r*Math.PI*2,s=Math.sin(e),n=-Math.cos(e);o.x=n*h.x+s*p.x,o.y=n*h.y+s*p.y,o.z=n*h.z+s*p.z,o.normalize(),u.push(o.x,o.y,o.z),a.x=c.x+i*o.x,a.y=c.y+i*o.y,a.z=c.z+i*o.z,l.push(a.x,a.y,a.z)}}!function(){for(let t=0;t<e;t++)m(t);m(!1===s?e:0),function(){for(let t=0;t<=e;t++)for(let i=0;i<=r;i++)h.x=t/e,h.y=i/r,p.push(h.x,h.y)}(),function(){for(let t=1;t<=e;t++)for(let e=1;e<=r;e++){const i=(r+1)*(t-1)+(e-1),s=(r+1)*t+(e-1),n=(r+1)*t+e,a=(r+1)*(t-1)+e;d.push(i,s,a),d.push(s,n,a)}}()}(),this.setIndex(d),this.setAttribute("position",new Float32BufferAttribute(l,3)),this.setAttribute("normal",new Float32BufferAttribute(u,3)),this.setAttribute("uv",new Float32BufferAttribute(p,2))}copy(t){return super.copy(t),this.parameters=Object.assign({},t.parameters),this}toJSON(){const t=super.toJSON();return t.path=this.parameters.path.toJSON(),t}static fromJSON(t){return new TubeGeometry((new Curves[t.path.type]).fromJSON(t.path),t.tubularSegments,t.radius,t.radialSegments,t.closed)}}class WireframeGeometry extends BufferGeometry{constructor(t=null){if(super(),this.type="WireframeGeometry",this.parameters={geometry:t},null!==t){const e=[],i=new Set,r=new Vector3,s=new Vector3;if(null!==t.index){const n=t.attributes.position,a=t.index;let o=t.groups;0===o.length&&(o=[{start:0,count:a.count,materialIndex:0}]);for(let t=0,h=o.length;t<h;++t){const h=o[t],c=h.start;for(let t=c,o=c+h.count;t<o;t+=3)for(let o=0;o<3;o++){const h=a.getX(t+o),c=a.getX(t+(o+1)%3);r.fromBufferAttribute(n,h),s.fromBufferAttribute(n,c),!0===isUniqueEdge(r,s,i)&&(e.push(r.x,r.y,r.z),e.push(s.x,s.y,s.z))}}}else{const n=t.attributes.position;for(let t=0,a=n.count/3;t<a;t++)for(let a=0;a<3;a++){const o=3*t+a,h=3*t+(a+1)%3;r.fromBufferAttribute(n,o),s.fromBufferAttribute(n,h),!0===isUniqueEdge(r,s,i)&&(e.push(r.x,r.y,r.z),e.push(s.x,s.y,s.z))}}this.setAttribute("position",new Float32BufferAttribute(e,3))}}copy(t){return super.copy(t),this.parameters=Object.assign({},t.parameters),this}}function isUniqueEdge(t,e,i){const r=`${t.x},${t.y},${t.z}-${e.x},${e.y},${e.z}`,s=`${e.x},${e.y},${e.z}-${t.x},${t.y},${t.z}`;return!0!==i.has(r)&&!0!==i.has(s)&&(i.add(r),i.add(s),!0)}var Geometries=Object.freeze({__proto__:null,BoxGeometry,CapsuleGeometry,CircleGeometry,ConeGeometry,CylinderGeometry,DodecahedronGeometry,EdgesGeometry,ExtrudeGeometry,IcosahedronGeometry,LatheGeometry,OctahedronGeometry,PlaneGeometry,PolyhedronGeometry,RingGeometry,ShapeGeometry,SphereGeometry,TetrahedronGeometry,TorusGeometry,TorusKnotGeometry,TubeGeometry,WireframeGeometry});class ShadowMaterial extends Material{constructor(t){super(),this.isShadowMaterial=!0,this.type="ShadowMaterial",this.color=new Color(0),this.transparent=!0,this.fog=!0,this.setValues(t)}copy(t){return super.copy(t),this.color.copy(t.color),this.fog=t.fog,this}}class RawShaderMaterial extends ShaderMaterial{constructor(t){super(t),this.isRawShaderMaterial=!0,this.type="RawShaderMaterial"}}class MeshStandardMaterial extends Material{constructor(t){super(),this.isMeshStandardMaterial=!0,this.type="MeshStandardMaterial",this.defines={STANDARD:""},this.color=new Color(16777215),this.roughness=1,this.metalness=0,this.map=null,this.lightMap=null,this.lightMapIntensity=1,this.aoMap=null,this.aoMapIntensity=1,this.emissive=new Color(0),this.emissiveIntensity=1,this.emissiveMap=null,this.bumpMap=null,this.bumpScale=1,this.normalMap=null,this.normalMapType=0,this.normalScale=new Vector2(1,1),this.displacementMap=null,this.displacementScale=1,this.displacementBias=0,this.roughnessMap=null,this.metalnessMap=null,this.alphaMap=null,this.envMap=null,this.envMapRotation=new Euler,this.envMapIntensity=1,this.wireframe=!1,this.wireframeLinewidth=1,this.wireframeLinecap="round",this.wireframeLinejoin="round",this.flatShading=!1,this.fog=!0,this.setValues(t)}copy(t){return super.copy(t),this.defines={STANDARD:""},this.color.copy(t.color),this.roughness=t.roughness,this.metalness=t.metalness,this.map=t.map,this.lightMap=t.lightMap,this.lightMapIntensity=t.lightMapIntensity,this.aoMap=t.aoMap,this.aoMapIntensity=t.aoMapIntensity,this.emissive.copy(t.emissive),this.emissiveMap=t.emissiveMap,this.emissiveIntensity=t.emissiveIntensity,this.bumpMap=t.bumpMap,this.bumpScale=t.bumpScale,this.normalMap=t.normalMap,this.normalMapType=t.normalMapType,this.normalScale.copy(t.normalScale),this.displacementMap=t.displacementMap,this.displacementScale=t.displacementScale,this.displacementBias=t.displacementBias,this.roughnessMap=t.roughnessMap,this.metalnessMap=t.metalnessMap,this.alphaMap=t.alphaMap,this.envMap=t.envMap,this.envMapRotation.copy(t.envMapRotation),this.envMapIntensity=t.envMapIntensity,this.wireframe=t.wireframe,this.wireframeLinewidth=t.wireframeLinewidth,this.wireframeLinecap=t.wireframeLinecap,this.wireframeLinejoin=t.wireframeLinejoin,this.flatShading=t.flatShading,this.fog=t.fog,this}}class MeshPhysicalMaterial extends MeshStandardMaterial{constructor(t){super(),this.isMeshPhysicalMaterial=!0,this.defines={STANDARD:"",PHYSICAL:""},this.type="MeshPhysicalMaterial",this.anisotropyRotation=0,this.anisotropyMap=null,this.clearcoatMap=null,this.clearcoatRoughness=0,this.clearcoatRoughnessMap=null,this.clearcoatNormalScale=new Vector2(1,1),this.clearcoatNormalMap=null,this.ior=1.5,Object.defineProperty(this,"reflectivity",{get:function(){return clamp(2.5*(this.ior-1)/(this.ior+1),0,1)},set:function(t){this.ior=(1+.4*t)/(1-.4*t)}}),this.iridescenceMap=null,this.iridescenceIOR=1.3,this.iridescenceThicknessRange=[100,400],this.iridescenceThicknessMap=null,this.sheenColor=new Color(0),this.sheenColorMap=null,this.sheenRoughness=1,this.sheenRoughnessMap=null,this.transmissionMap=null,this.thickness=0,this.thicknessMap=null,this.attenuationDistance=1/0,this.attenuationColor=new Color(1,1,1),this.specularIntensity=1,this.specularIntensityMap=null,this.specularColor=new Color(1,1,1),this.specularColorMap=null,this._anisotropy=0,this._clearcoat=0,this._dispersion=0,this._iridescence=0,this._sheen=0,this._transmission=0,this.setValues(t)}get anisotropy(){return this._anisotropy}set anisotropy(t){this._anisotropy>0!=t>0&&this.version++,this._anisotropy=t}get clearcoat(){return this._clearcoat}set clearcoat(t){this._clearcoat>0!=t>0&&this.version++,this._clearcoat=t}get iridescence(){return this._iridescence}set iridescence(t){this._iridescence>0!=t>0&&this.version++,this._iridescence=t}get dispersion(){return this._dispersion}set dispersion(t){this._dispersion>0!=t>0&&this.version++,this._dispersion=t}get sheen(){return this._sheen}set sheen(t){this._sheen>0!=t>0&&this.version++,this._sheen=t}get transmission(){return this._transmission}set transmission(t){this._transmission>0!=t>0&&this.version++,this._transmission=t}copy(t){return super.copy(t),this.defines={STANDARD:"",PHYSICAL:""},this.anisotropy=t.anisotropy,this.anisotropyRotation=t.anisotropyRotation,this.anisotropyMap=t.anisotropyMap,this.clearcoat=t.clearcoat,this.clearcoatMap=t.clearcoatMap,this.clearcoatRoughness=t.clearcoatRoughness,this.clearcoatRoughnessMap=t.clearcoatRoughnessMap,this.clearcoatNormalMap=t.clearcoatNormalMap,this.clearcoatNormalScale.copy(t.clearcoatNormalScale),this.dispersion=t.dispersion,this.ior=t.ior,this.iridescence=t.iridescence,this.iridescenceMap=t.iridescenceMap,this.iridescenceIOR=t.iridescenceIOR,this.iridescenceThicknessRange=[...t.iridescenceThicknessRange],this.iridescenceThicknessMap=t.iridescenceThicknessMap,this.sheen=t.sheen,this.sheenColor.copy(t.sheenColor),this.sheenColorMap=t.sheenColorMap,this.sheenRoughness=t.sheenRoughness,this.sheenRoughnessMap=t.sheenRoughnessMap,this.transmission=t.transmission,this.transmissionMap=t.transmissionMap,this.thickness=t.thickness,this.thicknessMap=t.thicknessMap,this.attenuationDistance=t.attenuationDistance,this.attenuationColor.copy(t.attenuationColor),this.specularIntensity=t.specularIntensity,this.specularIntensityMap=t.specularIntensityMap,this.specularColor.copy(t.specularColor),this.specularColorMap=t.specularColorMap,this}}class MeshPhongMaterial extends Material{constructor(t){super(),this.isMeshPhongMaterial=!0,this.type="MeshPhongMaterial",this.color=new Color(16777215),this.specular=new Color(1118481),this.shininess=30,this.map=null,this.lightMap=null,this.lightMapIntensity=1,this.aoMap=null,this.aoMapIntensity=1,this.emissive=new Color(0),this.emissiveIntensity=1,this.emissiveMap=null,this.bumpMap=null,this.bumpScale=1,this.normalMap=null,this.normalMapType=0,this.normalScale=new Vector2(1,1),this.displacementMap=null,this.displacementScale=1,this.displacementBias=0,this.specularMap=null,this.alphaMap=null,this.envMap=null,this.envMapRotation=new Euler,this.combine=0,this.reflectivity=1,this.refractionRatio=.98,this.wireframe=!1,this.wireframeLinewidth=1,this.wireframeLinecap="round",this.wireframeLinejoin="round",this.flatShading=!1,this.fog=!0,this.setValues(t)}copy(t){return super.copy(t),this.color.copy(t.color),this.specular.copy(t.specular),this.shininess=t.shininess,this.map=t.map,this.lightMap=t.lightMap,this.lightMapIntensity=t.lightMapIntensity,this.aoMap=t.aoMap,this.aoMapIntensity=t.aoMapIntensity,this.emissive.copy(t.emissive),this.emissiveMap=t.emissiveMap,this.emissiveIntensity=t.emissiveIntensity,this.bumpMap=t.bumpMap,this.bumpScale=t.bumpScale,this.normalMap=t.normalMap,this.normalMapType=t.normalMapType,this.normalScale.copy(t.normalScale),this.displacementMap=t.displacementMap,this.displacementScale=t.displacementScale,this.displacementBias=t.displacementBias,this.specularMap=t.specularMap,this.alphaMap=t.alphaMap,this.envMap=t.envMap,this.envMapRotation.copy(t.envMapRotation),this.combine=t.combine,this.reflectivity=t.reflectivity,this.refractionRatio=t.refractionRatio,this.wireframe=t.wireframe,this.wireframeLinewidth=t.wireframeLinewidth,this.wireframeLinecap=t.wireframeLinecap,this.wireframeLinejoin=t.wireframeLinejoin,this.flatShading=t.flatShading,this.fog=t.fog,this}}class MeshToonMaterial extends Material{constructor(t){super(),this.isMeshToonMaterial=!0,this.defines={TOON:""},this.type="MeshToonMaterial",this.color=new Color(16777215),this.map=null,this.gradientMap=null,this.lightMap=null,this.lightMapIntensity=1,this.aoMap=null,this.aoMapIntensity=1,this.emissive=new Color(0),this.emissiveIntensity=1,this.emissiveMap=null,this.bumpMap=null,this.bumpScale=1,this.normalMap=null,this.normalMapType=0,this.normalScale=new Vector2(1,1),this.displacementMap=null,this.displacementScale=1,this.displacementBias=0,this.alphaMap=null,this.wireframe=!1,this.wireframeLinewidth=1,this.wireframeLinecap="round",this.wireframeLinejoin="round",this.fog=!0,this.setValues(t)}copy(t){return super.copy(t),this.color.copy(t.color),this.map=t.map,this.gradientMap=t.gradientMap,this.lightMap=t.lightMap,this.lightMapIntensity=t.lightMapIntensity,this.aoMap=t.aoMap,this.aoMapIntensity=t.aoMapIntensity,this.emissive.copy(t.emissive),this.emissiveMap=t.emissiveMap,this.emissiveIntensity=t.emissiveIntensity,this.bumpMap=t.bumpMap,this.bumpScale=t.bumpScale,this.normalMap=t.normalMap,this.normalMapType=t.normalMapType,this.normalScale.copy(t.normalScale),this.displacementMap=t.displacementMap,this.displacementScale=t.displacementScale,this.displacementBias=t.displacementBias,this.alphaMap=t.alphaMap,this.wireframe=t.wireframe,this.wireframeLinewidth=t.wireframeLinewidth,this.wireframeLinecap=t.wireframeLinecap,this.wireframeLinejoin=t.wireframeLinejoin,this.fog=t.fog,this}}class MeshNormalMaterial extends Material{constructor(t){super(),this.isMeshNormalMaterial=!0,this.type="MeshNormalMaterial",this.bumpMap=null,this.bumpScale=1,this.normalMap=null,this.normalMapType=0,this.normalScale=new Vector2(1,1),this.displacementMap=null,this.displacementScale=1,this.displacementBias=0,this.wireframe=!1,this.wireframeLinewidth=1,this.flatShading=!1,this.setValues(t)}copy(t){return super.copy(t),this.bumpMap=t.bumpMap,this.bumpScale=t.bumpScale,this.normalMap=t.normalMap,this.normalMapType=t.normalMapType,this.normalScale.copy(t.normalScale),this.displacementMap=t.displacementMap,this.displacementScale=t.displacementScale,this.displacementBias=t.displacementBias,this.wireframe=t.wireframe,this.wireframeLinewidth=t.wireframeLinewidth,this.flatShading=t.flatShading,this}}class MeshLambertMaterial extends Material{constructor(t){super(),this.isMeshLambertMaterial=!0,this.type="MeshLambertMaterial",this.color=new Color(16777215),this.map=null,this.lightMap=null,this.lightMapIntensity=1,this.aoMap=null,this.aoMapIntensity=1,this.emissive=new Color(0),this.emissiveIntensity=1,this.emissiveMap=null,this.bumpMap=null,this.bumpScale=1,this.normalMap=null,this.normalMapType=0,this.normalScale=new Vector2(1,1),this.displacementMap=null,this.displacementScale=1,this.displacementBias=0,this.specularMap=null,this.alphaMap=null,this.envMap=null,this.envMapRotation=new Euler,this.combine=0,this.reflectivity=1,this.refractionRatio=.98,this.wireframe=!1,this.wireframeLinewidth=1,this.wireframeLinecap="round",this.wireframeLinejoin="round",this.flatShading=!1,this.fog=!0,this.setValues(t)}copy(t){return super.copy(t),this.color.copy(t.color),this.map=t.map,this.lightMap=t.lightMap,this.lightMapIntensity=t.lightMapIntensity,this.aoMap=t.aoMap,this.aoMapIntensity=t.aoMapIntensity,this.emissive.copy(t.emissive),this.emissiveMap=t.emissiveMap,this.emissiveIntensity=t.emissiveIntensity,this.bumpMap=t.bumpMap,this.bumpScale=t.bumpScale,this.normalMap=t.normalMap,this.normalMapType=t.normalMapType,this.normalScale.copy(t.normalScale),this.displacementMap=t.displacementMap,this.displacementScale=t.displacementScale,this.displacementBias=t.displacementBias,this.specularMap=t.specularMap,this.alphaMap=t.alphaMap,this.envMap=t.envMap,this.envMapRotation.copy(t.envMapRotation),this.combine=t.combine,this.reflectivity=t.reflectivity,this.refractionRatio=t.refractionRatio,this.wireframe=t.wireframe,this.wireframeLinewidth=t.wireframeLinewidth,this.wireframeLinecap=t.wireframeLinecap,this.wireframeLinejoin=t.wireframeLinejoin,this.flatShading=t.flatShading,this.fog=t.fog,this}}class MeshDepthMaterial extends Material{constructor(t){super(),this.isMeshDepthMaterial=!0,this.type="MeshDepthMaterial",this.depthPacking=3200,this.map=null,this.alphaMap=null,this.displacementMap=null,this.displacementScale=1,this.displacementBias=0,this.wireframe=!1,this.wireframeLinewidth=1,this.setValues(t)}copy(t){return super.copy(t),this.depthPacking=t.depthPacking,this.map=t.map,this.alphaMap=t.alphaMap,this.displacementMap=t.displacementMap,this.displacementScale=t.displacementScale,this.displacementBias=t.displacementBias,this.wireframe=t.wireframe,this.wireframeLinewidth=t.wireframeLinewidth,this}}class MeshDistanceMaterial extends Material{constructor(t){super(),this.isMeshDistanceMaterial=!0,this.type="MeshDistanceMaterial",this.map=null,this.alphaMap=null,this.displacementMap=null,this.displacementScale=1,this.displacementBias=0,this.setValues(t)}copy(t){return super.copy(t),this.map=t.map,this.alphaMap=t.alphaMap,this.displacementMap=t.displacementMap,this.displacementScale=t.displacementScale,this.displacementBias=t.displacementBias,this}}class MeshMatcapMaterial extends Material{constructor(t){super(),this.isMeshMatcapMaterial=!0,this.defines={MATCAP:""},this.type="MeshMatcapMaterial",this.color=new Color(16777215),this.matcap=null,this.map=null,this.bumpMap=null,this.bumpScale=1,this.normalMap=null,this.normalMapType=0,this.normalScale=new Vector2(1,1),this.displacementMap=null,this.displacementScale=1,this.displacementBias=0,this.alphaMap=null,this.flatShading=!1,this.fog=!0,this.setValues(t)}copy(t){return super.copy(t),this.defines={MATCAP:""},this.color.copy(t.color),this.matcap=t.matcap,this.map=t.map,this.bumpMap=t.bumpMap,this.bumpScale=t.bumpScale,this.normalMap=t.normalMap,this.normalMapType=t.normalMapType,this.normalScale.copy(t.normalScale),this.displacementMap=t.displacementMap,this.displacementScale=t.displacementScale,this.displacementBias=t.displacementBias,this.alphaMap=t.alphaMap,this.flatShading=t.flatShading,this.fog=t.fog,this}}class LineDashedMaterial extends LineBasicMaterial{constructor(t){super(),this.isLineDashedMaterial=!0,this.type="LineDashedMaterial",this.scale=1,this.dashSize=3,this.gapSize=1,this.setValues(t)}copy(t){return super.copy(t),this.scale=t.scale,this.dashSize=t.dashSize,this.gapSize=t.gapSize,this}}function convertArray(t,e){return t&&t.constructor!==e?"number"==typeof e.BYTES_PER_ELEMENT?new e(t):Array.prototype.slice.call(t):t}function isTypedArray(t){return ArrayBuffer.isView(t)&&!(t instanceof DataView)}function getKeyframeOrder(t){const e=t.length,i=new Array(e);for(let t=0;t!==e;++t)i[t]=t;return i.sort((function(e,i){return t[e]-t[i]})),i}function sortedArray(t,e,i){const r=t.length,s=new t.constructor(r);for(let n=0,a=0;a!==r;++n){const r=i[n]*e;for(let i=0;i!==e;++i)s[a++]=t[r+i]}return s}function flattenJSON(t,e,i,r){let s=1,n=t[0];for(;void 0!==n&&void 0===n[r];)n=t[s++];if(void 0===n)return;let a=n[r];if(void 0!==a)if(Array.isArray(a))do{a=n[r],void 0!==a&&(e.push(n.time),i.push(...a)),n=t[s++]}while(void 0!==n);else if(void 0!==a.toArray)do{a=n[r],void 0!==a&&(e.push(n.time),a.toArray(i,i.length)),n=t[s++]}while(void 0!==n);else do{a=n[r],void 0!==a&&(e.push(n.time),i.push(a)),n=t[s++]}while(void 0!==n)}function subclip(t,e,i,r,s=30){const n=t.clone();n.name=e;const a=[];for(let t=0;t<n.tracks.length;++t){const e=n.tracks[t],o=e.getValueSize(),h=[],c=[];for(let t=0;t<e.times.length;++t){const n=e.times[t]*s;if(!(n<i||n>=r)){h.push(e.times[t]);for(let i=0;i<o;++i)c.push(e.values[t*o+i])}}0!==h.length&&(e.times=convertArray(h,e.times.constructor),e.values=convertArray(c,e.values.constructor),a.push(e))}n.tracks=a;let o=1/0;for(let t=0;t<n.tracks.length;++t)o>n.tracks[t].times[0]&&(o=n.tracks[t].times[0]);for(let t=0;t<n.tracks.length;++t)n.tracks[t].shift(-1*o);return n.resetDuration(),n}function makeClipAdditive(t,e=0,i=t,r=30){r<=0&&(r=30);const s=i.tracks.length,n=e/r;for(let e=0;e<s;++e){const r=i.tracks[e],s=r.ValueTypeName;if("bool"===s||"string"===s)continue;const a=t.tracks.find((function(t){return t.name===r.name&&t.ValueTypeName===s}));if(void 0===a)continue;let o=0;const h=r.getValueSize();r.createInterpolant.isInterpolantFactoryMethodGLTFCubicSpline&&(o=h/3);let c=0;const l=a.getValueSize();a.createInterpolant.isInterpolantFactoryMethodGLTFCubicSpline&&(c=l/3);const u=r.times.length-1;let p;if(n<=r.times[0]){const t=o,e=h-o;p=r.values.slice(t,e)}else if(n>=r.times[u]){const t=u*h+o,e=t+h-o;p=r.values.slice(t,e)}else{const t=r.createInterpolant(),e=o,i=h-o;t.evaluate(n),p=t.resultBuffer.slice(e,i)}if("quaternion"===s){(new Quaternion).fromArray(p).normalize().conjugate().toArray(p)}const d=a.times.length;for(let t=0;t<d;++t){const e=t*l+c;if("quaternion"===s)Quaternion.multiplyQuaternionsFlat(a.values,e,p,0,a.values,e);else{const t=l-2*c;for(let i=0;i<t;++i)a.values[e+i]-=p[i]}}}return t.blendMode=2501,t}class AnimationUtils{static convertArray(t,e){return convertArray(t,e)}static isTypedArray(t){return isTypedArray(t)}static getKeyframeOrder(t){return getKeyframeOrder(t)}static sortedArray(t,e,i){return sortedArray(t,e,i)}static flattenJSON(t,e,i,r){flattenJSON(t,e,i,r)}static subclip(t,e,i,r,s=30){return subclip(t,e,i,r,s)}static makeClipAdditive(t,e=0,i=t,r=30){return makeClipAdditive(t,e,i,r)}}class Interpolant{constructor(t,e,i,r){this.parameterPositions=t,this._cachedIndex=0,this.resultBuffer=void 0!==r?r:new e.constructor(i),this.sampleValues=e,this.valueSize=i,this.settings=null,this.DefaultSettings_={}}evaluate(t){const e=this.parameterPositions;let i=this._cachedIndex,r=e[i],s=e[i-1];t:{e:{let n;i:{r:if(!(t<r)){for(let n=i+2;;){if(void 0===r){if(t<s)break r;return i=e.length,this._cachedIndex=i,this.copySampleValue_(i-1)}if(i===n)break;if(s=r,r=e[++i],t<r)break e}n=e.length;break i}if(t>=s)break t;{const a=e[1];t<a&&(i=2,s=a);for(let n=i-2;;){if(void 0===s)return this._cachedIndex=0,this.copySampleValue_(0);if(i===n)break;if(r=s,s=e[--i-1],t>=s)break e}n=i,i=0}}for(;i<n;){const r=i+n>>>1;t<e[r]?n=r:i=r+1}if(r=e[i],s=e[i-1],void 0===s)return this._cachedIndex=0,this.copySampleValue_(0);if(void 0===r)return i=e.length,this._cachedIndex=i,this.copySampleValue_(i-1)}this._cachedIndex=i,this.intervalChanged_(i,s,r)}return this.interpolate_(i,s,t,r)}getSettings_(){return this.settings||this.DefaultSettings_}copySampleValue_(t){const e=this.resultBuffer,i=this.sampleValues,r=this.valueSize,s=t*r;for(let t=0;t!==r;++t)e[t]=i[s+t];return e}interpolate_(){throw new Error("call to abstract method")}intervalChanged_(){}}class CubicInterpolant extends Interpolant{constructor(t,e,i,r){super(t,e,i,r),this._weightPrev=-0,this._offsetPrev=-0,this._weightNext=-0,this._offsetNext=-0,this.DefaultSettings_={endingStart:2400,endingEnd:2400}}intervalChanged_(t,e,i){const r=this.parameterPositions;let s=t-2,n=t+1,a=r[s],o=r[n];if(void 0===a)switch(this.getSettings_().endingStart){case 2401:s=t,a=2*e-i;break;case 2402:s=r.length-2,a=e+r[s]-r[s+1];break;default:s=t,a=i}if(void 0===o)switch(this.getSettings_().endingEnd){case 2401:n=t,o=2*i-e;break;case 2402:n=1,o=i+r[1]-r[0];break;default:n=t-1,o=e}const h=.5*(i-e),c=this.valueSize;this._weightPrev=h/(e-a),this._weightNext=h/(o-i),this._offsetPrev=s*c,this._offsetNext=n*c}interpolate_(t,e,i,r){const s=this.resultBuffer,n=this.sampleValues,a=this.valueSize,o=t*a,h=o-a,c=this._offsetPrev,l=this._offsetNext,u=this._weightPrev,p=this._weightNext,d=(i-e)/(r-e),m=d*d,y=m*d,f=-u*y+2*u*m-u*d,g=(1+u)*y+(-1.5-2*u)*m+(-.5+u)*d+1,x=(-1-p)*y+(1.5+p)*m+.5*d,_=p*y-p*m;for(let t=0;t!==a;++t)s[t]=f*n[c+t]+g*n[h+t]+x*n[o+t]+_*n[l+t];return s}}class LinearInterpolant extends Interpolant{constructor(t,e,i,r){super(t,e,i,r)}interpolate_(t,e,i,r){const s=this.resultBuffer,n=this.sampleValues,a=this.valueSize,o=t*a,h=o-a,c=(i-e)/(r-e),l=1-c;for(let t=0;t!==a;++t)s[t]=n[h+t]*l+n[o+t]*c;return s}}class DiscreteInterpolant extends Interpolant{constructor(t,e,i,r){super(t,e,i,r)}interpolate_(t){return this.copySampleValue_(t-1)}}class KeyframeTrack{constructor(t,e,i,r){if(void 0===t)throw new Error("THREE.KeyframeTrack: track name is undefined");if(void 0===e||0===e.length)throw new Error("THREE.KeyframeTrack: no keyframes in track named "+t);this.name=t,this.times=convertArray(e,this.TimeBufferType),this.values=convertArray(i,this.ValueBufferType),this.setInterpolation(r||this.DefaultInterpolation)}static toJSON(t){const e=t.constructor;let i;if(e.toJSON!==this.toJSON)i=e.toJSON(t);else{i={name:t.name,times:convertArray(t.times,Array),values:convertArray(t.values,Array)};const e=t.getInterpolation();e!==t.DefaultInterpolation&&(i.interpolation=e)}return i.type=t.ValueTypeName,i}InterpolantFactoryMethodDiscrete(t){return new DiscreteInterpolant(this.times,this.values,this.getValueSize(),t)}InterpolantFactoryMethodLinear(t){return new LinearInterpolant(this.times,this.values,this.getValueSize(),t)}InterpolantFactoryMethodSmooth(t){return new CubicInterpolant(this.times,this.values,this.getValueSize(),t)}setInterpolation(t){let e;switch(t){case 2300:e=this.InterpolantFactoryMethodDiscrete;break;case 2301:e=this.InterpolantFactoryMethodLinear;break;case 2302:e=this.InterpolantFactoryMethodSmooth}if(void 0===e){const e="unsupported interpolation for "+this.ValueTypeName+" keyframe track named "+this.name;if(void 0===this.createInterpolant){if(t===this.DefaultInterpolation)throw new Error(e);this.setInterpolation(this.DefaultInterpolation)}return console.warn("THREE.KeyframeTrack:",e),this}return this.createInterpolant=e,this}getInterpolation(){switch(this.createInterpolant){case this.InterpolantFactoryMethodDiscrete:return 2300;case this.InterpolantFactoryMethodLinear:return 2301;case this.InterpolantFactoryMethodSmooth:return 2302}}getValueSize(){return this.values.length/this.times.length}shift(t){if(0!==t){const e=this.times;for(let i=0,r=e.length;i!==r;++i)e[i]+=t}return this}scale(t){if(1!==t){const e=this.times;for(let i=0,r=e.length;i!==r;++i)e[i]*=t}return this}trim(t,e){const i=this.times,r=i.length;let s=0,n=r-1;for(;s!==r&&i[s]<t;)++s;for(;-1!==n&&i[n]>e;)--n;if(++n,0!==s||n!==r){s>=n&&(n=Math.max(n,1),s=n-1);const t=this.getValueSize();this.times=i.slice(s,n),this.values=this.values.slice(s*t,n*t)}return this}validate(){let t=!0;const e=this.getValueSize();e-Math.floor(e)!=0&&(console.error("THREE.KeyframeTrack: Invalid value size in track.",this),t=!1);const i=this.times,r=this.values,s=i.length;0===s&&(console.error("THREE.KeyframeTrack: Track is empty.",this),t=!1);let n=null;for(let e=0;e!==s;e++){const r=i[e];if("number"==typeof r&&isNaN(r)){console.error("THREE.KeyframeTrack: Time is not a valid number.",this,e,r),t=!1;break}if(null!==n&&n>r){console.error("THREE.KeyframeTrack: Out of order keys.",this,e,r,n),t=!1;break}n=r}if(void 0!==r&&isTypedArray(r))for(let e=0,i=r.length;e!==i;++e){const i=r[e];if(isNaN(i)){console.error("THREE.KeyframeTrack: Value is not a valid number.",this,e,i),t=!1;break}}return t}optimize(){const t=this.times.slice(),e=this.values.slice(),i=this.getValueSize(),r=2302===this.getInterpolation(),s=t.length-1;let n=1;for(let a=1;a<s;++a){let s=!1;const o=t[a];if(o!==t[a+1]&&(1!==a||o!==t[0]))if(r)s=!0;else{const t=a*i,r=t-i,n=t+i;for(let a=0;a!==i;++a){const i=e[t+a];if(i!==e[r+a]||i!==e[n+a]){s=!0;break}}}if(s){if(a!==n){t[n]=t[a];const r=a*i,s=n*i;for(let t=0;t!==i;++t)e[s+t]=e[r+t]}++n}}if(s>0){t[n]=t[s];for(let t=s*i,r=n*i,a=0;a!==i;++a)e[r+a]=e[t+a];++n}return n!==t.length?(this.times=t.slice(0,n),this.values=e.slice(0,n*i)):(this.times=t,this.values=e),this}clone(){const t=this.times.slice(),e=this.values.slice(),i=new(0,this.constructor)(this.name,t,e);return i.createInterpolant=this.createInterpolant,i}}KeyframeTrack.prototype.ValueTypeName="",KeyframeTrack.prototype.TimeBufferType=Float32Array,KeyframeTrack.prototype.ValueBufferType=Float32Array,KeyframeTrack.prototype.DefaultInterpolation=2301;class BooleanKeyframeTrack extends KeyframeTrack{constructor(t,e,i){super(t,e,i)}}BooleanKeyframeTrack.prototype.ValueTypeName="bool",BooleanKeyframeTrack.prototype.ValueBufferType=Array,BooleanKeyframeTrack.prototype.DefaultInterpolation=2300,BooleanKeyframeTrack.prototype.InterpolantFactoryMethodLinear=void 0,BooleanKeyframeTrack.prototype.InterpolantFactoryMethodSmooth=void 0;class ColorKeyframeTrack extends KeyframeTrack{constructor(t,e,i,r){super(t,e,i,r)}}ColorKeyframeTrack.prototype.ValueTypeName="color";class NumberKeyframeTrack extends KeyframeTrack{constructor(t,e,i,r){super(t,e,i,r)}}NumberKeyframeTrack.prototype.ValueTypeName="number";class QuaternionLinearInterpolant extends Interpolant{constructor(t,e,i,r){super(t,e,i,r)}interpolate_(t,e,i,r){const s=this.resultBuffer,n=this.sampleValues,a=this.valueSize,o=(i-e)/(r-e);let h=t*a;for(let t=h+a;h!==t;h+=4)Quaternion.slerpFlat(s,0,n,h-a,n,h,o);return s}}class QuaternionKeyframeTrack extends KeyframeTrack{constructor(t,e,i,r){super(t,e,i,r)}InterpolantFactoryMethodLinear(t){return new QuaternionLinearInterpolant(this.times,this.values,this.getValueSize(),t)}}QuaternionKeyframeTrack.prototype.ValueTypeName="quaternion",QuaternionKeyframeTrack.prototype.InterpolantFactoryMethodSmooth=void 0;class StringKeyframeTrack extends KeyframeTrack{constructor(t,e,i){super(t,e,i)}}StringKeyframeTrack.prototype.ValueTypeName="string",StringKeyframeTrack.prototype.ValueBufferType=Array,StringKeyframeTrack.prototype.DefaultInterpolation=2300,StringKeyframeTrack.prototype.InterpolantFactoryMethodLinear=void 0,StringKeyframeTrack.prototype.InterpolantFactoryMethodSmooth=void 0;class VectorKeyframeTrack extends KeyframeTrack{constructor(t,e,i,r){super(t,e,i,r)}}VectorKeyframeTrack.prototype.ValueTypeName="vector";class AnimationClip{constructor(t="",e=-1,i=[],r=2500){this.name=t,this.tracks=i,this.duration=e,this.blendMode=r,this.uuid=generateUUID(),this.duration<0&&this.resetDuration()}static parse(t){const e=[],i=t.tracks,r=1/(t.fps||1);for(let t=0,s=i.length;t!==s;++t)e.push(parseKeyframeTrack(i[t]).scale(r));const s=new this(t.name,t.duration,e,t.blendMode);return s.uuid=t.uuid,s}static toJSON(t){const e=[],i=t.tracks,r={name:t.name,duration:t.duration,tracks:e,uuid:t.uuid,blendMode:t.blendMode};for(let t=0,r=i.length;t!==r;++t)e.push(KeyframeTrack.toJSON(i[t]));return r}static CreateFromMorphTargetSequence(t,e,i,r){const s=e.length,n=[];for(let t=0;t<s;t++){let a=[],o=[];a.push((t+s-1)%s,t,(t+1)%s),o.push(0,1,0);const h=getKeyframeOrder(a);a=sortedArray(a,1,h),o=sortedArray(o,1,h),r||0!==a[0]||(a.push(s),o.push(o[0])),n.push(new NumberKeyframeTrack(".morphTargetInfluences["+e[t].name+"]",a,o).scale(1/i))}return new this(t,-1,n)}static findByName(t,e){let i=t;if(!Array.isArray(t)){const e=t;i=e.geometry&&e.geometry.animations||e.animations}for(let t=0;t<i.length;t++)if(i[t].name===e)return i[t];return null}static CreateClipsFromMorphTargetSequences(t,e,i){const r={},s=/^([\w-]*?)([\d]+)$/;for(let e=0,i=t.length;e<i;e++){const i=t[e],n=i.name.match(s);if(n&&n.length>1){const t=n[1];let e=r[t];e||(r[t]=e=[]),e.push(i)}}const n=[];for(const t in r)n.push(this.CreateFromMorphTargetSequence(t,r[t],e,i));return n}static parseAnimation(t,e){if(console.warn("THREE.AnimationClip: parseAnimation() is deprecated and will be removed with r185"),!t)return console.error("THREE.AnimationClip: No animation in JSONLoader data."),null;const i=function(t,e,i,r,s){if(0!==i.length){const n=[],a=[];flattenJSON(i,n,a,r),0!==n.length&&s.push(new t(e,n,a))}},r=[],s=t.name||"default",n=t.fps||30,a=t.blendMode;let o=t.length||-1;const h=t.hierarchy||[];for(let t=0;t<h.length;t++){const s=h[t].keys;if(s&&0!==s.length)if(s[0].morphTargets){const t={};let e;for(e=0;e<s.length;e++)if(s[e].morphTargets)for(let i=0;i<s[e].morphTargets.length;i++)t[s[e].morphTargets[i]]=-1;for(const i in t){const t=[],n=[];for(let r=0;r!==s[e].morphTargets.length;++r){const r=s[e];t.push(r.time),n.push(r.morphTarget===i?1:0)}r.push(new NumberKeyframeTrack(".morphTargetInfluence["+i+"]",t,n))}o=t.length*n}else{const n=".bones["+e[t].name+"]";i(VectorKeyframeTrack,n+".position",s,"pos",r),i(QuaternionKeyframeTrack,n+".quaternion",s,"rot",r),i(VectorKeyframeTrack,n+".scale",s,"scl",r)}}if(0===r.length)return null;return new this(s,o,r,a)}resetDuration(){let t=0;for(let e=0,i=this.tracks.length;e!==i;++e){const i=this.tracks[e];t=Math.max(t,i.times[i.times.length-1])}return this.duration=t,this}trim(){for(let t=0;t<this.tracks.length;t++)this.tracks[t].trim(0,this.duration);return this}validate(){let t=!0;for(let e=0;e<this.tracks.length;e++)t=t&&this.tracks[e].validate();return t}optimize(){for(let t=0;t<this.tracks.length;t++)this.tracks[t].optimize();return this}clone(){const t=[];for(let e=0;e<this.tracks.length;e++)t.push(this.tracks[e].clone());return new this.constructor(this.name,this.duration,t,this.blendMode)}toJSON(){return this.constructor.toJSON(this)}}function getTrackTypeForValueTypeName(t){switch(t.toLowerCase()){case"scalar":case"double":case"float":case"number":case"integer":return NumberKeyframeTrack;case"vector":case"vector2":case"vector3":case"vector4":return VectorKeyframeTrack;case"color":return ColorKeyframeTrack;case"quaternion":return QuaternionKeyframeTrack;case"bool":case"boolean":return BooleanKeyframeTrack;case"string":return StringKeyframeTrack}throw new Error("THREE.KeyframeTrack: Unsupported typeName: "+t)}function parseKeyframeTrack(t){if(void 0===t.type)throw new Error("THREE.KeyframeTrack: track type undefined, can not parse");const e=getTrackTypeForValueTypeName(t.type);if(void 0===t.times){const e=[],i=[];flattenJSON(t.keys,e,i,"value"),t.times=e,t.values=i}return void 0!==e.parse?e.parse(t):new e(t.name,t.times,t.values,t.interpolation)}const Cache={enabled:!1,files:{},add:function(t,e){!1!==this.enabled&&(this.files[t]=e)},get:function(t){if(!1!==this.enabled)return this.files[t]},remove:function(t){delete this.files[t]},clear:function(){this.files={}}};class LoadingManager{constructor(t,e,i){const r=this;let s,n=!1,a=0,o=0;const h=[];this.onStart=void 0,this.onLoad=t,this.onProgress=e,this.onError=i,this.itemStart=function(t){o++,!1===n&&void 0!==r.onStart&&r.onStart(t,a,o),n=!0},this.itemEnd=function(t){a++,void 0!==r.onProgress&&r.onProgress(t,a,o),a===o&&(n=!1,void 0!==r.onLoad&&r.onLoad())},this.itemError=function(t){void 0!==r.onError&&r.onError(t)},this.resolveURL=function(t){return s?s(t):t},this.setURLModifier=function(t){return s=t,this},this.addHandler=function(t,e){return h.push(t,e),this},this.removeHandler=function(t){const e=h.indexOf(t);return-1!==e&&h.splice(e,2),this},this.getHandler=function(t){for(let e=0,i=h.length;e<i;e+=2){const i=h[e],r=h[e+1];if(i.global&&(i.lastIndex=0),i.test(t))return r}return null}}}const DefaultLoadingManager=new LoadingManager;class Loader{constructor(t){this.manager=void 0!==t?t:DefaultLoadingManager,this.crossOrigin="anonymous",this.withCredentials=!1,this.path="",this.resourcePath="",this.requestHeader={}}load(){}loadAsync(t,e){const i=this;return new Promise((function(r,s){i.load(t,r,e,s)}))}parse(){}setCrossOrigin(t){return this.crossOrigin=t,this}setWithCredentials(t){return this.withCredentials=t,this}setPath(t){return this.path=t,this}setResourcePath(t){return this.resourcePath=t,this}setRequestHeader(t){return this.requestHeader=t,this}}Loader.DEFAULT_MATERIAL_NAME="__DEFAULT";const loading={};class HttpError extends Error{constructor(t,e){super(t),this.response=e}}class FileLoader extends Loader{constructor(t){super(t),this.mimeType="",this.responseType=""}load(t,e,i,r){void 0===t&&(t=""),void 0!==this.path&&(t=this.path+t),t=this.manager.resolveURL(t);const s=Cache.get(t);if(void 0!==s)return this.manager.itemStart(t),setTimeout((()=>{e&&e(s),this.manager.itemEnd(t)}),0),s;if(void 0!==loading[t])return void loading[t].push({onLoad:e,onProgress:i,onError:r});loading[t]=[],loading[t].push({onLoad:e,onProgress:i,onError:r});const n=new Request(t,{headers:new Headers(this.requestHeader),credentials:this.withCredentials?"include":"same-origin"}),a=this.mimeType,o=this.responseType;fetch(n).then((e=>{if(200===e.status||0===e.status){if(0===e.status&&console.warn("THREE.FileLoader: HTTP Status 0 received."),"undefined"==typeof ReadableStream||void 0===e.body||void 0===e.body.getReader)return e;const i=loading[t],r=e.body.getReader(),s=e.headers.get("X-File-Size")||e.headers.get("Content-Length"),n=s?parseInt(s):0,a=0!==n;let o=0;const h=new ReadableStream({start(t){!function e(){r.read().then((({done:r,value:s})=>{if(r)t.close();else{o+=s.byteLength;const r=new ProgressEvent("progress",{lengthComputable:a,loaded:o,total:n});for(let t=0,e=i.length;t<e;t++){const e=i[t];e.onProgress&&e.onProgress(r)}t.enqueue(s),e()}}),(e=>{t.error(e)}))}()}});return new Response(h)}throw new HttpError(`fetch for "${e.url}" responded with ${e.status}: ${e.statusText}`,e)})).then((t=>{switch(o){case"arraybuffer":return t.arrayBuffer();case"blob":return t.blob();case"document":return t.text().then((t=>(new DOMParser).parseFromString(t,a)));case"json":return t.json();default:if(""===a)return t.text();{const e=/charset="?([^;"\s]*)"?/i.exec(a),i=e&&e[1]?e[1].toLowerCase():void 0,r=new TextDecoder(i);return t.arrayBuffer().then((t=>r.decode(t)))}}})).then((e=>{Cache.add(t,e);const i=loading[t];delete loading[t];for(let t=0,r=i.length;t<r;t++){const r=i[t];r.onLoad&&r.onLoad(e)}})).catch((e=>{const i=loading[t];if(void 0===i)throw this.manager.itemError(t),e;delete loading[t];for(let t=0,r=i.length;t<r;t++){const r=i[t];r.onError&&r.onError(e)}this.manager.itemError(t)})).finally((()=>{this.manager.itemEnd(t)})),this.manager.itemStart(t)}setResponseType(t){return this.responseType=t,this}setMimeType(t){return this.mimeType=t,this}}class AnimationLoader extends Loader{constructor(t){super(t)}load(t,e,i,r){const s=this,n=new FileLoader(this.manager);n.setPath(this.path),n.setRequestHeader(this.requestHeader),n.setWithCredentials(this.withCredentials),n.load(t,(function(i){try{e(s.parse(JSON.parse(i)))}catch(e){r?r(e):console.error(e),s.manager.itemError(t)}}),i,r)}parse(t){const e=[];for(let i=0;i<t.length;i++){const r=AnimationClip.parse(t[i]);e.push(r)}return e}}class CompressedTextureLoader extends Loader{constructor(t){super(t)}load(t,e,i,r){const s=this,n=[],a=new CompressedTexture,o=new FileLoader(this.manager);o.setPath(this.path),o.setResponseType("arraybuffer"),o.setRequestHeader(this.requestHeader),o.setWithCredentials(s.withCredentials);let h=0;function c(c){o.load(t[c],(function(t){const i=s.parse(t,!0);n[c]={width:i.width,height:i.height,format:i.format,mipmaps:i.mipmaps},h+=1,6===h&&(1===i.mipmapCount&&(a.minFilter=1006),a.image=n,a.format=i.format,a.needsUpdate=!0,e&&e(a))}),i,r)}if(Array.isArray(t))for(let e=0,i=t.length;e<i;++e)c(e);else o.load(t,(function(t){const i=s.parse(t,!0);if(i.isCubemap){const t=i.mipmaps.length/i.mipmapCount;for(let e=0;e<t;e++){n[e]={mipmaps:[]};for(let t=0;t<i.mipmapCount;t++)n[e].mipmaps.push(i.mipmaps[e*i.mipmapCount+t]),n[e].format=i.format,n[e].width=i.width,n[e].height=i.height}a.image=n}else a.image.width=i.width,a.image.height=i.height,a.mipmaps=i.mipmaps;1===i.mipmapCount&&(a.minFilter=1006),a.format=i.format,a.needsUpdate=!0,e&&e(a)}),i,r);return a}}class ImageLoader extends Loader{constructor(t){super(t)}load(t,e,i,r){void 0!==this.path&&(t=this.path+t),t=this.manager.resolveURL(t);const s=this,n=Cache.get(t);if(void 0!==n)return s.manager.itemStart(t),setTimeout((function(){e&&e(n),s.manager.itemEnd(t)}),0),n;const a=createElementNS("img");function o(){c(),Cache.add(t,this),e&&e(this),s.manager.itemEnd(t)}function h(e){c(),r&&r(e),s.manager.itemError(t),s.manager.itemEnd(t)}function c(){a.removeEventListener("load",o,!1),a.removeEventListener("error",h,!1)}return a.addEventListener("load",o,!1),a.addEventListener("error",h,!1),"data:"!==t.slice(0,5)&&void 0!==this.crossOrigin&&(a.crossOrigin=this.crossOrigin),s.manager.itemStart(t),a.src=t,a}}class CubeTextureLoader extends Loader{constructor(t){super(t)}load(t,e,i,r){const s=new CubeTexture;s.colorSpace="srgb";const n=new ImageLoader(this.manager);n.setCrossOrigin(this.crossOrigin),n.setPath(this.path);let a=0;function o(i){n.load(t[i],(function(t){s.images[i]=t,a++,6===a&&(s.needsUpdate=!0,e&&e(s))}),void 0,r)}for(let e=0;e<t.length;++e)o(e);return s}}class DataTextureLoader extends Loader{constructor(t){super(t)}load(t,e,i,r){const s=this,n=new DataTexture,a=new FileLoader(this.manager);return a.setResponseType("arraybuffer"),a.setRequestHeader(this.requestHeader),a.setPath(this.path),a.setWithCredentials(s.withCredentials),a.load(t,(function(t){let i;try{i=s.parse(t)}catch(t){if(void 0===r)return void console.error(t);r(t)}void 0!==i.image?n.image=i.image:void 0!==i.data&&(n.image.width=i.width,n.image.height=i.height,n.image.data=i.data),n.wrapS=void 0!==i.wrapS?i.wrapS:1001,n.wrapT=void 0!==i.wrapT?i.wrapT:1001,n.magFilter=void 0!==i.magFilter?i.magFilter:1006,n.minFilter=void 0!==i.minFilter?i.minFilter:1006,n.anisotropy=void 0!==i.anisotropy?i.anisotropy:1,void 0!==i.colorSpace&&(n.colorSpace=i.colorSpace),void 0!==i.flipY&&(n.flipY=i.flipY),void 0!==i.format&&(n.format=i.format),void 0!==i.type&&(n.type=i.type),void 0!==i.mipmaps&&(n.mipmaps=i.mipmaps,n.minFilter=1008),1===i.mipmapCount&&(n.minFilter=1006),void 0!==i.generateMipmaps&&(n.generateMipmaps=i.generateMipmaps),n.needsUpdate=!0,e&&e(n,i)}),i,r),n}}class TextureLoader extends Loader{constructor(t){super(t)}load(t,e,i,r){const s=new Texture,n=new ImageLoader(this.manager);return n.setCrossOrigin(this.crossOrigin),n.setPath(this.path),n.load(t,(function(t){s.image=t,s.needsUpdate=!0,void 0!==e&&e(s)}),i,r),s}}class Light extends Object3D{constructor(t,e=1){super(),this.isLight=!0,this.type="Light",this.color=new Color(t),this.intensity=e}dispose(){}copy(t,e){return super.copy(t,e),this.color.copy(t.color),this.intensity=t.intensity,this}toJSON(t){const e=super.toJSON(t);return e.object.color=this.color.getHex(),e.object.intensity=this.intensity,void 0!==this.groundColor&&(e.object.groundColor=this.groundColor.getHex()),void 0!==this.distance&&(e.object.distance=this.distance),void 0!==this.angle&&(e.object.angle=this.angle),void 0!==this.decay&&(e.object.decay=this.decay),void 0!==this.penumbra&&(e.object.penumbra=this.penumbra),void 0!==this.shadow&&(e.object.shadow=this.shadow.toJSON()),void 0!==this.target&&(e.object.target=this.target.uuid),e}}class HemisphereLight extends Light{constructor(t,e,i){super(t,i),this.isHemisphereLight=!0,this.type="HemisphereLight",this.position.copy(Object3D.DEFAULT_UP),this.updateMatrix(),this.groundColor=new Color(e)}copy(t,e){return super.copy(t,e),this.groundColor.copy(t.groundColor),this}}const _projScreenMatrix$1=new Matrix4,_lightPositionWorld$1=new Vector3,_lookTarget$1=new Vector3;class LightShadow{constructor(t){this.camera=t,this.intensity=1,this.bias=0,this.normalBias=0,this.radius=1,this.blurSamples=8,this.mapSize=new Vector2(512,512),this.mapType=1009,this.map=null,this.mapPass=null,this.matrix=new Matrix4,this.autoUpdate=!0,this.needsUpdate=!1,this._frustum=new Frustum,this._frameExtents=new Vector2(1,1),this._viewportCount=1,this._viewports=[new Vector4(0,0,1,1)]}getViewportCount(){return this._viewportCount}getFrustum(){return this._frustum}updateMatrices(t){const e=this.camera,i=this.matrix;_lightPositionWorld$1.setFromMatrixPosition(t.matrixWorld),e.position.copy(_lightPositionWorld$1),_lookTarget$1.setFromMatrixPosition(t.target.matrixWorld),e.lookAt(_lookTarget$1),e.updateMatrixWorld(),_projScreenMatrix$1.multiplyMatrices(e.projectionMatrix,e.matrixWorldInverse),this._frustum.setFromProjectionMatrix(_projScreenMatrix$1),i.set(.5,0,0,.5,0,.5,0,.5,0,0,.5,.5,0,0,0,1),i.multiply(_projScreenMatrix$1)}getViewport(t){return this._viewports[t]}getFrameExtents(){return this._frameExtents}dispose(){this.map&&this.map.dispose(),this.mapPass&&this.mapPass.dispose()}copy(t){return this.camera=t.camera.clone(),this.intensity=t.intensity,this.bias=t.bias,this.radius=t.radius,this.autoUpdate=t.autoUpdate,this.needsUpdate=t.needsUpdate,this.normalBias=t.normalBias,this.blurSamples=t.blurSamples,this.mapSize.copy(t.mapSize),this}clone(){return(new this.constructor).copy(this)}toJSON(){const t={};return 1!==this.intensity&&(t.intensity=this.intensity),0!==this.bias&&(t.bias=this.bias),0!==this.normalBias&&(t.normalBias=this.normalBias),1!==this.radius&&(t.radius=this.radius),512===this.mapSize.x&&512===this.mapSize.y||(t.mapSize=this.mapSize.toArray()),t.camera=this.camera.toJSON(!1).object,delete t.camera.matrix,t}}class SpotLightShadow extends LightShadow{constructor(){super(new PerspectiveCamera(50,1,.5,500)),this.isSpotLightShadow=!0,this.focus=1}updateMatrices(t){const e=this.camera,i=2*RAD2DEG*t.angle*this.focus,r=this.mapSize.width/this.mapSize.height,s=t.distance||e.far;i===e.fov&&r===e.aspect&&s===e.far||(e.fov=i,e.aspect=r,e.far=s,e.updateProjectionMatrix()),super.updateMatrices(t)}copy(t){return super.copy(t),this.focus=t.focus,this}}class SpotLight extends Light{constructor(t,e,i=0,r=Math.PI/3,s=0,n=2){super(t,e),this.isSpotLight=!0,this.type="SpotLight",this.position.copy(Object3D.DEFAULT_UP),this.updateMatrix(),this.target=new Object3D,this.distance=i,this.angle=r,this.penumbra=s,this.decay=n,this.map=null,this.shadow=new SpotLightShadow}get power(){return this.intensity*Math.PI}set power(t){this.intensity=t/Math.PI}dispose(){this.shadow.dispose()}copy(t,e){return super.copy(t,e),this.distance=t.distance,this.angle=t.angle,this.penumbra=t.penumbra,this.decay=t.decay,this.target=t.target.clone(),this.shadow=t.shadow.clone(),this}}const _projScreenMatrix=new Matrix4,_lightPositionWorld=new Vector3,_lookTarget=new Vector3;class PointLightShadow extends LightShadow{constructor(){super(new PerspectiveCamera(90,1,.5,500)),this.isPointLightShadow=!0,this._frameExtents=new Vector2(4,2),this._viewportCount=6,this._viewports=[new Vector4(2,1,1,1),new Vector4(0,1,1,1),new Vector4(3,1,1,1),new Vector4(1,1,1,1),new Vector4(3,0,1,1),new Vector4(1,0,1,1)],this._cubeDirections=[new Vector3(1,0,0),new Vector3(-1,0,0),new Vector3(0,0,1),new Vector3(0,0,-1),new Vector3(0,1,0),new Vector3(0,-1,0)],this._cubeUps=[new Vector3(0,1,0),new Vector3(0,1,0),new Vector3(0,1,0),new Vector3(0,1,0),new Vector3(0,0,1),new Vector3(0,0,-1)]}updateMatrices(t,e=0){const i=this.camera,r=this.matrix,s=t.distance||i.far;s!==i.far&&(i.far=s,i.updateProjectionMatrix()),_lightPositionWorld.setFromMatrixPosition(t.matrixWorld),i.position.copy(_lightPositionWorld),_lookTarget.copy(i.position),_lookTarget.add(this._cubeDirections[e]),i.up.copy(this._cubeUps[e]),i.lookAt(_lookTarget),i.updateMatrixWorld(),r.makeTranslation(-_lightPositionWorld.x,-_lightPositionWorld.y,-_lightPositionWorld.z),_projScreenMatrix.multiplyMatrices(i.projectionMatrix,i.matrixWorldInverse),this._frustum.setFromProjectionMatrix(_projScreenMatrix)}}class PointLight extends Light{constructor(t,e,i=0,r=2){super(t,e),this.isPointLight=!0,this.type="PointLight",this.distance=i,this.decay=r,this.shadow=new PointLightShadow}get power(){return 4*this.intensity*Math.PI}set power(t){this.intensity=t/(4*Math.PI)}dispose(){this.shadow.dispose()}copy(t,e){return super.copy(t,e),this.distance=t.distance,this.decay=t.decay,this.shadow=t.shadow.clone(),this}}class OrthographicCamera extends Camera{constructor(t=-1,e=1,i=1,r=-1,s=.1,n=2e3){super(),this.isOrthographicCamera=!0,this.type="OrthographicCamera",this.zoom=1,this.view=null,this.left=t,this.right=e,this.top=i,this.bottom=r,this.near=s,this.far=n,this.updateProjectionMatrix()}copy(t,e){return super.copy(t,e),this.left=t.left,this.right=t.right,this.top=t.top,this.bottom=t.bottom,this.near=t.near,this.far=t.far,this.zoom=t.zoom,this.view=null===t.view?null:Object.assign({},t.view),this}setViewOffset(t,e,i,r,s,n){null===this.view&&(this.view={enabled:!0,fullWidth:1,fullHeight:1,offsetX:0,offsetY:0,width:1,height:1}),this.view.enabled=!0,this.view.fullWidth=t,this.view.fullHeight=e,this.view.offsetX=i,this.view.offsetY=r,this.view.width=s,this.view.height=n,this.updateProjectionMatrix()}clearViewOffset(){null!==this.view&&(this.view.enabled=!1),this.updateProjectionMatrix()}updateProjectionMatrix(){const t=(this.right-this.left)/(2*this.zoom),e=(this.top-this.bottom)/(2*this.zoom),i=(this.right+this.left)/2,r=(this.top+this.bottom)/2;let s=i-t,n=i+t,a=r+e,o=r-e;if(null!==this.view&&this.view.enabled){const t=(this.right-this.left)/this.view.fullWidth/this.zoom,e=(this.top-this.bottom)/this.view.fullHeight/this.zoom;s+=t*this.view.offsetX,n=s+t*this.view.width,a-=e*this.view.offsetY,o=a-e*this.view.height}this.projectionMatrix.makeOrthographic(s,n,a,o,this.near,this.far,this.coordinateSystem),this.projectionMatrixInverse.copy(this.projectionMatrix).invert()}toJSON(t){const e=super.toJSON(t);return e.object.zoom=this.zoom,e.object.left=this.left,e.object.right=this.right,e.object.top=this.top,e.object.bottom=this.bottom,e.object.near=this.near,e.object.far=this.far,null!==this.view&&(e.object.view=Object.assign({},this.view)),e}}class DirectionalLightShadow extends LightShadow{constructor(){super(new OrthographicCamera(-5,5,5,-5,.5,500)),this.isDirectionalLightShadow=!0}}class DirectionalLight extends Light{constructor(t,e){super(t,e),this.isDirectionalLight=!0,this.type="DirectionalLight",this.position.copy(Object3D.DEFAULT_UP),this.updateMatrix(),this.target=new Object3D,this.shadow=new DirectionalLightShadow}dispose(){this.shadow.dispose()}copy(t){return super.copy(t),this.target=t.target.clone(),this.shadow=t.shadow.clone(),this}}class AmbientLight extends Light{constructor(t,e){super(t,e),this.isAmbientLight=!0,this.type="AmbientLight"}}class RectAreaLight extends Light{constructor(t,e,i=10,r=10){super(t,e),this.isRectAreaLight=!0,this.type="RectAreaLight",this.width=i,this.height=r}get power(){return this.intensity*this.width*this.height*Math.PI}set power(t){this.intensity=t/(this.width*this.height*Math.PI)}copy(t){return super.copy(t),this.width=t.width,this.height=t.height,this}toJSON(t){const e=super.toJSON(t);return e.object.width=this.width,e.object.height=this.height,e}}class SphericalHarmonics3{constructor(){this.isSphericalHarmonics3=!0,this.coefficients=[];for(let t=0;t<9;t++)this.coefficients.push(new Vector3)}set(t){for(let e=0;e<9;e++)this.coefficients[e].copy(t[e]);return this}zero(){for(let t=0;t<9;t++)this.coefficients[t].set(0,0,0);return this}getAt(t,e){const i=t.x,r=t.y,s=t.z,n=this.coefficients;return e.copy(n[0]).multiplyScalar(.282095),e.addScaledVector(n[1],.488603*r),e.addScaledVector(n[2],.488603*s),e.addScaledVector(n[3],.488603*i),e.addScaledVector(n[4],i*r*1.092548),e.addScaledVector(n[5],r*s*1.092548),e.addScaledVector(n[6],.315392*(3*s*s-1)),e.addScaledVector(n[7],i*s*1.092548),e.addScaledVector(n[8],.546274*(i*i-r*r)),e}getIrradianceAt(t,e){const i=t.x,r=t.y,s=t.z,n=this.coefficients;return e.copy(n[0]).multiplyScalar(.886227),e.addScaledVector(n[1],1.023328*r),e.addScaledVector(n[2],1.023328*s),e.addScaledVector(n[3],1.023328*i),e.addScaledVector(n[4],.858086*i*r),e.addScaledVector(n[5],.858086*r*s),e.addScaledVector(n[6],.743125*s*s-.247708),e.addScaledVector(n[7],.858086*i*s),e.addScaledVector(n[8],.429043*(i*i-r*r)),e}add(t){for(let e=0;e<9;e++)this.coefficients[e].add(t.coefficients[e]);return this}addScaledSH(t,e){for(let i=0;i<9;i++)this.coefficients[i].addScaledVector(t.coefficients[i],e);return this}scale(t){for(let e=0;e<9;e++)this.coefficients[e].multiplyScalar(t);return this}lerp(t,e){for(let i=0;i<9;i++)this.coefficients[i].lerp(t.coefficients[i],e);return this}equals(t){for(let e=0;e<9;e++)if(!this.coefficients[e].equals(t.coefficients[e]))return!1;return!0}copy(t){return this.set(t.coefficients)}clone(){return(new this.constructor).copy(this)}fromArray(t,e=0){const i=this.coefficients;for(let r=0;r<9;r++)i[r].fromArray(t,e+3*r);return this}toArray(t=[],e=0){const i=this.coefficients;for(let r=0;r<9;r++)i[r].toArray(t,e+3*r);return t}static getBasisAt(t,e){const i=t.x,r=t.y,s=t.z;e[0]=.282095,e[1]=.488603*r,e[2]=.488603*s,e[3]=.488603*i,e[4]=1.092548*i*r,e[5]=1.092548*r*s,e[6]=.315392*(3*s*s-1),e[7]=1.092548*i*s,e[8]=.546274*(i*i-r*r)}}class LightProbe extends Light{constructor(t=new SphericalHarmonics3,e=1){super(void 0,e),this.isLightProbe=!0,this.sh=t}copy(t){return super.copy(t),this.sh.copy(t.sh),this}fromJSON(t){return this.intensity=t.intensity,this.sh.fromArray(t.sh),this}toJSON(t){const e=super.toJSON(t);return e.object.sh=this.sh.toArray(),e}}class MaterialLoader extends Loader{constructor(t){super(t),this.textures={}}load(t,e,i,r){const s=this,n=new FileLoader(s.manager);n.setPath(s.path),n.setRequestHeader(s.requestHeader),n.setWithCredentials(s.withCredentials),n.load(t,(function(i){try{e(s.parse(JSON.parse(i)))}catch(e){r?r(e):console.error(e),s.manager.itemError(t)}}),i,r)}parse(t){const e=this.textures;function i(t){return void 0===e[t]&&console.warn("THREE.MaterialLoader: Undefined texture",t),e[t]}const r=this.createMaterialFromType(t.type);if(void 0!==t.uuid&&(r.uuid=t.uuid),void 0!==t.name&&(r.name=t.name),void 0!==t.color&&void 0!==r.color&&r.color.setHex(t.color),void 0!==t.roughness&&(r.roughness=t.roughness),void 0!==t.metalness&&(r.metalness=t.metalness),void 0!==t.sheen&&(r.sheen=t.sheen),void 0!==t.sheenColor&&(r.sheenColor=(new Color).setHex(t.sheenColor)),void 0!==t.sheenRoughness&&(r.sheenRoughness=t.sheenRoughness),void 0!==t.emissive&&void 0!==r.emissive&&r.emissive.setHex(t.emissive),void 0!==t.specular&&void 0!==r.specular&&r.specular.setHex(t.specular),void 0!==t.specularIntensity&&(r.specularIntensity=t.specularIntensity),void 0!==t.specularColor&&void 0!==r.specularColor&&r.specularColor.setHex(t.specularColor),void 0!==t.shininess&&(r.shininess=t.shininess),void 0!==t.clearcoat&&(r.clearcoat=t.clearcoat),void 0!==t.clearcoatRoughness&&(r.clearcoatRoughness=t.clearcoatRoughness),void 0!==t.dispersion&&(r.dispersion=t.dispersion),void 0!==t.iridescence&&(r.iridescence=t.iridescence),void 0!==t.iridescenceIOR&&(r.iridescenceIOR=t.iridescenceIOR),void 0!==t.iridescenceThicknessRange&&(r.iridescenceThicknessRange=t.iridescenceThicknessRange),void 0!==t.transmission&&(r.transmission=t.transmission),void 0!==t.thickness&&(r.thickness=t.thickness),void 0!==t.attenuationDistance&&(r.attenuationDistance=t.attenuationDistance),void 0!==t.attenuationColor&&void 0!==r.attenuationColor&&r.attenuationColor.setHex(t.attenuationColor),void 0!==t.anisotropy&&(r.anisotropy=t.anisotropy),void 0!==t.anisotropyRotation&&(r.anisotropyRotation=t.anisotropyRotation),void 0!==t.fog&&(r.fog=t.fog),void 0!==t.flatShading&&(r.flatShading=t.flatShading),void 0!==t.blending&&(r.blending=t.blending),void 0!==t.combine&&(r.combine=t.combine),void 0!==t.side&&(r.side=t.side),void 0!==t.shadowSide&&(r.shadowSide=t.shadowSide),void 0!==t.opacity&&(r.opacity=t.opacity),void 0!==t.transparent&&(r.transparent=t.transparent),void 0!==t.alphaTest&&(r.alphaTest=t.alphaTest),void 0!==t.alphaHash&&(r.alphaHash=t.alphaHash),void 0!==t.depthFunc&&(r.depthFunc=t.depthFunc),void 0!==t.depthTest&&(r.depthTest=t.depthTest),void 0!==t.depthWrite&&(r.depthWrite=t.depthWrite),void 0!==t.colorWrite&&(r.colorWrite=t.colorWrite),void 0!==t.blendSrc&&(r.blendSrc=t.blendSrc),void 0!==t.blendDst&&(r.blendDst=t.blendDst),void 0!==t.blendEquation&&(r.blendEquation=t.blendEquation),void 0!==t.blendSrcAlpha&&(r.blendSrcAlpha=t.blendSrcAlpha),void 0!==t.blendDstAlpha&&(r.blendDstAlpha=t.blendDstAlpha),void 0!==t.blendEquationAlpha&&(r.blendEquationAlpha=t.blendEquationAlpha),void 0!==t.blendColor&&void 0!==r.blendColor&&r.blendColor.setHex(t.blendColor),void 0!==t.blendAlpha&&(r.blendAlpha=t.blendAlpha),void 0!==t.stencilWriteMask&&(r.stencilWriteMask=t.stencilWriteMask),void 0!==t.stencilFunc&&(r.stencilFunc=t.stencilFunc),void 0!==t.stencilRef&&(r.stencilRef=t.stencilRef),void 0!==t.stencilFuncMask&&(r.stencilFuncMask=t.stencilFuncMask),void 0!==t.stencilFail&&(r.stencilFail=t.stencilFail),void 0!==t.stencilZFail&&(r.stencilZFail=t.stencilZFail),void 0!==t.stencilZPass&&(r.stencilZPass=t.stencilZPass),void 0!==t.stencilWrite&&(r.stencilWrite=t.stencilWrite),void 0!==t.wireframe&&(r.wireframe=t.wireframe),void 0!==t.wireframeLinewidth&&(r.wireframeLinewidth=t.wireframeLinewidth),void 0!==t.wireframeLinecap&&(r.wireframeLinecap=t.wireframeLinecap),void 0!==t.wireframeLinejoin&&(r.wireframeLinejoin=t.wireframeLinejoin),void 0!==t.rotation&&(r.rotation=t.rotation),void 0!==t.linewidth&&(r.linewidth=t.linewidth),void 0!==t.dashSize&&(r.dashSize=t.dashSize),void 0!==t.gapSize&&(r.gapSize=t.gapSize),void 0!==t.scale&&(r.scale=t.scale),void 0!==t.polygonOffset&&(r.polygonOffset=t.polygonOffset),void 0!==t.polygonOffsetFactor&&(r.polygonOffsetFactor=t.polygonOffsetFactor),void 0!==t.polygonOffsetUnits&&(r.polygonOffsetUnits=t.polygonOffsetUnits),void 0!==t.dithering&&(r.dithering=t.dithering),void 0!==t.alphaToCoverage&&(r.alphaToCoverage=t.alphaToCoverage),void 0!==t.premultipliedAlpha&&(r.premultipliedAlpha=t.premultipliedAlpha),void 0!==t.forceSinglePass&&(r.forceSinglePass=t.forceSinglePass),void 0!==t.visible&&(r.visible=t.visible),void 0!==t.toneMapped&&(r.toneMapped=t.toneMapped),void 0!==t.userData&&(r.userData=t.userData),void 0!==t.vertexColors&&("number"==typeof t.vertexColors?r.vertexColors=t.vertexColors>0:r.vertexColors=t.vertexColors),void 0!==t.uniforms)for(const e in t.uniforms){const s=t.uniforms[e];switch(r.uniforms[e]={},s.type){case"t":r.uniforms[e].value=i(s.value);break;case"c":r.uniforms[e].value=(new Color).setHex(s.value);break;case"v2":r.uniforms[e].value=(new Vector2).fromArray(s.value);break;case"v3":r.uniforms[e].value=(new Vector3).fromArray(s.value);break;case"v4":r.uniforms[e].value=(new Vector4).fromArray(s.value);break;case"m3":r.uniforms[e].value=(new Matrix3).fromArray(s.value);break;case"m4":r.uniforms[e].value=(new Matrix4).fromArray(s.value);break;default:r.uniforms[e].value=s.value}}if(void 0!==t.defines&&(r.defines=t.defines),void 0!==t.vertexShader&&(r.vertexShader=t.vertexShader),void 0!==t.fragmentShader&&(r.fragmentShader=t.fragmentShader),void 0!==t.glslVersion&&(r.glslVersion=t.glslVersion),void 0!==t.extensions)for(const e in t.extensions)r.extensions[e]=t.extensions[e];if(void 0!==t.lights&&(r.lights=t.lights),void 0!==t.clipping&&(r.clipping=t.clipping),void 0!==t.size&&(r.size=t.size),void 0!==t.sizeAttenuation&&(r.sizeAttenuation=t.sizeAttenuation),void 0!==t.map&&(r.map=i(t.map)),void 0!==t.matcap&&(r.matcap=i(t.matcap)),void 0!==t.alphaMap&&(r.alphaMap=i(t.alphaMap)),void 0!==t.bumpMap&&(r.bumpMap=i(t.bumpMap)),void 0!==t.bumpScale&&(r.bumpScale=t.bumpScale),void 0!==t.normalMap&&(r.normalMap=i(t.normalMap)),void 0!==t.normalMapType&&(r.normalMapType=t.normalMapType),void 0!==t.normalScale){let e=t.normalScale;!1===Array.isArray(e)&&(e=[e,e]),r.normalScale=(new Vector2).fromArray(e)}return void 0!==t.displacementMap&&(r.displacementMap=i(t.displacementMap)),void 0!==t.displacementScale&&(r.displacementScale=t.displacementScale),void 0!==t.displacementBias&&(r.displacementBias=t.displacementBias),void 0!==t.roughnessMap&&(r.roughnessMap=i(t.roughnessMap)),void 0!==t.metalnessMap&&(r.metalnessMap=i(t.metalnessMap)),void 0!==t.emissiveMap&&(r.emissiveMap=i(t.emissiveMap)),void 0!==t.emissiveIntensity&&(r.emissiveIntensity=t.emissiveIntensity),void 0!==t.specularMap&&(r.specularMap=i(t.specularMap)),void 0!==t.specularIntensityMap&&(r.specularIntensityMap=i(t.specularIntensityMap)),void 0!==t.specularColorMap&&(r.specularColorMap=i(t.specularColorMap)),void 0!==t.envMap&&(r.envMap=i(t.envMap)),void 0!==t.envMapRotation&&r.envMapRotation.fromArray(t.envMapRotation),void 0!==t.envMapIntensity&&(r.envMapIntensity=t.envMapIntensity),void 0!==t.reflectivity&&(r.reflectivity=t.reflectivity),void 0!==t.refractionRatio&&(r.refractionRatio=t.refractionRatio),void 0!==t.lightMap&&(r.lightMap=i(t.lightMap)),void 0!==t.lightMapIntensity&&(r.lightMapIntensity=t.lightMapIntensity),void 0!==t.aoMap&&(r.aoMap=i(t.aoMap)),void 0!==t.aoMapIntensity&&(r.aoMapIntensity=t.aoMapIntensity),void 0!==t.gradientMap&&(r.gradientMap=i(t.gradientMap)),void 0!==t.clearcoatMap&&(r.clearcoatMap=i(t.clearcoatMap)),void 0!==t.clearcoatRoughnessMap&&(r.clearcoatRoughnessMap=i(t.clearcoatRoughnessMap)),void 0!==t.clearcoatNormalMap&&(r.clearcoatNormalMap=i(t.clearcoatNormalMap)),void 0!==t.clearcoatNormalScale&&(r.clearcoatNormalScale=(new Vector2).fromArray(t.clearcoatNormalScale)),void 0!==t.iridescenceMap&&(r.iridescenceMap=i(t.iridescenceMap)),void 0!==t.iridescenceThicknessMap&&(r.iridescenceThicknessMap=i(t.iridescenceThicknessMap)),void 0!==t.transmissionMap&&(r.transmissionMap=i(t.transmissionMap)),void 0!==t.thicknessMap&&(r.thicknessMap=i(t.thicknessMap)),void 0!==t.anisotropyMap&&(r.anisotropyMap=i(t.anisotropyMap)),void 0!==t.sheenColorMap&&(r.sheenColorMap=i(t.sheenColorMap)),void 0!==t.sheenRoughnessMap&&(r.sheenRoughnessMap=i(t.sheenRoughnessMap)),r}setTextures(t){return this.textures=t,this}createMaterialFromType(t){return MaterialLoader.createMaterialFromType(t)}static createMaterialFromType(t){return new{ShadowMaterial,SpriteMaterial,RawShaderMaterial,ShaderMaterial,PointsMaterial,MeshPhysicalMaterial,MeshStandardMaterial,MeshPhongMaterial,MeshToonMaterial,MeshNormalMaterial,MeshLambertMaterial,MeshDepthMaterial,MeshDistanceMaterial,MeshBasicMaterial,MeshMatcapMaterial,LineDashedMaterial,LineBasicMaterial,Material}[t]}}class LoaderUtils{static extractUrlBase(t){const e=t.lastIndexOf("/");return-1===e?"./":t.slice(0,e+1)}static resolveURL(t,e){return"string"!=typeof t||""===t?"":(/^https?:\/\//i.test(e)&&/^\//.test(t)&&(e=e.replace(/(^https?:\/\/[^\/]+).*/i,"$1")),/^(https?:)?\/\//i.test(t)||/^data:.*,.*$/i.test(t)||/^blob:.*$/i.test(t)?t:e+t)}}class InstancedBufferGeometry extends BufferGeometry{constructor(){super(),this.isInstancedBufferGeometry=!0,this.type="InstancedBufferGeometry",this.instanceCount=1/0}copy(t){return super.copy(t),this.instanceCount=t.instanceCount,this}toJSON(){const t=super.toJSON();return t.instanceCount=this.instanceCount,t.isInstancedBufferGeometry=!0,t}}class BufferGeometryLoader extends Loader{constructor(t){super(t)}load(t,e,i,r){const s=this,n=new FileLoader(s.manager);n.setPath(s.path),n.setRequestHeader(s.requestHeader),n.setWithCredentials(s.withCredentials),n.load(t,(function(i){try{e(s.parse(JSON.parse(i)))}catch(e){r?r(e):console.error(e),s.manager.itemError(t)}}),i,r)}parse(t){const e={},i={};function r(t,r){if(void 0!==e[r])return e[r];const s=t.interleavedBuffers[r],n=function(t,e){if(void 0!==i[e])return i[e];const r=t.arrayBuffers,s=r[e],n=new Uint32Array(s).buffer;return i[e]=n,n}(t,s.buffer),a=getTypedArray(s.type,n),o=new InterleavedBuffer(a,s.stride);return o.uuid=s.uuid,e[r]=o,o}const s=t.isInstancedBufferGeometry?new InstancedBufferGeometry:new BufferGeometry,n=t.data.index;if(void 0!==n){const t=getTypedArray(n.type,n.array);s.setIndex(new BufferAttribute(t,1))}const a=t.data.attributes;for(const e in a){const i=a[e];let n;if(i.isInterleavedBufferAttribute){const e=r(t.data,i.data);n=new InterleavedBufferAttribute(e,i.itemSize,i.offset,i.normalized)}else{const t=getTypedArray(i.type,i.array);n=new(i.isInstancedBufferAttribute?InstancedBufferAttribute:BufferAttribute)(t,i.itemSize,i.normalized)}void 0!==i.name&&(n.name=i.name),void 0!==i.usage&&n.setUsage(i.usage),s.setAttribute(e,n)}const o=t.data.morphAttributes;if(o)for(const e in o){const i=o[e],n=[];for(let e=0,s=i.length;e<s;e++){const s=i[e];let a;if(s.isInterleavedBufferAttribute){const e=r(t.data,s.data);a=new InterleavedBufferAttribute(e,s.itemSize,s.offset,s.normalized)}else{const t=getTypedArray(s.type,s.array);a=new BufferAttribute(t,s.itemSize,s.normalized)}void 0!==s.name&&(a.name=s.name),n.push(a)}s.morphAttributes[e]=n}t.data.morphTargetsRelative&&(s.morphTargetsRelative=!0);const h=t.data.groups||t.data.drawcalls||t.data.offsets;if(void 0!==h)for(let t=0,e=h.length;t!==e;++t){const e=h[t];s.addGroup(e.start,e.count,e.materialIndex)}const c=t.data.boundingSphere;if(void 0!==c){const t=new Vector3;void 0!==c.center&&t.fromArray(c.center),s.boundingSphere=new Sphere(t,c.radius)}return t.name&&(s.name=t.name),t.userData&&(s.userData=t.userData),s}}class ObjectLoader extends Loader{constructor(t){super(t)}load(t,e,i,r){const s=this,n=""===this.path?LoaderUtils.extractUrlBase(t):this.path;this.resourcePath=this.resourcePath||n;const a=new FileLoader(this.manager);a.setPath(this.path),a.setRequestHeader(this.requestHeader),a.setWithCredentials(this.withCredentials),a.load(t,(function(i){let n=null;try{n=JSON.parse(i)}catch(e){return void 0!==r&&r(e),void console.error("THREE:ObjectLoader: Can't parse "+t+".",e.message)}const a=n.metadata;if(void 0===a||void 0===a.type||"geometry"===a.type.toLowerCase())return void 0!==r&&r(new Error("THREE.ObjectLoader: Can't load "+t)),void console.error("THREE.ObjectLoader: Can't load "+t);s.parse(n,e)}),i,r)}async loadAsync(t,e){const i=""===this.path?LoaderUtils.extractUrlBase(t):this.path;this.resourcePath=this.resourcePath||i;const r=new FileLoader(this.manager);r.setPath(this.path),r.setRequestHeader(this.requestHeader),r.setWithCredentials(this.withCredentials);const s=await r.loadAsync(t,e),n=JSON.parse(s),a=n.metadata;if(void 0===a||void 0===a.type||"geometry"===a.type.toLowerCase())throw new Error("THREE.ObjectLoader: Can't load "+t);return await this.parseAsync(n)}parse(t,e){const i=this.parseAnimations(t.animations),r=this.parseShapes(t.shapes),s=this.parseGeometries(t.geometries,r),n=this.parseImages(t.images,(function(){void 0!==e&&e(h)})),a=this.parseTextures(t.textures,n),o=this.parseMaterials(t.materials,a),h=this.parseObject(t.object,s,o,a,i),c=this.parseSkeletons(t.skeletons,h);if(this.bindSkeletons(h,c),this.bindLightTargets(h),void 0!==e){let t=!1;for(const e in n)if(n[e].data instanceof HTMLImageElement){t=!0;break}!1===t&&e(h)}return h}async parseAsync(t){const e=this.parseAnimations(t.animations),i=this.parseShapes(t.shapes),r=this.parseGeometries(t.geometries,i),s=await this.parseImagesAsync(t.images),n=this.parseTextures(t.textures,s),a=this.parseMaterials(t.materials,n),o=this.parseObject(t.object,r,a,n,e),h=this.parseSkeletons(t.skeletons,o);return this.bindSkeletons(o,h),this.bindLightTargets(o),o}parseShapes(t){const e={};if(void 0!==t)for(let i=0,r=t.length;i<r;i++){const r=(new Shape).fromJSON(t[i]);e[r.uuid]=r}return e}parseSkeletons(t,e){const i={},r={};if(e.traverse((function(t){t.isBone&&(r[t.uuid]=t)})),void 0!==t)for(let e=0,s=t.length;e<s;e++){const s=(new Skeleton).fromJSON(t[e],r);i[s.uuid]=s}return i}parseGeometries(t,e){const i={};if(void 0!==t){const r=new BufferGeometryLoader;for(let s=0,n=t.length;s<n;s++){let n;const a=t[s];switch(a.type){case"BufferGeometry":case"InstancedBufferGeometry":n=r.parse(a);break;default:a.type in Geometries?n=Geometries[a.type].fromJSON(a,e):console.warn(`THREE.ObjectLoader: Unsupported geometry type "${a.type}"`)}n.uuid=a.uuid,void 0!==a.name&&(n.name=a.name),void 0!==a.userData&&(n.userData=a.userData),i[a.uuid]=n}}return i}parseMaterials(t,e){const i={},r={};if(void 0!==t){const s=new MaterialLoader;s.setTextures(e);for(let e=0,n=t.length;e<n;e++){const n=t[e];void 0===i[n.uuid]&&(i[n.uuid]=s.parse(n)),r[n.uuid]=i[n.uuid]}}return r}parseAnimations(t){const e={};if(void 0!==t)for(let i=0;i<t.length;i++){const r=t[i],s=AnimationClip.parse(r);e[s.uuid]=s}return e}parseImages(t,e){const i=this,r={};let s;function n(t){if("string"==typeof t){const e=t;return function(t){return i.manager.itemStart(t),s.load(t,(function(){i.manager.itemEnd(t)}),void 0,(function(){i.manager.itemError(t),i.manager.itemEnd(t)}))}(/^(\/\/)|([a-z]+:(\/\/)?)/i.test(e)?e:i.resourcePath+e)}return t.data?{data:getTypedArray(t.type,t.data),width:t.width,height:t.height}:null}if(void 0!==t&&t.length>0){const i=new LoadingManager(e);s=new ImageLoader(i),s.setCrossOrigin(this.crossOrigin);for(let e=0,i=t.length;e<i;e++){const i=t[e],s=i.url;if(Array.isArray(s)){const t=[];for(let e=0,i=s.length;e<i;e++){const i=n(s[e]);null!==i&&(i instanceof HTMLImageElement?t.push(i):t.push(new DataTexture(i.data,i.width,i.height)))}r[i.uuid]=new Source(t)}else{const t=n(i.url);r[i.uuid]=new Source(t)}}}return r}async parseImagesAsync(t){const e=this,i={};let r;async function s(t){if("string"==typeof t){const i=t,s=/^(\/\/)|([a-z]+:(\/\/)?)/i.test(i)?i:e.resourcePath+i;return await r.loadAsync(s)}return t.data?{data:getTypedArray(t.type,t.data),width:t.width,height:t.height}:null}if(void 0!==t&&t.length>0){r=new ImageLoader(this.manager),r.setCrossOrigin(this.crossOrigin);for(let e=0,r=t.length;e<r;e++){const r=t[e],n=r.url;if(Array.isArray(n)){const t=[];for(let e=0,i=n.length;e<i;e++){const i=n[e],r=await s(i);null!==r&&(r instanceof HTMLImageElement?t.push(r):t.push(new DataTexture(r.data,r.width,r.height)))}i[r.uuid]=new Source(t)}else{const t=await s(r.url);i[r.uuid]=new Source(t)}}}return i}parseTextures(t,e){function i(t,e){return"number"==typeof t?t:(console.warn("THREE.ObjectLoader.parseTexture: Constant should be in numeric form.",t),e[t])}const r={};if(void 0!==t)for(let s=0,n=t.length;s<n;s++){const n=t[s];void 0===n.image&&console.warn('THREE.ObjectLoader: No "image" specified for',n.uuid),void 0===e[n.image]&&console.warn("THREE.ObjectLoader: Undefined image",n.image);const a=e[n.image],o=a.data;let h;Array.isArray(o)?(h=new CubeTexture,6===o.length&&(h.needsUpdate=!0)):(h=o&&o.data?new DataTexture:new Texture,o&&(h.needsUpdate=!0)),h.source=a,h.uuid=n.uuid,void 0!==n.name&&(h.name=n.name),void 0!==n.mapping&&(h.mapping=i(n.mapping,TEXTURE_MAPPING)),void 0!==n.channel&&(h.channel=n.channel),void 0!==n.offset&&h.offset.fromArray(n.offset),void 0!==n.repeat&&h.repeat.fromArray(n.repeat),void 0!==n.center&&h.center.fromArray(n.center),void 0!==n.rotation&&(h.rotation=n.rotation),void 0!==n.wrap&&(h.wrapS=i(n.wrap[0],TEXTURE_WRAPPING),h.wrapT=i(n.wrap[1],TEXTURE_WRAPPING)),void 0!==n.format&&(h.format=n.format),void 0!==n.internalFormat&&(h.internalFormat=n.internalFormat),void 0!==n.type&&(h.type=n.type),void 0!==n.colorSpace&&(h.colorSpace=n.colorSpace),void 0!==n.minFilter&&(h.minFilter=i(n.minFilter,TEXTURE_FILTER)),void 0!==n.magFilter&&(h.magFilter=i(n.magFilter,TEXTURE_FILTER)),void 0!==n.anisotropy&&(h.anisotropy=n.anisotropy),void 0!==n.flipY&&(h.flipY=n.flipY),void 0!==n.generateMipmaps&&(h.generateMipmaps=n.generateMipmaps),void 0!==n.premultiplyAlpha&&(h.premultiplyAlpha=n.premultiplyAlpha),void 0!==n.unpackAlignment&&(h.unpackAlignment=n.unpackAlignment),void 0!==n.compareFunction&&(h.compareFunction=n.compareFunction),void 0!==n.userData&&(h.userData=n.userData),r[n.uuid]=h}return r}parseObject(t,e,i,r,s){let n,a,o;function h(t){return void 0===e[t]&&console.warn("THREE.ObjectLoader: Undefined geometry",t),e[t]}function c(t){if(void 0!==t){if(Array.isArray(t)){const e=[];for(let r=0,s=t.length;r<s;r++){const s=t[r];void 0===i[s]&&console.warn("THREE.ObjectLoader: Undefined material",s),e.push(i[s])}return e}return void 0===i[t]&&console.warn("THREE.ObjectLoader: Undefined material",t),i[t]}}function l(t){return void 0===r[t]&&console.warn("THREE.ObjectLoader: Undefined texture",t),r[t]}switch(t.type){case"Scene":n=new Scene,void 0!==t.background&&(Number.isInteger(t.background)?n.background=new Color(t.background):n.background=l(t.background)),void 0!==t.environment&&(n.environment=l(t.environment)),void 0!==t.fog&&("Fog"===t.fog.type?n.fog=new Fog(t.fog.color,t.fog.near,t.fog.far):"FogExp2"===t.fog.type&&(n.fog=new FogExp2(t.fog.color,t.fog.density)),""!==t.fog.name&&(n.fog.name=t.fog.name)),void 0!==t.backgroundBlurriness&&(n.backgroundBlurriness=t.backgroundBlurriness),void 0!==t.backgroundIntensity&&(n.backgroundIntensity=t.backgroundIntensity),void 0!==t.backgroundRotation&&n.backgroundRotation.fromArray(t.backgroundRotation),void 0!==t.environmentIntensity&&(n.environmentIntensity=t.environmentIntensity),void 0!==t.environmentRotation&&n.environmentRotation.fromArray(t.environmentRotation);break;case"PerspectiveCamera":n=new PerspectiveCamera(t.fov,t.aspect,t.near,t.far),void 0!==t.focus&&(n.focus=t.focus),void 0!==t.zoom&&(n.zoom=t.zoom),void 0!==t.filmGauge&&(n.filmGauge=t.filmGauge),void 0!==t.filmOffset&&(n.filmOffset=t.filmOffset),void 0!==t.view&&(n.view=Object.assign({},t.view));break;case"OrthographicCamera":n=new OrthographicCamera(t.left,t.right,t.top,t.bottom,t.near,t.far),void 0!==t.zoom&&(n.zoom=t.zoom),void 0!==t.view&&(n.view=Object.assign({},t.view));break;case"AmbientLight":n=new AmbientLight(t.color,t.intensity);break;case"DirectionalLight":n=new DirectionalLight(t.color,t.intensity),n.target=t.target||"";break;case"PointLight":n=new PointLight(t.color,t.intensity,t.distance,t.decay);break;case"RectAreaLight":n=new RectAreaLight(t.color,t.intensity,t.width,t.height);break;case"SpotLight":n=new SpotLight(t.color,t.intensity,t.distance,t.angle,t.penumbra,t.decay),n.target=t.target||"";break;case"HemisphereLight":n=new HemisphereLight(t.color,t.groundColor,t.intensity);break;case"LightProbe":n=(new LightProbe).fromJSON(t);break;case"SkinnedMesh":a=h(t.geometry),o=c(t.material),n=new SkinnedMesh(a,o),void 0!==t.bindMode&&(n.bindMode=t.bindMode),void 0!==t.bindMatrix&&n.bindMatrix.fromArray(t.bindMatrix),void 0!==t.skeleton&&(n.skeleton=t.skeleton);break;case"Mesh":a=h(t.geometry),o=c(t.material),n=new Mesh(a,o);break;case"InstancedMesh":a=h(t.geometry),o=c(t.material);const e=t.count,i=t.instanceMatrix,r=t.instanceColor;n=new InstancedMesh(a,o,e),n.instanceMatrix=new InstancedBufferAttribute(new Float32Array(i.array),16),void 0!==r&&(n.instanceColor=new InstancedBufferAttribute(new Float32Array(r.array),r.itemSize));break;case"BatchedMesh":a=h(t.geometry),o=c(t.material),n=new BatchedMesh(t.maxInstanceCount,t.maxVertexCount,t.maxIndexCount,o),n.geometry=a,n.perObjectFrustumCulled=t.perObjectFrustumCulled,n.sortObjects=t.sortObjects,n._drawRanges=t.drawRanges,n._reservedRanges=t.reservedRanges,n._geometryInfo=t.geometryInfo.map((t=>{let e=null,i=null;return void 0!==t.boundingBox&&(e=new Box3,e.min.fromArray(t.boundingBox.min),e.max.fromArray(t.boundingBox.max)),void 0!==t.boundingSphere&&(i=new Sphere,i.radius=t.boundingSphere.radius,i.center.fromArray(t.boundingSphere.center)),{...t,boundingBox:e,boundingSphere:i}})),n._instanceInfo=t.instanceInfo,n._availableInstanceIds=t._availableInstanceIds,n._availableGeometryIds=t._availableGeometryIds,n._nextIndexStart=t.nextIndexStart,n._nextVertexStart=t.nextVertexStart,n._geometryCount=t.geometryCount,n._maxInstanceCount=t.maxInstanceCount,n._maxVertexCount=t.maxVertexCount,n._maxIndexCount=t.maxIndexCount,n._geometryInitialized=t.geometryInitialized,n._matricesTexture=l(t.matricesTexture.uuid),n._indirectTexture=l(t.indirectTexture.uuid),void 0!==t.colorsTexture&&(n._colorsTexture=l(t.colorsTexture.uuid)),void 0!==t.boundingSphere&&(n.boundingSphere=new Sphere,n.boundingSphere.center.fromArray(t.boundingSphere.center),n.boundingSphere.radius=t.boundingSphere.radius),void 0!==t.boundingBox&&(n.boundingBox=new Box3,n.boundingBox.min.fromArray(t.boundingBox.min),n.boundingBox.max.fromArray(t.boundingBox.max));break;case"LOD":n=new LOD;break;case"Line":n=new Line(h(t.geometry),c(t.material));break;case"LineLoop":n=new LineLoop(h(t.geometry),c(t.material));break;case"LineSegments":n=new LineSegments(h(t.geometry),c(t.material));break;case"PointCloud":case"Points":n=new Points(h(t.geometry),c(t.material));break;case"Sprite":n=new Sprite(c(t.material));break;case"Group":n=new Group;break;case"Bone":n=new Bone;break;default:n=new Object3D}if(n.uuid=t.uuid,void 0!==t.name&&(n.name=t.name),void 0!==t.matrix?(n.matrix.fromArray(t.matrix),void 0!==t.matrixAutoUpdate&&(n.matrixAutoUpdate=t.matrixAutoUpdate),n.matrixAutoUpdate&&n.matrix.decompose(n.position,n.quaternion,n.scale)):(void 0!==t.position&&n.position.fromArray(t.position),void 0!==t.rotation&&n.rotation.fromArray(t.rotation),void 0!==t.quaternion&&n.quaternion.fromArray(t.quaternion),void 0!==t.scale&&n.scale.fromArray(t.scale)),void 0!==t.up&&n.up.fromArray(t.up),void 0!==t.castShadow&&(n.castShadow=t.castShadow),void 0!==t.receiveShadow&&(n.receiveShadow=t.receiveShadow),t.shadow&&(void 0!==t.shadow.intensity&&(n.shadow.intensity=t.shadow.intensity),void 0!==t.shadow.bias&&(n.shadow.bias=t.shadow.bias),void 0!==t.shadow.normalBias&&(n.shadow.normalBias=t.shadow.normalBias),void 0!==t.shadow.radius&&(n.shadow.radius=t.shadow.radius),void 0!==t.shadow.mapSize&&n.shadow.mapSize.fromArray(t.shadow.mapSize),void 0!==t.shadow.camera&&(n.shadow.camera=this.parseObject(t.shadow.camera))),void 0!==t.visible&&(n.visible=t.visible),void 0!==t.frustumCulled&&(n.frustumCulled=t.frustumCulled),void 0!==t.renderOrder&&(n.renderOrder=t.renderOrder),void 0!==t.userData&&(n.userData=t.userData),void 0!==t.layers&&(n.layers.mask=t.layers),void 0!==t.children){const a=t.children;for(let t=0;t<a.length;t++)n.add(this.parseObject(a[t],e,i,r,s))}if(void 0!==t.animations){const e=t.animations;for(let t=0;t<e.length;t++){const i=e[t];n.animations.push(s[i])}}if("LOD"===t.type){void 0!==t.autoUpdate&&(n.autoUpdate=t.autoUpdate);const e=t.levels;for(let t=0;t<e.length;t++){const i=e[t],r=n.getObjectByProperty("uuid",i.object);void 0!==r&&n.addLevel(r,i.distance,i.hysteresis)}}return n}bindSkeletons(t,e){0!==Object.keys(e).length&&t.traverse((function(t){if(!0===t.isSkinnedMesh&&void 0!==t.skeleton){const i=e[t.skeleton];void 0===i?console.warn("THREE.ObjectLoader: No skeleton found with UUID:",t.skeleton):t.bind(i,t.bindMatrix)}}))}bindLightTargets(t){t.traverse((function(e){if(e.isDirectionalLight||e.isSpotLight){const i=e.target,r=t.getObjectByProperty("uuid",i);e.target=void 0!==r?r:new Object3D}}))}}const TEXTURE_MAPPING={UVMapping:300,CubeReflectionMapping:301,CubeRefractionMapping:302,EquirectangularReflectionMapping:303,EquirectangularRefractionMapping:304,CubeUVReflectionMapping:306},TEXTURE_WRAPPING={RepeatWrapping:1e3,ClampToEdgeWrapping:1001,MirroredRepeatWrapping:1002},TEXTURE_FILTER={NearestFilter:1003,NearestMipmapNearestFilter:1004,NearestMipmapLinearFilter:1005,LinearFilter:1006,LinearMipmapNearestFilter:1007,LinearMipmapLinearFilter:1008};class ImageBitmapLoader extends Loader{constructor(t){super(t),this.isImageBitmapLoader=!0,"undefined"==typeof createImageBitmap&&console.warn("THREE.ImageBitmapLoader: createImageBitmap() not supported."),"undefined"==typeof fetch&&console.warn("THREE.ImageBitmapLoader: fetch() not supported."),this.options={premultiplyAlpha:"none"}}setOptions(t){return this.options=t,this}load(t,e,i,r){void 0===t&&(t=""),void 0!==this.path&&(t=this.path+t),t=this.manager.resolveURL(t);const s=this,n=Cache.get(t);if(void 0!==n)return s.manager.itemStart(t),n.then?void n.then((i=>{e&&e(i),s.manager.itemEnd(t)})).catch((t=>{r&&r(t)})):(setTimeout((function(){e&&e(n),s.manager.itemEnd(t)}),0),n);const a={};a.credentials="anonymous"===this.crossOrigin?"same-origin":"include",a.headers=this.requestHeader;const o=fetch(t,a).then((function(t){return t.blob()})).then((function(t){return createImageBitmap(t,Object.assign(s.options,{colorSpaceConversion:"none"}))})).then((function(i){return Cache.add(t,i),e&&e(i),s.manager.itemEnd(t),i})).catch((function(e){r&&r(e),Cache.remove(t),s.manager.itemError(t),s.manager.itemEnd(t)}));Cache.add(t,o),s.manager.itemStart(t)}}let _context;class AudioContext{static getContext(){return void 0===_context&&(_context=new(window.AudioContext||window.webkitAudioContext)),_context}static setContext(t){_context=t}}class AudioLoader extends Loader{constructor(t){super(t)}load(t,e,i,r){const s=this,n=new FileLoader(this.manager);function a(e){r?r(e):console.error(e),s.manager.itemError(t)}n.setResponseType("arraybuffer"),n.setPath(this.path),n.setRequestHeader(this.requestHeader),n.setWithCredentials(this.withCredentials),n.load(t,(function(t){try{const i=t.slice(0);AudioContext.getContext().decodeAudioData(i,(function(t){e(t)})).catch(a)}catch(t){a(t)}}),i,r)}}const _eyeRight=new Matrix4,_eyeLeft=new Matrix4,_projectionMatrix=new Matrix4;class StereoCamera{constructor(){this.type="StereoCamera",this.aspect=1,this.eyeSep=.064,this.cameraL=new PerspectiveCamera,this.cameraL.layers.enable(1),this.cameraL.matrixAutoUpdate=!1,this.cameraR=new PerspectiveCamera,this.cameraR.layers.enable(2),this.cameraR.matrixAutoUpdate=!1,this._cache={focus:null,fov:null,aspect:null,near:null,far:null,zoom:null,eyeSep:null}}update(t){const e=this._cache;if(e.focus!==t.focus||e.fov!==t.fov||e.aspect!==t.aspect*this.aspect||e.near!==t.near||e.far!==t.far||e.zoom!==t.zoom||e.eyeSep!==this.eyeSep){e.focus=t.focus,e.fov=t.fov,e.aspect=t.aspect*this.aspect,e.near=t.near,e.far=t.far,e.zoom=t.zoom,e.eyeSep=this.eyeSep,_projectionMatrix.copy(t.projectionMatrix);const i=e.eyeSep/2,r=i*e.near/e.focus,s=e.near*Math.tan(DEG2RAD*e.fov*.5)/e.zoom;let n,a;_eyeLeft.elements[12]=-i,_eyeRight.elements[12]=i,n=-s*e.aspect+r,a=s*e.aspect+r,_projectionMatrix.elements[0]=2*e.near/(a-n),_projectionMatrix.elements[8]=(a+n)/(a-n),this.cameraL.projectionMatrix.copy(_projectionMatrix),n=-s*e.aspect-r,a=s*e.aspect-r,_projectionMatrix.elements[0]=2*e.near/(a-n),_projectionMatrix.elements[8]=(a+n)/(a-n),this.cameraR.projectionMatrix.copy(_projectionMatrix)}this.cameraL.matrixWorld.copy(t.matrixWorld).multiply(_eyeLeft),this.cameraR.matrixWorld.copy(t.matrixWorld).multiply(_eyeRight)}}class ArrayCamera extends PerspectiveCamera{constructor(t=[]){super(),this.isArrayCamera=!0,this.isMultiViewCamera=!1,this.cameras=t}}class Clock{constructor(t=!0){this.autoStart=t,this.startTime=0,this.oldTime=0,this.elapsedTime=0,this.running=!1}start(){this.startTime=now(),this.oldTime=this.startTime,this.elapsedTime=0,this.running=!0}stop(){this.getElapsedTime(),this.running=!1,this.autoStart=!1}getElapsedTime(){return this.getDelta(),this.elapsedTime}getDelta(){let t=0;if(this.autoStart&&!this.running)return this.start(),0;if(this.running){const e=now();t=(e-this.oldTime)/1e3,this.oldTime=e,this.elapsedTime+=t}return t}}function now(){return performance.now()}const _position$1=new Vector3,_quaternion$1=new Quaternion,_scale$1=new Vector3,_orientation$1=new Vector3;class AudioListener extends Object3D{constructor(){super(),this.type="AudioListener",this.context=AudioContext.getContext(),this.gain=this.context.createGain(),this.gain.connect(this.context.destination),this.filter=null,this.timeDelta=0,this._clock=new Clock}getInput(){return this.gain}removeFilter(){return null!==this.filter&&(this.gain.disconnect(this.filter),this.filter.disconnect(this.context.destination),this.gain.connect(this.context.destination),this.filter=null),this}getFilter(){return this.filter}setFilter(t){return null!==this.filter?(this.gain.disconnect(this.filter),this.filter.disconnect(this.context.destination)):this.gain.disconnect(this.context.destination),this.filter=t,this.gain.connect(this.filter),this.filter.connect(this.context.destination),this}getMasterVolume(){return this.gain.gain.value}setMasterVolume(t){return this.gain.gain.setTargetAtTime(t,this.context.currentTime,.01),this}updateMatrixWorld(t){super.updateMatrixWorld(t);const e=this.context.listener,i=this.up;if(this.timeDelta=this._clock.getDelta(),this.matrixWorld.decompose(_position$1,_quaternion$1,_scale$1),_orientation$1.set(0,0,-1).applyQuaternion(_quaternion$1),e.positionX){const t=this.context.currentTime+this.timeDelta;e.positionX.linearRampToValueAtTime(_position$1.x,t),e.positionY.linearRampToValueAtTime(_position$1.y,t),e.positionZ.linearRampToValueAtTime(_position$1.z,t),e.forwardX.linearRampToValueAtTime(_orientation$1.x,t),e.forwardY.linearRampToValueAtTime(_orientation$1.y,t),e.forwardZ.linearRampToValueAtTime(_orientation$1.z,t),e.upX.linearRampToValueAtTime(i.x,t),e.upY.linearRampToValueAtTime(i.y,t),e.upZ.linearRampToValueAtTime(i.z,t)}else e.setPosition(_position$1.x,_position$1.y,_position$1.z),e.setOrientation(_orientation$1.x,_orientation$1.y,_orientation$1.z,i.x,i.y,i.z)}}class Audio extends Object3D{constructor(t){super(),this.type="Audio",this.listener=t,this.context=t.context,this.gain=this.context.createGain(),this.gain.connect(t.getInput()),this.autoplay=!1,this.buffer=null,this.detune=0,this.loop=!1,this.loopStart=0,this.loopEnd=0,this.offset=0,this.duration=void 0,this.playbackRate=1,this.isPlaying=!1,this.hasPlaybackControl=!0,this.source=null,this.sourceType="empty",this._startedAt=0,this._progress=0,this._connected=!1,this.filters=[]}getOutput(){return this.gain}setNodeSource(t){return this.hasPlaybackControl=!1,this.sourceType="audioNode",this.source=t,this.connect(),this}setMediaElementSource(t){return this.hasPlaybackControl=!1,this.sourceType="mediaNode",this.source=this.context.createMediaElementSource(t),this.connect(),this}setMediaStreamSource(t){return this.hasPlaybackControl=!1,this.sourceType="mediaStreamNode",this.source=this.context.createMediaStreamSource(t),this.connect(),this}setBuffer(t){return this.buffer=t,this.sourceType="buffer",this.autoplay&&this.play(),this}play(t=0){if(!0===this.isPlaying)return void console.warn("THREE.Audio: Audio is already playing.");if(!1===this.hasPlaybackControl)return void console.warn("THREE.Audio: this Audio has no playback control.");this._startedAt=this.context.currentTime+t;const e=this.context.createBufferSource();return e.buffer=this.buffer,e.loop=this.loop,e.loopStart=this.loopStart,e.loopEnd=this.loopEnd,e.onended=this.onEnded.bind(this),e.start(this._startedAt,this._progress+this.offset,this.duration),this.isPlaying=!0,this.source=e,this.setDetune(this.detune),this.setPlaybackRate(this.playbackRate),this.connect()}pause(){if(!1!==this.hasPlaybackControl)return!0===this.isPlaying&&(this._progress+=Math.max(this.context.currentTime-this._startedAt,0)*this.playbackRate,!0===this.loop&&(this._progress=this._progress%(this.duration||this.buffer.duration)),this.source.stop(),this.source.onended=null,this.isPlaying=!1),this;console.warn("THREE.Audio: this Audio has no playback control.")}stop(t=0){if(!1!==this.hasPlaybackControl)return this._progress=0,null!==this.source&&(this.source.stop(this.context.currentTime+t),this.source.onended=null),this.isPlaying=!1,this;console.warn("THREE.Audio: this Audio has no playback control.")}connect(){if(this.filters.length>0){this.source.connect(this.filters[0]);for(let t=1,e=this.filters.length;t<e;t++)this.filters[t-1].connect(this.filters[t]);this.filters[this.filters.length-1].connect(this.getOutput())}else this.source.connect(this.getOutput());return this._connected=!0,this}disconnect(){if(!1!==this._connected){if(this.filters.length>0){this.source.disconnect(this.filters[0]);for(let t=1,e=this.filters.length;t<e;t++)this.filters[t-1].disconnect(this.filters[t]);this.filters[this.filters.length-1].disconnect(this.getOutput())}else this.source.disconnect(this.getOutput());return this._connected=!1,this}}getFilters(){return this.filters}setFilters(t){return t||(t=[]),!0===this._connected?(this.disconnect(),this.filters=t.slice(),this.connect()):this.filters=t.slice(),this}setDetune(t){return this.detune=t,!0===this.isPlaying&&void 0!==this.source.detune&&this.source.detune.setTargetAtTime(this.detune,this.context.currentTime,.01),this}getDetune(){return this.detune}getFilter(){return this.getFilters()[0]}setFilter(t){return this.setFilters(t?[t]:[])}setPlaybackRate(t){if(!1!==this.hasPlaybackControl)return this.playbackRate=t,!0===this.isPlaying&&this.source.playbackRate.setTargetAtTime(this.playbackRate,this.context.currentTime,.01),this;console.warn("THREE.Audio: this Audio has no playback control.")}getPlaybackRate(){return this.playbackRate}onEnded(){this.isPlaying=!1,this._progress=0}getLoop(){return!1===this.hasPlaybackControl?(console.warn("THREE.Audio: this Audio has no playback control."),!1):this.loop}setLoop(t){if(!1!==this.hasPlaybackControl)return this.loop=t,!0===this.isPlaying&&(this.source.loop=this.loop),this;console.warn("THREE.Audio: this Audio has no playback control.")}setLoopStart(t){return this.loopStart=t,this}setLoopEnd(t){return this.loopEnd=t,this}getVolume(){return this.gain.gain.value}setVolume(t){return this.gain.gain.setTargetAtTime(t,this.context.currentTime,.01),this}copy(t,e){return super.copy(t,e),"buffer"!==t.sourceType?(console.warn("THREE.Audio: Audio source type cannot be copied."),this):(this.autoplay=t.autoplay,this.buffer=t.buffer,this.detune=t.detune,this.loop=t.loop,this.loopStart=t.loopStart,this.loopEnd=t.loopEnd,this.offset=t.offset,this.duration=t.duration,this.playbackRate=t.playbackRate,this.hasPlaybackControl=t.hasPlaybackControl,this.sourceType=t.sourceType,this.filters=t.filters.slice(),this)}clone(t){return new this.constructor(this.listener).copy(this,t)}}const _position=new Vector3,_quaternion=new Quaternion,_scale=new Vector3,_orientation=new Vector3;class PositionalAudio extends Audio{constructor(t){super(t),this.panner=this.context.createPanner(),this.panner.panningModel="HRTF",this.panner.connect(this.gain)}connect(){return super.connect(),this.panner.connect(this.gain),this}disconnect(){return super.disconnect(),this.panner.disconnect(this.gain),this}getOutput(){return this.panner}getRefDistance(){return this.panner.refDistance}setRefDistance(t){return this.panner.refDistance=t,this}getRolloffFactor(){return this.panner.rolloffFactor}setRolloffFactor(t){return this.panner.rolloffFactor=t,this}getDistanceModel(){return this.panner.distanceModel}setDistanceModel(t){return this.panner.distanceModel=t,this}getMaxDistance(){return this.panner.maxDistance}setMaxDistance(t){return this.panner.maxDistance=t,this}setDirectionalCone(t,e,i){return this.panner.coneInnerAngle=t,this.panner.coneOuterAngle=e,this.panner.coneOuterGain=i,this}updateMatrixWorld(t){if(super.updateMatrixWorld(t),!0===this.hasPlaybackControl&&!1===this.isPlaying)return;this.matrixWorld.decompose(_position,_quaternion,_scale),_orientation.set(0,0,1).applyQuaternion(_quaternion);const e=this.panner;if(e.positionX){const t=this.context.currentTime+this.listener.timeDelta;e.positionX.linearRampToValueAtTime(_position.x,t),e.positionY.linearRampToValueAtTime(_position.y,t),e.positionZ.linearRampToValueAtTime(_position.z,t),e.orientationX.linearRampToValueAtTime(_orientation.x,t),e.orientationY.linearRampToValueAtTime(_orientation.y,t),e.orientationZ.linearRampToValueAtTime(_orientation.z,t)}else e.setPosition(_position.x,_position.y,_position.z),e.setOrientation(_orientation.x,_orientation.y,_orientation.z)}}class AudioAnalyser{constructor(t,e=2048){this.analyser=t.context.createAnalyser(),this.analyser.fftSize=e,this.data=new Uint8Array(this.analyser.frequencyBinCount),t.getOutput().connect(this.analyser)}getFrequencyData(){return this.analyser.getByteFrequencyData(this.data),this.data}getAverageFrequency(){let t=0;const e=this.getFrequencyData();for(let i=0;i<e.length;i++)t+=e[i];return t/e.length}}class PropertyMixer{constructor(t,e,i){let r,s,n;switch(this.binding=t,this.valueSize=i,e){case"quaternion":r=this._slerp,s=this._slerpAdditive,n=this._setAdditiveIdentityQuaternion,this.buffer=new Float64Array(6*i),this._workIndex=5;break;case"string":case"bool":r=this._select,s=this._select,n=this._setAdditiveIdentityOther,this.buffer=new Array(5*i);break;default:r=this._lerp,s=this._lerpAdditive,n=this._setAdditiveIdentityNumeric,this.buffer=new Float64Array(5*i)}this._mixBufferRegion=r,this._mixBufferRegionAdditive=s,this._setIdentity=n,this._origIndex=3,this._addIndex=4,this.cumulativeWeight=0,this.cumulativeWeightAdditive=0,this.useCount=0,this.referenceCount=0}accumulate(t,e){const i=this.buffer,r=this.valueSize,s=t*r+r;let n=this.cumulativeWeight;if(0===n){for(let t=0;t!==r;++t)i[s+t]=i[t];n=e}else{n+=e;const t=e/n;this._mixBufferRegion(i,s,0,t,r)}this.cumulativeWeight=n}accumulateAdditive(t){const e=this.buffer,i=this.valueSize,r=i*this._addIndex;0===this.cumulativeWeightAdditive&&this._setIdentity(),this._mixBufferRegionAdditive(e,r,0,t,i),this.cumulativeWeightAdditive+=t}apply(t){const e=this.valueSize,i=this.buffer,r=t*e+e,s=this.cumulativeWeight,n=this.cumulativeWeightAdditive,a=this.binding;if(this.cumulativeWeight=0,this.cumulativeWeightAdditive=0,s<1){const t=e*this._origIndex;this._mixBufferRegion(i,r,t,1-s,e)}n>0&&this._mixBufferRegionAdditive(i,r,this._addIndex*e,1,e);for(let t=e,s=e+e;t!==s;++t)if(i[t]!==i[t+e]){a.setValue(i,r);break}}saveOriginalState(){const t=this.binding,e=this.buffer,i=this.valueSize,r=i*this._origIndex;t.getValue(e,r);for(let t=i,s=r;t!==s;++t)e[t]=e[r+t%i];this._setIdentity(),this.cumulativeWeight=0,this.cumulativeWeightAdditive=0}restoreOriginalState(){const t=3*this.valueSize;this.binding.setValue(this.buffer,t)}_setAdditiveIdentityNumeric(){const t=this._addIndex*this.valueSize,e=t+this.valueSize;for(let i=t;i<e;i++)this.buffer[i]=0}_setAdditiveIdentityQuaternion(){this._setAdditiveIdentityNumeric(),this.buffer[this._addIndex*this.valueSize+3]=1}_setAdditiveIdentityOther(){const t=this._origIndex*this.valueSize,e=this._addIndex*this.valueSize;for(let i=0;i<this.valueSize;i++)this.buffer[e+i]=this.buffer[t+i]}_select(t,e,i,r,s){if(r>=.5)for(let r=0;r!==s;++r)t[e+r]=t[i+r]}_slerp(t,e,i,r){Quaternion.slerpFlat(t,e,t,e,t,i,r)}_slerpAdditive(t,e,i,r,s){const n=this._workIndex*s;Quaternion.multiplyQuaternionsFlat(t,n,t,e,t,i),Quaternion.slerpFlat(t,e,t,e,t,n,r)}_lerp(t,e,i,r,s){const n=1-r;for(let a=0;a!==s;++a){const s=e+a;t[s]=t[s]*n+t[i+a]*r}}_lerpAdditive(t,e,i,r,s){for(let n=0;n!==s;++n){const s=e+n;t[s]=t[s]+t[i+n]*r}}}const _RESERVED_CHARS_RE="\\[\\]\\.:\\/",_reservedRe=new RegExp("[\\[\\]\\.:\\/]","g"),_wordChar="[^\\[\\]\\.:\\/]",_wordCharOrDot="[^"+"\\[\\]\\.:\\/".replace("\\.","")+"]",_directoryRe=/((?:WC+[\/:])*)/.source.replace("WC",_wordChar),_nodeRe=/(WCOD+)?/.source.replace("WCOD",_wordCharOrDot),_objectRe=/(?:\.(WC+)(?:\[(.+)\])?)?/.source.replace("WC",_wordChar),_propertyRe=/\.(WC+)(?:\[(.+)\])?/.source.replace("WC",_wordChar),_trackRe=new RegExp("^"+_directoryRe+_nodeRe+_objectRe+_propertyRe+"$"),_supportedObjectNames=["material","materials","bones","map"];class Composite{constructor(t,e,i){const r=i||PropertyBinding.parseTrackName(e);this._targetGroup=t,this._bindings=t.subscribe_(e,r)}getValue(t,e){this.bind();const i=this._targetGroup.nCachedObjects_,r=this._bindings[i];void 0!==r&&r.getValue(t,e)}setValue(t,e){const i=this._bindings;for(let r=this._targetGroup.nCachedObjects_,s=i.length;r!==s;++r)i[r].setValue(t,e)}bind(){const t=this._bindings;for(let e=this._targetGroup.nCachedObjects_,i=t.length;e!==i;++e)t[e].bind()}unbind(){const t=this._bindings;for(let e=this._targetGroup.nCachedObjects_,i=t.length;e!==i;++e)t[e].unbind()}}class PropertyBinding{constructor(t,e,i){this.path=e,this.parsedPath=i||PropertyBinding.parseTrackName(e),this.node=PropertyBinding.findNode(t,this.parsedPath.nodeName),this.rootNode=t,this.getValue=this._getValue_unbound,this.setValue=this._setValue_unbound}static create(t,e,i){return t&&t.isAnimationObjectGroup?new PropertyBinding.Composite(t,e,i):new PropertyBinding(t,e,i)}static sanitizeNodeName(t){return t.replace(/\s/g,"_").replace(_reservedRe,"")}static parseTrackName(t){const e=_trackRe.exec(t);if(null===e)throw new Error("PropertyBinding: Cannot parse trackName: "+t);const i={nodeName:e[2],objectName:e[3],objectIndex:e[4],propertyName:e[5],propertyIndex:e[6]},r=i.nodeName&&i.nodeName.lastIndexOf(".");if(void 0!==r&&-1!==r){const t=i.nodeName.substring(r+1);-1!==_supportedObjectNames.indexOf(t)&&(i.nodeName=i.nodeName.substring(0,r),i.objectName=t)}if(null===i.propertyName||0===i.propertyName.length)throw new Error("PropertyBinding: can not parse propertyName from trackName: "+t);return i}static findNode(t,e){if(void 0===e||""===e||"."===e||-1===e||e===t.name||e===t.uuid)return t;if(t.skeleton){const i=t.skeleton.getBoneByName(e);if(void 0!==i)return i}if(t.children){const i=function(t){for(let r=0;r<t.length;r++){const s=t[r];if(s.name===e||s.uuid===e)return s;const n=i(s.children);if(n)return n}return null},r=i(t.children);if(r)return r}return null}_getValue_unavailable(){}_setValue_unavailable(){}_getValue_direct(t,e){t[e]=this.targetObject[this.propertyName]}_getValue_array(t,e){const i=this.resolvedProperty;for(let r=0,s=i.length;r!==s;++r)t[e++]=i[r]}_getValue_arrayElement(t,e){t[e]=this.resolvedProperty[this.propertyIndex]}_getValue_toArray(t,e){this.resolvedProperty.toArray(t,e)}_setValue_direct(t,e){this.targetObject[this.propertyName]=t[e]}_setValue_direct_setNeedsUpdate(t,e){this.targetObject[this.propertyName]=t[e],this.targetObject.needsUpdate=!0}_setValue_direct_setMatrixWorldNeedsUpdate(t,e){this.targetObject[this.propertyName]=t[e],this.targetObject.matrixWorldNeedsUpdate=!0}_setValue_array(t,e){const i=this.resolvedProperty;for(let r=0,s=i.length;r!==s;++r)i[r]=t[e++]}_setValue_array_setNeedsUpdate(t,e){const i=this.resolvedProperty;for(let r=0,s=i.length;r!==s;++r)i[r]=t[e++];this.targetObject.needsUpdate=!0}_setValue_array_setMatrixWorldNeedsUpdate(t,e){const i=this.resolvedProperty;for(let r=0,s=i.length;r!==s;++r)i[r]=t[e++];this.targetObject.matrixWorldNeedsUpdate=!0}_setValue_arrayElement(t,e){this.resolvedProperty[this.propertyIndex]=t[e]}_setValue_arrayElement_setNeedsUpdate(t,e){this.resolvedProperty[this.propertyIndex]=t[e],this.targetObject.needsUpdate=!0}_setValue_arrayElement_setMatrixWorldNeedsUpdate(t,e){this.resolvedProperty[this.propertyIndex]=t[e],this.targetObject.matrixWorldNeedsUpdate=!0}_setValue_fromArray(t,e){this.resolvedProperty.fromArray(t,e)}_setValue_fromArray_setNeedsUpdate(t,e){this.resolvedProperty.fromArray(t,e),this.targetObject.needsUpdate=!0}_setValue_fromArray_setMatrixWorldNeedsUpdate(t,e){this.resolvedProperty.fromArray(t,e),this.targetObject.matrixWorldNeedsUpdate=!0}_getValue_unbound(t,e){this.bind(),this.getValue(t,e)}_setValue_unbound(t,e){this.bind(),this.setValue(t,e)}bind(){let t=this.node;const e=this.parsedPath,i=e.objectName,r=e.propertyName;let s=e.propertyIndex;if(t||(t=PropertyBinding.findNode(this.rootNode,e.nodeName),this.node=t),this.getValue=this._getValue_unavailable,this.setValue=this._setValue_unavailable,!t)return void console.warn("THREE.PropertyBinding: No target node found for track: "+this.path+".");if(i){let r=e.objectIndex;switch(i){case"materials":if(!t.material)return void console.error("THREE.PropertyBinding: Can not bind to material as node does not have a material.",this);if(!t.material.materials)return void console.error("THREE.PropertyBinding: Can not bind to material.materials as node.material does not have a materials array.",this);t=t.material.materials;break;case"bones":if(!t.skeleton)return void console.error("THREE.PropertyBinding: Can not bind to bones as node does not have a skeleton.",this);t=t.skeleton.bones;for(let e=0;e<t.length;e++)if(t[e].name===r){r=e;break}break;case"map":if("map"in t){t=t.map;break}if(!t.material)return void console.error("THREE.PropertyBinding: Can not bind to material as node does not have a material.",this);if(!t.material.map)return void console.error("THREE.PropertyBinding: Can not bind to material.map as node.material does not have a map.",this);t=t.material.map;break;default:if(void 0===t[i])return void console.error("THREE.PropertyBinding: Can not bind to objectName of node undefined.",this);t=t[i]}if(void 0!==r){if(void 0===t[r])return void console.error("THREE.PropertyBinding: Trying to bind to objectIndex of objectName, but is undefined.",this,t);t=t[r]}}const n=t[r];if(void 0===n){const i=e.nodeName;return void console.error("THREE.PropertyBinding: Trying to update property for track: "+i+"."+r+" but it wasn't found.",t)}let a=this.Versioning.None;this.targetObject=t,!0===t.isMaterial?a=this.Versioning.NeedsUpdate:!0===t.isObject3D&&(a=this.Versioning.MatrixWorldNeedsUpdate);let o=this.BindingType.Direct;if(void 0!==s){if("morphTargetInfluences"===r){if(!t.geometry)return void console.error("THREE.PropertyBinding: Can not bind to morphTargetInfluences because node does not have a geometry.",this);if(!t.geometry.morphAttributes)return void console.error("THREE.PropertyBinding: Can not bind to morphTargetInfluences because node does not have a geometry.morphAttributes.",this);void 0!==t.morphTargetDictionary[s]&&(s=t.morphTargetDictionary[s])}o=this.BindingType.ArrayElement,this.resolvedProperty=n,this.propertyIndex=s}else void 0!==n.fromArray&&void 0!==n.toArray?(o=this.BindingType.HasFromToArray,this.resolvedProperty=n):Array.isArray(n)?(o=this.BindingType.EntireArray,this.resolvedProperty=n):this.propertyName=r;this.getValue=this.GetterByBindingType[o],this.setValue=this.SetterByBindingTypeAndVersioning[o][a]}unbind(){this.node=null,this.getValue=this._getValue_unbound,this.setValue=this._setValue_unbound}}PropertyBinding.Composite=Composite,PropertyBinding.prototype.BindingType={Direct:0,EntireArray:1,ArrayElement:2,HasFromToArray:3},PropertyBinding.prototype.Versioning={None:0,NeedsUpdate:1,MatrixWorldNeedsUpdate:2},PropertyBinding.prototype.GetterByBindingType=[PropertyBinding.prototype._getValue_direct,PropertyBinding.prototype._getValue_array,PropertyBinding.prototype._getValue_arrayElement,PropertyBinding.prototype._getValue_toArray],PropertyBinding.prototype.SetterByBindingTypeAndVersioning=[[PropertyBinding.prototype._setValue_direct,PropertyBinding.prototype._setValue_direct_setNeedsUpdate,PropertyBinding.prototype._setValue_direct_setMatrixWorldNeedsUpdate],[PropertyBinding.prototype._setValue_array,PropertyBinding.prototype._setValue_array_setNeedsUpdate,PropertyBinding.prototype._setValue_array_setMatrixWorldNeedsUpdate],[PropertyBinding.prototype._setValue_arrayElement,PropertyBinding.prototype._setValue_arrayElement_setNeedsUpdate,PropertyBinding.prototype._setValue_arrayElement_setMatrixWorldNeedsUpdate],[PropertyBinding.prototype._setValue_fromArray,PropertyBinding.prototype._setValue_fromArray_setNeedsUpdate,PropertyBinding.prototype._setValue_fromArray_setMatrixWorldNeedsUpdate]];class AnimationObjectGroup{constructor(){this.isAnimationObjectGroup=!0,this.uuid=generateUUID(),this._objects=Array.prototype.slice.call(arguments),this.nCachedObjects_=0;const t={};this._indicesByUUID=t;for(let e=0,i=arguments.length;e!==i;++e)t[arguments[e].uuid]=e;this._paths=[],this._parsedPaths=[],this._bindings=[],this._bindingsIndicesByPath={};const e=this;this.stats={objects:{get total(){return e._objects.length},get inUse(){return this.total-e.nCachedObjects_}},get bindingsPerObject(){return e._bindings.length}}}add(){const t=this._objects,e=this._indicesByUUID,i=this._paths,r=this._parsedPaths,s=this._bindings,n=s.length;let a,o=t.length,h=this.nCachedObjects_;for(let c=0,l=arguments.length;c!==l;++c){const l=arguments[c],u=l.uuid;let p=e[u];if(void 0===p){p=o++,e[u]=p,t.push(l);for(let t=0,e=n;t!==e;++t)s[t].push(new PropertyBinding(l,i[t],r[t]))}else if(p<h){a=t[p];const o=--h,c=t[o];e[c.uuid]=p,t[p]=c,e[u]=o,t[o]=l;for(let t=0,e=n;t!==e;++t){const e=s[t],n=e[o];let a=e[p];e[p]=n,void 0===a&&(a=new PropertyBinding(l,i[t],r[t])),e[o]=a}}else t[p]!==a&&console.error("THREE.AnimationObjectGroup: Different objects with the same UUID detected. Clean the caches or recreate your infrastructure when reloading scenes.")}this.nCachedObjects_=h}remove(){const t=this._objects,e=this._indicesByUUID,i=this._bindings,r=i.length;let s=this.nCachedObjects_;for(let n=0,a=arguments.length;n!==a;++n){const a=arguments[n],o=a.uuid,h=e[o];if(void 0!==h&&h>=s){const n=s++,c=t[n];e[c.uuid]=h,t[h]=c,e[o]=n,t[n]=a;for(let t=0,e=r;t!==e;++t){const e=i[t],r=e[n],s=e[h];e[h]=r,e[n]=s}}}this.nCachedObjects_=s}uncache(){const t=this._objects,e=this._indicesByUUID,i=this._bindings,r=i.length;let s=this.nCachedObjects_,n=t.length;for(let a=0,o=arguments.length;a!==o;++a){const o=arguments[a].uuid,h=e[o];if(void 0!==h)if(delete e[o],h<s){const a=--s,o=t[a],c=--n,l=t[c];e[o.uuid]=h,t[h]=o,e[l.uuid]=a,t[a]=l,t.pop();for(let t=0,e=r;t!==e;++t){const e=i[t],r=e[a],s=e[c];e[h]=r,e[a]=s,e.pop()}}else{const s=--n,a=t[s];s>0&&(e[a.uuid]=h),t[h]=a,t.pop();for(let t=0,e=r;t!==e;++t){const e=i[t];e[h]=e[s],e.pop()}}}this.nCachedObjects_=s}subscribe_(t,e){const i=this._bindingsIndicesByPath;let r=i[t];const s=this._bindings;if(void 0!==r)return s[r];const n=this._paths,a=this._parsedPaths,o=this._objects,h=o.length,c=this.nCachedObjects_,l=new Array(h);r=s.length,i[t]=r,n.push(t),a.push(e),s.push(l);for(let i=c,r=o.length;i!==r;++i){const r=o[i];l[i]=new PropertyBinding(r,t,e)}return l}unsubscribe_(t){const e=this._bindingsIndicesByPath,i=e[t];if(void 0!==i){const r=this._paths,s=this._parsedPaths,n=this._bindings,a=n.length-1,o=n[a];e[t[a]]=i,n[i]=o,n.pop(),s[i]=s[a],s.pop(),r[i]=r[a],r.pop()}}}class AnimationAction{constructor(t,e,i=null,r=e.blendMode){this._mixer=t,this._clip=e,this._localRoot=i,this.blendMode=r;const s=e.tracks,n=s.length,a=new Array(n),o={endingStart:2400,endingEnd:2400};for(let t=0;t!==n;++t){const e=s[t].createInterpolant(null);a[t]=e,e.settings=o}this._interpolantSettings=o,this._interpolants=a,this._propertyBindings=new Array(n),this._cacheIndex=null,this._byClipCacheIndex=null,this._timeScaleInterpolant=null,this._weightInterpolant=null,this.loop=2201,this._loopCount=-1,this._startTime=null,this.time=0,this.timeScale=1,this._effectiveTimeScale=1,this.weight=1,this._effectiveWeight=1,this.repetitions=1/0,this.paused=!1,this.enabled=!0,this.clampWhenFinished=!1,this.zeroSlopeAtStart=!0,this.zeroSlopeAtEnd=!0}play(){return this._mixer._activateAction(this),this}stop(){return this._mixer._deactivateAction(this),this.reset()}reset(){return this.paused=!1,this.enabled=!0,this.time=0,this._loopCount=-1,this._startTime=null,this.stopFading().stopWarping()}isRunning(){return this.enabled&&!this.paused&&0!==this.timeScale&&null===this._startTime&&this._mixer._isActiveAction(this)}isScheduled(){return this._mixer._isActiveAction(this)}startAt(t){return this._startTime=t,this}setLoop(t,e){return this.loop=t,this.repetitions=e,this}setEffectiveWeight(t){return this.weight=t,this._effectiveWeight=this.enabled?t:0,this.stopFading()}getEffectiveWeight(){return this._effectiveWeight}fadeIn(t){return this._scheduleFading(t,0,1)}fadeOut(t){return this._scheduleFading(t,1,0)}crossFadeFrom(t,e,i=!1){if(t.fadeOut(e),this.fadeIn(e),!0===i){const i=this._clip.duration,r=t._clip.duration,s=r/i,n=i/r;t.warp(1,s,e),this.warp(n,1,e)}return this}crossFadeTo(t,e,i=!1){return t.crossFadeFrom(this,e,i)}stopFading(){const t=this._weightInterpolant;return null!==t&&(this._weightInterpolant=null,this._mixer._takeBackControlInterpolant(t)),this}setEffectiveTimeScale(t){return this.timeScale=t,this._effectiveTimeScale=this.paused?0:t,this.stopWarping()}getEffectiveTimeScale(){return this._effectiveTimeScale}setDuration(t){return this.timeScale=this._clip.duration/t,this.stopWarping()}syncWith(t){return this.time=t.time,this.timeScale=t.timeScale,this.stopWarping()}halt(t){return this.warp(this._effectiveTimeScale,0,t)}warp(t,e,i){const r=this._mixer,s=r.time,n=this.timeScale;let a=this._timeScaleInterpolant;null===a&&(a=r._lendControlInterpolant(),this._timeScaleInterpolant=a);const o=a.parameterPositions,h=a.sampleValues;return o[0]=s,o[1]=s+i,h[0]=t/n,h[1]=e/n,this}stopWarping(){const t=this._timeScaleInterpolant;return null!==t&&(this._timeScaleInterpolant=null,this._mixer._takeBackControlInterpolant(t)),this}getMixer(){return this._mixer}getClip(){return this._clip}getRoot(){return this._localRoot||this._mixer._root}_update(t,e,i,r){if(!this.enabled)return void this._updateWeight(t);const s=this._startTime;if(null!==s){const r=(t-s)*i;r<0||0===i?e=0:(this._startTime=null,e=i*r)}e*=this._updateTimeScale(t);const n=this._updateTime(e),a=this._updateWeight(t);if(a>0){const t=this._interpolants,e=this._propertyBindings;if(2501===this.blendMode)for(let i=0,r=t.length;i!==r;++i)t[i].evaluate(n),e[i].accumulateAdditive(a);else for(let i=0,s=t.length;i!==s;++i)t[i].evaluate(n),e[i].accumulate(r,a)}}_updateWeight(t){let e=0;if(this.enabled){e=this.weight;const i=this._weightInterpolant;if(null!==i){const r=i.evaluate(t)[0];e*=r,t>i.parameterPositions[1]&&(this.stopFading(),0===r&&(this.enabled=!1))}}return this._effectiveWeight=e,e}_updateTimeScale(t){let e=0;if(!this.paused){e=this.timeScale;const i=this._timeScaleInterpolant;if(null!==i){e*=i.evaluate(t)[0],t>i.parameterPositions[1]&&(this.stopWarping(),0===e?this.paused=!0:this.timeScale=e)}}return this._effectiveTimeScale=e,e}_updateTime(t){const e=this._clip.duration,i=this.loop;let r=this.time+t,s=this._loopCount;const n=2202===i;if(0===t)return-1===s||!n||1&~s?r:e-r;if(2200===i){-1===s&&(this._loopCount=0,this._setEndings(!0,!0,!1));t:{if(r>=e)r=e;else{if(!(r<0)){this.time=r;break t}r=0}this.clampWhenFinished?this.paused=!0:this.enabled=!1,this.time=r,this._mixer.dispatchEvent({type:"finished",action:this,direction:t<0?-1:1})}}else{if(-1===s&&(t>=0?(s=0,this._setEndings(!0,0===this.repetitions,n)):this._setEndings(0===this.repetitions,!0,n)),r>=e||r<0){const i=Math.floor(r/e);r-=e*i,s+=Math.abs(i);const a=this.repetitions-s;if(a<=0)this.clampWhenFinished?this.paused=!0:this.enabled=!1,r=t>0?e:0,this.time=r,this._mixer.dispatchEvent({type:"finished",action:this,direction:t>0?1:-1});else{if(1===a){const e=t<0;this._setEndings(e,!e,n)}else this._setEndings(!1,!1,n);this._loopCount=s,this.time=r,this._mixer.dispatchEvent({type:"loop",action:this,loopDelta:i})}}else this.time=r;if(n&&!(1&~s))return e-r}return r}_setEndings(t,e,i){const r=this._interpolantSettings;i?(r.endingStart=2401,r.endingEnd=2401):(r.endingStart=t?this.zeroSlopeAtStart?2401:2400:2402,r.endingEnd=e?this.zeroSlopeAtEnd?2401:2400:2402)}_scheduleFading(t,e,i){const r=this._mixer,s=r.time;let n=this._weightInterpolant;null===n&&(n=r._lendControlInterpolant(),this._weightInterpolant=n);const a=n.parameterPositions,o=n.sampleValues;return a[0]=s,o[0]=e,a[1]=s+t,o[1]=i,this}}const _controlInterpolantsResultBuffer=new Float32Array(1);class AnimationMixer extends EventDispatcher{constructor(t){super(),this._root=t,this._initMemoryManager(),this._accuIndex=0,this.time=0,this.timeScale=1}_bindAction(t,e){const i=t._localRoot||this._root,r=t._clip.tracks,s=r.length,n=t._propertyBindings,a=t._interpolants,o=i.uuid,h=this._bindingsByRootAndName;let c=h[o];void 0===c&&(c={},h[o]=c);for(let t=0;t!==s;++t){const s=r[t],h=s.name;let l=c[h];if(void 0!==l)++l.referenceCount,n[t]=l;else{if(l=n[t],void 0!==l){null===l._cacheIndex&&(++l.referenceCount,this._addInactiveBinding(l,o,h));continue}const r=e&&e._propertyBindings[t].binding.parsedPath;l=new PropertyMixer(PropertyBinding.create(i,h,r),s.ValueTypeName,s.getValueSize()),++l.referenceCount,this._addInactiveBinding(l,o,h),n[t]=l}a[t].resultBuffer=l.buffer}}_activateAction(t){if(!this._isActiveAction(t)){if(null===t._cacheIndex){const e=(t._localRoot||this._root).uuid,i=t._clip.uuid,r=this._actionsByClip[i];this._bindAction(t,r&&r.knownActions[0]),this._addInactiveAction(t,i,e)}const e=t._propertyBindings;for(let t=0,i=e.length;t!==i;++t){const i=e[t];0==i.useCount++&&(this._lendBinding(i),i.saveOriginalState())}this._lendAction(t)}}_deactivateAction(t){if(this._isActiveAction(t)){const e=t._propertyBindings;for(let t=0,i=e.length;t!==i;++t){const i=e[t];0==--i.useCount&&(i.restoreOriginalState(),this._takeBackBinding(i))}this._takeBackAction(t)}}_initMemoryManager(){this._actions=[],this._nActiveActions=0,this._actionsByClip={},this._bindings=[],this._nActiveBindings=0,this._bindingsByRootAndName={},this._controlInterpolants=[],this._nActiveControlInterpolants=0;const t=this;this.stats={actions:{get total(){return t._actions.length},get inUse(){return t._nActiveActions}},bindings:{get total(){return t._bindings.length},get inUse(){return t._nActiveBindings}},controlInterpolants:{get total(){return t._controlInterpolants.length},get inUse(){return t._nActiveControlInterpolants}}}}_isActiveAction(t){const e=t._cacheIndex;return null!==e&&e<this._nActiveActions}_addInactiveAction(t,e,i){const r=this._actions,s=this._actionsByClip;let n=s[e];if(void 0===n)n={knownActions:[t],actionByRoot:{}},t._byClipCacheIndex=0,s[e]=n;else{const e=n.knownActions;t._byClipCacheIndex=e.length,e.push(t)}t._cacheIndex=r.length,r.push(t),n.actionByRoot[i]=t}_removeInactiveAction(t){const e=this._actions,i=e[e.length-1],r=t._cacheIndex;i._cacheIndex=r,e[r]=i,e.pop(),t._cacheIndex=null;const s=t._clip.uuid,n=this._actionsByClip,a=n[s],o=a.knownActions,h=o[o.length-1],c=t._byClipCacheIndex;h._byClipCacheIndex=c,o[c]=h,o.pop(),t._byClipCacheIndex=null;delete a.actionByRoot[(t._localRoot||this._root).uuid],0===o.length&&delete n[s],this._removeInactiveBindingsForAction(t)}_removeInactiveBindingsForAction(t){const e=t._propertyBindings;for(let t=0,i=e.length;t!==i;++t){const i=e[t];0==--i.referenceCount&&this._removeInactiveBinding(i)}}_lendAction(t){const e=this._actions,i=t._cacheIndex,r=this._nActiveActions++,s=e[r];t._cacheIndex=r,e[r]=t,s._cacheIndex=i,e[i]=s}_takeBackAction(t){const e=this._actions,i=t._cacheIndex,r=--this._nActiveActions,s=e[r];t._cacheIndex=r,e[r]=t,s._cacheIndex=i,e[i]=s}_addInactiveBinding(t,e,i){const r=this._bindingsByRootAndName,s=this._bindings;let n=r[e];void 0===n&&(n={},r[e]=n),n[i]=t,t._cacheIndex=s.length,s.push(t)}_removeInactiveBinding(t){const e=this._bindings,i=t.binding,r=i.rootNode.uuid,s=i.path,n=this._bindingsByRootAndName,a=n[r],o=e[e.length-1],h=t._cacheIndex;o._cacheIndex=h,e[h]=o,e.pop(),delete a[s],0===Object.keys(a).length&&delete n[r]}_lendBinding(t){const e=this._bindings,i=t._cacheIndex,r=this._nActiveBindings++,s=e[r];t._cacheIndex=r,e[r]=t,s._cacheIndex=i,e[i]=s}_takeBackBinding(t){const e=this._bindings,i=t._cacheIndex,r=--this._nActiveBindings,s=e[r];t._cacheIndex=r,e[r]=t,s._cacheIndex=i,e[i]=s}_lendControlInterpolant(){const t=this._controlInterpolants,e=this._nActiveControlInterpolants++;let i=t[e];return void 0===i&&(i=new LinearInterpolant(new Float32Array(2),new Float32Array(2),1,_controlInterpolantsResultBuffer),i.__cacheIndex=e,t[e]=i),i}_takeBackControlInterpolant(t){const e=this._controlInterpolants,i=t.__cacheIndex,r=--this._nActiveControlInterpolants,s=e[r];t.__cacheIndex=r,e[r]=t,s.__cacheIndex=i,e[i]=s}clipAction(t,e,i){const r=e||this._root,s=r.uuid;let n="string"==typeof t?AnimationClip.findByName(r,t):t;const a=null!==n?n.uuid:t,o=this._actionsByClip[a];let h=null;if(void 0===i&&(i=null!==n?n.blendMode:2500),void 0!==o){const t=o.actionByRoot[s];if(void 0!==t&&t.blendMode===i)return t;h=o.knownActions[0],null===n&&(n=h._clip)}if(null===n)return null;const c=new AnimationAction(this,n,e,i);return this._bindAction(c,h),this._addInactiveAction(c,a,s),c}existingAction(t,e){const i=e||this._root,r=i.uuid,s="string"==typeof t?AnimationClip.findByName(i,t):t,n=s?s.uuid:t,a=this._actionsByClip[n];return void 0!==a&&a.actionByRoot[r]||null}stopAllAction(){const t=this._actions;for(let e=this._nActiveActions-1;e>=0;--e)t[e].stop();return this}update(t){t*=this.timeScale;const e=this._actions,i=this._nActiveActions,r=this.time+=t,s=Math.sign(t),n=this._accuIndex^=1;for(let a=0;a!==i;++a){e[a]._update(r,t,s,n)}const a=this._bindings,o=this._nActiveBindings;for(let t=0;t!==o;++t)a[t].apply(n);return this}setTime(t){this.time=0;for(let t=0;t<this._actions.length;t++)this._actions[t].time=0;return this.update(t)}getRoot(){return this._root}uncacheClip(t){const e=this._actions,i=t.uuid,r=this._actionsByClip,s=r[i];if(void 0!==s){const t=s.knownActions;for(let i=0,r=t.length;i!==r;++i){const r=t[i];this._deactivateAction(r);const s=r._cacheIndex,n=e[e.length-1];r._cacheIndex=null,r._byClipCacheIndex=null,n._cacheIndex=s,e[s]=n,e.pop(),this._removeInactiveBindingsForAction(r)}delete r[i]}}uncacheRoot(t){const e=t.uuid,i=this._actionsByClip;for(const t in i){const r=i[t].actionByRoot[e];void 0!==r&&(this._deactivateAction(r),this._removeInactiveAction(r))}const r=this._bindingsByRootAndName[e];if(void 0!==r)for(const t in r){const e=r[t];e.restoreOriginalState(),this._removeInactiveBinding(e)}}uncacheAction(t,e){const i=this.existingAction(t,e);null!==i&&(this._deactivateAction(i),this._removeInactiveAction(i))}}class RenderTarget3D extends RenderTarget{constructor(t=1,e=1,i=1,r={}){super(t,e,r),this.isRenderTarget3D=!0,this.depth=i,this.texture=new Data3DTexture(null,t,e,i),this.texture.isRenderTargetTexture=!0}}class RenderTargetArray extends RenderTarget{constructor(t=1,e=1,i=1,r={}){super(t,e,r),this.isRenderTargetArray=!0,this.depth=i,this.texture=new DataArrayTexture(null,t,e,i),this.texture.isRenderTargetTexture=!0}}class Uniform{constructor(t){this.value=t}clone(){return new Uniform(void 0===this.value.clone?this.value:this.value.clone())}}let _id=0;class UniformsGroup extends EventDispatcher{constructor(){super(),this.isUniformsGroup=!0,Object.defineProperty(this,"id",{value:_id++}),this.name="",this.usage=35044,this.uniforms=[]}add(t){return this.uniforms.push(t),this}remove(t){const e=this.uniforms.indexOf(t);return-1!==e&&this.uniforms.splice(e,1),this}setName(t){return this.name=t,this}setUsage(t){return this.usage=t,this}dispose(){this.dispatchEvent({type:"dispose"})}copy(t){this.name=t.name,this.usage=t.usage;const e=t.uniforms;this.uniforms.length=0;for(let t=0,i=e.length;t<i;t++){const i=Array.isArray(e[t])?e[t]:[e[t]];for(let t=0;t<i.length;t++)this.uniforms.push(i[t].clone())}return this}clone(){return(new this.constructor).copy(this)}}class InstancedInterleavedBuffer extends InterleavedBuffer{constructor(t,e,i=1){super(t,e),this.isInstancedInterleavedBuffer=!0,this.meshPerAttribute=i}copy(t){return super.copy(t),this.meshPerAttribute=t.meshPerAttribute,this}clone(t){const e=super.clone(t);return e.meshPerAttribute=this.meshPerAttribute,e}toJSON(t){const e=super.toJSON(t);return e.isInstancedInterleavedBuffer=!0,e.meshPerAttribute=this.meshPerAttribute,e}}class GLBufferAttribute{constructor(t,e,i,r,s){this.isGLBufferAttribute=!0,this.name="",this.buffer=t,this.type=e,this.itemSize=i,this.elementSize=r,this.count=s,this.version=0}set needsUpdate(t){!0===t&&this.version++}setBuffer(t){return this.buffer=t,this}setType(t,e){return this.type=t,this.elementSize=e,this}setItemSize(t){return this.itemSize=t,this}setCount(t){return this.count=t,this}}const _matrix=new Matrix4;class Raycaster{constructor(t,e,i=0,r=1/0){this.ray=new Ray(t,e),this.near=i,this.far=r,this.camera=null,this.layers=new Layers,this.params={Mesh:{},Line:{threshold:1},LOD:{},Points:{threshold:1},Sprite:{}}}set(t,e){this.ray.set(t,e)}setFromCamera(t,e){e.isPerspectiveCamera?(this.ray.origin.setFromMatrixPosition(e.matrixWorld),this.ray.direction.set(t.x,t.y,.5).unproject(e).sub(this.ray.origin).normalize(),this.camera=e):e.isOrthographicCamera?(this.ray.origin.set(t.x,t.y,(e.near+e.far)/(e.near-e.far)).unproject(e),this.ray.direction.set(0,0,-1).transformDirection(e.matrixWorld),this.camera=e):console.error("THREE.Raycaster: Unsupported camera type: "+e.type)}setFromXRController(t){return _matrix.identity().extractRotation(t.matrixWorld),this.ray.origin.setFromMatrixPosition(t.matrixWorld),this.ray.direction.set(0,0,-1).applyMatrix4(_matrix),this}intersectObject(t,e=!0,i=[]){return intersect(t,this,i,e),i.sort(ascSort),i}intersectObjects(t,e=!0,i=[]){for(let r=0,s=t.length;r<s;r++)intersect(t[r],this,i,e);return i.sort(ascSort),i}}function ascSort(t,e){return t.distance-e.distance}function intersect(t,e,i,r){let s=!0;if(t.layers.test(e.layers)){!1===t.raycast(e,i)&&(s=!1)}if(!0===s&&!0===r){const r=t.children;for(let t=0,s=r.length;t<s;t++)intersect(r[t],e,i,!0)}}class Spherical{constructor(t=1,e=0,i=0){this.radius=t,this.phi=e,this.theta=i}set(t,e,i){return this.radius=t,this.phi=e,this.theta=i,this}copy(t){return this.radius=t.radius,this.phi=t.phi,this.theta=t.theta,this}makeSafe(){const t=1e-6;return this.phi=clamp(this.phi,t,Math.PI-t),this}setFromVector3(t){return this.setFromCartesianCoords(t.x,t.y,t.z)}setFromCartesianCoords(t,e,i){return this.radius=Math.sqrt(t*t+e*e+i*i),0===this.radius?(this.theta=0,this.phi=0):(this.theta=Math.atan2(t,i),this.phi=Math.acos(clamp(e/this.radius,-1,1))),this}clone(){return(new this.constructor).copy(this)}}class Cylindrical{constructor(t=1,e=0,i=0){this.radius=t,this.theta=e,this.y=i}set(t,e,i){return this.radius=t,this.theta=e,this.y=i,this}copy(t){return this.radius=t.radius,this.theta=t.theta,this.y=t.y,this}setFromVector3(t){return this.setFromCartesianCoords(t.x,t.y,t.z)}setFromCartesianCoords(t,e,i){return this.radius=Math.sqrt(t*t+i*i),this.theta=Math.atan2(t,i),this.y=e,this}clone(){return(new this.constructor).copy(this)}}class Matrix2{constructor(t,e,i,r){Matrix2.prototype.isMatrix2=!0,this.elements=[1,0,0,1],void 0!==t&&this.set(t,e,i,r)}identity(){return this.set(1,0,0,1),this}fromArray(t,e=0){for(let i=0;i<4;i++)this.elements[i]=t[i+e];return this}set(t,e,i,r){const s=this.elements;return s[0]=t,s[2]=e,s[1]=i,s[3]=r,this}}const _vector$4=new Vector2;class Box2{constructor(t=new Vector2(1/0,1/0),e=new Vector2(-1/0,-1/0)){this.isBox2=!0,this.min=t,this.max=e}set(t,e){return this.min.copy(t),this.max.copy(e),this}setFromPoints(t){this.makeEmpty();for(let e=0,i=t.length;e<i;e++)this.expandByPoint(t[e]);return this}setFromCenterAndSize(t,e){const i=_vector$4.copy(e).multiplyScalar(.5);return this.min.copy(t).sub(i),this.max.copy(t).add(i),this}clone(){return(new this.constructor).copy(this)}copy(t){return this.min.copy(t.min),this.max.copy(t.max),this}makeEmpty(){return this.min.x=this.min.y=1/0,this.max.x=this.max.y=-1/0,this}isEmpty(){return this.max.x<this.min.x||this.max.y<this.min.y}getCenter(t){return this.isEmpty()?t.set(0,0):t.addVectors(this.min,this.max).multiplyScalar(.5)}getSize(t){return this.isEmpty()?t.set(0,0):t.subVectors(this.max,this.min)}expandByPoint(t){return this.min.min(t),this.max.max(t),this}expandByVector(t){return this.min.sub(t),this.max.add(t),this}expandByScalar(t){return this.min.addScalar(-t),this.max.addScalar(t),this}containsPoint(t){return t.x>=this.min.x&&t.x<=this.max.x&&t.y>=this.min.y&&t.y<=this.max.y}containsBox(t){return this.min.x<=t.min.x&&t.max.x<=this.max.x&&this.min.y<=t.min.y&&t.max.y<=this.max.y}getParameter(t,e){return e.set((t.x-this.min.x)/(this.max.x-this.min.x),(t.y-this.min.y)/(this.max.y-this.min.y))}intersectsBox(t){return t.max.x>=this.min.x&&t.min.x<=this.max.x&&t.max.y>=this.min.y&&t.min.y<=this.max.y}clampPoint(t,e){return e.copy(t).clamp(this.min,this.max)}distanceToPoint(t){return this.clampPoint(t,_vector$4).distanceTo(t)}intersect(t){return this.min.max(t.min),this.max.min(t.max),this.isEmpty()&&this.makeEmpty(),this}union(t){return this.min.min(t.min),this.max.max(t.max),this}translate(t){return this.min.add(t),this.max.add(t),this}equals(t){return t.min.equals(this.min)&&t.max.equals(this.max)}}const _startP=new Vector3,_startEnd=new Vector3;class Line3{constructor(t=new Vector3,e=new Vector3){this.start=t,this.end=e}set(t,e){return this.start.copy(t),this.end.copy(e),this}copy(t){return this.start.copy(t.start),this.end.copy(t.end),this}getCenter(t){return t.addVectors(this.start,this.end).multiplyScalar(.5)}delta(t){return t.subVectors(this.end,this.start)}distanceSq(){return this.start.distanceToSquared(this.end)}distance(){return this.start.distanceTo(this.end)}at(t,e){return this.delta(e).multiplyScalar(t).add(this.start)}closestPointToPointParameter(t,e){_startP.subVectors(t,this.start),_startEnd.subVectors(this.end,this.start);const i=_startEnd.dot(_startEnd);let r=_startEnd.dot(_startP)/i;return e&&(r=clamp(r,0,1)),r}closestPointToPoint(t,e,i){const r=this.closestPointToPointParameter(t,e);return this.delta(i).multiplyScalar(r).add(this.start)}applyMatrix4(t){return this.start.applyMatrix4(t),this.end.applyMatrix4(t),this}equals(t){return t.start.equals(this.start)&&t.end.equals(this.end)}clone(){return(new this.constructor).copy(this)}}const _vector$3=new Vector3;class SpotLightHelper extends Object3D{constructor(t,e){super(),this.light=t,this.matrixAutoUpdate=!1,this.color=e,this.type="SpotLightHelper";const i=new BufferGeometry,r=[0,0,0,0,0,1,0,0,0,1,0,1,0,0,0,-1,0,1,0,0,0,0,1,1,0,0,0,0,-1,1];for(let t=0,e=1,i=32;t<i;t++,e++){const s=t/i*Math.PI*2,n=e/i*Math.PI*2;r.push(Math.cos(s),Math.sin(s),1,Math.cos(n),Math.sin(n),1)}i.setAttribute("position",new Float32BufferAttribute(r,3));const s=new LineBasicMaterial({fog:!1,toneMapped:!1});this.cone=new LineSegments(i,s),this.add(this.cone),this.update()}dispose(){this.cone.geometry.dispose(),this.cone.material.dispose()}update(){this.light.updateWorldMatrix(!0,!1),this.light.target.updateWorldMatrix(!0,!1),this.parent?(this.parent.updateWorldMatrix(!0),this.matrix.copy(this.parent.matrixWorld).invert().multiply(this.light.matrixWorld)):this.matrix.copy(this.light.matrixWorld),this.matrixWorld.copy(this.light.matrixWorld);const t=this.light.distance?this.light.distance:1e3,e=t*Math.tan(this.light.angle);this.cone.scale.set(e,e,t),_vector$3.setFromMatrixPosition(this.light.target.matrixWorld),this.cone.lookAt(_vector$3),void 0!==this.color?this.cone.material.color.set(this.color):this.cone.material.color.copy(this.light.color)}}const _vector$2=new Vector3,_boneMatrix=new Matrix4,_matrixWorldInv=new Matrix4;class SkeletonHelper extends LineSegments{constructor(t){const e=getBoneList(t),i=new BufferGeometry,r=[],s=[],n=new Color(0,0,1),a=new Color(0,1,0);for(let t=0;t<e.length;t++){const i=e[t];i.parent&&i.parent.isBone&&(r.push(0,0,0),r.push(0,0,0),s.push(n.r,n.g,n.b),s.push(a.r,a.g,a.b))}i.setAttribute("position",new Float32BufferAttribute(r,3)),i.setAttribute("color",new Float32BufferAttribute(s,3));super(i,new LineBasicMaterial({vertexColors:!0,depthTest:!1,depthWrite:!1,toneMapped:!1,transparent:!0})),this.isSkeletonHelper=!0,this.type="SkeletonHelper",this.root=t,this.bones=e,this.matrix=t.matrixWorld,this.matrixAutoUpdate=!1}updateMatrixWorld(t){const e=this.bones,i=this.geometry,r=i.getAttribute("position");_matrixWorldInv.copy(this.root.matrixWorld).invert();for(let t=0,i=0;t<e.length;t++){const s=e[t];s.parent&&s.parent.isBone&&(_boneMatrix.multiplyMatrices(_matrixWorldInv,s.matrixWorld),_vector$2.setFromMatrixPosition(_boneMatrix),r.setXYZ(i,_vector$2.x,_vector$2.y,_vector$2.z),_boneMatrix.multiplyMatrices(_matrixWorldInv,s.parent.matrixWorld),_vector$2.setFromMatrixPosition(_boneMatrix),r.setXYZ(i+1,_vector$2.x,_vector$2.y,_vector$2.z),i+=2)}i.getAttribute("position").needsUpdate=!0,super.updateMatrixWorld(t)}dispose(){this.geometry.dispose(),this.material.dispose()}}function getBoneList(t){const e=[];!0===t.isBone&&e.push(t);for(let i=0;i<t.children.length;i++)e.push(...getBoneList(t.children[i]));return e}class PointLightHelper extends Mesh{constructor(t,e,i){super(new SphereGeometry(e,4,2),new MeshBasicMaterial({wireframe:!0,fog:!1,toneMapped:!1})),this.light=t,this.color=i,this.type="PointLightHelper",this.matrix=this.light.matrixWorld,this.matrixAutoUpdate=!1,this.update()}dispose(){this.geometry.dispose(),this.material.dispose()}update(){this.light.updateWorldMatrix(!0,!1),void 0!==this.color?this.material.color.set(this.color):this.material.color.copy(this.light.color)}}const _vector$1=new Vector3,_color1=new Color,_color2=new Color;class HemisphereLightHelper extends Object3D{constructor(t,e,i){super(),this.light=t,this.matrix=t.matrixWorld,this.matrixAutoUpdate=!1,this.color=i,this.type="HemisphereLightHelper";const r=new OctahedronGeometry(e);r.rotateY(.5*Math.PI),this.material=new MeshBasicMaterial({wireframe:!0,fog:!1,toneMapped:!1}),void 0===this.color&&(this.material.vertexColors=!0);const s=r.getAttribute("position"),n=new Float32Array(3*s.count);r.setAttribute("color",new BufferAttribute(n,3)),this.add(new Mesh(r,this.material)),this.update()}dispose(){this.children[0].geometry.dispose(),this.children[0].material.dispose()}update(){const t=this.children[0];if(void 0!==this.color)this.material.color.set(this.color);else{const e=t.geometry.getAttribute("color");_color1.copy(this.light.color),_color2.copy(this.light.groundColor);for(let t=0,i=e.count;t<i;t++){const r=t<i/2?_color1:_color2;e.setXYZ(t,r.r,r.g,r.b)}e.needsUpdate=!0}this.light.updateWorldMatrix(!0,!1),t.lookAt(_vector$1.setFromMatrixPosition(this.light.matrixWorld).negate())}}class GridHelper extends LineSegments{constructor(t=10,e=10,i=4473924,r=8947848){i=new Color(i),r=new Color(r);const s=e/2,n=t/e,a=t/2,o=[],h=[];for(let t=0,c=0,l=-a;t<=e;t++,l+=n){o.push(-a,0,l,a,0,l),o.push(l,0,-a,l,0,a);const e=t===s?i:r;e.toArray(h,c),c+=3,e.toArray(h,c),c+=3,e.toArray(h,c),c+=3,e.toArray(h,c),c+=3}const c=new BufferGeometry;c.setAttribute("position",new Float32BufferAttribute(o,3)),c.setAttribute("color",new Float32BufferAttribute(h,3));super(c,new LineBasicMaterial({vertexColors:!0,toneMapped:!1})),this.type="GridHelper"}dispose(){this.geometry.dispose(),this.material.dispose()}}class PolarGridHelper extends LineSegments{constructor(t=10,e=16,i=8,r=64,s=4473924,n=8947848){s=new Color(s),n=new Color(n);const a=[],o=[];if(e>1)for(let i=0;i<e;i++){const r=i/e*(2*Math.PI),h=Math.sin(r)*t,c=Math.cos(r)*t;a.push(0,0,0),a.push(h,0,c);const l=1&i?s:n;o.push(l.r,l.g,l.b),o.push(l.r,l.g,l.b)}for(let e=0;e<i;e++){const h=1&e?s:n,c=t-t/i*e;for(let t=0;t<r;t++){let e=t/r*(2*Math.PI),i=Math.sin(e)*c,s=Math.cos(e)*c;a.push(i,0,s),o.push(h.r,h.g,h.b),e=(t+1)/r*(2*Math.PI),i=Math.sin(e)*c,s=Math.cos(e)*c,a.push(i,0,s),o.push(h.r,h.g,h.b)}}const h=new BufferGeometry;h.setAttribute("position",new Float32BufferAttribute(a,3)),h.setAttribute("color",new Float32BufferAttribute(o,3));super(h,new LineBasicMaterial({vertexColors:!0,toneMapped:!1})),this.type="PolarGridHelper"}dispose(){this.geometry.dispose(),this.material.dispose()}}const _v1=new Vector3,_v2=new Vector3,_v3=new Vector3;class DirectionalLightHelper extends Object3D{constructor(t,e,i){super(),this.light=t,this.matrix=t.matrixWorld,this.matrixAutoUpdate=!1,this.color=i,this.type="DirectionalLightHelper",void 0===e&&(e=1);let r=new BufferGeometry;r.setAttribute("position",new Float32BufferAttribute([-e,e,0,e,e,0,e,-e,0,-e,-e,0,-e,e,0],3));const s=new LineBasicMaterial({fog:!1,toneMapped:!1});this.lightPlane=new Line(r,s),this.add(this.lightPlane),r=new BufferGeometry,r.setAttribute("position",new Float32BufferAttribute([0,0,0,0,0,1],3)),this.targetLine=new Line(r,s),this.add(this.targetLine),this.update()}dispose(){this.lightPlane.geometry.dispose(),this.lightPlane.material.dispose(),this.targetLine.geometry.dispose(),this.targetLine.material.dispose()}update(){this.light.updateWorldMatrix(!0,!1),this.light.target.updateWorldMatrix(!0,!1),_v1.setFromMatrixPosition(this.light.matrixWorld),_v2.setFromMatrixPosition(this.light.target.matrixWorld),_v3.subVectors(_v2,_v1),this.lightPlane.lookAt(_v2),void 0!==this.color?(this.lightPlane.material.color.set(this.color),this.targetLine.material.color.set(this.color)):(this.lightPlane.material.color.copy(this.light.color),this.targetLine.material.color.copy(this.light.color)),this.targetLine.lookAt(_v2),this.targetLine.scale.z=_v3.length()}}const _vector=new Vector3,_camera=new Camera;class CameraHelper extends LineSegments{constructor(t){const e=new BufferGeometry,i=new LineBasicMaterial({color:16777215,vertexColors:!0,toneMapped:!1}),r=[],s=[],n={};function a(t,e){o(t),o(e)}function o(t){r.push(0,0,0),s.push(0,0,0),void 0===n[t]&&(n[t]=[]),n[t].push(r.length/3-1)}a("n1","n2"),a("n2","n4"),a("n4","n3"),a("n3","n1"),a("f1","f2"),a("f2","f4"),a("f4","f3"),a("f3","f1"),a("n1","f1"),a("n2","f2"),a("n3","f3"),a("n4","f4"),a("p","n1"),a("p","n2"),a("p","n3"),a("p","n4"),a("u1","u2"),a("u2","u3"),a("u3","u1"),a("c","t"),a("p","c"),a("cn1","cn2"),a("cn3","cn4"),a("cf1","cf2"),a("cf3","cf4"),e.setAttribute("position",new Float32BufferAttribute(r,3)),e.setAttribute("color",new Float32BufferAttribute(s,3)),super(e,i),this.type="CameraHelper",this.camera=t,this.camera.updateProjectionMatrix&&this.camera.updateProjectionMatrix(),this.matrix=t.matrixWorld,this.matrixAutoUpdate=!1,this.pointMap=n,this.update();const h=new Color(16755200),c=new Color(16711680),l=new Color(43775),u=new Color(16777215),p=new Color(3355443);this.setColors(h,c,l,u,p)}setColors(t,e,i,r,s){const n=this.geometry.getAttribute("color");n.setXYZ(0,t.r,t.g,t.b),n.setXYZ(1,t.r,t.g,t.b),n.setXYZ(2,t.r,t.g,t.b),n.setXYZ(3,t.r,t.g,t.b),n.setXYZ(4,t.r,t.g,t.b),n.setXYZ(5,t.r,t.g,t.b),n.setXYZ(6,t.r,t.g,t.b),n.setXYZ(7,t.r,t.g,t.b),n.setXYZ(8,t.r,t.g,t.b),n.setXYZ(9,t.r,t.g,t.b),n.setXYZ(10,t.r,t.g,t.b),n.setXYZ(11,t.r,t.g,t.b),n.setXYZ(12,t.r,t.g,t.b),n.setXYZ(13,t.r,t.g,t.b),n.setXYZ(14,t.r,t.g,t.b),n.setXYZ(15,t.r,t.g,t.b),n.setXYZ(16,t.r,t.g,t.b),n.setXYZ(17,t.r,t.g,t.b),n.setXYZ(18,t.r,t.g,t.b),n.setXYZ(19,t.r,t.g,t.b),n.setXYZ(20,t.r,t.g,t.b),n.setXYZ(21,t.r,t.g,t.b),n.setXYZ(22,t.r,t.g,t.b),n.setXYZ(23,t.r,t.g,t.b),n.setXYZ(24,e.r,e.g,e.b),n.setXYZ(25,e.r,e.g,e.b),n.setXYZ(26,e.r,e.g,e.b),n.setXYZ(27,e.r,e.g,e.b),n.setXYZ(28,e.r,e.g,e.b),n.setXYZ(29,e.r,e.g,e.b),n.setXYZ(30,e.r,e.g,e.b),n.setXYZ(31,e.r,e.g,e.b),n.setXYZ(32,i.r,i.g,i.b),n.setXYZ(33,i.r,i.g,i.b),n.setXYZ(34,i.r,i.g,i.b),n.setXYZ(35,i.r,i.g,i.b),n.setXYZ(36,i.r,i.g,i.b),n.setXYZ(37,i.r,i.g,i.b),n.setXYZ(38,r.r,r.g,r.b),n.setXYZ(39,r.r,r.g,r.b),n.setXYZ(40,s.r,s.g,s.b),n.setXYZ(41,s.r,s.g,s.b),n.setXYZ(42,s.r,s.g,s.b),n.setXYZ(43,s.r,s.g,s.b),n.setXYZ(44,s.r,s.g,s.b),n.setXYZ(45,s.r,s.g,s.b),n.setXYZ(46,s.r,s.g,s.b),n.setXYZ(47,s.r,s.g,s.b),n.setXYZ(48,s.r,s.g,s.b),n.setXYZ(49,s.r,s.g,s.b),n.needsUpdate=!0}update(){const t=this.geometry,e=this.pointMap;_camera.projectionMatrixInverse.copy(this.camera.projectionMatrixInverse);const i=2e3===this.camera.coordinateSystem?-1:0;setPoint("c",e,t,_camera,0,0,i),setPoint("t",e,t,_camera,0,0,1),setPoint("n1",e,t,_camera,-1,-1,i),setPoint("n2",e,t,_camera,1,-1,i),setPoint("n3",e,t,_camera,-1,1,i),setPoint("n4",e,t,_camera,1,1,i),setPoint("f1",e,t,_camera,-1,-1,1),setPoint("f2",e,t,_camera,1,-1,1),setPoint("f3",e,t,_camera,-1,1,1),setPoint("f4",e,t,_camera,1,1,1),setPoint("u1",e,t,_camera,.7,1.1,i),setPoint("u2",e,t,_camera,-.7,1.1,i),setPoint("u3",e,t,_camera,0,2,i),setPoint("cf1",e,t,_camera,-1,0,1),setPoint("cf2",e,t,_camera,1,0,1),setPoint("cf3",e,t,_camera,0,-1,1),setPoint("cf4",e,t,_camera,0,1,1),setPoint("cn1",e,t,_camera,-1,0,i),setPoint("cn2",e,t,_camera,1,0,i),setPoint("cn3",e,t,_camera,0,-1,i),setPoint("cn4",e,t,_camera,0,1,i),t.getAttribute("position").needsUpdate=!0}dispose(){this.geometry.dispose(),this.material.dispose()}}function setPoint(t,e,i,r,s,n,a){_vector.set(s,n,a).unproject(r);const o=e[t];if(void 0!==o){const t=i.getAttribute("position");for(let e=0,i=o.length;e<i;e++)t.setXYZ(o[e],_vector.x,_vector.y,_vector.z)}}const _box=new Box3;class BoxHelper extends LineSegments{constructor(t,e=16776960){const i=new Uint16Array([0,1,1,2,2,3,3,0,4,5,5,6,6,7,7,4,0,4,1,5,2,6,3,7]),r=new Float32Array(24),s=new BufferGeometry;s.setIndex(new BufferAttribute(i,1)),s.setAttribute("position",new BufferAttribute(r,3)),super(s,new LineBasicMaterial({color:e,toneMapped:!1})),this.object=t,this.type="BoxHelper",this.matrixAutoUpdate=!1,this.update()}update(){if(void 0!==this.object&&_box.setFromObject(this.object),_box.isEmpty())return;const t=_box.min,e=_box.max,i=this.geometry.attributes.position,r=i.array;r[0]=e.x,r[1]=e.y,r[2]=e.z,r[3]=t.x,r[4]=e.y,r[5]=e.z,r[6]=t.x,r[7]=t.y,r[8]=e.z,r[9]=e.x,r[10]=t.y,r[11]=e.z,r[12]=e.x,r[13]=e.y,r[14]=t.z,r[15]=t.x,r[16]=e.y,r[17]=t.z,r[18]=t.x,r[19]=t.y,r[20]=t.z,r[21]=e.x,r[22]=t.y,r[23]=t.z,i.needsUpdate=!0,this.geometry.computeBoundingSphere()}setFromObject(t){return this.object=t,this.update(),this}copy(t,e){return super.copy(t,e),this.object=t.object,this}dispose(){this.geometry.dispose(),this.material.dispose()}}class Box3Helper extends LineSegments{constructor(t,e=16776960){const i=new Uint16Array([0,1,1,2,2,3,3,0,4,5,5,6,6,7,7,4,0,4,1,5,2,6,3,7]),r=new BufferGeometry;r.setIndex(new BufferAttribute(i,1)),r.setAttribute("position",new Float32BufferAttribute([1,1,1,-1,1,1,-1,-1,1,1,-1,1,1,1,-1,-1,1,-1,-1,-1,-1,1,-1,-1],3)),super(r,new LineBasicMaterial({color:e,toneMapped:!1})),this.box=t,this.type="Box3Helper",this.geometry.computeBoundingSphere()}updateMatrixWorld(t){const e=this.box;e.isEmpty()||(e.getCenter(this.position),e.getSize(this.scale),this.scale.multiplyScalar(.5),super.updateMatrixWorld(t))}dispose(){this.geometry.dispose(),this.material.dispose()}}class PlaneHelper extends Line{constructor(t,e=1,i=16776960){const r=i,s=new BufferGeometry;s.setAttribute("position",new Float32BufferAttribute([1,-1,0,-1,1,0,-1,-1,0,1,1,0,-1,1,0,-1,-1,0,1,-1,0,1,1,0],3)),s.computeBoundingSphere(),super(s,new LineBasicMaterial({color:r,toneMapped:!1})),this.type="PlaneHelper",this.plane=t,this.size=e;const n=new BufferGeometry;n.setAttribute("position",new Float32BufferAttribute([1,1,0,-1,1,0,-1,-1,0,1,1,0,-1,-1,0,1,-1,0],3)),n.computeBoundingSphere(),this.add(new Mesh(n,new MeshBasicMaterial({color:r,opacity:.2,transparent:!0,depthWrite:!1,toneMapped:!1})))}updateMatrixWorld(t){this.position.set(0,0,0),this.scale.set(.5*this.size,.5*this.size,1),this.lookAt(this.plane.normal),this.translateZ(-this.plane.constant),super.updateMatrixWorld(t)}dispose(){this.geometry.dispose(),this.material.dispose(),this.children[0].geometry.dispose(),this.children[0].material.dispose()}}const _axis=new Vector3;let _lineGeometry,_coneGeometry;class ArrowHelper extends Object3D{constructor(t=new Vector3(0,0,1),e=new Vector3(0,0,0),i=1,r=16776960,s=.2*i,n=.2*s){super(),this.type="ArrowHelper",void 0===_lineGeometry&&(_lineGeometry=new BufferGeometry,_lineGeometry.setAttribute("position",new Float32BufferAttribute([0,0,0,0,1,0],3)),_coneGeometry=new ConeGeometry(.5,1,5,1),_coneGeometry.translate(0,-.5,0)),this.position.copy(e),this.line=new Line(_lineGeometry,new LineBasicMaterial({color:r,toneMapped:!1})),this.line.matrixAutoUpdate=!1,this.add(this.line),this.cone=new Mesh(_coneGeometry,new MeshBasicMaterial({color:r,toneMapped:!1})),this.cone.matrixAutoUpdate=!1,this.add(this.cone),this.setDirection(t),this.setLength(i,s,n)}setDirection(t){if(t.y>.99999)this.quaternion.set(0,0,0,1);else if(t.y<-.99999)this.quaternion.set(1,0,0,0);else{_axis.set(t.z,0,-t.x).normalize();const e=Math.acos(t.y);this.quaternion.setFromAxisAngle(_axis,e)}}setLength(t,e=.2*t,i=.2*e){this.line.scale.set(1,Math.max(1e-4,t-e),1),this.line.updateMatrix(),this.cone.scale.set(i,e,i),this.cone.position.y=t,this.cone.updateMatrix()}setColor(t){this.line.material.color.set(t),this.cone.material.color.set(t)}copy(t){return super.copy(t,!1),this.line.copy(t.line),this.cone.copy(t.cone),this}dispose(){this.line.geometry.dispose(),this.line.material.dispose(),this.cone.geometry.dispose(),this.cone.material.dispose()}}class AxesHelper extends LineSegments{constructor(t=1){const e=[0,0,0,t,0,0,0,0,0,0,t,0,0,0,0,0,0,t],i=new BufferGeometry;i.setAttribute("position",new Float32BufferAttribute(e,3)),i.setAttribute("color",new Float32BufferAttribute([1,0,0,1,.6,0,0,1,0,.6,1,0,0,0,1,0,.6,1],3));super(i,new LineBasicMaterial({vertexColors:!0,toneMapped:!1})),this.type="AxesHelper"}setColors(t,e,i){const r=new Color,s=this.geometry.attributes.color.array;return r.set(t),r.toArray(s,0),r.toArray(s,3),r.set(e),r.toArray(s,6),r.toArray(s,9),r.set(i),r.toArray(s,12),r.toArray(s,15),this.geometry.attributes.color.needsUpdate=!0,this}dispose(){this.geometry.dispose(),this.material.dispose()}}class ShapePath{constructor(){this.type="ShapePath",this.color=new Color,this.subPaths=[],this.currentPath=null}moveTo(t,e){return this.currentPath=new Path,this.subPaths.push(this.currentPath),this.currentPath.moveTo(t,e),this}lineTo(t,e){return this.currentPath.lineTo(t,e),this}quadraticCurveTo(t,e,i,r){return this.currentPath.quadraticCurveTo(t,e,i,r),this}bezierCurveTo(t,e,i,r,s,n){return this.currentPath.bezierCurveTo(t,e,i,r,s,n),this}splineThru(t){return this.currentPath.splineThru(t),this}toShapes(t){function e(t,e){const i=e.length;let r=!1;for(let s=i-1,n=0;n<i;s=n++){let i=e[s],a=e[n],o=a.x-i.x,h=a.y-i.y;if(Math.abs(h)>Number.EPSILON){if(h<0&&(i=e[n],o=-o,a=e[s],h=-h),t.y<i.y||t.y>a.y)continue;if(t.y===i.y){if(t.x===i.x)return!0}else{const e=h*(t.x-i.x)-o*(t.y-i.y);if(0===e)return!0;if(e<0)continue;r=!r}}else{if(t.y!==i.y)continue;if(a.x<=t.x&&t.x<=i.x||i.x<=t.x&&t.x<=a.x)return!0}}return r}const i=ShapeUtils.isClockWise,r=this.subPaths;if(0===r.length)return[];let s,n,a;const o=[];if(1===r.length)return n=r[0],a=new Shape,a.curves=n.curves,o.push(a),o;let h=!i(r[0].getPoints());h=t?!h:h;const c=[],l=[];let u,p,d=[],m=0;l[m]=void 0,d[m]=[];for(let e=0,a=r.length;e<a;e++)n=r[e],u=n.getPoints(),s=i(u),s=t?!s:s,s?(!h&&l[m]&&m++,l[m]={s:new Shape,p:u},l[m].s.curves=n.curves,h&&m++,d[m]=[]):d[m].push({h:n,p:u[0]});if(!l[0])return function(t){const e=[];for(let i=0,r=t.length;i<r;i++){const r=t[i],s=new Shape;s.curves=r.curves,e.push(s)}return e}(r);if(l.length>1){let t=!1,i=0;for(let t=0,e=l.length;t<e;t++)c[t]=[];for(let r=0,s=l.length;r<s;r++){const s=d[r];for(let n=0;n<s.length;n++){const a=s[n];let o=!0;for(let s=0;s<l.length;s++)e(a.p,l[s].p)&&(r!==s&&i++,o?(o=!1,c[s].push(a)):t=!0);o&&c[r].push(a)}}i>0&&!1===t&&(d=c)}for(let t=0,e=l.length;t<e;t++){a=l[t].s,o.push(a),p=d[t];for(let t=0,e=p.length;t<e;t++)a.holes.push(p[t].h)}return o}}class Controls extends EventDispatcher{constructor(t,e=null){super(),this.object=t,this.domElement=e,this.enabled=!0,this.state=-1,this.keys={},this.mouseButtons={LEFT:null,MIDDLE:null,RIGHT:null},this.touches={ONE:null,TWO:null}}connect(t){void 0!==t?(null!==this.domElement&&this.disconnect(),this.domElement=t):console.warn("THREE.Controls: connect() now requires an element.")}disconnect(){}dispose(){}update(){}}function contain(t,e){const i=t.image&&t.image.width?t.image.width/t.image.height:1;return i>e?(t.repeat.x=1,t.repeat.y=i/e,t.offset.x=0,t.offset.y=(1-t.repeat.y)/2):(t.repeat.x=e/i,t.repeat.y=1,t.offset.x=(1-t.repeat.x)/2,t.offset.y=0),t}function cover(t,e){const i=t.image&&t.image.width?t.image.width/t.image.height:1;return i>e?(t.repeat.x=e/i,t.repeat.y=1,t.offset.x=(1-t.repeat.x)/2,t.offset.y=0):(t.repeat.x=1,t.repeat.y=i/e,t.offset.x=0,t.offset.y=(1-t.repeat.y)/2),t}function fill(t){return t.repeat.x=1,t.repeat.y=1,t.offset.x=0,t.offset.y=0,t}function getByteLength(t,e,i,r){const s=getTextureTypeByteLength(r);switch(i){case 1021:return t*e;case 1028:case 1029:return t*e/s.components*s.byteLength;case 1030:case 1031:return t*e*2/s.components*s.byteLength;case 1022:return t*e*3/s.components*s.byteLength;case 1023:case 1033:return t*e*4/s.components*s.byteLength;case 33776:case 33777:case 36196:case 37492:return Math.floor((t+3)/4)*Math.floor((e+3)/4)*8;case 33778:case 33779:case 37496:case 37808:return Math.floor((t+3)/4)*Math.floor((e+3)/4)*16;case 35841:case 35843:return Math.max(t,16)*Math.max(e,8)/4;case 35840:case 35842:return Math.max(t,8)*Math.max(e,8)/2;case 37809:return Math.floor((t+4)/5)*Math.floor((e+3)/4)*16;case 37810:return Math.floor((t+4)/5)*Math.floor((e+4)/5)*16;case 37811:return Math.floor((t+5)/6)*Math.floor((e+4)/5)*16;case 37812:return Math.floor((t+5)/6)*Math.floor((e+5)/6)*16;case 37813:return Math.floor((t+7)/8)*Math.floor((e+4)/5)*16;case 37814:return Math.floor((t+7)/8)*Math.floor((e+5)/6)*16;case 37815:return Math.floor((t+7)/8)*Math.floor((e+7)/8)*16;case 37816:return Math.floor((t+9)/10)*Math.floor((e+4)/5)*16;case 37817:return Math.floor((t+9)/10)*Math.floor((e+5)/6)*16;case 37818:return Math.floor((t+9)/10)*Math.floor((e+7)/8)*16;case 37819:return Math.floor((t+9)/10)*Math.floor((e+9)/10)*16;case 37820:return Math.floor((t+11)/12)*Math.floor((e+9)/10)*16;case 37821:return Math.floor((t+11)/12)*Math.floor((e+11)/12)*16;case 36492:case 36494:case 36495:case 36285:case 36286:return Math.ceil(t/4)*Math.ceil(e/4)*16;case 36283:case 36284:return Math.ceil(t/4)*Math.ceil(e/4)*8}throw new Error(`Unable to determine texture byte length for ${i} format.`)}function getTextureTypeByteLength(t){switch(t){case 1009:case 1010:return{byteLength:1,components:1};case 1012:case 1011:case 1016:return{byteLength:2,components:1};case 1017:case 1018:return{byteLength:2,components:4};case 1014:case 1013:case 1015:return{byteLength:4,components:1};case 35902:return{byteLength:4,components:3}}throw new Error(`Unknown texture type ${t}.`)}class TextureUtils{static contain(t,e){return contain(t,e)}static cover(t,e){return cover(t,e)}static fill(t){return fill(t)}static getByteLength(t,e,i,r){return getByteLength(t,e,i,r)}}"undefined"!=typeof __THREE_DEVTOOLS__&&__THREE_DEVTOOLS__.dispatchEvent(new CustomEvent("register",{detail:{revision:"176"}})),"undefined"!=typeof window&&(window.__THREE__?console.warn("WARNING: Multiple instances of Three.js being imported."):window.__THREE__="176");export{ACESFilmicToneMapping,AddEquation,AddOperation,AdditiveAnimationBlendMode,AdditiveBlending,AgXToneMapping,AlphaFormat,AlwaysCompare,AlwaysDepth,AlwaysStencilFunc,AmbientLight,AnimationAction,AnimationClip,AnimationLoader,AnimationMixer,AnimationObjectGroup,AnimationUtils,ArcCurve,ArrayCamera,ArrowHelper,AttachedBindMode,Audio,AudioAnalyser,AudioContext,AudioListener,AudioLoader,AxesHelper,BackSide,BasicDepthPacking,BasicShadowMap,BatchedMesh,Bone,BooleanKeyframeTrack,Box2,Box3,Box3Helper,BoxGeometry,BoxHelper,BufferAttribute,BufferGeometry,BufferGeometryLoader,ByteType,Cache,Camera,CameraHelper,CanvasTexture,CapsuleGeometry,CatmullRomCurve3,CineonToneMapping,CircleGeometry,ClampToEdgeWrapping,Clock,Color,ColorKeyframeTrack,ColorManagement,CompressedArrayTexture,CompressedCubeTexture,CompressedTexture,CompressedTextureLoader,ConeGeometry,ConstantAlphaFactor,ConstantColorFactor,Controls,CubeCamera,CubeReflectionMapping,CubeRefractionMapping,CubeTexture,CubeTextureLoader,CubeUVReflectionMapping,CubicBezierCurve,CubicBezierCurve3,CubicInterpolant,CullFaceBack,CullFaceFront,CullFaceFrontBack,CullFaceNone,Curve,CurvePath,CustomBlending,CustomToneMapping,CylinderGeometry,Cylindrical,Data3DTexture,DataArrayTexture,DataTexture,DataTextureLoader,DataUtils,DecrementStencilOp,DecrementWrapStencilOp,DefaultLoadingManager,DepthArrayTexture,DepthFormat,DepthStencilFormat,DepthTexture,DetachedBindMode,DirectionalLight,DirectionalLightHelper,DiscreteInterpolant,DodecahedronGeometry,DoubleSide,DstAlphaFactor,DstColorFactor,DynamicCopyUsage,DynamicDrawUsage,DynamicReadUsage,EdgesGeometry,EllipseCurve,EqualCompare,EqualDepth,EqualStencilFunc,EquirectangularReflectionMapping,EquirectangularRefractionMapping,Euler,EventDispatcher,ExtrudeGeometry,FileLoader,Float16BufferAttribute,Float32BufferAttribute,FloatType,Fog,FogExp2,FramebufferTexture,FrontSide,Frustum,FrustumArray,GLBufferAttribute,GLSL1,GLSL3,GreaterCompare,GreaterDepth,GreaterEqualCompare,GreaterEqualDepth,GreaterEqualStencilFunc,GreaterStencilFunc,GridHelper,Group,HalfFloatType,HemisphereLight,HemisphereLightHelper,IcosahedronGeometry,ImageBitmapLoader,ImageLoader,ImageUtils,IncrementStencilOp,IncrementWrapStencilOp,InstancedBufferAttribute,InstancedBufferGeometry,InstancedInterleavedBuffer,InstancedMesh,Int16BufferAttribute,Int32BufferAttribute,Int8BufferAttribute,IntType,InterleavedBuffer,InterleavedBufferAttribute,Interpolant,InterpolateDiscrete,InterpolateLinear,InterpolateSmooth,InterpolationSamplingMode,InterpolationSamplingType,InvertStencilOp,KeepStencilOp,KeyframeTrack,LOD,LatheGeometry,Layers,LessCompare,LessDepth,LessEqualCompare,LessEqualDepth,LessEqualStencilFunc,LessStencilFunc,Light,LightProbe,Line,Line3,LineBasicMaterial,LineCurve,LineCurve3,LineDashedMaterial,LineLoop,LineSegments,LinearFilter,LinearInterpolant,LinearMipMapLinearFilter,LinearMipMapNearestFilter,LinearMipmapLinearFilter,LinearMipmapNearestFilter,LinearSRGBColorSpace,LinearToneMapping,LinearTransfer,Loader,LoaderUtils,LoadingManager,LoopOnce,LoopPingPong,LoopRepeat,MOUSE,Material,MaterialLoader,MathUtils,Matrix2,Matrix3,Matrix4,MaxEquation,Mesh,MeshBasicMaterial,MeshDepthMaterial,MeshDistanceMaterial,MeshLambertMaterial,MeshMatcapMaterial,MeshNormalMaterial,MeshPhongMaterial,MeshPhysicalMaterial,MeshStandardMaterial,MeshToonMaterial,MinEquation,MirroredRepeatWrapping,MixOperation,MultiplyBlending,MultiplyOperation,NearestFilter,NearestMipMapLinearFilter,NearestMipMapNearestFilter,NearestMipmapLinearFilter,NearestMipmapNearestFilter,NeutralToneMapping,NeverCompare,NeverDepth,NeverStencilFunc,NoBlending,NoColorSpace,NoToneMapping,NormalAnimationBlendMode,NormalBlending,NotEqualCompare,NotEqualDepth,NotEqualStencilFunc,NumberKeyframeTrack,Object3D,ObjectLoader,ObjectSpaceNormalMap,OctahedronGeometry,OneFactor,OneMinusConstantAlphaFactor,OneMinusConstantColorFactor,OneMinusDstAlphaFactor,OneMinusDstColorFactor,OneMinusSrcAlphaFactor,OneMinusSrcColorFactor,OrthographicCamera,PCFShadowMap,PCFSoftShadowMap,Path,PerspectiveCamera,Plane,PlaneGeometry,PlaneHelper,PointLight,PointLightHelper,Points,PointsMaterial,PolarGridHelper,PolyhedronGeometry,PositionalAudio,PropertyBinding,PropertyMixer,QuadraticBezierCurve,QuadraticBezierCurve3,Quaternion,QuaternionKeyframeTrack,QuaternionLinearInterpolant,RAD2DEG,RED_GREEN_RGTC2_Format,RED_RGTC1_Format,REVISION,RGBADepthPacking,RGBAFormat,RGBAIntegerFormat,RGBA_ASTC_10x10_Format,RGBA_ASTC_10x5_Format,RGBA_ASTC_10x6_Format,RGBA_ASTC_10x8_Format,RGBA_ASTC_12x10_Format,RGBA_ASTC_12x12_Format,RGBA_ASTC_4x4_Format,RGBA_ASTC_5x4_Format,RGBA_ASTC_5x5_Format,RGBA_ASTC_6x5_Format,RGBA_ASTC_6x6_Format,RGBA_ASTC_8x5_Format,RGBA_ASTC_8x6_Format,RGBA_ASTC_8x8_Format,RGBA_BPTC_Format,RGBA_ETC2_EAC_Format,RGBA_PVRTC_2BPPV1_Format,RGBA_PVRTC_4BPPV1_Format,RGBA_S3TC_DXT1_Format,RGBA_S3TC_DXT3_Format,RGBA_S3TC_DXT5_Format,RGBDepthPacking,RGBFormat,RGBIntegerFormat,RGB_BPTC_SIGNED_Format,RGB_BPTC_UNSIGNED_Format,RGB_ETC1_Format,RGB_ETC2_Format,RGB_PVRTC_2BPPV1_Format,RGB_PVRTC_4BPPV1_Format,RGB_S3TC_DXT1_Format,RGDepthPacking,RGFormat,RGIntegerFormat,RawShaderMaterial,Ray,Raycaster,RectAreaLight,RedFormat,RedIntegerFormat,ReinhardToneMapping,RenderTarget,RenderTarget3D,RenderTargetArray,RepeatWrapping,ReplaceStencilOp,ReverseSubtractEquation,RingGeometry,SIGNED_RED_GREEN_RGTC2_Format,SIGNED_RED_RGTC1_Format,SRGBColorSpace,SRGBTransfer,Scene,ShaderMaterial,ShadowMaterial,Shape,ShapeGeometry,ShapePath,ShapeUtils,ShortType,Skeleton,SkeletonHelper,SkinnedMesh,Source,Sphere,SphereGeometry,Spherical,SphericalHarmonics3,SplineCurve,SpotLight,SpotLightHelper,Sprite,SpriteMaterial,SrcAlphaFactor,SrcAlphaSaturateFactor,SrcColorFactor,StaticCopyUsage,StaticDrawUsage,StaticReadUsage,StereoCamera,StreamCopyUsage,StreamDrawUsage,StreamReadUsage,StringKeyframeTrack,SubtractEquation,SubtractiveBlending,TOUCH,TangentSpaceNormalMap,TetrahedronGeometry,Texture,TextureLoader,TextureUtils,TimestampQuery,TorusGeometry,TorusKnotGeometry,Triangle,TriangleFanDrawMode,TriangleStripDrawMode,TrianglesDrawMode,TubeGeometry,UVMapping,Uint16BufferAttribute,Uint32BufferAttribute,Uint8BufferAttribute,Uint8ClampedBufferAttribute,Uniform,UniformsGroup,UniformsUtils,UnsignedByteType,UnsignedInt248Type,UnsignedInt5999Type,UnsignedIntType,UnsignedShort4444Type,UnsignedShort5551Type,UnsignedShortType,VSMShadowMap,Vector2,Vector3,Vector4,VectorKeyframeTrack,VideoFrameTexture,VideoTexture,WebGL3DRenderTarget,WebGLArrayRenderTarget,WebGLCoordinateSystem,WebGLCubeRenderTarget,WebGLRenderTarget,WebGPUCoordinateSystem,WebXRController,WireframeGeometry,WrapAroundEnding,ZeroCurvatureEnding,ZeroFactor,ZeroSlopeEnding,ZeroStencilOp,arrayNeedsUint32,cloneUniforms,createCanvasElement,createElementNS,getByteLength,getUnlitUniformColorSpace,mergeUniforms,probeAsync,toNormalizedProjectionMatrix,toReversedProjectionMatrix,warnOnce};