/*! For license information please see three.cjs.LICENSE.txt */
"use strict";const REVISION="176",MOUSE={LEFT:0,MIDDLE:1,RIGHT:2,ROTATE:0,DOLLY:1,PAN:2},TOUCH={ROTATE:0,PAN:1,DOLLY_PAN:2,DOLLY_ROTATE:3},CullFaceNone=0,CullFaceBack=1,CullFaceFront=2,CullFaceFrontBack=3,BasicShadowMap=0,PCFShadowMap=1,PCFSoftShadowMap=2,VSMShadowMap=3,FrontSide=0,BackSide=1,DoubleSide=2,NoBlending=0,NormalBlending=1,AdditiveBlending=2,SubtractiveBlending=3,MultiplyBlending=4,CustomBlending=5,AddEquation=100,SubtractEquation=101,ReverseSubtractEquation=102,MinEquation=103,MaxEquation=104,ZeroFactor=200,OneFactor=201,SrcColorFactor=202,OneMinusSrcColorFactor=203,SrcAlphaFactor=204,OneMinusSrcAlphaFactor=205,DstAlphaFactor=206,OneMinusDstAlphaFactor=207,DstColorFactor=208,OneMinusDstColorFactor=209,SrcAlphaSaturateFactor=210,ConstantColorFactor=211,OneMinusConstantColorFactor=212,ConstantAlphaFactor=213,OneMinusConstantAlphaFactor=214,NeverDepth=0,AlwaysDepth=1,LessDepth=2,LessEqualDepth=3,EqualDepth=4,GreaterEqualDepth=5,GreaterDepth=6,NotEqualDepth=7,MultiplyOperation=0,MixOperation=1,AddOperation=2,NoToneMapping=0,LinearToneMapping=1,ReinhardToneMapping=2,CineonToneMapping=3,ACESFilmicToneMapping=4,CustomToneMapping=5,AgXToneMapping=6,NeutralToneMapping=7,AttachedBindMode="attached",DetachedBindMode="detached",UVMapping=300,CubeReflectionMapping=301,CubeRefractionMapping=302,EquirectangularReflectionMapping=303,EquirectangularRefractionMapping=304,CubeUVReflectionMapping=306,RepeatWrapping=1e3,ClampToEdgeWrapping=1001,MirroredRepeatWrapping=1002,NearestFilter=1003,NearestMipmapNearestFilter=1004,NearestMipMapNearestFilter=1004,NearestMipmapLinearFilter=1005,NearestMipMapLinearFilter=1005,LinearFilter=1006,LinearMipmapNearestFilter=1007,LinearMipMapNearestFilter=1007,LinearMipmapLinearFilter=1008,LinearMipMapLinearFilter=1008,UnsignedByteType=1009,ByteType=1010,ShortType=1011,UnsignedShortType=1012,IntType=1013,UnsignedIntType=1014,FloatType=1015,HalfFloatType=1016,UnsignedShort4444Type=1017,UnsignedShort5551Type=1018,UnsignedInt248Type=1020,UnsignedInt5999Type=35902,AlphaFormat=1021,RGBFormat=1022,RGBAFormat=1023,DepthFormat=1026,DepthStencilFormat=1027,RedFormat=1028,RedIntegerFormat=1029,RGFormat=1030,RGIntegerFormat=1031,RGBIntegerFormat=1032,RGBAIntegerFormat=1033,RGB_S3TC_DXT1_Format=33776,RGBA_S3TC_DXT1_Format=33777,RGBA_S3TC_DXT3_Format=33778,RGBA_S3TC_DXT5_Format=33779,RGB_PVRTC_4BPPV1_Format=35840,RGB_PVRTC_2BPPV1_Format=35841,RGBA_PVRTC_4BPPV1_Format=35842,RGBA_PVRTC_2BPPV1_Format=35843,RGB_ETC1_Format=36196,RGB_ETC2_Format=37492,RGBA_ETC2_EAC_Format=37496,RGBA_ASTC_4x4_Format=37808,RGBA_ASTC_5x4_Format=37809,RGBA_ASTC_5x5_Format=37810,RGBA_ASTC_6x5_Format=37811,RGBA_ASTC_6x6_Format=37812,RGBA_ASTC_8x5_Format=37813,RGBA_ASTC_8x6_Format=37814,RGBA_ASTC_8x8_Format=37815,RGBA_ASTC_10x5_Format=37816,RGBA_ASTC_10x6_Format=37817,RGBA_ASTC_10x8_Format=37818,RGBA_ASTC_10x10_Format=37819,RGBA_ASTC_12x10_Format=37820,RGBA_ASTC_12x12_Format=37821,RGBA_BPTC_Format=36492,RGB_BPTC_SIGNED_Format=36494,RGB_BPTC_UNSIGNED_Format=36495,RED_RGTC1_Format=36283,SIGNED_RED_RGTC1_Format=36284,RED_GREEN_RGTC2_Format=36285,SIGNED_RED_GREEN_RGTC2_Format=36286,LoopOnce=2200,LoopRepeat=2201,LoopPingPong=2202,InterpolateDiscrete=2300,InterpolateLinear=2301,InterpolateSmooth=2302,ZeroCurvatureEnding=2400,ZeroSlopeEnding=2401,WrapAroundEnding=2402,NormalAnimationBlendMode=2500,AdditiveAnimationBlendMode=2501,TrianglesDrawMode=0,TriangleStripDrawMode=1,TriangleFanDrawMode=2,BasicDepthPacking=3200,RGBADepthPacking=3201,RGBDepthPacking=3202,RGDepthPacking=3203,TangentSpaceNormalMap=0,ObjectSpaceNormalMap=1,NoColorSpace="",SRGBColorSpace="srgb",LinearSRGBColorSpace="srgb-linear",LinearTransfer="linear",SRGBTransfer="srgb",ZeroStencilOp=0,KeepStencilOp=7680,ReplaceStencilOp=7681,IncrementStencilOp=7682,DecrementStencilOp=7683,IncrementWrapStencilOp=34055,DecrementWrapStencilOp=34056,InvertStencilOp=5386,NeverStencilFunc=512,LessStencilFunc=513,EqualStencilFunc=514,LessEqualStencilFunc=515,GreaterStencilFunc=516,NotEqualStencilFunc=517,GreaterEqualStencilFunc=518,AlwaysStencilFunc=519,NeverCompare=512,LessCompare=513,EqualCompare=514,LessEqualCompare=515,GreaterCompare=516,NotEqualCompare=517,GreaterEqualCompare=518,AlwaysCompare=519,StaticDrawUsage=35044,DynamicDrawUsage=35048,StreamDrawUsage=35040,StaticReadUsage=35045,DynamicReadUsage=35049,StreamReadUsage=35041,StaticCopyUsage=35046,DynamicCopyUsage=35050,StreamCopyUsage=35042,GLSL1="100",GLSL3="300 es",WebGLCoordinateSystem=2e3,WebGPUCoordinateSystem=2001,TimestampQuery={COMPUTE:"compute",RENDER:"render"},InterpolationSamplingType={PERSPECTIVE:"perspective",LINEAR:"linear",FLAT:"flat"},InterpolationSamplingMode={NORMAL:"normal",CENTROID:"centroid",SAMPLE:"sample",FLAT_FIRST:"flat first",FLAT_EITHER:"flat either"};class EventDispatcher{addEventListener(e,t){void 0===this._listeners&&(this._listeners={});const r=this._listeners;void 0===r[e]&&(r[e]=[]),-1===r[e].indexOf(t)&&r[e].push(t)}hasEventListener(e,t){const r=this._listeners;return void 0!==r&&(void 0!==r[e]&&-1!==r[e].indexOf(t))}removeEventListener(e,t){const r=this._listeners;if(void 0===r)return;const n=r[e];if(void 0!==n){const e=n.indexOf(t);-1!==e&&n.splice(e,1)}}dispatchEvent(e){const t=this._listeners;if(void 0===t)return;const r=t[e.type];if(void 0!==r){e.target=this;const t=r.slice(0);for(let r=0,n=t.length;r<n;r++)t[r].call(this,e);e.target=null}}}const _lut=["00","01","02","03","04","05","06","07","08","09","0a","0b","0c","0d","0e","0f","10","11","12","13","14","15","16","17","18","19","1a","1b","1c","1d","1e","1f","20","21","22","23","24","25","26","27","28","29","2a","2b","2c","2d","2e","2f","30","31","32","33","34","35","36","37","38","39","3a","3b","3c","3d","3e","3f","40","41","42","43","44","45","46","47","48","49","4a","4b","4c","4d","4e","4f","50","51","52","53","54","55","56","57","58","59","5a","5b","5c","5d","5e","5f","60","61","62","63","64","65","66","67","68","69","6a","6b","6c","6d","6e","6f","70","71","72","73","74","75","76","77","78","79","7a","7b","7c","7d","7e","7f","80","81","82","83","84","85","86","87","88","89","8a","8b","8c","8d","8e","8f","90","91","92","93","94","95","96","97","98","99","9a","9b","9c","9d","9e","9f","a0","a1","a2","a3","a4","a5","a6","a7","a8","a9","aa","ab","ac","ad","ae","af","b0","b1","b2","b3","b4","b5","b6","b7","b8","b9","ba","bb","bc","bd","be","bf","c0","c1","c2","c3","c4","c5","c6","c7","c8","c9","ca","cb","cc","cd","ce","cf","d0","d1","d2","d3","d4","d5","d6","d7","d8","d9","da","db","dc","dd","de","df","e0","e1","e2","e3","e4","e5","e6","e7","e8","e9","ea","eb","ec","ed","ee","ef","f0","f1","f2","f3","f4","f5","f6","f7","f8","f9","fa","fb","fc","fd","fe","ff"];let _seed=1234567;const DEG2RAD=Math.PI/180,RAD2DEG=180/Math.PI;function generateUUID(){const e=4294967295*Math.random()|0,t=4294967295*Math.random()|0,r=4294967295*Math.random()|0,n=4294967295*Math.random()|0;return(_lut[255&e]+_lut[e>>8&255]+_lut[e>>16&255]+_lut[e>>24&255]+"-"+_lut[255&t]+_lut[t>>8&255]+"-"+_lut[t>>16&15|64]+_lut[t>>24&255]+"-"+_lut[63&r|128]+_lut[r>>8&255]+"-"+_lut[r>>16&255]+_lut[r>>24&255]+_lut[255&n]+_lut[n>>8&255]+_lut[n>>16&255]+_lut[n>>24&255]).toLowerCase()}function clamp(e,t,r){return Math.max(t,Math.min(r,e))}function euclideanModulo(e,t){return(e%t+t)%t}function mapLinear(e,t,r,n,i){return n+(e-t)*(i-n)/(r-t)}function inverseLerp(e,t,r){return e!==t?(r-e)/(t-e):0}function lerp(e,t,r){return(1-r)*e+r*t}function damp(e,t,r,n){return lerp(e,t,1-Math.exp(-r*n))}function pingpong(e,t=1){return t-Math.abs(euclideanModulo(e,2*t)-t)}function smoothstep(e,t,r){return e<=t?0:e>=r?1:(e=(e-t)/(r-t))*e*(3-2*e)}function smootherstep(e,t,r){return e<=t?0:e>=r?1:(e=(e-t)/(r-t))*e*e*(e*(6*e-15)+10)}function randInt(e,t){return e+Math.floor(Math.random()*(t-e+1))}function randFloat(e,t){return e+Math.random()*(t-e)}function randFloatSpread(e){return e*(.5-Math.random())}function seededRandom(e){void 0!==e&&(_seed=e);let t=_seed+=1831565813;return t=Math.imul(t^t>>>15,1|t),t^=t+Math.imul(t^t>>>7,61|t),((t^t>>>14)>>>0)/4294967296}function degToRad(e){return e*DEG2RAD}function radToDeg(e){return e*RAD2DEG}function isPowerOfTwo(e){return!(e&e-1)&&0!==e}function ceilPowerOfTwo(e){return Math.pow(2,Math.ceil(Math.log(e)/Math.LN2))}function floorPowerOfTwo(e){return Math.pow(2,Math.floor(Math.log(e)/Math.LN2))}function setQuaternionFromProperEuler(e,t,r,n,i){const a=Math.cos,s=Math.sin,o=a(r/2),l=s(r/2),c=a((t+n)/2),h=s((t+n)/2),u=a((t-n)/2),d=s((t-n)/2),p=a((n-t)/2),m=s((n-t)/2);switch(i){case"XYX":e.set(o*h,l*u,l*d,o*c);break;case"YZY":e.set(l*d,o*h,l*u,o*c);break;case"ZXZ":e.set(l*u,l*d,o*h,o*c);break;case"XZX":e.set(o*h,l*m,l*p,o*c);break;case"YXY":e.set(l*p,o*h,l*m,o*c);break;case"ZYZ":e.set(l*m,l*p,o*h,o*c);break;default:console.warn("THREE.MathUtils: .setQuaternionFromProperEuler() encountered an unknown order: "+i)}}function denormalize(e,t){switch(t.constructor){case Float32Array:return e;case Uint32Array:return e/4294967295;case Uint16Array:return e/65535;case Uint8Array:return e/255;case Int32Array:return Math.max(e/2147483647,-1);case Int16Array:return Math.max(e/32767,-1);case Int8Array:return Math.max(e/127,-1);default:throw new Error("Invalid component type.")}}function normalize(e,t){switch(t.constructor){case Float32Array:return e;case Uint32Array:return Math.round(4294967295*e);case Uint16Array:return Math.round(65535*e);case Uint8Array:return Math.round(255*e);case Int32Array:return Math.round(2147483647*e);case Int16Array:return Math.round(32767*e);case Int8Array:return Math.round(127*e);default:throw new Error("Invalid component type.")}}const MathUtils={DEG2RAD,RAD2DEG,generateUUID,clamp,euclideanModulo,mapLinear,inverseLerp,lerp,damp,pingpong,smoothstep,smootherstep,randInt,randFloat,randFloatSpread,seededRandom,degToRad,radToDeg,isPowerOfTwo,ceilPowerOfTwo,floorPowerOfTwo,setQuaternionFromProperEuler,normalize,denormalize};class Vector2{constructor(e=0,t=0){Vector2.prototype.isVector2=!0,this.x=e,this.y=t}get width(){return this.x}set width(e){this.x=e}get height(){return this.y}set height(e){this.y=e}set(e,t){return this.x=e,this.y=t,this}setScalar(e){return this.x=e,this.y=e,this}setX(e){return this.x=e,this}setY(e){return this.y=e,this}setComponent(e,t){switch(e){case 0:this.x=t;break;case 1:this.y=t;break;default:throw new Error("index is out of range: "+e)}return this}getComponent(e){switch(e){case 0:return this.x;case 1:return this.y;default:throw new Error("index is out of range: "+e)}}clone(){return new this.constructor(this.x,this.y)}copy(e){return this.x=e.x,this.y=e.y,this}add(e){return this.x+=e.x,this.y+=e.y,this}addScalar(e){return this.x+=e,this.y+=e,this}addVectors(e,t){return this.x=e.x+t.x,this.y=e.y+t.y,this}addScaledVector(e,t){return this.x+=e.x*t,this.y+=e.y*t,this}sub(e){return this.x-=e.x,this.y-=e.y,this}subScalar(e){return this.x-=e,this.y-=e,this}subVectors(e,t){return this.x=e.x-t.x,this.y=e.y-t.y,this}multiply(e){return this.x*=e.x,this.y*=e.y,this}multiplyScalar(e){return this.x*=e,this.y*=e,this}divide(e){return this.x/=e.x,this.y/=e.y,this}divideScalar(e){return this.multiplyScalar(1/e)}applyMatrix3(e){const t=this.x,r=this.y,n=e.elements;return this.x=n[0]*t+n[3]*r+n[6],this.y=n[1]*t+n[4]*r+n[7],this}min(e){return this.x=Math.min(this.x,e.x),this.y=Math.min(this.y,e.y),this}max(e){return this.x=Math.max(this.x,e.x),this.y=Math.max(this.y,e.y),this}clamp(e,t){return this.x=clamp(this.x,e.x,t.x),this.y=clamp(this.y,e.y,t.y),this}clampScalar(e,t){return this.x=clamp(this.x,e,t),this.y=clamp(this.y,e,t),this}clampLength(e,t){const r=this.length();return this.divideScalar(r||1).multiplyScalar(clamp(r,e,t))}floor(){return this.x=Math.floor(this.x),this.y=Math.floor(this.y),this}ceil(){return this.x=Math.ceil(this.x),this.y=Math.ceil(this.y),this}round(){return this.x=Math.round(this.x),this.y=Math.round(this.y),this}roundToZero(){return this.x=Math.trunc(this.x),this.y=Math.trunc(this.y),this}negate(){return this.x=-this.x,this.y=-this.y,this}dot(e){return this.x*e.x+this.y*e.y}cross(e){return this.x*e.y-this.y*e.x}lengthSq(){return this.x*this.x+this.y*this.y}length(){return Math.sqrt(this.x*this.x+this.y*this.y)}manhattanLength(){return Math.abs(this.x)+Math.abs(this.y)}normalize(){return this.divideScalar(this.length()||1)}angle(){return Math.atan2(-this.y,-this.x)+Math.PI}angleTo(e){const t=Math.sqrt(this.lengthSq()*e.lengthSq());if(0===t)return Math.PI/2;const r=this.dot(e)/t;return Math.acos(clamp(r,-1,1))}distanceTo(e){return Math.sqrt(this.distanceToSquared(e))}distanceToSquared(e){const t=this.x-e.x,r=this.y-e.y;return t*t+r*r}manhattanDistanceTo(e){return Math.abs(this.x-e.x)+Math.abs(this.y-e.y)}setLength(e){return this.normalize().multiplyScalar(e)}lerp(e,t){return this.x+=(e.x-this.x)*t,this.y+=(e.y-this.y)*t,this}lerpVectors(e,t,r){return this.x=e.x+(t.x-e.x)*r,this.y=e.y+(t.y-e.y)*r,this}equals(e){return e.x===this.x&&e.y===this.y}fromArray(e,t=0){return this.x=e[t],this.y=e[t+1],this}toArray(e=[],t=0){return e[t]=this.x,e[t+1]=this.y,e}fromBufferAttribute(e,t){return this.x=e.getX(t),this.y=e.getY(t),this}rotateAround(e,t){const r=Math.cos(t),n=Math.sin(t),i=this.x-e.x,a=this.y-e.y;return this.x=i*r-a*n+e.x,this.y=i*n+a*r+e.y,this}random(){return this.x=Math.random(),this.y=Math.random(),this}*[Symbol.iterator](){yield this.x,yield this.y}}class Matrix3{constructor(e,t,r,n,i,a,s,o,l){Matrix3.prototype.isMatrix3=!0,this.elements=[1,0,0,0,1,0,0,0,1],void 0!==e&&this.set(e,t,r,n,i,a,s,o,l)}set(e,t,r,n,i,a,s,o,l){const c=this.elements;return c[0]=e,c[1]=n,c[2]=s,c[3]=t,c[4]=i,c[5]=o,c[6]=r,c[7]=a,c[8]=l,this}identity(){return this.set(1,0,0,0,1,0,0,0,1),this}copy(e){const t=this.elements,r=e.elements;return t[0]=r[0],t[1]=r[1],t[2]=r[2],t[3]=r[3],t[4]=r[4],t[5]=r[5],t[6]=r[6],t[7]=r[7],t[8]=r[8],this}extractBasis(e,t,r){return e.setFromMatrix3Column(this,0),t.setFromMatrix3Column(this,1),r.setFromMatrix3Column(this,2),this}setFromMatrix4(e){const t=e.elements;return this.set(t[0],t[4],t[8],t[1],t[5],t[9],t[2],t[6],t[10]),this}multiply(e){return this.multiplyMatrices(this,e)}premultiply(e){return this.multiplyMatrices(e,this)}multiplyMatrices(e,t){const r=e.elements,n=t.elements,i=this.elements,a=r[0],s=r[3],o=r[6],l=r[1],c=r[4],h=r[7],u=r[2],d=r[5],p=r[8],m=n[0],f=n[3],g=n[6],_=n[1],v=n[4],x=n[7],y=n[2],M=n[5],S=n[8];return i[0]=a*m+s*_+o*y,i[3]=a*f+s*v+o*M,i[6]=a*g+s*x+o*S,i[1]=l*m+c*_+h*y,i[4]=l*f+c*v+h*M,i[7]=l*g+c*x+h*S,i[2]=u*m+d*_+p*y,i[5]=u*f+d*v+p*M,i[8]=u*g+d*x+p*S,this}multiplyScalar(e){const t=this.elements;return t[0]*=e,t[3]*=e,t[6]*=e,t[1]*=e,t[4]*=e,t[7]*=e,t[2]*=e,t[5]*=e,t[8]*=e,this}determinant(){const e=this.elements,t=e[0],r=e[1],n=e[2],i=e[3],a=e[4],s=e[5],o=e[6],l=e[7],c=e[8];return t*a*c-t*s*l-r*i*c+r*s*o+n*i*l-n*a*o}invert(){const e=this.elements,t=e[0],r=e[1],n=e[2],i=e[3],a=e[4],s=e[5],o=e[6],l=e[7],c=e[8],h=c*a-s*l,u=s*o-c*i,d=l*i-a*o,p=t*h+r*u+n*d;if(0===p)return this.set(0,0,0,0,0,0,0,0,0);const m=1/p;return e[0]=h*m,e[1]=(n*l-c*r)*m,e[2]=(s*r-n*a)*m,e[3]=u*m,e[4]=(c*t-n*o)*m,e[5]=(n*i-s*t)*m,e[6]=d*m,e[7]=(r*o-l*t)*m,e[8]=(a*t-r*i)*m,this}transpose(){let e;const t=this.elements;return e=t[1],t[1]=t[3],t[3]=e,e=t[2],t[2]=t[6],t[6]=e,e=t[5],t[5]=t[7],t[7]=e,this}getNormalMatrix(e){return this.setFromMatrix4(e).invert().transpose()}transposeIntoArray(e){const t=this.elements;return e[0]=t[0],e[1]=t[3],e[2]=t[6],e[3]=t[1],e[4]=t[4],e[5]=t[7],e[6]=t[2],e[7]=t[5],e[8]=t[8],this}setUvTransform(e,t,r,n,i,a,s){const o=Math.cos(i),l=Math.sin(i);return this.set(r*o,r*l,-r*(o*a+l*s)+a+e,-n*l,n*o,-n*(-l*a+o*s)+s+t,0,0,1),this}scale(e,t){return this.premultiply(_m3.makeScale(e,t)),this}rotate(e){return this.premultiply(_m3.makeRotation(-e)),this}translate(e,t){return this.premultiply(_m3.makeTranslation(e,t)),this}makeTranslation(e,t){return e.isVector2?this.set(1,0,e.x,0,1,e.y,0,0,1):this.set(1,0,e,0,1,t,0,0,1),this}makeRotation(e){const t=Math.cos(e),r=Math.sin(e);return this.set(t,-r,0,r,t,0,0,0,1),this}makeScale(e,t){return this.set(e,0,0,0,t,0,0,0,1),this}equals(e){const t=this.elements,r=e.elements;for(let e=0;e<9;e++)if(t[e]!==r[e])return!1;return!0}fromArray(e,t=0){for(let r=0;r<9;r++)this.elements[r]=e[r+t];return this}toArray(e=[],t=0){const r=this.elements;return e[t]=r[0],e[t+1]=r[1],e[t+2]=r[2],e[t+3]=r[3],e[t+4]=r[4],e[t+5]=r[5],e[t+6]=r[6],e[t+7]=r[7],e[t+8]=r[8],e}clone(){return(new this.constructor).fromArray(this.elements)}}const _m3=new Matrix3;function arrayNeedsUint32(e){for(let t=e.length-1;t>=0;--t)if(e[t]>=65535)return!0;return!1}const TYPED_ARRAYS={Int8Array,Uint8Array,Uint8ClampedArray,Int16Array,Uint16Array,Int32Array,Uint32Array,Float32Array,Float64Array};function getTypedArray(e,t){return new TYPED_ARRAYS[e](t)}function createElementNS(e){return document.createElementNS("http://www.w3.org/1999/xhtml",e)}function createCanvasElement(){const e=createElementNS("canvas");return e.style.display="block",e}const _cache={};function warnOnce(e){e in _cache||(_cache[e]=!0,console.warn(e))}function probeAsync(e,t,r){return new Promise((function(n,i){setTimeout((function a(){switch(e.clientWaitSync(t,e.SYNC_FLUSH_COMMANDS_BIT,0)){case e.WAIT_FAILED:i();break;case e.TIMEOUT_EXPIRED:setTimeout(a,r);break;default:n()}}),r)}))}function toNormalizedProjectionMatrix(e){const t=e.elements;t[2]=.5*t[2]+.5*t[3],t[6]=.5*t[6]+.5*t[7],t[10]=.5*t[10]+.5*t[11],t[14]=.5*t[14]+.5*t[15]}function toReversedProjectionMatrix(e){const t=e.elements;-1===t[11]?(t[10]=-t[10]-1,t[14]=-t[14]):(t[10]=-t[10],t[14]=1-t[14])}const LINEAR_REC709_TO_XYZ=(new Matrix3).set(.4123908,.3575843,.1804808,.212639,.7151687,.0721923,.0193308,.1191948,.9505322),XYZ_TO_LINEAR_REC709=(new Matrix3).set(3.2409699,-1.5373832,-.4986108,-.9692436,1.8759675,.0415551,.0556301,-.203977,1.0569715);function createColorManagement(){const e={enabled:!0,workingColorSpace:"srgb-linear",spaces:{},convert:function(e,t,r){return!1!==this.enabled&&t!==r&&t&&r?("srgb"===this.spaces[t].transfer&&(e.r=SRGBToLinear(e.r),e.g=SRGBToLinear(e.g),e.b=SRGBToLinear(e.b)),this.spaces[t].primaries!==this.spaces[r].primaries&&(e.applyMatrix3(this.spaces[t].toXYZ),e.applyMatrix3(this.spaces[r].fromXYZ)),"srgb"===this.spaces[r].transfer&&(e.r=LinearToSRGB(e.r),e.g=LinearToSRGB(e.g),e.b=LinearToSRGB(e.b)),e):e},fromWorkingColorSpace:function(e,t){return this.convert(e,this.workingColorSpace,t)},toWorkingColorSpace:function(e,t){return this.convert(e,t,this.workingColorSpace)},getPrimaries:function(e){return this.spaces[e].primaries},getTransfer:function(e){return""===e?"linear":this.spaces[e].transfer},getLuminanceCoefficients:function(e,t=this.workingColorSpace){return e.fromArray(this.spaces[t].luminanceCoefficients)},define:function(e){Object.assign(this.spaces,e)},_getMatrix:function(e,t,r){return e.copy(this.spaces[t].toXYZ).multiply(this.spaces[r].fromXYZ)},_getDrawingBufferColorSpace:function(e){return this.spaces[e].outputColorSpaceConfig.drawingBufferColorSpace},_getUnpackColorSpace:function(e=this.workingColorSpace){return this.spaces[e].workingColorSpaceConfig.unpackColorSpace}},t=[.64,.33,.3,.6,.15,.06],r=[.2126,.7152,.0722],n=[.3127,.329];return e.define({[LinearSRGBColorSpace]:{primaries:t,whitePoint:n,transfer:"linear",toXYZ:LINEAR_REC709_TO_XYZ,fromXYZ:XYZ_TO_LINEAR_REC709,luminanceCoefficients:r,workingColorSpaceConfig:{unpackColorSpace:"srgb"},outputColorSpaceConfig:{drawingBufferColorSpace:"srgb"}},[SRGBColorSpace]:{primaries:t,whitePoint:n,transfer:"srgb",toXYZ:LINEAR_REC709_TO_XYZ,fromXYZ:XYZ_TO_LINEAR_REC709,luminanceCoefficients:r,outputColorSpaceConfig:{drawingBufferColorSpace:"srgb"}}}),e}const ColorManagement=createColorManagement();function SRGBToLinear(e){return e<.04045?.0773993808*e:Math.pow(.9478672986*e+.0521327014,2.4)}function LinearToSRGB(e){return e<.0031308?12.92*e:1.055*Math.pow(e,.41666)-.055}let _canvas;class ImageUtils{static getDataURL(e,t="image/png"){if(/^data:/i.test(e.src))return e.src;if("undefined"==typeof HTMLCanvasElement)return e.src;let r;if(e instanceof HTMLCanvasElement)r=e;else{void 0===_canvas&&(_canvas=createElementNS("canvas")),_canvas.width=e.width,_canvas.height=e.height;const t=_canvas.getContext("2d");e instanceof ImageData?t.putImageData(e,0,0):t.drawImage(e,0,0,e.width,e.height),r=_canvas}return r.toDataURL(t)}static sRGBToLinear(e){if("undefined"!=typeof HTMLImageElement&&e instanceof HTMLImageElement||"undefined"!=typeof HTMLCanvasElement&&e instanceof HTMLCanvasElement||"undefined"!=typeof ImageBitmap&&e instanceof ImageBitmap){const t=createElementNS("canvas");t.width=e.width,t.height=e.height;const r=t.getContext("2d");r.drawImage(e,0,0,e.width,e.height);const n=r.getImageData(0,0,e.width,e.height),i=n.data;for(let e=0;e<i.length;e++)i[e]=255*SRGBToLinear(i[e]/255);return r.putImageData(n,0,0),t}if(e.data){const t=e.data.slice(0);for(let e=0;e<t.length;e++)t instanceof Uint8Array||t instanceof Uint8ClampedArray?t[e]=Math.floor(255*SRGBToLinear(t[e]/255)):t[e]=SRGBToLinear(t[e]);return{data:t,width:e.width,height:e.height}}return console.warn("THREE.ImageUtils.sRGBToLinear(): Unsupported image type. No color space conversion applied."),e}}let _sourceId=0;class Source{constructor(e=null){this.isSource=!0,Object.defineProperty(this,"id",{value:_sourceId++}),this.uuid=generateUUID(),this.data=e,this.dataReady=!0,this.version=0}set needsUpdate(e){!0===e&&this.version++}toJSON(e){const t=void 0===e||"string"==typeof e;if(!t&&void 0!==e.images[this.uuid])return e.images[this.uuid];const r={uuid:this.uuid,url:""},n=this.data;if(null!==n){let e;if(Array.isArray(n)){e=[];for(let t=0,r=n.length;t<r;t++)n[t].isDataTexture?e.push(serializeImage(n[t].image)):e.push(serializeImage(n[t]))}else e=serializeImage(n);r.url=e}return t||(e.images[this.uuid]=r),r}}function serializeImage(e){return"undefined"!=typeof HTMLImageElement&&e instanceof HTMLImageElement||"undefined"!=typeof HTMLCanvasElement&&e instanceof HTMLCanvasElement||"undefined"!=typeof ImageBitmap&&e instanceof ImageBitmap?ImageUtils.getDataURL(e):e.data?{data:Array.from(e.data),width:e.width,height:e.height,type:e.data.constructor.name}:(console.warn("THREE.Texture: Unable to serialize Texture."),{})}let _textureId=0;class Texture extends EventDispatcher{constructor(e=Texture.DEFAULT_IMAGE,t=Texture.DEFAULT_MAPPING,r=1001,n=1001,i=1006,a=1008,s=1023,o=1009,l=Texture.DEFAULT_ANISOTROPY,c=""){super(),this.isTexture=!0,Object.defineProperty(this,"id",{value:_textureId++}),this.uuid=generateUUID(),this.name="",this.source=new Source(e),this.mipmaps=[],this.mapping=t,this.channel=0,this.wrapS=r,this.wrapT=n,this.magFilter=i,this.minFilter=a,this.anisotropy=l,this.format=s,this.internalFormat=null,this.type=o,this.offset=new Vector2(0,0),this.repeat=new Vector2(1,1),this.center=new Vector2(0,0),this.rotation=0,this.matrixAutoUpdate=!0,this.matrix=new Matrix3,this.generateMipmaps=!0,this.premultiplyAlpha=!1,this.flipY=!0,this.unpackAlignment=4,this.colorSpace=c,this.userData={},this.version=0,this.onUpdate=null,this.renderTarget=null,this.isRenderTargetTexture=!1,this.isTextureArray=!1,this.pmremVersion=0}get image(){return this.source.data}set image(e=null){this.source.data=e}updateMatrix(){this.matrix.setUvTransform(this.offset.x,this.offset.y,this.repeat.x,this.repeat.y,this.rotation,this.center.x,this.center.y)}clone(){return(new this.constructor).copy(this)}copy(e){return this.name=e.name,this.source=e.source,this.mipmaps=e.mipmaps.slice(0),this.mapping=e.mapping,this.channel=e.channel,this.wrapS=e.wrapS,this.wrapT=e.wrapT,this.magFilter=e.magFilter,this.minFilter=e.minFilter,this.anisotropy=e.anisotropy,this.format=e.format,this.internalFormat=e.internalFormat,this.type=e.type,this.offset.copy(e.offset),this.repeat.copy(e.repeat),this.center.copy(e.center),this.rotation=e.rotation,this.matrixAutoUpdate=e.matrixAutoUpdate,this.matrix.copy(e.matrix),this.generateMipmaps=e.generateMipmaps,this.premultiplyAlpha=e.premultiplyAlpha,this.flipY=e.flipY,this.unpackAlignment=e.unpackAlignment,this.colorSpace=e.colorSpace,this.renderTarget=e.renderTarget,this.isRenderTargetTexture=e.isRenderTargetTexture,this.isTextureArray=e.isTextureArray,this.userData=JSON.parse(JSON.stringify(e.userData)),this.needsUpdate=!0,this}toJSON(e){const t=void 0===e||"string"==typeof e;if(!t&&void 0!==e.textures[this.uuid])return e.textures[this.uuid];const r={metadata:{version:4.6,type:"Texture",generator:"Texture.toJSON"},uuid:this.uuid,name:this.name,image:this.source.toJSON(e).uuid,mapping:this.mapping,channel:this.channel,repeat:[this.repeat.x,this.repeat.y],offset:[this.offset.x,this.offset.y],center:[this.center.x,this.center.y],rotation:this.rotation,wrap:[this.wrapS,this.wrapT],format:this.format,internalFormat:this.internalFormat,type:this.type,colorSpace:this.colorSpace,minFilter:this.minFilter,magFilter:this.magFilter,anisotropy:this.anisotropy,flipY:this.flipY,generateMipmaps:this.generateMipmaps,premultiplyAlpha:this.premultiplyAlpha,unpackAlignment:this.unpackAlignment};return Object.keys(this.userData).length>0&&(r.userData=this.userData),t||(e.textures[this.uuid]=r),r}dispose(){this.dispatchEvent({type:"dispose"})}transformUv(e){if(300!==this.mapping)return e;if(e.applyMatrix3(this.matrix),e.x<0||e.x>1)switch(this.wrapS){case 1e3:e.x=e.x-Math.floor(e.x);break;case 1001:e.x=e.x<0?0:1;break;case 1002:1===Math.abs(Math.floor(e.x)%2)?e.x=Math.ceil(e.x)-e.x:e.x=e.x-Math.floor(e.x)}if(e.y<0||e.y>1)switch(this.wrapT){case 1e3:e.y=e.y-Math.floor(e.y);break;case 1001:e.y=e.y<0?0:1;break;case 1002:1===Math.abs(Math.floor(e.y)%2)?e.y=Math.ceil(e.y)-e.y:e.y=e.y-Math.floor(e.y)}return this.flipY&&(e.y=1-e.y),e}set needsUpdate(e){!0===e&&(this.version++,this.source.needsUpdate=!0)}set needsPMREMUpdate(e){!0===e&&this.pmremVersion++}}Texture.DEFAULT_IMAGE=null,Texture.DEFAULT_MAPPING=300,Texture.DEFAULT_ANISOTROPY=1;class Vector4{constructor(e=0,t=0,r=0,n=1){Vector4.prototype.isVector4=!0,this.x=e,this.y=t,this.z=r,this.w=n}get width(){return this.z}set width(e){this.z=e}get height(){return this.w}set height(e){this.w=e}set(e,t,r,n){return this.x=e,this.y=t,this.z=r,this.w=n,this}setScalar(e){return this.x=e,this.y=e,this.z=e,this.w=e,this}setX(e){return this.x=e,this}setY(e){return this.y=e,this}setZ(e){return this.z=e,this}setW(e){return this.w=e,this}setComponent(e,t){switch(e){case 0:this.x=t;break;case 1:this.y=t;break;case 2:this.z=t;break;case 3:this.w=t;break;default:throw new Error("index is out of range: "+e)}return this}getComponent(e){switch(e){case 0:return this.x;case 1:return this.y;case 2:return this.z;case 3:return this.w;default:throw new Error("index is out of range: "+e)}}clone(){return new this.constructor(this.x,this.y,this.z,this.w)}copy(e){return this.x=e.x,this.y=e.y,this.z=e.z,this.w=void 0!==e.w?e.w:1,this}add(e){return this.x+=e.x,this.y+=e.y,this.z+=e.z,this.w+=e.w,this}addScalar(e){return this.x+=e,this.y+=e,this.z+=e,this.w+=e,this}addVectors(e,t){return this.x=e.x+t.x,this.y=e.y+t.y,this.z=e.z+t.z,this.w=e.w+t.w,this}addScaledVector(e,t){return this.x+=e.x*t,this.y+=e.y*t,this.z+=e.z*t,this.w+=e.w*t,this}sub(e){return this.x-=e.x,this.y-=e.y,this.z-=e.z,this.w-=e.w,this}subScalar(e){return this.x-=e,this.y-=e,this.z-=e,this.w-=e,this}subVectors(e,t){return this.x=e.x-t.x,this.y=e.y-t.y,this.z=e.z-t.z,this.w=e.w-t.w,this}multiply(e){return this.x*=e.x,this.y*=e.y,this.z*=e.z,this.w*=e.w,this}multiplyScalar(e){return this.x*=e,this.y*=e,this.z*=e,this.w*=e,this}applyMatrix4(e){const t=this.x,r=this.y,n=this.z,i=this.w,a=e.elements;return this.x=a[0]*t+a[4]*r+a[8]*n+a[12]*i,this.y=a[1]*t+a[5]*r+a[9]*n+a[13]*i,this.z=a[2]*t+a[6]*r+a[10]*n+a[14]*i,this.w=a[3]*t+a[7]*r+a[11]*n+a[15]*i,this}divide(e){return this.x/=e.x,this.y/=e.y,this.z/=e.z,this.w/=e.w,this}divideScalar(e){return this.multiplyScalar(1/e)}setAxisAngleFromQuaternion(e){this.w=2*Math.acos(e.w);const t=Math.sqrt(1-e.w*e.w);return t<1e-4?(this.x=1,this.y=0,this.z=0):(this.x=e.x/t,this.y=e.y/t,this.z=e.z/t),this}setAxisAngleFromRotationMatrix(e){let t,r,n,i;const a=.01,s=.1,o=e.elements,l=o[0],c=o[4],h=o[8],u=o[1],d=o[5],p=o[9],m=o[2],f=o[6],g=o[10];if(Math.abs(c-u)<a&&Math.abs(h-m)<a&&Math.abs(p-f)<a){if(Math.abs(c+u)<s&&Math.abs(h+m)<s&&Math.abs(p+f)<s&&Math.abs(l+d+g-3)<s)return this.set(1,0,0,0),this;t=Math.PI;const e=(l+1)/2,o=(d+1)/2,_=(g+1)/2,v=(c+u)/4,x=(h+m)/4,y=(p+f)/4;return e>o&&e>_?e<a?(r=0,n=.707106781,i=.707106781):(r=Math.sqrt(e),n=v/r,i=x/r):o>_?o<a?(r=.707106781,n=0,i=.707106781):(n=Math.sqrt(o),r=v/n,i=y/n):_<a?(r=.707106781,n=.707106781,i=0):(i=Math.sqrt(_),r=x/i,n=y/i),this.set(r,n,i,t),this}let _=Math.sqrt((f-p)*(f-p)+(h-m)*(h-m)+(u-c)*(u-c));return Math.abs(_)<.001&&(_=1),this.x=(f-p)/_,this.y=(h-m)/_,this.z=(u-c)/_,this.w=Math.acos((l+d+g-1)/2),this}setFromMatrixPosition(e){const t=e.elements;return this.x=t[12],this.y=t[13],this.z=t[14],this.w=t[15],this}min(e){return this.x=Math.min(this.x,e.x),this.y=Math.min(this.y,e.y),this.z=Math.min(this.z,e.z),this.w=Math.min(this.w,e.w),this}max(e){return this.x=Math.max(this.x,e.x),this.y=Math.max(this.y,e.y),this.z=Math.max(this.z,e.z),this.w=Math.max(this.w,e.w),this}clamp(e,t){return this.x=clamp(this.x,e.x,t.x),this.y=clamp(this.y,e.y,t.y),this.z=clamp(this.z,e.z,t.z),this.w=clamp(this.w,e.w,t.w),this}clampScalar(e,t){return this.x=clamp(this.x,e,t),this.y=clamp(this.y,e,t),this.z=clamp(this.z,e,t),this.w=clamp(this.w,e,t),this}clampLength(e,t){const r=this.length();return this.divideScalar(r||1).multiplyScalar(clamp(r,e,t))}floor(){return this.x=Math.floor(this.x),this.y=Math.floor(this.y),this.z=Math.floor(this.z),this.w=Math.floor(this.w),this}ceil(){return this.x=Math.ceil(this.x),this.y=Math.ceil(this.y),this.z=Math.ceil(this.z),this.w=Math.ceil(this.w),this}round(){return this.x=Math.round(this.x),this.y=Math.round(this.y),this.z=Math.round(this.z),this.w=Math.round(this.w),this}roundToZero(){return this.x=Math.trunc(this.x),this.y=Math.trunc(this.y),this.z=Math.trunc(this.z),this.w=Math.trunc(this.w),this}negate(){return this.x=-this.x,this.y=-this.y,this.z=-this.z,this.w=-this.w,this}dot(e){return this.x*e.x+this.y*e.y+this.z*e.z+this.w*e.w}lengthSq(){return this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w}length(){return Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w)}manhattanLength(){return Math.abs(this.x)+Math.abs(this.y)+Math.abs(this.z)+Math.abs(this.w)}normalize(){return this.divideScalar(this.length()||1)}setLength(e){return this.normalize().multiplyScalar(e)}lerp(e,t){return this.x+=(e.x-this.x)*t,this.y+=(e.y-this.y)*t,this.z+=(e.z-this.z)*t,this.w+=(e.w-this.w)*t,this}lerpVectors(e,t,r){return this.x=e.x+(t.x-e.x)*r,this.y=e.y+(t.y-e.y)*r,this.z=e.z+(t.z-e.z)*r,this.w=e.w+(t.w-e.w)*r,this}equals(e){return e.x===this.x&&e.y===this.y&&e.z===this.z&&e.w===this.w}fromArray(e,t=0){return this.x=e[t],this.y=e[t+1],this.z=e[t+2],this.w=e[t+3],this}toArray(e=[],t=0){return e[t]=this.x,e[t+1]=this.y,e[t+2]=this.z,e[t+3]=this.w,e}fromBufferAttribute(e,t){return this.x=e.getX(t),this.y=e.getY(t),this.z=e.getZ(t),this.w=e.getW(t),this}random(){return this.x=Math.random(),this.y=Math.random(),this.z=Math.random(),this.w=Math.random(),this}*[Symbol.iterator](){yield this.x,yield this.y,yield this.z,yield this.w}}class RenderTarget extends EventDispatcher{constructor(e=1,t=1,r={}){super(),this.isRenderTarget=!0,this.width=e,this.height=t,this.depth=r.depth?r.depth:1,this.scissor=new Vector4(0,0,e,t),this.scissorTest=!1,this.viewport=new Vector4(0,0,e,t);const n={width:e,height:t,depth:this.depth};r=Object.assign({generateMipmaps:!1,internalFormat:null,minFilter:1006,depthBuffer:!0,stencilBuffer:!1,resolveDepthBuffer:!0,resolveStencilBuffer:!0,depthTexture:null,samples:0,count:1,multiview:!1},r);const i=new Texture(n,r.mapping,r.wrapS,r.wrapT,r.magFilter,r.minFilter,r.format,r.type,r.anisotropy,r.colorSpace);i.flipY=!1,i.generateMipmaps=r.generateMipmaps,i.internalFormat=r.internalFormat,this.textures=[];const a=r.count;for(let e=0;e<a;e++)this.textures[e]=i.clone(),this.textures[e].isRenderTargetTexture=!0,this.textures[e].renderTarget=this;this.depthBuffer=r.depthBuffer,this.stencilBuffer=r.stencilBuffer,this.resolveDepthBuffer=r.resolveDepthBuffer,this.resolveStencilBuffer=r.resolveStencilBuffer,this._depthTexture=null,this.depthTexture=r.depthTexture,this.samples=r.samples,this.multiview=r.multiview}get texture(){return this.textures[0]}set texture(e){this.textures[0]=e}set depthTexture(e){null!==this._depthTexture&&(this._depthTexture.renderTarget=null),null!==e&&(e.renderTarget=this),this._depthTexture=e}get depthTexture(){return this._depthTexture}setSize(e,t,r=1){if(this.width!==e||this.height!==t||this.depth!==r){this.width=e,this.height=t,this.depth=r;for(let n=0,i=this.textures.length;n<i;n++)this.textures[n].image.width=e,this.textures[n].image.height=t,this.textures[n].image.depth=r;this.dispose()}this.viewport.set(0,0,e,t),this.scissor.set(0,0,e,t)}clone(){return(new this.constructor).copy(this)}copy(e){this.width=e.width,this.height=e.height,this.depth=e.depth,this.scissor.copy(e.scissor),this.scissorTest=e.scissorTest,this.viewport.copy(e.viewport),this.textures.length=0;for(let t=0,r=e.textures.length;t<r;t++){this.textures[t]=e.textures[t].clone(),this.textures[t].isRenderTargetTexture=!0,this.textures[t].renderTarget=this;const r=Object.assign({},e.textures[t].image);this.textures[t].source=new Source(r)}return this.depthBuffer=e.depthBuffer,this.stencilBuffer=e.stencilBuffer,this.resolveDepthBuffer=e.resolveDepthBuffer,this.resolveStencilBuffer=e.resolveStencilBuffer,null!==e.depthTexture&&(this.depthTexture=e.depthTexture.clone()),this.samples=e.samples,this}dispose(){this.dispatchEvent({type:"dispose"})}}class WebGLRenderTarget extends RenderTarget{constructor(e=1,t=1,r={}){super(e,t,r),this.isWebGLRenderTarget=!0}}class DataArrayTexture extends Texture{constructor(e=null,t=1,r=1,n=1){super(null),this.isDataArrayTexture=!0,this.image={data:e,width:t,height:r,depth:n},this.magFilter=1003,this.minFilter=1003,this.wrapR=1001,this.generateMipmaps=!1,this.flipY=!1,this.unpackAlignment=1,this.layerUpdates=new Set}addLayerUpdate(e){this.layerUpdates.add(e)}clearLayerUpdates(){this.layerUpdates.clear()}}class WebGLArrayRenderTarget extends WebGLRenderTarget{constructor(e=1,t=1,r=1,n={}){super(e,t,n),this.isWebGLArrayRenderTarget=!0,this.depth=r,this.texture=new DataArrayTexture(null,e,t,r),this.texture.isRenderTargetTexture=!0}}class Data3DTexture extends Texture{constructor(e=null,t=1,r=1,n=1){super(null),this.isData3DTexture=!0,this.image={data:e,width:t,height:r,depth:n},this.magFilter=1003,this.minFilter=1003,this.wrapR=1001,this.generateMipmaps=!1,this.flipY=!1,this.unpackAlignment=1}}class WebGL3DRenderTarget extends WebGLRenderTarget{constructor(e=1,t=1,r=1,n={}){super(e,t,n),this.isWebGL3DRenderTarget=!0,this.depth=r,this.texture=new Data3DTexture(null,e,t,r),this.texture.isRenderTargetTexture=!0}}class Quaternion{constructor(e=0,t=0,r=0,n=1){this.isQuaternion=!0,this._x=e,this._y=t,this._z=r,this._w=n}static slerpFlat(e,t,r,n,i,a,s){let o=r[n+0],l=r[n+1],c=r[n+2],h=r[n+3];const u=i[a+0],d=i[a+1],p=i[a+2],m=i[a+3];if(0===s)return e[t+0]=o,e[t+1]=l,e[t+2]=c,void(e[t+3]=h);if(1===s)return e[t+0]=u,e[t+1]=d,e[t+2]=p,void(e[t+3]=m);if(h!==m||o!==u||l!==d||c!==p){let e=1-s;const t=o*u+l*d+c*p+h*m,r=t>=0?1:-1,n=1-t*t;if(n>Number.EPSILON){const i=Math.sqrt(n),a=Math.atan2(i,t*r);e=Math.sin(e*a)/i,s=Math.sin(s*a)/i}const i=s*r;if(o=o*e+u*i,l=l*e+d*i,c=c*e+p*i,h=h*e+m*i,e===1-s){const e=1/Math.sqrt(o*o+l*l+c*c+h*h);o*=e,l*=e,c*=e,h*=e}}e[t]=o,e[t+1]=l,e[t+2]=c,e[t+3]=h}static multiplyQuaternionsFlat(e,t,r,n,i,a){const s=r[n],o=r[n+1],l=r[n+2],c=r[n+3],h=i[a],u=i[a+1],d=i[a+2],p=i[a+3];return e[t]=s*p+c*h+o*d-l*u,e[t+1]=o*p+c*u+l*h-s*d,e[t+2]=l*p+c*d+s*u-o*h,e[t+3]=c*p-s*h-o*u-l*d,e}get x(){return this._x}set x(e){this._x=e,this._onChangeCallback()}get y(){return this._y}set y(e){this._y=e,this._onChangeCallback()}get z(){return this._z}set z(e){this._z=e,this._onChangeCallback()}get w(){return this._w}set w(e){this._w=e,this._onChangeCallback()}set(e,t,r,n){return this._x=e,this._y=t,this._z=r,this._w=n,this._onChangeCallback(),this}clone(){return new this.constructor(this._x,this._y,this._z,this._w)}copy(e){return this._x=e.x,this._y=e.y,this._z=e.z,this._w=e.w,this._onChangeCallback(),this}setFromEuler(e,t=!0){const r=e._x,n=e._y,i=e._z,a=e._order,s=Math.cos,o=Math.sin,l=s(r/2),c=s(n/2),h=s(i/2),u=o(r/2),d=o(n/2),p=o(i/2);switch(a){case"XYZ":this._x=u*c*h+l*d*p,this._y=l*d*h-u*c*p,this._z=l*c*p+u*d*h,this._w=l*c*h-u*d*p;break;case"YXZ":this._x=u*c*h+l*d*p,this._y=l*d*h-u*c*p,this._z=l*c*p-u*d*h,this._w=l*c*h+u*d*p;break;case"ZXY":this._x=u*c*h-l*d*p,this._y=l*d*h+u*c*p,this._z=l*c*p+u*d*h,this._w=l*c*h-u*d*p;break;case"ZYX":this._x=u*c*h-l*d*p,this._y=l*d*h+u*c*p,this._z=l*c*p-u*d*h,this._w=l*c*h+u*d*p;break;case"YZX":this._x=u*c*h+l*d*p,this._y=l*d*h+u*c*p,this._z=l*c*p-u*d*h,this._w=l*c*h-u*d*p;break;case"XZY":this._x=u*c*h-l*d*p,this._y=l*d*h-u*c*p,this._z=l*c*p+u*d*h,this._w=l*c*h+u*d*p;break;default:console.warn("THREE.Quaternion: .setFromEuler() encountered an unknown order: "+a)}return!0===t&&this._onChangeCallback(),this}setFromAxisAngle(e,t){const r=t/2,n=Math.sin(r);return this._x=e.x*n,this._y=e.y*n,this._z=e.z*n,this._w=Math.cos(r),this._onChangeCallback(),this}setFromRotationMatrix(e){const t=e.elements,r=t[0],n=t[4],i=t[8],a=t[1],s=t[5],o=t[9],l=t[2],c=t[6],h=t[10],u=r+s+h;if(u>0){const e=.5/Math.sqrt(u+1);this._w=.25/e,this._x=(c-o)*e,this._y=(i-l)*e,this._z=(a-n)*e}else if(r>s&&r>h){const e=2*Math.sqrt(1+r-s-h);this._w=(c-o)/e,this._x=.25*e,this._y=(n+a)/e,this._z=(i+l)/e}else if(s>h){const e=2*Math.sqrt(1+s-r-h);this._w=(i-l)/e,this._x=(n+a)/e,this._y=.25*e,this._z=(o+c)/e}else{const e=2*Math.sqrt(1+h-r-s);this._w=(a-n)/e,this._x=(i+l)/e,this._y=(o+c)/e,this._z=.25*e}return this._onChangeCallback(),this}setFromUnitVectors(e,t){let r=e.dot(t)+1;return r<Number.EPSILON?(r=0,Math.abs(e.x)>Math.abs(e.z)?(this._x=-e.y,this._y=e.x,this._z=0,this._w=r):(this._x=0,this._y=-e.z,this._z=e.y,this._w=r)):(this._x=e.y*t.z-e.z*t.y,this._y=e.z*t.x-e.x*t.z,this._z=e.x*t.y-e.y*t.x,this._w=r),this.normalize()}angleTo(e){return 2*Math.acos(Math.abs(clamp(this.dot(e),-1,1)))}rotateTowards(e,t){const r=this.angleTo(e);if(0===r)return this;const n=Math.min(1,t/r);return this.slerp(e,n),this}identity(){return this.set(0,0,0,1)}invert(){return this.conjugate()}conjugate(){return this._x*=-1,this._y*=-1,this._z*=-1,this._onChangeCallback(),this}dot(e){return this._x*e._x+this._y*e._y+this._z*e._z+this._w*e._w}lengthSq(){return this._x*this._x+this._y*this._y+this._z*this._z+this._w*this._w}length(){return Math.sqrt(this._x*this._x+this._y*this._y+this._z*this._z+this._w*this._w)}normalize(){let e=this.length();return 0===e?(this._x=0,this._y=0,this._z=0,this._w=1):(e=1/e,this._x=this._x*e,this._y=this._y*e,this._z=this._z*e,this._w=this._w*e),this._onChangeCallback(),this}multiply(e){return this.multiplyQuaternions(this,e)}premultiply(e){return this.multiplyQuaternions(e,this)}multiplyQuaternions(e,t){const r=e._x,n=e._y,i=e._z,a=e._w,s=t._x,o=t._y,l=t._z,c=t._w;return this._x=r*c+a*s+n*l-i*o,this._y=n*c+a*o+i*s-r*l,this._z=i*c+a*l+r*o-n*s,this._w=a*c-r*s-n*o-i*l,this._onChangeCallback(),this}slerp(e,t){if(0===t)return this;if(1===t)return this.copy(e);const r=this._x,n=this._y,i=this._z,a=this._w;let s=a*e._w+r*e._x+n*e._y+i*e._z;if(s<0?(this._w=-e._w,this._x=-e._x,this._y=-e._y,this._z=-e._z,s=-s):this.copy(e),s>=1)return this._w=a,this._x=r,this._y=n,this._z=i,this;const o=1-s*s;if(o<=Number.EPSILON){const e=1-t;return this._w=e*a+t*this._w,this._x=e*r+t*this._x,this._y=e*n+t*this._y,this._z=e*i+t*this._z,this.normalize(),this}const l=Math.sqrt(o),c=Math.atan2(l,s),h=Math.sin((1-t)*c)/l,u=Math.sin(t*c)/l;return this._w=a*h+this._w*u,this._x=r*h+this._x*u,this._y=n*h+this._y*u,this._z=i*h+this._z*u,this._onChangeCallback(),this}slerpQuaternions(e,t,r){return this.copy(e).slerp(t,r)}random(){const e=2*Math.PI*Math.random(),t=2*Math.PI*Math.random(),r=Math.random(),n=Math.sqrt(1-r),i=Math.sqrt(r);return this.set(n*Math.sin(e),n*Math.cos(e),i*Math.sin(t),i*Math.cos(t))}equals(e){return e._x===this._x&&e._y===this._y&&e._z===this._z&&e._w===this._w}fromArray(e,t=0){return this._x=e[t],this._y=e[t+1],this._z=e[t+2],this._w=e[t+3],this._onChangeCallback(),this}toArray(e=[],t=0){return e[t]=this._x,e[t+1]=this._y,e[t+2]=this._z,e[t+3]=this._w,e}fromBufferAttribute(e,t){return this._x=e.getX(t),this._y=e.getY(t),this._z=e.getZ(t),this._w=e.getW(t),this._onChangeCallback(),this}toJSON(){return this.toArray()}_onChange(e){return this._onChangeCallback=e,this}_onChangeCallback(){}*[Symbol.iterator](){yield this._x,yield this._y,yield this._z,yield this._w}}class Vector3{constructor(e=0,t=0,r=0){Vector3.prototype.isVector3=!0,this.x=e,this.y=t,this.z=r}set(e,t,r){return void 0===r&&(r=this.z),this.x=e,this.y=t,this.z=r,this}setScalar(e){return this.x=e,this.y=e,this.z=e,this}setX(e){return this.x=e,this}setY(e){return this.y=e,this}setZ(e){return this.z=e,this}setComponent(e,t){switch(e){case 0:this.x=t;break;case 1:this.y=t;break;case 2:this.z=t;break;default:throw new Error("index is out of range: "+e)}return this}getComponent(e){switch(e){case 0:return this.x;case 1:return this.y;case 2:return this.z;default:throw new Error("index is out of range: "+e)}}clone(){return new this.constructor(this.x,this.y,this.z)}copy(e){return this.x=e.x,this.y=e.y,this.z=e.z,this}add(e){return this.x+=e.x,this.y+=e.y,this.z+=e.z,this}addScalar(e){return this.x+=e,this.y+=e,this.z+=e,this}addVectors(e,t){return this.x=e.x+t.x,this.y=e.y+t.y,this.z=e.z+t.z,this}addScaledVector(e,t){return this.x+=e.x*t,this.y+=e.y*t,this.z+=e.z*t,this}sub(e){return this.x-=e.x,this.y-=e.y,this.z-=e.z,this}subScalar(e){return this.x-=e,this.y-=e,this.z-=e,this}subVectors(e,t){return this.x=e.x-t.x,this.y=e.y-t.y,this.z=e.z-t.z,this}multiply(e){return this.x*=e.x,this.y*=e.y,this.z*=e.z,this}multiplyScalar(e){return this.x*=e,this.y*=e,this.z*=e,this}multiplyVectors(e,t){return this.x=e.x*t.x,this.y=e.y*t.y,this.z=e.z*t.z,this}applyEuler(e){return this.applyQuaternion(_quaternion$4.setFromEuler(e))}applyAxisAngle(e,t){return this.applyQuaternion(_quaternion$4.setFromAxisAngle(e,t))}applyMatrix3(e){const t=this.x,r=this.y,n=this.z,i=e.elements;return this.x=i[0]*t+i[3]*r+i[6]*n,this.y=i[1]*t+i[4]*r+i[7]*n,this.z=i[2]*t+i[5]*r+i[8]*n,this}applyNormalMatrix(e){return this.applyMatrix3(e).normalize()}applyMatrix4(e){const t=this.x,r=this.y,n=this.z,i=e.elements,a=1/(i[3]*t+i[7]*r+i[11]*n+i[15]);return this.x=(i[0]*t+i[4]*r+i[8]*n+i[12])*a,this.y=(i[1]*t+i[5]*r+i[9]*n+i[13])*a,this.z=(i[2]*t+i[6]*r+i[10]*n+i[14])*a,this}applyQuaternion(e){const t=this.x,r=this.y,n=this.z,i=e.x,a=e.y,s=e.z,o=e.w,l=2*(a*n-s*r),c=2*(s*t-i*n),h=2*(i*r-a*t);return this.x=t+o*l+a*h-s*c,this.y=r+o*c+s*l-i*h,this.z=n+o*h+i*c-a*l,this}project(e){return this.applyMatrix4(e.matrixWorldInverse).applyMatrix4(e.projectionMatrix)}unproject(e){return this.applyMatrix4(e.projectionMatrixInverse).applyMatrix4(e.matrixWorld)}transformDirection(e){const t=this.x,r=this.y,n=this.z,i=e.elements;return this.x=i[0]*t+i[4]*r+i[8]*n,this.y=i[1]*t+i[5]*r+i[9]*n,this.z=i[2]*t+i[6]*r+i[10]*n,this.normalize()}divide(e){return this.x/=e.x,this.y/=e.y,this.z/=e.z,this}divideScalar(e){return this.multiplyScalar(1/e)}min(e){return this.x=Math.min(this.x,e.x),this.y=Math.min(this.y,e.y),this.z=Math.min(this.z,e.z),this}max(e){return this.x=Math.max(this.x,e.x),this.y=Math.max(this.y,e.y),this.z=Math.max(this.z,e.z),this}clamp(e,t){return this.x=clamp(this.x,e.x,t.x),this.y=clamp(this.y,e.y,t.y),this.z=clamp(this.z,e.z,t.z),this}clampScalar(e,t){return this.x=clamp(this.x,e,t),this.y=clamp(this.y,e,t),this.z=clamp(this.z,e,t),this}clampLength(e,t){const r=this.length();return this.divideScalar(r||1).multiplyScalar(clamp(r,e,t))}floor(){return this.x=Math.floor(this.x),this.y=Math.floor(this.y),this.z=Math.floor(this.z),this}ceil(){return this.x=Math.ceil(this.x),this.y=Math.ceil(this.y),this.z=Math.ceil(this.z),this}round(){return this.x=Math.round(this.x),this.y=Math.round(this.y),this.z=Math.round(this.z),this}roundToZero(){return this.x=Math.trunc(this.x),this.y=Math.trunc(this.y),this.z=Math.trunc(this.z),this}negate(){return this.x=-this.x,this.y=-this.y,this.z=-this.z,this}dot(e){return this.x*e.x+this.y*e.y+this.z*e.z}lengthSq(){return this.x*this.x+this.y*this.y+this.z*this.z}length(){return Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z)}manhattanLength(){return Math.abs(this.x)+Math.abs(this.y)+Math.abs(this.z)}normalize(){return this.divideScalar(this.length()||1)}setLength(e){return this.normalize().multiplyScalar(e)}lerp(e,t){return this.x+=(e.x-this.x)*t,this.y+=(e.y-this.y)*t,this.z+=(e.z-this.z)*t,this}lerpVectors(e,t,r){return this.x=e.x+(t.x-e.x)*r,this.y=e.y+(t.y-e.y)*r,this.z=e.z+(t.z-e.z)*r,this}cross(e){return this.crossVectors(this,e)}crossVectors(e,t){const r=e.x,n=e.y,i=e.z,a=t.x,s=t.y,o=t.z;return this.x=n*o-i*s,this.y=i*a-r*o,this.z=r*s-n*a,this}projectOnVector(e){const t=e.lengthSq();if(0===t)return this.set(0,0,0);const r=e.dot(this)/t;return this.copy(e).multiplyScalar(r)}projectOnPlane(e){return _vector$c.copy(this).projectOnVector(e),this.sub(_vector$c)}reflect(e){return this.sub(_vector$c.copy(e).multiplyScalar(2*this.dot(e)))}angleTo(e){const t=Math.sqrt(this.lengthSq()*e.lengthSq());if(0===t)return Math.PI/2;const r=this.dot(e)/t;return Math.acos(clamp(r,-1,1))}distanceTo(e){return Math.sqrt(this.distanceToSquared(e))}distanceToSquared(e){const t=this.x-e.x,r=this.y-e.y,n=this.z-e.z;return t*t+r*r+n*n}manhattanDistanceTo(e){return Math.abs(this.x-e.x)+Math.abs(this.y-e.y)+Math.abs(this.z-e.z)}setFromSpherical(e){return this.setFromSphericalCoords(e.radius,e.phi,e.theta)}setFromSphericalCoords(e,t,r){const n=Math.sin(t)*e;return this.x=n*Math.sin(r),this.y=Math.cos(t)*e,this.z=n*Math.cos(r),this}setFromCylindrical(e){return this.setFromCylindricalCoords(e.radius,e.theta,e.y)}setFromCylindricalCoords(e,t,r){return this.x=e*Math.sin(t),this.y=r,this.z=e*Math.cos(t),this}setFromMatrixPosition(e){const t=e.elements;return this.x=t[12],this.y=t[13],this.z=t[14],this}setFromMatrixScale(e){const t=this.setFromMatrixColumn(e,0).length(),r=this.setFromMatrixColumn(e,1).length(),n=this.setFromMatrixColumn(e,2).length();return this.x=t,this.y=r,this.z=n,this}setFromMatrixColumn(e,t){return this.fromArray(e.elements,4*t)}setFromMatrix3Column(e,t){return this.fromArray(e.elements,3*t)}setFromEuler(e){return this.x=e._x,this.y=e._y,this.z=e._z,this}setFromColor(e){return this.x=e.r,this.y=e.g,this.z=e.b,this}equals(e){return e.x===this.x&&e.y===this.y&&e.z===this.z}fromArray(e,t=0){return this.x=e[t],this.y=e[t+1],this.z=e[t+2],this}toArray(e=[],t=0){return e[t]=this.x,e[t+1]=this.y,e[t+2]=this.z,e}fromBufferAttribute(e,t){return this.x=e.getX(t),this.y=e.getY(t),this.z=e.getZ(t),this}random(){return this.x=Math.random(),this.y=Math.random(),this.z=Math.random(),this}randomDirection(){const e=Math.random()*Math.PI*2,t=2*Math.random()-1,r=Math.sqrt(1-t*t);return this.x=r*Math.cos(e),this.y=t,this.z=r*Math.sin(e),this}*[Symbol.iterator](){yield this.x,yield this.y,yield this.z}}const _vector$c=new Vector3,_quaternion$4=new Quaternion;class Box3{constructor(e=new Vector3(1/0,1/0,1/0),t=new Vector3(-1/0,-1/0,-1/0)){this.isBox3=!0,this.min=e,this.max=t}set(e,t){return this.min.copy(e),this.max.copy(t),this}setFromArray(e){this.makeEmpty();for(let t=0,r=e.length;t<r;t+=3)this.expandByPoint(_vector$b.fromArray(e,t));return this}setFromBufferAttribute(e){this.makeEmpty();for(let t=0,r=e.count;t<r;t++)this.expandByPoint(_vector$b.fromBufferAttribute(e,t));return this}setFromPoints(e){this.makeEmpty();for(let t=0,r=e.length;t<r;t++)this.expandByPoint(e[t]);return this}setFromCenterAndSize(e,t){const r=_vector$b.copy(t).multiplyScalar(.5);return this.min.copy(e).sub(r),this.max.copy(e).add(r),this}setFromObject(e,t=!1){return this.makeEmpty(),this.expandByObject(e,t)}clone(){return(new this.constructor).copy(this)}copy(e){return this.min.copy(e.min),this.max.copy(e.max),this}makeEmpty(){return this.min.x=this.min.y=this.min.z=1/0,this.max.x=this.max.y=this.max.z=-1/0,this}isEmpty(){return this.max.x<this.min.x||this.max.y<this.min.y||this.max.z<this.min.z}getCenter(e){return this.isEmpty()?e.set(0,0,0):e.addVectors(this.min,this.max).multiplyScalar(.5)}getSize(e){return this.isEmpty()?e.set(0,0,0):e.subVectors(this.max,this.min)}expandByPoint(e){return this.min.min(e),this.max.max(e),this}expandByVector(e){return this.min.sub(e),this.max.add(e),this}expandByScalar(e){return this.min.addScalar(-e),this.max.addScalar(e),this}expandByObject(e,t=!1){e.updateWorldMatrix(!1,!1);const r=e.geometry;if(void 0!==r){const n=r.getAttribute("position");if(!0===t&&void 0!==n&&!0!==e.isInstancedMesh)for(let t=0,r=n.count;t<r;t++)!0===e.isMesh?e.getVertexPosition(t,_vector$b):_vector$b.fromBufferAttribute(n,t),_vector$b.applyMatrix4(e.matrixWorld),this.expandByPoint(_vector$b);else void 0!==e.boundingBox?(null===e.boundingBox&&e.computeBoundingBox(),_box$4.copy(e.boundingBox)):(null===r.boundingBox&&r.computeBoundingBox(),_box$4.copy(r.boundingBox)),_box$4.applyMatrix4(e.matrixWorld),this.union(_box$4)}const n=e.children;for(let e=0,r=n.length;e<r;e++)this.expandByObject(n[e],t);return this}containsPoint(e){return e.x>=this.min.x&&e.x<=this.max.x&&e.y>=this.min.y&&e.y<=this.max.y&&e.z>=this.min.z&&e.z<=this.max.z}containsBox(e){return this.min.x<=e.min.x&&e.max.x<=this.max.x&&this.min.y<=e.min.y&&e.max.y<=this.max.y&&this.min.z<=e.min.z&&e.max.z<=this.max.z}getParameter(e,t){return t.set((e.x-this.min.x)/(this.max.x-this.min.x),(e.y-this.min.y)/(this.max.y-this.min.y),(e.z-this.min.z)/(this.max.z-this.min.z))}intersectsBox(e){return e.max.x>=this.min.x&&e.min.x<=this.max.x&&e.max.y>=this.min.y&&e.min.y<=this.max.y&&e.max.z>=this.min.z&&e.min.z<=this.max.z}intersectsSphere(e){return this.clampPoint(e.center,_vector$b),_vector$b.distanceToSquared(e.center)<=e.radius*e.radius}intersectsPlane(e){let t,r;return e.normal.x>0?(t=e.normal.x*this.min.x,r=e.normal.x*this.max.x):(t=e.normal.x*this.max.x,r=e.normal.x*this.min.x),e.normal.y>0?(t+=e.normal.y*this.min.y,r+=e.normal.y*this.max.y):(t+=e.normal.y*this.max.y,r+=e.normal.y*this.min.y),e.normal.z>0?(t+=e.normal.z*this.min.z,r+=e.normal.z*this.max.z):(t+=e.normal.z*this.max.z,r+=e.normal.z*this.min.z),t<=-e.constant&&r>=-e.constant}intersectsTriangle(e){if(this.isEmpty())return!1;this.getCenter(_center),_extents.subVectors(this.max,_center),_v0$3.subVectors(e.a,_center),_v1$7.subVectors(e.b,_center),_v2$4.subVectors(e.c,_center),_f0.subVectors(_v1$7,_v0$3),_f1.subVectors(_v2$4,_v1$7),_f2.subVectors(_v0$3,_v2$4);let t=[0,-_f0.z,_f0.y,0,-_f1.z,_f1.y,0,-_f2.z,_f2.y,_f0.z,0,-_f0.x,_f1.z,0,-_f1.x,_f2.z,0,-_f2.x,-_f0.y,_f0.x,0,-_f1.y,_f1.x,0,-_f2.y,_f2.x,0];return!!satForAxes(t,_v0$3,_v1$7,_v2$4,_extents)&&(t=[1,0,0,0,1,0,0,0,1],!!satForAxes(t,_v0$3,_v1$7,_v2$4,_extents)&&(_triangleNormal.crossVectors(_f0,_f1),t=[_triangleNormal.x,_triangleNormal.y,_triangleNormal.z],satForAxes(t,_v0$3,_v1$7,_v2$4,_extents)))}clampPoint(e,t){return t.copy(e).clamp(this.min,this.max)}distanceToPoint(e){return this.clampPoint(e,_vector$b).distanceTo(e)}getBoundingSphere(e){return this.isEmpty()?e.makeEmpty():(this.getCenter(e.center),e.radius=.5*this.getSize(_vector$b).length()),e}intersect(e){return this.min.max(e.min),this.max.min(e.max),this.isEmpty()&&this.makeEmpty(),this}union(e){return this.min.min(e.min),this.max.max(e.max),this}applyMatrix4(e){return this.isEmpty()||(_points[0].set(this.min.x,this.min.y,this.min.z).applyMatrix4(e),_points[1].set(this.min.x,this.min.y,this.max.z).applyMatrix4(e),_points[2].set(this.min.x,this.max.y,this.min.z).applyMatrix4(e),_points[3].set(this.min.x,this.max.y,this.max.z).applyMatrix4(e),_points[4].set(this.max.x,this.min.y,this.min.z).applyMatrix4(e),_points[5].set(this.max.x,this.min.y,this.max.z).applyMatrix4(e),_points[6].set(this.max.x,this.max.y,this.min.z).applyMatrix4(e),_points[7].set(this.max.x,this.max.y,this.max.z).applyMatrix4(e),this.setFromPoints(_points)),this}translate(e){return this.min.add(e),this.max.add(e),this}equals(e){return e.min.equals(this.min)&&e.max.equals(this.max)}}const _points=[new Vector3,new Vector3,new Vector3,new Vector3,new Vector3,new Vector3,new Vector3,new Vector3],_vector$b=new Vector3,_box$4=new Box3,_v0$3=new Vector3,_v1$7=new Vector3,_v2$4=new Vector3,_f0=new Vector3,_f1=new Vector3,_f2=new Vector3,_center=new Vector3,_extents=new Vector3,_triangleNormal=new Vector3,_testAxis=new Vector3;function satForAxes(e,t,r,n,i){for(let a=0,s=e.length-3;a<=s;a+=3){_testAxis.fromArray(e,a);const s=i.x*Math.abs(_testAxis.x)+i.y*Math.abs(_testAxis.y)+i.z*Math.abs(_testAxis.z),o=t.dot(_testAxis),l=r.dot(_testAxis),c=n.dot(_testAxis);if(Math.max(-Math.max(o,l,c),Math.min(o,l,c))>s)return!1}return!0}const _box$3=new Box3,_v1$6=new Vector3,_v2$3=new Vector3;class Sphere{constructor(e=new Vector3,t=-1){this.isSphere=!0,this.center=e,this.radius=t}set(e,t){return this.center.copy(e),this.radius=t,this}setFromPoints(e,t){const r=this.center;void 0!==t?r.copy(t):_box$3.setFromPoints(e).getCenter(r);let n=0;for(let t=0,i=e.length;t<i;t++)n=Math.max(n,r.distanceToSquared(e[t]));return this.radius=Math.sqrt(n),this}copy(e){return this.center.copy(e.center),this.radius=e.radius,this}isEmpty(){return this.radius<0}makeEmpty(){return this.center.set(0,0,0),this.radius=-1,this}containsPoint(e){return e.distanceToSquared(this.center)<=this.radius*this.radius}distanceToPoint(e){return e.distanceTo(this.center)-this.radius}intersectsSphere(e){const t=this.radius+e.radius;return e.center.distanceToSquared(this.center)<=t*t}intersectsBox(e){return e.intersectsSphere(this)}intersectsPlane(e){return Math.abs(e.distanceToPoint(this.center))<=this.radius}clampPoint(e,t){const r=this.center.distanceToSquared(e);return t.copy(e),r>this.radius*this.radius&&(t.sub(this.center).normalize(),t.multiplyScalar(this.radius).add(this.center)),t}getBoundingBox(e){return this.isEmpty()?(e.makeEmpty(),e):(e.set(this.center,this.center),e.expandByScalar(this.radius),e)}applyMatrix4(e){return this.center.applyMatrix4(e),this.radius=this.radius*e.getMaxScaleOnAxis(),this}translate(e){return this.center.add(e),this}expandByPoint(e){if(this.isEmpty())return this.center.copy(e),this.radius=0,this;_v1$6.subVectors(e,this.center);const t=_v1$6.lengthSq();if(t>this.radius*this.radius){const e=Math.sqrt(t),r=.5*(e-this.radius);this.center.addScaledVector(_v1$6,r/e),this.radius+=r}return this}union(e){return e.isEmpty()?this:this.isEmpty()?(this.copy(e),this):(!0===this.center.equals(e.center)?this.radius=Math.max(this.radius,e.radius):(_v2$3.subVectors(e.center,this.center).setLength(e.radius),this.expandByPoint(_v1$6.copy(e.center).add(_v2$3)),this.expandByPoint(_v1$6.copy(e.center).sub(_v2$3))),this)}equals(e){return e.center.equals(this.center)&&e.radius===this.radius}clone(){return(new this.constructor).copy(this)}}const _vector$a=new Vector3,_segCenter=new Vector3,_segDir=new Vector3,_diff=new Vector3,_edge1=new Vector3,_edge2=new Vector3,_normal$1=new Vector3;class Ray{constructor(e=new Vector3,t=new Vector3(0,0,-1)){this.origin=e,this.direction=t}set(e,t){return this.origin.copy(e),this.direction.copy(t),this}copy(e){return this.origin.copy(e.origin),this.direction.copy(e.direction),this}at(e,t){return t.copy(this.origin).addScaledVector(this.direction,e)}lookAt(e){return this.direction.copy(e).sub(this.origin).normalize(),this}recast(e){return this.origin.copy(this.at(e,_vector$a)),this}closestPointToPoint(e,t){t.subVectors(e,this.origin);const r=t.dot(this.direction);return r<0?t.copy(this.origin):t.copy(this.origin).addScaledVector(this.direction,r)}distanceToPoint(e){return Math.sqrt(this.distanceSqToPoint(e))}distanceSqToPoint(e){const t=_vector$a.subVectors(e,this.origin).dot(this.direction);return t<0?this.origin.distanceToSquared(e):(_vector$a.copy(this.origin).addScaledVector(this.direction,t),_vector$a.distanceToSquared(e))}distanceSqToSegment(e,t,r,n){_segCenter.copy(e).add(t).multiplyScalar(.5),_segDir.copy(t).sub(e).normalize(),_diff.copy(this.origin).sub(_segCenter);const i=.5*e.distanceTo(t),a=-this.direction.dot(_segDir),s=_diff.dot(this.direction),o=-_diff.dot(_segDir),l=_diff.lengthSq(),c=Math.abs(1-a*a);let h,u,d,p;if(c>0)if(h=a*o-s,u=a*s-o,p=i*c,h>=0)if(u>=-p)if(u<=p){const e=1/c;h*=e,u*=e,d=h*(h+a*u+2*s)+u*(a*h+u+2*o)+l}else u=i,h=Math.max(0,-(a*u+s)),d=-h*h+u*(u+2*o)+l;else u=-i,h=Math.max(0,-(a*u+s)),d=-h*h+u*(u+2*o)+l;else u<=-p?(h=Math.max(0,-(-a*i+s)),u=h>0?-i:Math.min(Math.max(-i,-o),i),d=-h*h+u*(u+2*o)+l):u<=p?(h=0,u=Math.min(Math.max(-i,-o),i),d=u*(u+2*o)+l):(h=Math.max(0,-(a*i+s)),u=h>0?i:Math.min(Math.max(-i,-o),i),d=-h*h+u*(u+2*o)+l);else u=a>0?-i:i,h=Math.max(0,-(a*u+s)),d=-h*h+u*(u+2*o)+l;return r&&r.copy(this.origin).addScaledVector(this.direction,h),n&&n.copy(_segCenter).addScaledVector(_segDir,u),d}intersectSphere(e,t){_vector$a.subVectors(e.center,this.origin);const r=_vector$a.dot(this.direction),n=_vector$a.dot(_vector$a)-r*r,i=e.radius*e.radius;if(n>i)return null;const a=Math.sqrt(i-n),s=r-a,o=r+a;return o<0?null:s<0?this.at(o,t):this.at(s,t)}intersectsSphere(e){return this.distanceSqToPoint(e.center)<=e.radius*e.radius}distanceToPlane(e){const t=e.normal.dot(this.direction);if(0===t)return 0===e.distanceToPoint(this.origin)?0:null;const r=-(this.origin.dot(e.normal)+e.constant)/t;return r>=0?r:null}intersectPlane(e,t){const r=this.distanceToPlane(e);return null===r?null:this.at(r,t)}intersectsPlane(e){const t=e.distanceToPoint(this.origin);if(0===t)return!0;return e.normal.dot(this.direction)*t<0}intersectBox(e,t){let r,n,i,a,s,o;const l=1/this.direction.x,c=1/this.direction.y,h=1/this.direction.z,u=this.origin;return l>=0?(r=(e.min.x-u.x)*l,n=(e.max.x-u.x)*l):(r=(e.max.x-u.x)*l,n=(e.min.x-u.x)*l),c>=0?(i=(e.min.y-u.y)*c,a=(e.max.y-u.y)*c):(i=(e.max.y-u.y)*c,a=(e.min.y-u.y)*c),r>a||i>n?null:((i>r||isNaN(r))&&(r=i),(a<n||isNaN(n))&&(n=a),h>=0?(s=(e.min.z-u.z)*h,o=(e.max.z-u.z)*h):(s=(e.max.z-u.z)*h,o=(e.min.z-u.z)*h),r>o||s>n?null:((s>r||r!=r)&&(r=s),(o<n||n!=n)&&(n=o),n<0?null:this.at(r>=0?r:n,t)))}intersectsBox(e){return null!==this.intersectBox(e,_vector$a)}intersectTriangle(e,t,r,n,i){_edge1.subVectors(t,e),_edge2.subVectors(r,e),_normal$1.crossVectors(_edge1,_edge2);let a,s=this.direction.dot(_normal$1);if(s>0){if(n)return null;a=1}else{if(!(s<0))return null;a=-1,s=-s}_diff.subVectors(this.origin,e);const o=a*this.direction.dot(_edge2.crossVectors(_diff,_edge2));if(o<0)return null;const l=a*this.direction.dot(_edge1.cross(_diff));if(l<0)return null;if(o+l>s)return null;const c=-a*_diff.dot(_normal$1);return c<0?null:this.at(c/s,i)}applyMatrix4(e){return this.origin.applyMatrix4(e),this.direction.transformDirection(e),this}equals(e){return e.origin.equals(this.origin)&&e.direction.equals(this.direction)}clone(){return(new this.constructor).copy(this)}}class Matrix4{constructor(e,t,r,n,i,a,s,o,l,c,h,u,d,p,m,f){Matrix4.prototype.isMatrix4=!0,this.elements=[1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1],void 0!==e&&this.set(e,t,r,n,i,a,s,o,l,c,h,u,d,p,m,f)}set(e,t,r,n,i,a,s,o,l,c,h,u,d,p,m,f){const g=this.elements;return g[0]=e,g[4]=t,g[8]=r,g[12]=n,g[1]=i,g[5]=a,g[9]=s,g[13]=o,g[2]=l,g[6]=c,g[10]=h,g[14]=u,g[3]=d,g[7]=p,g[11]=m,g[15]=f,this}identity(){return this.set(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1),this}clone(){return(new Matrix4).fromArray(this.elements)}copy(e){const t=this.elements,r=e.elements;return t[0]=r[0],t[1]=r[1],t[2]=r[2],t[3]=r[3],t[4]=r[4],t[5]=r[5],t[6]=r[6],t[7]=r[7],t[8]=r[8],t[9]=r[9],t[10]=r[10],t[11]=r[11],t[12]=r[12],t[13]=r[13],t[14]=r[14],t[15]=r[15],this}copyPosition(e){const t=this.elements,r=e.elements;return t[12]=r[12],t[13]=r[13],t[14]=r[14],this}setFromMatrix3(e){const t=e.elements;return this.set(t[0],t[3],t[6],0,t[1],t[4],t[7],0,t[2],t[5],t[8],0,0,0,0,1),this}extractBasis(e,t,r){return e.setFromMatrixColumn(this,0),t.setFromMatrixColumn(this,1),r.setFromMatrixColumn(this,2),this}makeBasis(e,t,r){return this.set(e.x,t.x,r.x,0,e.y,t.y,r.y,0,e.z,t.z,r.z,0,0,0,0,1),this}extractRotation(e){const t=this.elements,r=e.elements,n=1/_v1$5.setFromMatrixColumn(e,0).length(),i=1/_v1$5.setFromMatrixColumn(e,1).length(),a=1/_v1$5.setFromMatrixColumn(e,2).length();return t[0]=r[0]*n,t[1]=r[1]*n,t[2]=r[2]*n,t[3]=0,t[4]=r[4]*i,t[5]=r[5]*i,t[6]=r[6]*i,t[7]=0,t[8]=r[8]*a,t[9]=r[9]*a,t[10]=r[10]*a,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,this}makeRotationFromEuler(e){const t=this.elements,r=e.x,n=e.y,i=e.z,a=Math.cos(r),s=Math.sin(r),o=Math.cos(n),l=Math.sin(n),c=Math.cos(i),h=Math.sin(i);if("XYZ"===e.order){const e=a*c,r=a*h,n=s*c,i=s*h;t[0]=o*c,t[4]=-o*h,t[8]=l,t[1]=r+n*l,t[5]=e-i*l,t[9]=-s*o,t[2]=i-e*l,t[6]=n+r*l,t[10]=a*o}else if("YXZ"===e.order){const e=o*c,r=o*h,n=l*c,i=l*h;t[0]=e+i*s,t[4]=n*s-r,t[8]=a*l,t[1]=a*h,t[5]=a*c,t[9]=-s,t[2]=r*s-n,t[6]=i+e*s,t[10]=a*o}else if("ZXY"===e.order){const e=o*c,r=o*h,n=l*c,i=l*h;t[0]=e-i*s,t[4]=-a*h,t[8]=n+r*s,t[1]=r+n*s,t[5]=a*c,t[9]=i-e*s,t[2]=-a*l,t[6]=s,t[10]=a*o}else if("ZYX"===e.order){const e=a*c,r=a*h,n=s*c,i=s*h;t[0]=o*c,t[4]=n*l-r,t[8]=e*l+i,t[1]=o*h,t[5]=i*l+e,t[9]=r*l-n,t[2]=-l,t[6]=s*o,t[10]=a*o}else if("YZX"===e.order){const e=a*o,r=a*l,n=s*o,i=s*l;t[0]=o*c,t[4]=i-e*h,t[8]=n*h+r,t[1]=h,t[5]=a*c,t[9]=-s*c,t[2]=-l*c,t[6]=r*h+n,t[10]=e-i*h}else if("XZY"===e.order){const e=a*o,r=a*l,n=s*o,i=s*l;t[0]=o*c,t[4]=-h,t[8]=l*c,t[1]=e*h+i,t[5]=a*c,t[9]=r*h-n,t[2]=n*h-r,t[6]=s*c,t[10]=i*h+e}return t[3]=0,t[7]=0,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,this}makeRotationFromQuaternion(e){return this.compose(_zero,e,_one)}lookAt(e,t,r){const n=this.elements;return _z.subVectors(e,t),0===_z.lengthSq()&&(_z.z=1),_z.normalize(),_x.crossVectors(r,_z),0===_x.lengthSq()&&(1===Math.abs(r.z)?_z.x+=1e-4:_z.z+=1e-4,_z.normalize(),_x.crossVectors(r,_z)),_x.normalize(),_y.crossVectors(_z,_x),n[0]=_x.x,n[4]=_y.x,n[8]=_z.x,n[1]=_x.y,n[5]=_y.y,n[9]=_z.y,n[2]=_x.z,n[6]=_y.z,n[10]=_z.z,this}multiply(e){return this.multiplyMatrices(this,e)}premultiply(e){return this.multiplyMatrices(e,this)}multiplyMatrices(e,t){const r=e.elements,n=t.elements,i=this.elements,a=r[0],s=r[4],o=r[8],l=r[12],c=r[1],h=r[5],u=r[9],d=r[13],p=r[2],m=r[6],f=r[10],g=r[14],_=r[3],v=r[7],x=r[11],y=r[15],M=n[0],S=n[4],b=n[8],T=n[12],E=n[1],A=n[5],w=n[9],C=n[13],R=n[2],L=n[6],P=n[10],I=n[14],U=n[3],D=n[7],N=n[11],B=n[15];return i[0]=a*M+s*E+o*R+l*U,i[4]=a*S+s*A+o*L+l*D,i[8]=a*b+s*w+o*P+l*N,i[12]=a*T+s*C+o*I+l*B,i[1]=c*M+h*E+u*R+d*U,i[5]=c*S+h*A+u*L+d*D,i[9]=c*b+h*w+u*P+d*N,i[13]=c*T+h*C+u*I+d*B,i[2]=p*M+m*E+f*R+g*U,i[6]=p*S+m*A+f*L+g*D,i[10]=p*b+m*w+f*P+g*N,i[14]=p*T+m*C+f*I+g*B,i[3]=_*M+v*E+x*R+y*U,i[7]=_*S+v*A+x*L+y*D,i[11]=_*b+v*w+x*P+y*N,i[15]=_*T+v*C+x*I+y*B,this}multiplyScalar(e){const t=this.elements;return t[0]*=e,t[4]*=e,t[8]*=e,t[12]*=e,t[1]*=e,t[5]*=e,t[9]*=e,t[13]*=e,t[2]*=e,t[6]*=e,t[10]*=e,t[14]*=e,t[3]*=e,t[7]*=e,t[11]*=e,t[15]*=e,this}determinant(){const e=this.elements,t=e[0],r=e[4],n=e[8],i=e[12],a=e[1],s=e[5],o=e[9],l=e[13],c=e[2],h=e[6],u=e[10],d=e[14];return e[3]*(+i*o*h-n*l*h-i*s*u+r*l*u+n*s*d-r*o*d)+e[7]*(+t*o*d-t*l*u+i*a*u-n*a*d+n*l*c-i*o*c)+e[11]*(+t*l*h-t*s*d-i*a*h+r*a*d+i*s*c-r*l*c)+e[15]*(-n*s*c-t*o*h+t*s*u+n*a*h-r*a*u+r*o*c)}transpose(){const e=this.elements;let t;return t=e[1],e[1]=e[4],e[4]=t,t=e[2],e[2]=e[8],e[8]=t,t=e[6],e[6]=e[9],e[9]=t,t=e[3],e[3]=e[12],e[12]=t,t=e[7],e[7]=e[13],e[13]=t,t=e[11],e[11]=e[14],e[14]=t,this}setPosition(e,t,r){const n=this.elements;return e.isVector3?(n[12]=e.x,n[13]=e.y,n[14]=e.z):(n[12]=e,n[13]=t,n[14]=r),this}invert(){const e=this.elements,t=e[0],r=e[1],n=e[2],i=e[3],a=e[4],s=e[5],o=e[6],l=e[7],c=e[8],h=e[9],u=e[10],d=e[11],p=e[12],m=e[13],f=e[14],g=e[15],_=h*f*l-m*u*l+m*o*d-s*f*d-h*o*g+s*u*g,v=p*u*l-c*f*l-p*o*d+a*f*d+c*o*g-a*u*g,x=c*m*l-p*h*l+p*s*d-a*m*d-c*s*g+a*h*g,y=p*h*o-c*m*o-p*s*u+a*m*u+c*s*f-a*h*f,M=t*_+r*v+n*x+i*y;if(0===M)return this.set(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);const S=1/M;return e[0]=_*S,e[1]=(m*u*i-h*f*i-m*n*d+r*f*d+h*n*g-r*u*g)*S,e[2]=(s*f*i-m*o*i+m*n*l-r*f*l-s*n*g+r*o*g)*S,e[3]=(h*o*i-s*u*i-h*n*l+r*u*l+s*n*d-r*o*d)*S,e[4]=v*S,e[5]=(c*f*i-p*u*i+p*n*d-t*f*d-c*n*g+t*u*g)*S,e[6]=(p*o*i-a*f*i-p*n*l+t*f*l+a*n*g-t*o*g)*S,e[7]=(a*u*i-c*o*i+c*n*l-t*u*l-a*n*d+t*o*d)*S,e[8]=x*S,e[9]=(p*h*i-c*m*i-p*r*d+t*m*d+c*r*g-t*h*g)*S,e[10]=(a*m*i-p*s*i+p*r*l-t*m*l-a*r*g+t*s*g)*S,e[11]=(c*s*i-a*h*i-c*r*l+t*h*l+a*r*d-t*s*d)*S,e[12]=y*S,e[13]=(c*m*n-p*h*n+p*r*u-t*m*u-c*r*f+t*h*f)*S,e[14]=(p*s*n-a*m*n-p*r*o+t*m*o+a*r*f-t*s*f)*S,e[15]=(a*h*n-c*s*n+c*r*o-t*h*o-a*r*u+t*s*u)*S,this}scale(e){const t=this.elements,r=e.x,n=e.y,i=e.z;return t[0]*=r,t[4]*=n,t[8]*=i,t[1]*=r,t[5]*=n,t[9]*=i,t[2]*=r,t[6]*=n,t[10]*=i,t[3]*=r,t[7]*=n,t[11]*=i,this}getMaxScaleOnAxis(){const e=this.elements,t=e[0]*e[0]+e[1]*e[1]+e[2]*e[2],r=e[4]*e[4]+e[5]*e[5]+e[6]*e[6],n=e[8]*e[8]+e[9]*e[9]+e[10]*e[10];return Math.sqrt(Math.max(t,r,n))}makeTranslation(e,t,r){return e.isVector3?this.set(1,0,0,e.x,0,1,0,e.y,0,0,1,e.z,0,0,0,1):this.set(1,0,0,e,0,1,0,t,0,0,1,r,0,0,0,1),this}makeRotationX(e){const t=Math.cos(e),r=Math.sin(e);return this.set(1,0,0,0,0,t,-r,0,0,r,t,0,0,0,0,1),this}makeRotationY(e){const t=Math.cos(e),r=Math.sin(e);return this.set(t,0,r,0,0,1,0,0,-r,0,t,0,0,0,0,1),this}makeRotationZ(e){const t=Math.cos(e),r=Math.sin(e);return this.set(t,-r,0,0,r,t,0,0,0,0,1,0,0,0,0,1),this}makeRotationAxis(e,t){const r=Math.cos(t),n=Math.sin(t),i=1-r,a=e.x,s=e.y,o=e.z,l=i*a,c=i*s;return this.set(l*a+r,l*s-n*o,l*o+n*s,0,l*s+n*o,c*s+r,c*o-n*a,0,l*o-n*s,c*o+n*a,i*o*o+r,0,0,0,0,1),this}makeScale(e,t,r){return this.set(e,0,0,0,0,t,0,0,0,0,r,0,0,0,0,1),this}makeShear(e,t,r,n,i,a){return this.set(1,r,i,0,e,1,a,0,t,n,1,0,0,0,0,1),this}compose(e,t,r){const n=this.elements,i=t._x,a=t._y,s=t._z,o=t._w,l=i+i,c=a+a,h=s+s,u=i*l,d=i*c,p=i*h,m=a*c,f=a*h,g=s*h,_=o*l,v=o*c,x=o*h,y=r.x,M=r.y,S=r.z;return n[0]=(1-(m+g))*y,n[1]=(d+x)*y,n[2]=(p-v)*y,n[3]=0,n[4]=(d-x)*M,n[5]=(1-(u+g))*M,n[6]=(f+_)*M,n[7]=0,n[8]=(p+v)*S,n[9]=(f-_)*S,n[10]=(1-(u+m))*S,n[11]=0,n[12]=e.x,n[13]=e.y,n[14]=e.z,n[15]=1,this}decompose(e,t,r){const n=this.elements;let i=_v1$5.set(n[0],n[1],n[2]).length();const a=_v1$5.set(n[4],n[5],n[6]).length(),s=_v1$5.set(n[8],n[9],n[10]).length();this.determinant()<0&&(i=-i),e.x=n[12],e.y=n[13],e.z=n[14],_m1$4.copy(this);const o=1/i,l=1/a,c=1/s;return _m1$4.elements[0]*=o,_m1$4.elements[1]*=o,_m1$4.elements[2]*=o,_m1$4.elements[4]*=l,_m1$4.elements[5]*=l,_m1$4.elements[6]*=l,_m1$4.elements[8]*=c,_m1$4.elements[9]*=c,_m1$4.elements[10]*=c,t.setFromRotationMatrix(_m1$4),r.x=i,r.y=a,r.z=s,this}makePerspective(e,t,r,n,i,a,s=2e3){const o=this.elements,l=2*i/(t-e),c=2*i/(r-n),h=(t+e)/(t-e),u=(r+n)/(r-n);let d,p;if(2e3===s)d=-(a+i)/(a-i),p=-2*a*i/(a-i);else{if(2001!==s)throw new Error("THREE.Matrix4.makePerspective(): Invalid coordinate system: "+s);d=-a/(a-i),p=-a*i/(a-i)}return o[0]=l,o[4]=0,o[8]=h,o[12]=0,o[1]=0,o[5]=c,o[9]=u,o[13]=0,o[2]=0,o[6]=0,o[10]=d,o[14]=p,o[3]=0,o[7]=0,o[11]=-1,o[15]=0,this}makeOrthographic(e,t,r,n,i,a,s=2e3){const o=this.elements,l=1/(t-e),c=1/(r-n),h=1/(a-i),u=(t+e)*l,d=(r+n)*c;let p,m;if(2e3===s)p=(a+i)*h,m=-2*h;else{if(2001!==s)throw new Error("THREE.Matrix4.makeOrthographic(): Invalid coordinate system: "+s);p=i*h,m=-1*h}return o[0]=2*l,o[4]=0,o[8]=0,o[12]=-u,o[1]=0,o[5]=2*c,o[9]=0,o[13]=-d,o[2]=0,o[6]=0,o[10]=m,o[14]=-p,o[3]=0,o[7]=0,o[11]=0,o[15]=1,this}equals(e){const t=this.elements,r=e.elements;for(let e=0;e<16;e++)if(t[e]!==r[e])return!1;return!0}fromArray(e,t=0){for(let r=0;r<16;r++)this.elements[r]=e[r+t];return this}toArray(e=[],t=0){const r=this.elements;return e[t]=r[0],e[t+1]=r[1],e[t+2]=r[2],e[t+3]=r[3],e[t+4]=r[4],e[t+5]=r[5],e[t+6]=r[6],e[t+7]=r[7],e[t+8]=r[8],e[t+9]=r[9],e[t+10]=r[10],e[t+11]=r[11],e[t+12]=r[12],e[t+13]=r[13],e[t+14]=r[14],e[t+15]=r[15],e}}const _v1$5=new Vector3,_m1$4=new Matrix4,_zero=new Vector3(0,0,0),_one=new Vector3(1,1,1),_x=new Vector3,_y=new Vector3,_z=new Vector3,_matrix$2=new Matrix4,_quaternion$3=new Quaternion;class Euler{constructor(e=0,t=0,r=0,n=Euler.DEFAULT_ORDER){this.isEuler=!0,this._x=e,this._y=t,this._z=r,this._order=n}get x(){return this._x}set x(e){this._x=e,this._onChangeCallback()}get y(){return this._y}set y(e){this._y=e,this._onChangeCallback()}get z(){return this._z}set z(e){this._z=e,this._onChangeCallback()}get order(){return this._order}set order(e){this._order=e,this._onChangeCallback()}set(e,t,r,n=this._order){return this._x=e,this._y=t,this._z=r,this._order=n,this._onChangeCallback(),this}clone(){return new this.constructor(this._x,this._y,this._z,this._order)}copy(e){return this._x=e._x,this._y=e._y,this._z=e._z,this._order=e._order,this._onChangeCallback(),this}setFromRotationMatrix(e,t=this._order,r=!0){const n=e.elements,i=n[0],a=n[4],s=n[8],o=n[1],l=n[5],c=n[9],h=n[2],u=n[6],d=n[10];switch(t){case"XYZ":this._y=Math.asin(clamp(s,-1,1)),Math.abs(s)<.9999999?(this._x=Math.atan2(-c,d),this._z=Math.atan2(-a,i)):(this._x=Math.atan2(u,l),this._z=0);break;case"YXZ":this._x=Math.asin(-clamp(c,-1,1)),Math.abs(c)<.9999999?(this._y=Math.atan2(s,d),this._z=Math.atan2(o,l)):(this._y=Math.atan2(-h,i),this._z=0);break;case"ZXY":this._x=Math.asin(clamp(u,-1,1)),Math.abs(u)<.9999999?(this._y=Math.atan2(-h,d),this._z=Math.atan2(-a,l)):(this._y=0,this._z=Math.atan2(o,i));break;case"ZYX":this._y=Math.asin(-clamp(h,-1,1)),Math.abs(h)<.9999999?(this._x=Math.atan2(u,d),this._z=Math.atan2(o,i)):(this._x=0,this._z=Math.atan2(-a,l));break;case"YZX":this._z=Math.asin(clamp(o,-1,1)),Math.abs(o)<.9999999?(this._x=Math.atan2(-c,l),this._y=Math.atan2(-h,i)):(this._x=0,this._y=Math.atan2(s,d));break;case"XZY":this._z=Math.asin(-clamp(a,-1,1)),Math.abs(a)<.9999999?(this._x=Math.atan2(u,l),this._y=Math.atan2(s,i)):(this._x=Math.atan2(-c,d),this._y=0);break;default:console.warn("THREE.Euler: .setFromRotationMatrix() encountered an unknown order: "+t)}return this._order=t,!0===r&&this._onChangeCallback(),this}setFromQuaternion(e,t,r){return _matrix$2.makeRotationFromQuaternion(e),this.setFromRotationMatrix(_matrix$2,t,r)}setFromVector3(e,t=this._order){return this.set(e.x,e.y,e.z,t)}reorder(e){return _quaternion$3.setFromEuler(this),this.setFromQuaternion(_quaternion$3,e)}equals(e){return e._x===this._x&&e._y===this._y&&e._z===this._z&&e._order===this._order}fromArray(e){return this._x=e[0],this._y=e[1],this._z=e[2],void 0!==e[3]&&(this._order=e[3]),this._onChangeCallback(),this}toArray(e=[],t=0){return e[t]=this._x,e[t+1]=this._y,e[t+2]=this._z,e[t+3]=this._order,e}_onChange(e){return this._onChangeCallback=e,this}_onChangeCallback(){}*[Symbol.iterator](){yield this._x,yield this._y,yield this._z,yield this._order}}Euler.DEFAULT_ORDER="XYZ";class Layers{constructor(){this.mask=1}set(e){this.mask=1<<e>>>0}enable(e){this.mask|=1<<e}enableAll(){this.mask=-1}toggle(e){this.mask^=1<<e}disable(e){this.mask&=~(1<<e)}disableAll(){this.mask=0}test(e){return!!(this.mask&e.mask)}isEnabled(e){return!!(this.mask&1<<e)}}let _object3DId=0;const _v1$4=new Vector3,_q1=new Quaternion,_m1$3=new Matrix4,_target=new Vector3,_position$3=new Vector3,_scale$2=new Vector3,_quaternion$2=new Quaternion,_xAxis=new Vector3(1,0,0),_yAxis=new Vector3(0,1,0),_zAxis=new Vector3(0,0,1),_addedEvent={type:"added"},_removedEvent={type:"removed"},_childaddedEvent={type:"childadded",child:null},_childremovedEvent={type:"childremoved",child:null};class Object3D extends EventDispatcher{constructor(){super(),this.isObject3D=!0,Object.defineProperty(this,"id",{value:_object3DId++}),this.uuid=generateUUID(),this.name="",this.type="Object3D",this.parent=null,this.children=[],this.up=Object3D.DEFAULT_UP.clone();const e=new Vector3,t=new Euler,r=new Quaternion,n=new Vector3(1,1,1);t._onChange((function(){r.setFromEuler(t,!1)})),r._onChange((function(){t.setFromQuaternion(r,void 0,!1)})),Object.defineProperties(this,{position:{configurable:!0,enumerable:!0,value:e},rotation:{configurable:!0,enumerable:!0,value:t},quaternion:{configurable:!0,enumerable:!0,value:r},scale:{configurable:!0,enumerable:!0,value:n},modelViewMatrix:{value:new Matrix4},normalMatrix:{value:new Matrix3}}),this.matrix=new Matrix4,this.matrixWorld=new Matrix4,this.matrixAutoUpdate=Object3D.DEFAULT_MATRIX_AUTO_UPDATE,this.matrixWorldAutoUpdate=Object3D.DEFAULT_MATRIX_WORLD_AUTO_UPDATE,this.matrixWorldNeedsUpdate=!1,this.layers=new Layers,this.visible=!0,this.castShadow=!1,this.receiveShadow=!1,this.frustumCulled=!0,this.renderOrder=0,this.animations=[],this.customDepthMaterial=void 0,this.customDistanceMaterial=void 0,this.userData={}}onBeforeShadow(){}onAfterShadow(){}onBeforeRender(){}onAfterRender(){}applyMatrix4(e){this.matrixAutoUpdate&&this.updateMatrix(),this.matrix.premultiply(e),this.matrix.decompose(this.position,this.quaternion,this.scale)}applyQuaternion(e){return this.quaternion.premultiply(e),this}setRotationFromAxisAngle(e,t){this.quaternion.setFromAxisAngle(e,t)}setRotationFromEuler(e){this.quaternion.setFromEuler(e,!0)}setRotationFromMatrix(e){this.quaternion.setFromRotationMatrix(e)}setRotationFromQuaternion(e){this.quaternion.copy(e)}rotateOnAxis(e,t){return _q1.setFromAxisAngle(e,t),this.quaternion.multiply(_q1),this}rotateOnWorldAxis(e,t){return _q1.setFromAxisAngle(e,t),this.quaternion.premultiply(_q1),this}rotateX(e){return this.rotateOnAxis(_xAxis,e)}rotateY(e){return this.rotateOnAxis(_yAxis,e)}rotateZ(e){return this.rotateOnAxis(_zAxis,e)}translateOnAxis(e,t){return _v1$4.copy(e).applyQuaternion(this.quaternion),this.position.add(_v1$4.multiplyScalar(t)),this}translateX(e){return this.translateOnAxis(_xAxis,e)}translateY(e){return this.translateOnAxis(_yAxis,e)}translateZ(e){return this.translateOnAxis(_zAxis,e)}localToWorld(e){return this.updateWorldMatrix(!0,!1),e.applyMatrix4(this.matrixWorld)}worldToLocal(e){return this.updateWorldMatrix(!0,!1),e.applyMatrix4(_m1$3.copy(this.matrixWorld).invert())}lookAt(e,t,r){e.isVector3?_target.copy(e):_target.set(e,t,r);const n=this.parent;this.updateWorldMatrix(!0,!1),_position$3.setFromMatrixPosition(this.matrixWorld),this.isCamera||this.isLight?_m1$3.lookAt(_position$3,_target,this.up):_m1$3.lookAt(_target,_position$3,this.up),this.quaternion.setFromRotationMatrix(_m1$3),n&&(_m1$3.extractRotation(n.matrixWorld),_q1.setFromRotationMatrix(_m1$3),this.quaternion.premultiply(_q1.invert()))}add(e){if(arguments.length>1){for(let e=0;e<arguments.length;e++)this.add(arguments[e]);return this}return e===this?(console.error("THREE.Object3D.add: object can't be added as a child of itself.",e),this):(e&&e.isObject3D?(e.removeFromParent(),e.parent=this,this.children.push(e),e.dispatchEvent(_addedEvent),_childaddedEvent.child=e,this.dispatchEvent(_childaddedEvent),_childaddedEvent.child=null):console.error("THREE.Object3D.add: object not an instance of THREE.Object3D.",e),this)}remove(e){if(arguments.length>1){for(let e=0;e<arguments.length;e++)this.remove(arguments[e]);return this}const t=this.children.indexOf(e);return-1!==t&&(e.parent=null,this.children.splice(t,1),e.dispatchEvent(_removedEvent),_childremovedEvent.child=e,this.dispatchEvent(_childremovedEvent),_childremovedEvent.child=null),this}removeFromParent(){const e=this.parent;return null!==e&&e.remove(this),this}clear(){return this.remove(...this.children)}attach(e){return this.updateWorldMatrix(!0,!1),_m1$3.copy(this.matrixWorld).invert(),null!==e.parent&&(e.parent.updateWorldMatrix(!0,!1),_m1$3.multiply(e.parent.matrixWorld)),e.applyMatrix4(_m1$3),e.removeFromParent(),e.parent=this,this.children.push(e),e.updateWorldMatrix(!1,!0),e.dispatchEvent(_addedEvent),_childaddedEvent.child=e,this.dispatchEvent(_childaddedEvent),_childaddedEvent.child=null,this}getObjectById(e){return this.getObjectByProperty("id",e)}getObjectByName(e){return this.getObjectByProperty("name",e)}getObjectByProperty(e,t){if(this[e]===t)return this;for(let r=0,n=this.children.length;r<n;r++){const n=this.children[r].getObjectByProperty(e,t);if(void 0!==n)return n}}getObjectsByProperty(e,t,r=[]){this[e]===t&&r.push(this);const n=this.children;for(let i=0,a=n.length;i<a;i++)n[i].getObjectsByProperty(e,t,r);return r}getWorldPosition(e){return this.updateWorldMatrix(!0,!1),e.setFromMatrixPosition(this.matrixWorld)}getWorldQuaternion(e){return this.updateWorldMatrix(!0,!1),this.matrixWorld.decompose(_position$3,e,_scale$2),e}getWorldScale(e){return this.updateWorldMatrix(!0,!1),this.matrixWorld.decompose(_position$3,_quaternion$2,e),e}getWorldDirection(e){this.updateWorldMatrix(!0,!1);const t=this.matrixWorld.elements;return e.set(t[8],t[9],t[10]).normalize()}raycast(){}traverse(e){e(this);const t=this.children;for(let r=0,n=t.length;r<n;r++)t[r].traverse(e)}traverseVisible(e){if(!1===this.visible)return;e(this);const t=this.children;for(let r=0,n=t.length;r<n;r++)t[r].traverseVisible(e)}traverseAncestors(e){const t=this.parent;null!==t&&(e(t),t.traverseAncestors(e))}updateMatrix(){this.matrix.compose(this.position,this.quaternion,this.scale),this.matrixWorldNeedsUpdate=!0}updateMatrixWorld(e){this.matrixAutoUpdate&&this.updateMatrix(),(this.matrixWorldNeedsUpdate||e)&&(!0===this.matrixWorldAutoUpdate&&(null===this.parent?this.matrixWorld.copy(this.matrix):this.matrixWorld.multiplyMatrices(this.parent.matrixWorld,this.matrix)),this.matrixWorldNeedsUpdate=!1,e=!0);const t=this.children;for(let r=0,n=t.length;r<n;r++){t[r].updateMatrixWorld(e)}}updateWorldMatrix(e,t){const r=this.parent;if(!0===e&&null!==r&&r.updateWorldMatrix(!0,!1),this.matrixAutoUpdate&&this.updateMatrix(),!0===this.matrixWorldAutoUpdate&&(null===this.parent?this.matrixWorld.copy(this.matrix):this.matrixWorld.multiplyMatrices(this.parent.matrixWorld,this.matrix)),!0===t){const e=this.children;for(let t=0,r=e.length;t<r;t++){e[t].updateWorldMatrix(!1,!0)}}}toJSON(e){const t=void 0===e||"string"==typeof e,r={};t&&(e={geometries:{},materials:{},textures:{},images:{},shapes:{},skeletons:{},animations:{},nodes:{}},r.metadata={version:4.6,type:"Object",generator:"Object3D.toJSON"});const n={};function i(t,r){return void 0===t[r.uuid]&&(t[r.uuid]=r.toJSON(e)),r.uuid}if(n.uuid=this.uuid,n.type=this.type,""!==this.name&&(n.name=this.name),!0===this.castShadow&&(n.castShadow=!0),!0===this.receiveShadow&&(n.receiveShadow=!0),!1===this.visible&&(n.visible=!1),!1===this.frustumCulled&&(n.frustumCulled=!1),0!==this.renderOrder&&(n.renderOrder=this.renderOrder),Object.keys(this.userData).length>0&&(n.userData=this.userData),n.layers=this.layers.mask,n.matrix=this.matrix.toArray(),n.up=this.up.toArray(),!1===this.matrixAutoUpdate&&(n.matrixAutoUpdate=!1),this.isInstancedMesh&&(n.type="InstancedMesh",n.count=this.count,n.instanceMatrix=this.instanceMatrix.toJSON(),null!==this.instanceColor&&(n.instanceColor=this.instanceColor.toJSON())),this.isBatchedMesh&&(n.type="BatchedMesh",n.perObjectFrustumCulled=this.perObjectFrustumCulled,n.sortObjects=this.sortObjects,n.drawRanges=this._drawRanges,n.reservedRanges=this._reservedRanges,n.geometryInfo=this._geometryInfo.map((e=>({...e,boundingBox:e.boundingBox?{min:e.boundingBox.min.toArray(),max:e.boundingBox.max.toArray()}:void 0,boundingSphere:e.boundingSphere?{radius:e.boundingSphere.radius,center:e.boundingSphere.center.toArray()}:void 0}))),n.instanceInfo=this._instanceInfo.map((e=>({...e}))),n.availableInstanceIds=this._availableInstanceIds.slice(),n.availableGeometryIds=this._availableGeometryIds.slice(),n.nextIndexStart=this._nextIndexStart,n.nextVertexStart=this._nextVertexStart,n.geometryCount=this._geometryCount,n.maxInstanceCount=this._maxInstanceCount,n.maxVertexCount=this._maxVertexCount,n.maxIndexCount=this._maxIndexCount,n.geometryInitialized=this._geometryInitialized,n.matricesTexture=this._matricesTexture.toJSON(e),n.indirectTexture=this._indirectTexture.toJSON(e),null!==this._colorsTexture&&(n.colorsTexture=this._colorsTexture.toJSON(e)),null!==this.boundingSphere&&(n.boundingSphere={center:this.boundingSphere.center.toArray(),radius:this.boundingSphere.radius}),null!==this.boundingBox&&(n.boundingBox={min:this.boundingBox.min.toArray(),max:this.boundingBox.max.toArray()})),this.isScene)this.background&&(this.background.isColor?n.background=this.background.toJSON():this.background.isTexture&&(n.background=this.background.toJSON(e).uuid)),this.environment&&this.environment.isTexture&&!0!==this.environment.isRenderTargetTexture&&(n.environment=this.environment.toJSON(e).uuid);else if(this.isMesh||this.isLine||this.isPoints){n.geometry=i(e.geometries,this.geometry);const t=this.geometry.parameters;if(void 0!==t&&void 0!==t.shapes){const r=t.shapes;if(Array.isArray(r))for(let t=0,n=r.length;t<n;t++){const n=r[t];i(e.shapes,n)}else i(e.shapes,r)}}if(this.isSkinnedMesh&&(n.bindMode=this.bindMode,n.bindMatrix=this.bindMatrix.toArray(),void 0!==this.skeleton&&(i(e.skeletons,this.skeleton),n.skeleton=this.skeleton.uuid)),void 0!==this.material)if(Array.isArray(this.material)){const t=[];for(let r=0,n=this.material.length;r<n;r++)t.push(i(e.materials,this.material[r]));n.material=t}else n.material=i(e.materials,this.material);if(this.children.length>0){n.children=[];for(let t=0;t<this.children.length;t++)n.children.push(this.children[t].toJSON(e).object)}if(this.animations.length>0){n.animations=[];for(let t=0;t<this.animations.length;t++){const r=this.animations[t];n.animations.push(i(e.animations,r))}}if(t){const t=a(e.geometries),n=a(e.materials),i=a(e.textures),s=a(e.images),o=a(e.shapes),l=a(e.skeletons),c=a(e.animations),h=a(e.nodes);t.length>0&&(r.geometries=t),n.length>0&&(r.materials=n),i.length>0&&(r.textures=i),s.length>0&&(r.images=s),o.length>0&&(r.shapes=o),l.length>0&&(r.skeletons=l),c.length>0&&(r.animations=c),h.length>0&&(r.nodes=h)}return r.object=n,r;function a(e){const t=[];for(const r in e){const n=e[r];delete n.metadata,t.push(n)}return t}}clone(e){return(new this.constructor).copy(this,e)}copy(e,t=!0){if(this.name=e.name,this.up.copy(e.up),this.position.copy(e.position),this.rotation.order=e.rotation.order,this.quaternion.copy(e.quaternion),this.scale.copy(e.scale),this.matrix.copy(e.matrix),this.matrixWorld.copy(e.matrixWorld),this.matrixAutoUpdate=e.matrixAutoUpdate,this.matrixWorldAutoUpdate=e.matrixWorldAutoUpdate,this.matrixWorldNeedsUpdate=e.matrixWorldNeedsUpdate,this.layers.mask=e.layers.mask,this.visible=e.visible,this.castShadow=e.castShadow,this.receiveShadow=e.receiveShadow,this.frustumCulled=e.frustumCulled,this.renderOrder=e.renderOrder,this.animations=e.animations.slice(),this.userData=JSON.parse(JSON.stringify(e.userData)),!0===t)for(let t=0;t<e.children.length;t++){const r=e.children[t];this.add(r.clone())}return this}}Object3D.DEFAULT_UP=new Vector3(0,1,0),Object3D.DEFAULT_MATRIX_AUTO_UPDATE=!0,Object3D.DEFAULT_MATRIX_WORLD_AUTO_UPDATE=!0;const _v0$2=new Vector3,_v1$3=new Vector3,_v2$2=new Vector3,_v3$2=new Vector3,_vab=new Vector3,_vac=new Vector3,_vbc=new Vector3,_vap=new Vector3,_vbp=new Vector3,_vcp=new Vector3,_v40=new Vector4,_v41=new Vector4,_v42=new Vector4;class Triangle{constructor(e=new Vector3,t=new Vector3,r=new Vector3){this.a=e,this.b=t,this.c=r}static getNormal(e,t,r,n){n.subVectors(r,t),_v0$2.subVectors(e,t),n.cross(_v0$2);const i=n.lengthSq();return i>0?n.multiplyScalar(1/Math.sqrt(i)):n.set(0,0,0)}static getBarycoord(e,t,r,n,i){_v0$2.subVectors(n,t),_v1$3.subVectors(r,t),_v2$2.subVectors(e,t);const a=_v0$2.dot(_v0$2),s=_v0$2.dot(_v1$3),o=_v0$2.dot(_v2$2),l=_v1$3.dot(_v1$3),c=_v1$3.dot(_v2$2),h=a*l-s*s;if(0===h)return i.set(0,0,0),null;const u=1/h,d=(l*o-s*c)*u,p=(a*c-s*o)*u;return i.set(1-d-p,p,d)}static containsPoint(e,t,r,n){return null!==this.getBarycoord(e,t,r,n,_v3$2)&&(_v3$2.x>=0&&_v3$2.y>=0&&_v3$2.x+_v3$2.y<=1)}static getInterpolation(e,t,r,n,i,a,s,o){return null===this.getBarycoord(e,t,r,n,_v3$2)?(o.x=0,o.y=0,"z"in o&&(o.z=0),"w"in o&&(o.w=0),null):(o.setScalar(0),o.addScaledVector(i,_v3$2.x),o.addScaledVector(a,_v3$2.y),o.addScaledVector(s,_v3$2.z),o)}static getInterpolatedAttribute(e,t,r,n,i,a){return _v40.setScalar(0),_v41.setScalar(0),_v42.setScalar(0),_v40.fromBufferAttribute(e,t),_v41.fromBufferAttribute(e,r),_v42.fromBufferAttribute(e,n),a.setScalar(0),a.addScaledVector(_v40,i.x),a.addScaledVector(_v41,i.y),a.addScaledVector(_v42,i.z),a}static isFrontFacing(e,t,r,n){return _v0$2.subVectors(r,t),_v1$3.subVectors(e,t),_v0$2.cross(_v1$3).dot(n)<0}set(e,t,r){return this.a.copy(e),this.b.copy(t),this.c.copy(r),this}setFromPointsAndIndices(e,t,r,n){return this.a.copy(e[t]),this.b.copy(e[r]),this.c.copy(e[n]),this}setFromAttributeAndIndices(e,t,r,n){return this.a.fromBufferAttribute(e,t),this.b.fromBufferAttribute(e,r),this.c.fromBufferAttribute(e,n),this}clone(){return(new this.constructor).copy(this)}copy(e){return this.a.copy(e.a),this.b.copy(e.b),this.c.copy(e.c),this}getArea(){return _v0$2.subVectors(this.c,this.b),_v1$3.subVectors(this.a,this.b),.5*_v0$2.cross(_v1$3).length()}getMidpoint(e){return e.addVectors(this.a,this.b).add(this.c).multiplyScalar(1/3)}getNormal(e){return Triangle.getNormal(this.a,this.b,this.c,e)}getPlane(e){return e.setFromCoplanarPoints(this.a,this.b,this.c)}getBarycoord(e,t){return Triangle.getBarycoord(e,this.a,this.b,this.c,t)}getInterpolation(e,t,r,n,i){return Triangle.getInterpolation(e,this.a,this.b,this.c,t,r,n,i)}containsPoint(e){return Triangle.containsPoint(e,this.a,this.b,this.c)}isFrontFacing(e){return Triangle.isFrontFacing(this.a,this.b,this.c,e)}intersectsBox(e){return e.intersectsTriangle(this)}closestPointToPoint(e,t){const r=this.a,n=this.b,i=this.c;let a,s;_vab.subVectors(n,r),_vac.subVectors(i,r),_vap.subVectors(e,r);const o=_vab.dot(_vap),l=_vac.dot(_vap);if(o<=0&&l<=0)return t.copy(r);_vbp.subVectors(e,n);const c=_vab.dot(_vbp),h=_vac.dot(_vbp);if(c>=0&&h<=c)return t.copy(n);const u=o*h-c*l;if(u<=0&&o>=0&&c<=0)return a=o/(o-c),t.copy(r).addScaledVector(_vab,a);_vcp.subVectors(e,i);const d=_vab.dot(_vcp),p=_vac.dot(_vcp);if(p>=0&&d<=p)return t.copy(i);const m=d*l-o*p;if(m<=0&&l>=0&&p<=0)return s=l/(l-p),t.copy(r).addScaledVector(_vac,s);const f=c*p-d*h;if(f<=0&&h-c>=0&&d-p>=0)return _vbc.subVectors(i,n),s=(h-c)/(h-c+(d-p)),t.copy(n).addScaledVector(_vbc,s);const g=1/(f+m+u);return a=m*g,s=u*g,t.copy(r).addScaledVector(_vab,a).addScaledVector(_vac,s)}equals(e){return e.a.equals(this.a)&&e.b.equals(this.b)&&e.c.equals(this.c)}}const _colorKeywords={aliceblue:15792383,antiquewhite:16444375,aqua:65535,aquamarine:8388564,azure:15794175,beige:16119260,bisque:16770244,black:0,blanchedalmond:16772045,blue:255,blueviolet:9055202,brown:10824234,burlywood:14596231,cadetblue:6266528,chartreuse:8388352,chocolate:13789470,coral:16744272,cornflowerblue:6591981,cornsilk:16775388,crimson:14423100,cyan:65535,darkblue:139,darkcyan:35723,darkgoldenrod:12092939,darkgray:11119017,darkgreen:25600,darkgrey:11119017,darkkhaki:12433259,darkmagenta:9109643,darkolivegreen:5597999,darkorange:16747520,darkorchid:10040012,darkred:9109504,darksalmon:15308410,darkseagreen:9419919,darkslateblue:4734347,darkslategray:3100495,darkslategrey:3100495,darkturquoise:52945,darkviolet:9699539,deeppink:16716947,deepskyblue:49151,dimgray:6908265,dimgrey:6908265,dodgerblue:2003199,firebrick:11674146,floralwhite:16775920,forestgreen:2263842,fuchsia:16711935,gainsboro:14474460,ghostwhite:16316671,gold:16766720,goldenrod:14329120,gray:8421504,green:32768,greenyellow:11403055,grey:8421504,honeydew:15794160,hotpink:16738740,indianred:13458524,indigo:4915330,ivory:16777200,khaki:15787660,lavender:15132410,lavenderblush:16773365,lawngreen:8190976,lemonchiffon:16775885,lightblue:11393254,lightcoral:15761536,lightcyan:14745599,lightgoldenrodyellow:16448210,lightgray:13882323,lightgreen:9498256,lightgrey:13882323,lightpink:16758465,lightsalmon:16752762,lightseagreen:2142890,lightskyblue:8900346,lightslategray:7833753,lightslategrey:7833753,lightsteelblue:11584734,lightyellow:16777184,lime:65280,limegreen:3329330,linen:16445670,magenta:16711935,maroon:8388608,mediumaquamarine:6737322,mediumblue:205,mediumorchid:12211667,mediumpurple:9662683,mediumseagreen:3978097,mediumslateblue:8087790,mediumspringgreen:64154,mediumturquoise:4772300,mediumvioletred:13047173,midnightblue:1644912,mintcream:16121850,mistyrose:16770273,moccasin:16770229,navajowhite:16768685,navy:128,oldlace:16643558,olive:8421376,olivedrab:7048739,orange:16753920,orangered:16729344,orchid:14315734,palegoldenrod:15657130,palegreen:10025880,paleturquoise:11529966,palevioletred:14381203,papayawhip:16773077,peachpuff:16767673,peru:13468991,pink:16761035,plum:14524637,powderblue:11591910,purple:8388736,rebeccapurple:6697881,red:16711680,rosybrown:12357519,royalblue:4286945,saddlebrown:9127187,salmon:16416882,sandybrown:16032864,seagreen:3050327,seashell:16774638,sienna:10506797,silver:12632256,skyblue:8900331,slateblue:6970061,slategray:7372944,slategrey:7372944,snow:16775930,springgreen:65407,steelblue:4620980,tan:13808780,teal:32896,thistle:14204888,tomato:16737095,turquoise:4251856,violet:15631086,wheat:16113331,white:16777215,whitesmoke:16119285,yellow:16776960,yellowgreen:10145074},_hslA={h:0,s:0,l:0},_hslB={h:0,s:0,l:0};function hue2rgb(e,t,r){return r<0&&(r+=1),r>1&&(r-=1),r<1/6?e+6*(t-e)*r:r<.5?t:r<2/3?e+6*(t-e)*(2/3-r):e}class Color{constructor(e,t,r){return this.isColor=!0,this.r=1,this.g=1,this.b=1,this.set(e,t,r)}set(e,t,r){if(void 0===t&&void 0===r){const t=e;t&&t.isColor?this.copy(t):"number"==typeof t?this.setHex(t):"string"==typeof t&&this.setStyle(t)}else this.setRGB(e,t,r);return this}setScalar(e){return this.r=e,this.g=e,this.b=e,this}setHex(e,t="srgb"){return e=Math.floor(e),this.r=(e>>16&255)/255,this.g=(e>>8&255)/255,this.b=(255&e)/255,ColorManagement.toWorkingColorSpace(this,t),this}setRGB(e,t,r,n=ColorManagement.workingColorSpace){return this.r=e,this.g=t,this.b=r,ColorManagement.toWorkingColorSpace(this,n),this}setHSL(e,t,r,n=ColorManagement.workingColorSpace){if(e=euclideanModulo(e,1),t=clamp(t,0,1),r=clamp(r,0,1),0===t)this.r=this.g=this.b=r;else{const n=r<=.5?r*(1+t):r+t-r*t,i=2*r-n;this.r=hue2rgb(i,n,e+1/3),this.g=hue2rgb(i,n,e),this.b=hue2rgb(i,n,e-1/3)}return ColorManagement.toWorkingColorSpace(this,n),this}setStyle(e,t="srgb"){function r(t){void 0!==t&&parseFloat(t)<1&&console.warn("THREE.Color: Alpha component of "+e+" will be ignored.")}let n;if(n=/^(\w+)\(([^\)]*)\)/.exec(e)){let i;const a=n[1],s=n[2];switch(a){case"rgb":case"rgba":if(i=/^\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*(?:,\s*(\d*\.?\d+)\s*)?$/.exec(s))return r(i[4]),this.setRGB(Math.min(255,parseInt(i[1],10))/255,Math.min(255,parseInt(i[2],10))/255,Math.min(255,parseInt(i[3],10))/255,t);if(i=/^\s*(\d+)\%\s*,\s*(\d+)\%\s*,\s*(\d+)\%\s*(?:,\s*(\d*\.?\d+)\s*)?$/.exec(s))return r(i[4]),this.setRGB(Math.min(100,parseInt(i[1],10))/100,Math.min(100,parseInt(i[2],10))/100,Math.min(100,parseInt(i[3],10))/100,t);break;case"hsl":case"hsla":if(i=/^\s*(\d*\.?\d+)\s*,\s*(\d*\.?\d+)\%\s*,\s*(\d*\.?\d+)\%\s*(?:,\s*(\d*\.?\d+)\s*)?$/.exec(s))return r(i[4]),this.setHSL(parseFloat(i[1])/360,parseFloat(i[2])/100,parseFloat(i[3])/100,t);break;default:console.warn("THREE.Color: Unknown color model "+e)}}else if(n=/^\#([A-Fa-f\d]+)$/.exec(e)){const r=n[1],i=r.length;if(3===i)return this.setRGB(parseInt(r.charAt(0),16)/15,parseInt(r.charAt(1),16)/15,parseInt(r.charAt(2),16)/15,t);if(6===i)return this.setHex(parseInt(r,16),t);console.warn("THREE.Color: Invalid hex color "+e)}else if(e&&e.length>0)return this.setColorName(e,t);return this}setColorName(e,t="srgb"){const r=_colorKeywords[e.toLowerCase()];return void 0!==r?this.setHex(r,t):console.warn("THREE.Color: Unknown color "+e),this}clone(){return new this.constructor(this.r,this.g,this.b)}copy(e){return this.r=e.r,this.g=e.g,this.b=e.b,this}copySRGBToLinear(e){return this.r=SRGBToLinear(e.r),this.g=SRGBToLinear(e.g),this.b=SRGBToLinear(e.b),this}copyLinearToSRGB(e){return this.r=LinearToSRGB(e.r),this.g=LinearToSRGB(e.g),this.b=LinearToSRGB(e.b),this}convertSRGBToLinear(){return this.copySRGBToLinear(this),this}convertLinearToSRGB(){return this.copyLinearToSRGB(this),this}getHex(e="srgb"){return ColorManagement.fromWorkingColorSpace(_color.copy(this),e),65536*Math.round(clamp(255*_color.r,0,255))+256*Math.round(clamp(255*_color.g,0,255))+Math.round(clamp(255*_color.b,0,255))}getHexString(e="srgb"){return("000000"+this.getHex(e).toString(16)).slice(-6)}getHSL(e,t=ColorManagement.workingColorSpace){ColorManagement.fromWorkingColorSpace(_color.copy(this),t);const r=_color.r,n=_color.g,i=_color.b,a=Math.max(r,n,i),s=Math.min(r,n,i);let o,l;const c=(s+a)/2;if(s===a)o=0,l=0;else{const e=a-s;switch(l=c<=.5?e/(a+s):e/(2-a-s),a){case r:o=(n-i)/e+(n<i?6:0);break;case n:o=(i-r)/e+2;break;case i:o=(r-n)/e+4}o/=6}return e.h=o,e.s=l,e.l=c,e}getRGB(e,t=ColorManagement.workingColorSpace){return ColorManagement.fromWorkingColorSpace(_color.copy(this),t),e.r=_color.r,e.g=_color.g,e.b=_color.b,e}getStyle(e="srgb"){ColorManagement.fromWorkingColorSpace(_color.copy(this),e);const t=_color.r,r=_color.g,n=_color.b;return"srgb"!==e?`color(${e} ${t.toFixed(3)} ${r.toFixed(3)} ${n.toFixed(3)})`:`rgb(${Math.round(255*t)},${Math.round(255*r)},${Math.round(255*n)})`}offsetHSL(e,t,r){return this.getHSL(_hslA),this.setHSL(_hslA.h+e,_hslA.s+t,_hslA.l+r)}add(e){return this.r+=e.r,this.g+=e.g,this.b+=e.b,this}addColors(e,t){return this.r=e.r+t.r,this.g=e.g+t.g,this.b=e.b+t.b,this}addScalar(e){return this.r+=e,this.g+=e,this.b+=e,this}sub(e){return this.r=Math.max(0,this.r-e.r),this.g=Math.max(0,this.g-e.g),this.b=Math.max(0,this.b-e.b),this}multiply(e){return this.r*=e.r,this.g*=e.g,this.b*=e.b,this}multiplyScalar(e){return this.r*=e,this.g*=e,this.b*=e,this}lerp(e,t){return this.r+=(e.r-this.r)*t,this.g+=(e.g-this.g)*t,this.b+=(e.b-this.b)*t,this}lerpColors(e,t,r){return this.r=e.r+(t.r-e.r)*r,this.g=e.g+(t.g-e.g)*r,this.b=e.b+(t.b-e.b)*r,this}lerpHSL(e,t){this.getHSL(_hslA),e.getHSL(_hslB);const r=lerp(_hslA.h,_hslB.h,t),n=lerp(_hslA.s,_hslB.s,t),i=lerp(_hslA.l,_hslB.l,t);return this.setHSL(r,n,i),this}setFromVector3(e){return this.r=e.x,this.g=e.y,this.b=e.z,this}applyMatrix3(e){const t=this.r,r=this.g,n=this.b,i=e.elements;return this.r=i[0]*t+i[3]*r+i[6]*n,this.g=i[1]*t+i[4]*r+i[7]*n,this.b=i[2]*t+i[5]*r+i[8]*n,this}equals(e){return e.r===this.r&&e.g===this.g&&e.b===this.b}fromArray(e,t=0){return this.r=e[t],this.g=e[t+1],this.b=e[t+2],this}toArray(e=[],t=0){return e[t]=this.r,e[t+1]=this.g,e[t+2]=this.b,e}fromBufferAttribute(e,t){return this.r=e.getX(t),this.g=e.getY(t),this.b=e.getZ(t),this}toJSON(){return this.getHex()}*[Symbol.iterator](){yield this.r,yield this.g,yield this.b}}const _color=new Color;Color.NAMES=_colorKeywords;let _materialId=0;class Material extends EventDispatcher{constructor(){super(),this.isMaterial=!0,Object.defineProperty(this,"id",{value:_materialId++}),this.uuid=generateUUID(),this.name="",this.type="Material",this.blending=1,this.side=0,this.vertexColors=!1,this.opacity=1,this.transparent=!1,this.alphaHash=!1,this.blendSrc=204,this.blendDst=205,this.blendEquation=100,this.blendSrcAlpha=null,this.blendDstAlpha=null,this.blendEquationAlpha=null,this.blendColor=new Color(0,0,0),this.blendAlpha=0,this.depthFunc=3,this.depthTest=!0,this.depthWrite=!0,this.stencilWriteMask=255,this.stencilFunc=519,this.stencilRef=0,this.stencilFuncMask=255,this.stencilFail=7680,this.stencilZFail=7680,this.stencilZPass=7680,this.stencilWrite=!1,this.clippingPlanes=null,this.clipIntersection=!1,this.clipShadows=!1,this.shadowSide=null,this.colorWrite=!0,this.precision=null,this.polygonOffset=!1,this.polygonOffsetFactor=0,this.polygonOffsetUnits=0,this.dithering=!1,this.alphaToCoverage=!1,this.premultipliedAlpha=!1,this.forceSinglePass=!1,this.allowOverride=!0,this.visible=!0,this.toneMapped=!0,this.userData={},this.version=0,this._alphaTest=0}get alphaTest(){return this._alphaTest}set alphaTest(e){this._alphaTest>0!=e>0&&this.version++,this._alphaTest=e}onBeforeRender(){}onBeforeCompile(){}customProgramCacheKey(){return this.onBeforeCompile.toString()}setValues(e){if(void 0!==e)for(const t in e){const r=e[t];if(void 0===r){console.warn(`THREE.Material: parameter '${t}' has value of undefined.`);continue}const n=this[t];void 0!==n?n&&n.isColor?n.set(r):n&&n.isVector3&&r&&r.isVector3?n.copy(r):this[t]=r:console.warn(`THREE.Material: '${t}' is not a property of THREE.${this.type}.`)}}toJSON(e){const t=void 0===e||"string"==typeof e;t&&(e={textures:{},images:{}});const r={metadata:{version:4.6,type:"Material",generator:"Material.toJSON"}};function n(e){const t=[];for(const r in e){const n=e[r];delete n.metadata,t.push(n)}return t}if(r.uuid=this.uuid,r.type=this.type,""!==this.name&&(r.name=this.name),this.color&&this.color.isColor&&(r.color=this.color.getHex()),void 0!==this.roughness&&(r.roughness=this.roughness),void 0!==this.metalness&&(r.metalness=this.metalness),void 0!==this.sheen&&(r.sheen=this.sheen),this.sheenColor&&this.sheenColor.isColor&&(r.sheenColor=this.sheenColor.getHex()),void 0!==this.sheenRoughness&&(r.sheenRoughness=this.sheenRoughness),this.emissive&&this.emissive.isColor&&(r.emissive=this.emissive.getHex()),void 0!==this.emissiveIntensity&&1!==this.emissiveIntensity&&(r.emissiveIntensity=this.emissiveIntensity),this.specular&&this.specular.isColor&&(r.specular=this.specular.getHex()),void 0!==this.specularIntensity&&(r.specularIntensity=this.specularIntensity),this.specularColor&&this.specularColor.isColor&&(r.specularColor=this.specularColor.getHex()),void 0!==this.shininess&&(r.shininess=this.shininess),void 0!==this.clearcoat&&(r.clearcoat=this.clearcoat),void 0!==this.clearcoatRoughness&&(r.clearcoatRoughness=this.clearcoatRoughness),this.clearcoatMap&&this.clearcoatMap.isTexture&&(r.clearcoatMap=this.clearcoatMap.toJSON(e).uuid),this.clearcoatRoughnessMap&&this.clearcoatRoughnessMap.isTexture&&(r.clearcoatRoughnessMap=this.clearcoatRoughnessMap.toJSON(e).uuid),this.clearcoatNormalMap&&this.clearcoatNormalMap.isTexture&&(r.clearcoatNormalMap=this.clearcoatNormalMap.toJSON(e).uuid,r.clearcoatNormalScale=this.clearcoatNormalScale.toArray()),void 0!==this.dispersion&&(r.dispersion=this.dispersion),void 0!==this.iridescence&&(r.iridescence=this.iridescence),void 0!==this.iridescenceIOR&&(r.iridescenceIOR=this.iridescenceIOR),void 0!==this.iridescenceThicknessRange&&(r.iridescenceThicknessRange=this.iridescenceThicknessRange),this.iridescenceMap&&this.iridescenceMap.isTexture&&(r.iridescenceMap=this.iridescenceMap.toJSON(e).uuid),this.iridescenceThicknessMap&&this.iridescenceThicknessMap.isTexture&&(r.iridescenceThicknessMap=this.iridescenceThicknessMap.toJSON(e).uuid),void 0!==this.anisotropy&&(r.anisotropy=this.anisotropy),void 0!==this.anisotropyRotation&&(r.anisotropyRotation=this.anisotropyRotation),this.anisotropyMap&&this.anisotropyMap.isTexture&&(r.anisotropyMap=this.anisotropyMap.toJSON(e).uuid),this.map&&this.map.isTexture&&(r.map=this.map.toJSON(e).uuid),this.matcap&&this.matcap.isTexture&&(r.matcap=this.matcap.toJSON(e).uuid),this.alphaMap&&this.alphaMap.isTexture&&(r.alphaMap=this.alphaMap.toJSON(e).uuid),this.lightMap&&this.lightMap.isTexture&&(r.lightMap=this.lightMap.toJSON(e).uuid,r.lightMapIntensity=this.lightMapIntensity),this.aoMap&&this.aoMap.isTexture&&(r.aoMap=this.aoMap.toJSON(e).uuid,r.aoMapIntensity=this.aoMapIntensity),this.bumpMap&&this.bumpMap.isTexture&&(r.bumpMap=this.bumpMap.toJSON(e).uuid,r.bumpScale=this.bumpScale),this.normalMap&&this.normalMap.isTexture&&(r.normalMap=this.normalMap.toJSON(e).uuid,r.normalMapType=this.normalMapType,r.normalScale=this.normalScale.toArray()),this.displacementMap&&this.displacementMap.isTexture&&(r.displacementMap=this.displacementMap.toJSON(e).uuid,r.displacementScale=this.displacementScale,r.displacementBias=this.displacementBias),this.roughnessMap&&this.roughnessMap.isTexture&&(r.roughnessMap=this.roughnessMap.toJSON(e).uuid),this.metalnessMap&&this.metalnessMap.isTexture&&(r.metalnessMap=this.metalnessMap.toJSON(e).uuid),this.emissiveMap&&this.emissiveMap.isTexture&&(r.emissiveMap=this.emissiveMap.toJSON(e).uuid),this.specularMap&&this.specularMap.isTexture&&(r.specularMap=this.specularMap.toJSON(e).uuid),this.specularIntensityMap&&this.specularIntensityMap.isTexture&&(r.specularIntensityMap=this.specularIntensityMap.toJSON(e).uuid),this.specularColorMap&&this.specularColorMap.isTexture&&(r.specularColorMap=this.specularColorMap.toJSON(e).uuid),this.envMap&&this.envMap.isTexture&&(r.envMap=this.envMap.toJSON(e).uuid,void 0!==this.combine&&(r.combine=this.combine)),void 0!==this.envMapRotation&&(r.envMapRotation=this.envMapRotation.toArray()),void 0!==this.envMapIntensity&&(r.envMapIntensity=this.envMapIntensity),void 0!==this.reflectivity&&(r.reflectivity=this.reflectivity),void 0!==this.refractionRatio&&(r.refractionRatio=this.refractionRatio),this.gradientMap&&this.gradientMap.isTexture&&(r.gradientMap=this.gradientMap.toJSON(e).uuid),void 0!==this.transmission&&(r.transmission=this.transmission),this.transmissionMap&&this.transmissionMap.isTexture&&(r.transmissionMap=this.transmissionMap.toJSON(e).uuid),void 0!==this.thickness&&(r.thickness=this.thickness),this.thicknessMap&&this.thicknessMap.isTexture&&(r.thicknessMap=this.thicknessMap.toJSON(e).uuid),void 0!==this.attenuationDistance&&this.attenuationDistance!==1/0&&(r.attenuationDistance=this.attenuationDistance),void 0!==this.attenuationColor&&(r.attenuationColor=this.attenuationColor.getHex()),void 0!==this.size&&(r.size=this.size),null!==this.shadowSide&&(r.shadowSide=this.shadowSide),void 0!==this.sizeAttenuation&&(r.sizeAttenuation=this.sizeAttenuation),1!==this.blending&&(r.blending=this.blending),0!==this.side&&(r.side=this.side),!0===this.vertexColors&&(r.vertexColors=!0),this.opacity<1&&(r.opacity=this.opacity),!0===this.transparent&&(r.transparent=!0),204!==this.blendSrc&&(r.blendSrc=this.blendSrc),205!==this.blendDst&&(r.blendDst=this.blendDst),100!==this.blendEquation&&(r.blendEquation=this.blendEquation),null!==this.blendSrcAlpha&&(r.blendSrcAlpha=this.blendSrcAlpha),null!==this.blendDstAlpha&&(r.blendDstAlpha=this.blendDstAlpha),null!==this.blendEquationAlpha&&(r.blendEquationAlpha=this.blendEquationAlpha),this.blendColor&&this.blendColor.isColor&&(r.blendColor=this.blendColor.getHex()),0!==this.blendAlpha&&(r.blendAlpha=this.blendAlpha),3!==this.depthFunc&&(r.depthFunc=this.depthFunc),!1===this.depthTest&&(r.depthTest=this.depthTest),!1===this.depthWrite&&(r.depthWrite=this.depthWrite),!1===this.colorWrite&&(r.colorWrite=this.colorWrite),255!==this.stencilWriteMask&&(r.stencilWriteMask=this.stencilWriteMask),519!==this.stencilFunc&&(r.stencilFunc=this.stencilFunc),0!==this.stencilRef&&(r.stencilRef=this.stencilRef),255!==this.stencilFuncMask&&(r.stencilFuncMask=this.stencilFuncMask),7680!==this.stencilFail&&(r.stencilFail=this.stencilFail),7680!==this.stencilZFail&&(r.stencilZFail=this.stencilZFail),7680!==this.stencilZPass&&(r.stencilZPass=this.stencilZPass),!0===this.stencilWrite&&(r.stencilWrite=this.stencilWrite),void 0!==this.rotation&&0!==this.rotation&&(r.rotation=this.rotation),!0===this.polygonOffset&&(r.polygonOffset=!0),0!==this.polygonOffsetFactor&&(r.polygonOffsetFactor=this.polygonOffsetFactor),0!==this.polygonOffsetUnits&&(r.polygonOffsetUnits=this.polygonOffsetUnits),void 0!==this.linewidth&&1!==this.linewidth&&(r.linewidth=this.linewidth),void 0!==this.dashSize&&(r.dashSize=this.dashSize),void 0!==this.gapSize&&(r.gapSize=this.gapSize),void 0!==this.scale&&(r.scale=this.scale),!0===this.dithering&&(r.dithering=!0),this.alphaTest>0&&(r.alphaTest=this.alphaTest),!0===this.alphaHash&&(r.alphaHash=!0),!0===this.alphaToCoverage&&(r.alphaToCoverage=!0),!0===this.premultipliedAlpha&&(r.premultipliedAlpha=!0),!0===this.forceSinglePass&&(r.forceSinglePass=!0),!0===this.wireframe&&(r.wireframe=!0),this.wireframeLinewidth>1&&(r.wireframeLinewidth=this.wireframeLinewidth),"round"!==this.wireframeLinecap&&(r.wireframeLinecap=this.wireframeLinecap),"round"!==this.wireframeLinejoin&&(r.wireframeLinejoin=this.wireframeLinejoin),!0===this.flatShading&&(r.flatShading=!0),!1===this.visible&&(r.visible=!1),!1===this.toneMapped&&(r.toneMapped=!1),!1===this.fog&&(r.fog=!1),Object.keys(this.userData).length>0&&(r.userData=this.userData),t){const t=n(e.textures),i=n(e.images);t.length>0&&(r.textures=t),i.length>0&&(r.images=i)}return r}clone(){return(new this.constructor).copy(this)}copy(e){this.name=e.name,this.blending=e.blending,this.side=e.side,this.vertexColors=e.vertexColors,this.opacity=e.opacity,this.transparent=e.transparent,this.blendSrc=e.blendSrc,this.blendDst=e.blendDst,this.blendEquation=e.blendEquation,this.blendSrcAlpha=e.blendSrcAlpha,this.blendDstAlpha=e.blendDstAlpha,this.blendEquationAlpha=e.blendEquationAlpha,this.blendColor.copy(e.blendColor),this.blendAlpha=e.blendAlpha,this.depthFunc=e.depthFunc,this.depthTest=e.depthTest,this.depthWrite=e.depthWrite,this.stencilWriteMask=e.stencilWriteMask,this.stencilFunc=e.stencilFunc,this.stencilRef=e.stencilRef,this.stencilFuncMask=e.stencilFuncMask,this.stencilFail=e.stencilFail,this.stencilZFail=e.stencilZFail,this.stencilZPass=e.stencilZPass,this.stencilWrite=e.stencilWrite;const t=e.clippingPlanes;let r=null;if(null!==t){const e=t.length;r=new Array(e);for(let n=0;n!==e;++n)r[n]=t[n].clone()}return this.clippingPlanes=r,this.clipIntersection=e.clipIntersection,this.clipShadows=e.clipShadows,this.shadowSide=e.shadowSide,this.colorWrite=e.colorWrite,this.precision=e.precision,this.polygonOffset=e.polygonOffset,this.polygonOffsetFactor=e.polygonOffsetFactor,this.polygonOffsetUnits=e.polygonOffsetUnits,this.dithering=e.dithering,this.alphaTest=e.alphaTest,this.alphaHash=e.alphaHash,this.alphaToCoverage=e.alphaToCoverage,this.premultipliedAlpha=e.premultipliedAlpha,this.forceSinglePass=e.forceSinglePass,this.visible=e.visible,this.toneMapped=e.toneMapped,this.userData=JSON.parse(JSON.stringify(e.userData)),this}dispose(){this.dispatchEvent({type:"dispose"})}set needsUpdate(e){!0===e&&this.version++}}class MeshBasicMaterial extends Material{constructor(e){super(),this.isMeshBasicMaterial=!0,this.type="MeshBasicMaterial",this.color=new Color(16777215),this.map=null,this.lightMap=null,this.lightMapIntensity=1,this.aoMap=null,this.aoMapIntensity=1,this.specularMap=null,this.alphaMap=null,this.envMap=null,this.envMapRotation=new Euler,this.combine=0,this.reflectivity=1,this.refractionRatio=.98,this.wireframe=!1,this.wireframeLinewidth=1,this.wireframeLinecap="round",this.wireframeLinejoin="round",this.fog=!0,this.setValues(e)}copy(e){return super.copy(e),this.color.copy(e.color),this.map=e.map,this.lightMap=e.lightMap,this.lightMapIntensity=e.lightMapIntensity,this.aoMap=e.aoMap,this.aoMapIntensity=e.aoMapIntensity,this.specularMap=e.specularMap,this.alphaMap=e.alphaMap,this.envMap=e.envMap,this.envMapRotation.copy(e.envMapRotation),this.combine=e.combine,this.reflectivity=e.reflectivity,this.refractionRatio=e.refractionRatio,this.wireframe=e.wireframe,this.wireframeLinewidth=e.wireframeLinewidth,this.wireframeLinecap=e.wireframeLinecap,this.wireframeLinejoin=e.wireframeLinejoin,this.fog=e.fog,this}}const _tables=_generateTables();function _generateTables(){const e=new ArrayBuffer(4),t=new Float32Array(e),r=new Uint32Array(e),n=new Uint32Array(512),i=new Uint32Array(512);for(let e=0;e<256;++e){const t=e-127;t<-27?(n[e]=0,n[256|e]=32768,i[e]=24,i[256|e]=24):t<-14?(n[e]=1024>>-t-14,n[256|e]=1024>>-t-14|32768,i[e]=-t-1,i[256|e]=-t-1):t<=15?(n[e]=t+15<<10,n[256|e]=t+15<<10|32768,i[e]=13,i[256|e]=13):t<128?(n[e]=31744,n[256|e]=64512,i[e]=24,i[256|e]=24):(n[e]=31744,n[256|e]=64512,i[e]=13,i[256|e]=13)}const a=new Uint32Array(2048),s=new Uint32Array(64),o=new Uint32Array(64);for(let e=1;e<1024;++e){let t=e<<13,r=0;for(;!(8388608&t);)t<<=1,r-=8388608;t&=-8388609,r+=947912704,a[e]=t|r}for(let e=1024;e<2048;++e)a[e]=939524096+(e-1024<<13);for(let e=1;e<31;++e)s[e]=e<<23;s[31]=1199570944,s[32]=2147483648;for(let e=33;e<63;++e)s[e]=2147483648+(e-32<<23);s[63]=3347054592;for(let e=1;e<64;++e)32!==e&&(o[e]=1024);return{floatView:t,uint32View:r,baseTable:n,shiftTable:i,mantissaTable:a,exponentTable:s,offsetTable:o}}function toHalfFloat(e){Math.abs(e)>65504&&console.warn("THREE.DataUtils.toHalfFloat(): Value out of range."),e=clamp(e,-65504,65504),_tables.floatView[0]=e;const t=_tables.uint32View[0],r=t>>23&511;return _tables.baseTable[r]+((8388607&t)>>_tables.shiftTable[r])}function fromHalfFloat(e){const t=e>>10;return _tables.uint32View[0]=_tables.mantissaTable[_tables.offsetTable[t]+(1023&e)]+_tables.exponentTable[t],_tables.floatView[0]}class DataUtils{static toHalfFloat(e){return toHalfFloat(e)}static fromHalfFloat(e){return fromHalfFloat(e)}}const _vector$9=new Vector3,_vector2$1=new Vector2;let _id$3=0;class BufferAttribute{constructor(e,t,r=!1){if(Array.isArray(e))throw new TypeError("THREE.BufferAttribute: array should be a Typed Array.");this.isBufferAttribute=!0,Object.defineProperty(this,"id",{value:_id$3++}),this.name="",this.array=e,this.itemSize=t,this.count=void 0!==e?e.length/t:0,this.normalized=r,this.usage=35044,this.updateRanges=[],this.gpuType=1015,this.version=0}onUploadCallback(){}set needsUpdate(e){!0===e&&this.version++}setUsage(e){return this.usage=e,this}addUpdateRange(e,t){this.updateRanges.push({start:e,count:t})}clearUpdateRanges(){this.updateRanges.length=0}copy(e){return this.name=e.name,this.array=new e.array.constructor(e.array),this.itemSize=e.itemSize,this.count=e.count,this.normalized=e.normalized,this.usage=e.usage,this.gpuType=e.gpuType,this}copyAt(e,t,r){e*=this.itemSize,r*=t.itemSize;for(let n=0,i=this.itemSize;n<i;n++)this.array[e+n]=t.array[r+n];return this}copyArray(e){return this.array.set(e),this}applyMatrix3(e){if(2===this.itemSize)for(let t=0,r=this.count;t<r;t++)_vector2$1.fromBufferAttribute(this,t),_vector2$1.applyMatrix3(e),this.setXY(t,_vector2$1.x,_vector2$1.y);else if(3===this.itemSize)for(let t=0,r=this.count;t<r;t++)_vector$9.fromBufferAttribute(this,t),_vector$9.applyMatrix3(e),this.setXYZ(t,_vector$9.x,_vector$9.y,_vector$9.z);return this}applyMatrix4(e){for(let t=0,r=this.count;t<r;t++)_vector$9.fromBufferAttribute(this,t),_vector$9.applyMatrix4(e),this.setXYZ(t,_vector$9.x,_vector$9.y,_vector$9.z);return this}applyNormalMatrix(e){for(let t=0,r=this.count;t<r;t++)_vector$9.fromBufferAttribute(this,t),_vector$9.applyNormalMatrix(e),this.setXYZ(t,_vector$9.x,_vector$9.y,_vector$9.z);return this}transformDirection(e){for(let t=0,r=this.count;t<r;t++)_vector$9.fromBufferAttribute(this,t),_vector$9.transformDirection(e),this.setXYZ(t,_vector$9.x,_vector$9.y,_vector$9.z);return this}set(e,t=0){return this.array.set(e,t),this}getComponent(e,t){let r=this.array[e*this.itemSize+t];return this.normalized&&(r=denormalize(r,this.array)),r}setComponent(e,t,r){return this.normalized&&(r=normalize(r,this.array)),this.array[e*this.itemSize+t]=r,this}getX(e){let t=this.array[e*this.itemSize];return this.normalized&&(t=denormalize(t,this.array)),t}setX(e,t){return this.normalized&&(t=normalize(t,this.array)),this.array[e*this.itemSize]=t,this}getY(e){let t=this.array[e*this.itemSize+1];return this.normalized&&(t=denormalize(t,this.array)),t}setY(e,t){return this.normalized&&(t=normalize(t,this.array)),this.array[e*this.itemSize+1]=t,this}getZ(e){let t=this.array[e*this.itemSize+2];return this.normalized&&(t=denormalize(t,this.array)),t}setZ(e,t){return this.normalized&&(t=normalize(t,this.array)),this.array[e*this.itemSize+2]=t,this}getW(e){let t=this.array[e*this.itemSize+3];return this.normalized&&(t=denormalize(t,this.array)),t}setW(e,t){return this.normalized&&(t=normalize(t,this.array)),this.array[e*this.itemSize+3]=t,this}setXY(e,t,r){return e*=this.itemSize,this.normalized&&(t=normalize(t,this.array),r=normalize(r,this.array)),this.array[e+0]=t,this.array[e+1]=r,this}setXYZ(e,t,r,n){return e*=this.itemSize,this.normalized&&(t=normalize(t,this.array),r=normalize(r,this.array),n=normalize(n,this.array)),this.array[e+0]=t,this.array[e+1]=r,this.array[e+2]=n,this}setXYZW(e,t,r,n,i){return e*=this.itemSize,this.normalized&&(t=normalize(t,this.array),r=normalize(r,this.array),n=normalize(n,this.array),i=normalize(i,this.array)),this.array[e+0]=t,this.array[e+1]=r,this.array[e+2]=n,this.array[e+3]=i,this}onUpload(e){return this.onUploadCallback=e,this}clone(){return new this.constructor(this.array,this.itemSize).copy(this)}toJSON(){const e={itemSize:this.itemSize,type:this.array.constructor.name,array:Array.from(this.array),normalized:this.normalized};return""!==this.name&&(e.name=this.name),35044!==this.usage&&(e.usage=this.usage),e}}class Int8BufferAttribute extends BufferAttribute{constructor(e,t,r){super(new Int8Array(e),t,r)}}class Uint8BufferAttribute extends BufferAttribute{constructor(e,t,r){super(new Uint8Array(e),t,r)}}class Uint8ClampedBufferAttribute extends BufferAttribute{constructor(e,t,r){super(new Uint8ClampedArray(e),t,r)}}class Int16BufferAttribute extends BufferAttribute{constructor(e,t,r){super(new Int16Array(e),t,r)}}class Uint16BufferAttribute extends BufferAttribute{constructor(e,t,r){super(new Uint16Array(e),t,r)}}class Int32BufferAttribute extends BufferAttribute{constructor(e,t,r){super(new Int32Array(e),t,r)}}class Uint32BufferAttribute extends BufferAttribute{constructor(e,t,r){super(new Uint32Array(e),t,r)}}class Float16BufferAttribute extends BufferAttribute{constructor(e,t,r){super(new Uint16Array(e),t,r),this.isFloat16BufferAttribute=!0}getX(e){let t=fromHalfFloat(this.array[e*this.itemSize]);return this.normalized&&(t=denormalize(t,this.array)),t}setX(e,t){return this.normalized&&(t=normalize(t,this.array)),this.array[e*this.itemSize]=toHalfFloat(t),this}getY(e){let t=fromHalfFloat(this.array[e*this.itemSize+1]);return this.normalized&&(t=denormalize(t,this.array)),t}setY(e,t){return this.normalized&&(t=normalize(t,this.array)),this.array[e*this.itemSize+1]=toHalfFloat(t),this}getZ(e){let t=fromHalfFloat(this.array[e*this.itemSize+2]);return this.normalized&&(t=denormalize(t,this.array)),t}setZ(e,t){return this.normalized&&(t=normalize(t,this.array)),this.array[e*this.itemSize+2]=toHalfFloat(t),this}getW(e){let t=fromHalfFloat(this.array[e*this.itemSize+3]);return this.normalized&&(t=denormalize(t,this.array)),t}setW(e,t){return this.normalized&&(t=normalize(t,this.array)),this.array[e*this.itemSize+3]=toHalfFloat(t),this}setXY(e,t,r){return e*=this.itemSize,this.normalized&&(t=normalize(t,this.array),r=normalize(r,this.array)),this.array[e+0]=toHalfFloat(t),this.array[e+1]=toHalfFloat(r),this}setXYZ(e,t,r,n){return e*=this.itemSize,this.normalized&&(t=normalize(t,this.array),r=normalize(r,this.array),n=normalize(n,this.array)),this.array[e+0]=toHalfFloat(t),this.array[e+1]=toHalfFloat(r),this.array[e+2]=toHalfFloat(n),this}setXYZW(e,t,r,n,i){return e*=this.itemSize,this.normalized&&(t=normalize(t,this.array),r=normalize(r,this.array),n=normalize(n,this.array),i=normalize(i,this.array)),this.array[e+0]=toHalfFloat(t),this.array[e+1]=toHalfFloat(r),this.array[e+2]=toHalfFloat(n),this.array[e+3]=toHalfFloat(i),this}}class Float32BufferAttribute extends BufferAttribute{constructor(e,t,r){super(new Float32Array(e),t,r)}}let _id$2=0;const _m1$2=new Matrix4,_obj=new Object3D,_offset=new Vector3,_box$2=new Box3,_boxMorphTargets=new Box3,_vector$8=new Vector3;class BufferGeometry extends EventDispatcher{constructor(){super(),this.isBufferGeometry=!0,Object.defineProperty(this,"id",{value:_id$2++}),this.uuid=generateUUID(),this.name="",this.type="BufferGeometry",this.index=null,this.indirect=null,this.attributes={},this.morphAttributes={},this.morphTargetsRelative=!1,this.groups=[],this.boundingBox=null,this.boundingSphere=null,this.drawRange={start:0,count:1/0},this.userData={}}getIndex(){return this.index}setIndex(e){return Array.isArray(e)?this.index=new(arrayNeedsUint32(e)?Uint32BufferAttribute:Uint16BufferAttribute)(e,1):this.index=e,this}setIndirect(e){return this.indirect=e,this}getIndirect(){return this.indirect}getAttribute(e){return this.attributes[e]}setAttribute(e,t){return this.attributes[e]=t,this}deleteAttribute(e){return delete this.attributes[e],this}hasAttribute(e){return void 0!==this.attributes[e]}addGroup(e,t,r=0){this.groups.push({start:e,count:t,materialIndex:r})}clearGroups(){this.groups=[]}setDrawRange(e,t){this.drawRange.start=e,this.drawRange.count=t}applyMatrix4(e){const t=this.attributes.position;void 0!==t&&(t.applyMatrix4(e),t.needsUpdate=!0);const r=this.attributes.normal;if(void 0!==r){const t=(new Matrix3).getNormalMatrix(e);r.applyNormalMatrix(t),r.needsUpdate=!0}const n=this.attributes.tangent;return void 0!==n&&(n.transformDirection(e),n.needsUpdate=!0),null!==this.boundingBox&&this.computeBoundingBox(),null!==this.boundingSphere&&this.computeBoundingSphere(),this}applyQuaternion(e){return _m1$2.makeRotationFromQuaternion(e),this.applyMatrix4(_m1$2),this}rotateX(e){return _m1$2.makeRotationX(e),this.applyMatrix4(_m1$2),this}rotateY(e){return _m1$2.makeRotationY(e),this.applyMatrix4(_m1$2),this}rotateZ(e){return _m1$2.makeRotationZ(e),this.applyMatrix4(_m1$2),this}translate(e,t,r){return _m1$2.makeTranslation(e,t,r),this.applyMatrix4(_m1$2),this}scale(e,t,r){return _m1$2.makeScale(e,t,r),this.applyMatrix4(_m1$2),this}lookAt(e){return _obj.lookAt(e),_obj.updateMatrix(),this.applyMatrix4(_obj.matrix),this}center(){return this.computeBoundingBox(),this.boundingBox.getCenter(_offset).negate(),this.translate(_offset.x,_offset.y,_offset.z),this}setFromPoints(e){const t=this.getAttribute("position");if(void 0===t){const t=[];for(let r=0,n=e.length;r<n;r++){const n=e[r];t.push(n.x,n.y,n.z||0)}this.setAttribute("position",new Float32BufferAttribute(t,3))}else{const r=Math.min(e.length,t.count);for(let n=0;n<r;n++){const r=e[n];t.setXYZ(n,r.x,r.y,r.z||0)}e.length>t.count&&console.warn("THREE.BufferGeometry: Buffer size too small for points data. Use .dispose() and create a new geometry."),t.needsUpdate=!0}return this}computeBoundingBox(){null===this.boundingBox&&(this.boundingBox=new Box3);const e=this.attributes.position,t=this.morphAttributes.position;if(e&&e.isGLBufferAttribute)return console.error("THREE.BufferGeometry.computeBoundingBox(): GLBufferAttribute requires a manual bounding box.",this),void this.boundingBox.set(new Vector3(-1/0,-1/0,-1/0),new Vector3(1/0,1/0,1/0));if(void 0!==e){if(this.boundingBox.setFromBufferAttribute(e),t)for(let e=0,r=t.length;e<r;e++){const r=t[e];_box$2.setFromBufferAttribute(r),this.morphTargetsRelative?(_vector$8.addVectors(this.boundingBox.min,_box$2.min),this.boundingBox.expandByPoint(_vector$8),_vector$8.addVectors(this.boundingBox.max,_box$2.max),this.boundingBox.expandByPoint(_vector$8)):(this.boundingBox.expandByPoint(_box$2.min),this.boundingBox.expandByPoint(_box$2.max))}}else this.boundingBox.makeEmpty();(isNaN(this.boundingBox.min.x)||isNaN(this.boundingBox.min.y)||isNaN(this.boundingBox.min.z))&&console.error('THREE.BufferGeometry.computeBoundingBox(): Computed min/max have NaN values. The "position" attribute is likely to have NaN values.',this)}computeBoundingSphere(){null===this.boundingSphere&&(this.boundingSphere=new Sphere);const e=this.attributes.position,t=this.morphAttributes.position;if(e&&e.isGLBufferAttribute)return console.error("THREE.BufferGeometry.computeBoundingSphere(): GLBufferAttribute requires a manual bounding sphere.",this),void this.boundingSphere.set(new Vector3,1/0);if(e){const r=this.boundingSphere.center;if(_box$2.setFromBufferAttribute(e),t)for(let e=0,r=t.length;e<r;e++){const r=t[e];_boxMorphTargets.setFromBufferAttribute(r),this.morphTargetsRelative?(_vector$8.addVectors(_box$2.min,_boxMorphTargets.min),_box$2.expandByPoint(_vector$8),_vector$8.addVectors(_box$2.max,_boxMorphTargets.max),_box$2.expandByPoint(_vector$8)):(_box$2.expandByPoint(_boxMorphTargets.min),_box$2.expandByPoint(_boxMorphTargets.max))}_box$2.getCenter(r);let n=0;for(let t=0,i=e.count;t<i;t++)_vector$8.fromBufferAttribute(e,t),n=Math.max(n,r.distanceToSquared(_vector$8));if(t)for(let i=0,a=t.length;i<a;i++){const a=t[i],s=this.morphTargetsRelative;for(let t=0,i=a.count;t<i;t++)_vector$8.fromBufferAttribute(a,t),s&&(_offset.fromBufferAttribute(e,t),_vector$8.add(_offset)),n=Math.max(n,r.distanceToSquared(_vector$8))}this.boundingSphere.radius=Math.sqrt(n),isNaN(this.boundingSphere.radius)&&console.error('THREE.BufferGeometry.computeBoundingSphere(): Computed radius is NaN. The "position" attribute is likely to have NaN values.',this)}}computeTangents(){const e=this.index,t=this.attributes;if(null===e||void 0===t.position||void 0===t.normal||void 0===t.uv)return void console.error("THREE.BufferGeometry: .computeTangents() failed. Missing required attributes (index, position, normal or uv)");const r=t.position,n=t.normal,i=t.uv;!1===this.hasAttribute("tangent")&&this.setAttribute("tangent",new BufferAttribute(new Float32Array(4*r.count),4));const a=this.getAttribute("tangent"),s=[],o=[];for(let e=0;e<r.count;e++)s[e]=new Vector3,o[e]=new Vector3;const l=new Vector3,c=new Vector3,h=new Vector3,u=new Vector2,d=new Vector2,p=new Vector2,m=new Vector3,f=new Vector3;function g(e,t,n){l.fromBufferAttribute(r,e),c.fromBufferAttribute(r,t),h.fromBufferAttribute(r,n),u.fromBufferAttribute(i,e),d.fromBufferAttribute(i,t),p.fromBufferAttribute(i,n),c.sub(l),h.sub(l),d.sub(u),p.sub(u);const a=1/(d.x*p.y-p.x*d.y);isFinite(a)&&(m.copy(c).multiplyScalar(p.y).addScaledVector(h,-d.y).multiplyScalar(a),f.copy(h).multiplyScalar(d.x).addScaledVector(c,-p.x).multiplyScalar(a),s[e].add(m),s[t].add(m),s[n].add(m),o[e].add(f),o[t].add(f),o[n].add(f))}let _=this.groups;0===_.length&&(_=[{start:0,count:e.count}]);for(let t=0,r=_.length;t<r;++t){const r=_[t],n=r.start;for(let t=n,i=n+r.count;t<i;t+=3)g(e.getX(t+0),e.getX(t+1),e.getX(t+2))}const v=new Vector3,x=new Vector3,y=new Vector3,M=new Vector3;function S(e){y.fromBufferAttribute(n,e),M.copy(y);const t=s[e];v.copy(t),v.sub(y.multiplyScalar(y.dot(t))).normalize(),x.crossVectors(M,t);const r=x.dot(o[e])<0?-1:1;a.setXYZW(e,v.x,v.y,v.z,r)}for(let t=0,r=_.length;t<r;++t){const r=_[t],n=r.start;for(let t=n,i=n+r.count;t<i;t+=3)S(e.getX(t+0)),S(e.getX(t+1)),S(e.getX(t+2))}}computeVertexNormals(){const e=this.index,t=this.getAttribute("position");if(void 0!==t){let r=this.getAttribute("normal");if(void 0===r)r=new BufferAttribute(new Float32Array(3*t.count),3),this.setAttribute("normal",r);else for(let e=0,t=r.count;e<t;e++)r.setXYZ(e,0,0,0);const n=new Vector3,i=new Vector3,a=new Vector3,s=new Vector3,o=new Vector3,l=new Vector3,c=new Vector3,h=new Vector3;if(e)for(let u=0,d=e.count;u<d;u+=3){const d=e.getX(u+0),p=e.getX(u+1),m=e.getX(u+2);n.fromBufferAttribute(t,d),i.fromBufferAttribute(t,p),a.fromBufferAttribute(t,m),c.subVectors(a,i),h.subVectors(n,i),c.cross(h),s.fromBufferAttribute(r,d),o.fromBufferAttribute(r,p),l.fromBufferAttribute(r,m),s.add(c),o.add(c),l.add(c),r.setXYZ(d,s.x,s.y,s.z),r.setXYZ(p,o.x,o.y,o.z),r.setXYZ(m,l.x,l.y,l.z)}else for(let e=0,s=t.count;e<s;e+=3)n.fromBufferAttribute(t,e+0),i.fromBufferAttribute(t,e+1),a.fromBufferAttribute(t,e+2),c.subVectors(a,i),h.subVectors(n,i),c.cross(h),r.setXYZ(e+0,c.x,c.y,c.z),r.setXYZ(e+1,c.x,c.y,c.z),r.setXYZ(e+2,c.x,c.y,c.z);this.normalizeNormals(),r.needsUpdate=!0}}normalizeNormals(){const e=this.attributes.normal;for(let t=0,r=e.count;t<r;t++)_vector$8.fromBufferAttribute(e,t),_vector$8.normalize(),e.setXYZ(t,_vector$8.x,_vector$8.y,_vector$8.z)}toNonIndexed(){function e(e,t){const r=e.array,n=e.itemSize,i=e.normalized,a=new r.constructor(t.length*n);let s=0,o=0;for(let i=0,l=t.length;i<l;i++){s=e.isInterleavedBufferAttribute?t[i]*e.data.stride+e.offset:t[i]*n;for(let e=0;e<n;e++)a[o++]=r[s++]}return new BufferAttribute(a,n,i)}if(null===this.index)return console.warn("THREE.BufferGeometry.toNonIndexed(): BufferGeometry is already non-indexed."),this;const t=new BufferGeometry,r=this.index.array,n=this.attributes;for(const i in n){const a=e(n[i],r);t.setAttribute(i,a)}const i=this.morphAttributes;for(const n in i){const a=[],s=i[n];for(let t=0,n=s.length;t<n;t++){const n=e(s[t],r);a.push(n)}t.morphAttributes[n]=a}t.morphTargetsRelative=this.morphTargetsRelative;const a=this.groups;for(let e=0,r=a.length;e<r;e++){const r=a[e];t.addGroup(r.start,r.count,r.materialIndex)}return t}toJSON(){const e={metadata:{version:4.6,type:"BufferGeometry",generator:"BufferGeometry.toJSON"}};if(e.uuid=this.uuid,e.type=this.type,""!==this.name&&(e.name=this.name),Object.keys(this.userData).length>0&&(e.userData=this.userData),void 0!==this.parameters){const t=this.parameters;for(const r in t)void 0!==t[r]&&(e[r]=t[r]);return e}e.data={attributes:{}};const t=this.index;null!==t&&(e.data.index={type:t.array.constructor.name,array:Array.prototype.slice.call(t.array)});const r=this.attributes;for(const t in r){const n=r[t];e.data.attributes[t]=n.toJSON(e.data)}const n={};let i=!1;for(const t in this.morphAttributes){const r=this.morphAttributes[t],a=[];for(let t=0,n=r.length;t<n;t++){const n=r[t];a.push(n.toJSON(e.data))}a.length>0&&(n[t]=a,i=!0)}i&&(e.data.morphAttributes=n,e.data.morphTargetsRelative=this.morphTargetsRelative);const a=this.groups;a.length>0&&(e.data.groups=JSON.parse(JSON.stringify(a)));const s=this.boundingSphere;return null!==s&&(e.data.boundingSphere={center:s.center.toArray(),radius:s.radius}),e}clone(){return(new this.constructor).copy(this)}copy(e){this.index=null,this.attributes={},this.morphAttributes={},this.groups=[],this.boundingBox=null,this.boundingSphere=null;const t={};this.name=e.name;const r=e.index;null!==r&&this.setIndex(r.clone());const n=e.attributes;for(const e in n){const r=n[e];this.setAttribute(e,r.clone(t))}const i=e.morphAttributes;for(const e in i){const r=[],n=i[e];for(let e=0,i=n.length;e<i;e++)r.push(n[e].clone(t));this.morphAttributes[e]=r}this.morphTargetsRelative=e.morphTargetsRelative;const a=e.groups;for(let e=0,t=a.length;e<t;e++){const t=a[e];this.addGroup(t.start,t.count,t.materialIndex)}const s=e.boundingBox;null!==s&&(this.boundingBox=s.clone());const o=e.boundingSphere;return null!==o&&(this.boundingSphere=o.clone()),this.drawRange.start=e.drawRange.start,this.drawRange.count=e.drawRange.count,this.userData=e.userData,this}dispose(){this.dispatchEvent({type:"dispose"})}}const _inverseMatrix$3=new Matrix4,_ray$3=new Ray,_sphere$6=new Sphere,_sphereHitAt=new Vector3,_vA$1=new Vector3,_vB$1=new Vector3,_vC$1=new Vector3,_tempA=new Vector3,_morphA=new Vector3,_intersectionPoint=new Vector3,_intersectionPointWorld=new Vector3;class Mesh extends Object3D{constructor(e=new BufferGeometry,t=new MeshBasicMaterial){super(),this.isMesh=!0,this.type="Mesh",this.geometry=e,this.material=t,this.morphTargetDictionary=void 0,this.morphTargetInfluences=void 0,this.updateMorphTargets()}copy(e,t){return super.copy(e,t),void 0!==e.morphTargetInfluences&&(this.morphTargetInfluences=e.morphTargetInfluences.slice()),void 0!==e.morphTargetDictionary&&(this.morphTargetDictionary=Object.assign({},e.morphTargetDictionary)),this.material=Array.isArray(e.material)?e.material.slice():e.material,this.geometry=e.geometry,this}updateMorphTargets(){const e=this.geometry.morphAttributes,t=Object.keys(e);if(t.length>0){const r=e[t[0]];if(void 0!==r){this.morphTargetInfluences=[],this.morphTargetDictionary={};for(let e=0,t=r.length;e<t;e++){const t=r[e].name||String(e);this.morphTargetInfluences.push(0),this.morphTargetDictionary[t]=e}}}}getVertexPosition(e,t){const r=this.geometry,n=r.attributes.position,i=r.morphAttributes.position,a=r.morphTargetsRelative;t.fromBufferAttribute(n,e);const s=this.morphTargetInfluences;if(i&&s){_morphA.set(0,0,0);for(let r=0,n=i.length;r<n;r++){const n=s[r],o=i[r];0!==n&&(_tempA.fromBufferAttribute(o,e),a?_morphA.addScaledVector(_tempA,n):_morphA.addScaledVector(_tempA.sub(t),n))}t.add(_morphA)}return t}raycast(e,t){const r=this.geometry,n=this.material,i=this.matrixWorld;if(void 0!==n){if(null===r.boundingSphere&&r.computeBoundingSphere(),_sphere$6.copy(r.boundingSphere),_sphere$6.applyMatrix4(i),_ray$3.copy(e.ray).recast(e.near),!1===_sphere$6.containsPoint(_ray$3.origin)){if(null===_ray$3.intersectSphere(_sphere$6,_sphereHitAt))return;if(_ray$3.origin.distanceToSquared(_sphereHitAt)>(e.far-e.near)**2)return}_inverseMatrix$3.copy(i).invert(),_ray$3.copy(e.ray).applyMatrix4(_inverseMatrix$3),null!==r.boundingBox&&!1===_ray$3.intersectsBox(r.boundingBox)||this._computeIntersections(e,t,_ray$3)}}_computeIntersections(e,t,r){let n;const i=this.geometry,a=this.material,s=i.index,o=i.attributes.position,l=i.attributes.uv,c=i.attributes.uv1,h=i.attributes.normal,u=i.groups,d=i.drawRange;if(null!==s)if(Array.isArray(a))for(let i=0,o=u.length;i<o;i++){const o=u[i],p=a[o.materialIndex];for(let i=Math.max(o.start,d.start),a=Math.min(s.count,Math.min(o.start+o.count,d.start+d.count));i<a;i+=3){n=checkGeometryIntersection(this,p,e,r,l,c,h,s.getX(i),s.getX(i+1),s.getX(i+2)),n&&(n.faceIndex=Math.floor(i/3),n.face.materialIndex=o.materialIndex,t.push(n))}}else{for(let i=Math.max(0,d.start),o=Math.min(s.count,d.start+d.count);i<o;i+=3){n=checkGeometryIntersection(this,a,e,r,l,c,h,s.getX(i),s.getX(i+1),s.getX(i+2)),n&&(n.faceIndex=Math.floor(i/3),t.push(n))}}else if(void 0!==o)if(Array.isArray(a))for(let i=0,s=u.length;i<s;i++){const s=u[i],p=a[s.materialIndex];for(let i=Math.max(s.start,d.start),a=Math.min(o.count,Math.min(s.start+s.count,d.start+d.count));i<a;i+=3){n=checkGeometryIntersection(this,p,e,r,l,c,h,i,i+1,i+2),n&&(n.faceIndex=Math.floor(i/3),n.face.materialIndex=s.materialIndex,t.push(n))}}else{for(let i=Math.max(0,d.start),s=Math.min(o.count,d.start+d.count);i<s;i+=3){n=checkGeometryIntersection(this,a,e,r,l,c,h,i,i+1,i+2),n&&(n.faceIndex=Math.floor(i/3),t.push(n))}}}}function checkIntersection$1(e,t,r,n,i,a,s,o){let l;if(l=1===t.side?n.intersectTriangle(s,a,i,!0,o):n.intersectTriangle(i,a,s,0===t.side,o),null===l)return null;_intersectionPointWorld.copy(o),_intersectionPointWorld.applyMatrix4(e.matrixWorld);const c=r.ray.origin.distanceTo(_intersectionPointWorld);return c<r.near||c>r.far?null:{distance:c,point:_intersectionPointWorld.clone(),object:e}}function checkGeometryIntersection(e,t,r,n,i,a,s,o,l,c){e.getVertexPosition(o,_vA$1),e.getVertexPosition(l,_vB$1),e.getVertexPosition(c,_vC$1);const h=checkIntersection$1(e,t,r,n,_vA$1,_vB$1,_vC$1,_intersectionPoint);if(h){const e=new Vector3;Triangle.getBarycoord(_intersectionPoint,_vA$1,_vB$1,_vC$1,e),i&&(h.uv=Triangle.getInterpolatedAttribute(i,o,l,c,e,new Vector2)),a&&(h.uv1=Triangle.getInterpolatedAttribute(a,o,l,c,e,new Vector2)),s&&(h.normal=Triangle.getInterpolatedAttribute(s,o,l,c,e,new Vector3),h.normal.dot(n.direction)>0&&h.normal.multiplyScalar(-1));const t={a:o,b:l,c,normal:new Vector3,materialIndex:0};Triangle.getNormal(_vA$1,_vB$1,_vC$1,t.normal),h.face=t,h.barycoord=e}return h}class BoxGeometry extends BufferGeometry{constructor(e=1,t=1,r=1,n=1,i=1,a=1){super(),this.type="BoxGeometry",this.parameters={width:e,height:t,depth:r,widthSegments:n,heightSegments:i,depthSegments:a};const s=this;n=Math.floor(n),i=Math.floor(i),a=Math.floor(a);const o=[],l=[],c=[],h=[];let u=0,d=0;function p(e,t,r,n,i,a,p,m,f,g,_){const v=a/f,x=p/g,y=a/2,M=p/2,S=m/2,b=f+1,T=g+1;let E=0,A=0;const w=new Vector3;for(let a=0;a<T;a++){const s=a*x-M;for(let o=0;o<b;o++){const u=o*v-y;w[e]=u*n,w[t]=s*i,w[r]=S,l.push(w.x,w.y,w.z),w[e]=0,w[t]=0,w[r]=m>0?1:-1,c.push(w.x,w.y,w.z),h.push(o/f),h.push(1-a/g),E+=1}}for(let e=0;e<g;e++)for(let t=0;t<f;t++){const r=u+t+b*e,n=u+t+b*(e+1),i=u+(t+1)+b*(e+1),a=u+(t+1)+b*e;o.push(r,n,a),o.push(n,i,a),A+=6}s.addGroup(d,A,_),d+=A,u+=E}p("z","y","x",-1,-1,r,t,e,a,i,0),p("z","y","x",1,-1,r,t,-e,a,i,1),p("x","z","y",1,1,e,r,t,n,a,2),p("x","z","y",1,-1,e,r,-t,n,a,3),p("x","y","z",1,-1,e,t,r,n,i,4),p("x","y","z",-1,-1,e,t,-r,n,i,5),this.setIndex(o),this.setAttribute("position",new Float32BufferAttribute(l,3)),this.setAttribute("normal",new Float32BufferAttribute(c,3)),this.setAttribute("uv",new Float32BufferAttribute(h,2))}copy(e){return super.copy(e),this.parameters=Object.assign({},e.parameters),this}static fromJSON(e){return new BoxGeometry(e.width,e.height,e.depth,e.widthSegments,e.heightSegments,e.depthSegments)}}function cloneUniforms(e){const t={};for(const r in e){t[r]={};for(const n in e[r]){const i=e[r][n];i&&(i.isColor||i.isMatrix3||i.isMatrix4||i.isVector2||i.isVector3||i.isVector4||i.isTexture||i.isQuaternion)?i.isRenderTargetTexture?(console.warn("UniformsUtils: Textures of render targets cannot be cloned via cloneUniforms() or mergeUniforms()."),t[r][n]=null):t[r][n]=i.clone():Array.isArray(i)?t[r][n]=i.slice():t[r][n]=i}}return t}function mergeUniforms(e){const t={};for(let r=0;r<e.length;r++){const n=cloneUniforms(e[r]);for(const e in n)t[e]=n[e]}return t}function cloneUniformsGroups(e){const t=[];for(let r=0;r<e.length;r++)t.push(e[r].clone());return t}function getUnlitUniformColorSpace(e){const t=e.getRenderTarget();return null===t?e.outputColorSpace:!0===t.isXRRenderTarget?t.texture.colorSpace:ColorManagement.workingColorSpace}const UniformsUtils={clone:cloneUniforms,merge:mergeUniforms};var default_vertex="void main() {\n\tgl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}",default_fragment="void main() {\n\tgl_FragColor = vec4( 1.0, 0.0, 0.0, 1.0 );\n}";class ShaderMaterial extends Material{constructor(e){super(),this.isShaderMaterial=!0,this.type="ShaderMaterial",this.defines={},this.uniforms={},this.uniformsGroups=[],this.vertexShader=default_vertex,this.fragmentShader=default_fragment,this.linewidth=1,this.wireframe=!1,this.wireframeLinewidth=1,this.fog=!1,this.lights=!1,this.clipping=!1,this.forceSinglePass=!0,this.extensions={clipCullDistance:!1,multiDraw:!1},this.defaultAttributeValues={color:[1,1,1],uv:[0,0],uv1:[0,0]},this.index0AttributeName=void 0,this.uniformsNeedUpdate=!1,this.glslVersion=null,void 0!==e&&this.setValues(e)}copy(e){return super.copy(e),this.fragmentShader=e.fragmentShader,this.vertexShader=e.vertexShader,this.uniforms=cloneUniforms(e.uniforms),this.uniformsGroups=cloneUniformsGroups(e.uniformsGroups),this.defines=Object.assign({},e.defines),this.wireframe=e.wireframe,this.wireframeLinewidth=e.wireframeLinewidth,this.fog=e.fog,this.lights=e.lights,this.clipping=e.clipping,this.extensions=Object.assign({},e.extensions),this.glslVersion=e.glslVersion,this}toJSON(e){const t=super.toJSON(e);t.glslVersion=this.glslVersion,t.uniforms={};for(const r in this.uniforms){const n=this.uniforms[r].value;n&&n.isTexture?t.uniforms[r]={type:"t",value:n.toJSON(e).uuid}:n&&n.isColor?t.uniforms[r]={type:"c",value:n.getHex()}:n&&n.isVector2?t.uniforms[r]={type:"v2",value:n.toArray()}:n&&n.isVector3?t.uniforms[r]={type:"v3",value:n.toArray()}:n&&n.isVector4?t.uniforms[r]={type:"v4",value:n.toArray()}:n&&n.isMatrix3?t.uniforms[r]={type:"m3",value:n.toArray()}:n&&n.isMatrix4?t.uniforms[r]={type:"m4",value:n.toArray()}:t.uniforms[r]={value:n}}Object.keys(this.defines).length>0&&(t.defines=this.defines),t.vertexShader=this.vertexShader,t.fragmentShader=this.fragmentShader,t.lights=this.lights,t.clipping=this.clipping;const r={};for(const e in this.extensions)!0===this.extensions[e]&&(r[e]=!0);return Object.keys(r).length>0&&(t.extensions=r),t}}class Camera extends Object3D{constructor(){super(),this.isCamera=!0,this.type="Camera",this.matrixWorldInverse=new Matrix4,this.projectionMatrix=new Matrix4,this.projectionMatrixInverse=new Matrix4,this.coordinateSystem=2e3}copy(e,t){return super.copy(e,t),this.matrixWorldInverse.copy(e.matrixWorldInverse),this.projectionMatrix.copy(e.projectionMatrix),this.projectionMatrixInverse.copy(e.projectionMatrixInverse),this.coordinateSystem=e.coordinateSystem,this}getWorldDirection(e){return super.getWorldDirection(e).negate()}updateMatrixWorld(e){super.updateMatrixWorld(e),this.matrixWorldInverse.copy(this.matrixWorld).invert()}updateWorldMatrix(e,t){super.updateWorldMatrix(e,t),this.matrixWorldInverse.copy(this.matrixWorld).invert()}clone(){return(new this.constructor).copy(this)}}const _v3$1=new Vector3,_minTarget=new Vector2,_maxTarget=new Vector2;class PerspectiveCamera extends Camera{constructor(e=50,t=1,r=.1,n=2e3){super(),this.isPerspectiveCamera=!0,this.type="PerspectiveCamera",this.fov=e,this.zoom=1,this.near=r,this.far=n,this.focus=10,this.aspect=t,this.view=null,this.filmGauge=35,this.filmOffset=0,this.updateProjectionMatrix()}copy(e,t){return super.copy(e,t),this.fov=e.fov,this.zoom=e.zoom,this.near=e.near,this.far=e.far,this.focus=e.focus,this.aspect=e.aspect,this.view=null===e.view?null:Object.assign({},e.view),this.filmGauge=e.filmGauge,this.filmOffset=e.filmOffset,this}setFocalLength(e){const t=.5*this.getFilmHeight()/e;this.fov=2*RAD2DEG*Math.atan(t),this.updateProjectionMatrix()}getFocalLength(){const e=Math.tan(.5*DEG2RAD*this.fov);return.5*this.getFilmHeight()/e}getEffectiveFOV(){return 2*RAD2DEG*Math.atan(Math.tan(.5*DEG2RAD*this.fov)/this.zoom)}getFilmWidth(){return this.filmGauge*Math.min(this.aspect,1)}getFilmHeight(){return this.filmGauge/Math.max(this.aspect,1)}getViewBounds(e,t,r){_v3$1.set(-1,-1,.5).applyMatrix4(this.projectionMatrixInverse),t.set(_v3$1.x,_v3$1.y).multiplyScalar(-e/_v3$1.z),_v3$1.set(1,1,.5).applyMatrix4(this.projectionMatrixInverse),r.set(_v3$1.x,_v3$1.y).multiplyScalar(-e/_v3$1.z)}getViewSize(e,t){return this.getViewBounds(e,_minTarget,_maxTarget),t.subVectors(_maxTarget,_minTarget)}setViewOffset(e,t,r,n,i,a){this.aspect=e/t,null===this.view&&(this.view={enabled:!0,fullWidth:1,fullHeight:1,offsetX:0,offsetY:0,width:1,height:1}),this.view.enabled=!0,this.view.fullWidth=e,this.view.fullHeight=t,this.view.offsetX=r,this.view.offsetY=n,this.view.width=i,this.view.height=a,this.updateProjectionMatrix()}clearViewOffset(){null!==this.view&&(this.view.enabled=!1),this.updateProjectionMatrix()}updateProjectionMatrix(){const e=this.near;let t=e*Math.tan(.5*DEG2RAD*this.fov)/this.zoom,r=2*t,n=this.aspect*r,i=-.5*n;const a=this.view;if(null!==this.view&&this.view.enabled){const e=a.fullWidth,s=a.fullHeight;i+=a.offsetX*n/e,t-=a.offsetY*r/s,n*=a.width/e,r*=a.height/s}const s=this.filmOffset;0!==s&&(i+=e*s/this.getFilmWidth()),this.projectionMatrix.makePerspective(i,i+n,t,t-r,e,this.far,this.coordinateSystem),this.projectionMatrixInverse.copy(this.projectionMatrix).invert()}toJSON(e){const t=super.toJSON(e);return t.object.fov=this.fov,t.object.zoom=this.zoom,t.object.near=this.near,t.object.far=this.far,t.object.focus=this.focus,t.object.aspect=this.aspect,null!==this.view&&(t.object.view=Object.assign({},this.view)),t.object.filmGauge=this.filmGauge,t.object.filmOffset=this.filmOffset,t}}const fov=-90,aspect=1;class CubeCamera extends Object3D{constructor(e,t,r){super(),this.type="CubeCamera",this.renderTarget=r,this.coordinateSystem=null,this.activeMipmapLevel=0;const n=new PerspectiveCamera(-90,1,e,t);n.layers=this.layers,this.add(n);const i=new PerspectiveCamera(-90,1,e,t);i.layers=this.layers,this.add(i);const a=new PerspectiveCamera(-90,1,e,t);a.layers=this.layers,this.add(a);const s=new PerspectiveCamera(-90,1,e,t);s.layers=this.layers,this.add(s);const o=new PerspectiveCamera(-90,1,e,t);o.layers=this.layers,this.add(o);const l=new PerspectiveCamera(-90,1,e,t);l.layers=this.layers,this.add(l)}updateCoordinateSystem(){const e=this.coordinateSystem,t=this.children.concat(),[r,n,i,a,s,o]=t;for(const e of t)this.remove(e);if(2e3===e)r.up.set(0,1,0),r.lookAt(1,0,0),n.up.set(0,1,0),n.lookAt(-1,0,0),i.up.set(0,0,-1),i.lookAt(0,1,0),a.up.set(0,0,1),a.lookAt(0,-1,0),s.up.set(0,1,0),s.lookAt(0,0,1),o.up.set(0,1,0),o.lookAt(0,0,-1);else{if(2001!==e)throw new Error("THREE.CubeCamera.updateCoordinateSystem(): Invalid coordinate system: "+e);r.up.set(0,-1,0),r.lookAt(-1,0,0),n.up.set(0,-1,0),n.lookAt(1,0,0),i.up.set(0,0,1),i.lookAt(0,1,0),a.up.set(0,0,-1),a.lookAt(0,-1,0),s.up.set(0,-1,0),s.lookAt(0,0,1),o.up.set(0,-1,0),o.lookAt(0,0,-1)}for(const e of t)this.add(e),e.updateMatrixWorld()}update(e,t){null===this.parent&&this.updateMatrixWorld();const{renderTarget:r,activeMipmapLevel:n}=this;this.coordinateSystem!==e.coordinateSystem&&(this.coordinateSystem=e.coordinateSystem,this.updateCoordinateSystem());const[i,a,s,o,l,c]=this.children,h=e.getRenderTarget(),u=e.getActiveCubeFace(),d=e.getActiveMipmapLevel(),p=e.xr.enabled;e.xr.enabled=!1;const m=r.texture.generateMipmaps;r.texture.generateMipmaps=!1,e.setRenderTarget(r,0,n),e.render(t,i),e.setRenderTarget(r,1,n),e.render(t,a),e.setRenderTarget(r,2,n),e.render(t,s),e.setRenderTarget(r,3,n),e.render(t,o),e.setRenderTarget(r,4,n),e.render(t,l),r.texture.generateMipmaps=m,e.setRenderTarget(r,5,n),e.render(t,c),e.setRenderTarget(h,u,d),e.xr.enabled=p,r.texture.needsPMREMUpdate=!0}}class CubeTexture extends Texture{constructor(e=[],t=301,r,n,i,a,s,o,l,c){super(e,t,r,n,i,a,s,o,l,c),this.isCubeTexture=!0,this.flipY=!1}get images(){return this.image}set images(e){this.image=e}}class WebGLCubeRenderTarget extends WebGLRenderTarget{constructor(e=1,t={}){super(e,e,t),this.isWebGLCubeRenderTarget=!0;const r={width:e,height:e,depth:1},n=[r,r,r,r,r,r];this.texture=new CubeTexture(n,t.mapping,t.wrapS,t.wrapT,t.magFilter,t.minFilter,t.format,t.type,t.anisotropy,t.colorSpace),this.texture.isRenderTargetTexture=!0,this.texture.generateMipmaps=void 0!==t.generateMipmaps&&t.generateMipmaps,this.texture.minFilter=void 0!==t.minFilter?t.minFilter:1006}fromEquirectangularTexture(e,t){this.texture.type=t.type,this.texture.colorSpace=t.colorSpace,this.texture.generateMipmaps=t.generateMipmaps,this.texture.minFilter=t.minFilter,this.texture.magFilter=t.magFilter;const r={uniforms:{tEquirect:{value:null}},vertexShader:"\n\n\t\t\t\tvarying vec3 vWorldDirection;\n\n\t\t\t\tvec3 transformDirection( in vec3 dir, in mat4 matrix ) {\n\n\t\t\t\t\treturn normalize( ( matrix * vec4( dir, 0.0 ) ).xyz );\n\n\t\t\t\t}\n\n\t\t\t\tvoid main() {\n\n\t\t\t\t\tvWorldDirection = transformDirection( position, modelMatrix );\n\n\t\t\t\t\t#include <begin_vertex>\n\t\t\t\t\t#include <project_vertex>\n\n\t\t\t\t}\n\t\t\t",fragmentShader:"\n\n\t\t\t\tuniform sampler2D tEquirect;\n\n\t\t\t\tvarying vec3 vWorldDirection;\n\n\t\t\t\t#include <common>\n\n\t\t\t\tvoid main() {\n\n\t\t\t\t\tvec3 direction = normalize( vWorldDirection );\n\n\t\t\t\t\tvec2 sampleUV = equirectUv( direction );\n\n\t\t\t\t\tgl_FragColor = texture2D( tEquirect, sampleUV );\n\n\t\t\t\t}\n\t\t\t"},n=new BoxGeometry(5,5,5),i=new ShaderMaterial({name:"CubemapFromEquirect",uniforms:cloneUniforms(r.uniforms),vertexShader:r.vertexShader,fragmentShader:r.fragmentShader,side:1,blending:0});i.uniforms.tEquirect.value=t;const a=new Mesh(n,i),s=t.minFilter;1008===t.minFilter&&(t.minFilter=1006);return new CubeCamera(1,10,this).update(e,a),t.minFilter=s,a.geometry.dispose(),a.material.dispose(),this}clear(e,t=!0,r=!0,n=!0){const i=e.getRenderTarget();for(let i=0;i<6;i++)e.setRenderTarget(this,i),e.clear(t,r,n);e.setRenderTarget(i)}}class Group extends Object3D{constructor(){super(),this.isGroup=!0,this.type="Group"}}const _moveEvent={type:"move"};class WebXRController{constructor(){this._targetRay=null,this._grip=null,this._hand=null}getHandSpace(){return null===this._hand&&(this._hand=new Group,this._hand.matrixAutoUpdate=!1,this._hand.visible=!1,this._hand.joints={},this._hand.inputState={pinching:!1}),this._hand}getTargetRaySpace(){return null===this._targetRay&&(this._targetRay=new Group,this._targetRay.matrixAutoUpdate=!1,this._targetRay.visible=!1,this._targetRay.hasLinearVelocity=!1,this._targetRay.linearVelocity=new Vector3,this._targetRay.hasAngularVelocity=!1,this._targetRay.angularVelocity=new Vector3),this._targetRay}getGripSpace(){return null===this._grip&&(this._grip=new Group,this._grip.matrixAutoUpdate=!1,this._grip.visible=!1,this._grip.hasLinearVelocity=!1,this._grip.linearVelocity=new Vector3,this._grip.hasAngularVelocity=!1,this._grip.angularVelocity=new Vector3),this._grip}dispatchEvent(e){return null!==this._targetRay&&this._targetRay.dispatchEvent(e),null!==this._grip&&this._grip.dispatchEvent(e),null!==this._hand&&this._hand.dispatchEvent(e),this}connect(e){if(e&&e.hand){const t=this._hand;if(t)for(const r of e.hand.values())this._getHandJoint(t,r)}return this.dispatchEvent({type:"connected",data:e}),this}disconnect(e){return this.dispatchEvent({type:"disconnected",data:e}),null!==this._targetRay&&(this._targetRay.visible=!1),null!==this._grip&&(this._grip.visible=!1),null!==this._hand&&(this._hand.visible=!1),this}update(e,t,r){let n=null,i=null,a=null;const s=this._targetRay,o=this._grip,l=this._hand;if(e&&"visible-blurred"!==t.session.visibilityState){if(l&&e.hand){a=!0;for(const n of e.hand.values()){const e=t.getJointPose(n,r),i=this._getHandJoint(l,n);null!==e&&(i.matrix.fromArray(e.transform.matrix),i.matrix.decompose(i.position,i.rotation,i.scale),i.matrixWorldNeedsUpdate=!0,i.jointRadius=e.radius),i.visible=null!==e}const n=l.joints["index-finger-tip"],i=l.joints["thumb-tip"],s=n.position.distanceTo(i.position),o=.02,c=.005;l.inputState.pinching&&s>o+c?(l.inputState.pinching=!1,this.dispatchEvent({type:"pinchend",handedness:e.handedness,target:this})):!l.inputState.pinching&&s<=o-c&&(l.inputState.pinching=!0,this.dispatchEvent({type:"pinchstart",handedness:e.handedness,target:this}))}else null!==o&&e.gripSpace&&(i=t.getPose(e.gripSpace,r),null!==i&&(o.matrix.fromArray(i.transform.matrix),o.matrix.decompose(o.position,o.rotation,o.scale),o.matrixWorldNeedsUpdate=!0,i.linearVelocity?(o.hasLinearVelocity=!0,o.linearVelocity.copy(i.linearVelocity)):o.hasLinearVelocity=!1,i.angularVelocity?(o.hasAngularVelocity=!0,o.angularVelocity.copy(i.angularVelocity)):o.hasAngularVelocity=!1));null!==s&&(n=t.getPose(e.targetRaySpace,r),null===n&&null!==i&&(n=i),null!==n&&(s.matrix.fromArray(n.transform.matrix),s.matrix.decompose(s.position,s.rotation,s.scale),s.matrixWorldNeedsUpdate=!0,n.linearVelocity?(s.hasLinearVelocity=!0,s.linearVelocity.copy(n.linearVelocity)):s.hasLinearVelocity=!1,n.angularVelocity?(s.hasAngularVelocity=!0,s.angularVelocity.copy(n.angularVelocity)):s.hasAngularVelocity=!1,this.dispatchEvent(_moveEvent)))}return null!==s&&(s.visible=null!==n),null!==o&&(o.visible=null!==i),null!==l&&(l.visible=null!==a),this}_getHandJoint(e,t){if(void 0===e.joints[t.jointName]){const r=new Group;r.matrixAutoUpdate=!1,r.visible=!1,e.joints[t.jointName]=r,e.add(r)}return e.joints[t.jointName]}}class FogExp2{constructor(e,t=25e-5){this.isFogExp2=!0,this.name="",this.color=new Color(e),this.density=t}clone(){return new FogExp2(this.color,this.density)}toJSON(){return{type:"FogExp2",name:this.name,color:this.color.getHex(),density:this.density}}}class Fog{constructor(e,t=1,r=1e3){this.isFog=!0,this.name="",this.color=new Color(e),this.near=t,this.far=r}clone(){return new Fog(this.color,this.near,this.far)}toJSON(){return{type:"Fog",name:this.name,color:this.color.getHex(),near:this.near,far:this.far}}}class Scene extends Object3D{constructor(){super(),this.isScene=!0,this.type="Scene",this.background=null,this.environment=null,this.fog=null,this.backgroundBlurriness=0,this.backgroundIntensity=1,this.backgroundRotation=new Euler,this.environmentIntensity=1,this.environmentRotation=new Euler,this.overrideMaterial=null,"undefined"!=typeof __THREE_DEVTOOLS__&&__THREE_DEVTOOLS__.dispatchEvent(new CustomEvent("observe",{detail:this}))}copy(e,t){return super.copy(e,t),null!==e.background&&(this.background=e.background.clone()),null!==e.environment&&(this.environment=e.environment.clone()),null!==e.fog&&(this.fog=e.fog.clone()),this.backgroundBlurriness=e.backgroundBlurriness,this.backgroundIntensity=e.backgroundIntensity,this.backgroundRotation.copy(e.backgroundRotation),this.environmentIntensity=e.environmentIntensity,this.environmentRotation.copy(e.environmentRotation),null!==e.overrideMaterial&&(this.overrideMaterial=e.overrideMaterial.clone()),this.matrixAutoUpdate=e.matrixAutoUpdate,this}toJSON(e){const t=super.toJSON(e);return null!==this.fog&&(t.object.fog=this.fog.toJSON()),this.backgroundBlurriness>0&&(t.object.backgroundBlurriness=this.backgroundBlurriness),1!==this.backgroundIntensity&&(t.object.backgroundIntensity=this.backgroundIntensity),t.object.backgroundRotation=this.backgroundRotation.toArray(),1!==this.environmentIntensity&&(t.object.environmentIntensity=this.environmentIntensity),t.object.environmentRotation=this.environmentRotation.toArray(),t}}class InterleavedBuffer{constructor(e,t){this.isInterleavedBuffer=!0,this.array=e,this.stride=t,this.count=void 0!==e?e.length/t:0,this.usage=35044,this.updateRanges=[],this.version=0,this.uuid=generateUUID()}onUploadCallback(){}set needsUpdate(e){!0===e&&this.version++}setUsage(e){return this.usage=e,this}addUpdateRange(e,t){this.updateRanges.push({start:e,count:t})}clearUpdateRanges(){this.updateRanges.length=0}copy(e){return this.array=new e.array.constructor(e.array),this.count=e.count,this.stride=e.stride,this.usage=e.usage,this}copyAt(e,t,r){e*=this.stride,r*=t.stride;for(let n=0,i=this.stride;n<i;n++)this.array[e+n]=t.array[r+n];return this}set(e,t=0){return this.array.set(e,t),this}clone(e){void 0===e.arrayBuffers&&(e.arrayBuffers={}),void 0===this.array.buffer._uuid&&(this.array.buffer._uuid=generateUUID()),void 0===e.arrayBuffers[this.array.buffer._uuid]&&(e.arrayBuffers[this.array.buffer._uuid]=this.array.slice(0).buffer);const t=new this.array.constructor(e.arrayBuffers[this.array.buffer._uuid]),r=new this.constructor(t,this.stride);return r.setUsage(this.usage),r}onUpload(e){return this.onUploadCallback=e,this}toJSON(e){return void 0===e.arrayBuffers&&(e.arrayBuffers={}),void 0===this.array.buffer._uuid&&(this.array.buffer._uuid=generateUUID()),void 0===e.arrayBuffers[this.array.buffer._uuid]&&(e.arrayBuffers[this.array.buffer._uuid]=Array.from(new Uint32Array(this.array.buffer))),{uuid:this.uuid,buffer:this.array.buffer._uuid,type:this.array.constructor.name,stride:this.stride}}}const _vector$7=new Vector3;class InterleavedBufferAttribute{constructor(e,t,r,n=!1){this.isInterleavedBufferAttribute=!0,this.name="",this.data=e,this.itemSize=t,this.offset=r,this.normalized=n}get count(){return this.data.count}get array(){return this.data.array}set needsUpdate(e){this.data.needsUpdate=e}applyMatrix4(e){for(let t=0,r=this.data.count;t<r;t++)_vector$7.fromBufferAttribute(this,t),_vector$7.applyMatrix4(e),this.setXYZ(t,_vector$7.x,_vector$7.y,_vector$7.z);return this}applyNormalMatrix(e){for(let t=0,r=this.count;t<r;t++)_vector$7.fromBufferAttribute(this,t),_vector$7.applyNormalMatrix(e),this.setXYZ(t,_vector$7.x,_vector$7.y,_vector$7.z);return this}transformDirection(e){for(let t=0,r=this.count;t<r;t++)_vector$7.fromBufferAttribute(this,t),_vector$7.transformDirection(e),this.setXYZ(t,_vector$7.x,_vector$7.y,_vector$7.z);return this}getComponent(e,t){let r=this.array[e*this.data.stride+this.offset+t];return this.normalized&&(r=denormalize(r,this.array)),r}setComponent(e,t,r){return this.normalized&&(r=normalize(r,this.array)),this.data.array[e*this.data.stride+this.offset+t]=r,this}setX(e,t){return this.normalized&&(t=normalize(t,this.array)),this.data.array[e*this.data.stride+this.offset]=t,this}setY(e,t){return this.normalized&&(t=normalize(t,this.array)),this.data.array[e*this.data.stride+this.offset+1]=t,this}setZ(e,t){return this.normalized&&(t=normalize(t,this.array)),this.data.array[e*this.data.stride+this.offset+2]=t,this}setW(e,t){return this.normalized&&(t=normalize(t,this.array)),this.data.array[e*this.data.stride+this.offset+3]=t,this}getX(e){let t=this.data.array[e*this.data.stride+this.offset];return this.normalized&&(t=denormalize(t,this.array)),t}getY(e){let t=this.data.array[e*this.data.stride+this.offset+1];return this.normalized&&(t=denormalize(t,this.array)),t}getZ(e){let t=this.data.array[e*this.data.stride+this.offset+2];return this.normalized&&(t=denormalize(t,this.array)),t}getW(e){let t=this.data.array[e*this.data.stride+this.offset+3];return this.normalized&&(t=denormalize(t,this.array)),t}setXY(e,t,r){return e=e*this.data.stride+this.offset,this.normalized&&(t=normalize(t,this.array),r=normalize(r,this.array)),this.data.array[e+0]=t,this.data.array[e+1]=r,this}setXYZ(e,t,r,n){return e=e*this.data.stride+this.offset,this.normalized&&(t=normalize(t,this.array),r=normalize(r,this.array),n=normalize(n,this.array)),this.data.array[e+0]=t,this.data.array[e+1]=r,this.data.array[e+2]=n,this}setXYZW(e,t,r,n,i){return e=e*this.data.stride+this.offset,this.normalized&&(t=normalize(t,this.array),r=normalize(r,this.array),n=normalize(n,this.array),i=normalize(i,this.array)),this.data.array[e+0]=t,this.data.array[e+1]=r,this.data.array[e+2]=n,this.data.array[e+3]=i,this}clone(e){if(void 0===e){console.log("THREE.InterleavedBufferAttribute.clone(): Cloning an interleaved buffer attribute will de-interleave buffer data.");const e=[];for(let t=0;t<this.count;t++){const r=t*this.data.stride+this.offset;for(let t=0;t<this.itemSize;t++)e.push(this.data.array[r+t])}return new BufferAttribute(new this.array.constructor(e),this.itemSize,this.normalized)}return void 0===e.interleavedBuffers&&(e.interleavedBuffers={}),void 0===e.interleavedBuffers[this.data.uuid]&&(e.interleavedBuffers[this.data.uuid]=this.data.clone(e)),new InterleavedBufferAttribute(e.interleavedBuffers[this.data.uuid],this.itemSize,this.offset,this.normalized)}toJSON(e){if(void 0===e){console.log("THREE.InterleavedBufferAttribute.toJSON(): Serializing an interleaved buffer attribute will de-interleave buffer data.");const e=[];for(let t=0;t<this.count;t++){const r=t*this.data.stride+this.offset;for(let t=0;t<this.itemSize;t++)e.push(this.data.array[r+t])}return{itemSize:this.itemSize,type:this.array.constructor.name,array:e,normalized:this.normalized}}return void 0===e.interleavedBuffers&&(e.interleavedBuffers={}),void 0===e.interleavedBuffers[this.data.uuid]&&(e.interleavedBuffers[this.data.uuid]=this.data.toJSON(e)),{isInterleavedBufferAttribute:!0,itemSize:this.itemSize,data:this.data.uuid,offset:this.offset,normalized:this.normalized}}}class SpriteMaterial extends Material{constructor(e){super(),this.isSpriteMaterial=!0,this.type="SpriteMaterial",this.color=new Color(16777215),this.map=null,this.alphaMap=null,this.rotation=0,this.sizeAttenuation=!0,this.transparent=!0,this.fog=!0,this.setValues(e)}copy(e){return super.copy(e),this.color.copy(e.color),this.map=e.map,this.alphaMap=e.alphaMap,this.rotation=e.rotation,this.sizeAttenuation=e.sizeAttenuation,this.fog=e.fog,this}}let _geometry;const _intersectPoint=new Vector3,_worldScale=new Vector3,_mvPosition=new Vector3,_alignedPosition=new Vector2,_rotatedPosition=new Vector2,_viewWorldMatrix=new Matrix4,_vA=new Vector3,_vB=new Vector3,_vC=new Vector3,_uvA=new Vector2,_uvB=new Vector2,_uvC=new Vector2;class Sprite extends Object3D{constructor(e=new SpriteMaterial){if(super(),this.isSprite=!0,this.type="Sprite",void 0===_geometry){_geometry=new BufferGeometry;const e=new Float32Array([-.5,-.5,0,0,0,.5,-.5,0,1,0,.5,.5,0,1,1,-.5,.5,0,0,1]),t=new InterleavedBuffer(e,5);_geometry.setIndex([0,1,2,0,2,3]),_geometry.setAttribute("position",new InterleavedBufferAttribute(t,3,0,!1)),_geometry.setAttribute("uv",new InterleavedBufferAttribute(t,2,3,!1))}this.geometry=_geometry,this.material=e,this.center=new Vector2(.5,.5)}raycast(e,t){null===e.camera&&console.error('THREE.Sprite: "Raycaster.camera" needs to be set in order to raycast against sprites.'),_worldScale.setFromMatrixScale(this.matrixWorld),_viewWorldMatrix.copy(e.camera.matrixWorld),this.modelViewMatrix.multiplyMatrices(e.camera.matrixWorldInverse,this.matrixWorld),_mvPosition.setFromMatrixPosition(this.modelViewMatrix),e.camera.isPerspectiveCamera&&!1===this.material.sizeAttenuation&&_worldScale.multiplyScalar(-_mvPosition.z);const r=this.material.rotation;let n,i;0!==r&&(i=Math.cos(r),n=Math.sin(r));const a=this.center;transformVertex(_vA.set(-.5,-.5,0),_mvPosition,a,_worldScale,n,i),transformVertex(_vB.set(.5,-.5,0),_mvPosition,a,_worldScale,n,i),transformVertex(_vC.set(.5,.5,0),_mvPosition,a,_worldScale,n,i),_uvA.set(0,0),_uvB.set(1,0),_uvC.set(1,1);let s=e.ray.intersectTriangle(_vA,_vB,_vC,!1,_intersectPoint);if(null===s&&(transformVertex(_vB.set(-.5,.5,0),_mvPosition,a,_worldScale,n,i),_uvB.set(0,1),s=e.ray.intersectTriangle(_vA,_vC,_vB,!1,_intersectPoint),null===s))return;const o=e.ray.origin.distanceTo(_intersectPoint);o<e.near||o>e.far||t.push({distance:o,point:_intersectPoint.clone(),uv:Triangle.getInterpolation(_intersectPoint,_vA,_vB,_vC,_uvA,_uvB,_uvC,new Vector2),face:null,object:this})}copy(e,t){return super.copy(e,t),void 0!==e.center&&this.center.copy(e.center),this.material=e.material,this}}function transformVertex(e,t,r,n,i,a){_alignedPosition.subVectors(e,r).addScalar(.5).multiply(n),void 0!==i?(_rotatedPosition.x=a*_alignedPosition.x-i*_alignedPosition.y,_rotatedPosition.y=i*_alignedPosition.x+a*_alignedPosition.y):_rotatedPosition.copy(_alignedPosition),e.copy(t),e.x+=_rotatedPosition.x,e.y+=_rotatedPosition.y,e.applyMatrix4(_viewWorldMatrix)}const _v1$2=new Vector3,_v2$1=new Vector3;class LOD extends Object3D{constructor(){super(),this.isLOD=!0,this._currentLevel=0,this.type="LOD",Object.defineProperties(this,{levels:{enumerable:!0,value:[]}}),this.autoUpdate=!0}copy(e){super.copy(e,!1);const t=e.levels;for(let e=0,r=t.length;e<r;e++){const r=t[e];this.addLevel(r.object.clone(),r.distance,r.hysteresis)}return this.autoUpdate=e.autoUpdate,this}addLevel(e,t=0,r=0){t=Math.abs(t);const n=this.levels;let i;for(i=0;i<n.length&&!(t<n[i].distance);i++);return n.splice(i,0,{distance:t,hysteresis:r,object:e}),this.add(e),this}removeLevel(e){const t=this.levels;for(let r=0;r<t.length;r++)if(t[r].distance===e){const e=t.splice(r,1);return this.remove(e[0].object),!0}return!1}getCurrentLevel(){return this._currentLevel}getObjectForDistance(e){const t=this.levels;if(t.length>0){let r,n;for(r=1,n=t.length;r<n;r++){let n=t[r].distance;if(t[r].object.visible&&(n-=n*t[r].hysteresis),e<n)break}return t[r-1].object}return null}raycast(e,t){if(this.levels.length>0){_v1$2.setFromMatrixPosition(this.matrixWorld);const r=e.ray.origin.distanceTo(_v1$2);this.getObjectForDistance(r).raycast(e,t)}}update(e){const t=this.levels;if(t.length>1){_v1$2.setFromMatrixPosition(e.matrixWorld),_v2$1.setFromMatrixPosition(this.matrixWorld);const r=_v1$2.distanceTo(_v2$1)/e.zoom;let n,i;for(t[0].object.visible=!0,n=1,i=t.length;n<i;n++){let e=t[n].distance;if(t[n].object.visible&&(e-=e*t[n].hysteresis),!(r>=e))break;t[n-1].object.visible=!1,t[n].object.visible=!0}for(this._currentLevel=n-1;n<i;n++)t[n].object.visible=!1}}toJSON(e){const t=super.toJSON(e);!1===this.autoUpdate&&(t.object.autoUpdate=!1),t.object.levels=[];const r=this.levels;for(let e=0,n=r.length;e<n;e++){const n=r[e];t.object.levels.push({object:n.object.uuid,distance:n.distance,hysteresis:n.hysteresis})}return t}}const _basePosition=new Vector3,_skinIndex=new Vector4,_skinWeight=new Vector4,_vector3=new Vector3,_matrix4=new Matrix4,_vertex=new Vector3,_sphere$5=new Sphere,_inverseMatrix$2=new Matrix4,_ray$2=new Ray;class SkinnedMesh extends Mesh{constructor(e,t){super(e,t),this.isSkinnedMesh=!0,this.type="SkinnedMesh",this.bindMode="attached",this.bindMatrix=new Matrix4,this.bindMatrixInverse=new Matrix4,this.boundingBox=null,this.boundingSphere=null}computeBoundingBox(){const e=this.geometry;null===this.boundingBox&&(this.boundingBox=new Box3),this.boundingBox.makeEmpty();const t=e.getAttribute("position");for(let e=0;e<t.count;e++)this.getVertexPosition(e,_vertex),this.boundingBox.expandByPoint(_vertex)}computeBoundingSphere(){const e=this.geometry;null===this.boundingSphere&&(this.boundingSphere=new Sphere),this.boundingSphere.makeEmpty();const t=e.getAttribute("position");for(let e=0;e<t.count;e++)this.getVertexPosition(e,_vertex),this.boundingSphere.expandByPoint(_vertex)}copy(e,t){return super.copy(e,t),this.bindMode=e.bindMode,this.bindMatrix.copy(e.bindMatrix),this.bindMatrixInverse.copy(e.bindMatrixInverse),this.skeleton=e.skeleton,null!==e.boundingBox&&(this.boundingBox=e.boundingBox.clone()),null!==e.boundingSphere&&(this.boundingSphere=e.boundingSphere.clone()),this}raycast(e,t){const r=this.material,n=this.matrixWorld;void 0!==r&&(null===this.boundingSphere&&this.computeBoundingSphere(),_sphere$5.copy(this.boundingSphere),_sphere$5.applyMatrix4(n),!1!==e.ray.intersectsSphere(_sphere$5)&&(_inverseMatrix$2.copy(n).invert(),_ray$2.copy(e.ray).applyMatrix4(_inverseMatrix$2),null!==this.boundingBox&&!1===_ray$2.intersectsBox(this.boundingBox)||this._computeIntersections(e,t,_ray$2)))}getVertexPosition(e,t){return super.getVertexPosition(e,t),this.applyBoneTransform(e,t),t}bind(e,t){this.skeleton=e,void 0===t&&(this.updateMatrixWorld(!0),this.skeleton.calculateInverses(),t=this.matrixWorld),this.bindMatrix.copy(t),this.bindMatrixInverse.copy(t).invert()}pose(){this.skeleton.pose()}normalizeSkinWeights(){const e=new Vector4,t=this.geometry.attributes.skinWeight;for(let r=0,n=t.count;r<n;r++){e.fromBufferAttribute(t,r);const n=1/e.manhattanLength();n!==1/0?e.multiplyScalar(n):e.set(1,0,0,0),t.setXYZW(r,e.x,e.y,e.z,e.w)}}updateMatrixWorld(e){super.updateMatrixWorld(e),"attached"===this.bindMode?this.bindMatrixInverse.copy(this.matrixWorld).invert():"detached"===this.bindMode?this.bindMatrixInverse.copy(this.bindMatrix).invert():console.warn("THREE.SkinnedMesh: Unrecognized bindMode: "+this.bindMode)}applyBoneTransform(e,t){const r=this.skeleton,n=this.geometry;_skinIndex.fromBufferAttribute(n.attributes.skinIndex,e),_skinWeight.fromBufferAttribute(n.attributes.skinWeight,e),_basePosition.copy(t).applyMatrix4(this.bindMatrix),t.set(0,0,0);for(let e=0;e<4;e++){const n=_skinWeight.getComponent(e);if(0!==n){const i=_skinIndex.getComponent(e);_matrix4.multiplyMatrices(r.bones[i].matrixWorld,r.boneInverses[i]),t.addScaledVector(_vector3.copy(_basePosition).applyMatrix4(_matrix4),n)}}return t.applyMatrix4(this.bindMatrixInverse)}}class Bone extends Object3D{constructor(){super(),this.isBone=!0,this.type="Bone"}}class DataTexture extends Texture{constructor(e=null,t=1,r=1,n,i,a,s,o,l=1003,c=1003,h,u){super(null,a,s,o,l,c,n,i,h,u),this.isDataTexture=!0,this.image={data:e,width:t,height:r},this.generateMipmaps=!1,this.flipY=!1,this.unpackAlignment=1}}const _offsetMatrix=new Matrix4,_identityMatrix=new Matrix4;class Skeleton{constructor(e=[],t=[]){this.uuid=generateUUID(),this.bones=e.slice(0),this.boneInverses=t,this.boneMatrices=null,this.boneTexture=null,this.init()}init(){const e=this.bones,t=this.boneInverses;if(this.boneMatrices=new Float32Array(16*e.length),0===t.length)this.calculateInverses();else if(e.length!==t.length){console.warn("THREE.Skeleton: Number of inverse bone matrices does not match amount of bones."),this.boneInverses=[];for(let e=0,t=this.bones.length;e<t;e++)this.boneInverses.push(new Matrix4)}}calculateInverses(){this.boneInverses.length=0;for(let e=0,t=this.bones.length;e<t;e++){const t=new Matrix4;this.bones[e]&&t.copy(this.bones[e].matrixWorld).invert(),this.boneInverses.push(t)}}pose(){for(let e=0,t=this.bones.length;e<t;e++){const t=this.bones[e];t&&t.matrixWorld.copy(this.boneInverses[e]).invert()}for(let e=0,t=this.bones.length;e<t;e++){const t=this.bones[e];t&&(t.parent&&t.parent.isBone?(t.matrix.copy(t.parent.matrixWorld).invert(),t.matrix.multiply(t.matrixWorld)):t.matrix.copy(t.matrixWorld),t.matrix.decompose(t.position,t.quaternion,t.scale))}}update(){const e=this.bones,t=this.boneInverses,r=this.boneMatrices,n=this.boneTexture;for(let n=0,i=e.length;n<i;n++){const i=e[n]?e[n].matrixWorld:_identityMatrix;_offsetMatrix.multiplyMatrices(i,t[n]),_offsetMatrix.toArray(r,16*n)}null!==n&&(n.needsUpdate=!0)}clone(){return new Skeleton(this.bones,this.boneInverses)}computeBoneTexture(){let e=Math.sqrt(4*this.bones.length);e=4*Math.ceil(e/4),e=Math.max(e,4);const t=new Float32Array(e*e*4);t.set(this.boneMatrices);const r=new DataTexture(t,e,e,1023,1015);return r.needsUpdate=!0,this.boneMatrices=t,this.boneTexture=r,this}getBoneByName(e){for(let t=0,r=this.bones.length;t<r;t++){const r=this.bones[t];if(r.name===e)return r}}dispose(){null!==this.boneTexture&&(this.boneTexture.dispose(),this.boneTexture=null)}fromJSON(e,t){this.uuid=e.uuid;for(let r=0,n=e.bones.length;r<n;r++){const n=e.bones[r];let i=t[n];void 0===i&&(console.warn("THREE.Skeleton: No bone found with UUID:",n),i=new Bone),this.bones.push(i),this.boneInverses.push((new Matrix4).fromArray(e.boneInverses[r]))}return this.init(),this}toJSON(){const e={metadata:{version:4.6,type:"Skeleton",generator:"Skeleton.toJSON"},bones:[],boneInverses:[]};e.uuid=this.uuid;const t=this.bones,r=this.boneInverses;for(let n=0,i=t.length;n<i;n++){const i=t[n];e.bones.push(i.uuid);const a=r[n];e.boneInverses.push(a.toArray())}return e}}class InstancedBufferAttribute extends BufferAttribute{constructor(e,t,r,n=1){super(e,t,r),this.isInstancedBufferAttribute=!0,this.meshPerAttribute=n}copy(e){return super.copy(e),this.meshPerAttribute=e.meshPerAttribute,this}toJSON(){const e=super.toJSON();return e.meshPerAttribute=this.meshPerAttribute,e.isInstancedBufferAttribute=!0,e}}const _instanceLocalMatrix=new Matrix4,_instanceWorldMatrix=new Matrix4,_instanceIntersects=[],_box3=new Box3,_identity=new Matrix4,_mesh$1=new Mesh,_sphere$4=new Sphere;class InstancedMesh extends Mesh{constructor(e,t,r){super(e,t),this.isInstancedMesh=!0,this.instanceMatrix=new InstancedBufferAttribute(new Float32Array(16*r),16),this.instanceColor=null,this.morphTexture=null,this.count=r,this.boundingBox=null,this.boundingSphere=null;for(let e=0;e<r;e++)this.setMatrixAt(e,_identity)}computeBoundingBox(){const e=this.geometry,t=this.count;null===this.boundingBox&&(this.boundingBox=new Box3),null===e.boundingBox&&e.computeBoundingBox(),this.boundingBox.makeEmpty();for(let r=0;r<t;r++)this.getMatrixAt(r,_instanceLocalMatrix),_box3.copy(e.boundingBox).applyMatrix4(_instanceLocalMatrix),this.boundingBox.union(_box3)}computeBoundingSphere(){const e=this.geometry,t=this.count;null===this.boundingSphere&&(this.boundingSphere=new Sphere),null===e.boundingSphere&&e.computeBoundingSphere(),this.boundingSphere.makeEmpty();for(let r=0;r<t;r++)this.getMatrixAt(r,_instanceLocalMatrix),_sphere$4.copy(e.boundingSphere).applyMatrix4(_instanceLocalMatrix),this.boundingSphere.union(_sphere$4)}copy(e,t){return super.copy(e,t),this.instanceMatrix.copy(e.instanceMatrix),null!==e.morphTexture&&(this.morphTexture=e.morphTexture.clone()),null!==e.instanceColor&&(this.instanceColor=e.instanceColor.clone()),this.count=e.count,null!==e.boundingBox&&(this.boundingBox=e.boundingBox.clone()),null!==e.boundingSphere&&(this.boundingSphere=e.boundingSphere.clone()),this}getColorAt(e,t){t.fromArray(this.instanceColor.array,3*e)}getMatrixAt(e,t){t.fromArray(this.instanceMatrix.array,16*e)}getMorphAt(e,t){const r=t.morphTargetInfluences,n=this.morphTexture.source.data.data,i=e*(r.length+1)+1;for(let e=0;e<r.length;e++)r[e]=n[i+e]}raycast(e,t){const r=this.matrixWorld,n=this.count;if(_mesh$1.geometry=this.geometry,_mesh$1.material=this.material,void 0!==_mesh$1.material&&(null===this.boundingSphere&&this.computeBoundingSphere(),_sphere$4.copy(this.boundingSphere),_sphere$4.applyMatrix4(r),!1!==e.ray.intersectsSphere(_sphere$4)))for(let i=0;i<n;i++){this.getMatrixAt(i,_instanceLocalMatrix),_instanceWorldMatrix.multiplyMatrices(r,_instanceLocalMatrix),_mesh$1.matrixWorld=_instanceWorldMatrix,_mesh$1.raycast(e,_instanceIntersects);for(let e=0,r=_instanceIntersects.length;e<r;e++){const r=_instanceIntersects[e];r.instanceId=i,r.object=this,t.push(r)}_instanceIntersects.length=0}}setColorAt(e,t){null===this.instanceColor&&(this.instanceColor=new InstancedBufferAttribute(new Float32Array(3*this.instanceMatrix.count).fill(1),3)),t.toArray(this.instanceColor.array,3*e)}setMatrixAt(e,t){t.toArray(this.instanceMatrix.array,16*e)}setMorphAt(e,t){const r=t.morphTargetInfluences,n=r.length+1;null===this.morphTexture&&(this.morphTexture=new DataTexture(new Float32Array(n*this.count),n,this.count,1028,1015));const i=this.morphTexture.source.data.data;let a=0;for(let e=0;e<r.length;e++)a+=r[e];const s=this.geometry.morphTargetsRelative?1:1-a,o=n*e;i[o]=s,i.set(r,o+1)}updateMorphTargets(){}dispose(){this.dispatchEvent({type:"dispose"}),null!==this.morphTexture&&(this.morphTexture.dispose(),this.morphTexture=null)}}const _vector1=new Vector3,_vector2=new Vector3,_normalMatrix=new Matrix3;class Plane{constructor(e=new Vector3(1,0,0),t=0){this.isPlane=!0,this.normal=e,this.constant=t}set(e,t){return this.normal.copy(e),this.constant=t,this}setComponents(e,t,r,n){return this.normal.set(e,t,r),this.constant=n,this}setFromNormalAndCoplanarPoint(e,t){return this.normal.copy(e),this.constant=-t.dot(this.normal),this}setFromCoplanarPoints(e,t,r){const n=_vector1.subVectors(r,t).cross(_vector2.subVectors(e,t)).normalize();return this.setFromNormalAndCoplanarPoint(n,e),this}copy(e){return this.normal.copy(e.normal),this.constant=e.constant,this}normalize(){const e=1/this.normal.length();return this.normal.multiplyScalar(e),this.constant*=e,this}negate(){return this.constant*=-1,this.normal.negate(),this}distanceToPoint(e){return this.normal.dot(e)+this.constant}distanceToSphere(e){return this.distanceToPoint(e.center)-e.radius}projectPoint(e,t){return t.copy(e).addScaledVector(this.normal,-this.distanceToPoint(e))}intersectLine(e,t){const r=e.delta(_vector1),n=this.normal.dot(r);if(0===n)return 0===this.distanceToPoint(e.start)?t.copy(e.start):null;const i=-(e.start.dot(this.normal)+this.constant)/n;return i<0||i>1?null:t.copy(e.start).addScaledVector(r,i)}intersectsLine(e){const t=this.distanceToPoint(e.start),r=this.distanceToPoint(e.end);return t<0&&r>0||r<0&&t>0}intersectsBox(e){return e.intersectsPlane(this)}intersectsSphere(e){return e.intersectsPlane(this)}coplanarPoint(e){return e.copy(this.normal).multiplyScalar(-this.constant)}applyMatrix4(e,t){const r=t||_normalMatrix.getNormalMatrix(e),n=this.coplanarPoint(_vector1).applyMatrix4(e),i=this.normal.applyMatrix3(r).normalize();return this.constant=-n.dot(i),this}translate(e){return this.constant-=e.dot(this.normal),this}equals(e){return e.normal.equals(this.normal)&&e.constant===this.constant}clone(){return(new this.constructor).copy(this)}}const _sphere$3=new Sphere,_vector$6=new Vector3;class Frustum{constructor(e=new Plane,t=new Plane,r=new Plane,n=new Plane,i=new Plane,a=new Plane){this.planes=[e,t,r,n,i,a]}set(e,t,r,n,i,a){const s=this.planes;return s[0].copy(e),s[1].copy(t),s[2].copy(r),s[3].copy(n),s[4].copy(i),s[5].copy(a),this}copy(e){const t=this.planes;for(let r=0;r<6;r++)t[r].copy(e.planes[r]);return this}setFromProjectionMatrix(e,t=2e3){const r=this.planes,n=e.elements,i=n[0],a=n[1],s=n[2],o=n[3],l=n[4],c=n[5],h=n[6],u=n[7],d=n[8],p=n[9],m=n[10],f=n[11],g=n[12],_=n[13],v=n[14],x=n[15];if(r[0].setComponents(o-i,u-l,f-d,x-g).normalize(),r[1].setComponents(o+i,u+l,f+d,x+g).normalize(),r[2].setComponents(o+a,u+c,f+p,x+_).normalize(),r[3].setComponents(o-a,u-c,f-p,x-_).normalize(),r[4].setComponents(o-s,u-h,f-m,x-v).normalize(),2e3===t)r[5].setComponents(o+s,u+h,f+m,x+v).normalize();else{if(2001!==t)throw new Error("THREE.Frustum.setFromProjectionMatrix(): Invalid coordinate system: "+t);r[5].setComponents(s,h,m,v).normalize()}return this}intersectsObject(e){if(void 0!==e.boundingSphere)null===e.boundingSphere&&e.computeBoundingSphere(),_sphere$3.copy(e.boundingSphere).applyMatrix4(e.matrixWorld);else{const t=e.geometry;null===t.boundingSphere&&t.computeBoundingSphere(),_sphere$3.copy(t.boundingSphere).applyMatrix4(e.matrixWorld)}return this.intersectsSphere(_sphere$3)}intersectsSprite(e){return _sphere$3.center.set(0,0,0),_sphere$3.radius=.7071067811865476,_sphere$3.applyMatrix4(e.matrixWorld),this.intersectsSphere(_sphere$3)}intersectsSphere(e){const t=this.planes,r=e.center,n=-e.radius;for(let e=0;e<6;e++){if(t[e].distanceToPoint(r)<n)return!1}return!0}intersectsBox(e){const t=this.planes;for(let r=0;r<6;r++){const n=t[r];if(_vector$6.x=n.normal.x>0?e.max.x:e.min.x,_vector$6.y=n.normal.y>0?e.max.y:e.min.y,_vector$6.z=n.normal.z>0?e.max.z:e.min.z,n.distanceToPoint(_vector$6)<0)return!1}return!0}containsPoint(e){const t=this.planes;for(let r=0;r<6;r++)if(t[r].distanceToPoint(e)<0)return!1;return!0}clone(){return(new this.constructor).copy(this)}}const _projScreenMatrix$2=new Matrix4,_frustum$1=new Frustum;class FrustumArray{constructor(){this.coordinateSystem=2e3}intersectsObject(e,t){if(!t.isArrayCamera||0===t.cameras.length)return!1;for(let r=0;r<t.cameras.length;r++){const n=t.cameras[r];if(_projScreenMatrix$2.multiplyMatrices(n.projectionMatrix,n.matrixWorldInverse),_frustum$1.setFromProjectionMatrix(_projScreenMatrix$2,this.coordinateSystem),_frustum$1.intersectsObject(e))return!0}return!1}intersectsSprite(e,t){if(!t||!t.cameras||0===t.cameras.length)return!1;for(let r=0;r<t.cameras.length;r++){const n=t.cameras[r];if(_projScreenMatrix$2.multiplyMatrices(n.projectionMatrix,n.matrixWorldInverse),_frustum$1.setFromProjectionMatrix(_projScreenMatrix$2,this.coordinateSystem),_frustum$1.intersectsSprite(e))return!0}return!1}intersectsSphere(e,t){if(!t||!t.cameras||0===t.cameras.length)return!1;for(let r=0;r<t.cameras.length;r++){const n=t.cameras[r];if(_projScreenMatrix$2.multiplyMatrices(n.projectionMatrix,n.matrixWorldInverse),_frustum$1.setFromProjectionMatrix(_projScreenMatrix$2,this.coordinateSystem),_frustum$1.intersectsSphere(e))return!0}return!1}intersectsBox(e,t){if(!t||!t.cameras||0===t.cameras.length)return!1;for(let r=0;r<t.cameras.length;r++){const n=t.cameras[r];if(_projScreenMatrix$2.multiplyMatrices(n.projectionMatrix,n.matrixWorldInverse),_frustum$1.setFromProjectionMatrix(_projScreenMatrix$2,this.coordinateSystem),_frustum$1.intersectsBox(e))return!0}return!1}containsPoint(e,t){if(!t||!t.cameras||0===t.cameras.length)return!1;for(let r=0;r<t.cameras.length;r++){const n=t.cameras[r];if(_projScreenMatrix$2.multiplyMatrices(n.projectionMatrix,n.matrixWorldInverse),_frustum$1.setFromProjectionMatrix(_projScreenMatrix$2,this.coordinateSystem),_frustum$1.containsPoint(e))return!0}return!1}clone(){return new FrustumArray}}function ascIdSort(e,t){return e-t}function sortOpaque(e,t){return e.z-t.z}function sortTransparent(e,t){return t.z-e.z}class MultiDrawRenderList{constructor(){this.index=0,this.pool=[],this.list=[]}push(e,t,r,n){const i=this.pool,a=this.list;this.index>=i.length&&i.push({start:-1,count:-1,z:-1,index:-1});const s=i[this.index];a.push(s),this.index++,s.start=e,s.count=t,s.z=r,s.index=n}reset(){this.list.length=0,this.index=0}}const _matrix$1=new Matrix4,_whiteColor=new Color(1,1,1),_frustum=new Frustum,_frustumArray=new FrustumArray,_box$1=new Box3,_sphere$2=new Sphere,_vector$5=new Vector3,_forward=new Vector3,_temp=new Vector3,_renderList=new MultiDrawRenderList,_mesh=new Mesh,_batchIntersects=[];function copyAttributeData(e,t,r=0){const n=t.itemSize;if(e.isInterleavedBufferAttribute||e.array.constructor!==t.array.constructor){const i=e.count;for(let a=0;a<i;a++)for(let i=0;i<n;i++)t.setComponent(a+r,i,e.getComponent(a,i))}else t.array.set(e.array,r*n);t.needsUpdate=!0}function copyArrayContents(e,t){if(e.constructor!==t.constructor){const r=Math.min(e.length,t.length);for(let n=0;n<r;n++)t[n]=e[n]}else{const r=Math.min(e.length,t.length);t.set(new e.constructor(e.buffer,0,r))}}class BatchedMesh extends Mesh{constructor(e,t,r=2*t,n){super(new BufferGeometry,n),this.isBatchedMesh=!0,this.perObjectFrustumCulled=!0,this.sortObjects=!0,this.boundingBox=null,this.boundingSphere=null,this.customSort=null,this._instanceInfo=[],this._geometryInfo=[],this._availableInstanceIds=[],this._availableGeometryIds=[],this._nextIndexStart=0,this._nextVertexStart=0,this._geometryCount=0,this._visibilityChanged=!0,this._geometryInitialized=!1,this._maxInstanceCount=e,this._maxVertexCount=t,this._maxIndexCount=r,this._multiDrawCounts=new Int32Array(e),this._multiDrawStarts=new Int32Array(e),this._multiDrawCount=0,this._multiDrawInstances=null,this._matricesTexture=null,this._indirectTexture=null,this._colorsTexture=null,this._initMatricesTexture(),this._initIndirectTexture()}get maxInstanceCount(){return this._maxInstanceCount}get instanceCount(){return this._instanceInfo.length-this._availableInstanceIds.length}get unusedVertexCount(){return this._maxVertexCount-this._nextVertexStart}get unusedIndexCount(){return this._maxIndexCount-this._nextIndexStart}_initMatricesTexture(){let e=Math.sqrt(4*this._maxInstanceCount);e=4*Math.ceil(e/4),e=Math.max(e,4);const t=new Float32Array(e*e*4),r=new DataTexture(t,e,e,1023,1015);this._matricesTexture=r}_initIndirectTexture(){let e=Math.sqrt(this._maxInstanceCount);e=Math.ceil(e);const t=new Uint32Array(e*e),r=new DataTexture(t,e,e,1029,1014);this._indirectTexture=r}_initColorsTexture(){let e=Math.sqrt(this._maxInstanceCount);e=Math.ceil(e);const t=new Float32Array(e*e*4).fill(1),r=new DataTexture(t,e,e,1023,1015);r.colorSpace=ColorManagement.workingColorSpace,this._colorsTexture=r}_initializeGeometry(e){const t=this.geometry,r=this._maxVertexCount,n=this._maxIndexCount;if(!1===this._geometryInitialized){for(const n in e.attributes){const i=e.getAttribute(n),{array:a,itemSize:s,normalized:o}=i,l=new a.constructor(r*s),c=new BufferAttribute(l,s,o);t.setAttribute(n,c)}if(null!==e.getIndex()){const e=r>65535?new Uint32Array(n):new Uint16Array(n);t.setIndex(new BufferAttribute(e,1))}this._geometryInitialized=!0}}_validateGeometry(e){const t=this.geometry;if(Boolean(e.getIndex())!==Boolean(t.getIndex()))throw new Error('THREE.BatchedMesh: All geometries must consistently have "index".');for(const r in t.attributes){if(!e.hasAttribute(r))throw new Error(`THREE.BatchedMesh: Added geometry missing "${r}". All geometries must have consistent attributes.`);const n=e.getAttribute(r),i=t.getAttribute(r);if(n.itemSize!==i.itemSize||n.normalized!==i.normalized)throw new Error("THREE.BatchedMesh: All attributes must have a consistent itemSize and normalized value.")}}validateInstanceId(e){const t=this._instanceInfo;if(e<0||e>=t.length||!1===t[e].active)throw new Error(`THREE.BatchedMesh: Invalid instanceId ${e}. Instance is either out of range or has been deleted.`)}validateGeometryId(e){const t=this._geometryInfo;if(e<0||e>=t.length||!1===t[e].active)throw new Error(`THREE.BatchedMesh: Invalid geometryId ${e}. Geometry is either out of range or has been deleted.`)}setCustomSort(e){return this.customSort=e,this}computeBoundingBox(){null===this.boundingBox&&(this.boundingBox=new Box3);const e=this.boundingBox,t=this._instanceInfo;e.makeEmpty();for(let r=0,n=t.length;r<n;r++){if(!1===t[r].active)continue;const n=t[r].geometryIndex;this.getMatrixAt(r,_matrix$1),this.getBoundingBoxAt(n,_box$1).applyMatrix4(_matrix$1),e.union(_box$1)}}computeBoundingSphere(){null===this.boundingSphere&&(this.boundingSphere=new Sphere);const e=this.boundingSphere,t=this._instanceInfo;e.makeEmpty();for(let r=0,n=t.length;r<n;r++){if(!1===t[r].active)continue;const n=t[r].geometryIndex;this.getMatrixAt(r,_matrix$1),this.getBoundingSphereAt(n,_sphere$2).applyMatrix4(_matrix$1),e.union(_sphere$2)}}addInstance(e){if(this._instanceInfo.length>=this.maxInstanceCount&&0===this._availableInstanceIds.length)throw new Error("THREE.BatchedMesh: Maximum item count reached.");const t={visible:!0,active:!0,geometryIndex:e};let r=null;this._availableInstanceIds.length>0?(this._availableInstanceIds.sort(ascIdSort),r=this._availableInstanceIds.shift(),this._instanceInfo[r]=t):(r=this._instanceInfo.length,this._instanceInfo.push(t));const n=this._matricesTexture;_matrix$1.identity().toArray(n.image.data,16*r),n.needsUpdate=!0;const i=this._colorsTexture;return i&&(_whiteColor.toArray(i.image.data,4*r),i.needsUpdate=!0),this._visibilityChanged=!0,r}addGeometry(e,t=-1,r=-1){this._initializeGeometry(e),this._validateGeometry(e);const n={vertexStart:-1,vertexCount:-1,reservedVertexCount:-1,indexStart:-1,indexCount:-1,reservedIndexCount:-1,start:-1,count:-1,boundingBox:null,boundingSphere:null,active:!0},i=this._geometryInfo;n.vertexStart=this._nextVertexStart,n.reservedVertexCount=-1===t?e.getAttribute("position").count:t;const a=e.getIndex();if(null!==a&&(n.indexStart=this._nextIndexStart,n.reservedIndexCount=-1===r?a.count:r),-1!==n.indexStart&&n.indexStart+n.reservedIndexCount>this._maxIndexCount||n.vertexStart+n.reservedVertexCount>this._maxVertexCount)throw new Error("THREE.BatchedMesh: Reserved space request exceeds the maximum buffer size.");let s;return this._availableGeometryIds.length>0?(this._availableGeometryIds.sort(ascIdSort),s=this._availableGeometryIds.shift(),i[s]=n):(s=this._geometryCount,this._geometryCount++,i.push(n)),this.setGeometryAt(s,e),this._nextIndexStart=n.indexStart+n.reservedIndexCount,this._nextVertexStart=n.vertexStart+n.reservedVertexCount,s}setGeometryAt(e,t){if(e>=this._geometryCount)throw new Error("THREE.BatchedMesh: Maximum geometry count reached.");this._validateGeometry(t);const r=this.geometry,n=null!==r.getIndex(),i=r.getIndex(),a=t.getIndex(),s=this._geometryInfo[e];if(n&&a.count>s.reservedIndexCount||t.attributes.position.count>s.reservedVertexCount)throw new Error("THREE.BatchedMesh: Reserved space not large enough for provided geometry.");const o=s.vertexStart,l=s.reservedVertexCount;s.vertexCount=t.getAttribute("position").count;for(const e in r.attributes){const n=t.getAttribute(e),i=r.getAttribute(e);copyAttributeData(n,i,o);const a=n.itemSize;for(let e=n.count,t=l;e<t;e++){const t=o+e;for(let e=0;e<a;e++)i.setComponent(t,e,0)}i.needsUpdate=!0,i.addUpdateRange(o*a,l*a)}if(n){const e=s.indexStart,r=s.reservedIndexCount;s.indexCount=t.getIndex().count;for(let t=0;t<a.count;t++)i.setX(e+t,o+a.getX(t));for(let t=a.count,n=r;t<n;t++)i.setX(e+t,o);i.needsUpdate=!0,i.addUpdateRange(e,s.reservedIndexCount)}return s.start=n?s.indexStart:s.vertexStart,s.count=n?s.indexCount:s.vertexCount,s.boundingBox=null,null!==t.boundingBox&&(s.boundingBox=t.boundingBox.clone()),s.boundingSphere=null,null!==t.boundingSphere&&(s.boundingSphere=t.boundingSphere.clone()),this._visibilityChanged=!0,e}deleteGeometry(e){const t=this._geometryInfo;if(e>=t.length||!1===t[e].active)return this;const r=this._instanceInfo;for(let t=0,n=r.length;t<n;t++)r[t].active&&r[t].geometryIndex===e&&this.deleteInstance(t);return t[e].active=!1,this._availableGeometryIds.push(e),this._visibilityChanged=!0,this}deleteInstance(e){return this.validateInstanceId(e),this._instanceInfo[e].active=!1,this._availableInstanceIds.push(e),this._visibilityChanged=!0,this}optimize(){let e=0,t=0;const r=this._geometryInfo,n=r.map(((e,t)=>t)).sort(((e,t)=>r[e].vertexStart-r[t].vertexStart)),i=this.geometry;for(let a=0,s=r.length;a<s;a++){const s=n[a],o=r[s];if(!1!==o.active){if(null!==i.index){if(o.indexStart!==t){const{indexStart:r,vertexStart:n,reservedIndexCount:a}=o,s=i.index,l=s.array,c=e-n;for(let e=r;e<r+a;e++)l[e]=l[e]+c;s.array.copyWithin(t,r,r+a),s.addUpdateRange(t,a),o.indexStart=t}t+=o.reservedIndexCount}if(o.vertexStart!==e){const{vertexStart:t,reservedVertexCount:r}=o,n=i.attributes;for(const i in n){const a=n[i],{array:s,itemSize:o}=a;s.copyWithin(e*o,t*o,(t+r)*o),a.addUpdateRange(e*o,r*o)}o.vertexStart=e}e+=o.reservedVertexCount,o.start=i.index?o.indexStart:o.vertexStart,this._nextIndexStart=i.index?o.indexStart+o.reservedIndexCount:0,this._nextVertexStart=o.vertexStart+o.reservedVertexCount}}return this}getBoundingBoxAt(e,t){if(e>=this._geometryCount)return null;const r=this.geometry,n=this._geometryInfo[e];if(null===n.boundingBox){const e=new Box3,t=r.index,i=r.attributes.position;for(let r=n.start,a=n.start+n.count;r<a;r++){let n=r;t&&(n=t.getX(n)),e.expandByPoint(_vector$5.fromBufferAttribute(i,n))}n.boundingBox=e}return t.copy(n.boundingBox),t}getBoundingSphereAt(e,t){if(e>=this._geometryCount)return null;const r=this.geometry,n=this._geometryInfo[e];if(null===n.boundingSphere){const t=new Sphere;this.getBoundingBoxAt(e,_box$1),_box$1.getCenter(t.center);const i=r.index,a=r.attributes.position;let s=0;for(let e=n.start,r=n.start+n.count;e<r;e++){let r=e;i&&(r=i.getX(r)),_vector$5.fromBufferAttribute(a,r),s=Math.max(s,t.center.distanceToSquared(_vector$5))}t.radius=Math.sqrt(s),n.boundingSphere=t}return t.copy(n.boundingSphere),t}setMatrixAt(e,t){this.validateInstanceId(e);const r=this._matricesTexture,n=this._matricesTexture.image.data;return t.toArray(n,16*e),r.needsUpdate=!0,this}getMatrixAt(e,t){return this.validateInstanceId(e),t.fromArray(this._matricesTexture.image.data,16*e)}setColorAt(e,t){return this.validateInstanceId(e),null===this._colorsTexture&&this._initColorsTexture(),t.toArray(this._colorsTexture.image.data,4*e),this._colorsTexture.needsUpdate=!0,this}getColorAt(e,t){return this.validateInstanceId(e),t.fromArray(this._colorsTexture.image.data,4*e)}setVisibleAt(e,t){return this.validateInstanceId(e),this._instanceInfo[e].visible===t||(this._instanceInfo[e].visible=t,this._visibilityChanged=!0),this}getVisibleAt(e){return this.validateInstanceId(e),this._instanceInfo[e].visible}setGeometryIdAt(e,t){return this.validateInstanceId(e),this.validateGeometryId(t),this._instanceInfo[e].geometryIndex=t,this}getGeometryIdAt(e){return this.validateInstanceId(e),this._instanceInfo[e].geometryIndex}getGeometryRangeAt(e,t={}){this.validateGeometryId(e);const r=this._geometryInfo[e];return t.vertexStart=r.vertexStart,t.vertexCount=r.vertexCount,t.reservedVertexCount=r.reservedVertexCount,t.indexStart=r.indexStart,t.indexCount=r.indexCount,t.reservedIndexCount=r.reservedIndexCount,t.start=r.start,t.count=r.count,t}setInstanceCount(e){const t=this._availableInstanceIds,r=this._instanceInfo;for(t.sort(ascIdSort);t[t.length-1]===r.length;)r.pop(),t.pop();if(e<r.length)throw new Error(`BatchedMesh: Instance ids outside the range ${e} are being used. Cannot shrink instance count.`);const n=new Int32Array(e),i=new Int32Array(e);copyArrayContents(this._multiDrawCounts,n),copyArrayContents(this._multiDrawStarts,i),this._multiDrawCounts=n,this._multiDrawStarts=i,this._maxInstanceCount=e;const a=this._indirectTexture,s=this._matricesTexture,o=this._colorsTexture;a.dispose(),this._initIndirectTexture(),copyArrayContents(a.image.data,this._indirectTexture.image.data),s.dispose(),this._initMatricesTexture(),copyArrayContents(s.image.data,this._matricesTexture.image.data),o&&(o.dispose(),this._initColorsTexture(),copyArrayContents(o.image.data,this._colorsTexture.image.data))}setGeometrySize(e,t){const r=[...this._geometryInfo].filter((e=>e.active));if(Math.max(...r.map((e=>e.vertexStart+e.reservedVertexCount)))>e)throw new Error(`BatchedMesh: Geometry vertex values are being used outside the range ${t}. Cannot shrink further.`);if(this.geometry.index){if(Math.max(...r.map((e=>e.indexStart+e.reservedIndexCount)))>t)throw new Error(`BatchedMesh: Geometry index values are being used outside the range ${t}. Cannot shrink further.`)}const n=this.geometry;n.dispose(),this._maxVertexCount=e,this._maxIndexCount=t,this._geometryInitialized&&(this._geometryInitialized=!1,this.geometry=new BufferGeometry,this._initializeGeometry(n));const i=this.geometry;n.index&&copyArrayContents(n.index.array,i.index.array);for(const e in n.attributes)copyArrayContents(n.attributes[e].array,i.attributes[e].array)}raycast(e,t){const r=this._instanceInfo,n=this._geometryInfo,i=this.matrixWorld,a=this.geometry;_mesh.material=this.material,_mesh.geometry.index=a.index,_mesh.geometry.attributes=a.attributes,null===_mesh.geometry.boundingBox&&(_mesh.geometry.boundingBox=new Box3),null===_mesh.geometry.boundingSphere&&(_mesh.geometry.boundingSphere=new Sphere);for(let a=0,s=r.length;a<s;a++){if(!r[a].visible||!r[a].active)continue;const s=r[a].geometryIndex,o=n[s];_mesh.geometry.setDrawRange(o.start,o.count),this.getMatrixAt(a,_mesh.matrixWorld).premultiply(i),this.getBoundingBoxAt(s,_mesh.geometry.boundingBox),this.getBoundingSphereAt(s,_mesh.geometry.boundingSphere),_mesh.raycast(e,_batchIntersects);for(let e=0,r=_batchIntersects.length;e<r;e++){const r=_batchIntersects[e];r.object=this,r.batchId=a,t.push(r)}_batchIntersects.length=0}_mesh.material=null,_mesh.geometry.index=null,_mesh.geometry.attributes={},_mesh.geometry.setDrawRange(0,1/0)}copy(e){return super.copy(e),this.geometry=e.geometry.clone(),this.perObjectFrustumCulled=e.perObjectFrustumCulled,this.sortObjects=e.sortObjects,this.boundingBox=null!==e.boundingBox?e.boundingBox.clone():null,this.boundingSphere=null!==e.boundingSphere?e.boundingSphere.clone():null,this._geometryInfo=e._geometryInfo.map((e=>({...e,boundingBox:null!==e.boundingBox?e.boundingBox.clone():null,boundingSphere:null!==e.boundingSphere?e.boundingSphere.clone():null}))),this._instanceInfo=e._instanceInfo.map((e=>({...e}))),this._availableInstanceIds=e._availableInstanceIds.slice(),this._availableGeometryIds=e._availableGeometryIds.slice(),this._nextIndexStart=e._nextIndexStart,this._nextVertexStart=e._nextVertexStart,this._geometryCount=e._geometryCount,this._maxInstanceCount=e._maxInstanceCount,this._maxVertexCount=e._maxVertexCount,this._maxIndexCount=e._maxIndexCount,this._geometryInitialized=e._geometryInitialized,this._multiDrawCounts=e._multiDrawCounts.slice(),this._multiDrawStarts=e._multiDrawStarts.slice(),this._indirectTexture=e._indirectTexture.clone(),this._indirectTexture.image.data=this._indirectTexture.image.data.slice(),this._matricesTexture=e._matricesTexture.clone(),this._matricesTexture.image.data=this._matricesTexture.image.data.slice(),null!==this._colorsTexture&&(this._colorsTexture=e._colorsTexture.clone(),this._colorsTexture.image.data=this._colorsTexture.image.data.slice()),this}dispose(){this.geometry.dispose(),this._matricesTexture.dispose(),this._matricesTexture=null,this._indirectTexture.dispose(),this._indirectTexture=null,null!==this._colorsTexture&&(this._colorsTexture.dispose(),this._colorsTexture=null)}onBeforeRender(e,t,r,n,i){if(!this._visibilityChanged&&!this.perObjectFrustumCulled&&!this.sortObjects)return;const a=n.getIndex(),s=null===a?1:a.array.BYTES_PER_ELEMENT,o=this._instanceInfo,l=this._multiDrawStarts,c=this._multiDrawCounts,h=this._geometryInfo,u=this.perObjectFrustumCulled,d=this._indirectTexture,p=d.image.data,m=r.isArrayCamera?_frustumArray:_frustum;u&&!r.isArrayCamera&&(_matrix$1.multiplyMatrices(r.projectionMatrix,r.matrixWorldInverse).multiply(this.matrixWorld),_frustum.setFromProjectionMatrix(_matrix$1,e.coordinateSystem));let f=0;if(this.sortObjects){_matrix$1.copy(this.matrixWorld).invert(),_vector$5.setFromMatrixPosition(r.matrixWorld).applyMatrix4(_matrix$1),_forward.set(0,0,-1).transformDirection(r.matrixWorld).transformDirection(_matrix$1);for(let e=0,t=o.length;e<t;e++)if(o[e].visible&&o[e].active){const t=o[e].geometryIndex;this.getMatrixAt(e,_matrix$1),this.getBoundingSphereAt(t,_sphere$2).applyMatrix4(_matrix$1);let n=!1;if(u&&(n=!m.intersectsSphere(_sphere$2,r)),!n){const r=h[t],n=_temp.subVectors(_sphere$2.center,_vector$5).dot(_forward);_renderList.push(r.start,r.count,n,e)}}const e=_renderList.list,t=this.customSort;null===t?e.sort(i.transparent?sortTransparent:sortOpaque):t.call(this,e,r);for(let t=0,r=e.length;t<r;t++){const r=e[t];l[f]=r.start*s,c[f]=r.count,p[f]=r.index,f++}_renderList.reset()}else for(let e=0,t=o.length;e<t;e++)if(o[e].visible&&o[e].active){const t=o[e].geometryIndex;let n=!1;if(u&&(this.getMatrixAt(e,_matrix$1),this.getBoundingSphereAt(t,_sphere$2).applyMatrix4(_matrix$1),n=!m.intersectsSphere(_sphere$2,r)),!n){const r=h[t];l[f]=r.start*s,c[f]=r.count,p[f]=e,f++}}d.needsUpdate=!0,this._multiDrawCount=f,this._visibilityChanged=!1}onBeforeShadow(e,t,r,n,i,a){this.onBeforeRender(e,null,n,i,a)}}class LineBasicMaterial extends Material{constructor(e){super(),this.isLineBasicMaterial=!0,this.type="LineBasicMaterial",this.color=new Color(16777215),this.map=null,this.linewidth=1,this.linecap="round",this.linejoin="round",this.fog=!0,this.setValues(e)}copy(e){return super.copy(e),this.color.copy(e.color),this.map=e.map,this.linewidth=e.linewidth,this.linecap=e.linecap,this.linejoin=e.linejoin,this.fog=e.fog,this}}const _vStart=new Vector3,_vEnd=new Vector3,_inverseMatrix$1=new Matrix4,_ray$1=new Ray,_sphere$1=new Sphere,_intersectPointOnRay=new Vector3,_intersectPointOnSegment=new Vector3;class Line extends Object3D{constructor(e=new BufferGeometry,t=new LineBasicMaterial){super(),this.isLine=!0,this.type="Line",this.geometry=e,this.material=t,this.morphTargetDictionary=void 0,this.morphTargetInfluences=void 0,this.updateMorphTargets()}copy(e,t){return super.copy(e,t),this.material=Array.isArray(e.material)?e.material.slice():e.material,this.geometry=e.geometry,this}computeLineDistances(){const e=this.geometry;if(null===e.index){const t=e.attributes.position,r=[0];for(let e=1,n=t.count;e<n;e++)_vStart.fromBufferAttribute(t,e-1),_vEnd.fromBufferAttribute(t,e),r[e]=r[e-1],r[e]+=_vStart.distanceTo(_vEnd);e.setAttribute("lineDistance",new Float32BufferAttribute(r,1))}else console.warn("THREE.Line.computeLineDistances(): Computation only possible with non-indexed BufferGeometry.");return this}raycast(e,t){const r=this.geometry,n=this.matrixWorld,i=e.params.Line.threshold,a=r.drawRange;if(null===r.boundingSphere&&r.computeBoundingSphere(),_sphere$1.copy(r.boundingSphere),_sphere$1.applyMatrix4(n),_sphere$1.radius+=i,!1===e.ray.intersectsSphere(_sphere$1))return;_inverseMatrix$1.copy(n).invert(),_ray$1.copy(e.ray).applyMatrix4(_inverseMatrix$1);const s=i/((this.scale.x+this.scale.y+this.scale.z)/3),o=s*s,l=this.isLineSegments?2:1,c=r.index,h=r.attributes.position;if(null!==c){const r=Math.max(0,a.start),n=Math.min(c.count,a.start+a.count);for(let i=r,a=n-1;i<a;i+=l){const r=c.getX(i),n=c.getX(i+1),a=checkIntersection(this,e,_ray$1,o,r,n,i);a&&t.push(a)}if(this.isLineLoop){const i=c.getX(n-1),a=c.getX(r),s=checkIntersection(this,e,_ray$1,o,i,a,n-1);s&&t.push(s)}}else{const r=Math.max(0,a.start),n=Math.min(h.count,a.start+a.count);for(let i=r,a=n-1;i<a;i+=l){const r=checkIntersection(this,e,_ray$1,o,i,i+1,i);r&&t.push(r)}if(this.isLineLoop){const i=checkIntersection(this,e,_ray$1,o,n-1,r,n-1);i&&t.push(i)}}}updateMorphTargets(){const e=this.geometry.morphAttributes,t=Object.keys(e);if(t.length>0){const r=e[t[0]];if(void 0!==r){this.morphTargetInfluences=[],this.morphTargetDictionary={};for(let e=0,t=r.length;e<t;e++){const t=r[e].name||String(e);this.morphTargetInfluences.push(0),this.morphTargetDictionary[t]=e}}}}}function checkIntersection(e,t,r,n,i,a,s){const o=e.geometry.attributes.position;_vStart.fromBufferAttribute(o,i),_vEnd.fromBufferAttribute(o,a);if(r.distanceSqToSegment(_vStart,_vEnd,_intersectPointOnRay,_intersectPointOnSegment)>n)return;_intersectPointOnRay.applyMatrix4(e.matrixWorld);const l=t.ray.origin.distanceTo(_intersectPointOnRay);return l<t.near||l>t.far?void 0:{distance:l,point:_intersectPointOnSegment.clone().applyMatrix4(e.matrixWorld),index:s,face:null,faceIndex:null,barycoord:null,object:e}}const _start=new Vector3,_end=new Vector3;class LineSegments extends Line{constructor(e,t){super(e,t),this.isLineSegments=!0,this.type="LineSegments"}computeLineDistances(){const e=this.geometry;if(null===e.index){const t=e.attributes.position,r=[];for(let e=0,n=t.count;e<n;e+=2)_start.fromBufferAttribute(t,e),_end.fromBufferAttribute(t,e+1),r[e]=0===e?0:r[e-1],r[e+1]=r[e]+_start.distanceTo(_end);e.setAttribute("lineDistance",new Float32BufferAttribute(r,1))}else console.warn("THREE.LineSegments.computeLineDistances(): Computation only possible with non-indexed BufferGeometry.");return this}}class LineLoop extends Line{constructor(e,t){super(e,t),this.isLineLoop=!0,this.type="LineLoop"}}class PointsMaterial extends Material{constructor(e){super(),this.isPointsMaterial=!0,this.type="PointsMaterial",this.color=new Color(16777215),this.map=null,this.alphaMap=null,this.size=1,this.sizeAttenuation=!0,this.fog=!0,this.setValues(e)}copy(e){return super.copy(e),this.color.copy(e.color),this.map=e.map,this.alphaMap=e.alphaMap,this.size=e.size,this.sizeAttenuation=e.sizeAttenuation,this.fog=e.fog,this}}const _inverseMatrix=new Matrix4,_ray=new Ray,_sphere=new Sphere,_position$2=new Vector3;class Points extends Object3D{constructor(e=new BufferGeometry,t=new PointsMaterial){super(),this.isPoints=!0,this.type="Points",this.geometry=e,this.material=t,this.morphTargetDictionary=void 0,this.morphTargetInfluences=void 0,this.updateMorphTargets()}copy(e,t){return super.copy(e,t),this.material=Array.isArray(e.material)?e.material.slice():e.material,this.geometry=e.geometry,this}raycast(e,t){const r=this.geometry,n=this.matrixWorld,i=e.params.Points.threshold,a=r.drawRange;if(null===r.boundingSphere&&r.computeBoundingSphere(),_sphere.copy(r.boundingSphere),_sphere.applyMatrix4(n),_sphere.radius+=i,!1===e.ray.intersectsSphere(_sphere))return;_inverseMatrix.copy(n).invert(),_ray.copy(e.ray).applyMatrix4(_inverseMatrix);const s=i/((this.scale.x+this.scale.y+this.scale.z)/3),o=s*s,l=r.index,c=r.attributes.position;if(null!==l){for(let r=Math.max(0,a.start),i=Math.min(l.count,a.start+a.count);r<i;r++){const i=l.getX(r);_position$2.fromBufferAttribute(c,i),testPoint(_position$2,i,o,n,e,t,this)}}else{for(let r=Math.max(0,a.start),i=Math.min(c.count,a.start+a.count);r<i;r++)_position$2.fromBufferAttribute(c,r),testPoint(_position$2,r,o,n,e,t,this)}}updateMorphTargets(){const e=this.geometry.morphAttributes,t=Object.keys(e);if(t.length>0){const r=e[t[0]];if(void 0!==r){this.morphTargetInfluences=[],this.morphTargetDictionary={};for(let e=0,t=r.length;e<t;e++){const t=r[e].name||String(e);this.morphTargetInfluences.push(0),this.morphTargetDictionary[t]=e}}}}}function testPoint(e,t,r,n,i,a,s){const o=_ray.distanceSqToPoint(e);if(o<r){const r=new Vector3;_ray.closestPointToPoint(e,r),r.applyMatrix4(n);const l=i.ray.origin.distanceTo(r);if(l<i.near||l>i.far)return;a.push({distance:l,distanceToRay:Math.sqrt(o),point:r,index:t,face:null,faceIndex:null,barycoord:null,object:s})}}class VideoTexture extends Texture{constructor(e,t,r,n,i=1006,a=1006,s,o,l){super(e,t,r,n,i,a,s,o,l),this.isVideoTexture=!0,this.generateMipmaps=!1;const c=this;"requestVideoFrameCallback"in e&&e.requestVideoFrameCallback((function t(){c.needsUpdate=!0,e.requestVideoFrameCallback(t)}))}clone(){return new this.constructor(this.image).copy(this)}update(){const e=this.image;!1==="requestVideoFrameCallback"in e&&e.readyState>=e.HAVE_CURRENT_DATA&&(this.needsUpdate=!0)}}class VideoFrameTexture extends VideoTexture{constructor(e,t,r,n,i,a,s,o){super({},e,t,r,n,i,a,s,o),this.isVideoFrameTexture=!0}update(){}clone(){return(new this.constructor).copy(this)}setFrame(e){this.image=e,this.needsUpdate=!0}}class FramebufferTexture extends Texture{constructor(e,t){super({width:e,height:t}),this.isFramebufferTexture=!0,this.magFilter=1003,this.minFilter=1003,this.generateMipmaps=!1,this.needsUpdate=!0}}class CompressedTexture extends Texture{constructor(e,t,r,n,i,a,s,o,l,c,h,u){super(null,a,s,o,l,c,n,i,h,u),this.isCompressedTexture=!0,this.image={width:t,height:r},this.mipmaps=e,this.flipY=!1,this.generateMipmaps=!1}}class CompressedArrayTexture extends CompressedTexture{constructor(e,t,r,n,i,a){super(e,t,r,i,a),this.isCompressedArrayTexture=!0,this.image.depth=n,this.wrapR=1001,this.layerUpdates=new Set}addLayerUpdate(e){this.layerUpdates.add(e)}clearLayerUpdates(){this.layerUpdates.clear()}}class CompressedCubeTexture extends CompressedTexture{constructor(e,t,r){super(void 0,e[0].width,e[0].height,t,r,301),this.isCompressedCubeTexture=!0,this.isCubeTexture=!0,this.image=e}}class CanvasTexture extends Texture{constructor(e,t,r,n,i,a,s,o,l){super(e,t,r,n,i,a,s,o,l),this.isCanvasTexture=!0,this.needsUpdate=!0}}class DepthTexture extends Texture{constructor(e,t,r=1014,n,i,a,s=1003,o=1003,l,c=1026){if(1026!==c&&1027!==c)throw new Error("DepthTexture format must be either THREE.DepthFormat or THREE.DepthStencilFormat");super(null,n,i,a,s,o,c,r,l),this.isDepthTexture=!0,this.image={width:e,height:t},this.flipY=!1,this.generateMipmaps=!1,this.compareFunction=null}copy(e){return super.copy(e),this.source=new Source(Object.assign({},e.image)),this.compareFunction=e.compareFunction,this}toJSON(e){const t=super.toJSON(e);return null!==this.compareFunction&&(t.compareFunction=this.compareFunction),t}}class DepthArrayTexture extends DepthTexture{constructor(e=1,t=1,r=1){super(e,t),this.isDepthArrayTexture=!0,this.image={width:e,height:t,depth:r},this.flipY=!1,this.generateMipmaps=!1,this.compareFunction=null,this.layerUpdates=new Set}addLayerUpdate(e){this.layerUpdates.add(e)}clearLayerUpdates(){this.layerUpdates.clear()}}class CapsuleGeometry extends BufferGeometry{constructor(e=1,t=1,r=4,n=8,i=1){super(),this.type="CapsuleGeometry",this.parameters={radius:e,height:t,capSegments:r,radialSegments:n,heightSegments:i},t=Math.max(0,t),r=Math.max(1,Math.floor(r)),n=Math.max(3,Math.floor(n)),i=Math.max(1,Math.floor(i));const a=[],s=[],o=[],l=[],c=t/2,h=Math.PI/2*e,u=t,d=2*h+u,p=2*r+i,m=n+1,f=new Vector3,g=new Vector3;for(let _=0;_<=p;_++){let v=0,x=0,y=0,M=0;if(_<=r){const t=_/r,n=t*Math.PI/2;x=-c-e*Math.cos(n),y=e*Math.sin(n),M=-e*Math.cos(n),v=t*h}else if(_<=r+i){const n=(_-r)/i;x=n*t-c,y=e,M=0,v=h+n*u}else{const t=(_-r-i)/r,n=t*Math.PI/2;x=c+e*Math.sin(n),y=e*Math.cos(n),M=e*Math.sin(n),v=h+u+t*h}const S=Math.max(0,Math.min(1,v/d));let b=0;0===_?b=.5/n:_===p&&(b=-.5/n);for(let e=0;e<=n;e++){const t=e/n,r=t*Math.PI*2,i=Math.sin(r),a=Math.cos(r);g.x=-y*a,g.y=x,g.z=y*i,s.push(g.x,g.y,g.z),f.set(-y*a,M,y*i),f.normalize(),o.push(f.x,f.y,f.z),l.push(t+b,S)}if(_>0){const e=(_-1)*m;for(let t=0;t<n;t++){const r=e+t,n=e+t+1,i=_*m+t,s=_*m+t+1;a.push(r,n,i),a.push(n,s,i)}}}this.setIndex(a),this.setAttribute("position",new Float32BufferAttribute(s,3)),this.setAttribute("normal",new Float32BufferAttribute(o,3)),this.setAttribute("uv",new Float32BufferAttribute(l,2))}copy(e){return super.copy(e),this.parameters=Object.assign({},e.parameters),this}static fromJSON(e){return new CapsuleGeometry(e.radius,e.height,e.capSegments,e.radialSegments,e.heightSegments)}}class CircleGeometry extends BufferGeometry{constructor(e=1,t=32,r=0,n=2*Math.PI){super(),this.type="CircleGeometry",this.parameters={radius:e,segments:t,thetaStart:r,thetaLength:n},t=Math.max(3,t);const i=[],a=[],s=[],o=[],l=new Vector3,c=new Vector2;a.push(0,0,0),s.push(0,0,1),o.push(.5,.5);for(let i=0,h=3;i<=t;i++,h+=3){const u=r+i/t*n;l.x=e*Math.cos(u),l.y=e*Math.sin(u),a.push(l.x,l.y,l.z),s.push(0,0,1),c.x=(a[h]/e+1)/2,c.y=(a[h+1]/e+1)/2,o.push(c.x,c.y)}for(let e=1;e<=t;e++)i.push(e,e+1,0);this.setIndex(i),this.setAttribute("position",new Float32BufferAttribute(a,3)),this.setAttribute("normal",new Float32BufferAttribute(s,3)),this.setAttribute("uv",new Float32BufferAttribute(o,2))}copy(e){return super.copy(e),this.parameters=Object.assign({},e.parameters),this}static fromJSON(e){return new CircleGeometry(e.radius,e.segments,e.thetaStart,e.thetaLength)}}class CylinderGeometry extends BufferGeometry{constructor(e=1,t=1,r=1,n=32,i=1,a=!1,s=0,o=2*Math.PI){super(),this.type="CylinderGeometry",this.parameters={radiusTop:e,radiusBottom:t,height:r,radialSegments:n,heightSegments:i,openEnded:a,thetaStart:s,thetaLength:o};const l=this;n=Math.floor(n),i=Math.floor(i);const c=[],h=[],u=[],d=[];let p=0;const m=[],f=r/2;let g=0;function _(r){const i=p,a=new Vector2,m=new Vector3;let _=0;const v=!0===r?e:t,x=!0===r?1:-1;for(let e=1;e<=n;e++)h.push(0,f*x,0),u.push(0,x,0),d.push(.5,.5),p++;const y=p;for(let e=0;e<=n;e++){const t=e/n*o+s,r=Math.cos(t),i=Math.sin(t);m.x=v*i,m.y=f*x,m.z=v*r,h.push(m.x,m.y,m.z),u.push(0,x,0),a.x=.5*r+.5,a.y=.5*i*x+.5,d.push(a.x,a.y),p++}for(let e=0;e<n;e++){const t=i+e,n=y+e;!0===r?c.push(n,n+1,t):c.push(n+1,n,t),_+=3}l.addGroup(g,_,!0===r?1:2),g+=_}!function(){const a=new Vector3,_=new Vector3;let v=0;const x=(t-e)/r;for(let l=0;l<=i;l++){const c=[],g=l/i,v=g*(t-e)+e;for(let e=0;e<=n;e++){const t=e/n,i=t*o+s,l=Math.sin(i),m=Math.cos(i);_.x=v*l,_.y=-g*r+f,_.z=v*m,h.push(_.x,_.y,_.z),a.set(l,x,m).normalize(),u.push(a.x,a.y,a.z),d.push(t,1-g),c.push(p++)}m.push(c)}for(let r=0;r<n;r++)for(let n=0;n<i;n++){const a=m[n][r],s=m[n+1][r],o=m[n+1][r+1],l=m[n][r+1];(e>0||0!==n)&&(c.push(a,s,l),v+=3),(t>0||n!==i-1)&&(c.push(s,o,l),v+=3)}l.addGroup(g,v,0),g+=v}(),!1===a&&(e>0&&_(!0),t>0&&_(!1)),this.setIndex(c),this.setAttribute("position",new Float32BufferAttribute(h,3)),this.setAttribute("normal",new Float32BufferAttribute(u,3)),this.setAttribute("uv",new Float32BufferAttribute(d,2))}copy(e){return super.copy(e),this.parameters=Object.assign({},e.parameters),this}static fromJSON(e){return new CylinderGeometry(e.radiusTop,e.radiusBottom,e.height,e.radialSegments,e.heightSegments,e.openEnded,e.thetaStart,e.thetaLength)}}class ConeGeometry extends CylinderGeometry{constructor(e=1,t=1,r=32,n=1,i=!1,a=0,s=2*Math.PI){super(0,e,t,r,n,i,a,s),this.type="ConeGeometry",this.parameters={radius:e,height:t,radialSegments:r,heightSegments:n,openEnded:i,thetaStart:a,thetaLength:s}}static fromJSON(e){return new ConeGeometry(e.radius,e.height,e.radialSegments,e.heightSegments,e.openEnded,e.thetaStart,e.thetaLength)}}class PolyhedronGeometry extends BufferGeometry{constructor(e=[],t=[],r=1,n=0){super(),this.type="PolyhedronGeometry",this.parameters={vertices:e,indices:t,radius:r,detail:n};const i=[],a=[];function s(e,t,r,n){const i=n+1,a=[];for(let n=0;n<=i;n++){a[n]=[];const s=e.clone().lerp(r,n/i),o=t.clone().lerp(r,n/i),l=i-n;for(let e=0;e<=l;e++)a[n][e]=0===e&&n===i?s:s.clone().lerp(o,e/l)}for(let e=0;e<i;e++)for(let t=0;t<2*(i-e)-1;t++){const r=Math.floor(t/2);t%2==0?(o(a[e][r+1]),o(a[e+1][r]),o(a[e][r])):(o(a[e][r+1]),o(a[e+1][r+1]),o(a[e+1][r]))}}function o(e){i.push(e.x,e.y,e.z)}function l(t,r){const n=3*t;r.x=e[n+0],r.y=e[n+1],r.z=e[n+2]}function c(e,t,r,n){n<0&&1===e.x&&(a[t]=e.x-1),0===r.x&&0===r.z&&(a[t]=n/2/Math.PI+.5)}function h(e){return Math.atan2(e.z,-e.x)}!function(e){const r=new Vector3,n=new Vector3,i=new Vector3;for(let a=0;a<t.length;a+=3)l(t[a+0],r),l(t[a+1],n),l(t[a+2],i),s(r,n,i,e)}(n),function(e){const t=new Vector3;for(let r=0;r<i.length;r+=3)t.x=i[r+0],t.y=i[r+1],t.z=i[r+2],t.normalize().multiplyScalar(e),i[r+0]=t.x,i[r+1]=t.y,i[r+2]=t.z}(r),function(){const e=new Vector3;for(let r=0;r<i.length;r+=3){e.x=i[r+0],e.y=i[r+1],e.z=i[r+2];const n=h(e)/2/Math.PI+.5,s=(t=e,Math.atan2(-t.y,Math.sqrt(t.x*t.x+t.z*t.z))/Math.PI+.5);a.push(n,1-s)}var t;(function(){const e=new Vector3,t=new Vector3,r=new Vector3,n=new Vector3,s=new Vector2,o=new Vector2,l=new Vector2;for(let u=0,d=0;u<i.length;u+=9,d+=6){e.set(i[u+0],i[u+1],i[u+2]),t.set(i[u+3],i[u+4],i[u+5]),r.set(i[u+6],i[u+7],i[u+8]),s.set(a[d+0],a[d+1]),o.set(a[d+2],a[d+3]),l.set(a[d+4],a[d+5]),n.copy(e).add(t).add(r).divideScalar(3);const p=h(n);c(s,d+0,e,p),c(o,d+2,t,p),c(l,d+4,r,p)}})(),function(){for(let e=0;e<a.length;e+=6){const t=a[e+0],r=a[e+2],n=a[e+4],i=Math.max(t,r,n),s=Math.min(t,r,n);i>.9&&s<.1&&(t<.2&&(a[e+0]+=1),r<.2&&(a[e+2]+=1),n<.2&&(a[e+4]+=1))}}()}(),this.setAttribute("position",new Float32BufferAttribute(i,3)),this.setAttribute("normal",new Float32BufferAttribute(i.slice(),3)),this.setAttribute("uv",new Float32BufferAttribute(a,2)),0===n?this.computeVertexNormals():this.normalizeNormals()}copy(e){return super.copy(e),this.parameters=Object.assign({},e.parameters),this}static fromJSON(e){return new PolyhedronGeometry(e.vertices,e.indices,e.radius,e.details)}}class DodecahedronGeometry extends PolyhedronGeometry{constructor(e=1,t=0){const r=(1+Math.sqrt(5))/2,n=1/r;super([-1,-1,-1,-1,-1,1,-1,1,-1,-1,1,1,1,-1,-1,1,-1,1,1,1,-1,1,1,1,0,-n,-r,0,-n,r,0,n,-r,0,n,r,-n,-r,0,-n,r,0,n,-r,0,n,r,0,-r,0,-n,r,0,-n,-r,0,n,r,0,n],[3,11,7,3,7,15,3,15,13,7,19,17,7,17,6,7,6,15,17,4,8,17,8,10,17,10,6,8,0,16,8,16,2,8,2,10,0,12,1,0,1,18,0,18,16,6,10,2,6,2,13,6,13,15,2,16,18,2,18,3,2,3,13,18,1,9,18,9,11,18,11,3,4,14,12,4,12,0,4,0,8,11,9,5,11,5,19,11,19,7,19,5,14,19,14,4,19,4,17,1,12,14,1,14,5,1,5,9],e,t),this.type="DodecahedronGeometry",this.parameters={radius:e,detail:t}}static fromJSON(e){return new DodecahedronGeometry(e.radius,e.detail)}}const _v0$1=new Vector3,_v1$1=new Vector3,_normal=new Vector3,_triangle=new Triangle;class EdgesGeometry extends BufferGeometry{constructor(e=null,t=1){if(super(),this.type="EdgesGeometry",this.parameters={geometry:e,thresholdAngle:t},null!==e){const r=4,n=Math.pow(10,r),i=Math.cos(DEG2RAD*t),a=e.getIndex(),s=e.getAttribute("position"),o=a?a.count:s.count,l=[0,0,0],c=["a","b","c"],h=new Array(3),u={},d=[];for(let e=0;e<o;e+=3){a?(l[0]=a.getX(e),l[1]=a.getX(e+1),l[2]=a.getX(e+2)):(l[0]=e,l[1]=e+1,l[2]=e+2);const{a:t,b:r,c:o}=_triangle;if(t.fromBufferAttribute(s,l[0]),r.fromBufferAttribute(s,l[1]),o.fromBufferAttribute(s,l[2]),_triangle.getNormal(_normal),h[0]=`${Math.round(t.x*n)},${Math.round(t.y*n)},${Math.round(t.z*n)}`,h[1]=`${Math.round(r.x*n)},${Math.round(r.y*n)},${Math.round(r.z*n)}`,h[2]=`${Math.round(o.x*n)},${Math.round(o.y*n)},${Math.round(o.z*n)}`,h[0]!==h[1]&&h[1]!==h[2]&&h[2]!==h[0])for(let e=0;e<3;e++){const t=(e+1)%3,r=h[e],n=h[t],a=_triangle[c[e]],s=_triangle[c[t]],o=`${r}_${n}`,p=`${n}_${r}`;p in u&&u[p]?(_normal.dot(u[p].normal)<=i&&(d.push(a.x,a.y,a.z),d.push(s.x,s.y,s.z)),u[p]=null):o in u||(u[o]={index0:l[e],index1:l[t],normal:_normal.clone()})}}for(const e in u)if(u[e]){const{index0:t,index1:r}=u[e];_v0$1.fromBufferAttribute(s,t),_v1$1.fromBufferAttribute(s,r),d.push(_v0$1.x,_v0$1.y,_v0$1.z),d.push(_v1$1.x,_v1$1.y,_v1$1.z)}this.setAttribute("position",new Float32BufferAttribute(d,3))}}copy(e){return super.copy(e),this.parameters=Object.assign({},e.parameters),this}}class Curve{constructor(){this.type="Curve",this.arcLengthDivisions=200,this.needsUpdate=!1,this.cacheArcLengths=null}getPoint(){console.warn("THREE.Curve: .getPoint() not implemented.")}getPointAt(e,t){const r=this.getUtoTmapping(e);return this.getPoint(r,t)}getPoints(e=5){const t=[];for(let r=0;r<=e;r++)t.push(this.getPoint(r/e));return t}getSpacedPoints(e=5){const t=[];for(let r=0;r<=e;r++)t.push(this.getPointAt(r/e));return t}getLength(){const e=this.getLengths();return e[e.length-1]}getLengths(e=this.arcLengthDivisions){if(this.cacheArcLengths&&this.cacheArcLengths.length===e+1&&!this.needsUpdate)return this.cacheArcLengths;this.needsUpdate=!1;const t=[];let r,n=this.getPoint(0),i=0;t.push(0);for(let a=1;a<=e;a++)r=this.getPoint(a/e),i+=r.distanceTo(n),t.push(i),n=r;return this.cacheArcLengths=t,t}updateArcLengths(){this.needsUpdate=!0,this.getLengths()}getUtoTmapping(e,t=null){const r=this.getLengths();let n=0;const i=r.length;let a;a=t||e*r[i-1];let s,o=0,l=i-1;for(;o<=l;)if(n=Math.floor(o+(l-o)/2),s=r[n]-a,s<0)o=n+1;else{if(!(s>0)){l=n;break}l=n-1}if(n=l,r[n]===a)return n/(i-1);const c=r[n];return(n+(a-c)/(r[n+1]-c))/(i-1)}getTangent(e,t){const r=1e-4;let n=e-r,i=e+r;n<0&&(n=0),i>1&&(i=1);const a=this.getPoint(n),s=this.getPoint(i),o=t||(a.isVector2?new Vector2:new Vector3);return o.copy(s).sub(a).normalize(),o}getTangentAt(e,t){const r=this.getUtoTmapping(e);return this.getTangent(r,t)}computeFrenetFrames(e,t=!1){const r=new Vector3,n=[],i=[],a=[],s=new Vector3,o=new Matrix4;for(let t=0;t<=e;t++){const r=t/e;n[t]=this.getTangentAt(r,new Vector3)}i[0]=new Vector3,a[0]=new Vector3;let l=Number.MAX_VALUE;const c=Math.abs(n[0].x),h=Math.abs(n[0].y),u=Math.abs(n[0].z);c<=l&&(l=c,r.set(1,0,0)),h<=l&&(l=h,r.set(0,1,0)),u<=l&&r.set(0,0,1),s.crossVectors(n[0],r).normalize(),i[0].crossVectors(n[0],s),a[0].crossVectors(n[0],i[0]);for(let t=1;t<=e;t++){if(i[t]=i[t-1].clone(),a[t]=a[t-1].clone(),s.crossVectors(n[t-1],n[t]),s.length()>Number.EPSILON){s.normalize();const e=Math.acos(clamp(n[t-1].dot(n[t]),-1,1));i[t].applyMatrix4(o.makeRotationAxis(s,e))}a[t].crossVectors(n[t],i[t])}if(!0===t){let t=Math.acos(clamp(i[0].dot(i[e]),-1,1));t/=e,n[0].dot(s.crossVectors(i[0],i[e]))>0&&(t=-t);for(let r=1;r<=e;r++)i[r].applyMatrix4(o.makeRotationAxis(n[r],t*r)),a[r].crossVectors(n[r],i[r])}return{tangents:n,normals:i,binormals:a}}clone(){return(new this.constructor).copy(this)}copy(e){return this.arcLengthDivisions=e.arcLengthDivisions,this}toJSON(){const e={metadata:{version:4.6,type:"Curve",generator:"Curve.toJSON"}};return e.arcLengthDivisions=this.arcLengthDivisions,e.type=this.type,e}fromJSON(e){return this.arcLengthDivisions=e.arcLengthDivisions,this}}class EllipseCurve extends Curve{constructor(e=0,t=0,r=1,n=1,i=0,a=2*Math.PI,s=!1,o=0){super(),this.isEllipseCurve=!0,this.type="EllipseCurve",this.aX=e,this.aY=t,this.xRadius=r,this.yRadius=n,this.aStartAngle=i,this.aEndAngle=a,this.aClockwise=s,this.aRotation=o}getPoint(e,t=new Vector2){const r=t,n=2*Math.PI;let i=this.aEndAngle-this.aStartAngle;const a=Math.abs(i)<Number.EPSILON;for(;i<0;)i+=n;for(;i>n;)i-=n;i<Number.EPSILON&&(i=a?0:n),!0!==this.aClockwise||a||(i===n?i=-n:i-=n);const s=this.aStartAngle+e*i;let o=this.aX+this.xRadius*Math.cos(s),l=this.aY+this.yRadius*Math.sin(s);if(0!==this.aRotation){const e=Math.cos(this.aRotation),t=Math.sin(this.aRotation),r=o-this.aX,n=l-this.aY;o=r*e-n*t+this.aX,l=r*t+n*e+this.aY}return r.set(o,l)}copy(e){return super.copy(e),this.aX=e.aX,this.aY=e.aY,this.xRadius=e.xRadius,this.yRadius=e.yRadius,this.aStartAngle=e.aStartAngle,this.aEndAngle=e.aEndAngle,this.aClockwise=e.aClockwise,this.aRotation=e.aRotation,this}toJSON(){const e=super.toJSON();return e.aX=this.aX,e.aY=this.aY,e.xRadius=this.xRadius,e.yRadius=this.yRadius,e.aStartAngle=this.aStartAngle,e.aEndAngle=this.aEndAngle,e.aClockwise=this.aClockwise,e.aRotation=this.aRotation,e}fromJSON(e){return super.fromJSON(e),this.aX=e.aX,this.aY=e.aY,this.xRadius=e.xRadius,this.yRadius=e.yRadius,this.aStartAngle=e.aStartAngle,this.aEndAngle=e.aEndAngle,this.aClockwise=e.aClockwise,this.aRotation=e.aRotation,this}}class ArcCurve extends EllipseCurve{constructor(e,t,r,n,i,a){super(e,t,r,r,n,i,a),this.isArcCurve=!0,this.type="ArcCurve"}}function CubicPoly(){let e=0,t=0,r=0,n=0;function i(i,a,s,o){e=i,t=s,r=-3*i+3*a-2*s-o,n=2*i-2*a+s+o}return{initCatmullRom:function(e,t,r,n,a){i(t,r,a*(r-e),a*(n-t))},initNonuniformCatmullRom:function(e,t,r,n,a,s,o){let l=(t-e)/a-(r-e)/(a+s)+(r-t)/s,c=(r-t)/s-(n-t)/(s+o)+(n-r)/o;l*=s,c*=s,i(t,r,l,c)},calc:function(i){const a=i*i;return e+t*i+r*a+n*(a*i)}}}const tmp=new Vector3,px=new CubicPoly,py=new CubicPoly,pz=new CubicPoly;class CatmullRomCurve3 extends Curve{constructor(e=[],t=!1,r="centripetal",n=.5){super(),this.isCatmullRomCurve3=!0,this.type="CatmullRomCurve3",this.points=e,this.closed=t,this.curveType=r,this.tension=n}getPoint(e,t=new Vector3){const r=t,n=this.points,i=n.length,a=(i-(this.closed?0:1))*e;let s,o,l=Math.floor(a),c=a-l;this.closed?l+=l>0?0:(Math.floor(Math.abs(l)/i)+1)*i:0===c&&l===i-1&&(l=i-2,c=1),this.closed||l>0?s=n[(l-1)%i]:(tmp.subVectors(n[0],n[1]).add(n[0]),s=tmp);const h=n[l%i],u=n[(l+1)%i];if(this.closed||l+2<i?o=n[(l+2)%i]:(tmp.subVectors(n[i-1],n[i-2]).add(n[i-1]),o=tmp),"centripetal"===this.curveType||"chordal"===this.curveType){const e="chordal"===this.curveType?.5:.25;let t=Math.pow(s.distanceToSquared(h),e),r=Math.pow(h.distanceToSquared(u),e),n=Math.pow(u.distanceToSquared(o),e);r<1e-4&&(r=1),t<1e-4&&(t=r),n<1e-4&&(n=r),px.initNonuniformCatmullRom(s.x,h.x,u.x,o.x,t,r,n),py.initNonuniformCatmullRom(s.y,h.y,u.y,o.y,t,r,n),pz.initNonuniformCatmullRom(s.z,h.z,u.z,o.z,t,r,n)}else"catmullrom"===this.curveType&&(px.initCatmullRom(s.x,h.x,u.x,o.x,this.tension),py.initCatmullRom(s.y,h.y,u.y,o.y,this.tension),pz.initCatmullRom(s.z,h.z,u.z,o.z,this.tension));return r.set(px.calc(c),py.calc(c),pz.calc(c)),r}copy(e){super.copy(e),this.points=[];for(let t=0,r=e.points.length;t<r;t++){const r=e.points[t];this.points.push(r.clone())}return this.closed=e.closed,this.curveType=e.curveType,this.tension=e.tension,this}toJSON(){const e=super.toJSON();e.points=[];for(let t=0,r=this.points.length;t<r;t++){const r=this.points[t];e.points.push(r.toArray())}return e.closed=this.closed,e.curveType=this.curveType,e.tension=this.tension,e}fromJSON(e){super.fromJSON(e),this.points=[];for(let t=0,r=e.points.length;t<r;t++){const r=e.points[t];this.points.push((new Vector3).fromArray(r))}return this.closed=e.closed,this.curveType=e.curveType,this.tension=e.tension,this}}function CatmullRom(e,t,r,n,i){const a=.5*(n-t),s=.5*(i-r),o=e*e;return(2*r-2*n+a+s)*(e*o)+(-3*r+3*n-2*a-s)*o+a*e+r}function QuadraticBezierP0(e,t){const r=1-e;return r*r*t}function QuadraticBezierP1(e,t){return 2*(1-e)*e*t}function QuadraticBezierP2(e,t){return e*e*t}function QuadraticBezier(e,t,r,n){return QuadraticBezierP0(e,t)+QuadraticBezierP1(e,r)+QuadraticBezierP2(e,n)}function CubicBezierP0(e,t){const r=1-e;return r*r*r*t}function CubicBezierP1(e,t){const r=1-e;return 3*r*r*e*t}function CubicBezierP2(e,t){return 3*(1-e)*e*e*t}function CubicBezierP3(e,t){return e*e*e*t}function CubicBezier(e,t,r,n,i){return CubicBezierP0(e,t)+CubicBezierP1(e,r)+CubicBezierP2(e,n)+CubicBezierP3(e,i)}class CubicBezierCurve extends Curve{constructor(e=new Vector2,t=new Vector2,r=new Vector2,n=new Vector2){super(),this.isCubicBezierCurve=!0,this.type="CubicBezierCurve",this.v0=e,this.v1=t,this.v2=r,this.v3=n}getPoint(e,t=new Vector2){const r=t,n=this.v0,i=this.v1,a=this.v2,s=this.v3;return r.set(CubicBezier(e,n.x,i.x,a.x,s.x),CubicBezier(e,n.y,i.y,a.y,s.y)),r}copy(e){return super.copy(e),this.v0.copy(e.v0),this.v1.copy(e.v1),this.v2.copy(e.v2),this.v3.copy(e.v3),this}toJSON(){const e=super.toJSON();return e.v0=this.v0.toArray(),e.v1=this.v1.toArray(),e.v2=this.v2.toArray(),e.v3=this.v3.toArray(),e}fromJSON(e){return super.fromJSON(e),this.v0.fromArray(e.v0),this.v1.fromArray(e.v1),this.v2.fromArray(e.v2),this.v3.fromArray(e.v3),this}}class CubicBezierCurve3 extends Curve{constructor(e=new Vector3,t=new Vector3,r=new Vector3,n=new Vector3){super(),this.isCubicBezierCurve3=!0,this.type="CubicBezierCurve3",this.v0=e,this.v1=t,this.v2=r,this.v3=n}getPoint(e,t=new Vector3){const r=t,n=this.v0,i=this.v1,a=this.v2,s=this.v3;return r.set(CubicBezier(e,n.x,i.x,a.x,s.x),CubicBezier(e,n.y,i.y,a.y,s.y),CubicBezier(e,n.z,i.z,a.z,s.z)),r}copy(e){return super.copy(e),this.v0.copy(e.v0),this.v1.copy(e.v1),this.v2.copy(e.v2),this.v3.copy(e.v3),this}toJSON(){const e=super.toJSON();return e.v0=this.v0.toArray(),e.v1=this.v1.toArray(),e.v2=this.v2.toArray(),e.v3=this.v3.toArray(),e}fromJSON(e){return super.fromJSON(e),this.v0.fromArray(e.v0),this.v1.fromArray(e.v1),this.v2.fromArray(e.v2),this.v3.fromArray(e.v3),this}}class LineCurve extends Curve{constructor(e=new Vector2,t=new Vector2){super(),this.isLineCurve=!0,this.type="LineCurve",this.v1=e,this.v2=t}getPoint(e,t=new Vector2){const r=t;return 1===e?r.copy(this.v2):(r.copy(this.v2).sub(this.v1),r.multiplyScalar(e).add(this.v1)),r}getPointAt(e,t){return this.getPoint(e,t)}getTangent(e,t=new Vector2){return t.subVectors(this.v2,this.v1).normalize()}getTangentAt(e,t){return this.getTangent(e,t)}copy(e){return super.copy(e),this.v1.copy(e.v1),this.v2.copy(e.v2),this}toJSON(){const e=super.toJSON();return e.v1=this.v1.toArray(),e.v2=this.v2.toArray(),e}fromJSON(e){return super.fromJSON(e),this.v1.fromArray(e.v1),this.v2.fromArray(e.v2),this}}class LineCurve3 extends Curve{constructor(e=new Vector3,t=new Vector3){super(),this.isLineCurve3=!0,this.type="LineCurve3",this.v1=e,this.v2=t}getPoint(e,t=new Vector3){const r=t;return 1===e?r.copy(this.v2):(r.copy(this.v2).sub(this.v1),r.multiplyScalar(e).add(this.v1)),r}getPointAt(e,t){return this.getPoint(e,t)}getTangent(e,t=new Vector3){return t.subVectors(this.v2,this.v1).normalize()}getTangentAt(e,t){return this.getTangent(e,t)}copy(e){return super.copy(e),this.v1.copy(e.v1),this.v2.copy(e.v2),this}toJSON(){const e=super.toJSON();return e.v1=this.v1.toArray(),e.v2=this.v2.toArray(),e}fromJSON(e){return super.fromJSON(e),this.v1.fromArray(e.v1),this.v2.fromArray(e.v2),this}}class QuadraticBezierCurve extends Curve{constructor(e=new Vector2,t=new Vector2,r=new Vector2){super(),this.isQuadraticBezierCurve=!0,this.type="QuadraticBezierCurve",this.v0=e,this.v1=t,this.v2=r}getPoint(e,t=new Vector2){const r=t,n=this.v0,i=this.v1,a=this.v2;return r.set(QuadraticBezier(e,n.x,i.x,a.x),QuadraticBezier(e,n.y,i.y,a.y)),r}copy(e){return super.copy(e),this.v0.copy(e.v0),this.v1.copy(e.v1),this.v2.copy(e.v2),this}toJSON(){const e=super.toJSON();return e.v0=this.v0.toArray(),e.v1=this.v1.toArray(),e.v2=this.v2.toArray(),e}fromJSON(e){return super.fromJSON(e),this.v0.fromArray(e.v0),this.v1.fromArray(e.v1),this.v2.fromArray(e.v2),this}}class QuadraticBezierCurve3 extends Curve{constructor(e=new Vector3,t=new Vector3,r=new Vector3){super(),this.isQuadraticBezierCurve3=!0,this.type="QuadraticBezierCurve3",this.v0=e,this.v1=t,this.v2=r}getPoint(e,t=new Vector3){const r=t,n=this.v0,i=this.v1,a=this.v2;return r.set(QuadraticBezier(e,n.x,i.x,a.x),QuadraticBezier(e,n.y,i.y,a.y),QuadraticBezier(e,n.z,i.z,a.z)),r}copy(e){return super.copy(e),this.v0.copy(e.v0),this.v1.copy(e.v1),this.v2.copy(e.v2),this}toJSON(){const e=super.toJSON();return e.v0=this.v0.toArray(),e.v1=this.v1.toArray(),e.v2=this.v2.toArray(),e}fromJSON(e){return super.fromJSON(e),this.v0.fromArray(e.v0),this.v1.fromArray(e.v1),this.v2.fromArray(e.v2),this}}class SplineCurve extends Curve{constructor(e=[]){super(),this.isSplineCurve=!0,this.type="SplineCurve",this.points=e}getPoint(e,t=new Vector2){const r=t,n=this.points,i=(n.length-1)*e,a=Math.floor(i),s=i-a,o=n[0===a?a:a-1],l=n[a],c=n[a>n.length-2?n.length-1:a+1],h=n[a>n.length-3?n.length-1:a+2];return r.set(CatmullRom(s,o.x,l.x,c.x,h.x),CatmullRom(s,o.y,l.y,c.y,h.y)),r}copy(e){super.copy(e),this.points=[];for(let t=0,r=e.points.length;t<r;t++){const r=e.points[t];this.points.push(r.clone())}return this}toJSON(){const e=super.toJSON();e.points=[];for(let t=0,r=this.points.length;t<r;t++){const r=this.points[t];e.points.push(r.toArray())}return e}fromJSON(e){super.fromJSON(e),this.points=[];for(let t=0,r=e.points.length;t<r;t++){const r=e.points[t];this.points.push((new Vector2).fromArray(r))}return this}}var Curves=Object.freeze({__proto__:null,ArcCurve,CatmullRomCurve3,CubicBezierCurve,CubicBezierCurve3,EllipseCurve,LineCurve,LineCurve3,QuadraticBezierCurve,QuadraticBezierCurve3,SplineCurve});class CurvePath extends Curve{constructor(){super(),this.type="CurvePath",this.curves=[],this.autoClose=!1}add(e){this.curves.push(e)}closePath(){const e=this.curves[0].getPoint(0),t=this.curves[this.curves.length-1].getPoint(1);if(!e.equals(t)){const r=!0===e.isVector2?"LineCurve":"LineCurve3";this.curves.push(new Curves[r](t,e))}return this}getPoint(e,t){const r=e*this.getLength(),n=this.getCurveLengths();let i=0;for(;i<n.length;){if(n[i]>=r){const e=n[i]-r,a=this.curves[i],s=a.getLength(),o=0===s?0:1-e/s;return a.getPointAt(o,t)}i++}return null}getLength(){const e=this.getCurveLengths();return e[e.length-1]}updateArcLengths(){this.needsUpdate=!0,this.cacheLengths=null,this.getCurveLengths()}getCurveLengths(){if(this.cacheLengths&&this.cacheLengths.length===this.curves.length)return this.cacheLengths;const e=[];let t=0;for(let r=0,n=this.curves.length;r<n;r++)t+=this.curves[r].getLength(),e.push(t);return this.cacheLengths=e,e}getSpacedPoints(e=40){const t=[];for(let r=0;r<=e;r++)t.push(this.getPoint(r/e));return this.autoClose&&t.push(t[0]),t}getPoints(e=12){const t=[];let r;for(let n=0,i=this.curves;n<i.length;n++){const a=i[n],s=a.isEllipseCurve?2*e:a.isLineCurve||a.isLineCurve3?1:a.isSplineCurve?e*a.points.length:e,o=a.getPoints(s);for(let e=0;e<o.length;e++){const n=o[e];r&&r.equals(n)||(t.push(n),r=n)}}return this.autoClose&&t.length>1&&!t[t.length-1].equals(t[0])&&t.push(t[0]),t}copy(e){super.copy(e),this.curves=[];for(let t=0,r=e.curves.length;t<r;t++){const r=e.curves[t];this.curves.push(r.clone())}return this.autoClose=e.autoClose,this}toJSON(){const e=super.toJSON();e.autoClose=this.autoClose,e.curves=[];for(let t=0,r=this.curves.length;t<r;t++){const r=this.curves[t];e.curves.push(r.toJSON())}return e}fromJSON(e){super.fromJSON(e),this.autoClose=e.autoClose,this.curves=[];for(let t=0,r=e.curves.length;t<r;t++){const r=e.curves[t];this.curves.push((new Curves[r.type]).fromJSON(r))}return this}}class Path extends CurvePath{constructor(e){super(),this.type="Path",this.currentPoint=new Vector2,e&&this.setFromPoints(e)}setFromPoints(e){this.moveTo(e[0].x,e[0].y);for(let t=1,r=e.length;t<r;t++)this.lineTo(e[t].x,e[t].y);return this}moveTo(e,t){return this.currentPoint.set(e,t),this}lineTo(e,t){const r=new LineCurve(this.currentPoint.clone(),new Vector2(e,t));return this.curves.push(r),this.currentPoint.set(e,t),this}quadraticCurveTo(e,t,r,n){const i=new QuadraticBezierCurve(this.currentPoint.clone(),new Vector2(e,t),new Vector2(r,n));return this.curves.push(i),this.currentPoint.set(r,n),this}bezierCurveTo(e,t,r,n,i,a){const s=new CubicBezierCurve(this.currentPoint.clone(),new Vector2(e,t),new Vector2(r,n),new Vector2(i,a));return this.curves.push(s),this.currentPoint.set(i,a),this}splineThru(e){const t=[this.currentPoint.clone()].concat(e),r=new SplineCurve(t);return this.curves.push(r),this.currentPoint.copy(e[e.length-1]),this}arc(e,t,r,n,i,a){const s=this.currentPoint.x,o=this.currentPoint.y;return this.absarc(e+s,t+o,r,n,i,a),this}absarc(e,t,r,n,i,a){return this.absellipse(e,t,r,r,n,i,a),this}ellipse(e,t,r,n,i,a,s,o){const l=this.currentPoint.x,c=this.currentPoint.y;return this.absellipse(e+l,t+c,r,n,i,a,s,o),this}absellipse(e,t,r,n,i,a,s,o){const l=new EllipseCurve(e,t,r,n,i,a,s,o);if(this.curves.length>0){const e=l.getPoint(0);e.equals(this.currentPoint)||this.lineTo(e.x,e.y)}this.curves.push(l);const c=l.getPoint(1);return this.currentPoint.copy(c),this}copy(e){return super.copy(e),this.currentPoint.copy(e.currentPoint),this}toJSON(){const e=super.toJSON();return e.currentPoint=this.currentPoint.toArray(),e}fromJSON(e){return super.fromJSON(e),this.currentPoint.fromArray(e.currentPoint),this}}class Shape extends Path{constructor(e){super(e),this.uuid=generateUUID(),this.type="Shape",this.holes=[]}getPointsHoles(e){const t=[];for(let r=0,n=this.holes.length;r<n;r++)t[r]=this.holes[r].getPoints(e);return t}extractPoints(e){return{shape:this.getPoints(e),holes:this.getPointsHoles(e)}}copy(e){super.copy(e),this.holes=[];for(let t=0,r=e.holes.length;t<r;t++){const r=e.holes[t];this.holes.push(r.clone())}return this}toJSON(){const e=super.toJSON();e.uuid=this.uuid,e.holes=[];for(let t=0,r=this.holes.length;t<r;t++){const r=this.holes[t];e.holes.push(r.toJSON())}return e}fromJSON(e){super.fromJSON(e),this.uuid=e.uuid,this.holes=[];for(let t=0,r=e.holes.length;t<r;t++){const r=e.holes[t];this.holes.push((new Path).fromJSON(r))}return this}}function earcut(e,t,r=2){const n=t&&t.length,i=n?t[0]*r:e.length;let a=linkedList(e,0,i,r,!0);const s=[];if(!a||a.next===a.prev)return s;let o,l,c;if(n&&(a=eliminateHoles(e,t,a,r)),e.length>80*r){o=1/0,l=1/0;let t=-1/0,n=-1/0;for(let a=r;a<i;a+=r){const r=e[a],i=e[a+1];r<o&&(o=r),i<l&&(l=i),r>t&&(t=r),i>n&&(n=i)}c=Math.max(t-o,n-l),c=0!==c?32767/c:0}return earcutLinked(a,s,r,o,l,c,0),s}function linkedList(e,t,r,n,i){let a;if(i===signedArea(e,t,r,n)>0)for(let i=t;i<r;i+=n)a=insertNode(i/n|0,e[i],e[i+1],a);else for(let i=r-n;i>=t;i-=n)a=insertNode(i/n|0,e[i],e[i+1],a);return a&&equals(a,a.next)&&(removeNode(a),a=a.next),a}function filterPoints(e,t){if(!e)return e;t||(t=e);let r,n=e;do{if(r=!1,n.steiner||!equals(n,n.next)&&0!==area(n.prev,n,n.next))n=n.next;else{if(removeNode(n),n=t=n.prev,n===n.next)break;r=!0}}while(r||n!==t);return t}function earcutLinked(e,t,r,n,i,a,s){if(!e)return;!s&&a&&indexCurve(e,n,i,a);let o=e;for(;e.prev!==e.next;){const l=e.prev,c=e.next;if(a?isEarHashed(e,n,i,a):isEar(e))t.push(l.i,e.i,c.i),removeNode(e),e=c.next,o=c.next;else if((e=c)===o){s?1===s?earcutLinked(e=cureLocalIntersections(filterPoints(e),t),t,r,n,i,a,2):2===s&&splitEarcut(e,t,r,n,i,a):earcutLinked(filterPoints(e),t,r,n,i,a,1);break}}}function isEar(e){const t=e.prev,r=e,n=e.next;if(area(t,r,n)>=0)return!1;const i=t.x,a=r.x,s=n.x,o=t.y,l=r.y,c=n.y,h=Math.min(i,a,s),u=Math.min(o,l,c),d=Math.max(i,a,s),p=Math.max(o,l,c);let m=n.next;for(;m!==t;){if(m.x>=h&&m.x<=d&&m.y>=u&&m.y<=p&&pointInTriangleExceptFirst(i,o,a,l,s,c,m.x,m.y)&&area(m.prev,m,m.next)>=0)return!1;m=m.next}return!0}function isEarHashed(e,t,r,n){const i=e.prev,a=e,s=e.next;if(area(i,a,s)>=0)return!1;const o=i.x,l=a.x,c=s.x,h=i.y,u=a.y,d=s.y,p=Math.min(o,l,c),m=Math.min(h,u,d),f=Math.max(o,l,c),g=Math.max(h,u,d),_=zOrder(p,m,t,r,n),v=zOrder(f,g,t,r,n);let x=e.prevZ,y=e.nextZ;for(;x&&x.z>=_&&y&&y.z<=v;){if(x.x>=p&&x.x<=f&&x.y>=m&&x.y<=g&&x!==i&&x!==s&&pointInTriangleExceptFirst(o,h,l,u,c,d,x.x,x.y)&&area(x.prev,x,x.next)>=0)return!1;if(x=x.prevZ,y.x>=p&&y.x<=f&&y.y>=m&&y.y<=g&&y!==i&&y!==s&&pointInTriangleExceptFirst(o,h,l,u,c,d,y.x,y.y)&&area(y.prev,y,y.next)>=0)return!1;y=y.nextZ}for(;x&&x.z>=_;){if(x.x>=p&&x.x<=f&&x.y>=m&&x.y<=g&&x!==i&&x!==s&&pointInTriangleExceptFirst(o,h,l,u,c,d,x.x,x.y)&&area(x.prev,x,x.next)>=0)return!1;x=x.prevZ}for(;y&&y.z<=v;){if(y.x>=p&&y.x<=f&&y.y>=m&&y.y<=g&&y!==i&&y!==s&&pointInTriangleExceptFirst(o,h,l,u,c,d,y.x,y.y)&&area(y.prev,y,y.next)>=0)return!1;y=y.nextZ}return!0}function cureLocalIntersections(e,t){let r=e;do{const n=r.prev,i=r.next.next;!equals(n,i)&&intersects(n,r,r.next,i)&&locallyInside(n,i)&&locallyInside(i,n)&&(t.push(n.i,r.i,i.i),removeNode(r),removeNode(r.next),r=e=i),r=r.next}while(r!==e);return filterPoints(r)}function splitEarcut(e,t,r,n,i,a){let s=e;do{let e=s.next.next;for(;e!==s.prev;){if(s.i!==e.i&&isValidDiagonal(s,e)){let o=splitPolygon(s,e);return s=filterPoints(s,s.next),o=filterPoints(o,o.next),earcutLinked(s,t,r,n,i,a,0),void earcutLinked(o,t,r,n,i,a,0)}e=e.next}s=s.next}while(s!==e)}function eliminateHoles(e,t,r,n){const i=[];for(let r=0,a=t.length;r<a;r++){const s=linkedList(e,t[r]*n,r<a-1?t[r+1]*n:e.length,n,!1);s===s.next&&(s.steiner=!0),i.push(getLeftmost(s))}i.sort(compareXYSlope);for(let e=0;e<i.length;e++)r=eliminateHole(i[e],r);return r}function compareXYSlope(e,t){let r=e.x-t.x;if(0===r&&(r=e.y-t.y,0===r)){r=(e.next.y-e.y)/(e.next.x-e.x)-(t.next.y-t.y)/(t.next.x-t.x)}return r}function eliminateHole(e,t){const r=findHoleBridge(e,t);if(!r)return t;const n=splitPolygon(r,e);return filterPoints(n,n.next),filterPoints(r,r.next)}function findHoleBridge(e,t){let r=t;const n=e.x,i=e.y;let a,s=-1/0;if(equals(e,r))return r;do{if(equals(e,r.next))return r.next;if(i<=r.y&&i>=r.next.y&&r.next.y!==r.y){const e=r.x+(i-r.y)*(r.next.x-r.x)/(r.next.y-r.y);if(e<=n&&e>s&&(s=e,a=r.x<r.next.x?r:r.next,e===n))return a}r=r.next}while(r!==t);if(!a)return null;const o=a,l=a.x,c=a.y;let h=1/0;r=a;do{if(n>=r.x&&r.x>=l&&n!==r.x&&pointInTriangle(i<c?n:s,i,l,c,i<c?s:n,i,r.x,r.y)){const t=Math.abs(i-r.y)/(n-r.x);locallyInside(r,e)&&(t<h||t===h&&(r.x>a.x||r.x===a.x&&sectorContainsSector(a,r)))&&(a=r,h=t)}r=r.next}while(r!==o);return a}function sectorContainsSector(e,t){return area(e.prev,e,t.prev)<0&&area(t.next,e,e.next)<0}function indexCurve(e,t,r,n){let i=e;do{0===i.z&&(i.z=zOrder(i.x,i.y,t,r,n)),i.prevZ=i.prev,i.nextZ=i.next,i=i.next}while(i!==e);i.prevZ.nextZ=null,i.prevZ=null,sortLinked(i)}function sortLinked(e){let t,r=1;do{let n,i=e;e=null;let a=null;for(t=0;i;){t++;let s=i,o=0;for(let e=0;e<r&&(o++,s=s.nextZ,s);e++);let l=r;for(;o>0||l>0&&s;)0!==o&&(0===l||!s||i.z<=s.z)?(n=i,i=i.nextZ,o--):(n=s,s=s.nextZ,l--),a?a.nextZ=n:e=n,n.prevZ=a,a=n;i=s}a.nextZ=null,r*=2}while(t>1);return e}function zOrder(e,t,r,n,i){return(e=1431655765&((e=858993459&((e=252645135&((e=16711935&((e=(e-r)*i|0)|e<<8))|e<<4))|e<<2))|e<<1))|(t=1431655765&((t=858993459&((t=252645135&((t=16711935&((t=(t-n)*i|0)|t<<8))|t<<4))|t<<2))|t<<1))<<1}function getLeftmost(e){let t=e,r=e;do{(t.x<r.x||t.x===r.x&&t.y<r.y)&&(r=t),t=t.next}while(t!==e);return r}function pointInTriangle(e,t,r,n,i,a,s,o){return(i-s)*(t-o)>=(e-s)*(a-o)&&(e-s)*(n-o)>=(r-s)*(t-o)&&(r-s)*(a-o)>=(i-s)*(n-o)}function pointInTriangleExceptFirst(e,t,r,n,i,a,s,o){return!(e===s&&t===o)&&pointInTriangle(e,t,r,n,i,a,s,o)}function isValidDiagonal(e,t){return e.next.i!==t.i&&e.prev.i!==t.i&&!intersectsPolygon(e,t)&&(locallyInside(e,t)&&locallyInside(t,e)&&middleInside(e,t)&&(area(e.prev,e,t.prev)||area(e,t.prev,t))||equals(e,t)&&area(e.prev,e,e.next)>0&&area(t.prev,t,t.next)>0)}function area(e,t,r){return(t.y-e.y)*(r.x-t.x)-(t.x-e.x)*(r.y-t.y)}function equals(e,t){return e.x===t.x&&e.y===t.y}function intersects(e,t,r,n){const i=sign(area(e,t,r)),a=sign(area(e,t,n)),s=sign(area(r,n,e)),o=sign(area(r,n,t));return i!==a&&s!==o||(!(0!==i||!onSegment(e,r,t))||(!(0!==a||!onSegment(e,n,t))||(!(0!==s||!onSegment(r,e,n))||!(0!==o||!onSegment(r,t,n)))))}function onSegment(e,t,r){return t.x<=Math.max(e.x,r.x)&&t.x>=Math.min(e.x,r.x)&&t.y<=Math.max(e.y,r.y)&&t.y>=Math.min(e.y,r.y)}function sign(e){return e>0?1:e<0?-1:0}function intersectsPolygon(e,t){let r=e;do{if(r.i!==e.i&&r.next.i!==e.i&&r.i!==t.i&&r.next.i!==t.i&&intersects(r,r.next,e,t))return!0;r=r.next}while(r!==e);return!1}function locallyInside(e,t){return area(e.prev,e,e.next)<0?area(e,t,e.next)>=0&&area(e,e.prev,t)>=0:area(e,t,e.prev)<0||area(e,e.next,t)<0}function middleInside(e,t){let r=e,n=!1;const i=(e.x+t.x)/2,a=(e.y+t.y)/2;do{r.y>a!=r.next.y>a&&r.next.y!==r.y&&i<(r.next.x-r.x)*(a-r.y)/(r.next.y-r.y)+r.x&&(n=!n),r=r.next}while(r!==e);return n}function splitPolygon(e,t){const r=createNode(e.i,e.x,e.y),n=createNode(t.i,t.x,t.y),i=e.next,a=t.prev;return e.next=t,t.prev=e,r.next=i,i.prev=r,n.next=r,r.prev=n,a.next=n,n.prev=a,n}function insertNode(e,t,r,n){const i=createNode(e,t,r);return n?(i.next=n.next,i.prev=n,n.next.prev=i,n.next=i):(i.prev=i,i.next=i),i}function removeNode(e){e.next.prev=e.prev,e.prev.next=e.next,e.prevZ&&(e.prevZ.nextZ=e.nextZ),e.nextZ&&(e.nextZ.prevZ=e.prevZ)}function createNode(e,t,r){return{i:e,x:t,y:r,prev:null,next:null,z:0,prevZ:null,nextZ:null,steiner:!1}}function signedArea(e,t,r,n){let i=0;for(let a=t,s=r-n;a<r;a+=n)i+=(e[s]-e[a])*(e[a+1]+e[s+1]),s=a;return i}class Earcut{static triangulate(e,t,r=2){return earcut(e,t,r)}}class ShapeUtils{static area(e){const t=e.length;let r=0;for(let n=t-1,i=0;i<t;n=i++)r+=e[n].x*e[i].y-e[i].x*e[n].y;return.5*r}static isClockWise(e){return ShapeUtils.area(e)<0}static triangulateShape(e,t){const r=[],n=[],i=[];removeDupEndPts(e),addContour(r,e);let a=e.length;t.forEach(removeDupEndPts);for(let e=0;e<t.length;e++)n.push(a),a+=t[e].length,addContour(r,t[e]);const s=Earcut.triangulate(r,n);for(let e=0;e<s.length;e+=3)i.push(s.slice(e,e+3));return i}}function removeDupEndPts(e){const t=e.length;t>2&&e[t-1].equals(e[0])&&e.pop()}function addContour(e,t){for(let r=0;r<t.length;r++)e.push(t[r].x),e.push(t[r].y)}class ExtrudeGeometry extends BufferGeometry{constructor(e=new Shape([new Vector2(.5,.5),new Vector2(-.5,.5),new Vector2(-.5,-.5),new Vector2(.5,-.5)]),t={}){super(),this.type="ExtrudeGeometry",this.parameters={shapes:e,options:t},e=Array.isArray(e)?e:[e];const r=this,n=[],i=[];for(let t=0,r=e.length;t<r;t++){a(e[t])}function a(e){const a=[],s=void 0!==t.curveSegments?t.curveSegments:12,o=void 0!==t.steps?t.steps:1,l=void 0!==t.depth?t.depth:1;let c=void 0===t.bevelEnabled||t.bevelEnabled,h=void 0!==t.bevelThickness?t.bevelThickness:.2,u=void 0!==t.bevelSize?t.bevelSize:h-.1,d=void 0!==t.bevelOffset?t.bevelOffset:0,p=void 0!==t.bevelSegments?t.bevelSegments:3;const m=t.extrudePath,f=void 0!==t.UVGenerator?t.UVGenerator:WorldUVGenerator;let g,_,v,x,y,M=!1;m&&(g=m.getSpacedPoints(o),M=!0,c=!1,_=m.computeFrenetFrames(o,!1),v=new Vector3,x=new Vector3,y=new Vector3),c||(p=0,h=0,u=0,d=0);const S=e.extractPoints(s);let b=S.shape;const T=S.holes;if(!ShapeUtils.isClockWise(b)){b=b.reverse();for(let e=0,t=T.length;e<t;e++){const t=T[e];ShapeUtils.isClockWise(t)&&(T[e]=t.reverse())}}function E(e){const t=1e-10*1e-10;let r=e[0];for(let n=1;n<=e.length;n++){const i=n%e.length,a=e[i],s=a.x-r.x,o=a.y-r.y,l=s*s+o*o,c=Math.max(Math.abs(a.x),Math.abs(a.y),Math.abs(r.x),Math.abs(r.y));l<=t*c*c?(e.splice(i,1),n--):r=a}}E(b),T.forEach(E);const A=T.length,w=b;for(let e=0;e<A;e++){const t=T[e];b=b.concat(t)}function C(e,t,r){return t||console.error("THREE.ExtrudeGeometry: vec does not exist"),e.clone().addScaledVector(t,r)}const R=b.length;function L(e,t,r){let n,i,a;const s=e.x-t.x,o=e.y-t.y,l=r.x-e.x,c=r.y-e.y,h=s*s+o*o,u=s*c-o*l;if(Math.abs(u)>Number.EPSILON){const u=Math.sqrt(h),d=Math.sqrt(l*l+c*c),p=t.x-o/u,m=t.y+s/u,f=((r.x-c/d-p)*c-(r.y+l/d-m)*l)/(s*c-o*l);n=p+s*f-e.x,i=m+o*f-e.y;const g=n*n+i*i;if(g<=2)return new Vector2(n,i);a=Math.sqrt(g/2)}else{let e=!1;s>Number.EPSILON?l>Number.EPSILON&&(e=!0):s<-Number.EPSILON?l<-Number.EPSILON&&(e=!0):Math.sign(o)===Math.sign(c)&&(e=!0),e?(n=-o,i=s,a=Math.sqrt(h)):(n=s,i=o,a=Math.sqrt(h/2))}return new Vector2(n/a,i/a)}const P=[];for(let e=0,t=w.length,r=t-1,n=e+1;e<t;e++,r++,n++)r===t&&(r=0),n===t&&(n=0),P[e]=L(w[e],w[r],w[n]);const I=[];let U,D,N=P.concat();for(let e=0,t=A;e<t;e++){const t=T[e];U=[];for(let e=0,r=t.length,n=r-1,i=e+1;e<r;e++,n++,i++)n===r&&(n=0),i===r&&(i=0),U[e]=L(t[e],t[n],t[i]);I.push(U),N=N.concat(U)}if(0===p)D=ShapeUtils.triangulateShape(w,T);else{const e=[],t=[];for(let r=0;r<p;r++){const n=r/p,i=h*Math.cos(n*Math.PI/2),a=u*Math.sin(n*Math.PI/2)+d;for(let t=0,r=w.length;t<r;t++){const r=C(w[t],P[t],a);V(r.x,r.y,-i),0===n&&e.push(r)}for(let e=0,r=A;e<r;e++){const r=T[e];U=I[e];const s=[];for(let e=0,t=r.length;e<t;e++){const t=C(r[e],U[e],a);V(t.x,t.y,-i),0===n&&s.push(t)}0===n&&t.push(s)}}D=ShapeUtils.triangulateShape(e,t)}const B=D.length,F=u+d;for(let e=0;e<R;e++){const t=c?C(b[e],N[e],F):b[e];M?(x.copy(_.normals[0]).multiplyScalar(t.x),v.copy(_.binormals[0]).multiplyScalar(t.y),y.copy(g[0]).add(x).add(v),V(y.x,y.y,y.z)):V(t.x,t.y,0)}for(let e=1;e<=o;e++)for(let t=0;t<R;t++){const r=c?C(b[t],N[t],F):b[t];M?(x.copy(_.normals[e]).multiplyScalar(r.x),v.copy(_.binormals[e]).multiplyScalar(r.y),y.copy(g[e]).add(x).add(v),V(y.x,y.y,y.z)):V(r.x,r.y,l/o*e)}for(let e=p-1;e>=0;e--){const t=e/p,r=h*Math.cos(t*Math.PI/2),n=u*Math.sin(t*Math.PI/2)+d;for(let e=0,t=w.length;e<t;e++){const t=C(w[e],P[e],n);V(t.x,t.y,l+r)}for(let e=0,t=T.length;e<t;e++){const t=T[e];U=I[e];for(let e=0,i=t.length;e<i;e++){const i=C(t[e],U[e],n);M?V(i.x,i.y+g[o-1].y,g[o-1].x+r):V(i.x,i.y,l+r)}}}function O(e,t){let r=e.length;for(;--r>=0;){const n=r;let i=r-1;i<0&&(i=e.length-1);for(let e=0,r=o+2*p;e<r;e++){const r=R*e,a=R*(e+1);G(t+n+r,t+i+r,t+i+a,t+n+a)}}}function V(e,t,r){a.push(e),a.push(t),a.push(r)}function z(e,t,i){k(e),k(t),k(i);const a=n.length/3,s=f.generateTopUV(r,n,a-3,a-2,a-1);H(s[0]),H(s[1]),H(s[2])}function G(e,t,i,a){k(e),k(t),k(a),k(t),k(i),k(a);const s=n.length/3,o=f.generateSideWallUV(r,n,s-6,s-3,s-2,s-1);H(o[0]),H(o[1]),H(o[3]),H(o[1]),H(o[2]),H(o[3])}function k(e){n.push(a[3*e+0]),n.push(a[3*e+1]),n.push(a[3*e+2])}function H(e){i.push(e.x),i.push(e.y)}!function(){const e=n.length/3;if(c){let e=0,t=R*e;for(let e=0;e<B;e++){const r=D[e];z(r[2]+t,r[1]+t,r[0]+t)}e=o+2*p,t=R*e;for(let e=0;e<B;e++){const r=D[e];z(r[0]+t,r[1]+t,r[2]+t)}}else{for(let e=0;e<B;e++){const t=D[e];z(t[2],t[1],t[0])}for(let e=0;e<B;e++){const t=D[e];z(t[0]+R*o,t[1]+R*o,t[2]+R*o)}}r.addGroup(e,n.length/3-e,0)}(),function(){const e=n.length/3;let t=0;O(w,t),t+=w.length;for(let e=0,r=T.length;e<r;e++){const r=T[e];O(r,t),t+=r.length}r.addGroup(e,n.length/3-e,1)}()}this.setAttribute("position",new Float32BufferAttribute(n,3)),this.setAttribute("uv",new Float32BufferAttribute(i,2)),this.computeVertexNormals()}copy(e){return super.copy(e),this.parameters=Object.assign({},e.parameters),this}toJSON(){const e=super.toJSON();return toJSON$1(this.parameters.shapes,this.parameters.options,e)}static fromJSON(e,t){const r=[];for(let n=0,i=e.shapes.length;n<i;n++){const i=t[e.shapes[n]];r.push(i)}const n=e.options.extrudePath;return void 0!==n&&(e.options.extrudePath=(new Curves[n.type]).fromJSON(n)),new ExtrudeGeometry(r,e.options)}}const WorldUVGenerator={generateTopUV:function(e,t,r,n,i){const a=t[3*r],s=t[3*r+1],o=t[3*n],l=t[3*n+1],c=t[3*i],h=t[3*i+1];return[new Vector2(a,s),new Vector2(o,l),new Vector2(c,h)]},generateSideWallUV:function(e,t,r,n,i,a){const s=t[3*r],o=t[3*r+1],l=t[3*r+2],c=t[3*n],h=t[3*n+1],u=t[3*n+2],d=t[3*i],p=t[3*i+1],m=t[3*i+2],f=t[3*a],g=t[3*a+1],_=t[3*a+2];return Math.abs(o-h)<Math.abs(s-c)?[new Vector2(s,1-l),new Vector2(c,1-u),new Vector2(d,1-m),new Vector2(f,1-_)]:[new Vector2(o,1-l),new Vector2(h,1-u),new Vector2(p,1-m),new Vector2(g,1-_)]}};function toJSON$1(e,t,r){if(r.shapes=[],Array.isArray(e))for(let t=0,n=e.length;t<n;t++){const n=e[t];r.shapes.push(n.uuid)}else r.shapes.push(e.uuid);return r.options=Object.assign({},t),void 0!==t.extrudePath&&(r.options.extrudePath=t.extrudePath.toJSON()),r}class IcosahedronGeometry extends PolyhedronGeometry{constructor(e=1,t=0){const r=(1+Math.sqrt(5))/2;super([-1,r,0,1,r,0,-1,-r,0,1,-r,0,0,-1,r,0,1,r,0,-1,-r,0,1,-r,r,0,-1,r,0,1,-r,0,-1,-r,0,1],[0,11,5,0,5,1,0,1,7,0,7,10,0,10,11,1,5,9,5,11,4,11,10,2,10,7,6,7,1,8,3,9,4,3,4,2,3,2,6,3,6,8,3,8,9,4,9,5,2,4,11,6,2,10,8,6,7,9,8,1],e,t),this.type="IcosahedronGeometry",this.parameters={radius:e,detail:t}}static fromJSON(e){return new IcosahedronGeometry(e.radius,e.detail)}}class LatheGeometry extends BufferGeometry{constructor(e=[new Vector2(0,-.5),new Vector2(.5,0),new Vector2(0,.5)],t=12,r=0,n=2*Math.PI){super(),this.type="LatheGeometry",this.parameters={points:e,segments:t,phiStart:r,phiLength:n},t=Math.floor(t),n=clamp(n,0,2*Math.PI);const i=[],a=[],s=[],o=[],l=[],c=1/t,h=new Vector3,u=new Vector2,d=new Vector3,p=new Vector3,m=new Vector3;let f=0,g=0;for(let t=0;t<=e.length-1;t++)switch(t){case 0:f=e[t+1].x-e[t].x,g=e[t+1].y-e[t].y,d.x=1*g,d.y=-f,d.z=0*g,m.copy(d),d.normalize(),o.push(d.x,d.y,d.z);break;case e.length-1:o.push(m.x,m.y,m.z);break;default:f=e[t+1].x-e[t].x,g=e[t+1].y-e[t].y,d.x=1*g,d.y=-f,d.z=0*g,p.copy(d),d.x+=m.x,d.y+=m.y,d.z+=m.z,d.normalize(),o.push(d.x,d.y,d.z),m.copy(p)}for(let i=0;i<=t;i++){const d=r+i*c*n,p=Math.sin(d),m=Math.cos(d);for(let r=0;r<=e.length-1;r++){h.x=e[r].x*p,h.y=e[r].y,h.z=e[r].x*m,a.push(h.x,h.y,h.z),u.x=i/t,u.y=r/(e.length-1),s.push(u.x,u.y);const n=o[3*r+0]*p,c=o[3*r+1],d=o[3*r+0]*m;l.push(n,c,d)}}for(let r=0;r<t;r++)for(let t=0;t<e.length-1;t++){const n=t+r*e.length,a=n,s=n+e.length,o=n+e.length+1,l=n+1;i.push(a,s,l),i.push(o,l,s)}this.setIndex(i),this.setAttribute("position",new Float32BufferAttribute(a,3)),this.setAttribute("uv",new Float32BufferAttribute(s,2)),this.setAttribute("normal",new Float32BufferAttribute(l,3))}copy(e){return super.copy(e),this.parameters=Object.assign({},e.parameters),this}static fromJSON(e){return new LatheGeometry(e.points,e.segments,e.phiStart,e.phiLength)}}class OctahedronGeometry extends PolyhedronGeometry{constructor(e=1,t=0){super([1,0,0,-1,0,0,0,1,0,0,-1,0,0,0,1,0,0,-1],[0,2,4,0,4,3,0,3,5,0,5,2,1,2,5,1,5,3,1,3,4,1,4,2],e,t),this.type="OctahedronGeometry",this.parameters={radius:e,detail:t}}static fromJSON(e){return new OctahedronGeometry(e.radius,e.detail)}}class PlaneGeometry extends BufferGeometry{constructor(e=1,t=1,r=1,n=1){super(),this.type="PlaneGeometry",this.parameters={width:e,height:t,widthSegments:r,heightSegments:n};const i=e/2,a=t/2,s=Math.floor(r),o=Math.floor(n),l=s+1,c=o+1,h=e/s,u=t/o,d=[],p=[],m=[],f=[];for(let e=0;e<c;e++){const t=e*u-a;for(let r=0;r<l;r++){const n=r*h-i;p.push(n,-t,0),m.push(0,0,1),f.push(r/s),f.push(1-e/o)}}for(let e=0;e<o;e++)for(let t=0;t<s;t++){const r=t+l*e,n=t+l*(e+1),i=t+1+l*(e+1),a=t+1+l*e;d.push(r,n,a),d.push(n,i,a)}this.setIndex(d),this.setAttribute("position",new Float32BufferAttribute(p,3)),this.setAttribute("normal",new Float32BufferAttribute(m,3)),this.setAttribute("uv",new Float32BufferAttribute(f,2))}copy(e){return super.copy(e),this.parameters=Object.assign({},e.parameters),this}static fromJSON(e){return new PlaneGeometry(e.width,e.height,e.widthSegments,e.heightSegments)}}class RingGeometry extends BufferGeometry{constructor(e=.5,t=1,r=32,n=1,i=0,a=2*Math.PI){super(),this.type="RingGeometry",this.parameters={innerRadius:e,outerRadius:t,thetaSegments:r,phiSegments:n,thetaStart:i,thetaLength:a},r=Math.max(3,r);const s=[],o=[],l=[],c=[];let h=e;const u=(t-e)/(n=Math.max(1,n)),d=new Vector3,p=new Vector2;for(let e=0;e<=n;e++){for(let e=0;e<=r;e++){const n=i+e/r*a;d.x=h*Math.cos(n),d.y=h*Math.sin(n),o.push(d.x,d.y,d.z),l.push(0,0,1),p.x=(d.x/t+1)/2,p.y=(d.y/t+1)/2,c.push(p.x,p.y)}h+=u}for(let e=0;e<n;e++){const t=e*(r+1);for(let e=0;e<r;e++){const n=e+t,i=n,a=n+r+1,o=n+r+2,l=n+1;s.push(i,a,l),s.push(a,o,l)}}this.setIndex(s),this.setAttribute("position",new Float32BufferAttribute(o,3)),this.setAttribute("normal",new Float32BufferAttribute(l,3)),this.setAttribute("uv",new Float32BufferAttribute(c,2))}copy(e){return super.copy(e),this.parameters=Object.assign({},e.parameters),this}static fromJSON(e){return new RingGeometry(e.innerRadius,e.outerRadius,e.thetaSegments,e.phiSegments,e.thetaStart,e.thetaLength)}}class ShapeGeometry extends BufferGeometry{constructor(e=new Shape([new Vector2(0,.5),new Vector2(-.5,-.5),new Vector2(.5,-.5)]),t=12){super(),this.type="ShapeGeometry",this.parameters={shapes:e,curveSegments:t};const r=[],n=[],i=[],a=[];let s=0,o=0;if(!1===Array.isArray(e))l(e);else for(let t=0;t<e.length;t++)l(e[t]),this.addGroup(s,o,t),s+=o,o=0;function l(e){const s=n.length/3,l=e.extractPoints(t);let c=l.shape;const h=l.holes;!1===ShapeUtils.isClockWise(c)&&(c=c.reverse());for(let e=0,t=h.length;e<t;e++){const t=h[e];!0===ShapeUtils.isClockWise(t)&&(h[e]=t.reverse())}const u=ShapeUtils.triangulateShape(c,h);for(let e=0,t=h.length;e<t;e++){const t=h[e];c=c.concat(t)}for(let e=0,t=c.length;e<t;e++){const t=c[e];n.push(t.x,t.y,0),i.push(0,0,1),a.push(t.x,t.y)}for(let e=0,t=u.length;e<t;e++){const t=u[e],n=t[0]+s,i=t[1]+s,a=t[2]+s;r.push(n,i,a),o+=3}}this.setIndex(r),this.setAttribute("position",new Float32BufferAttribute(n,3)),this.setAttribute("normal",new Float32BufferAttribute(i,3)),this.setAttribute("uv",new Float32BufferAttribute(a,2))}copy(e){return super.copy(e),this.parameters=Object.assign({},e.parameters),this}toJSON(){const e=super.toJSON();return toJSON(this.parameters.shapes,e)}static fromJSON(e,t){const r=[];for(let n=0,i=e.shapes.length;n<i;n++){const i=t[e.shapes[n]];r.push(i)}return new ShapeGeometry(r,e.curveSegments)}}function toJSON(e,t){if(t.shapes=[],Array.isArray(e))for(let r=0,n=e.length;r<n;r++){const n=e[r];t.shapes.push(n.uuid)}else t.shapes.push(e.uuid);return t}class SphereGeometry extends BufferGeometry{constructor(e=1,t=32,r=16,n=0,i=2*Math.PI,a=0,s=Math.PI){super(),this.type="SphereGeometry",this.parameters={radius:e,widthSegments:t,heightSegments:r,phiStart:n,phiLength:i,thetaStart:a,thetaLength:s},t=Math.max(3,Math.floor(t)),r=Math.max(2,Math.floor(r));const o=Math.min(a+s,Math.PI);let l=0;const c=[],h=new Vector3,u=new Vector3,d=[],p=[],m=[],f=[];for(let d=0;d<=r;d++){const g=[],_=d/r;let v=0;0===d&&0===a?v=.5/t:d===r&&o===Math.PI&&(v=-.5/t);for(let r=0;r<=t;r++){const o=r/t;h.x=-e*Math.cos(n+o*i)*Math.sin(a+_*s),h.y=e*Math.cos(a+_*s),h.z=e*Math.sin(n+o*i)*Math.sin(a+_*s),p.push(h.x,h.y,h.z),u.copy(h).normalize(),m.push(u.x,u.y,u.z),f.push(o+v,1-_),g.push(l++)}c.push(g)}for(let e=0;e<r;e++)for(let n=0;n<t;n++){const t=c[e][n+1],i=c[e][n],s=c[e+1][n],l=c[e+1][n+1];(0!==e||a>0)&&d.push(t,i,l),(e!==r-1||o<Math.PI)&&d.push(i,s,l)}this.setIndex(d),this.setAttribute("position",new Float32BufferAttribute(p,3)),this.setAttribute("normal",new Float32BufferAttribute(m,3)),this.setAttribute("uv",new Float32BufferAttribute(f,2))}copy(e){return super.copy(e),this.parameters=Object.assign({},e.parameters),this}static fromJSON(e){return new SphereGeometry(e.radius,e.widthSegments,e.heightSegments,e.phiStart,e.phiLength,e.thetaStart,e.thetaLength)}}class TetrahedronGeometry extends PolyhedronGeometry{constructor(e=1,t=0){super([1,1,1,-1,-1,1,-1,1,-1,1,-1,-1],[2,1,0,0,3,2,1,3,0,2,3,1],e,t),this.type="TetrahedronGeometry",this.parameters={radius:e,detail:t}}static fromJSON(e){return new TetrahedronGeometry(e.radius,e.detail)}}class TorusGeometry extends BufferGeometry{constructor(e=1,t=.4,r=12,n=48,i=2*Math.PI){super(),this.type="TorusGeometry",this.parameters={radius:e,tube:t,radialSegments:r,tubularSegments:n,arc:i},r=Math.floor(r),n=Math.floor(n);const a=[],s=[],o=[],l=[],c=new Vector3,h=new Vector3,u=new Vector3;for(let a=0;a<=r;a++)for(let d=0;d<=n;d++){const p=d/n*i,m=a/r*Math.PI*2;h.x=(e+t*Math.cos(m))*Math.cos(p),h.y=(e+t*Math.cos(m))*Math.sin(p),h.z=t*Math.sin(m),s.push(h.x,h.y,h.z),c.x=e*Math.cos(p),c.y=e*Math.sin(p),u.subVectors(h,c).normalize(),o.push(u.x,u.y,u.z),l.push(d/n),l.push(a/r)}for(let e=1;e<=r;e++)for(let t=1;t<=n;t++){const r=(n+1)*e+t-1,i=(n+1)*(e-1)+t-1,s=(n+1)*(e-1)+t,o=(n+1)*e+t;a.push(r,i,o),a.push(i,s,o)}this.setIndex(a),this.setAttribute("position",new Float32BufferAttribute(s,3)),this.setAttribute("normal",new Float32BufferAttribute(o,3)),this.setAttribute("uv",new Float32BufferAttribute(l,2))}copy(e){return super.copy(e),this.parameters=Object.assign({},e.parameters),this}static fromJSON(e){return new TorusGeometry(e.radius,e.tube,e.radialSegments,e.tubularSegments,e.arc)}}class TorusKnotGeometry extends BufferGeometry{constructor(e=1,t=.4,r=64,n=8,i=2,a=3){super(),this.type="TorusKnotGeometry",this.parameters={radius:e,tube:t,tubularSegments:r,radialSegments:n,p:i,q:a},r=Math.floor(r),n=Math.floor(n);const s=[],o=[],l=[],c=[],h=new Vector3,u=new Vector3,d=new Vector3,p=new Vector3,m=new Vector3,f=new Vector3,g=new Vector3;for(let s=0;s<=r;++s){const v=s/r*i*Math.PI*2;_(v,i,a,e,d),_(v+.01,i,a,e,p),f.subVectors(p,d),g.addVectors(p,d),m.crossVectors(f,g),g.crossVectors(m,f),m.normalize(),g.normalize();for(let e=0;e<=n;++e){const i=e/n*Math.PI*2,a=-t*Math.cos(i),p=t*Math.sin(i);h.x=d.x+(a*g.x+p*m.x),h.y=d.y+(a*g.y+p*m.y),h.z=d.z+(a*g.z+p*m.z),o.push(h.x,h.y,h.z),u.subVectors(h,d).normalize(),l.push(u.x,u.y,u.z),c.push(s/r),c.push(e/n)}}for(let e=1;e<=r;e++)for(let t=1;t<=n;t++){const r=(n+1)*(e-1)+(t-1),i=(n+1)*e+(t-1),a=(n+1)*e+t,o=(n+1)*(e-1)+t;s.push(r,i,o),s.push(i,a,o)}function _(e,t,r,n,i){const a=Math.cos(e),s=Math.sin(e),o=r/t*e,l=Math.cos(o);i.x=n*(2+l)*.5*a,i.y=n*(2+l)*s*.5,i.z=n*Math.sin(o)*.5}this.setIndex(s),this.setAttribute("position",new Float32BufferAttribute(o,3)),this.setAttribute("normal",new Float32BufferAttribute(l,3)),this.setAttribute("uv",new Float32BufferAttribute(c,2))}copy(e){return super.copy(e),this.parameters=Object.assign({},e.parameters),this}static fromJSON(e){return new TorusKnotGeometry(e.radius,e.tube,e.tubularSegments,e.radialSegments,e.p,e.q)}}class TubeGeometry extends BufferGeometry{constructor(e=new QuadraticBezierCurve3(new Vector3(-1,-1,0),new Vector3(-1,1,0),new Vector3(1,1,0)),t=64,r=1,n=8,i=!1){super(),this.type="TubeGeometry",this.parameters={path:e,tubularSegments:t,radius:r,radialSegments:n,closed:i};const a=e.computeFrenetFrames(t,i);this.tangents=a.tangents,this.normals=a.normals,this.binormals=a.binormals;const s=new Vector3,o=new Vector3,l=new Vector2;let c=new Vector3;const h=[],u=[],d=[],p=[];function m(i){c=e.getPointAt(i/t,c);const l=a.normals[i],d=a.binormals[i];for(let e=0;e<=n;e++){const t=e/n*Math.PI*2,i=Math.sin(t),a=-Math.cos(t);o.x=a*l.x+i*d.x,o.y=a*l.y+i*d.y,o.z=a*l.z+i*d.z,o.normalize(),u.push(o.x,o.y,o.z),s.x=c.x+r*o.x,s.y=c.y+r*o.y,s.z=c.z+r*o.z,h.push(s.x,s.y,s.z)}}!function(){for(let e=0;e<t;e++)m(e);m(!1===i?t:0),function(){for(let e=0;e<=t;e++)for(let r=0;r<=n;r++)l.x=e/t,l.y=r/n,d.push(l.x,l.y)}(),function(){for(let e=1;e<=t;e++)for(let t=1;t<=n;t++){const r=(n+1)*(e-1)+(t-1),i=(n+1)*e+(t-1),a=(n+1)*e+t,s=(n+1)*(e-1)+t;p.push(r,i,s),p.push(i,a,s)}}()}(),this.setIndex(p),this.setAttribute("position",new Float32BufferAttribute(h,3)),this.setAttribute("normal",new Float32BufferAttribute(u,3)),this.setAttribute("uv",new Float32BufferAttribute(d,2))}copy(e){return super.copy(e),this.parameters=Object.assign({},e.parameters),this}toJSON(){const e=super.toJSON();return e.path=this.parameters.path.toJSON(),e}static fromJSON(e){return new TubeGeometry((new Curves[e.path.type]).fromJSON(e.path),e.tubularSegments,e.radius,e.radialSegments,e.closed)}}class WireframeGeometry extends BufferGeometry{constructor(e=null){if(super(),this.type="WireframeGeometry",this.parameters={geometry:e},null!==e){const t=[],r=new Set,n=new Vector3,i=new Vector3;if(null!==e.index){const a=e.attributes.position,s=e.index;let o=e.groups;0===o.length&&(o=[{start:0,count:s.count,materialIndex:0}]);for(let e=0,l=o.length;e<l;++e){const l=o[e],c=l.start;for(let e=c,o=c+l.count;e<o;e+=3)for(let o=0;o<3;o++){const l=s.getX(e+o),c=s.getX(e+(o+1)%3);n.fromBufferAttribute(a,l),i.fromBufferAttribute(a,c),!0===isUniqueEdge(n,i,r)&&(t.push(n.x,n.y,n.z),t.push(i.x,i.y,i.z))}}}else{const a=e.attributes.position;for(let e=0,s=a.count/3;e<s;e++)for(let s=0;s<3;s++){const o=3*e+s,l=3*e+(s+1)%3;n.fromBufferAttribute(a,o),i.fromBufferAttribute(a,l),!0===isUniqueEdge(n,i,r)&&(t.push(n.x,n.y,n.z),t.push(i.x,i.y,i.z))}}this.setAttribute("position",new Float32BufferAttribute(t,3))}}copy(e){return super.copy(e),this.parameters=Object.assign({},e.parameters),this}}function isUniqueEdge(e,t,r){const n=`${e.x},${e.y},${e.z}-${t.x},${t.y},${t.z}`,i=`${t.x},${t.y},${t.z}-${e.x},${e.y},${e.z}`;return!0!==r.has(n)&&!0!==r.has(i)&&(r.add(n),r.add(i),!0)}var Geometries=Object.freeze({__proto__:null,BoxGeometry,CapsuleGeometry,CircleGeometry,ConeGeometry,CylinderGeometry,DodecahedronGeometry,EdgesGeometry,ExtrudeGeometry,IcosahedronGeometry,LatheGeometry,OctahedronGeometry,PlaneGeometry,PolyhedronGeometry,RingGeometry,ShapeGeometry,SphereGeometry,TetrahedronGeometry,TorusGeometry,TorusKnotGeometry,TubeGeometry,WireframeGeometry});class ShadowMaterial extends Material{constructor(e){super(),this.isShadowMaterial=!0,this.type="ShadowMaterial",this.color=new Color(0),this.transparent=!0,this.fog=!0,this.setValues(e)}copy(e){return super.copy(e),this.color.copy(e.color),this.fog=e.fog,this}}class RawShaderMaterial extends ShaderMaterial{constructor(e){super(e),this.isRawShaderMaterial=!0,this.type="RawShaderMaterial"}}class MeshStandardMaterial extends Material{constructor(e){super(),this.isMeshStandardMaterial=!0,this.type="MeshStandardMaterial",this.defines={STANDARD:""},this.color=new Color(16777215),this.roughness=1,this.metalness=0,this.map=null,this.lightMap=null,this.lightMapIntensity=1,this.aoMap=null,this.aoMapIntensity=1,this.emissive=new Color(0),this.emissiveIntensity=1,this.emissiveMap=null,this.bumpMap=null,this.bumpScale=1,this.normalMap=null,this.normalMapType=0,this.normalScale=new Vector2(1,1),this.displacementMap=null,this.displacementScale=1,this.displacementBias=0,this.roughnessMap=null,this.metalnessMap=null,this.alphaMap=null,this.envMap=null,this.envMapRotation=new Euler,this.envMapIntensity=1,this.wireframe=!1,this.wireframeLinewidth=1,this.wireframeLinecap="round",this.wireframeLinejoin="round",this.flatShading=!1,this.fog=!0,this.setValues(e)}copy(e){return super.copy(e),this.defines={STANDARD:""},this.color.copy(e.color),this.roughness=e.roughness,this.metalness=e.metalness,this.map=e.map,this.lightMap=e.lightMap,this.lightMapIntensity=e.lightMapIntensity,this.aoMap=e.aoMap,this.aoMapIntensity=e.aoMapIntensity,this.emissive.copy(e.emissive),this.emissiveMap=e.emissiveMap,this.emissiveIntensity=e.emissiveIntensity,this.bumpMap=e.bumpMap,this.bumpScale=e.bumpScale,this.normalMap=e.normalMap,this.normalMapType=e.normalMapType,this.normalScale.copy(e.normalScale),this.displacementMap=e.displacementMap,this.displacementScale=e.displacementScale,this.displacementBias=e.displacementBias,this.roughnessMap=e.roughnessMap,this.metalnessMap=e.metalnessMap,this.alphaMap=e.alphaMap,this.envMap=e.envMap,this.envMapRotation.copy(e.envMapRotation),this.envMapIntensity=e.envMapIntensity,this.wireframe=e.wireframe,this.wireframeLinewidth=e.wireframeLinewidth,this.wireframeLinecap=e.wireframeLinecap,this.wireframeLinejoin=e.wireframeLinejoin,this.flatShading=e.flatShading,this.fog=e.fog,this}}class MeshPhysicalMaterial extends MeshStandardMaterial{constructor(e){super(),this.isMeshPhysicalMaterial=!0,this.defines={STANDARD:"",PHYSICAL:""},this.type="MeshPhysicalMaterial",this.anisotropyRotation=0,this.anisotropyMap=null,this.clearcoatMap=null,this.clearcoatRoughness=0,this.clearcoatRoughnessMap=null,this.clearcoatNormalScale=new Vector2(1,1),this.clearcoatNormalMap=null,this.ior=1.5,Object.defineProperty(this,"reflectivity",{get:function(){return clamp(2.5*(this.ior-1)/(this.ior+1),0,1)},set:function(e){this.ior=(1+.4*e)/(1-.4*e)}}),this.iridescenceMap=null,this.iridescenceIOR=1.3,this.iridescenceThicknessRange=[100,400],this.iridescenceThicknessMap=null,this.sheenColor=new Color(0),this.sheenColorMap=null,this.sheenRoughness=1,this.sheenRoughnessMap=null,this.transmissionMap=null,this.thickness=0,this.thicknessMap=null,this.attenuationDistance=1/0,this.attenuationColor=new Color(1,1,1),this.specularIntensity=1,this.specularIntensityMap=null,this.specularColor=new Color(1,1,1),this.specularColorMap=null,this._anisotropy=0,this._clearcoat=0,this._dispersion=0,this._iridescence=0,this._sheen=0,this._transmission=0,this.setValues(e)}get anisotropy(){return this._anisotropy}set anisotropy(e){this._anisotropy>0!=e>0&&this.version++,this._anisotropy=e}get clearcoat(){return this._clearcoat}set clearcoat(e){this._clearcoat>0!=e>0&&this.version++,this._clearcoat=e}get iridescence(){return this._iridescence}set iridescence(e){this._iridescence>0!=e>0&&this.version++,this._iridescence=e}get dispersion(){return this._dispersion}set dispersion(e){this._dispersion>0!=e>0&&this.version++,this._dispersion=e}get sheen(){return this._sheen}set sheen(e){this._sheen>0!=e>0&&this.version++,this._sheen=e}get transmission(){return this._transmission}set transmission(e){this._transmission>0!=e>0&&this.version++,this._transmission=e}copy(e){return super.copy(e),this.defines={STANDARD:"",PHYSICAL:""},this.anisotropy=e.anisotropy,this.anisotropyRotation=e.anisotropyRotation,this.anisotropyMap=e.anisotropyMap,this.clearcoat=e.clearcoat,this.clearcoatMap=e.clearcoatMap,this.clearcoatRoughness=e.clearcoatRoughness,this.clearcoatRoughnessMap=e.clearcoatRoughnessMap,this.clearcoatNormalMap=e.clearcoatNormalMap,this.clearcoatNormalScale.copy(e.clearcoatNormalScale),this.dispersion=e.dispersion,this.ior=e.ior,this.iridescence=e.iridescence,this.iridescenceMap=e.iridescenceMap,this.iridescenceIOR=e.iridescenceIOR,this.iridescenceThicknessRange=[...e.iridescenceThicknessRange],this.iridescenceThicknessMap=e.iridescenceThicknessMap,this.sheen=e.sheen,this.sheenColor.copy(e.sheenColor),this.sheenColorMap=e.sheenColorMap,this.sheenRoughness=e.sheenRoughness,this.sheenRoughnessMap=e.sheenRoughnessMap,this.transmission=e.transmission,this.transmissionMap=e.transmissionMap,this.thickness=e.thickness,this.thicknessMap=e.thicknessMap,this.attenuationDistance=e.attenuationDistance,this.attenuationColor.copy(e.attenuationColor),this.specularIntensity=e.specularIntensity,this.specularIntensityMap=e.specularIntensityMap,this.specularColor.copy(e.specularColor),this.specularColorMap=e.specularColorMap,this}}class MeshPhongMaterial extends Material{constructor(e){super(),this.isMeshPhongMaterial=!0,this.type="MeshPhongMaterial",this.color=new Color(16777215),this.specular=new Color(1118481),this.shininess=30,this.map=null,this.lightMap=null,this.lightMapIntensity=1,this.aoMap=null,this.aoMapIntensity=1,this.emissive=new Color(0),this.emissiveIntensity=1,this.emissiveMap=null,this.bumpMap=null,this.bumpScale=1,this.normalMap=null,this.normalMapType=0,this.normalScale=new Vector2(1,1),this.displacementMap=null,this.displacementScale=1,this.displacementBias=0,this.specularMap=null,this.alphaMap=null,this.envMap=null,this.envMapRotation=new Euler,this.combine=0,this.reflectivity=1,this.refractionRatio=.98,this.wireframe=!1,this.wireframeLinewidth=1,this.wireframeLinecap="round",this.wireframeLinejoin="round",this.flatShading=!1,this.fog=!0,this.setValues(e)}copy(e){return super.copy(e),this.color.copy(e.color),this.specular.copy(e.specular),this.shininess=e.shininess,this.map=e.map,this.lightMap=e.lightMap,this.lightMapIntensity=e.lightMapIntensity,this.aoMap=e.aoMap,this.aoMapIntensity=e.aoMapIntensity,this.emissive.copy(e.emissive),this.emissiveMap=e.emissiveMap,this.emissiveIntensity=e.emissiveIntensity,this.bumpMap=e.bumpMap,this.bumpScale=e.bumpScale,this.normalMap=e.normalMap,this.normalMapType=e.normalMapType,this.normalScale.copy(e.normalScale),this.displacementMap=e.displacementMap,this.displacementScale=e.displacementScale,this.displacementBias=e.displacementBias,this.specularMap=e.specularMap,this.alphaMap=e.alphaMap,this.envMap=e.envMap,this.envMapRotation.copy(e.envMapRotation),this.combine=e.combine,this.reflectivity=e.reflectivity,this.refractionRatio=e.refractionRatio,this.wireframe=e.wireframe,this.wireframeLinewidth=e.wireframeLinewidth,this.wireframeLinecap=e.wireframeLinecap,this.wireframeLinejoin=e.wireframeLinejoin,this.flatShading=e.flatShading,this.fog=e.fog,this}}class MeshToonMaterial extends Material{constructor(e){super(),this.isMeshToonMaterial=!0,this.defines={TOON:""},this.type="MeshToonMaterial",this.color=new Color(16777215),this.map=null,this.gradientMap=null,this.lightMap=null,this.lightMapIntensity=1,this.aoMap=null,this.aoMapIntensity=1,this.emissive=new Color(0),this.emissiveIntensity=1,this.emissiveMap=null,this.bumpMap=null,this.bumpScale=1,this.normalMap=null,this.normalMapType=0,this.normalScale=new Vector2(1,1),this.displacementMap=null,this.displacementScale=1,this.displacementBias=0,this.alphaMap=null,this.wireframe=!1,this.wireframeLinewidth=1,this.wireframeLinecap="round",this.wireframeLinejoin="round",this.fog=!0,this.setValues(e)}copy(e){return super.copy(e),this.color.copy(e.color),this.map=e.map,this.gradientMap=e.gradientMap,this.lightMap=e.lightMap,this.lightMapIntensity=e.lightMapIntensity,this.aoMap=e.aoMap,this.aoMapIntensity=e.aoMapIntensity,this.emissive.copy(e.emissive),this.emissiveMap=e.emissiveMap,this.emissiveIntensity=e.emissiveIntensity,this.bumpMap=e.bumpMap,this.bumpScale=e.bumpScale,this.normalMap=e.normalMap,this.normalMapType=e.normalMapType,this.normalScale.copy(e.normalScale),this.displacementMap=e.displacementMap,this.displacementScale=e.displacementScale,this.displacementBias=e.displacementBias,this.alphaMap=e.alphaMap,this.wireframe=e.wireframe,this.wireframeLinewidth=e.wireframeLinewidth,this.wireframeLinecap=e.wireframeLinecap,this.wireframeLinejoin=e.wireframeLinejoin,this.fog=e.fog,this}}class MeshNormalMaterial extends Material{constructor(e){super(),this.isMeshNormalMaterial=!0,this.type="MeshNormalMaterial",this.bumpMap=null,this.bumpScale=1,this.normalMap=null,this.normalMapType=0,this.normalScale=new Vector2(1,1),this.displacementMap=null,this.displacementScale=1,this.displacementBias=0,this.wireframe=!1,this.wireframeLinewidth=1,this.flatShading=!1,this.setValues(e)}copy(e){return super.copy(e),this.bumpMap=e.bumpMap,this.bumpScale=e.bumpScale,this.normalMap=e.normalMap,this.normalMapType=e.normalMapType,this.normalScale.copy(e.normalScale),this.displacementMap=e.displacementMap,this.displacementScale=e.displacementScale,this.displacementBias=e.displacementBias,this.wireframe=e.wireframe,this.wireframeLinewidth=e.wireframeLinewidth,this.flatShading=e.flatShading,this}}class MeshLambertMaterial extends Material{constructor(e){super(),this.isMeshLambertMaterial=!0,this.type="MeshLambertMaterial",this.color=new Color(16777215),this.map=null,this.lightMap=null,this.lightMapIntensity=1,this.aoMap=null,this.aoMapIntensity=1,this.emissive=new Color(0),this.emissiveIntensity=1,this.emissiveMap=null,this.bumpMap=null,this.bumpScale=1,this.normalMap=null,this.normalMapType=0,this.normalScale=new Vector2(1,1),this.displacementMap=null,this.displacementScale=1,this.displacementBias=0,this.specularMap=null,this.alphaMap=null,this.envMap=null,this.envMapRotation=new Euler,this.combine=0,this.reflectivity=1,this.refractionRatio=.98,this.wireframe=!1,this.wireframeLinewidth=1,this.wireframeLinecap="round",this.wireframeLinejoin="round",this.flatShading=!1,this.fog=!0,this.setValues(e)}copy(e){return super.copy(e),this.color.copy(e.color),this.map=e.map,this.lightMap=e.lightMap,this.lightMapIntensity=e.lightMapIntensity,this.aoMap=e.aoMap,this.aoMapIntensity=e.aoMapIntensity,this.emissive.copy(e.emissive),this.emissiveMap=e.emissiveMap,this.emissiveIntensity=e.emissiveIntensity,this.bumpMap=e.bumpMap,this.bumpScale=e.bumpScale,this.normalMap=e.normalMap,this.normalMapType=e.normalMapType,this.normalScale.copy(e.normalScale),this.displacementMap=e.displacementMap,this.displacementScale=e.displacementScale,this.displacementBias=e.displacementBias,this.specularMap=e.specularMap,this.alphaMap=e.alphaMap,this.envMap=e.envMap,this.envMapRotation.copy(e.envMapRotation),this.combine=e.combine,this.reflectivity=e.reflectivity,this.refractionRatio=e.refractionRatio,this.wireframe=e.wireframe,this.wireframeLinewidth=e.wireframeLinewidth,this.wireframeLinecap=e.wireframeLinecap,this.wireframeLinejoin=e.wireframeLinejoin,this.flatShading=e.flatShading,this.fog=e.fog,this}}class MeshDepthMaterial extends Material{constructor(e){super(),this.isMeshDepthMaterial=!0,this.type="MeshDepthMaterial",this.depthPacking=3200,this.map=null,this.alphaMap=null,this.displacementMap=null,this.displacementScale=1,this.displacementBias=0,this.wireframe=!1,this.wireframeLinewidth=1,this.setValues(e)}copy(e){return super.copy(e),this.depthPacking=e.depthPacking,this.map=e.map,this.alphaMap=e.alphaMap,this.displacementMap=e.displacementMap,this.displacementScale=e.displacementScale,this.displacementBias=e.displacementBias,this.wireframe=e.wireframe,this.wireframeLinewidth=e.wireframeLinewidth,this}}class MeshDistanceMaterial extends Material{constructor(e){super(),this.isMeshDistanceMaterial=!0,this.type="MeshDistanceMaterial",this.map=null,this.alphaMap=null,this.displacementMap=null,this.displacementScale=1,this.displacementBias=0,this.setValues(e)}copy(e){return super.copy(e),this.map=e.map,this.alphaMap=e.alphaMap,this.displacementMap=e.displacementMap,this.displacementScale=e.displacementScale,this.displacementBias=e.displacementBias,this}}class MeshMatcapMaterial extends Material{constructor(e){super(),this.isMeshMatcapMaterial=!0,this.defines={MATCAP:""},this.type="MeshMatcapMaterial",this.color=new Color(16777215),this.matcap=null,this.map=null,this.bumpMap=null,this.bumpScale=1,this.normalMap=null,this.normalMapType=0,this.normalScale=new Vector2(1,1),this.displacementMap=null,this.displacementScale=1,this.displacementBias=0,this.alphaMap=null,this.flatShading=!1,this.fog=!0,this.setValues(e)}copy(e){return super.copy(e),this.defines={MATCAP:""},this.color.copy(e.color),this.matcap=e.matcap,this.map=e.map,this.bumpMap=e.bumpMap,this.bumpScale=e.bumpScale,this.normalMap=e.normalMap,this.normalMapType=e.normalMapType,this.normalScale.copy(e.normalScale),this.displacementMap=e.displacementMap,this.displacementScale=e.displacementScale,this.displacementBias=e.displacementBias,this.alphaMap=e.alphaMap,this.flatShading=e.flatShading,this.fog=e.fog,this}}class LineDashedMaterial extends LineBasicMaterial{constructor(e){super(),this.isLineDashedMaterial=!0,this.type="LineDashedMaterial",this.scale=1,this.dashSize=3,this.gapSize=1,this.setValues(e)}copy(e){return super.copy(e),this.scale=e.scale,this.dashSize=e.dashSize,this.gapSize=e.gapSize,this}}function convertArray(e,t){return e&&e.constructor!==t?"number"==typeof t.BYTES_PER_ELEMENT?new t(e):Array.prototype.slice.call(e):e}function isTypedArray(e){return ArrayBuffer.isView(e)&&!(e instanceof DataView)}function getKeyframeOrder(e){const t=e.length,r=new Array(t);for(let e=0;e!==t;++e)r[e]=e;return r.sort((function(t,r){return e[t]-e[r]})),r}function sortedArray(e,t,r){const n=e.length,i=new e.constructor(n);for(let a=0,s=0;s!==n;++a){const n=r[a]*t;for(let r=0;r!==t;++r)i[s++]=e[n+r]}return i}function flattenJSON(e,t,r,n){let i=1,a=e[0];for(;void 0!==a&&void 0===a[n];)a=e[i++];if(void 0===a)return;let s=a[n];if(void 0!==s)if(Array.isArray(s))do{s=a[n],void 0!==s&&(t.push(a.time),r.push(...s)),a=e[i++]}while(void 0!==a);else if(void 0!==s.toArray)do{s=a[n],void 0!==s&&(t.push(a.time),s.toArray(r,r.length)),a=e[i++]}while(void 0!==a);else do{s=a[n],void 0!==s&&(t.push(a.time),r.push(s)),a=e[i++]}while(void 0!==a)}function subclip(e,t,r,n,i=30){const a=e.clone();a.name=t;const s=[];for(let e=0;e<a.tracks.length;++e){const t=a.tracks[e],o=t.getValueSize(),l=[],c=[];for(let e=0;e<t.times.length;++e){const a=t.times[e]*i;if(!(a<r||a>=n)){l.push(t.times[e]);for(let r=0;r<o;++r)c.push(t.values[e*o+r])}}0!==l.length&&(t.times=convertArray(l,t.times.constructor),t.values=convertArray(c,t.values.constructor),s.push(t))}a.tracks=s;let o=1/0;for(let e=0;e<a.tracks.length;++e)o>a.tracks[e].times[0]&&(o=a.tracks[e].times[0]);for(let e=0;e<a.tracks.length;++e)a.tracks[e].shift(-1*o);return a.resetDuration(),a}function makeClipAdditive(e,t=0,r=e,n=30){n<=0&&(n=30);const i=r.tracks.length,a=t/n;for(let t=0;t<i;++t){const n=r.tracks[t],i=n.ValueTypeName;if("bool"===i||"string"===i)continue;const s=e.tracks.find((function(e){return e.name===n.name&&e.ValueTypeName===i}));if(void 0===s)continue;let o=0;const l=n.getValueSize();n.createInterpolant.isInterpolantFactoryMethodGLTFCubicSpline&&(o=l/3);let c=0;const h=s.getValueSize();s.createInterpolant.isInterpolantFactoryMethodGLTFCubicSpline&&(c=h/3);const u=n.times.length-1;let d;if(a<=n.times[0]){const e=o,t=l-o;d=n.values.slice(e,t)}else if(a>=n.times[u]){const e=u*l+o,t=e+l-o;d=n.values.slice(e,t)}else{const e=n.createInterpolant(),t=o,r=l-o;e.evaluate(a),d=e.resultBuffer.slice(t,r)}if("quaternion"===i){(new Quaternion).fromArray(d).normalize().conjugate().toArray(d)}const p=s.times.length;for(let e=0;e<p;++e){const t=e*h+c;if("quaternion"===i)Quaternion.multiplyQuaternionsFlat(s.values,t,d,0,s.values,t);else{const e=h-2*c;for(let r=0;r<e;++r)s.values[t+r]-=d[r]}}}return e.blendMode=2501,e}class AnimationUtils{static convertArray(e,t){return convertArray(e,t)}static isTypedArray(e){return isTypedArray(e)}static getKeyframeOrder(e){return getKeyframeOrder(e)}static sortedArray(e,t,r){return sortedArray(e,t,r)}static flattenJSON(e,t,r,n){flattenJSON(e,t,r,n)}static subclip(e,t,r,n,i=30){return subclip(e,t,r,n,i)}static makeClipAdditive(e,t=0,r=e,n=30){return makeClipAdditive(e,t,r,n)}}class Interpolant{constructor(e,t,r,n){this.parameterPositions=e,this._cachedIndex=0,this.resultBuffer=void 0!==n?n:new t.constructor(r),this.sampleValues=t,this.valueSize=r,this.settings=null,this.DefaultSettings_={}}evaluate(e){const t=this.parameterPositions;let r=this._cachedIndex,n=t[r],i=t[r-1];e:{t:{let a;r:{n:if(!(e<n)){for(let a=r+2;;){if(void 0===n){if(e<i)break n;return r=t.length,this._cachedIndex=r,this.copySampleValue_(r-1)}if(r===a)break;if(i=n,n=t[++r],e<n)break t}a=t.length;break r}if(e>=i)break e;{const s=t[1];e<s&&(r=2,i=s);for(let a=r-2;;){if(void 0===i)return this._cachedIndex=0,this.copySampleValue_(0);if(r===a)break;if(n=i,i=t[--r-1],e>=i)break t}a=r,r=0}}for(;r<a;){const n=r+a>>>1;e<t[n]?a=n:r=n+1}if(n=t[r],i=t[r-1],void 0===i)return this._cachedIndex=0,this.copySampleValue_(0);if(void 0===n)return r=t.length,this._cachedIndex=r,this.copySampleValue_(r-1)}this._cachedIndex=r,this.intervalChanged_(r,i,n)}return this.interpolate_(r,i,e,n)}getSettings_(){return this.settings||this.DefaultSettings_}copySampleValue_(e){const t=this.resultBuffer,r=this.sampleValues,n=this.valueSize,i=e*n;for(let e=0;e!==n;++e)t[e]=r[i+e];return t}interpolate_(){throw new Error("call to abstract method")}intervalChanged_(){}}class CubicInterpolant extends Interpolant{constructor(e,t,r,n){super(e,t,r,n),this._weightPrev=-0,this._offsetPrev=-0,this._weightNext=-0,this._offsetNext=-0,this.DefaultSettings_={endingStart:2400,endingEnd:2400}}intervalChanged_(e,t,r){const n=this.parameterPositions;let i=e-2,a=e+1,s=n[i],o=n[a];if(void 0===s)switch(this.getSettings_().endingStart){case 2401:i=e,s=2*t-r;break;case 2402:i=n.length-2,s=t+n[i]-n[i+1];break;default:i=e,s=r}if(void 0===o)switch(this.getSettings_().endingEnd){case 2401:a=e,o=2*r-t;break;case 2402:a=1,o=r+n[1]-n[0];break;default:a=e-1,o=t}const l=.5*(r-t),c=this.valueSize;this._weightPrev=l/(t-s),this._weightNext=l/(o-r),this._offsetPrev=i*c,this._offsetNext=a*c}interpolate_(e,t,r,n){const i=this.resultBuffer,a=this.sampleValues,s=this.valueSize,o=e*s,l=o-s,c=this._offsetPrev,h=this._offsetNext,u=this._weightPrev,d=this._weightNext,p=(r-t)/(n-t),m=p*p,f=m*p,g=-u*f+2*u*m-u*p,_=(1+u)*f+(-1.5-2*u)*m+(-.5+u)*p+1,v=(-1-d)*f+(1.5+d)*m+.5*p,x=d*f-d*m;for(let e=0;e!==s;++e)i[e]=g*a[c+e]+_*a[l+e]+v*a[o+e]+x*a[h+e];return i}}class LinearInterpolant extends Interpolant{constructor(e,t,r,n){super(e,t,r,n)}interpolate_(e,t,r,n){const i=this.resultBuffer,a=this.sampleValues,s=this.valueSize,o=e*s,l=o-s,c=(r-t)/(n-t),h=1-c;for(let e=0;e!==s;++e)i[e]=a[l+e]*h+a[o+e]*c;return i}}class DiscreteInterpolant extends Interpolant{constructor(e,t,r,n){super(e,t,r,n)}interpolate_(e){return this.copySampleValue_(e-1)}}class KeyframeTrack{constructor(e,t,r,n){if(void 0===e)throw new Error("THREE.KeyframeTrack: track name is undefined");if(void 0===t||0===t.length)throw new Error("THREE.KeyframeTrack: no keyframes in track named "+e);this.name=e,this.times=convertArray(t,this.TimeBufferType),this.values=convertArray(r,this.ValueBufferType),this.setInterpolation(n||this.DefaultInterpolation)}static toJSON(e){const t=e.constructor;let r;if(t.toJSON!==this.toJSON)r=t.toJSON(e);else{r={name:e.name,times:convertArray(e.times,Array),values:convertArray(e.values,Array)};const t=e.getInterpolation();t!==e.DefaultInterpolation&&(r.interpolation=t)}return r.type=e.ValueTypeName,r}InterpolantFactoryMethodDiscrete(e){return new DiscreteInterpolant(this.times,this.values,this.getValueSize(),e)}InterpolantFactoryMethodLinear(e){return new LinearInterpolant(this.times,this.values,this.getValueSize(),e)}InterpolantFactoryMethodSmooth(e){return new CubicInterpolant(this.times,this.values,this.getValueSize(),e)}setInterpolation(e){let t;switch(e){case 2300:t=this.InterpolantFactoryMethodDiscrete;break;case 2301:t=this.InterpolantFactoryMethodLinear;break;case 2302:t=this.InterpolantFactoryMethodSmooth}if(void 0===t){const t="unsupported interpolation for "+this.ValueTypeName+" keyframe track named "+this.name;if(void 0===this.createInterpolant){if(e===this.DefaultInterpolation)throw new Error(t);this.setInterpolation(this.DefaultInterpolation)}return console.warn("THREE.KeyframeTrack:",t),this}return this.createInterpolant=t,this}getInterpolation(){switch(this.createInterpolant){case this.InterpolantFactoryMethodDiscrete:return 2300;case this.InterpolantFactoryMethodLinear:return 2301;case this.InterpolantFactoryMethodSmooth:return 2302}}getValueSize(){return this.values.length/this.times.length}shift(e){if(0!==e){const t=this.times;for(let r=0,n=t.length;r!==n;++r)t[r]+=e}return this}scale(e){if(1!==e){const t=this.times;for(let r=0,n=t.length;r!==n;++r)t[r]*=e}return this}trim(e,t){const r=this.times,n=r.length;let i=0,a=n-1;for(;i!==n&&r[i]<e;)++i;for(;-1!==a&&r[a]>t;)--a;if(++a,0!==i||a!==n){i>=a&&(a=Math.max(a,1),i=a-1);const e=this.getValueSize();this.times=r.slice(i,a),this.values=this.values.slice(i*e,a*e)}return this}validate(){let e=!0;const t=this.getValueSize();t-Math.floor(t)!=0&&(console.error("THREE.KeyframeTrack: Invalid value size in track.",this),e=!1);const r=this.times,n=this.values,i=r.length;0===i&&(console.error("THREE.KeyframeTrack: Track is empty.",this),e=!1);let a=null;for(let t=0;t!==i;t++){const n=r[t];if("number"==typeof n&&isNaN(n)){console.error("THREE.KeyframeTrack: Time is not a valid number.",this,t,n),e=!1;break}if(null!==a&&a>n){console.error("THREE.KeyframeTrack: Out of order keys.",this,t,n,a),e=!1;break}a=n}if(void 0!==n&&isTypedArray(n))for(let t=0,r=n.length;t!==r;++t){const r=n[t];if(isNaN(r)){console.error("THREE.KeyframeTrack: Value is not a valid number.",this,t,r),e=!1;break}}return e}optimize(){const e=this.times.slice(),t=this.values.slice(),r=this.getValueSize(),n=2302===this.getInterpolation(),i=e.length-1;let a=1;for(let s=1;s<i;++s){let i=!1;const o=e[s];if(o!==e[s+1]&&(1!==s||o!==e[0]))if(n)i=!0;else{const e=s*r,n=e-r,a=e+r;for(let s=0;s!==r;++s){const r=t[e+s];if(r!==t[n+s]||r!==t[a+s]){i=!0;break}}}if(i){if(s!==a){e[a]=e[s];const n=s*r,i=a*r;for(let e=0;e!==r;++e)t[i+e]=t[n+e]}++a}}if(i>0){e[a]=e[i];for(let e=i*r,n=a*r,s=0;s!==r;++s)t[n+s]=t[e+s];++a}return a!==e.length?(this.times=e.slice(0,a),this.values=t.slice(0,a*r)):(this.times=e,this.values=t),this}clone(){const e=this.times.slice(),t=this.values.slice(),r=new(0,this.constructor)(this.name,e,t);return r.createInterpolant=this.createInterpolant,r}}KeyframeTrack.prototype.ValueTypeName="",KeyframeTrack.prototype.TimeBufferType=Float32Array,KeyframeTrack.prototype.ValueBufferType=Float32Array,KeyframeTrack.prototype.DefaultInterpolation=2301;class BooleanKeyframeTrack extends KeyframeTrack{constructor(e,t,r){super(e,t,r)}}BooleanKeyframeTrack.prototype.ValueTypeName="bool",BooleanKeyframeTrack.prototype.ValueBufferType=Array,BooleanKeyframeTrack.prototype.DefaultInterpolation=2300,BooleanKeyframeTrack.prototype.InterpolantFactoryMethodLinear=void 0,BooleanKeyframeTrack.prototype.InterpolantFactoryMethodSmooth=void 0;class ColorKeyframeTrack extends KeyframeTrack{constructor(e,t,r,n){super(e,t,r,n)}}ColorKeyframeTrack.prototype.ValueTypeName="color";class NumberKeyframeTrack extends KeyframeTrack{constructor(e,t,r,n){super(e,t,r,n)}}NumberKeyframeTrack.prototype.ValueTypeName="number";class QuaternionLinearInterpolant extends Interpolant{constructor(e,t,r,n){super(e,t,r,n)}interpolate_(e,t,r,n){const i=this.resultBuffer,a=this.sampleValues,s=this.valueSize,o=(r-t)/(n-t);let l=e*s;for(let e=l+s;l!==e;l+=4)Quaternion.slerpFlat(i,0,a,l-s,a,l,o);return i}}class QuaternionKeyframeTrack extends KeyframeTrack{constructor(e,t,r,n){super(e,t,r,n)}InterpolantFactoryMethodLinear(e){return new QuaternionLinearInterpolant(this.times,this.values,this.getValueSize(),e)}}QuaternionKeyframeTrack.prototype.ValueTypeName="quaternion",QuaternionKeyframeTrack.prototype.InterpolantFactoryMethodSmooth=void 0;class StringKeyframeTrack extends KeyframeTrack{constructor(e,t,r){super(e,t,r)}}StringKeyframeTrack.prototype.ValueTypeName="string",StringKeyframeTrack.prototype.ValueBufferType=Array,StringKeyframeTrack.prototype.DefaultInterpolation=2300,StringKeyframeTrack.prototype.InterpolantFactoryMethodLinear=void 0,StringKeyframeTrack.prototype.InterpolantFactoryMethodSmooth=void 0;class VectorKeyframeTrack extends KeyframeTrack{constructor(e,t,r,n){super(e,t,r,n)}}VectorKeyframeTrack.prototype.ValueTypeName="vector";class AnimationClip{constructor(e="",t=-1,r=[],n=2500){this.name=e,this.tracks=r,this.duration=t,this.blendMode=n,this.uuid=generateUUID(),this.duration<0&&this.resetDuration()}static parse(e){const t=[],r=e.tracks,n=1/(e.fps||1);for(let e=0,i=r.length;e!==i;++e)t.push(parseKeyframeTrack(r[e]).scale(n));const i=new this(e.name,e.duration,t,e.blendMode);return i.uuid=e.uuid,i}static toJSON(e){const t=[],r=e.tracks,n={name:e.name,duration:e.duration,tracks:t,uuid:e.uuid,blendMode:e.blendMode};for(let e=0,n=r.length;e!==n;++e)t.push(KeyframeTrack.toJSON(r[e]));return n}static CreateFromMorphTargetSequence(e,t,r,n){const i=t.length,a=[];for(let e=0;e<i;e++){let s=[],o=[];s.push((e+i-1)%i,e,(e+1)%i),o.push(0,1,0);const l=getKeyframeOrder(s);s=sortedArray(s,1,l),o=sortedArray(o,1,l),n||0!==s[0]||(s.push(i),o.push(o[0])),a.push(new NumberKeyframeTrack(".morphTargetInfluences["+t[e].name+"]",s,o).scale(1/r))}return new this(e,-1,a)}static findByName(e,t){let r=e;if(!Array.isArray(e)){const t=e;r=t.geometry&&t.geometry.animations||t.animations}for(let e=0;e<r.length;e++)if(r[e].name===t)return r[e];return null}static CreateClipsFromMorphTargetSequences(e,t,r){const n={},i=/^([\w-]*?)([\d]+)$/;for(let t=0,r=e.length;t<r;t++){const r=e[t],a=r.name.match(i);if(a&&a.length>1){const e=a[1];let t=n[e];t||(n[e]=t=[]),t.push(r)}}const a=[];for(const e in n)a.push(this.CreateFromMorphTargetSequence(e,n[e],t,r));return a}static parseAnimation(e,t){if(console.warn("THREE.AnimationClip: parseAnimation() is deprecated and will be removed with r185"),!e)return console.error("THREE.AnimationClip: No animation in JSONLoader data."),null;const r=function(e,t,r,n,i){if(0!==r.length){const a=[],s=[];flattenJSON(r,a,s,n),0!==a.length&&i.push(new e(t,a,s))}},n=[],i=e.name||"default",a=e.fps||30,s=e.blendMode;let o=e.length||-1;const l=e.hierarchy||[];for(let e=0;e<l.length;e++){const i=l[e].keys;if(i&&0!==i.length)if(i[0].morphTargets){const e={};let t;for(t=0;t<i.length;t++)if(i[t].morphTargets)for(let r=0;r<i[t].morphTargets.length;r++)e[i[t].morphTargets[r]]=-1;for(const r in e){const e=[],a=[];for(let n=0;n!==i[t].morphTargets.length;++n){const n=i[t];e.push(n.time),a.push(n.morphTarget===r?1:0)}n.push(new NumberKeyframeTrack(".morphTargetInfluence["+r+"]",e,a))}o=e.length*a}else{const a=".bones["+t[e].name+"]";r(VectorKeyframeTrack,a+".position",i,"pos",n),r(QuaternionKeyframeTrack,a+".quaternion",i,"rot",n),r(VectorKeyframeTrack,a+".scale",i,"scl",n)}}if(0===n.length)return null;return new this(i,o,n,s)}resetDuration(){let e=0;for(let t=0,r=this.tracks.length;t!==r;++t){const r=this.tracks[t];e=Math.max(e,r.times[r.times.length-1])}return this.duration=e,this}trim(){for(let e=0;e<this.tracks.length;e++)this.tracks[e].trim(0,this.duration);return this}validate(){let e=!0;for(let t=0;t<this.tracks.length;t++)e=e&&this.tracks[t].validate();return e}optimize(){for(let e=0;e<this.tracks.length;e++)this.tracks[e].optimize();return this}clone(){const e=[];for(let t=0;t<this.tracks.length;t++)e.push(this.tracks[t].clone());return new this.constructor(this.name,this.duration,e,this.blendMode)}toJSON(){return this.constructor.toJSON(this)}}function getTrackTypeForValueTypeName(e){switch(e.toLowerCase()){case"scalar":case"double":case"float":case"number":case"integer":return NumberKeyframeTrack;case"vector":case"vector2":case"vector3":case"vector4":return VectorKeyframeTrack;case"color":return ColorKeyframeTrack;case"quaternion":return QuaternionKeyframeTrack;case"bool":case"boolean":return BooleanKeyframeTrack;case"string":return StringKeyframeTrack}throw new Error("THREE.KeyframeTrack: Unsupported typeName: "+e)}function parseKeyframeTrack(e){if(void 0===e.type)throw new Error("THREE.KeyframeTrack: track type undefined, can not parse");const t=getTrackTypeForValueTypeName(e.type);if(void 0===e.times){const t=[],r=[];flattenJSON(e.keys,t,r,"value"),e.times=t,e.values=r}return void 0!==t.parse?t.parse(e):new t(e.name,e.times,e.values,e.interpolation)}const Cache={enabled:!1,files:{},add:function(e,t){!1!==this.enabled&&(this.files[e]=t)},get:function(e){if(!1!==this.enabled)return this.files[e]},remove:function(e){delete this.files[e]},clear:function(){this.files={}}};class LoadingManager{constructor(e,t,r){const n=this;let i,a=!1,s=0,o=0;const l=[];this.onStart=void 0,this.onLoad=e,this.onProgress=t,this.onError=r,this.itemStart=function(e){o++,!1===a&&void 0!==n.onStart&&n.onStart(e,s,o),a=!0},this.itemEnd=function(e){s++,void 0!==n.onProgress&&n.onProgress(e,s,o),s===o&&(a=!1,void 0!==n.onLoad&&n.onLoad())},this.itemError=function(e){void 0!==n.onError&&n.onError(e)},this.resolveURL=function(e){return i?i(e):e},this.setURLModifier=function(e){return i=e,this},this.addHandler=function(e,t){return l.push(e,t),this},this.removeHandler=function(e){const t=l.indexOf(e);return-1!==t&&l.splice(t,2),this},this.getHandler=function(e){for(let t=0,r=l.length;t<r;t+=2){const r=l[t],n=l[t+1];if(r.global&&(r.lastIndex=0),r.test(e))return n}return null}}}const DefaultLoadingManager=new LoadingManager;class Loader{constructor(e){this.manager=void 0!==e?e:DefaultLoadingManager,this.crossOrigin="anonymous",this.withCredentials=!1,this.path="",this.resourcePath="",this.requestHeader={}}load(){}loadAsync(e,t){const r=this;return new Promise((function(n,i){r.load(e,n,t,i)}))}parse(){}setCrossOrigin(e){return this.crossOrigin=e,this}setWithCredentials(e){return this.withCredentials=e,this}setPath(e){return this.path=e,this}setResourcePath(e){return this.resourcePath=e,this}setRequestHeader(e){return this.requestHeader=e,this}}Loader.DEFAULT_MATERIAL_NAME="__DEFAULT";const loading={};class HttpError extends Error{constructor(e,t){super(e),this.response=t}}class FileLoader extends Loader{constructor(e){super(e),this.mimeType="",this.responseType=""}load(e,t,r,n){void 0===e&&(e=""),void 0!==this.path&&(e=this.path+e),e=this.manager.resolveURL(e);const i=Cache.get(e);if(void 0!==i)return this.manager.itemStart(e),setTimeout((()=>{t&&t(i),this.manager.itemEnd(e)}),0),i;if(void 0!==loading[e])return void loading[e].push({onLoad:t,onProgress:r,onError:n});loading[e]=[],loading[e].push({onLoad:t,onProgress:r,onError:n});const a=new Request(e,{headers:new Headers(this.requestHeader),credentials:this.withCredentials?"include":"same-origin"}),s=this.mimeType,o=this.responseType;fetch(a).then((t=>{if(200===t.status||0===t.status){if(0===t.status&&console.warn("THREE.FileLoader: HTTP Status 0 received."),"undefined"==typeof ReadableStream||void 0===t.body||void 0===t.body.getReader)return t;const r=loading[e],n=t.body.getReader(),i=t.headers.get("X-File-Size")||t.headers.get("Content-Length"),a=i?parseInt(i):0,s=0!==a;let o=0;const l=new ReadableStream({start(e){!function t(){n.read().then((({done:n,value:i})=>{if(n)e.close();else{o+=i.byteLength;const n=new ProgressEvent("progress",{lengthComputable:s,loaded:o,total:a});for(let e=0,t=r.length;e<t;e++){const t=r[e];t.onProgress&&t.onProgress(n)}e.enqueue(i),t()}}),(t=>{e.error(t)}))}()}});return new Response(l)}throw new HttpError(`fetch for "${t.url}" responded with ${t.status}: ${t.statusText}`,t)})).then((e=>{switch(o){case"arraybuffer":return e.arrayBuffer();case"blob":return e.blob();case"document":return e.text().then((e=>(new DOMParser).parseFromString(e,s)));case"json":return e.json();default:if(""===s)return e.text();{const t=/charset="?([^;"\s]*)"?/i.exec(s),r=t&&t[1]?t[1].toLowerCase():void 0,n=new TextDecoder(r);return e.arrayBuffer().then((e=>n.decode(e)))}}})).then((t=>{Cache.add(e,t);const r=loading[e];delete loading[e];for(let e=0,n=r.length;e<n;e++){const n=r[e];n.onLoad&&n.onLoad(t)}})).catch((t=>{const r=loading[e];if(void 0===r)throw this.manager.itemError(e),t;delete loading[e];for(let e=0,n=r.length;e<n;e++){const n=r[e];n.onError&&n.onError(t)}this.manager.itemError(e)})).finally((()=>{this.manager.itemEnd(e)})),this.manager.itemStart(e)}setResponseType(e){return this.responseType=e,this}setMimeType(e){return this.mimeType=e,this}}class AnimationLoader extends Loader{constructor(e){super(e)}load(e,t,r,n){const i=this,a=new FileLoader(this.manager);a.setPath(this.path),a.setRequestHeader(this.requestHeader),a.setWithCredentials(this.withCredentials),a.load(e,(function(r){try{t(i.parse(JSON.parse(r)))}catch(t){n?n(t):console.error(t),i.manager.itemError(e)}}),r,n)}parse(e){const t=[];for(let r=0;r<e.length;r++){const n=AnimationClip.parse(e[r]);t.push(n)}return t}}class CompressedTextureLoader extends Loader{constructor(e){super(e)}load(e,t,r,n){const i=this,a=[],s=new CompressedTexture,o=new FileLoader(this.manager);o.setPath(this.path),o.setResponseType("arraybuffer"),o.setRequestHeader(this.requestHeader),o.setWithCredentials(i.withCredentials);let l=0;function c(c){o.load(e[c],(function(e){const r=i.parse(e,!0);a[c]={width:r.width,height:r.height,format:r.format,mipmaps:r.mipmaps},l+=1,6===l&&(1===r.mipmapCount&&(s.minFilter=1006),s.image=a,s.format=r.format,s.needsUpdate=!0,t&&t(s))}),r,n)}if(Array.isArray(e))for(let t=0,r=e.length;t<r;++t)c(t);else o.load(e,(function(e){const r=i.parse(e,!0);if(r.isCubemap){const e=r.mipmaps.length/r.mipmapCount;for(let t=0;t<e;t++){a[t]={mipmaps:[]};for(let e=0;e<r.mipmapCount;e++)a[t].mipmaps.push(r.mipmaps[t*r.mipmapCount+e]),a[t].format=r.format,a[t].width=r.width,a[t].height=r.height}s.image=a}else s.image.width=r.width,s.image.height=r.height,s.mipmaps=r.mipmaps;1===r.mipmapCount&&(s.minFilter=1006),s.format=r.format,s.needsUpdate=!0,t&&t(s)}),r,n);return s}}class ImageLoader extends Loader{constructor(e){super(e)}load(e,t,r,n){void 0!==this.path&&(e=this.path+e),e=this.manager.resolveURL(e);const i=this,a=Cache.get(e);if(void 0!==a)return i.manager.itemStart(e),setTimeout((function(){t&&t(a),i.manager.itemEnd(e)}),0),a;const s=createElementNS("img");function o(){c(),Cache.add(e,this),t&&t(this),i.manager.itemEnd(e)}function l(t){c(),n&&n(t),i.manager.itemError(e),i.manager.itemEnd(e)}function c(){s.removeEventListener("load",o,!1),s.removeEventListener("error",l,!1)}return s.addEventListener("load",o,!1),s.addEventListener("error",l,!1),"data:"!==e.slice(0,5)&&void 0!==this.crossOrigin&&(s.crossOrigin=this.crossOrigin),i.manager.itemStart(e),s.src=e,s}}class CubeTextureLoader extends Loader{constructor(e){super(e)}load(e,t,r,n){const i=new CubeTexture;i.colorSpace="srgb";const a=new ImageLoader(this.manager);a.setCrossOrigin(this.crossOrigin),a.setPath(this.path);let s=0;function o(r){a.load(e[r],(function(e){i.images[r]=e,s++,6===s&&(i.needsUpdate=!0,t&&t(i))}),void 0,n)}for(let t=0;t<e.length;++t)o(t);return i}}class DataTextureLoader extends Loader{constructor(e){super(e)}load(e,t,r,n){const i=this,a=new DataTexture,s=new FileLoader(this.manager);return s.setResponseType("arraybuffer"),s.setRequestHeader(this.requestHeader),s.setPath(this.path),s.setWithCredentials(i.withCredentials),s.load(e,(function(e){let r;try{r=i.parse(e)}catch(e){if(void 0===n)return void console.error(e);n(e)}void 0!==r.image?a.image=r.image:void 0!==r.data&&(a.image.width=r.width,a.image.height=r.height,a.image.data=r.data),a.wrapS=void 0!==r.wrapS?r.wrapS:1001,a.wrapT=void 0!==r.wrapT?r.wrapT:1001,a.magFilter=void 0!==r.magFilter?r.magFilter:1006,a.minFilter=void 0!==r.minFilter?r.minFilter:1006,a.anisotropy=void 0!==r.anisotropy?r.anisotropy:1,void 0!==r.colorSpace&&(a.colorSpace=r.colorSpace),void 0!==r.flipY&&(a.flipY=r.flipY),void 0!==r.format&&(a.format=r.format),void 0!==r.type&&(a.type=r.type),void 0!==r.mipmaps&&(a.mipmaps=r.mipmaps,a.minFilter=1008),1===r.mipmapCount&&(a.minFilter=1006),void 0!==r.generateMipmaps&&(a.generateMipmaps=r.generateMipmaps),a.needsUpdate=!0,t&&t(a,r)}),r,n),a}}class TextureLoader extends Loader{constructor(e){super(e)}load(e,t,r,n){const i=new Texture,a=new ImageLoader(this.manager);return a.setCrossOrigin(this.crossOrigin),a.setPath(this.path),a.load(e,(function(e){i.image=e,i.needsUpdate=!0,void 0!==t&&t(i)}),r,n),i}}class Light extends Object3D{constructor(e,t=1){super(),this.isLight=!0,this.type="Light",this.color=new Color(e),this.intensity=t}dispose(){}copy(e,t){return super.copy(e,t),this.color.copy(e.color),this.intensity=e.intensity,this}toJSON(e){const t=super.toJSON(e);return t.object.color=this.color.getHex(),t.object.intensity=this.intensity,void 0!==this.groundColor&&(t.object.groundColor=this.groundColor.getHex()),void 0!==this.distance&&(t.object.distance=this.distance),void 0!==this.angle&&(t.object.angle=this.angle),void 0!==this.decay&&(t.object.decay=this.decay),void 0!==this.penumbra&&(t.object.penumbra=this.penumbra),void 0!==this.shadow&&(t.object.shadow=this.shadow.toJSON()),void 0!==this.target&&(t.object.target=this.target.uuid),t}}class HemisphereLight extends Light{constructor(e,t,r){super(e,r),this.isHemisphereLight=!0,this.type="HemisphereLight",this.position.copy(Object3D.DEFAULT_UP),this.updateMatrix(),this.groundColor=new Color(t)}copy(e,t){return super.copy(e,t),this.groundColor.copy(e.groundColor),this}}const _projScreenMatrix$1=new Matrix4,_lightPositionWorld$1=new Vector3,_lookTarget$1=new Vector3;class LightShadow{constructor(e){this.camera=e,this.intensity=1,this.bias=0,this.normalBias=0,this.radius=1,this.blurSamples=8,this.mapSize=new Vector2(512,512),this.mapType=1009,this.map=null,this.mapPass=null,this.matrix=new Matrix4,this.autoUpdate=!0,this.needsUpdate=!1,this._frustum=new Frustum,this._frameExtents=new Vector2(1,1),this._viewportCount=1,this._viewports=[new Vector4(0,0,1,1)]}getViewportCount(){return this._viewportCount}getFrustum(){return this._frustum}updateMatrices(e){const t=this.camera,r=this.matrix;_lightPositionWorld$1.setFromMatrixPosition(e.matrixWorld),t.position.copy(_lightPositionWorld$1),_lookTarget$1.setFromMatrixPosition(e.target.matrixWorld),t.lookAt(_lookTarget$1),t.updateMatrixWorld(),_projScreenMatrix$1.multiplyMatrices(t.projectionMatrix,t.matrixWorldInverse),this._frustum.setFromProjectionMatrix(_projScreenMatrix$1),r.set(.5,0,0,.5,0,.5,0,.5,0,0,.5,.5,0,0,0,1),r.multiply(_projScreenMatrix$1)}getViewport(e){return this._viewports[e]}getFrameExtents(){return this._frameExtents}dispose(){this.map&&this.map.dispose(),this.mapPass&&this.mapPass.dispose()}copy(e){return this.camera=e.camera.clone(),this.intensity=e.intensity,this.bias=e.bias,this.radius=e.radius,this.autoUpdate=e.autoUpdate,this.needsUpdate=e.needsUpdate,this.normalBias=e.normalBias,this.blurSamples=e.blurSamples,this.mapSize.copy(e.mapSize),this}clone(){return(new this.constructor).copy(this)}toJSON(){const e={};return 1!==this.intensity&&(e.intensity=this.intensity),0!==this.bias&&(e.bias=this.bias),0!==this.normalBias&&(e.normalBias=this.normalBias),1!==this.radius&&(e.radius=this.radius),512===this.mapSize.x&&512===this.mapSize.y||(e.mapSize=this.mapSize.toArray()),e.camera=this.camera.toJSON(!1).object,delete e.camera.matrix,e}}class SpotLightShadow extends LightShadow{constructor(){super(new PerspectiveCamera(50,1,.5,500)),this.isSpotLightShadow=!0,this.focus=1}updateMatrices(e){const t=this.camera,r=2*RAD2DEG*e.angle*this.focus,n=this.mapSize.width/this.mapSize.height,i=e.distance||t.far;r===t.fov&&n===t.aspect&&i===t.far||(t.fov=r,t.aspect=n,t.far=i,t.updateProjectionMatrix()),super.updateMatrices(e)}copy(e){return super.copy(e),this.focus=e.focus,this}}class SpotLight extends Light{constructor(e,t,r=0,n=Math.PI/3,i=0,a=2){super(e,t),this.isSpotLight=!0,this.type="SpotLight",this.position.copy(Object3D.DEFAULT_UP),this.updateMatrix(),this.target=new Object3D,this.distance=r,this.angle=n,this.penumbra=i,this.decay=a,this.map=null,this.shadow=new SpotLightShadow}get power(){return this.intensity*Math.PI}set power(e){this.intensity=e/Math.PI}dispose(){this.shadow.dispose()}copy(e,t){return super.copy(e,t),this.distance=e.distance,this.angle=e.angle,this.penumbra=e.penumbra,this.decay=e.decay,this.target=e.target.clone(),this.shadow=e.shadow.clone(),this}}const _projScreenMatrix=new Matrix4,_lightPositionWorld=new Vector3,_lookTarget=new Vector3;class PointLightShadow extends LightShadow{constructor(){super(new PerspectiveCamera(90,1,.5,500)),this.isPointLightShadow=!0,this._frameExtents=new Vector2(4,2),this._viewportCount=6,this._viewports=[new Vector4(2,1,1,1),new Vector4(0,1,1,1),new Vector4(3,1,1,1),new Vector4(1,1,1,1),new Vector4(3,0,1,1),new Vector4(1,0,1,1)],this._cubeDirections=[new Vector3(1,0,0),new Vector3(-1,0,0),new Vector3(0,0,1),new Vector3(0,0,-1),new Vector3(0,1,0),new Vector3(0,-1,0)],this._cubeUps=[new Vector3(0,1,0),new Vector3(0,1,0),new Vector3(0,1,0),new Vector3(0,1,0),new Vector3(0,0,1),new Vector3(0,0,-1)]}updateMatrices(e,t=0){const r=this.camera,n=this.matrix,i=e.distance||r.far;i!==r.far&&(r.far=i,r.updateProjectionMatrix()),_lightPositionWorld.setFromMatrixPosition(e.matrixWorld),r.position.copy(_lightPositionWorld),_lookTarget.copy(r.position),_lookTarget.add(this._cubeDirections[t]),r.up.copy(this._cubeUps[t]),r.lookAt(_lookTarget),r.updateMatrixWorld(),n.makeTranslation(-_lightPositionWorld.x,-_lightPositionWorld.y,-_lightPositionWorld.z),_projScreenMatrix.multiplyMatrices(r.projectionMatrix,r.matrixWorldInverse),this._frustum.setFromProjectionMatrix(_projScreenMatrix)}}class PointLight extends Light{constructor(e,t,r=0,n=2){super(e,t),this.isPointLight=!0,this.type="PointLight",this.distance=r,this.decay=n,this.shadow=new PointLightShadow}get power(){return 4*this.intensity*Math.PI}set power(e){this.intensity=e/(4*Math.PI)}dispose(){this.shadow.dispose()}copy(e,t){return super.copy(e,t),this.distance=e.distance,this.decay=e.decay,this.shadow=e.shadow.clone(),this}}class OrthographicCamera extends Camera{constructor(e=-1,t=1,r=1,n=-1,i=.1,a=2e3){super(),this.isOrthographicCamera=!0,this.type="OrthographicCamera",this.zoom=1,this.view=null,this.left=e,this.right=t,this.top=r,this.bottom=n,this.near=i,this.far=a,this.updateProjectionMatrix()}copy(e,t){return super.copy(e,t),this.left=e.left,this.right=e.right,this.top=e.top,this.bottom=e.bottom,this.near=e.near,this.far=e.far,this.zoom=e.zoom,this.view=null===e.view?null:Object.assign({},e.view),this}setViewOffset(e,t,r,n,i,a){null===this.view&&(this.view={enabled:!0,fullWidth:1,fullHeight:1,offsetX:0,offsetY:0,width:1,height:1}),this.view.enabled=!0,this.view.fullWidth=e,this.view.fullHeight=t,this.view.offsetX=r,this.view.offsetY=n,this.view.width=i,this.view.height=a,this.updateProjectionMatrix()}clearViewOffset(){null!==this.view&&(this.view.enabled=!1),this.updateProjectionMatrix()}updateProjectionMatrix(){const e=(this.right-this.left)/(2*this.zoom),t=(this.top-this.bottom)/(2*this.zoom),r=(this.right+this.left)/2,n=(this.top+this.bottom)/2;let i=r-e,a=r+e,s=n+t,o=n-t;if(null!==this.view&&this.view.enabled){const e=(this.right-this.left)/this.view.fullWidth/this.zoom,t=(this.top-this.bottom)/this.view.fullHeight/this.zoom;i+=e*this.view.offsetX,a=i+e*this.view.width,s-=t*this.view.offsetY,o=s-t*this.view.height}this.projectionMatrix.makeOrthographic(i,a,s,o,this.near,this.far,this.coordinateSystem),this.projectionMatrixInverse.copy(this.projectionMatrix).invert()}toJSON(e){const t=super.toJSON(e);return t.object.zoom=this.zoom,t.object.left=this.left,t.object.right=this.right,t.object.top=this.top,t.object.bottom=this.bottom,t.object.near=this.near,t.object.far=this.far,null!==this.view&&(t.object.view=Object.assign({},this.view)),t}}class DirectionalLightShadow extends LightShadow{constructor(){super(new OrthographicCamera(-5,5,5,-5,.5,500)),this.isDirectionalLightShadow=!0}}class DirectionalLight extends Light{constructor(e,t){super(e,t),this.isDirectionalLight=!0,this.type="DirectionalLight",this.position.copy(Object3D.DEFAULT_UP),this.updateMatrix(),this.target=new Object3D,this.shadow=new DirectionalLightShadow}dispose(){this.shadow.dispose()}copy(e){return super.copy(e),this.target=e.target.clone(),this.shadow=e.shadow.clone(),this}}class AmbientLight extends Light{constructor(e,t){super(e,t),this.isAmbientLight=!0,this.type="AmbientLight"}}class RectAreaLight extends Light{constructor(e,t,r=10,n=10){super(e,t),this.isRectAreaLight=!0,this.type="RectAreaLight",this.width=r,this.height=n}get power(){return this.intensity*this.width*this.height*Math.PI}set power(e){this.intensity=e/(this.width*this.height*Math.PI)}copy(e){return super.copy(e),this.width=e.width,this.height=e.height,this}toJSON(e){const t=super.toJSON(e);return t.object.width=this.width,t.object.height=this.height,t}}class SphericalHarmonics3{constructor(){this.isSphericalHarmonics3=!0,this.coefficients=[];for(let e=0;e<9;e++)this.coefficients.push(new Vector3)}set(e){for(let t=0;t<9;t++)this.coefficients[t].copy(e[t]);return this}zero(){for(let e=0;e<9;e++)this.coefficients[e].set(0,0,0);return this}getAt(e,t){const r=e.x,n=e.y,i=e.z,a=this.coefficients;return t.copy(a[0]).multiplyScalar(.282095),t.addScaledVector(a[1],.488603*n),t.addScaledVector(a[2],.488603*i),t.addScaledVector(a[3],.488603*r),t.addScaledVector(a[4],r*n*1.092548),t.addScaledVector(a[5],n*i*1.092548),t.addScaledVector(a[6],.315392*(3*i*i-1)),t.addScaledVector(a[7],r*i*1.092548),t.addScaledVector(a[8],.546274*(r*r-n*n)),t}getIrradianceAt(e,t){const r=e.x,n=e.y,i=e.z,a=this.coefficients;return t.copy(a[0]).multiplyScalar(.886227),t.addScaledVector(a[1],1.023328*n),t.addScaledVector(a[2],1.023328*i),t.addScaledVector(a[3],1.023328*r),t.addScaledVector(a[4],.858086*r*n),t.addScaledVector(a[5],.858086*n*i),t.addScaledVector(a[6],.743125*i*i-.247708),t.addScaledVector(a[7],.858086*r*i),t.addScaledVector(a[8],.429043*(r*r-n*n)),t}add(e){for(let t=0;t<9;t++)this.coefficients[t].add(e.coefficients[t]);return this}addScaledSH(e,t){for(let r=0;r<9;r++)this.coefficients[r].addScaledVector(e.coefficients[r],t);return this}scale(e){for(let t=0;t<9;t++)this.coefficients[t].multiplyScalar(e);return this}lerp(e,t){for(let r=0;r<9;r++)this.coefficients[r].lerp(e.coefficients[r],t);return this}equals(e){for(let t=0;t<9;t++)if(!this.coefficients[t].equals(e.coefficients[t]))return!1;return!0}copy(e){return this.set(e.coefficients)}clone(){return(new this.constructor).copy(this)}fromArray(e,t=0){const r=this.coefficients;for(let n=0;n<9;n++)r[n].fromArray(e,t+3*n);return this}toArray(e=[],t=0){const r=this.coefficients;for(let n=0;n<9;n++)r[n].toArray(e,t+3*n);return e}static getBasisAt(e,t){const r=e.x,n=e.y,i=e.z;t[0]=.282095,t[1]=.488603*n,t[2]=.488603*i,t[3]=.488603*r,t[4]=1.092548*r*n,t[5]=1.092548*n*i,t[6]=.315392*(3*i*i-1),t[7]=1.092548*r*i,t[8]=.546274*(r*r-n*n)}}class LightProbe extends Light{constructor(e=new SphericalHarmonics3,t=1){super(void 0,t),this.isLightProbe=!0,this.sh=e}copy(e){return super.copy(e),this.sh.copy(e.sh),this}fromJSON(e){return this.intensity=e.intensity,this.sh.fromArray(e.sh),this}toJSON(e){const t=super.toJSON(e);return t.object.sh=this.sh.toArray(),t}}class MaterialLoader extends Loader{constructor(e){super(e),this.textures={}}load(e,t,r,n){const i=this,a=new FileLoader(i.manager);a.setPath(i.path),a.setRequestHeader(i.requestHeader),a.setWithCredentials(i.withCredentials),a.load(e,(function(r){try{t(i.parse(JSON.parse(r)))}catch(t){n?n(t):console.error(t),i.manager.itemError(e)}}),r,n)}parse(e){const t=this.textures;function r(e){return void 0===t[e]&&console.warn("THREE.MaterialLoader: Undefined texture",e),t[e]}const n=this.createMaterialFromType(e.type);if(void 0!==e.uuid&&(n.uuid=e.uuid),void 0!==e.name&&(n.name=e.name),void 0!==e.color&&void 0!==n.color&&n.color.setHex(e.color),void 0!==e.roughness&&(n.roughness=e.roughness),void 0!==e.metalness&&(n.metalness=e.metalness),void 0!==e.sheen&&(n.sheen=e.sheen),void 0!==e.sheenColor&&(n.sheenColor=(new Color).setHex(e.sheenColor)),void 0!==e.sheenRoughness&&(n.sheenRoughness=e.sheenRoughness),void 0!==e.emissive&&void 0!==n.emissive&&n.emissive.setHex(e.emissive),void 0!==e.specular&&void 0!==n.specular&&n.specular.setHex(e.specular),void 0!==e.specularIntensity&&(n.specularIntensity=e.specularIntensity),void 0!==e.specularColor&&void 0!==n.specularColor&&n.specularColor.setHex(e.specularColor),void 0!==e.shininess&&(n.shininess=e.shininess),void 0!==e.clearcoat&&(n.clearcoat=e.clearcoat),void 0!==e.clearcoatRoughness&&(n.clearcoatRoughness=e.clearcoatRoughness),void 0!==e.dispersion&&(n.dispersion=e.dispersion),void 0!==e.iridescence&&(n.iridescence=e.iridescence),void 0!==e.iridescenceIOR&&(n.iridescenceIOR=e.iridescenceIOR),void 0!==e.iridescenceThicknessRange&&(n.iridescenceThicknessRange=e.iridescenceThicknessRange),void 0!==e.transmission&&(n.transmission=e.transmission),void 0!==e.thickness&&(n.thickness=e.thickness),void 0!==e.attenuationDistance&&(n.attenuationDistance=e.attenuationDistance),void 0!==e.attenuationColor&&void 0!==n.attenuationColor&&n.attenuationColor.setHex(e.attenuationColor),void 0!==e.anisotropy&&(n.anisotropy=e.anisotropy),void 0!==e.anisotropyRotation&&(n.anisotropyRotation=e.anisotropyRotation),void 0!==e.fog&&(n.fog=e.fog),void 0!==e.flatShading&&(n.flatShading=e.flatShading),void 0!==e.blending&&(n.blending=e.blending),void 0!==e.combine&&(n.combine=e.combine),void 0!==e.side&&(n.side=e.side),void 0!==e.shadowSide&&(n.shadowSide=e.shadowSide),void 0!==e.opacity&&(n.opacity=e.opacity),void 0!==e.transparent&&(n.transparent=e.transparent),void 0!==e.alphaTest&&(n.alphaTest=e.alphaTest),void 0!==e.alphaHash&&(n.alphaHash=e.alphaHash),void 0!==e.depthFunc&&(n.depthFunc=e.depthFunc),void 0!==e.depthTest&&(n.depthTest=e.depthTest),void 0!==e.depthWrite&&(n.depthWrite=e.depthWrite),void 0!==e.colorWrite&&(n.colorWrite=e.colorWrite),void 0!==e.blendSrc&&(n.blendSrc=e.blendSrc),void 0!==e.blendDst&&(n.blendDst=e.blendDst),void 0!==e.blendEquation&&(n.blendEquation=e.blendEquation),void 0!==e.blendSrcAlpha&&(n.blendSrcAlpha=e.blendSrcAlpha),void 0!==e.blendDstAlpha&&(n.blendDstAlpha=e.blendDstAlpha),void 0!==e.blendEquationAlpha&&(n.blendEquationAlpha=e.blendEquationAlpha),void 0!==e.blendColor&&void 0!==n.blendColor&&n.blendColor.setHex(e.blendColor),void 0!==e.blendAlpha&&(n.blendAlpha=e.blendAlpha),void 0!==e.stencilWriteMask&&(n.stencilWriteMask=e.stencilWriteMask),void 0!==e.stencilFunc&&(n.stencilFunc=e.stencilFunc),void 0!==e.stencilRef&&(n.stencilRef=e.stencilRef),void 0!==e.stencilFuncMask&&(n.stencilFuncMask=e.stencilFuncMask),void 0!==e.stencilFail&&(n.stencilFail=e.stencilFail),void 0!==e.stencilZFail&&(n.stencilZFail=e.stencilZFail),void 0!==e.stencilZPass&&(n.stencilZPass=e.stencilZPass),void 0!==e.stencilWrite&&(n.stencilWrite=e.stencilWrite),void 0!==e.wireframe&&(n.wireframe=e.wireframe),void 0!==e.wireframeLinewidth&&(n.wireframeLinewidth=e.wireframeLinewidth),void 0!==e.wireframeLinecap&&(n.wireframeLinecap=e.wireframeLinecap),void 0!==e.wireframeLinejoin&&(n.wireframeLinejoin=e.wireframeLinejoin),void 0!==e.rotation&&(n.rotation=e.rotation),void 0!==e.linewidth&&(n.linewidth=e.linewidth),void 0!==e.dashSize&&(n.dashSize=e.dashSize),void 0!==e.gapSize&&(n.gapSize=e.gapSize),void 0!==e.scale&&(n.scale=e.scale),void 0!==e.polygonOffset&&(n.polygonOffset=e.polygonOffset),void 0!==e.polygonOffsetFactor&&(n.polygonOffsetFactor=e.polygonOffsetFactor),void 0!==e.polygonOffsetUnits&&(n.polygonOffsetUnits=e.polygonOffsetUnits),void 0!==e.dithering&&(n.dithering=e.dithering),void 0!==e.alphaToCoverage&&(n.alphaToCoverage=e.alphaToCoverage),void 0!==e.premultipliedAlpha&&(n.premultipliedAlpha=e.premultipliedAlpha),void 0!==e.forceSinglePass&&(n.forceSinglePass=e.forceSinglePass),void 0!==e.visible&&(n.visible=e.visible),void 0!==e.toneMapped&&(n.toneMapped=e.toneMapped),void 0!==e.userData&&(n.userData=e.userData),void 0!==e.vertexColors&&("number"==typeof e.vertexColors?n.vertexColors=e.vertexColors>0:n.vertexColors=e.vertexColors),void 0!==e.uniforms)for(const t in e.uniforms){const i=e.uniforms[t];switch(n.uniforms[t]={},i.type){case"t":n.uniforms[t].value=r(i.value);break;case"c":n.uniforms[t].value=(new Color).setHex(i.value);break;case"v2":n.uniforms[t].value=(new Vector2).fromArray(i.value);break;case"v3":n.uniforms[t].value=(new Vector3).fromArray(i.value);break;case"v4":n.uniforms[t].value=(new Vector4).fromArray(i.value);break;case"m3":n.uniforms[t].value=(new Matrix3).fromArray(i.value);break;case"m4":n.uniforms[t].value=(new Matrix4).fromArray(i.value);break;default:n.uniforms[t].value=i.value}}if(void 0!==e.defines&&(n.defines=e.defines),void 0!==e.vertexShader&&(n.vertexShader=e.vertexShader),void 0!==e.fragmentShader&&(n.fragmentShader=e.fragmentShader),void 0!==e.glslVersion&&(n.glslVersion=e.glslVersion),void 0!==e.extensions)for(const t in e.extensions)n.extensions[t]=e.extensions[t];if(void 0!==e.lights&&(n.lights=e.lights),void 0!==e.clipping&&(n.clipping=e.clipping),void 0!==e.size&&(n.size=e.size),void 0!==e.sizeAttenuation&&(n.sizeAttenuation=e.sizeAttenuation),void 0!==e.map&&(n.map=r(e.map)),void 0!==e.matcap&&(n.matcap=r(e.matcap)),void 0!==e.alphaMap&&(n.alphaMap=r(e.alphaMap)),void 0!==e.bumpMap&&(n.bumpMap=r(e.bumpMap)),void 0!==e.bumpScale&&(n.bumpScale=e.bumpScale),void 0!==e.normalMap&&(n.normalMap=r(e.normalMap)),void 0!==e.normalMapType&&(n.normalMapType=e.normalMapType),void 0!==e.normalScale){let t=e.normalScale;!1===Array.isArray(t)&&(t=[t,t]),n.normalScale=(new Vector2).fromArray(t)}return void 0!==e.displacementMap&&(n.displacementMap=r(e.displacementMap)),void 0!==e.displacementScale&&(n.displacementScale=e.displacementScale),void 0!==e.displacementBias&&(n.displacementBias=e.displacementBias),void 0!==e.roughnessMap&&(n.roughnessMap=r(e.roughnessMap)),void 0!==e.metalnessMap&&(n.metalnessMap=r(e.metalnessMap)),void 0!==e.emissiveMap&&(n.emissiveMap=r(e.emissiveMap)),void 0!==e.emissiveIntensity&&(n.emissiveIntensity=e.emissiveIntensity),void 0!==e.specularMap&&(n.specularMap=r(e.specularMap)),void 0!==e.specularIntensityMap&&(n.specularIntensityMap=r(e.specularIntensityMap)),void 0!==e.specularColorMap&&(n.specularColorMap=r(e.specularColorMap)),void 0!==e.envMap&&(n.envMap=r(e.envMap)),void 0!==e.envMapRotation&&n.envMapRotation.fromArray(e.envMapRotation),void 0!==e.envMapIntensity&&(n.envMapIntensity=e.envMapIntensity),void 0!==e.reflectivity&&(n.reflectivity=e.reflectivity),void 0!==e.refractionRatio&&(n.refractionRatio=e.refractionRatio),void 0!==e.lightMap&&(n.lightMap=r(e.lightMap)),void 0!==e.lightMapIntensity&&(n.lightMapIntensity=e.lightMapIntensity),void 0!==e.aoMap&&(n.aoMap=r(e.aoMap)),void 0!==e.aoMapIntensity&&(n.aoMapIntensity=e.aoMapIntensity),void 0!==e.gradientMap&&(n.gradientMap=r(e.gradientMap)),void 0!==e.clearcoatMap&&(n.clearcoatMap=r(e.clearcoatMap)),void 0!==e.clearcoatRoughnessMap&&(n.clearcoatRoughnessMap=r(e.clearcoatRoughnessMap)),void 0!==e.clearcoatNormalMap&&(n.clearcoatNormalMap=r(e.clearcoatNormalMap)),void 0!==e.clearcoatNormalScale&&(n.clearcoatNormalScale=(new Vector2).fromArray(e.clearcoatNormalScale)),void 0!==e.iridescenceMap&&(n.iridescenceMap=r(e.iridescenceMap)),void 0!==e.iridescenceThicknessMap&&(n.iridescenceThicknessMap=r(e.iridescenceThicknessMap)),void 0!==e.transmissionMap&&(n.transmissionMap=r(e.transmissionMap)),void 0!==e.thicknessMap&&(n.thicknessMap=r(e.thicknessMap)),void 0!==e.anisotropyMap&&(n.anisotropyMap=r(e.anisotropyMap)),void 0!==e.sheenColorMap&&(n.sheenColorMap=r(e.sheenColorMap)),void 0!==e.sheenRoughnessMap&&(n.sheenRoughnessMap=r(e.sheenRoughnessMap)),n}setTextures(e){return this.textures=e,this}createMaterialFromType(e){return MaterialLoader.createMaterialFromType(e)}static createMaterialFromType(e){return new{ShadowMaterial,SpriteMaterial,RawShaderMaterial,ShaderMaterial,PointsMaterial,MeshPhysicalMaterial,MeshStandardMaterial,MeshPhongMaterial,MeshToonMaterial,MeshNormalMaterial,MeshLambertMaterial,MeshDepthMaterial,MeshDistanceMaterial,MeshBasicMaterial,MeshMatcapMaterial,LineDashedMaterial,LineBasicMaterial,Material}[e]}}class LoaderUtils{static extractUrlBase(e){const t=e.lastIndexOf("/");return-1===t?"./":e.slice(0,t+1)}static resolveURL(e,t){return"string"!=typeof e||""===e?"":(/^https?:\/\//i.test(t)&&/^\//.test(e)&&(t=t.replace(/(^https?:\/\/[^\/]+).*/i,"$1")),/^(https?:)?\/\//i.test(e)||/^data:.*,.*$/i.test(e)||/^blob:.*$/i.test(e)?e:t+e)}}class InstancedBufferGeometry extends BufferGeometry{constructor(){super(),this.isInstancedBufferGeometry=!0,this.type="InstancedBufferGeometry",this.instanceCount=1/0}copy(e){return super.copy(e),this.instanceCount=e.instanceCount,this}toJSON(){const e=super.toJSON();return e.instanceCount=this.instanceCount,e.isInstancedBufferGeometry=!0,e}}class BufferGeometryLoader extends Loader{constructor(e){super(e)}load(e,t,r,n){const i=this,a=new FileLoader(i.manager);a.setPath(i.path),a.setRequestHeader(i.requestHeader),a.setWithCredentials(i.withCredentials),a.load(e,(function(r){try{t(i.parse(JSON.parse(r)))}catch(t){n?n(t):console.error(t),i.manager.itemError(e)}}),r,n)}parse(e){const t={},r={};function n(e,n){if(void 0!==t[n])return t[n];const i=e.interleavedBuffers[n],a=function(e,t){if(void 0!==r[t])return r[t];const n=e.arrayBuffers,i=n[t],a=new Uint32Array(i).buffer;return r[t]=a,a}(e,i.buffer),s=getTypedArray(i.type,a),o=new InterleavedBuffer(s,i.stride);return o.uuid=i.uuid,t[n]=o,o}const i=e.isInstancedBufferGeometry?new InstancedBufferGeometry:new BufferGeometry,a=e.data.index;if(void 0!==a){const e=getTypedArray(a.type,a.array);i.setIndex(new BufferAttribute(e,1))}const s=e.data.attributes;for(const t in s){const r=s[t];let a;if(r.isInterleavedBufferAttribute){const t=n(e.data,r.data);a=new InterleavedBufferAttribute(t,r.itemSize,r.offset,r.normalized)}else{const e=getTypedArray(r.type,r.array);a=new(r.isInstancedBufferAttribute?InstancedBufferAttribute:BufferAttribute)(e,r.itemSize,r.normalized)}void 0!==r.name&&(a.name=r.name),void 0!==r.usage&&a.setUsage(r.usage),i.setAttribute(t,a)}const o=e.data.morphAttributes;if(o)for(const t in o){const r=o[t],a=[];for(let t=0,i=r.length;t<i;t++){const i=r[t];let s;if(i.isInterleavedBufferAttribute){const t=n(e.data,i.data);s=new InterleavedBufferAttribute(t,i.itemSize,i.offset,i.normalized)}else{const e=getTypedArray(i.type,i.array);s=new BufferAttribute(e,i.itemSize,i.normalized)}void 0!==i.name&&(s.name=i.name),a.push(s)}i.morphAttributes[t]=a}e.data.morphTargetsRelative&&(i.morphTargetsRelative=!0);const l=e.data.groups||e.data.drawcalls||e.data.offsets;if(void 0!==l)for(let e=0,t=l.length;e!==t;++e){const t=l[e];i.addGroup(t.start,t.count,t.materialIndex)}const c=e.data.boundingSphere;if(void 0!==c){const e=new Vector3;void 0!==c.center&&e.fromArray(c.center),i.boundingSphere=new Sphere(e,c.radius)}return e.name&&(i.name=e.name),e.userData&&(i.userData=e.userData),i}}class ObjectLoader extends Loader{constructor(e){super(e)}load(e,t,r,n){const i=this,a=""===this.path?LoaderUtils.extractUrlBase(e):this.path;this.resourcePath=this.resourcePath||a;const s=new FileLoader(this.manager);s.setPath(this.path),s.setRequestHeader(this.requestHeader),s.setWithCredentials(this.withCredentials),s.load(e,(function(r){let a=null;try{a=JSON.parse(r)}catch(t){return void 0!==n&&n(t),void console.error("THREE:ObjectLoader: Can't parse "+e+".",t.message)}const s=a.metadata;if(void 0===s||void 0===s.type||"geometry"===s.type.toLowerCase())return void 0!==n&&n(new Error("THREE.ObjectLoader: Can't load "+e)),void console.error("THREE.ObjectLoader: Can't load "+e);i.parse(a,t)}),r,n)}async loadAsync(e,t){const r=""===this.path?LoaderUtils.extractUrlBase(e):this.path;this.resourcePath=this.resourcePath||r;const n=new FileLoader(this.manager);n.setPath(this.path),n.setRequestHeader(this.requestHeader),n.setWithCredentials(this.withCredentials);const i=await n.loadAsync(e,t),a=JSON.parse(i),s=a.metadata;if(void 0===s||void 0===s.type||"geometry"===s.type.toLowerCase())throw new Error("THREE.ObjectLoader: Can't load "+e);return await this.parseAsync(a)}parse(e,t){const r=this.parseAnimations(e.animations),n=this.parseShapes(e.shapes),i=this.parseGeometries(e.geometries,n),a=this.parseImages(e.images,(function(){void 0!==t&&t(l)})),s=this.parseTextures(e.textures,a),o=this.parseMaterials(e.materials,s),l=this.parseObject(e.object,i,o,s,r),c=this.parseSkeletons(e.skeletons,l);if(this.bindSkeletons(l,c),this.bindLightTargets(l),void 0!==t){let e=!1;for(const t in a)if(a[t].data instanceof HTMLImageElement){e=!0;break}!1===e&&t(l)}return l}async parseAsync(e){const t=this.parseAnimations(e.animations),r=this.parseShapes(e.shapes),n=this.parseGeometries(e.geometries,r),i=await this.parseImagesAsync(e.images),a=this.parseTextures(e.textures,i),s=this.parseMaterials(e.materials,a),o=this.parseObject(e.object,n,s,a,t),l=this.parseSkeletons(e.skeletons,o);return this.bindSkeletons(o,l),this.bindLightTargets(o),o}parseShapes(e){const t={};if(void 0!==e)for(let r=0,n=e.length;r<n;r++){const n=(new Shape).fromJSON(e[r]);t[n.uuid]=n}return t}parseSkeletons(e,t){const r={},n={};if(t.traverse((function(e){e.isBone&&(n[e.uuid]=e)})),void 0!==e)for(let t=0,i=e.length;t<i;t++){const i=(new Skeleton).fromJSON(e[t],n);r[i.uuid]=i}return r}parseGeometries(e,t){const r={};if(void 0!==e){const n=new BufferGeometryLoader;for(let i=0,a=e.length;i<a;i++){let a;const s=e[i];switch(s.type){case"BufferGeometry":case"InstancedBufferGeometry":a=n.parse(s);break;default:s.type in Geometries?a=Geometries[s.type].fromJSON(s,t):console.warn(`THREE.ObjectLoader: Unsupported geometry type "${s.type}"`)}a.uuid=s.uuid,void 0!==s.name&&(a.name=s.name),void 0!==s.userData&&(a.userData=s.userData),r[s.uuid]=a}}return r}parseMaterials(e,t){const r={},n={};if(void 0!==e){const i=new MaterialLoader;i.setTextures(t);for(let t=0,a=e.length;t<a;t++){const a=e[t];void 0===r[a.uuid]&&(r[a.uuid]=i.parse(a)),n[a.uuid]=r[a.uuid]}}return n}parseAnimations(e){const t={};if(void 0!==e)for(let r=0;r<e.length;r++){const n=e[r],i=AnimationClip.parse(n);t[i.uuid]=i}return t}parseImages(e,t){const r=this,n={};let i;function a(e){if("string"==typeof e){const t=e;return function(e){return r.manager.itemStart(e),i.load(e,(function(){r.manager.itemEnd(e)}),void 0,(function(){r.manager.itemError(e),r.manager.itemEnd(e)}))}(/^(\/\/)|([a-z]+:(\/\/)?)/i.test(t)?t:r.resourcePath+t)}return e.data?{data:getTypedArray(e.type,e.data),width:e.width,height:e.height}:null}if(void 0!==e&&e.length>0){const r=new LoadingManager(t);i=new ImageLoader(r),i.setCrossOrigin(this.crossOrigin);for(let t=0,r=e.length;t<r;t++){const r=e[t],i=r.url;if(Array.isArray(i)){const e=[];for(let t=0,r=i.length;t<r;t++){const r=a(i[t]);null!==r&&(r instanceof HTMLImageElement?e.push(r):e.push(new DataTexture(r.data,r.width,r.height)))}n[r.uuid]=new Source(e)}else{const e=a(r.url);n[r.uuid]=new Source(e)}}}return n}async parseImagesAsync(e){const t=this,r={};let n;async function i(e){if("string"==typeof e){const r=e,i=/^(\/\/)|([a-z]+:(\/\/)?)/i.test(r)?r:t.resourcePath+r;return await n.loadAsync(i)}return e.data?{data:getTypedArray(e.type,e.data),width:e.width,height:e.height}:null}if(void 0!==e&&e.length>0){n=new ImageLoader(this.manager),n.setCrossOrigin(this.crossOrigin);for(let t=0,n=e.length;t<n;t++){const n=e[t],a=n.url;if(Array.isArray(a)){const e=[];for(let t=0,r=a.length;t<r;t++){const r=a[t],n=await i(r);null!==n&&(n instanceof HTMLImageElement?e.push(n):e.push(new DataTexture(n.data,n.width,n.height)))}r[n.uuid]=new Source(e)}else{const e=await i(n.url);r[n.uuid]=new Source(e)}}}return r}parseTextures(e,t){function r(e,t){return"number"==typeof e?e:(console.warn("THREE.ObjectLoader.parseTexture: Constant should be in numeric form.",e),t[e])}const n={};if(void 0!==e)for(let i=0,a=e.length;i<a;i++){const a=e[i];void 0===a.image&&console.warn('THREE.ObjectLoader: No "image" specified for',a.uuid),void 0===t[a.image]&&console.warn("THREE.ObjectLoader: Undefined image",a.image);const s=t[a.image],o=s.data;let l;Array.isArray(o)?(l=new CubeTexture,6===o.length&&(l.needsUpdate=!0)):(l=o&&o.data?new DataTexture:new Texture,o&&(l.needsUpdate=!0)),l.source=s,l.uuid=a.uuid,void 0!==a.name&&(l.name=a.name),void 0!==a.mapping&&(l.mapping=r(a.mapping,TEXTURE_MAPPING)),void 0!==a.channel&&(l.channel=a.channel),void 0!==a.offset&&l.offset.fromArray(a.offset),void 0!==a.repeat&&l.repeat.fromArray(a.repeat),void 0!==a.center&&l.center.fromArray(a.center),void 0!==a.rotation&&(l.rotation=a.rotation),void 0!==a.wrap&&(l.wrapS=r(a.wrap[0],TEXTURE_WRAPPING),l.wrapT=r(a.wrap[1],TEXTURE_WRAPPING)),void 0!==a.format&&(l.format=a.format),void 0!==a.internalFormat&&(l.internalFormat=a.internalFormat),void 0!==a.type&&(l.type=a.type),void 0!==a.colorSpace&&(l.colorSpace=a.colorSpace),void 0!==a.minFilter&&(l.minFilter=r(a.minFilter,TEXTURE_FILTER)),void 0!==a.magFilter&&(l.magFilter=r(a.magFilter,TEXTURE_FILTER)),void 0!==a.anisotropy&&(l.anisotropy=a.anisotropy),void 0!==a.flipY&&(l.flipY=a.flipY),void 0!==a.generateMipmaps&&(l.generateMipmaps=a.generateMipmaps),void 0!==a.premultiplyAlpha&&(l.premultiplyAlpha=a.premultiplyAlpha),void 0!==a.unpackAlignment&&(l.unpackAlignment=a.unpackAlignment),void 0!==a.compareFunction&&(l.compareFunction=a.compareFunction),void 0!==a.userData&&(l.userData=a.userData),n[a.uuid]=l}return n}parseObject(e,t,r,n,i){let a,s,o;function l(e){return void 0===t[e]&&console.warn("THREE.ObjectLoader: Undefined geometry",e),t[e]}function c(e){if(void 0!==e){if(Array.isArray(e)){const t=[];for(let n=0,i=e.length;n<i;n++){const i=e[n];void 0===r[i]&&console.warn("THREE.ObjectLoader: Undefined material",i),t.push(r[i])}return t}return void 0===r[e]&&console.warn("THREE.ObjectLoader: Undefined material",e),r[e]}}function h(e){return void 0===n[e]&&console.warn("THREE.ObjectLoader: Undefined texture",e),n[e]}switch(e.type){case"Scene":a=new Scene,void 0!==e.background&&(Number.isInteger(e.background)?a.background=new Color(e.background):a.background=h(e.background)),void 0!==e.environment&&(a.environment=h(e.environment)),void 0!==e.fog&&("Fog"===e.fog.type?a.fog=new Fog(e.fog.color,e.fog.near,e.fog.far):"FogExp2"===e.fog.type&&(a.fog=new FogExp2(e.fog.color,e.fog.density)),""!==e.fog.name&&(a.fog.name=e.fog.name)),void 0!==e.backgroundBlurriness&&(a.backgroundBlurriness=e.backgroundBlurriness),void 0!==e.backgroundIntensity&&(a.backgroundIntensity=e.backgroundIntensity),void 0!==e.backgroundRotation&&a.backgroundRotation.fromArray(e.backgroundRotation),void 0!==e.environmentIntensity&&(a.environmentIntensity=e.environmentIntensity),void 0!==e.environmentRotation&&a.environmentRotation.fromArray(e.environmentRotation);break;case"PerspectiveCamera":a=new PerspectiveCamera(e.fov,e.aspect,e.near,e.far),void 0!==e.focus&&(a.focus=e.focus),void 0!==e.zoom&&(a.zoom=e.zoom),void 0!==e.filmGauge&&(a.filmGauge=e.filmGauge),void 0!==e.filmOffset&&(a.filmOffset=e.filmOffset),void 0!==e.view&&(a.view=Object.assign({},e.view));break;case"OrthographicCamera":a=new OrthographicCamera(e.left,e.right,e.top,e.bottom,e.near,e.far),void 0!==e.zoom&&(a.zoom=e.zoom),void 0!==e.view&&(a.view=Object.assign({},e.view));break;case"AmbientLight":a=new AmbientLight(e.color,e.intensity);break;case"DirectionalLight":a=new DirectionalLight(e.color,e.intensity),a.target=e.target||"";break;case"PointLight":a=new PointLight(e.color,e.intensity,e.distance,e.decay);break;case"RectAreaLight":a=new RectAreaLight(e.color,e.intensity,e.width,e.height);break;case"SpotLight":a=new SpotLight(e.color,e.intensity,e.distance,e.angle,e.penumbra,e.decay),a.target=e.target||"";break;case"HemisphereLight":a=new HemisphereLight(e.color,e.groundColor,e.intensity);break;case"LightProbe":a=(new LightProbe).fromJSON(e);break;case"SkinnedMesh":s=l(e.geometry),o=c(e.material),a=new SkinnedMesh(s,o),void 0!==e.bindMode&&(a.bindMode=e.bindMode),void 0!==e.bindMatrix&&a.bindMatrix.fromArray(e.bindMatrix),void 0!==e.skeleton&&(a.skeleton=e.skeleton);break;case"Mesh":s=l(e.geometry),o=c(e.material),a=new Mesh(s,o);break;case"InstancedMesh":s=l(e.geometry),o=c(e.material);const t=e.count,r=e.instanceMatrix,n=e.instanceColor;a=new InstancedMesh(s,o,t),a.instanceMatrix=new InstancedBufferAttribute(new Float32Array(r.array),16),void 0!==n&&(a.instanceColor=new InstancedBufferAttribute(new Float32Array(n.array),n.itemSize));break;case"BatchedMesh":s=l(e.geometry),o=c(e.material),a=new BatchedMesh(e.maxInstanceCount,e.maxVertexCount,e.maxIndexCount,o),a.geometry=s,a.perObjectFrustumCulled=e.perObjectFrustumCulled,a.sortObjects=e.sortObjects,a._drawRanges=e.drawRanges,a._reservedRanges=e.reservedRanges,a._geometryInfo=e.geometryInfo.map((e=>{let t=null,r=null;return void 0!==e.boundingBox&&(t=new Box3,t.min.fromArray(e.boundingBox.min),t.max.fromArray(e.boundingBox.max)),void 0!==e.boundingSphere&&(r=new Sphere,r.radius=e.boundingSphere.radius,r.center.fromArray(e.boundingSphere.center)),{...e,boundingBox:t,boundingSphere:r}})),a._instanceInfo=e.instanceInfo,a._availableInstanceIds=e._availableInstanceIds,a._availableGeometryIds=e._availableGeometryIds,a._nextIndexStart=e.nextIndexStart,a._nextVertexStart=e.nextVertexStart,a._geometryCount=e.geometryCount,a._maxInstanceCount=e.maxInstanceCount,a._maxVertexCount=e.maxVertexCount,a._maxIndexCount=e.maxIndexCount,a._geometryInitialized=e.geometryInitialized,a._matricesTexture=h(e.matricesTexture.uuid),a._indirectTexture=h(e.indirectTexture.uuid),void 0!==e.colorsTexture&&(a._colorsTexture=h(e.colorsTexture.uuid)),void 0!==e.boundingSphere&&(a.boundingSphere=new Sphere,a.boundingSphere.center.fromArray(e.boundingSphere.center),a.boundingSphere.radius=e.boundingSphere.radius),void 0!==e.boundingBox&&(a.boundingBox=new Box3,a.boundingBox.min.fromArray(e.boundingBox.min),a.boundingBox.max.fromArray(e.boundingBox.max));break;case"LOD":a=new LOD;break;case"Line":a=new Line(l(e.geometry),c(e.material));break;case"LineLoop":a=new LineLoop(l(e.geometry),c(e.material));break;case"LineSegments":a=new LineSegments(l(e.geometry),c(e.material));break;case"PointCloud":case"Points":a=new Points(l(e.geometry),c(e.material));break;case"Sprite":a=new Sprite(c(e.material));break;case"Group":a=new Group;break;case"Bone":a=new Bone;break;default:a=new Object3D}if(a.uuid=e.uuid,void 0!==e.name&&(a.name=e.name),void 0!==e.matrix?(a.matrix.fromArray(e.matrix),void 0!==e.matrixAutoUpdate&&(a.matrixAutoUpdate=e.matrixAutoUpdate),a.matrixAutoUpdate&&a.matrix.decompose(a.position,a.quaternion,a.scale)):(void 0!==e.position&&a.position.fromArray(e.position),void 0!==e.rotation&&a.rotation.fromArray(e.rotation),void 0!==e.quaternion&&a.quaternion.fromArray(e.quaternion),void 0!==e.scale&&a.scale.fromArray(e.scale)),void 0!==e.up&&a.up.fromArray(e.up),void 0!==e.castShadow&&(a.castShadow=e.castShadow),void 0!==e.receiveShadow&&(a.receiveShadow=e.receiveShadow),e.shadow&&(void 0!==e.shadow.intensity&&(a.shadow.intensity=e.shadow.intensity),void 0!==e.shadow.bias&&(a.shadow.bias=e.shadow.bias),void 0!==e.shadow.normalBias&&(a.shadow.normalBias=e.shadow.normalBias),void 0!==e.shadow.radius&&(a.shadow.radius=e.shadow.radius),void 0!==e.shadow.mapSize&&a.shadow.mapSize.fromArray(e.shadow.mapSize),void 0!==e.shadow.camera&&(a.shadow.camera=this.parseObject(e.shadow.camera))),void 0!==e.visible&&(a.visible=e.visible),void 0!==e.frustumCulled&&(a.frustumCulled=e.frustumCulled),void 0!==e.renderOrder&&(a.renderOrder=e.renderOrder),void 0!==e.userData&&(a.userData=e.userData),void 0!==e.layers&&(a.layers.mask=e.layers),void 0!==e.children){const s=e.children;for(let e=0;e<s.length;e++)a.add(this.parseObject(s[e],t,r,n,i))}if(void 0!==e.animations){const t=e.animations;for(let e=0;e<t.length;e++){const r=t[e];a.animations.push(i[r])}}if("LOD"===e.type){void 0!==e.autoUpdate&&(a.autoUpdate=e.autoUpdate);const t=e.levels;for(let e=0;e<t.length;e++){const r=t[e],n=a.getObjectByProperty("uuid",r.object);void 0!==n&&a.addLevel(n,r.distance,r.hysteresis)}}return a}bindSkeletons(e,t){0!==Object.keys(t).length&&e.traverse((function(e){if(!0===e.isSkinnedMesh&&void 0!==e.skeleton){const r=t[e.skeleton];void 0===r?console.warn("THREE.ObjectLoader: No skeleton found with UUID:",e.skeleton):e.bind(r,e.bindMatrix)}}))}bindLightTargets(e){e.traverse((function(t){if(t.isDirectionalLight||t.isSpotLight){const r=t.target,n=e.getObjectByProperty("uuid",r);t.target=void 0!==n?n:new Object3D}}))}}const TEXTURE_MAPPING={UVMapping:300,CubeReflectionMapping:301,CubeRefractionMapping:302,EquirectangularReflectionMapping:303,EquirectangularRefractionMapping:304,CubeUVReflectionMapping:306},TEXTURE_WRAPPING={RepeatWrapping:1e3,ClampToEdgeWrapping:1001,MirroredRepeatWrapping:1002},TEXTURE_FILTER={NearestFilter:1003,NearestMipmapNearestFilter:1004,NearestMipmapLinearFilter:1005,LinearFilter:1006,LinearMipmapNearestFilter:1007,LinearMipmapLinearFilter:1008};class ImageBitmapLoader extends Loader{constructor(e){super(e),this.isImageBitmapLoader=!0,"undefined"==typeof createImageBitmap&&console.warn("THREE.ImageBitmapLoader: createImageBitmap() not supported."),"undefined"==typeof fetch&&console.warn("THREE.ImageBitmapLoader: fetch() not supported."),this.options={premultiplyAlpha:"none"}}setOptions(e){return this.options=e,this}load(e,t,r,n){void 0===e&&(e=""),void 0!==this.path&&(e=this.path+e),e=this.manager.resolveURL(e);const i=this,a=Cache.get(e);if(void 0!==a)return i.manager.itemStart(e),a.then?void a.then((r=>{t&&t(r),i.manager.itemEnd(e)})).catch((e=>{n&&n(e)})):(setTimeout((function(){t&&t(a),i.manager.itemEnd(e)}),0),a);const s={};s.credentials="anonymous"===this.crossOrigin?"same-origin":"include",s.headers=this.requestHeader;const o=fetch(e,s).then((function(e){return e.blob()})).then((function(e){return createImageBitmap(e,Object.assign(i.options,{colorSpaceConversion:"none"}))})).then((function(r){return Cache.add(e,r),t&&t(r),i.manager.itemEnd(e),r})).catch((function(t){n&&n(t),Cache.remove(e),i.manager.itemError(e),i.manager.itemEnd(e)}));Cache.add(e,o),i.manager.itemStart(e)}}let _context;class AudioContext{static getContext(){return void 0===_context&&(_context=new(window.AudioContext||window.webkitAudioContext)),_context}static setContext(e){_context=e}}class AudioLoader extends Loader{constructor(e){super(e)}load(e,t,r,n){const i=this,a=new FileLoader(this.manager);function s(t){n?n(t):console.error(t),i.manager.itemError(e)}a.setResponseType("arraybuffer"),a.setPath(this.path),a.setRequestHeader(this.requestHeader),a.setWithCredentials(this.withCredentials),a.load(e,(function(e){try{const r=e.slice(0);AudioContext.getContext().decodeAudioData(r,(function(e){t(e)})).catch(s)}catch(e){s(e)}}),r,n)}}const _eyeRight=new Matrix4,_eyeLeft=new Matrix4,_projectionMatrix=new Matrix4;class StereoCamera{constructor(){this.type="StereoCamera",this.aspect=1,this.eyeSep=.064,this.cameraL=new PerspectiveCamera,this.cameraL.layers.enable(1),this.cameraL.matrixAutoUpdate=!1,this.cameraR=new PerspectiveCamera,this.cameraR.layers.enable(2),this.cameraR.matrixAutoUpdate=!1,this._cache={focus:null,fov:null,aspect:null,near:null,far:null,zoom:null,eyeSep:null}}update(e){const t=this._cache;if(t.focus!==e.focus||t.fov!==e.fov||t.aspect!==e.aspect*this.aspect||t.near!==e.near||t.far!==e.far||t.zoom!==e.zoom||t.eyeSep!==this.eyeSep){t.focus=e.focus,t.fov=e.fov,t.aspect=e.aspect*this.aspect,t.near=e.near,t.far=e.far,t.zoom=e.zoom,t.eyeSep=this.eyeSep,_projectionMatrix.copy(e.projectionMatrix);const r=t.eyeSep/2,n=r*t.near/t.focus,i=t.near*Math.tan(DEG2RAD*t.fov*.5)/t.zoom;let a,s;_eyeLeft.elements[12]=-r,_eyeRight.elements[12]=r,a=-i*t.aspect+n,s=i*t.aspect+n,_projectionMatrix.elements[0]=2*t.near/(s-a),_projectionMatrix.elements[8]=(s+a)/(s-a),this.cameraL.projectionMatrix.copy(_projectionMatrix),a=-i*t.aspect-n,s=i*t.aspect-n,_projectionMatrix.elements[0]=2*t.near/(s-a),_projectionMatrix.elements[8]=(s+a)/(s-a),this.cameraR.projectionMatrix.copy(_projectionMatrix)}this.cameraL.matrixWorld.copy(e.matrixWorld).multiply(_eyeLeft),this.cameraR.matrixWorld.copy(e.matrixWorld).multiply(_eyeRight)}}class ArrayCamera extends PerspectiveCamera{constructor(e=[]){super(),this.isArrayCamera=!0,this.isMultiViewCamera=!1,this.cameras=e}}class Clock{constructor(e=!0){this.autoStart=e,this.startTime=0,this.oldTime=0,this.elapsedTime=0,this.running=!1}start(){this.startTime=now(),this.oldTime=this.startTime,this.elapsedTime=0,this.running=!0}stop(){this.getElapsedTime(),this.running=!1,this.autoStart=!1}getElapsedTime(){return this.getDelta(),this.elapsedTime}getDelta(){let e=0;if(this.autoStart&&!this.running)return this.start(),0;if(this.running){const t=now();e=(t-this.oldTime)/1e3,this.oldTime=t,this.elapsedTime+=e}return e}}function now(){return performance.now()}const _position$1=new Vector3,_quaternion$1=new Quaternion,_scale$1=new Vector3,_orientation$1=new Vector3;class AudioListener extends Object3D{constructor(){super(),this.type="AudioListener",this.context=AudioContext.getContext(),this.gain=this.context.createGain(),this.gain.connect(this.context.destination),this.filter=null,this.timeDelta=0,this._clock=new Clock}getInput(){return this.gain}removeFilter(){return null!==this.filter&&(this.gain.disconnect(this.filter),this.filter.disconnect(this.context.destination),this.gain.connect(this.context.destination),this.filter=null),this}getFilter(){return this.filter}setFilter(e){return null!==this.filter?(this.gain.disconnect(this.filter),this.filter.disconnect(this.context.destination)):this.gain.disconnect(this.context.destination),this.filter=e,this.gain.connect(this.filter),this.filter.connect(this.context.destination),this}getMasterVolume(){return this.gain.gain.value}setMasterVolume(e){return this.gain.gain.setTargetAtTime(e,this.context.currentTime,.01),this}updateMatrixWorld(e){super.updateMatrixWorld(e);const t=this.context.listener,r=this.up;if(this.timeDelta=this._clock.getDelta(),this.matrixWorld.decompose(_position$1,_quaternion$1,_scale$1),_orientation$1.set(0,0,-1).applyQuaternion(_quaternion$1),t.positionX){const e=this.context.currentTime+this.timeDelta;t.positionX.linearRampToValueAtTime(_position$1.x,e),t.positionY.linearRampToValueAtTime(_position$1.y,e),t.positionZ.linearRampToValueAtTime(_position$1.z,e),t.forwardX.linearRampToValueAtTime(_orientation$1.x,e),t.forwardY.linearRampToValueAtTime(_orientation$1.y,e),t.forwardZ.linearRampToValueAtTime(_orientation$1.z,e),t.upX.linearRampToValueAtTime(r.x,e),t.upY.linearRampToValueAtTime(r.y,e),t.upZ.linearRampToValueAtTime(r.z,e)}else t.setPosition(_position$1.x,_position$1.y,_position$1.z),t.setOrientation(_orientation$1.x,_orientation$1.y,_orientation$1.z,r.x,r.y,r.z)}}class Audio extends Object3D{constructor(e){super(),this.type="Audio",this.listener=e,this.context=e.context,this.gain=this.context.createGain(),this.gain.connect(e.getInput()),this.autoplay=!1,this.buffer=null,this.detune=0,this.loop=!1,this.loopStart=0,this.loopEnd=0,this.offset=0,this.duration=void 0,this.playbackRate=1,this.isPlaying=!1,this.hasPlaybackControl=!0,this.source=null,this.sourceType="empty",this._startedAt=0,this._progress=0,this._connected=!1,this.filters=[]}getOutput(){return this.gain}setNodeSource(e){return this.hasPlaybackControl=!1,this.sourceType="audioNode",this.source=e,this.connect(),this}setMediaElementSource(e){return this.hasPlaybackControl=!1,this.sourceType="mediaNode",this.source=this.context.createMediaElementSource(e),this.connect(),this}setMediaStreamSource(e){return this.hasPlaybackControl=!1,this.sourceType="mediaStreamNode",this.source=this.context.createMediaStreamSource(e),this.connect(),this}setBuffer(e){return this.buffer=e,this.sourceType="buffer",this.autoplay&&this.play(),this}play(e=0){if(!0===this.isPlaying)return void console.warn("THREE.Audio: Audio is already playing.");if(!1===this.hasPlaybackControl)return void console.warn("THREE.Audio: this Audio has no playback control.");this._startedAt=this.context.currentTime+e;const t=this.context.createBufferSource();return t.buffer=this.buffer,t.loop=this.loop,t.loopStart=this.loopStart,t.loopEnd=this.loopEnd,t.onended=this.onEnded.bind(this),t.start(this._startedAt,this._progress+this.offset,this.duration),this.isPlaying=!0,this.source=t,this.setDetune(this.detune),this.setPlaybackRate(this.playbackRate),this.connect()}pause(){if(!1!==this.hasPlaybackControl)return!0===this.isPlaying&&(this._progress+=Math.max(this.context.currentTime-this._startedAt,0)*this.playbackRate,!0===this.loop&&(this._progress=this._progress%(this.duration||this.buffer.duration)),this.source.stop(),this.source.onended=null,this.isPlaying=!1),this;console.warn("THREE.Audio: this Audio has no playback control.")}stop(e=0){if(!1!==this.hasPlaybackControl)return this._progress=0,null!==this.source&&(this.source.stop(this.context.currentTime+e),this.source.onended=null),this.isPlaying=!1,this;console.warn("THREE.Audio: this Audio has no playback control.")}connect(){if(this.filters.length>0){this.source.connect(this.filters[0]);for(let e=1,t=this.filters.length;e<t;e++)this.filters[e-1].connect(this.filters[e]);this.filters[this.filters.length-1].connect(this.getOutput())}else this.source.connect(this.getOutput());return this._connected=!0,this}disconnect(){if(!1!==this._connected){if(this.filters.length>0){this.source.disconnect(this.filters[0]);for(let e=1,t=this.filters.length;e<t;e++)this.filters[e-1].disconnect(this.filters[e]);this.filters[this.filters.length-1].disconnect(this.getOutput())}else this.source.disconnect(this.getOutput());return this._connected=!1,this}}getFilters(){return this.filters}setFilters(e){return e||(e=[]),!0===this._connected?(this.disconnect(),this.filters=e.slice(),this.connect()):this.filters=e.slice(),this}setDetune(e){return this.detune=e,!0===this.isPlaying&&void 0!==this.source.detune&&this.source.detune.setTargetAtTime(this.detune,this.context.currentTime,.01),this}getDetune(){return this.detune}getFilter(){return this.getFilters()[0]}setFilter(e){return this.setFilters(e?[e]:[])}setPlaybackRate(e){if(!1!==this.hasPlaybackControl)return this.playbackRate=e,!0===this.isPlaying&&this.source.playbackRate.setTargetAtTime(this.playbackRate,this.context.currentTime,.01),this;console.warn("THREE.Audio: this Audio has no playback control.")}getPlaybackRate(){return this.playbackRate}onEnded(){this.isPlaying=!1,this._progress=0}getLoop(){return!1===this.hasPlaybackControl?(console.warn("THREE.Audio: this Audio has no playback control."),!1):this.loop}setLoop(e){if(!1!==this.hasPlaybackControl)return this.loop=e,!0===this.isPlaying&&(this.source.loop=this.loop),this;console.warn("THREE.Audio: this Audio has no playback control.")}setLoopStart(e){return this.loopStart=e,this}setLoopEnd(e){return this.loopEnd=e,this}getVolume(){return this.gain.gain.value}setVolume(e){return this.gain.gain.setTargetAtTime(e,this.context.currentTime,.01),this}copy(e,t){return super.copy(e,t),"buffer"!==e.sourceType?(console.warn("THREE.Audio: Audio source type cannot be copied."),this):(this.autoplay=e.autoplay,this.buffer=e.buffer,this.detune=e.detune,this.loop=e.loop,this.loopStart=e.loopStart,this.loopEnd=e.loopEnd,this.offset=e.offset,this.duration=e.duration,this.playbackRate=e.playbackRate,this.hasPlaybackControl=e.hasPlaybackControl,this.sourceType=e.sourceType,this.filters=e.filters.slice(),this)}clone(e){return new this.constructor(this.listener).copy(this,e)}}const _position=new Vector3,_quaternion=new Quaternion,_scale=new Vector3,_orientation=new Vector3;class PositionalAudio extends Audio{constructor(e){super(e),this.panner=this.context.createPanner(),this.panner.panningModel="HRTF",this.panner.connect(this.gain)}connect(){return super.connect(),this.panner.connect(this.gain),this}disconnect(){return super.disconnect(),this.panner.disconnect(this.gain),this}getOutput(){return this.panner}getRefDistance(){return this.panner.refDistance}setRefDistance(e){return this.panner.refDistance=e,this}getRolloffFactor(){return this.panner.rolloffFactor}setRolloffFactor(e){return this.panner.rolloffFactor=e,this}getDistanceModel(){return this.panner.distanceModel}setDistanceModel(e){return this.panner.distanceModel=e,this}getMaxDistance(){return this.panner.maxDistance}setMaxDistance(e){return this.panner.maxDistance=e,this}setDirectionalCone(e,t,r){return this.panner.coneInnerAngle=e,this.panner.coneOuterAngle=t,this.panner.coneOuterGain=r,this}updateMatrixWorld(e){if(super.updateMatrixWorld(e),!0===this.hasPlaybackControl&&!1===this.isPlaying)return;this.matrixWorld.decompose(_position,_quaternion,_scale),_orientation.set(0,0,1).applyQuaternion(_quaternion);const t=this.panner;if(t.positionX){const e=this.context.currentTime+this.listener.timeDelta;t.positionX.linearRampToValueAtTime(_position.x,e),t.positionY.linearRampToValueAtTime(_position.y,e),t.positionZ.linearRampToValueAtTime(_position.z,e),t.orientationX.linearRampToValueAtTime(_orientation.x,e),t.orientationY.linearRampToValueAtTime(_orientation.y,e),t.orientationZ.linearRampToValueAtTime(_orientation.z,e)}else t.setPosition(_position.x,_position.y,_position.z),t.setOrientation(_orientation.x,_orientation.y,_orientation.z)}}class AudioAnalyser{constructor(e,t=2048){this.analyser=e.context.createAnalyser(),this.analyser.fftSize=t,this.data=new Uint8Array(this.analyser.frequencyBinCount),e.getOutput().connect(this.analyser)}getFrequencyData(){return this.analyser.getByteFrequencyData(this.data),this.data}getAverageFrequency(){let e=0;const t=this.getFrequencyData();for(let r=0;r<t.length;r++)e+=t[r];return e/t.length}}class PropertyMixer{constructor(e,t,r){let n,i,a;switch(this.binding=e,this.valueSize=r,t){case"quaternion":n=this._slerp,i=this._slerpAdditive,a=this._setAdditiveIdentityQuaternion,this.buffer=new Float64Array(6*r),this._workIndex=5;break;case"string":case"bool":n=this._select,i=this._select,a=this._setAdditiveIdentityOther,this.buffer=new Array(5*r);break;default:n=this._lerp,i=this._lerpAdditive,a=this._setAdditiveIdentityNumeric,this.buffer=new Float64Array(5*r)}this._mixBufferRegion=n,this._mixBufferRegionAdditive=i,this._setIdentity=a,this._origIndex=3,this._addIndex=4,this.cumulativeWeight=0,this.cumulativeWeightAdditive=0,this.useCount=0,this.referenceCount=0}accumulate(e,t){const r=this.buffer,n=this.valueSize,i=e*n+n;let a=this.cumulativeWeight;if(0===a){for(let e=0;e!==n;++e)r[i+e]=r[e];a=t}else{a+=t;const e=t/a;this._mixBufferRegion(r,i,0,e,n)}this.cumulativeWeight=a}accumulateAdditive(e){const t=this.buffer,r=this.valueSize,n=r*this._addIndex;0===this.cumulativeWeightAdditive&&this._setIdentity(),this._mixBufferRegionAdditive(t,n,0,e,r),this.cumulativeWeightAdditive+=e}apply(e){const t=this.valueSize,r=this.buffer,n=e*t+t,i=this.cumulativeWeight,a=this.cumulativeWeightAdditive,s=this.binding;if(this.cumulativeWeight=0,this.cumulativeWeightAdditive=0,i<1){const e=t*this._origIndex;this._mixBufferRegion(r,n,e,1-i,t)}a>0&&this._mixBufferRegionAdditive(r,n,this._addIndex*t,1,t);for(let e=t,i=t+t;e!==i;++e)if(r[e]!==r[e+t]){s.setValue(r,n);break}}saveOriginalState(){const e=this.binding,t=this.buffer,r=this.valueSize,n=r*this._origIndex;e.getValue(t,n);for(let e=r,i=n;e!==i;++e)t[e]=t[n+e%r];this._setIdentity(),this.cumulativeWeight=0,this.cumulativeWeightAdditive=0}restoreOriginalState(){const e=3*this.valueSize;this.binding.setValue(this.buffer,e)}_setAdditiveIdentityNumeric(){const e=this._addIndex*this.valueSize,t=e+this.valueSize;for(let r=e;r<t;r++)this.buffer[r]=0}_setAdditiveIdentityQuaternion(){this._setAdditiveIdentityNumeric(),this.buffer[this._addIndex*this.valueSize+3]=1}_setAdditiveIdentityOther(){const e=this._origIndex*this.valueSize,t=this._addIndex*this.valueSize;for(let r=0;r<this.valueSize;r++)this.buffer[t+r]=this.buffer[e+r]}_select(e,t,r,n,i){if(n>=.5)for(let n=0;n!==i;++n)e[t+n]=e[r+n]}_slerp(e,t,r,n){Quaternion.slerpFlat(e,t,e,t,e,r,n)}_slerpAdditive(e,t,r,n,i){const a=this._workIndex*i;Quaternion.multiplyQuaternionsFlat(e,a,e,t,e,r),Quaternion.slerpFlat(e,t,e,t,e,a,n)}_lerp(e,t,r,n,i){const a=1-n;for(let s=0;s!==i;++s){const i=t+s;e[i]=e[i]*a+e[r+s]*n}}_lerpAdditive(e,t,r,n,i){for(let a=0;a!==i;++a){const i=t+a;e[i]=e[i]+e[r+a]*n}}}const _RESERVED_CHARS_RE="\\[\\]\\.:\\/",_reservedRe=new RegExp("[\\[\\]\\.:\\/]","g"),_wordChar="[^\\[\\]\\.:\\/]",_wordCharOrDot="[^"+"\\[\\]\\.:\\/".replace("\\.","")+"]",_directoryRe=/((?:WC+[\/:])*)/.source.replace("WC",_wordChar),_nodeRe=/(WCOD+)?/.source.replace("WCOD",_wordCharOrDot),_objectRe=/(?:\.(WC+)(?:\[(.+)\])?)?/.source.replace("WC",_wordChar),_propertyRe=/\.(WC+)(?:\[(.+)\])?/.source.replace("WC",_wordChar),_trackRe=new RegExp("^"+_directoryRe+_nodeRe+_objectRe+_propertyRe+"$"),_supportedObjectNames=["material","materials","bones","map"];class Composite{constructor(e,t,r){const n=r||PropertyBinding.parseTrackName(t);this._targetGroup=e,this._bindings=e.subscribe_(t,n)}getValue(e,t){this.bind();const r=this._targetGroup.nCachedObjects_,n=this._bindings[r];void 0!==n&&n.getValue(e,t)}setValue(e,t){const r=this._bindings;for(let n=this._targetGroup.nCachedObjects_,i=r.length;n!==i;++n)r[n].setValue(e,t)}bind(){const e=this._bindings;for(let t=this._targetGroup.nCachedObjects_,r=e.length;t!==r;++t)e[t].bind()}unbind(){const e=this._bindings;for(let t=this._targetGroup.nCachedObjects_,r=e.length;t!==r;++t)e[t].unbind()}}class PropertyBinding{constructor(e,t,r){this.path=t,this.parsedPath=r||PropertyBinding.parseTrackName(t),this.node=PropertyBinding.findNode(e,this.parsedPath.nodeName),this.rootNode=e,this.getValue=this._getValue_unbound,this.setValue=this._setValue_unbound}static create(e,t,r){return e&&e.isAnimationObjectGroup?new PropertyBinding.Composite(e,t,r):new PropertyBinding(e,t,r)}static sanitizeNodeName(e){return e.replace(/\s/g,"_").replace(_reservedRe,"")}static parseTrackName(e){const t=_trackRe.exec(e);if(null===t)throw new Error("PropertyBinding: Cannot parse trackName: "+e);const r={nodeName:t[2],objectName:t[3],objectIndex:t[4],propertyName:t[5],propertyIndex:t[6]},n=r.nodeName&&r.nodeName.lastIndexOf(".");if(void 0!==n&&-1!==n){const e=r.nodeName.substring(n+1);-1!==_supportedObjectNames.indexOf(e)&&(r.nodeName=r.nodeName.substring(0,n),r.objectName=e)}if(null===r.propertyName||0===r.propertyName.length)throw new Error("PropertyBinding: can not parse propertyName from trackName: "+e);return r}static findNode(e,t){if(void 0===t||""===t||"."===t||-1===t||t===e.name||t===e.uuid)return e;if(e.skeleton){const r=e.skeleton.getBoneByName(t);if(void 0!==r)return r}if(e.children){const r=function(e){for(let n=0;n<e.length;n++){const i=e[n];if(i.name===t||i.uuid===t)return i;const a=r(i.children);if(a)return a}return null},n=r(e.children);if(n)return n}return null}_getValue_unavailable(){}_setValue_unavailable(){}_getValue_direct(e,t){e[t]=this.targetObject[this.propertyName]}_getValue_array(e,t){const r=this.resolvedProperty;for(let n=0,i=r.length;n!==i;++n)e[t++]=r[n]}_getValue_arrayElement(e,t){e[t]=this.resolvedProperty[this.propertyIndex]}_getValue_toArray(e,t){this.resolvedProperty.toArray(e,t)}_setValue_direct(e,t){this.targetObject[this.propertyName]=e[t]}_setValue_direct_setNeedsUpdate(e,t){this.targetObject[this.propertyName]=e[t],this.targetObject.needsUpdate=!0}_setValue_direct_setMatrixWorldNeedsUpdate(e,t){this.targetObject[this.propertyName]=e[t],this.targetObject.matrixWorldNeedsUpdate=!0}_setValue_array(e,t){const r=this.resolvedProperty;for(let n=0,i=r.length;n!==i;++n)r[n]=e[t++]}_setValue_array_setNeedsUpdate(e,t){const r=this.resolvedProperty;for(let n=0,i=r.length;n!==i;++n)r[n]=e[t++];this.targetObject.needsUpdate=!0}_setValue_array_setMatrixWorldNeedsUpdate(e,t){const r=this.resolvedProperty;for(let n=0,i=r.length;n!==i;++n)r[n]=e[t++];this.targetObject.matrixWorldNeedsUpdate=!0}_setValue_arrayElement(e,t){this.resolvedProperty[this.propertyIndex]=e[t]}_setValue_arrayElement_setNeedsUpdate(e,t){this.resolvedProperty[this.propertyIndex]=e[t],this.targetObject.needsUpdate=!0}_setValue_arrayElement_setMatrixWorldNeedsUpdate(e,t){this.resolvedProperty[this.propertyIndex]=e[t],this.targetObject.matrixWorldNeedsUpdate=!0}_setValue_fromArray(e,t){this.resolvedProperty.fromArray(e,t)}_setValue_fromArray_setNeedsUpdate(e,t){this.resolvedProperty.fromArray(e,t),this.targetObject.needsUpdate=!0}_setValue_fromArray_setMatrixWorldNeedsUpdate(e,t){this.resolvedProperty.fromArray(e,t),this.targetObject.matrixWorldNeedsUpdate=!0}_getValue_unbound(e,t){this.bind(),this.getValue(e,t)}_setValue_unbound(e,t){this.bind(),this.setValue(e,t)}bind(){let e=this.node;const t=this.parsedPath,r=t.objectName,n=t.propertyName;let i=t.propertyIndex;if(e||(e=PropertyBinding.findNode(this.rootNode,t.nodeName),this.node=e),this.getValue=this._getValue_unavailable,this.setValue=this._setValue_unavailable,!e)return void console.warn("THREE.PropertyBinding: No target node found for track: "+this.path+".");if(r){let n=t.objectIndex;switch(r){case"materials":if(!e.material)return void console.error("THREE.PropertyBinding: Can not bind to material as node does not have a material.",this);if(!e.material.materials)return void console.error("THREE.PropertyBinding: Can not bind to material.materials as node.material does not have a materials array.",this);e=e.material.materials;break;case"bones":if(!e.skeleton)return void console.error("THREE.PropertyBinding: Can not bind to bones as node does not have a skeleton.",this);e=e.skeleton.bones;for(let t=0;t<e.length;t++)if(e[t].name===n){n=t;break}break;case"map":if("map"in e){e=e.map;break}if(!e.material)return void console.error("THREE.PropertyBinding: Can not bind to material as node does not have a material.",this);if(!e.material.map)return void console.error("THREE.PropertyBinding: Can not bind to material.map as node.material does not have a map.",this);e=e.material.map;break;default:if(void 0===e[r])return void console.error("THREE.PropertyBinding: Can not bind to objectName of node undefined.",this);e=e[r]}if(void 0!==n){if(void 0===e[n])return void console.error("THREE.PropertyBinding: Trying to bind to objectIndex of objectName, but is undefined.",this,e);e=e[n]}}const a=e[n];if(void 0===a){const r=t.nodeName;return void console.error("THREE.PropertyBinding: Trying to update property for track: "+r+"."+n+" but it wasn't found.",e)}let s=this.Versioning.None;this.targetObject=e,!0===e.isMaterial?s=this.Versioning.NeedsUpdate:!0===e.isObject3D&&(s=this.Versioning.MatrixWorldNeedsUpdate);let o=this.BindingType.Direct;if(void 0!==i){if("morphTargetInfluences"===n){if(!e.geometry)return void console.error("THREE.PropertyBinding: Can not bind to morphTargetInfluences because node does not have a geometry.",this);if(!e.geometry.morphAttributes)return void console.error("THREE.PropertyBinding: Can not bind to morphTargetInfluences because node does not have a geometry.morphAttributes.",this);void 0!==e.morphTargetDictionary[i]&&(i=e.morphTargetDictionary[i])}o=this.BindingType.ArrayElement,this.resolvedProperty=a,this.propertyIndex=i}else void 0!==a.fromArray&&void 0!==a.toArray?(o=this.BindingType.HasFromToArray,this.resolvedProperty=a):Array.isArray(a)?(o=this.BindingType.EntireArray,this.resolvedProperty=a):this.propertyName=n;this.getValue=this.GetterByBindingType[o],this.setValue=this.SetterByBindingTypeAndVersioning[o][s]}unbind(){this.node=null,this.getValue=this._getValue_unbound,this.setValue=this._setValue_unbound}}PropertyBinding.Composite=Composite,PropertyBinding.prototype.BindingType={Direct:0,EntireArray:1,ArrayElement:2,HasFromToArray:3},PropertyBinding.prototype.Versioning={None:0,NeedsUpdate:1,MatrixWorldNeedsUpdate:2},PropertyBinding.prototype.GetterByBindingType=[PropertyBinding.prototype._getValue_direct,PropertyBinding.prototype._getValue_array,PropertyBinding.prototype._getValue_arrayElement,PropertyBinding.prototype._getValue_toArray],PropertyBinding.prototype.SetterByBindingTypeAndVersioning=[[PropertyBinding.prototype._setValue_direct,PropertyBinding.prototype._setValue_direct_setNeedsUpdate,PropertyBinding.prototype._setValue_direct_setMatrixWorldNeedsUpdate],[PropertyBinding.prototype._setValue_array,PropertyBinding.prototype._setValue_array_setNeedsUpdate,PropertyBinding.prototype._setValue_array_setMatrixWorldNeedsUpdate],[PropertyBinding.prototype._setValue_arrayElement,PropertyBinding.prototype._setValue_arrayElement_setNeedsUpdate,PropertyBinding.prototype._setValue_arrayElement_setMatrixWorldNeedsUpdate],[PropertyBinding.prototype._setValue_fromArray,PropertyBinding.prototype._setValue_fromArray_setNeedsUpdate,PropertyBinding.prototype._setValue_fromArray_setMatrixWorldNeedsUpdate]];class AnimationObjectGroup{constructor(){this.isAnimationObjectGroup=!0,this.uuid=generateUUID(),this._objects=Array.prototype.slice.call(arguments),this.nCachedObjects_=0;const e={};this._indicesByUUID=e;for(let t=0,r=arguments.length;t!==r;++t)e[arguments[t].uuid]=t;this._paths=[],this._parsedPaths=[],this._bindings=[],this._bindingsIndicesByPath={};const t=this;this.stats={objects:{get total(){return t._objects.length},get inUse(){return this.total-t.nCachedObjects_}},get bindingsPerObject(){return t._bindings.length}}}add(){const e=this._objects,t=this._indicesByUUID,r=this._paths,n=this._parsedPaths,i=this._bindings,a=i.length;let s,o=e.length,l=this.nCachedObjects_;for(let c=0,h=arguments.length;c!==h;++c){const h=arguments[c],u=h.uuid;let d=t[u];if(void 0===d){d=o++,t[u]=d,e.push(h);for(let e=0,t=a;e!==t;++e)i[e].push(new PropertyBinding(h,r[e],n[e]))}else if(d<l){s=e[d];const o=--l,c=e[o];t[c.uuid]=d,e[d]=c,t[u]=o,e[o]=h;for(let e=0,t=a;e!==t;++e){const t=i[e],a=t[o];let s=t[d];t[d]=a,void 0===s&&(s=new PropertyBinding(h,r[e],n[e])),t[o]=s}}else e[d]!==s&&console.error("THREE.AnimationObjectGroup: Different objects with the same UUID detected. Clean the caches or recreate your infrastructure when reloading scenes.")}this.nCachedObjects_=l}remove(){const e=this._objects,t=this._indicesByUUID,r=this._bindings,n=r.length;let i=this.nCachedObjects_;for(let a=0,s=arguments.length;a!==s;++a){const s=arguments[a],o=s.uuid,l=t[o];if(void 0!==l&&l>=i){const a=i++,c=e[a];t[c.uuid]=l,e[l]=c,t[o]=a,e[a]=s;for(let e=0,t=n;e!==t;++e){const t=r[e],n=t[a],i=t[l];t[l]=n,t[a]=i}}}this.nCachedObjects_=i}uncache(){const e=this._objects,t=this._indicesByUUID,r=this._bindings,n=r.length;let i=this.nCachedObjects_,a=e.length;for(let s=0,o=arguments.length;s!==o;++s){const o=arguments[s].uuid,l=t[o];if(void 0!==l)if(delete t[o],l<i){const s=--i,o=e[s],c=--a,h=e[c];t[o.uuid]=l,e[l]=o,t[h.uuid]=s,e[s]=h,e.pop();for(let e=0,t=n;e!==t;++e){const t=r[e],n=t[s],i=t[c];t[l]=n,t[s]=i,t.pop()}}else{const i=--a,s=e[i];i>0&&(t[s.uuid]=l),e[l]=s,e.pop();for(let e=0,t=n;e!==t;++e){const t=r[e];t[l]=t[i],t.pop()}}}this.nCachedObjects_=i}subscribe_(e,t){const r=this._bindingsIndicesByPath;let n=r[e];const i=this._bindings;if(void 0!==n)return i[n];const a=this._paths,s=this._parsedPaths,o=this._objects,l=o.length,c=this.nCachedObjects_,h=new Array(l);n=i.length,r[e]=n,a.push(e),s.push(t),i.push(h);for(let r=c,n=o.length;r!==n;++r){const n=o[r];h[r]=new PropertyBinding(n,e,t)}return h}unsubscribe_(e){const t=this._bindingsIndicesByPath,r=t[e];if(void 0!==r){const n=this._paths,i=this._parsedPaths,a=this._bindings,s=a.length-1,o=a[s];t[e[s]]=r,a[r]=o,a.pop(),i[r]=i[s],i.pop(),n[r]=n[s],n.pop()}}}class AnimationAction{constructor(e,t,r=null,n=t.blendMode){this._mixer=e,this._clip=t,this._localRoot=r,this.blendMode=n;const i=t.tracks,a=i.length,s=new Array(a),o={endingStart:2400,endingEnd:2400};for(let e=0;e!==a;++e){const t=i[e].createInterpolant(null);s[e]=t,t.settings=o}this._interpolantSettings=o,this._interpolants=s,this._propertyBindings=new Array(a),this._cacheIndex=null,this._byClipCacheIndex=null,this._timeScaleInterpolant=null,this._weightInterpolant=null,this.loop=2201,this._loopCount=-1,this._startTime=null,this.time=0,this.timeScale=1,this._effectiveTimeScale=1,this.weight=1,this._effectiveWeight=1,this.repetitions=1/0,this.paused=!1,this.enabled=!0,this.clampWhenFinished=!1,this.zeroSlopeAtStart=!0,this.zeroSlopeAtEnd=!0}play(){return this._mixer._activateAction(this),this}stop(){return this._mixer._deactivateAction(this),this.reset()}reset(){return this.paused=!1,this.enabled=!0,this.time=0,this._loopCount=-1,this._startTime=null,this.stopFading().stopWarping()}isRunning(){return this.enabled&&!this.paused&&0!==this.timeScale&&null===this._startTime&&this._mixer._isActiveAction(this)}isScheduled(){return this._mixer._isActiveAction(this)}startAt(e){return this._startTime=e,this}setLoop(e,t){return this.loop=e,this.repetitions=t,this}setEffectiveWeight(e){return this.weight=e,this._effectiveWeight=this.enabled?e:0,this.stopFading()}getEffectiveWeight(){return this._effectiveWeight}fadeIn(e){return this._scheduleFading(e,0,1)}fadeOut(e){return this._scheduleFading(e,1,0)}crossFadeFrom(e,t,r=!1){if(e.fadeOut(t),this.fadeIn(t),!0===r){const r=this._clip.duration,n=e._clip.duration,i=n/r,a=r/n;e.warp(1,i,t),this.warp(a,1,t)}return this}crossFadeTo(e,t,r=!1){return e.crossFadeFrom(this,t,r)}stopFading(){const e=this._weightInterpolant;return null!==e&&(this._weightInterpolant=null,this._mixer._takeBackControlInterpolant(e)),this}setEffectiveTimeScale(e){return this.timeScale=e,this._effectiveTimeScale=this.paused?0:e,this.stopWarping()}getEffectiveTimeScale(){return this._effectiveTimeScale}setDuration(e){return this.timeScale=this._clip.duration/e,this.stopWarping()}syncWith(e){return this.time=e.time,this.timeScale=e.timeScale,this.stopWarping()}halt(e){return this.warp(this._effectiveTimeScale,0,e)}warp(e,t,r){const n=this._mixer,i=n.time,a=this.timeScale;let s=this._timeScaleInterpolant;null===s&&(s=n._lendControlInterpolant(),this._timeScaleInterpolant=s);const o=s.parameterPositions,l=s.sampleValues;return o[0]=i,o[1]=i+r,l[0]=e/a,l[1]=t/a,this}stopWarping(){const e=this._timeScaleInterpolant;return null!==e&&(this._timeScaleInterpolant=null,this._mixer._takeBackControlInterpolant(e)),this}getMixer(){return this._mixer}getClip(){return this._clip}getRoot(){return this._localRoot||this._mixer._root}_update(e,t,r,n){if(!this.enabled)return void this._updateWeight(e);const i=this._startTime;if(null!==i){const n=(e-i)*r;n<0||0===r?t=0:(this._startTime=null,t=r*n)}t*=this._updateTimeScale(e);const a=this._updateTime(t),s=this._updateWeight(e);if(s>0){const e=this._interpolants,t=this._propertyBindings;if(2501===this.blendMode)for(let r=0,n=e.length;r!==n;++r)e[r].evaluate(a),t[r].accumulateAdditive(s);else for(let r=0,i=e.length;r!==i;++r)e[r].evaluate(a),t[r].accumulate(n,s)}}_updateWeight(e){let t=0;if(this.enabled){t=this.weight;const r=this._weightInterpolant;if(null!==r){const n=r.evaluate(e)[0];t*=n,e>r.parameterPositions[1]&&(this.stopFading(),0===n&&(this.enabled=!1))}}return this._effectiveWeight=t,t}_updateTimeScale(e){let t=0;if(!this.paused){t=this.timeScale;const r=this._timeScaleInterpolant;if(null!==r){t*=r.evaluate(e)[0],e>r.parameterPositions[1]&&(this.stopWarping(),0===t?this.paused=!0:this.timeScale=t)}}return this._effectiveTimeScale=t,t}_updateTime(e){const t=this._clip.duration,r=this.loop;let n=this.time+e,i=this._loopCount;const a=2202===r;if(0===e)return-1===i||!a||1&~i?n:t-n;if(2200===r){-1===i&&(this._loopCount=0,this._setEndings(!0,!0,!1));e:{if(n>=t)n=t;else{if(!(n<0)){this.time=n;break e}n=0}this.clampWhenFinished?this.paused=!0:this.enabled=!1,this.time=n,this._mixer.dispatchEvent({type:"finished",action:this,direction:e<0?-1:1})}}else{if(-1===i&&(e>=0?(i=0,this._setEndings(!0,0===this.repetitions,a)):this._setEndings(0===this.repetitions,!0,a)),n>=t||n<0){const r=Math.floor(n/t);n-=t*r,i+=Math.abs(r);const s=this.repetitions-i;if(s<=0)this.clampWhenFinished?this.paused=!0:this.enabled=!1,n=e>0?t:0,this.time=n,this._mixer.dispatchEvent({type:"finished",action:this,direction:e>0?1:-1});else{if(1===s){const t=e<0;this._setEndings(t,!t,a)}else this._setEndings(!1,!1,a);this._loopCount=i,this.time=n,this._mixer.dispatchEvent({type:"loop",action:this,loopDelta:r})}}else this.time=n;if(a&&!(1&~i))return t-n}return n}_setEndings(e,t,r){const n=this._interpolantSettings;r?(n.endingStart=2401,n.endingEnd=2401):(n.endingStart=e?this.zeroSlopeAtStart?2401:2400:2402,n.endingEnd=t?this.zeroSlopeAtEnd?2401:2400:2402)}_scheduleFading(e,t,r){const n=this._mixer,i=n.time;let a=this._weightInterpolant;null===a&&(a=n._lendControlInterpolant(),this._weightInterpolant=a);const s=a.parameterPositions,o=a.sampleValues;return s[0]=i,o[0]=t,s[1]=i+e,o[1]=r,this}}const _controlInterpolantsResultBuffer=new Float32Array(1);class AnimationMixer extends EventDispatcher{constructor(e){super(),this._root=e,this._initMemoryManager(),this._accuIndex=0,this.time=0,this.timeScale=1}_bindAction(e,t){const r=e._localRoot||this._root,n=e._clip.tracks,i=n.length,a=e._propertyBindings,s=e._interpolants,o=r.uuid,l=this._bindingsByRootAndName;let c=l[o];void 0===c&&(c={},l[o]=c);for(let e=0;e!==i;++e){const i=n[e],l=i.name;let h=c[l];if(void 0!==h)++h.referenceCount,a[e]=h;else{if(h=a[e],void 0!==h){null===h._cacheIndex&&(++h.referenceCount,this._addInactiveBinding(h,o,l));continue}const n=t&&t._propertyBindings[e].binding.parsedPath;h=new PropertyMixer(PropertyBinding.create(r,l,n),i.ValueTypeName,i.getValueSize()),++h.referenceCount,this._addInactiveBinding(h,o,l),a[e]=h}s[e].resultBuffer=h.buffer}}_activateAction(e){if(!this._isActiveAction(e)){if(null===e._cacheIndex){const t=(e._localRoot||this._root).uuid,r=e._clip.uuid,n=this._actionsByClip[r];this._bindAction(e,n&&n.knownActions[0]),this._addInactiveAction(e,r,t)}const t=e._propertyBindings;for(let e=0,r=t.length;e!==r;++e){const r=t[e];0==r.useCount++&&(this._lendBinding(r),r.saveOriginalState())}this._lendAction(e)}}_deactivateAction(e){if(this._isActiveAction(e)){const t=e._propertyBindings;for(let e=0,r=t.length;e!==r;++e){const r=t[e];0==--r.useCount&&(r.restoreOriginalState(),this._takeBackBinding(r))}this._takeBackAction(e)}}_initMemoryManager(){this._actions=[],this._nActiveActions=0,this._actionsByClip={},this._bindings=[],this._nActiveBindings=0,this._bindingsByRootAndName={},this._controlInterpolants=[],this._nActiveControlInterpolants=0;const e=this;this.stats={actions:{get total(){return e._actions.length},get inUse(){return e._nActiveActions}},bindings:{get total(){return e._bindings.length},get inUse(){return e._nActiveBindings}},controlInterpolants:{get total(){return e._controlInterpolants.length},get inUse(){return e._nActiveControlInterpolants}}}}_isActiveAction(e){const t=e._cacheIndex;return null!==t&&t<this._nActiveActions}_addInactiveAction(e,t,r){const n=this._actions,i=this._actionsByClip;let a=i[t];if(void 0===a)a={knownActions:[e],actionByRoot:{}},e._byClipCacheIndex=0,i[t]=a;else{const t=a.knownActions;e._byClipCacheIndex=t.length,t.push(e)}e._cacheIndex=n.length,n.push(e),a.actionByRoot[r]=e}_removeInactiveAction(e){const t=this._actions,r=t[t.length-1],n=e._cacheIndex;r._cacheIndex=n,t[n]=r,t.pop(),e._cacheIndex=null;const i=e._clip.uuid,a=this._actionsByClip,s=a[i],o=s.knownActions,l=o[o.length-1],c=e._byClipCacheIndex;l._byClipCacheIndex=c,o[c]=l,o.pop(),e._byClipCacheIndex=null;delete s.actionByRoot[(e._localRoot||this._root).uuid],0===o.length&&delete a[i],this._removeInactiveBindingsForAction(e)}_removeInactiveBindingsForAction(e){const t=e._propertyBindings;for(let e=0,r=t.length;e!==r;++e){const r=t[e];0==--r.referenceCount&&this._removeInactiveBinding(r)}}_lendAction(e){const t=this._actions,r=e._cacheIndex,n=this._nActiveActions++,i=t[n];e._cacheIndex=n,t[n]=e,i._cacheIndex=r,t[r]=i}_takeBackAction(e){const t=this._actions,r=e._cacheIndex,n=--this._nActiveActions,i=t[n];e._cacheIndex=n,t[n]=e,i._cacheIndex=r,t[r]=i}_addInactiveBinding(e,t,r){const n=this._bindingsByRootAndName,i=this._bindings;let a=n[t];void 0===a&&(a={},n[t]=a),a[r]=e,e._cacheIndex=i.length,i.push(e)}_removeInactiveBinding(e){const t=this._bindings,r=e.binding,n=r.rootNode.uuid,i=r.path,a=this._bindingsByRootAndName,s=a[n],o=t[t.length-1],l=e._cacheIndex;o._cacheIndex=l,t[l]=o,t.pop(),delete s[i],0===Object.keys(s).length&&delete a[n]}_lendBinding(e){const t=this._bindings,r=e._cacheIndex,n=this._nActiveBindings++,i=t[n];e._cacheIndex=n,t[n]=e,i._cacheIndex=r,t[r]=i}_takeBackBinding(e){const t=this._bindings,r=e._cacheIndex,n=--this._nActiveBindings,i=t[n];e._cacheIndex=n,t[n]=e,i._cacheIndex=r,t[r]=i}_lendControlInterpolant(){const e=this._controlInterpolants,t=this._nActiveControlInterpolants++;let r=e[t];return void 0===r&&(r=new LinearInterpolant(new Float32Array(2),new Float32Array(2),1,_controlInterpolantsResultBuffer),r.__cacheIndex=t,e[t]=r),r}_takeBackControlInterpolant(e){const t=this._controlInterpolants,r=e.__cacheIndex,n=--this._nActiveControlInterpolants,i=t[n];e.__cacheIndex=n,t[n]=e,i.__cacheIndex=r,t[r]=i}clipAction(e,t,r){const n=t||this._root,i=n.uuid;let a="string"==typeof e?AnimationClip.findByName(n,e):e;const s=null!==a?a.uuid:e,o=this._actionsByClip[s];let l=null;if(void 0===r&&(r=null!==a?a.blendMode:2500),void 0!==o){const e=o.actionByRoot[i];if(void 0!==e&&e.blendMode===r)return e;l=o.knownActions[0],null===a&&(a=l._clip)}if(null===a)return null;const c=new AnimationAction(this,a,t,r);return this._bindAction(c,l),this._addInactiveAction(c,s,i),c}existingAction(e,t){const r=t||this._root,n=r.uuid,i="string"==typeof e?AnimationClip.findByName(r,e):e,a=i?i.uuid:e,s=this._actionsByClip[a];return void 0!==s&&s.actionByRoot[n]||null}stopAllAction(){const e=this._actions;for(let t=this._nActiveActions-1;t>=0;--t)e[t].stop();return this}update(e){e*=this.timeScale;const t=this._actions,r=this._nActiveActions,n=this.time+=e,i=Math.sign(e),a=this._accuIndex^=1;for(let s=0;s!==r;++s){t[s]._update(n,e,i,a)}const s=this._bindings,o=this._nActiveBindings;for(let e=0;e!==o;++e)s[e].apply(a);return this}setTime(e){this.time=0;for(let e=0;e<this._actions.length;e++)this._actions[e].time=0;return this.update(e)}getRoot(){return this._root}uncacheClip(e){const t=this._actions,r=e.uuid,n=this._actionsByClip,i=n[r];if(void 0!==i){const e=i.knownActions;for(let r=0,n=e.length;r!==n;++r){const n=e[r];this._deactivateAction(n);const i=n._cacheIndex,a=t[t.length-1];n._cacheIndex=null,n._byClipCacheIndex=null,a._cacheIndex=i,t[i]=a,t.pop(),this._removeInactiveBindingsForAction(n)}delete n[r]}}uncacheRoot(e){const t=e.uuid,r=this._actionsByClip;for(const e in r){const n=r[e].actionByRoot[t];void 0!==n&&(this._deactivateAction(n),this._removeInactiveAction(n))}const n=this._bindingsByRootAndName[t];if(void 0!==n)for(const e in n){const t=n[e];t.restoreOriginalState(),this._removeInactiveBinding(t)}}uncacheAction(e,t){const r=this.existingAction(e,t);null!==r&&(this._deactivateAction(r),this._removeInactiveAction(r))}}class RenderTarget3D extends RenderTarget{constructor(e=1,t=1,r=1,n={}){super(e,t,n),this.isRenderTarget3D=!0,this.depth=r,this.texture=new Data3DTexture(null,e,t,r),this.texture.isRenderTargetTexture=!0}}class RenderTargetArray extends RenderTarget{constructor(e=1,t=1,r=1,n={}){super(e,t,n),this.isRenderTargetArray=!0,this.depth=r,this.texture=new DataArrayTexture(null,e,t,r),this.texture.isRenderTargetTexture=!0}}class Uniform{constructor(e){this.value=e}clone(){return new Uniform(void 0===this.value.clone?this.value:this.value.clone())}}let _id$1=0;class UniformsGroup extends EventDispatcher{constructor(){super(),this.isUniformsGroup=!0,Object.defineProperty(this,"id",{value:_id$1++}),this.name="",this.usage=35044,this.uniforms=[]}add(e){return this.uniforms.push(e),this}remove(e){const t=this.uniforms.indexOf(e);return-1!==t&&this.uniforms.splice(t,1),this}setName(e){return this.name=e,this}setUsage(e){return this.usage=e,this}dispose(){this.dispatchEvent({type:"dispose"})}copy(e){this.name=e.name,this.usage=e.usage;const t=e.uniforms;this.uniforms.length=0;for(let e=0,r=t.length;e<r;e++){const r=Array.isArray(t[e])?t[e]:[t[e]];for(let e=0;e<r.length;e++)this.uniforms.push(r[e].clone())}return this}clone(){return(new this.constructor).copy(this)}}class InstancedInterleavedBuffer extends InterleavedBuffer{constructor(e,t,r=1){super(e,t),this.isInstancedInterleavedBuffer=!0,this.meshPerAttribute=r}copy(e){return super.copy(e),this.meshPerAttribute=e.meshPerAttribute,this}clone(e){const t=super.clone(e);return t.meshPerAttribute=this.meshPerAttribute,t}toJSON(e){const t=super.toJSON(e);return t.isInstancedInterleavedBuffer=!0,t.meshPerAttribute=this.meshPerAttribute,t}}class GLBufferAttribute{constructor(e,t,r,n,i){this.isGLBufferAttribute=!0,this.name="",this.buffer=e,this.type=t,this.itemSize=r,this.elementSize=n,this.count=i,this.version=0}set needsUpdate(e){!0===e&&this.version++}setBuffer(e){return this.buffer=e,this}setType(e,t){return this.type=e,this.elementSize=t,this}setItemSize(e){return this.itemSize=e,this}setCount(e){return this.count=e,this}}const _matrix=new Matrix4;class Raycaster{constructor(e,t,r=0,n=1/0){this.ray=new Ray(e,t),this.near=r,this.far=n,this.camera=null,this.layers=new Layers,this.params={Mesh:{},Line:{threshold:1},LOD:{},Points:{threshold:1},Sprite:{}}}set(e,t){this.ray.set(e,t)}setFromCamera(e,t){t.isPerspectiveCamera?(this.ray.origin.setFromMatrixPosition(t.matrixWorld),this.ray.direction.set(e.x,e.y,.5).unproject(t).sub(this.ray.origin).normalize(),this.camera=t):t.isOrthographicCamera?(this.ray.origin.set(e.x,e.y,(t.near+t.far)/(t.near-t.far)).unproject(t),this.ray.direction.set(0,0,-1).transformDirection(t.matrixWorld),this.camera=t):console.error("THREE.Raycaster: Unsupported camera type: "+t.type)}setFromXRController(e){return _matrix.identity().extractRotation(e.matrixWorld),this.ray.origin.setFromMatrixPosition(e.matrixWorld),this.ray.direction.set(0,0,-1).applyMatrix4(_matrix),this}intersectObject(e,t=!0,r=[]){return intersect(e,this,r,t),r.sort(ascSort),r}intersectObjects(e,t=!0,r=[]){for(let n=0,i=e.length;n<i;n++)intersect(e[n],this,r,t);return r.sort(ascSort),r}}function ascSort(e,t){return e.distance-t.distance}function intersect(e,t,r,n){let i=!0;if(e.layers.test(t.layers)){!1===e.raycast(t,r)&&(i=!1)}if(!0===i&&!0===n){const n=e.children;for(let e=0,i=n.length;e<i;e++)intersect(n[e],t,r,!0)}}class Spherical{constructor(e=1,t=0,r=0){this.radius=e,this.phi=t,this.theta=r}set(e,t,r){return this.radius=e,this.phi=t,this.theta=r,this}copy(e){return this.radius=e.radius,this.phi=e.phi,this.theta=e.theta,this}makeSafe(){const e=1e-6;return this.phi=clamp(this.phi,e,Math.PI-e),this}setFromVector3(e){return this.setFromCartesianCoords(e.x,e.y,e.z)}setFromCartesianCoords(e,t,r){return this.radius=Math.sqrt(e*e+t*t+r*r),0===this.radius?(this.theta=0,this.phi=0):(this.theta=Math.atan2(e,r),this.phi=Math.acos(clamp(t/this.radius,-1,1))),this}clone(){return(new this.constructor).copy(this)}}class Cylindrical{constructor(e=1,t=0,r=0){this.radius=e,this.theta=t,this.y=r}set(e,t,r){return this.radius=e,this.theta=t,this.y=r,this}copy(e){return this.radius=e.radius,this.theta=e.theta,this.y=e.y,this}setFromVector3(e){return this.setFromCartesianCoords(e.x,e.y,e.z)}setFromCartesianCoords(e,t,r){return this.radius=Math.sqrt(e*e+r*r),this.theta=Math.atan2(e,r),this.y=t,this}clone(){return(new this.constructor).copy(this)}}class Matrix2{constructor(e,t,r,n){Matrix2.prototype.isMatrix2=!0,this.elements=[1,0,0,1],void 0!==e&&this.set(e,t,r,n)}identity(){return this.set(1,0,0,1),this}fromArray(e,t=0){for(let r=0;r<4;r++)this.elements[r]=e[r+t];return this}set(e,t,r,n){const i=this.elements;return i[0]=e,i[2]=t,i[1]=r,i[3]=n,this}}const _vector$4=new Vector2;class Box2{constructor(e=new Vector2(1/0,1/0),t=new Vector2(-1/0,-1/0)){this.isBox2=!0,this.min=e,this.max=t}set(e,t){return this.min.copy(e),this.max.copy(t),this}setFromPoints(e){this.makeEmpty();for(let t=0,r=e.length;t<r;t++)this.expandByPoint(e[t]);return this}setFromCenterAndSize(e,t){const r=_vector$4.copy(t).multiplyScalar(.5);return this.min.copy(e).sub(r),this.max.copy(e).add(r),this}clone(){return(new this.constructor).copy(this)}copy(e){return this.min.copy(e.min),this.max.copy(e.max),this}makeEmpty(){return this.min.x=this.min.y=1/0,this.max.x=this.max.y=-1/0,this}isEmpty(){return this.max.x<this.min.x||this.max.y<this.min.y}getCenter(e){return this.isEmpty()?e.set(0,0):e.addVectors(this.min,this.max).multiplyScalar(.5)}getSize(e){return this.isEmpty()?e.set(0,0):e.subVectors(this.max,this.min)}expandByPoint(e){return this.min.min(e),this.max.max(e),this}expandByVector(e){return this.min.sub(e),this.max.add(e),this}expandByScalar(e){return this.min.addScalar(-e),this.max.addScalar(e),this}containsPoint(e){return e.x>=this.min.x&&e.x<=this.max.x&&e.y>=this.min.y&&e.y<=this.max.y}containsBox(e){return this.min.x<=e.min.x&&e.max.x<=this.max.x&&this.min.y<=e.min.y&&e.max.y<=this.max.y}getParameter(e,t){return t.set((e.x-this.min.x)/(this.max.x-this.min.x),(e.y-this.min.y)/(this.max.y-this.min.y))}intersectsBox(e){return e.max.x>=this.min.x&&e.min.x<=this.max.x&&e.max.y>=this.min.y&&e.min.y<=this.max.y}clampPoint(e,t){return t.copy(e).clamp(this.min,this.max)}distanceToPoint(e){return this.clampPoint(e,_vector$4).distanceTo(e)}intersect(e){return this.min.max(e.min),this.max.min(e.max),this.isEmpty()&&this.makeEmpty(),this}union(e){return this.min.min(e.min),this.max.max(e.max),this}translate(e){return this.min.add(e),this.max.add(e),this}equals(e){return e.min.equals(this.min)&&e.max.equals(this.max)}}const _startP=new Vector3,_startEnd=new Vector3;class Line3{constructor(e=new Vector3,t=new Vector3){this.start=e,this.end=t}set(e,t){return this.start.copy(e),this.end.copy(t),this}copy(e){return this.start.copy(e.start),this.end.copy(e.end),this}getCenter(e){return e.addVectors(this.start,this.end).multiplyScalar(.5)}delta(e){return e.subVectors(this.end,this.start)}distanceSq(){return this.start.distanceToSquared(this.end)}distance(){return this.start.distanceTo(this.end)}at(e,t){return this.delta(t).multiplyScalar(e).add(this.start)}closestPointToPointParameter(e,t){_startP.subVectors(e,this.start),_startEnd.subVectors(this.end,this.start);const r=_startEnd.dot(_startEnd);let n=_startEnd.dot(_startP)/r;return t&&(n=clamp(n,0,1)),n}closestPointToPoint(e,t,r){const n=this.closestPointToPointParameter(e,t);return this.delta(r).multiplyScalar(n).add(this.start)}applyMatrix4(e){return this.start.applyMatrix4(e),this.end.applyMatrix4(e),this}equals(e){return e.start.equals(this.start)&&e.end.equals(this.end)}clone(){return(new this.constructor).copy(this)}}const _vector$3=new Vector3;class SpotLightHelper extends Object3D{constructor(e,t){super(),this.light=e,this.matrixAutoUpdate=!1,this.color=t,this.type="SpotLightHelper";const r=new BufferGeometry,n=[0,0,0,0,0,1,0,0,0,1,0,1,0,0,0,-1,0,1,0,0,0,0,1,1,0,0,0,0,-1,1];for(let e=0,t=1,r=32;e<r;e++,t++){const i=e/r*Math.PI*2,a=t/r*Math.PI*2;n.push(Math.cos(i),Math.sin(i),1,Math.cos(a),Math.sin(a),1)}r.setAttribute("position",new Float32BufferAttribute(n,3));const i=new LineBasicMaterial({fog:!1,toneMapped:!1});this.cone=new LineSegments(r,i),this.add(this.cone),this.update()}dispose(){this.cone.geometry.dispose(),this.cone.material.dispose()}update(){this.light.updateWorldMatrix(!0,!1),this.light.target.updateWorldMatrix(!0,!1),this.parent?(this.parent.updateWorldMatrix(!0),this.matrix.copy(this.parent.matrixWorld).invert().multiply(this.light.matrixWorld)):this.matrix.copy(this.light.matrixWorld),this.matrixWorld.copy(this.light.matrixWorld);const e=this.light.distance?this.light.distance:1e3,t=e*Math.tan(this.light.angle);this.cone.scale.set(t,t,e),_vector$3.setFromMatrixPosition(this.light.target.matrixWorld),this.cone.lookAt(_vector$3),void 0!==this.color?this.cone.material.color.set(this.color):this.cone.material.color.copy(this.light.color)}}const _vector$2=new Vector3,_boneMatrix=new Matrix4,_matrixWorldInv=new Matrix4;class SkeletonHelper extends LineSegments{constructor(e){const t=getBoneList(e),r=new BufferGeometry,n=[],i=[],a=new Color(0,0,1),s=new Color(0,1,0);for(let e=0;e<t.length;e++){const r=t[e];r.parent&&r.parent.isBone&&(n.push(0,0,0),n.push(0,0,0),i.push(a.r,a.g,a.b),i.push(s.r,s.g,s.b))}r.setAttribute("position",new Float32BufferAttribute(n,3)),r.setAttribute("color",new Float32BufferAttribute(i,3));super(r,new LineBasicMaterial({vertexColors:!0,depthTest:!1,depthWrite:!1,toneMapped:!1,transparent:!0})),this.isSkeletonHelper=!0,this.type="SkeletonHelper",this.root=e,this.bones=t,this.matrix=e.matrixWorld,this.matrixAutoUpdate=!1}updateMatrixWorld(e){const t=this.bones,r=this.geometry,n=r.getAttribute("position");_matrixWorldInv.copy(this.root.matrixWorld).invert();for(let e=0,r=0;e<t.length;e++){const i=t[e];i.parent&&i.parent.isBone&&(_boneMatrix.multiplyMatrices(_matrixWorldInv,i.matrixWorld),_vector$2.setFromMatrixPosition(_boneMatrix),n.setXYZ(r,_vector$2.x,_vector$2.y,_vector$2.z),_boneMatrix.multiplyMatrices(_matrixWorldInv,i.parent.matrixWorld),_vector$2.setFromMatrixPosition(_boneMatrix),n.setXYZ(r+1,_vector$2.x,_vector$2.y,_vector$2.z),r+=2)}r.getAttribute("position").needsUpdate=!0,super.updateMatrixWorld(e)}dispose(){this.geometry.dispose(),this.material.dispose()}}function getBoneList(e){const t=[];!0===e.isBone&&t.push(e);for(let r=0;r<e.children.length;r++)t.push(...getBoneList(e.children[r]));return t}class PointLightHelper extends Mesh{constructor(e,t,r){super(new SphereGeometry(t,4,2),new MeshBasicMaterial({wireframe:!0,fog:!1,toneMapped:!1})),this.light=e,this.color=r,this.type="PointLightHelper",this.matrix=this.light.matrixWorld,this.matrixAutoUpdate=!1,this.update()}dispose(){this.geometry.dispose(),this.material.dispose()}update(){this.light.updateWorldMatrix(!0,!1),void 0!==this.color?this.material.color.set(this.color):this.material.color.copy(this.light.color)}}const _vector$1=new Vector3,_color1=new Color,_color2=new Color;class HemisphereLightHelper extends Object3D{constructor(e,t,r){super(),this.light=e,this.matrix=e.matrixWorld,this.matrixAutoUpdate=!1,this.color=r,this.type="HemisphereLightHelper";const n=new OctahedronGeometry(t);n.rotateY(.5*Math.PI),this.material=new MeshBasicMaterial({wireframe:!0,fog:!1,toneMapped:!1}),void 0===this.color&&(this.material.vertexColors=!0);const i=n.getAttribute("position"),a=new Float32Array(3*i.count);n.setAttribute("color",new BufferAttribute(a,3)),this.add(new Mesh(n,this.material)),this.update()}dispose(){this.children[0].geometry.dispose(),this.children[0].material.dispose()}update(){const e=this.children[0];if(void 0!==this.color)this.material.color.set(this.color);else{const t=e.geometry.getAttribute("color");_color1.copy(this.light.color),_color2.copy(this.light.groundColor);for(let e=0,r=t.count;e<r;e++){const n=e<r/2?_color1:_color2;t.setXYZ(e,n.r,n.g,n.b)}t.needsUpdate=!0}this.light.updateWorldMatrix(!0,!1),e.lookAt(_vector$1.setFromMatrixPosition(this.light.matrixWorld).negate())}}class GridHelper extends LineSegments{constructor(e=10,t=10,r=4473924,n=8947848){r=new Color(r),n=new Color(n);const i=t/2,a=e/t,s=e/2,o=[],l=[];for(let e=0,c=0,h=-s;e<=t;e++,h+=a){o.push(-s,0,h,s,0,h),o.push(h,0,-s,h,0,s);const t=e===i?r:n;t.toArray(l,c),c+=3,t.toArray(l,c),c+=3,t.toArray(l,c),c+=3,t.toArray(l,c),c+=3}const c=new BufferGeometry;c.setAttribute("position",new Float32BufferAttribute(o,3)),c.setAttribute("color",new Float32BufferAttribute(l,3));super(c,new LineBasicMaterial({vertexColors:!0,toneMapped:!1})),this.type="GridHelper"}dispose(){this.geometry.dispose(),this.material.dispose()}}class PolarGridHelper extends LineSegments{constructor(e=10,t=16,r=8,n=64,i=4473924,a=8947848){i=new Color(i),a=new Color(a);const s=[],o=[];if(t>1)for(let r=0;r<t;r++){const n=r/t*(2*Math.PI),l=Math.sin(n)*e,c=Math.cos(n)*e;s.push(0,0,0),s.push(l,0,c);const h=1&r?i:a;o.push(h.r,h.g,h.b),o.push(h.r,h.g,h.b)}for(let t=0;t<r;t++){const l=1&t?i:a,c=e-e/r*t;for(let e=0;e<n;e++){let t=e/n*(2*Math.PI),r=Math.sin(t)*c,i=Math.cos(t)*c;s.push(r,0,i),o.push(l.r,l.g,l.b),t=(e+1)/n*(2*Math.PI),r=Math.sin(t)*c,i=Math.cos(t)*c,s.push(r,0,i),o.push(l.r,l.g,l.b)}}const l=new BufferGeometry;l.setAttribute("position",new Float32BufferAttribute(s,3)),l.setAttribute("color",new Float32BufferAttribute(o,3));super(l,new LineBasicMaterial({vertexColors:!0,toneMapped:!1})),this.type="PolarGridHelper"}dispose(){this.geometry.dispose(),this.material.dispose()}}const _v1=new Vector3,_v2=new Vector3,_v3=new Vector3;class DirectionalLightHelper extends Object3D{constructor(e,t,r){super(),this.light=e,this.matrix=e.matrixWorld,this.matrixAutoUpdate=!1,this.color=r,this.type="DirectionalLightHelper",void 0===t&&(t=1);let n=new BufferGeometry;n.setAttribute("position",new Float32BufferAttribute([-t,t,0,t,t,0,t,-t,0,-t,-t,0,-t,t,0],3));const i=new LineBasicMaterial({fog:!1,toneMapped:!1});this.lightPlane=new Line(n,i),this.add(this.lightPlane),n=new BufferGeometry,n.setAttribute("position",new Float32BufferAttribute([0,0,0,0,0,1],3)),this.targetLine=new Line(n,i),this.add(this.targetLine),this.update()}dispose(){this.lightPlane.geometry.dispose(),this.lightPlane.material.dispose(),this.targetLine.geometry.dispose(),this.targetLine.material.dispose()}update(){this.light.updateWorldMatrix(!0,!1),this.light.target.updateWorldMatrix(!0,!1),_v1.setFromMatrixPosition(this.light.matrixWorld),_v2.setFromMatrixPosition(this.light.target.matrixWorld),_v3.subVectors(_v2,_v1),this.lightPlane.lookAt(_v2),void 0!==this.color?(this.lightPlane.material.color.set(this.color),this.targetLine.material.color.set(this.color)):(this.lightPlane.material.color.copy(this.light.color),this.targetLine.material.color.copy(this.light.color)),this.targetLine.lookAt(_v2),this.targetLine.scale.z=_v3.length()}}const _vector=new Vector3,_camera=new Camera;class CameraHelper extends LineSegments{constructor(e){const t=new BufferGeometry,r=new LineBasicMaterial({color:16777215,vertexColors:!0,toneMapped:!1}),n=[],i=[],a={};function s(e,t){o(e),o(t)}function o(e){n.push(0,0,0),i.push(0,0,0),void 0===a[e]&&(a[e]=[]),a[e].push(n.length/3-1)}s("n1","n2"),s("n2","n4"),s("n4","n3"),s("n3","n1"),s("f1","f2"),s("f2","f4"),s("f4","f3"),s("f3","f1"),s("n1","f1"),s("n2","f2"),s("n3","f3"),s("n4","f4"),s("p","n1"),s("p","n2"),s("p","n3"),s("p","n4"),s("u1","u2"),s("u2","u3"),s("u3","u1"),s("c","t"),s("p","c"),s("cn1","cn2"),s("cn3","cn4"),s("cf1","cf2"),s("cf3","cf4"),t.setAttribute("position",new Float32BufferAttribute(n,3)),t.setAttribute("color",new Float32BufferAttribute(i,3)),super(t,r),this.type="CameraHelper",this.camera=e,this.camera.updateProjectionMatrix&&this.camera.updateProjectionMatrix(),this.matrix=e.matrixWorld,this.matrixAutoUpdate=!1,this.pointMap=a,this.update();const l=new Color(16755200),c=new Color(16711680),h=new Color(43775),u=new Color(16777215),d=new Color(3355443);this.setColors(l,c,h,u,d)}setColors(e,t,r,n,i){const a=this.geometry.getAttribute("color");a.setXYZ(0,e.r,e.g,e.b),a.setXYZ(1,e.r,e.g,e.b),a.setXYZ(2,e.r,e.g,e.b),a.setXYZ(3,e.r,e.g,e.b),a.setXYZ(4,e.r,e.g,e.b),a.setXYZ(5,e.r,e.g,e.b),a.setXYZ(6,e.r,e.g,e.b),a.setXYZ(7,e.r,e.g,e.b),a.setXYZ(8,e.r,e.g,e.b),a.setXYZ(9,e.r,e.g,e.b),a.setXYZ(10,e.r,e.g,e.b),a.setXYZ(11,e.r,e.g,e.b),a.setXYZ(12,e.r,e.g,e.b),a.setXYZ(13,e.r,e.g,e.b),a.setXYZ(14,e.r,e.g,e.b),a.setXYZ(15,e.r,e.g,e.b),a.setXYZ(16,e.r,e.g,e.b),a.setXYZ(17,e.r,e.g,e.b),a.setXYZ(18,e.r,e.g,e.b),a.setXYZ(19,e.r,e.g,e.b),a.setXYZ(20,e.r,e.g,e.b),a.setXYZ(21,e.r,e.g,e.b),a.setXYZ(22,e.r,e.g,e.b),a.setXYZ(23,e.r,e.g,e.b),a.setXYZ(24,t.r,t.g,t.b),a.setXYZ(25,t.r,t.g,t.b),a.setXYZ(26,t.r,t.g,t.b),a.setXYZ(27,t.r,t.g,t.b),a.setXYZ(28,t.r,t.g,t.b),a.setXYZ(29,t.r,t.g,t.b),a.setXYZ(30,t.r,t.g,t.b),a.setXYZ(31,t.r,t.g,t.b),a.setXYZ(32,r.r,r.g,r.b),a.setXYZ(33,r.r,r.g,r.b),a.setXYZ(34,r.r,r.g,r.b),a.setXYZ(35,r.r,r.g,r.b),a.setXYZ(36,r.r,r.g,r.b),a.setXYZ(37,r.r,r.g,r.b),a.setXYZ(38,n.r,n.g,n.b),a.setXYZ(39,n.r,n.g,n.b),a.setXYZ(40,i.r,i.g,i.b),a.setXYZ(41,i.r,i.g,i.b),a.setXYZ(42,i.r,i.g,i.b),a.setXYZ(43,i.r,i.g,i.b),a.setXYZ(44,i.r,i.g,i.b),a.setXYZ(45,i.r,i.g,i.b),a.setXYZ(46,i.r,i.g,i.b),a.setXYZ(47,i.r,i.g,i.b),a.setXYZ(48,i.r,i.g,i.b),a.setXYZ(49,i.r,i.g,i.b),a.needsUpdate=!0}update(){const e=this.geometry,t=this.pointMap;_camera.projectionMatrixInverse.copy(this.camera.projectionMatrixInverse);const r=2e3===this.camera.coordinateSystem?-1:0;setPoint("c",t,e,_camera,0,0,r),setPoint("t",t,e,_camera,0,0,1),setPoint("n1",t,e,_camera,-1,-1,r),setPoint("n2",t,e,_camera,1,-1,r),setPoint("n3",t,e,_camera,-1,1,r),setPoint("n4",t,e,_camera,1,1,r),setPoint("f1",t,e,_camera,-1,-1,1),setPoint("f2",t,e,_camera,1,-1,1),setPoint("f3",t,e,_camera,-1,1,1),setPoint("f4",t,e,_camera,1,1,1),setPoint("u1",t,e,_camera,.7,1.1,r),setPoint("u2",t,e,_camera,-.7,1.1,r),setPoint("u3",t,e,_camera,0,2,r),setPoint("cf1",t,e,_camera,-1,0,1),setPoint("cf2",t,e,_camera,1,0,1),setPoint("cf3",t,e,_camera,0,-1,1),setPoint("cf4",t,e,_camera,0,1,1),setPoint("cn1",t,e,_camera,-1,0,r),setPoint("cn2",t,e,_camera,1,0,r),setPoint("cn3",t,e,_camera,0,-1,r),setPoint("cn4",t,e,_camera,0,1,r),e.getAttribute("position").needsUpdate=!0}dispose(){this.geometry.dispose(),this.material.dispose()}}function setPoint(e,t,r,n,i,a,s){_vector.set(i,a,s).unproject(n);const o=t[e];if(void 0!==o){const e=r.getAttribute("position");for(let t=0,r=o.length;t<r;t++)e.setXYZ(o[t],_vector.x,_vector.y,_vector.z)}}const _box=new Box3;class BoxHelper extends LineSegments{constructor(e,t=16776960){const r=new Uint16Array([0,1,1,2,2,3,3,0,4,5,5,6,6,7,7,4,0,4,1,5,2,6,3,7]),n=new Float32Array(24),i=new BufferGeometry;i.setIndex(new BufferAttribute(r,1)),i.setAttribute("position",new BufferAttribute(n,3)),super(i,new LineBasicMaterial({color:t,toneMapped:!1})),this.object=e,this.type="BoxHelper",this.matrixAutoUpdate=!1,this.update()}update(){if(void 0!==this.object&&_box.setFromObject(this.object),_box.isEmpty())return;const e=_box.min,t=_box.max,r=this.geometry.attributes.position,n=r.array;n[0]=t.x,n[1]=t.y,n[2]=t.z,n[3]=e.x,n[4]=t.y,n[5]=t.z,n[6]=e.x,n[7]=e.y,n[8]=t.z,n[9]=t.x,n[10]=e.y,n[11]=t.z,n[12]=t.x,n[13]=t.y,n[14]=e.z,n[15]=e.x,n[16]=t.y,n[17]=e.z,n[18]=e.x,n[19]=e.y,n[20]=e.z,n[21]=t.x,n[22]=e.y,n[23]=e.z,r.needsUpdate=!0,this.geometry.computeBoundingSphere()}setFromObject(e){return this.object=e,this.update(),this}copy(e,t){return super.copy(e,t),this.object=e.object,this}dispose(){this.geometry.dispose(),this.material.dispose()}}class Box3Helper extends LineSegments{constructor(e,t=16776960){const r=new Uint16Array([0,1,1,2,2,3,3,0,4,5,5,6,6,7,7,4,0,4,1,5,2,6,3,7]),n=new BufferGeometry;n.setIndex(new BufferAttribute(r,1)),n.setAttribute("position",new Float32BufferAttribute([1,1,1,-1,1,1,-1,-1,1,1,-1,1,1,1,-1,-1,1,-1,-1,-1,-1,1,-1,-1],3)),super(n,new LineBasicMaterial({color:t,toneMapped:!1})),this.box=e,this.type="Box3Helper",this.geometry.computeBoundingSphere()}updateMatrixWorld(e){const t=this.box;t.isEmpty()||(t.getCenter(this.position),t.getSize(this.scale),this.scale.multiplyScalar(.5),super.updateMatrixWorld(e))}dispose(){this.geometry.dispose(),this.material.dispose()}}class PlaneHelper extends Line{constructor(e,t=1,r=16776960){const n=r,i=new BufferGeometry;i.setAttribute("position",new Float32BufferAttribute([1,-1,0,-1,1,0,-1,-1,0,1,1,0,-1,1,0,-1,-1,0,1,-1,0,1,1,0],3)),i.computeBoundingSphere(),super(i,new LineBasicMaterial({color:n,toneMapped:!1})),this.type="PlaneHelper",this.plane=e,this.size=t;const a=new BufferGeometry;a.setAttribute("position",new Float32BufferAttribute([1,1,0,-1,1,0,-1,-1,0,1,1,0,-1,-1,0,1,-1,0],3)),a.computeBoundingSphere(),this.add(new Mesh(a,new MeshBasicMaterial({color:n,opacity:.2,transparent:!0,depthWrite:!1,toneMapped:!1})))}updateMatrixWorld(e){this.position.set(0,0,0),this.scale.set(.5*this.size,.5*this.size,1),this.lookAt(this.plane.normal),this.translateZ(-this.plane.constant),super.updateMatrixWorld(e)}dispose(){this.geometry.dispose(),this.material.dispose(),this.children[0].geometry.dispose(),this.children[0].material.dispose()}}const _axis=new Vector3;let _lineGeometry,_coneGeometry;class ArrowHelper extends Object3D{constructor(e=new Vector3(0,0,1),t=new Vector3(0,0,0),r=1,n=16776960,i=.2*r,a=.2*i){super(),this.type="ArrowHelper",void 0===_lineGeometry&&(_lineGeometry=new BufferGeometry,_lineGeometry.setAttribute("position",new Float32BufferAttribute([0,0,0,0,1,0],3)),_coneGeometry=new ConeGeometry(.5,1,5,1),_coneGeometry.translate(0,-.5,0)),this.position.copy(t),this.line=new Line(_lineGeometry,new LineBasicMaterial({color:n,toneMapped:!1})),this.line.matrixAutoUpdate=!1,this.add(this.line),this.cone=new Mesh(_coneGeometry,new MeshBasicMaterial({color:n,toneMapped:!1})),this.cone.matrixAutoUpdate=!1,this.add(this.cone),this.setDirection(e),this.setLength(r,i,a)}setDirection(e){if(e.y>.99999)this.quaternion.set(0,0,0,1);else if(e.y<-.99999)this.quaternion.set(1,0,0,0);else{_axis.set(e.z,0,-e.x).normalize();const t=Math.acos(e.y);this.quaternion.setFromAxisAngle(_axis,t)}}setLength(e,t=.2*e,r=.2*t){this.line.scale.set(1,Math.max(1e-4,e-t),1),this.line.updateMatrix(),this.cone.scale.set(r,t,r),this.cone.position.y=e,this.cone.updateMatrix()}setColor(e){this.line.material.color.set(e),this.cone.material.color.set(e)}copy(e){return super.copy(e,!1),this.line.copy(e.line),this.cone.copy(e.cone),this}dispose(){this.line.geometry.dispose(),this.line.material.dispose(),this.cone.geometry.dispose(),this.cone.material.dispose()}}class AxesHelper extends LineSegments{constructor(e=1){const t=[0,0,0,e,0,0,0,0,0,0,e,0,0,0,0,0,0,e],r=new BufferGeometry;r.setAttribute("position",new Float32BufferAttribute(t,3)),r.setAttribute("color",new Float32BufferAttribute([1,0,0,1,.6,0,0,1,0,.6,1,0,0,0,1,0,.6,1],3));super(r,new LineBasicMaterial({vertexColors:!0,toneMapped:!1})),this.type="AxesHelper"}setColors(e,t,r){const n=new Color,i=this.geometry.attributes.color.array;return n.set(e),n.toArray(i,0),n.toArray(i,3),n.set(t),n.toArray(i,6),n.toArray(i,9),n.set(r),n.toArray(i,12),n.toArray(i,15),this.geometry.attributes.color.needsUpdate=!0,this}dispose(){this.geometry.dispose(),this.material.dispose()}}class ShapePath{constructor(){this.type="ShapePath",this.color=new Color,this.subPaths=[],this.currentPath=null}moveTo(e,t){return this.currentPath=new Path,this.subPaths.push(this.currentPath),this.currentPath.moveTo(e,t),this}lineTo(e,t){return this.currentPath.lineTo(e,t),this}quadraticCurveTo(e,t,r,n){return this.currentPath.quadraticCurveTo(e,t,r,n),this}bezierCurveTo(e,t,r,n,i,a){return this.currentPath.bezierCurveTo(e,t,r,n,i,a),this}splineThru(e){return this.currentPath.splineThru(e),this}toShapes(e){function t(e,t){const r=t.length;let n=!1;for(let i=r-1,a=0;a<r;i=a++){let r=t[i],s=t[a],o=s.x-r.x,l=s.y-r.y;if(Math.abs(l)>Number.EPSILON){if(l<0&&(r=t[a],o=-o,s=t[i],l=-l),e.y<r.y||e.y>s.y)continue;if(e.y===r.y){if(e.x===r.x)return!0}else{const t=l*(e.x-r.x)-o*(e.y-r.y);if(0===t)return!0;if(t<0)continue;n=!n}}else{if(e.y!==r.y)continue;if(s.x<=e.x&&e.x<=r.x||r.x<=e.x&&e.x<=s.x)return!0}}return n}const r=ShapeUtils.isClockWise,n=this.subPaths;if(0===n.length)return[];let i,a,s;const o=[];if(1===n.length)return a=n[0],s=new Shape,s.curves=a.curves,o.push(s),o;let l=!r(n[0].getPoints());l=e?!l:l;const c=[],h=[];let u,d,p=[],m=0;h[m]=void 0,p[m]=[];for(let t=0,s=n.length;t<s;t++)a=n[t],u=a.getPoints(),i=r(u),i=e?!i:i,i?(!l&&h[m]&&m++,h[m]={s:new Shape,p:u},h[m].s.curves=a.curves,l&&m++,p[m]=[]):p[m].push({h:a,p:u[0]});if(!h[0])return function(e){const t=[];for(let r=0,n=e.length;r<n;r++){const n=e[r],i=new Shape;i.curves=n.curves,t.push(i)}return t}(n);if(h.length>1){let e=!1,r=0;for(let e=0,t=h.length;e<t;e++)c[e]=[];for(let n=0,i=h.length;n<i;n++){const i=p[n];for(let a=0;a<i.length;a++){const s=i[a];let o=!0;for(let i=0;i<h.length;i++)t(s.p,h[i].p)&&(n!==i&&r++,o?(o=!1,c[i].push(s)):e=!0);o&&c[n].push(s)}}r>0&&!1===e&&(p=c)}for(let e=0,t=h.length;e<t;e++){s=h[e].s,o.push(s),d=p[e];for(let e=0,t=d.length;e<t;e++)s.holes.push(d[e].h)}return o}}class Controls extends EventDispatcher{constructor(e,t=null){super(),this.object=e,this.domElement=t,this.enabled=!0,this.state=-1,this.keys={},this.mouseButtons={LEFT:null,MIDDLE:null,RIGHT:null},this.touches={ONE:null,TWO:null}}connect(e){void 0!==e?(null!==this.domElement&&this.disconnect(),this.domElement=e):console.warn("THREE.Controls: connect() now requires an element.")}disconnect(){}dispose(){}update(){}}function contain(e,t){const r=e.image&&e.image.width?e.image.width/e.image.height:1;return r>t?(e.repeat.x=1,e.repeat.y=r/t,e.offset.x=0,e.offset.y=(1-e.repeat.y)/2):(e.repeat.x=t/r,e.repeat.y=1,e.offset.x=(1-e.repeat.x)/2,e.offset.y=0),e}function cover(e,t){const r=e.image&&e.image.width?e.image.width/e.image.height:1;return r>t?(e.repeat.x=t/r,e.repeat.y=1,e.offset.x=(1-e.repeat.x)/2,e.offset.y=0):(e.repeat.x=1,e.repeat.y=r/t,e.offset.x=0,e.offset.y=(1-e.repeat.y)/2),e}function fill(e){return e.repeat.x=1,e.repeat.y=1,e.offset.x=0,e.offset.y=0,e}function getByteLength(e,t,r,n){const i=getTextureTypeByteLength(n);switch(r){case 1021:return e*t;case 1028:case 1029:return e*t/i.components*i.byteLength;case 1030:case 1031:return e*t*2/i.components*i.byteLength;case 1022:return e*t*3/i.components*i.byteLength;case 1023:case 1033:return e*t*4/i.components*i.byteLength;case 33776:case 33777:case 36196:case 37492:return Math.floor((e+3)/4)*Math.floor((t+3)/4)*8;case 33778:case 33779:case 37496:case 37808:return Math.floor((e+3)/4)*Math.floor((t+3)/4)*16;case 35841:case 35843:return Math.max(e,16)*Math.max(t,8)/4;case 35840:case 35842:return Math.max(e,8)*Math.max(t,8)/2;case 37809:return Math.floor((e+4)/5)*Math.floor((t+3)/4)*16;case 37810:return Math.floor((e+4)/5)*Math.floor((t+4)/5)*16;case 37811:return Math.floor((e+5)/6)*Math.floor((t+4)/5)*16;case 37812:return Math.floor((e+5)/6)*Math.floor((t+5)/6)*16;case 37813:return Math.floor((e+7)/8)*Math.floor((t+4)/5)*16;case 37814:return Math.floor((e+7)/8)*Math.floor((t+5)/6)*16;case 37815:return Math.floor((e+7)/8)*Math.floor((t+7)/8)*16;case 37816:return Math.floor((e+9)/10)*Math.floor((t+4)/5)*16;case 37817:return Math.floor((e+9)/10)*Math.floor((t+5)/6)*16;case 37818:return Math.floor((e+9)/10)*Math.floor((t+7)/8)*16;case 37819:return Math.floor((e+9)/10)*Math.floor((t+9)/10)*16;case 37820:return Math.floor((e+11)/12)*Math.floor((t+9)/10)*16;case 37821:return Math.floor((e+11)/12)*Math.floor((t+11)/12)*16;case 36492:case 36494:case 36495:case 36285:case 36286:return Math.ceil(e/4)*Math.ceil(t/4)*16;case 36283:case 36284:return Math.ceil(e/4)*Math.ceil(t/4)*8}throw new Error(`Unable to determine texture byte length for ${r} format.`)}function getTextureTypeByteLength(e){switch(e){case 1009:case 1010:return{byteLength:1,components:1};case 1012:case 1011:case 1016:return{byteLength:2,components:1};case 1017:case 1018:return{byteLength:2,components:4};case 1014:case 1013:case 1015:return{byteLength:4,components:1};case 35902:return{byteLength:4,components:3}}throw new Error(`Unknown texture type ${e}.`)}class TextureUtils{static contain(e,t){return contain(e,t)}static cover(e,t){return cover(e,t)}static fill(e){return fill(e)}static getByteLength(e,t,r,n){return getByteLength(e,t,r,n)}}function WebGLAnimation(){let e=null,t=!1,r=null,n=null;function i(t,a){r(t,a),n=e.requestAnimationFrame(i)}return{start:function(){!0!==t&&null!==r&&(n=e.requestAnimationFrame(i),t=!0)},stop:function(){e.cancelAnimationFrame(n),t=!1},setAnimationLoop:function(e){r=e},setContext:function(t){e=t}}}function WebGLAttributes(e){const t=new WeakMap;return{get:function(e){return e.isInterleavedBufferAttribute&&(e=e.data),t.get(e)},remove:function(r){r.isInterleavedBufferAttribute&&(r=r.data);const n=t.get(r);n&&(e.deleteBuffer(n.buffer),t.delete(r))},update:function(r,n){if(r.isInterleavedBufferAttribute&&(r=r.data),r.isGLBufferAttribute){const e=t.get(r);return void((!e||e.version<r.version)&&t.set(r,{buffer:r.buffer,type:r.type,bytesPerElement:r.elementSize,version:r.version}))}const i=t.get(r);if(void 0===i)t.set(r,function(t,r){const n=t.array,i=t.usage,a=n.byteLength,s=e.createBuffer();let o;if(e.bindBuffer(r,s),e.bufferData(r,n,i),t.onUploadCallback(),n instanceof Float32Array)o=e.FLOAT;else if(n instanceof Uint16Array)o=t.isFloat16BufferAttribute?e.HALF_FLOAT:e.UNSIGNED_SHORT;else if(n instanceof Int16Array)o=e.SHORT;else if(n instanceof Uint32Array)o=e.UNSIGNED_INT;else if(n instanceof Int32Array)o=e.INT;else if(n instanceof Int8Array)o=e.BYTE;else if(n instanceof Uint8Array)o=e.UNSIGNED_BYTE;else{if(!(n instanceof Uint8ClampedArray))throw new Error("THREE.WebGLAttributes: Unsupported buffer data format: "+n);o=e.UNSIGNED_BYTE}return{buffer:s,type:o,bytesPerElement:n.BYTES_PER_ELEMENT,version:t.version,size:a}}(r,n));else if(i.version<r.version){if(i.size!==r.array.byteLength)throw new Error("THREE.WebGLAttributes: The size of the buffer attribute's array buffer does not match the original size. Resizing buffer attributes is not supported.");!function(t,r,n){const i=r.array,a=r.updateRanges;if(e.bindBuffer(n,t),0===a.length)e.bufferSubData(n,0,i);else{a.sort(((e,t)=>e.start-t.start));let t=0;for(let e=1;e<a.length;e++){const r=a[t],n=a[e];n.start<=r.start+r.count+1?r.count=Math.max(r.count,n.start+n.count-r.start):(++t,a[t]=n)}a.length=t+1;for(let t=0,r=a.length;t<r;t++){const r=a[t];e.bufferSubData(n,r.start*i.BYTES_PER_ELEMENT,i,r.start,r.count)}r.clearUpdateRanges()}r.onUploadCallback()}(i.buffer,r,n),i.version=r.version}}}}"undefined"!=typeof __THREE_DEVTOOLS__&&__THREE_DEVTOOLS__.dispatchEvent(new CustomEvent("register",{detail:{revision:"176"}})),"undefined"!=typeof window&&(window.__THREE__?console.warn("WARNING: Multiple instances of Three.js being imported."):window.__THREE__="176");var alphahash_fragment="#ifdef USE_ALPHAHASH\n\tif ( diffuseColor.a < getAlphaHashThreshold( vPosition ) ) discard;\n#endif",alphahash_pars_fragment="#ifdef USE_ALPHAHASH\n\tconst float ALPHA_HASH_SCALE = 0.05;\n\tfloat hash2D( vec2 value ) {\n\t\treturn fract( 1.0e4 * sin( 17.0 * value.x + 0.1 * value.y ) * ( 0.1 + abs( sin( 13.0 * value.y + value.x ) ) ) );\n\t}\n\tfloat hash3D( vec3 value ) {\n\t\treturn hash2D( vec2( hash2D( value.xy ), value.z ) );\n\t}\n\tfloat getAlphaHashThreshold( vec3 position ) {\n\t\tfloat maxDeriv = max(\n\t\t\tlength( dFdx( position.xyz ) ),\n\t\t\tlength( dFdy( position.xyz ) )\n\t\t);\n\t\tfloat pixScale = 1.0 / ( ALPHA_HASH_SCALE * maxDeriv );\n\t\tvec2 pixScales = vec2(\n\t\t\texp2( floor( log2( pixScale ) ) ),\n\t\t\texp2( ceil( log2( pixScale ) ) )\n\t\t);\n\t\tvec2 alpha = vec2(\n\t\t\thash3D( floor( pixScales.x * position.xyz ) ),\n\t\t\thash3D( floor( pixScales.y * position.xyz ) )\n\t\t);\n\t\tfloat lerpFactor = fract( log2( pixScale ) );\n\t\tfloat x = ( 1.0 - lerpFactor ) * alpha.x + lerpFactor * alpha.y;\n\t\tfloat a = min( lerpFactor, 1.0 - lerpFactor );\n\t\tvec3 cases = vec3(\n\t\t\tx * x / ( 2.0 * a * ( 1.0 - a ) ),\n\t\t\t( x - 0.5 * a ) / ( 1.0 - a ),\n\t\t\t1.0 - ( ( 1.0 - x ) * ( 1.0 - x ) / ( 2.0 * a * ( 1.0 - a ) ) )\n\t\t);\n\t\tfloat threshold = ( x < ( 1.0 - a ) )\n\t\t\t? ( ( x < a ) ? cases.x : cases.y )\n\t\t\t: cases.z;\n\t\treturn clamp( threshold , 1.0e-6, 1.0 );\n\t}\n#endif",alphamap_fragment="#ifdef USE_ALPHAMAP\n\tdiffuseColor.a *= texture2D( alphaMap, vAlphaMapUv ).g;\n#endif",alphamap_pars_fragment="#ifdef USE_ALPHAMAP\n\tuniform sampler2D alphaMap;\n#endif",alphatest_fragment="#ifdef USE_ALPHATEST\n\t#ifdef ALPHA_TO_COVERAGE\n\tdiffuseColor.a = smoothstep( alphaTest, alphaTest + fwidth( diffuseColor.a ), diffuseColor.a );\n\tif ( diffuseColor.a == 0.0 ) discard;\n\t#else\n\tif ( diffuseColor.a < alphaTest ) discard;\n\t#endif\n#endif",alphatest_pars_fragment="#ifdef USE_ALPHATEST\n\tuniform float alphaTest;\n#endif",aomap_fragment="#ifdef USE_AOMAP\n\tfloat ambientOcclusion = ( texture2D( aoMap, vAoMapUv ).r - 1.0 ) * aoMapIntensity + 1.0;\n\treflectedLight.indirectDiffuse *= ambientOcclusion;\n\t#if defined( USE_CLEARCOAT ) \n\t\tclearcoatSpecularIndirect *= ambientOcclusion;\n\t#endif\n\t#if defined( USE_SHEEN ) \n\t\tsheenSpecularIndirect *= ambientOcclusion;\n\t#endif\n\t#if defined( USE_ENVMAP ) && defined( STANDARD )\n\t\tfloat dotNV = saturate( dot( geometryNormal, geometryViewDir ) );\n\t\treflectedLight.indirectSpecular *= computeSpecularOcclusion( dotNV, ambientOcclusion, material.roughness );\n\t#endif\n#endif",aomap_pars_fragment="#ifdef USE_AOMAP\n\tuniform sampler2D aoMap;\n\tuniform float aoMapIntensity;\n#endif",batching_pars_vertex="#ifdef USE_BATCHING\n\t#if ! defined( GL_ANGLE_multi_draw )\n\t#define gl_DrawID _gl_DrawID\n\tuniform int _gl_DrawID;\n\t#endif\n\tuniform highp sampler2D batchingTexture;\n\tuniform highp usampler2D batchingIdTexture;\n\tmat4 getBatchingMatrix( const in float i ) {\n\t\tint size = textureSize( batchingTexture, 0 ).x;\n\t\tint j = int( i ) * 4;\n\t\tint x = j % size;\n\t\tint y = j / size;\n\t\tvec4 v1 = texelFetch( batchingTexture, ivec2( x, y ), 0 );\n\t\tvec4 v2 = texelFetch( batchingTexture, ivec2( x + 1, y ), 0 );\n\t\tvec4 v3 = texelFetch( batchingTexture, ivec2( x + 2, y ), 0 );\n\t\tvec4 v4 = texelFetch( batchingTexture, ivec2( x + 3, y ), 0 );\n\t\treturn mat4( v1, v2, v3, v4 );\n\t}\n\tfloat getIndirectIndex( const in int i ) {\n\t\tint size = textureSize( batchingIdTexture, 0 ).x;\n\t\tint x = i % size;\n\t\tint y = i / size;\n\t\treturn float( texelFetch( batchingIdTexture, ivec2( x, y ), 0 ).r );\n\t}\n#endif\n#ifdef USE_BATCHING_COLOR\n\tuniform sampler2D batchingColorTexture;\n\tvec3 getBatchingColor( const in float i ) {\n\t\tint size = textureSize( batchingColorTexture, 0 ).x;\n\t\tint j = int( i );\n\t\tint x = j % size;\n\t\tint y = j / size;\n\t\treturn texelFetch( batchingColorTexture, ivec2( x, y ), 0 ).rgb;\n\t}\n#endif",batching_vertex="#ifdef USE_BATCHING\n\tmat4 batchingMatrix = getBatchingMatrix( getIndirectIndex( gl_DrawID ) );\n#endif",begin_vertex="vec3 transformed = vec3( position );\n#ifdef USE_ALPHAHASH\n\tvPosition = vec3( position );\n#endif",beginnormal_vertex="vec3 objectNormal = vec3( normal );\n#ifdef USE_TANGENT\n\tvec3 objectTangent = vec3( tangent.xyz );\n#endif",bsdfs="float G_BlinnPhong_Implicit( ) {\n\treturn 0.25;\n}\nfloat D_BlinnPhong( const in float shininess, const in float dotNH ) {\n\treturn RECIPROCAL_PI * ( shininess * 0.5 + 1.0 ) * pow( dotNH, shininess );\n}\nvec3 BRDF_BlinnPhong( const in vec3 lightDir, const in vec3 viewDir, const in vec3 normal, const in vec3 specularColor, const in float shininess ) {\n\tvec3 halfDir = normalize( lightDir + viewDir );\n\tfloat dotNH = saturate( dot( normal, halfDir ) );\n\tfloat dotVH = saturate( dot( viewDir, halfDir ) );\n\tvec3 F = F_Schlick( specularColor, 1.0, dotVH );\n\tfloat G = G_BlinnPhong_Implicit( );\n\tfloat D = D_BlinnPhong( shininess, dotNH );\n\treturn F * ( G * D );\n} // validated",iridescence_fragment="#ifdef USE_IRIDESCENCE\n\tconst mat3 XYZ_TO_REC709 = mat3(\n\t\t 3.2404542, -0.9692660,  0.0556434,\n\t\t-1.5371385,  1.8760108, -0.2040259,\n\t\t-0.4985314,  0.0415560,  1.0572252\n\t);\n\tvec3 Fresnel0ToIor( vec3 fresnel0 ) {\n\t\tvec3 sqrtF0 = sqrt( fresnel0 );\n\t\treturn ( vec3( 1.0 ) + sqrtF0 ) / ( vec3( 1.0 ) - sqrtF0 );\n\t}\n\tvec3 IorToFresnel0( vec3 transmittedIor, float incidentIor ) {\n\t\treturn pow2( ( transmittedIor - vec3( incidentIor ) ) / ( transmittedIor + vec3( incidentIor ) ) );\n\t}\n\tfloat IorToFresnel0( float transmittedIor, float incidentIor ) {\n\t\treturn pow2( ( transmittedIor - incidentIor ) / ( transmittedIor + incidentIor ));\n\t}\n\tvec3 evalSensitivity( float OPD, vec3 shift ) {\n\t\tfloat phase = 2.0 * PI * OPD * 1.0e-9;\n\t\tvec3 val = vec3( 5.4856e-13, 4.4201e-13, 5.2481e-13 );\n\t\tvec3 pos = vec3( 1.6810e+06, 1.7953e+06, 2.2084e+06 );\n\t\tvec3 var = vec3( 4.3278e+09, 9.3046e+09, 6.6121e+09 );\n\t\tvec3 xyz = val * sqrt( 2.0 * PI * var ) * cos( pos * phase + shift ) * exp( - pow2( phase ) * var );\n\t\txyz.x += 9.7470e-14 * sqrt( 2.0 * PI * 4.5282e+09 ) * cos( 2.2399e+06 * phase + shift[ 0 ] ) * exp( - 4.5282e+09 * pow2( phase ) );\n\t\txyz /= 1.0685e-7;\n\t\tvec3 rgb = XYZ_TO_REC709 * xyz;\n\t\treturn rgb;\n\t}\n\tvec3 evalIridescence( float outsideIOR, float eta2, float cosTheta1, float thinFilmThickness, vec3 baseF0 ) {\n\t\tvec3 I;\n\t\tfloat iridescenceIOR = mix( outsideIOR, eta2, smoothstep( 0.0, 0.03, thinFilmThickness ) );\n\t\tfloat sinTheta2Sq = pow2( outsideIOR / iridescenceIOR ) * ( 1.0 - pow2( cosTheta1 ) );\n\t\tfloat cosTheta2Sq = 1.0 - sinTheta2Sq;\n\t\tif ( cosTheta2Sq < 0.0 ) {\n\t\t\treturn vec3( 1.0 );\n\t\t}\n\t\tfloat cosTheta2 = sqrt( cosTheta2Sq );\n\t\tfloat R0 = IorToFresnel0( iridescenceIOR, outsideIOR );\n\t\tfloat R12 = F_Schlick( R0, 1.0, cosTheta1 );\n\t\tfloat T121 = 1.0 - R12;\n\t\tfloat phi12 = 0.0;\n\t\tif ( iridescenceIOR < outsideIOR ) phi12 = PI;\n\t\tfloat phi21 = PI - phi12;\n\t\tvec3 baseIOR = Fresnel0ToIor( clamp( baseF0, 0.0, 0.9999 ) );\t\tvec3 R1 = IorToFresnel0( baseIOR, iridescenceIOR );\n\t\tvec3 R23 = F_Schlick( R1, 1.0, cosTheta2 );\n\t\tvec3 phi23 = vec3( 0.0 );\n\t\tif ( baseIOR[ 0 ] < iridescenceIOR ) phi23[ 0 ] = PI;\n\t\tif ( baseIOR[ 1 ] < iridescenceIOR ) phi23[ 1 ] = PI;\n\t\tif ( baseIOR[ 2 ] < iridescenceIOR ) phi23[ 2 ] = PI;\n\t\tfloat OPD = 2.0 * iridescenceIOR * thinFilmThickness * cosTheta2;\n\t\tvec3 phi = vec3( phi21 ) + phi23;\n\t\tvec3 R123 = clamp( R12 * R23, 1e-5, 0.9999 );\n\t\tvec3 r123 = sqrt( R123 );\n\t\tvec3 Rs = pow2( T121 ) * R23 / ( vec3( 1.0 ) - R123 );\n\t\tvec3 C0 = R12 + Rs;\n\t\tI = C0;\n\t\tvec3 Cm = Rs - T121;\n\t\tfor ( int m = 1; m <= 2; ++ m ) {\n\t\t\tCm *= r123;\n\t\t\tvec3 Sm = 2.0 * evalSensitivity( float( m ) * OPD, float( m ) * phi );\n\t\t\tI += Cm * Sm;\n\t\t}\n\t\treturn max( I, vec3( 0.0 ) );\n\t}\n#endif",bumpmap_pars_fragment="#ifdef USE_BUMPMAP\n\tuniform sampler2D bumpMap;\n\tuniform float bumpScale;\n\tvec2 dHdxy_fwd() {\n\t\tvec2 dSTdx = dFdx( vBumpMapUv );\n\t\tvec2 dSTdy = dFdy( vBumpMapUv );\n\t\tfloat Hll = bumpScale * texture2D( bumpMap, vBumpMapUv ).x;\n\t\tfloat dBx = bumpScale * texture2D( bumpMap, vBumpMapUv + dSTdx ).x - Hll;\n\t\tfloat dBy = bumpScale * texture2D( bumpMap, vBumpMapUv + dSTdy ).x - Hll;\n\t\treturn vec2( dBx, dBy );\n\t}\n\tvec3 perturbNormalArb( vec3 surf_pos, vec3 surf_norm, vec2 dHdxy, float faceDirection ) {\n\t\tvec3 vSigmaX = normalize( dFdx( surf_pos.xyz ) );\n\t\tvec3 vSigmaY = normalize( dFdy( surf_pos.xyz ) );\n\t\tvec3 vN = surf_norm;\n\t\tvec3 R1 = cross( vSigmaY, vN );\n\t\tvec3 R2 = cross( vN, vSigmaX );\n\t\tfloat fDet = dot( vSigmaX, R1 ) * faceDirection;\n\t\tvec3 vGrad = sign( fDet ) * ( dHdxy.x * R1 + dHdxy.y * R2 );\n\t\treturn normalize( abs( fDet ) * surf_norm - vGrad );\n\t}\n#endif",clipping_planes_fragment="#if NUM_CLIPPING_PLANES > 0\n\tvec4 plane;\n\t#ifdef ALPHA_TO_COVERAGE\n\t\tfloat distanceToPlane, distanceGradient;\n\t\tfloat clipOpacity = 1.0;\n\t\t#pragma unroll_loop_start\n\t\tfor ( int i = 0; i < UNION_CLIPPING_PLANES; i ++ ) {\n\t\t\tplane = clippingPlanes[ i ];\n\t\t\tdistanceToPlane = - dot( vClipPosition, plane.xyz ) + plane.w;\n\t\t\tdistanceGradient = fwidth( distanceToPlane ) / 2.0;\n\t\t\tclipOpacity *= smoothstep( - distanceGradient, distanceGradient, distanceToPlane );\n\t\t\tif ( clipOpacity == 0.0 ) discard;\n\t\t}\n\t\t#pragma unroll_loop_end\n\t\t#if UNION_CLIPPING_PLANES < NUM_CLIPPING_PLANES\n\t\t\tfloat unionClipOpacity = 1.0;\n\t\t\t#pragma unroll_loop_start\n\t\t\tfor ( int i = UNION_CLIPPING_PLANES; i < NUM_CLIPPING_PLANES; i ++ ) {\n\t\t\t\tplane = clippingPlanes[ i ];\n\t\t\t\tdistanceToPlane = - dot( vClipPosition, plane.xyz ) + plane.w;\n\t\t\t\tdistanceGradient = fwidth( distanceToPlane ) / 2.0;\n\t\t\t\tunionClipOpacity *= 1.0 - smoothstep( - distanceGradient, distanceGradient, distanceToPlane );\n\t\t\t}\n\t\t\t#pragma unroll_loop_end\n\t\t\tclipOpacity *= 1.0 - unionClipOpacity;\n\t\t#endif\n\t\tdiffuseColor.a *= clipOpacity;\n\t\tif ( diffuseColor.a == 0.0 ) discard;\n\t#else\n\t\t#pragma unroll_loop_start\n\t\tfor ( int i = 0; i < UNION_CLIPPING_PLANES; i ++ ) {\n\t\t\tplane = clippingPlanes[ i ];\n\t\t\tif ( dot( vClipPosition, plane.xyz ) > plane.w ) discard;\n\t\t}\n\t\t#pragma unroll_loop_end\n\t\t#if UNION_CLIPPING_PLANES < NUM_CLIPPING_PLANES\n\t\t\tbool clipped = true;\n\t\t\t#pragma unroll_loop_start\n\t\t\tfor ( int i = UNION_CLIPPING_PLANES; i < NUM_CLIPPING_PLANES; i ++ ) {\n\t\t\t\tplane = clippingPlanes[ i ];\n\t\t\t\tclipped = ( dot( vClipPosition, plane.xyz ) > plane.w ) && clipped;\n\t\t\t}\n\t\t\t#pragma unroll_loop_end\n\t\t\tif ( clipped ) discard;\n\t\t#endif\n\t#endif\n#endif",clipping_planes_pars_fragment="#if NUM_CLIPPING_PLANES > 0\n\tvarying vec3 vClipPosition;\n\tuniform vec4 clippingPlanes[ NUM_CLIPPING_PLANES ];\n#endif",clipping_planes_pars_vertex="#if NUM_CLIPPING_PLANES > 0\n\tvarying vec3 vClipPosition;\n#endif",clipping_planes_vertex="#if NUM_CLIPPING_PLANES > 0\n\tvClipPosition = - mvPosition.xyz;\n#endif",color_fragment="#if defined( USE_COLOR_ALPHA )\n\tdiffuseColor *= vColor;\n#elif defined( USE_COLOR )\n\tdiffuseColor.rgb *= vColor;\n#endif",color_pars_fragment="#if defined( USE_COLOR_ALPHA )\n\tvarying vec4 vColor;\n#elif defined( USE_COLOR )\n\tvarying vec3 vColor;\n#endif",color_pars_vertex="#if defined( USE_COLOR_ALPHA )\n\tvarying vec4 vColor;\n#elif defined( USE_COLOR ) || defined( USE_INSTANCING_COLOR ) || defined( USE_BATCHING_COLOR )\n\tvarying vec3 vColor;\n#endif",color_vertex="#if defined( USE_COLOR_ALPHA )\n\tvColor = vec4( 1.0 );\n#elif defined( USE_COLOR ) || defined( USE_INSTANCING_COLOR ) || defined( USE_BATCHING_COLOR )\n\tvColor = vec3( 1.0 );\n#endif\n#ifdef USE_COLOR\n\tvColor *= color;\n#endif\n#ifdef USE_INSTANCING_COLOR\n\tvColor.xyz *= instanceColor.xyz;\n#endif\n#ifdef USE_BATCHING_COLOR\n\tvec3 batchingColor = getBatchingColor( getIndirectIndex( gl_DrawID ) );\n\tvColor.xyz *= batchingColor.xyz;\n#endif",common="#define PI 3.141592653589793\n#define PI2 6.283185307179586\n#define PI_HALF 1.5707963267948966\n#define RECIPROCAL_PI 0.3183098861837907\n#define RECIPROCAL_PI2 0.15915494309189535\n#define EPSILON 1e-6\n#ifndef saturate\n#define saturate( a ) clamp( a, 0.0, 1.0 )\n#endif\n#define whiteComplement( a ) ( 1.0 - saturate( a ) )\nfloat pow2( const in float x ) { return x*x; }\nvec3 pow2( const in vec3 x ) { return x*x; }\nfloat pow3( const in float x ) { return x*x*x; }\nfloat pow4( const in float x ) { float x2 = x*x; return x2*x2; }\nfloat max3( const in vec3 v ) { return max( max( v.x, v.y ), v.z ); }\nfloat average( const in vec3 v ) { return dot( v, vec3( 0.3333333 ) ); }\nhighp float rand( const in vec2 uv ) {\n\tconst highp float a = 12.9898, b = 78.233, c = 43758.5453;\n\thighp float dt = dot( uv.xy, vec2( a,b ) ), sn = mod( dt, PI );\n\treturn fract( sin( sn ) * c );\n}\n#ifdef HIGH_PRECISION\n\tfloat precisionSafeLength( vec3 v ) { return length( v ); }\n#else\n\tfloat precisionSafeLength( vec3 v ) {\n\t\tfloat maxComponent = max3( abs( v ) );\n\t\treturn length( v / maxComponent ) * maxComponent;\n\t}\n#endif\nstruct IncidentLight {\n\tvec3 color;\n\tvec3 direction;\n\tbool visible;\n};\nstruct ReflectedLight {\n\tvec3 directDiffuse;\n\tvec3 directSpecular;\n\tvec3 indirectDiffuse;\n\tvec3 indirectSpecular;\n};\n#ifdef USE_ALPHAHASH\n\tvarying vec3 vPosition;\n#endif\nvec3 transformDirection( in vec3 dir, in mat4 matrix ) {\n\treturn normalize( ( matrix * vec4( dir, 0.0 ) ).xyz );\n}\nvec3 inverseTransformDirection( in vec3 dir, in mat4 matrix ) {\n\treturn normalize( ( vec4( dir, 0.0 ) * matrix ).xyz );\n}\nmat3 transposeMat3( const in mat3 m ) {\n\tmat3 tmp;\n\ttmp[ 0 ] = vec3( m[ 0 ].x, m[ 1 ].x, m[ 2 ].x );\n\ttmp[ 1 ] = vec3( m[ 0 ].y, m[ 1 ].y, m[ 2 ].y );\n\ttmp[ 2 ] = vec3( m[ 0 ].z, m[ 1 ].z, m[ 2 ].z );\n\treturn tmp;\n}\nbool isPerspectiveMatrix( mat4 m ) {\n\treturn m[ 2 ][ 3 ] == - 1.0;\n}\nvec2 equirectUv( in vec3 dir ) {\n\tfloat u = atan( dir.z, dir.x ) * RECIPROCAL_PI2 + 0.5;\n\tfloat v = asin( clamp( dir.y, - 1.0, 1.0 ) ) * RECIPROCAL_PI + 0.5;\n\treturn vec2( u, v );\n}\nvec3 BRDF_Lambert( const in vec3 diffuseColor ) {\n\treturn RECIPROCAL_PI * diffuseColor;\n}\nvec3 F_Schlick( const in vec3 f0, const in float f90, const in float dotVH ) {\n\tfloat fresnel = exp2( ( - 5.55473 * dotVH - 6.98316 ) * dotVH );\n\treturn f0 * ( 1.0 - fresnel ) + ( f90 * fresnel );\n}\nfloat F_Schlick( const in float f0, const in float f90, const in float dotVH ) {\n\tfloat fresnel = exp2( ( - 5.55473 * dotVH - 6.98316 ) * dotVH );\n\treturn f0 * ( 1.0 - fresnel ) + ( f90 * fresnel );\n} // validated",cube_uv_reflection_fragment="#ifdef ENVMAP_TYPE_CUBE_UV\n\t#define cubeUV_minMipLevel 4.0\n\t#define cubeUV_minTileSize 16.0\n\tfloat getFace( vec3 direction ) {\n\t\tvec3 absDirection = abs( direction );\n\t\tfloat face = - 1.0;\n\t\tif ( absDirection.x > absDirection.z ) {\n\t\t\tif ( absDirection.x > absDirection.y )\n\t\t\t\tface = direction.x > 0.0 ? 0.0 : 3.0;\n\t\t\telse\n\t\t\t\tface = direction.y > 0.0 ? 1.0 : 4.0;\n\t\t} else {\n\t\t\tif ( absDirection.z > absDirection.y )\n\t\t\t\tface = direction.z > 0.0 ? 2.0 : 5.0;\n\t\t\telse\n\t\t\t\tface = direction.y > 0.0 ? 1.0 : 4.0;\n\t\t}\n\t\treturn face;\n\t}\n\tvec2 getUV( vec3 direction, float face ) {\n\t\tvec2 uv;\n\t\tif ( face == 0.0 ) {\n\t\t\tuv = vec2( direction.z, direction.y ) / abs( direction.x );\n\t\t} else if ( face == 1.0 ) {\n\t\t\tuv = vec2( - direction.x, - direction.z ) / abs( direction.y );\n\t\t} else if ( face == 2.0 ) {\n\t\t\tuv = vec2( - direction.x, direction.y ) / abs( direction.z );\n\t\t} else if ( face == 3.0 ) {\n\t\t\tuv = vec2( - direction.z, direction.y ) / abs( direction.x );\n\t\t} else if ( face == 4.0 ) {\n\t\t\tuv = vec2( - direction.x, direction.z ) / abs( direction.y );\n\t\t} else {\n\t\t\tuv = vec2( direction.x, direction.y ) / abs( direction.z );\n\t\t}\n\t\treturn 0.5 * ( uv + 1.0 );\n\t}\n\tvec3 bilinearCubeUV( sampler2D envMap, vec3 direction, float mipInt ) {\n\t\tfloat face = getFace( direction );\n\t\tfloat filterInt = max( cubeUV_minMipLevel - mipInt, 0.0 );\n\t\tmipInt = max( mipInt, cubeUV_minMipLevel );\n\t\tfloat faceSize = exp2( mipInt );\n\t\thighp vec2 uv = getUV( direction, face ) * ( faceSize - 2.0 ) + 1.0;\n\t\tif ( face > 2.0 ) {\n\t\t\tuv.y += faceSize;\n\t\t\tface -= 3.0;\n\t\t}\n\t\tuv.x += face * faceSize;\n\t\tuv.x += filterInt * 3.0 * cubeUV_minTileSize;\n\t\tuv.y += 4.0 * ( exp2( CUBEUV_MAX_MIP ) - faceSize );\n\t\tuv.x *= CUBEUV_TEXEL_WIDTH;\n\t\tuv.y *= CUBEUV_TEXEL_HEIGHT;\n\t\t#ifdef texture2DGradEXT\n\t\t\treturn texture2DGradEXT( envMap, uv, vec2( 0.0 ), vec2( 0.0 ) ).rgb;\n\t\t#else\n\t\t\treturn texture2D( envMap, uv ).rgb;\n\t\t#endif\n\t}\n\t#define cubeUV_r0 1.0\n\t#define cubeUV_m0 - 2.0\n\t#define cubeUV_r1 0.8\n\t#define cubeUV_m1 - 1.0\n\t#define cubeUV_r4 0.4\n\t#define cubeUV_m4 2.0\n\t#define cubeUV_r5 0.305\n\t#define cubeUV_m5 3.0\n\t#define cubeUV_r6 0.21\n\t#define cubeUV_m6 4.0\n\tfloat roughnessToMip( float roughness ) {\n\t\tfloat mip = 0.0;\n\t\tif ( roughness >= cubeUV_r1 ) {\n\t\t\tmip = ( cubeUV_r0 - roughness ) * ( cubeUV_m1 - cubeUV_m0 ) / ( cubeUV_r0 - cubeUV_r1 ) + cubeUV_m0;\n\t\t} else if ( roughness >= cubeUV_r4 ) {\n\t\t\tmip = ( cubeUV_r1 - roughness ) * ( cubeUV_m4 - cubeUV_m1 ) / ( cubeUV_r1 - cubeUV_r4 ) + cubeUV_m1;\n\t\t} else if ( roughness >= cubeUV_r5 ) {\n\t\t\tmip = ( cubeUV_r4 - roughness ) * ( cubeUV_m5 - cubeUV_m4 ) / ( cubeUV_r4 - cubeUV_r5 ) + cubeUV_m4;\n\t\t} else if ( roughness >= cubeUV_r6 ) {\n\t\t\tmip = ( cubeUV_r5 - roughness ) * ( cubeUV_m6 - cubeUV_m5 ) / ( cubeUV_r5 - cubeUV_r6 ) + cubeUV_m5;\n\t\t} else {\n\t\t\tmip = - 2.0 * log2( 1.16 * roughness );\t\t}\n\t\treturn mip;\n\t}\n\tvec4 textureCubeUV( sampler2D envMap, vec3 sampleDir, float roughness ) {\n\t\tfloat mip = clamp( roughnessToMip( roughness ), cubeUV_m0, CUBEUV_MAX_MIP );\n\t\tfloat mipF = fract( mip );\n\t\tfloat mipInt = floor( mip );\n\t\tvec3 color0 = bilinearCubeUV( envMap, sampleDir, mipInt );\n\t\tif ( mipF == 0.0 ) {\n\t\t\treturn vec4( color0, 1.0 );\n\t\t} else {\n\t\t\tvec3 color1 = bilinearCubeUV( envMap, sampleDir, mipInt + 1.0 );\n\t\t\treturn vec4( mix( color0, color1, mipF ), 1.0 );\n\t\t}\n\t}\n#endif",defaultnormal_vertex="vec3 transformedNormal = objectNormal;\n#ifdef USE_TANGENT\n\tvec3 transformedTangent = objectTangent;\n#endif\n#ifdef USE_BATCHING\n\tmat3 bm = mat3( batchingMatrix );\n\ttransformedNormal /= vec3( dot( bm[ 0 ], bm[ 0 ] ), dot( bm[ 1 ], bm[ 1 ] ), dot( bm[ 2 ], bm[ 2 ] ) );\n\ttransformedNormal = bm * transformedNormal;\n\t#ifdef USE_TANGENT\n\t\ttransformedTangent = bm * transformedTangent;\n\t#endif\n#endif\n#ifdef USE_INSTANCING\n\tmat3 im = mat3( instanceMatrix );\n\ttransformedNormal /= vec3( dot( im[ 0 ], im[ 0 ] ), dot( im[ 1 ], im[ 1 ] ), dot( im[ 2 ], im[ 2 ] ) );\n\ttransformedNormal = im * transformedNormal;\n\t#ifdef USE_TANGENT\n\t\ttransformedTangent = im * transformedTangent;\n\t#endif\n#endif\ntransformedNormal = normalMatrix * transformedNormal;\n#ifdef FLIP_SIDED\n\ttransformedNormal = - transformedNormal;\n#endif\n#ifdef USE_TANGENT\n\ttransformedTangent = ( modelViewMatrix * vec4( transformedTangent, 0.0 ) ).xyz;\n\t#ifdef FLIP_SIDED\n\t\ttransformedTangent = - transformedTangent;\n\t#endif\n#endif",displacementmap_pars_vertex="#ifdef USE_DISPLACEMENTMAP\n\tuniform sampler2D displacementMap;\n\tuniform float displacementScale;\n\tuniform float displacementBias;\n#endif",displacementmap_vertex="#ifdef USE_DISPLACEMENTMAP\n\ttransformed += normalize( objectNormal ) * ( texture2D( displacementMap, vDisplacementMapUv ).x * displacementScale + displacementBias );\n#endif",emissivemap_fragment="#ifdef USE_EMISSIVEMAP\n\tvec4 emissiveColor = texture2D( emissiveMap, vEmissiveMapUv );\n\t#ifdef DECODE_VIDEO_TEXTURE_EMISSIVE\n\t\temissiveColor = sRGBTransferEOTF( emissiveColor );\n\t#endif\n\ttotalEmissiveRadiance *= emissiveColor.rgb;\n#endif",emissivemap_pars_fragment="#ifdef USE_EMISSIVEMAP\n\tuniform sampler2D emissiveMap;\n#endif",colorspace_fragment="gl_FragColor = linearToOutputTexel( gl_FragColor );",colorspace_pars_fragment="vec4 LinearTransferOETF( in vec4 value ) {\n\treturn value;\n}\nvec4 sRGBTransferEOTF( in vec4 value ) {\n\treturn vec4( mix( pow( value.rgb * 0.9478672986 + vec3( 0.0521327014 ), vec3( 2.4 ) ), value.rgb * 0.0773993808, vec3( lessThanEqual( value.rgb, vec3( 0.04045 ) ) ) ), value.a );\n}\nvec4 sRGBTransferOETF( in vec4 value ) {\n\treturn vec4( mix( pow( value.rgb, vec3( 0.41666 ) ) * 1.055 - vec3( 0.055 ), value.rgb * 12.92, vec3( lessThanEqual( value.rgb, vec3( 0.0031308 ) ) ) ), value.a );\n}",envmap_fragment="#ifdef USE_ENVMAP\n\t#ifdef ENV_WORLDPOS\n\t\tvec3 cameraToFrag;\n\t\tif ( isOrthographic ) {\n\t\t\tcameraToFrag = normalize( vec3( - viewMatrix[ 0 ][ 2 ], - viewMatrix[ 1 ][ 2 ], - viewMatrix[ 2 ][ 2 ] ) );\n\t\t} else {\n\t\t\tcameraToFrag = normalize( vWorldPosition - cameraPosition );\n\t\t}\n\t\tvec3 worldNormal = inverseTransformDirection( normal, viewMatrix );\n\t\t#ifdef ENVMAP_MODE_REFLECTION\n\t\t\tvec3 reflectVec = reflect( cameraToFrag, worldNormal );\n\t\t#else\n\t\t\tvec3 reflectVec = refract( cameraToFrag, worldNormal, refractionRatio );\n\t\t#endif\n\t#else\n\t\tvec3 reflectVec = vReflect;\n\t#endif\n\t#ifdef ENVMAP_TYPE_CUBE\n\t\tvec4 envColor = textureCube( envMap, envMapRotation * vec3( flipEnvMap * reflectVec.x, reflectVec.yz ) );\n\t#else\n\t\tvec4 envColor = vec4( 0.0 );\n\t#endif\n\t#ifdef ENVMAP_BLENDING_MULTIPLY\n\t\toutgoingLight = mix( outgoingLight, outgoingLight * envColor.xyz, specularStrength * reflectivity );\n\t#elif defined( ENVMAP_BLENDING_MIX )\n\t\toutgoingLight = mix( outgoingLight, envColor.xyz, specularStrength * reflectivity );\n\t#elif defined( ENVMAP_BLENDING_ADD )\n\t\toutgoingLight += envColor.xyz * specularStrength * reflectivity;\n\t#endif\n#endif",envmap_common_pars_fragment="#ifdef USE_ENVMAP\n\tuniform float envMapIntensity;\n\tuniform float flipEnvMap;\n\tuniform mat3 envMapRotation;\n\t#ifdef ENVMAP_TYPE_CUBE\n\t\tuniform samplerCube envMap;\n\t#else\n\t\tuniform sampler2D envMap;\n\t#endif\n\t\n#endif",envmap_pars_fragment="#ifdef USE_ENVMAP\n\tuniform float reflectivity;\n\t#if defined( USE_BUMPMAP ) || defined( USE_NORMALMAP ) || defined( PHONG ) || defined( LAMBERT )\n\t\t#define ENV_WORLDPOS\n\t#endif\n\t#ifdef ENV_WORLDPOS\n\t\tvarying vec3 vWorldPosition;\n\t\tuniform float refractionRatio;\n\t#else\n\t\tvarying vec3 vReflect;\n\t#endif\n#endif",envmap_pars_vertex="#ifdef USE_ENVMAP\n\t#if defined( USE_BUMPMAP ) || defined( USE_NORMALMAP ) || defined( PHONG ) || defined( LAMBERT )\n\t\t#define ENV_WORLDPOS\n\t#endif\n\t#ifdef ENV_WORLDPOS\n\t\t\n\t\tvarying vec3 vWorldPosition;\n\t#else\n\t\tvarying vec3 vReflect;\n\t\tuniform float refractionRatio;\n\t#endif\n#endif",envmap_vertex="#ifdef USE_ENVMAP\n\t#ifdef ENV_WORLDPOS\n\t\tvWorldPosition = worldPosition.xyz;\n\t#else\n\t\tvec3 cameraToVertex;\n\t\tif ( isOrthographic ) {\n\t\t\tcameraToVertex = normalize( vec3( - viewMatrix[ 0 ][ 2 ], - viewMatrix[ 1 ][ 2 ], - viewMatrix[ 2 ][ 2 ] ) );\n\t\t} else {\n\t\t\tcameraToVertex = normalize( worldPosition.xyz - cameraPosition );\n\t\t}\n\t\tvec3 worldNormal = inverseTransformDirection( transformedNormal, viewMatrix );\n\t\t#ifdef ENVMAP_MODE_REFLECTION\n\t\t\tvReflect = reflect( cameraToVertex, worldNormal );\n\t\t#else\n\t\t\tvReflect = refract( cameraToVertex, worldNormal, refractionRatio );\n\t\t#endif\n\t#endif\n#endif",fog_vertex="#ifdef USE_FOG\n\tvFogDepth = - mvPosition.z;\n#endif",fog_pars_vertex="#ifdef USE_FOG\n\tvarying float vFogDepth;\n#endif",fog_fragment="#ifdef USE_FOG\n\t#ifdef FOG_EXP2\n\t\tfloat fogFactor = 1.0 - exp( - fogDensity * fogDensity * vFogDepth * vFogDepth );\n\t#else\n\t\tfloat fogFactor = smoothstep( fogNear, fogFar, vFogDepth );\n\t#endif\n\tgl_FragColor.rgb = mix( gl_FragColor.rgb, fogColor, fogFactor );\n#endif",fog_pars_fragment="#ifdef USE_FOG\n\tuniform vec3 fogColor;\n\tvarying float vFogDepth;\n\t#ifdef FOG_EXP2\n\t\tuniform float fogDensity;\n\t#else\n\t\tuniform float fogNear;\n\t\tuniform float fogFar;\n\t#endif\n#endif",gradientmap_pars_fragment="#ifdef USE_GRADIENTMAP\n\tuniform sampler2D gradientMap;\n#endif\nvec3 getGradientIrradiance( vec3 normal, vec3 lightDirection ) {\n\tfloat dotNL = dot( normal, lightDirection );\n\tvec2 coord = vec2( dotNL * 0.5 + 0.5, 0.0 );\n\t#ifdef USE_GRADIENTMAP\n\t\treturn vec3( texture2D( gradientMap, coord ).r );\n\t#else\n\t\tvec2 fw = fwidth( coord ) * 0.5;\n\t\treturn mix( vec3( 0.7 ), vec3( 1.0 ), smoothstep( 0.7 - fw.x, 0.7 + fw.x, coord.x ) );\n\t#endif\n}",lightmap_pars_fragment="#ifdef USE_LIGHTMAP\n\tuniform sampler2D lightMap;\n\tuniform float lightMapIntensity;\n#endif",lights_lambert_fragment="LambertMaterial material;\nmaterial.diffuseColor = diffuseColor.rgb;\nmaterial.specularStrength = specularStrength;",lights_lambert_pars_fragment="varying vec3 vViewPosition;\nstruct LambertMaterial {\n\tvec3 diffuseColor;\n\tfloat specularStrength;\n};\nvoid RE_Direct_Lambert( const in IncidentLight directLight, const in vec3 geometryPosition, const in vec3 geometryNormal, const in vec3 geometryViewDir, const in vec3 geometryClearcoatNormal, const in LambertMaterial material, inout ReflectedLight reflectedLight ) {\n\tfloat dotNL = saturate( dot( geometryNormal, directLight.direction ) );\n\tvec3 irradiance = dotNL * directLight.color;\n\treflectedLight.directDiffuse += irradiance * BRDF_Lambert( material.diffuseColor );\n}\nvoid RE_IndirectDiffuse_Lambert( const in vec3 irradiance, const in vec3 geometryPosition, const in vec3 geometryNormal, const in vec3 geometryViewDir, const in vec3 geometryClearcoatNormal, const in LambertMaterial material, inout ReflectedLight reflectedLight ) {\n\treflectedLight.indirectDiffuse += irradiance * BRDF_Lambert( material.diffuseColor );\n}\n#define RE_Direct\t\t\t\tRE_Direct_Lambert\n#define RE_IndirectDiffuse\t\tRE_IndirectDiffuse_Lambert",lights_pars_begin="uniform bool receiveShadow;\nuniform vec3 ambientLightColor;\n#if defined( USE_LIGHT_PROBES )\n\tuniform vec3 lightProbe[ 9 ];\n#endif\nvec3 shGetIrradianceAt( in vec3 normal, in vec3 shCoefficients[ 9 ] ) {\n\tfloat x = normal.x, y = normal.y, z = normal.z;\n\tvec3 result = shCoefficients[ 0 ] * 0.886227;\n\tresult += shCoefficients[ 1 ] * 2.0 * 0.511664 * y;\n\tresult += shCoefficients[ 2 ] * 2.0 * 0.511664 * z;\n\tresult += shCoefficients[ 3 ] * 2.0 * 0.511664 * x;\n\tresult += shCoefficients[ 4 ] * 2.0 * 0.429043 * x * y;\n\tresult += shCoefficients[ 5 ] * 2.0 * 0.429043 * y * z;\n\tresult += shCoefficients[ 6 ] * ( 0.743125 * z * z - 0.247708 );\n\tresult += shCoefficients[ 7 ] * 2.0 * 0.429043 * x * z;\n\tresult += shCoefficients[ 8 ] * 0.429043 * ( x * x - y * y );\n\treturn result;\n}\nvec3 getLightProbeIrradiance( const in vec3 lightProbe[ 9 ], const in vec3 normal ) {\n\tvec3 worldNormal = inverseTransformDirection( normal, viewMatrix );\n\tvec3 irradiance = shGetIrradianceAt( worldNormal, lightProbe );\n\treturn irradiance;\n}\nvec3 getAmbientLightIrradiance( const in vec3 ambientLightColor ) {\n\tvec3 irradiance = ambientLightColor;\n\treturn irradiance;\n}\nfloat getDistanceAttenuation( const in float lightDistance, const in float cutoffDistance, const in float decayExponent ) {\n\tfloat distanceFalloff = 1.0 / max( pow( lightDistance, decayExponent ), 0.01 );\n\tif ( cutoffDistance > 0.0 ) {\n\t\tdistanceFalloff *= pow2( saturate( 1.0 - pow4( lightDistance / cutoffDistance ) ) );\n\t}\n\treturn distanceFalloff;\n}\nfloat getSpotAttenuation( const in float coneCosine, const in float penumbraCosine, const in float angleCosine ) {\n\treturn smoothstep( coneCosine, penumbraCosine, angleCosine );\n}\n#if NUM_DIR_LIGHTS > 0\n\tstruct DirectionalLight {\n\t\tvec3 direction;\n\t\tvec3 color;\n\t};\n\tuniform DirectionalLight directionalLights[ NUM_DIR_LIGHTS ];\n\tvoid getDirectionalLightInfo( const in DirectionalLight directionalLight, out IncidentLight light ) {\n\t\tlight.color = directionalLight.color;\n\t\tlight.direction = directionalLight.direction;\n\t\tlight.visible = true;\n\t}\n#endif\n#if NUM_POINT_LIGHTS > 0\n\tstruct PointLight {\n\t\tvec3 position;\n\t\tvec3 color;\n\t\tfloat distance;\n\t\tfloat decay;\n\t};\n\tuniform PointLight pointLights[ NUM_POINT_LIGHTS ];\n\tvoid getPointLightInfo( const in PointLight pointLight, const in vec3 geometryPosition, out IncidentLight light ) {\n\t\tvec3 lVector = pointLight.position - geometryPosition;\n\t\tlight.direction = normalize( lVector );\n\t\tfloat lightDistance = length( lVector );\n\t\tlight.color = pointLight.color;\n\t\tlight.color *= getDistanceAttenuation( lightDistance, pointLight.distance, pointLight.decay );\n\t\tlight.visible = ( light.color != vec3( 0.0 ) );\n\t}\n#endif\n#if NUM_SPOT_LIGHTS > 0\n\tstruct SpotLight {\n\t\tvec3 position;\n\t\tvec3 direction;\n\t\tvec3 color;\n\t\tfloat distance;\n\t\tfloat decay;\n\t\tfloat coneCos;\n\t\tfloat penumbraCos;\n\t};\n\tuniform SpotLight spotLights[ NUM_SPOT_LIGHTS ];\n\tvoid getSpotLightInfo( const in SpotLight spotLight, const in vec3 geometryPosition, out IncidentLight light ) {\n\t\tvec3 lVector = spotLight.position - geometryPosition;\n\t\tlight.direction = normalize( lVector );\n\t\tfloat angleCos = dot( light.direction, spotLight.direction );\n\t\tfloat spotAttenuation = getSpotAttenuation( spotLight.coneCos, spotLight.penumbraCos, angleCos );\n\t\tif ( spotAttenuation > 0.0 ) {\n\t\t\tfloat lightDistance = length( lVector );\n\t\t\tlight.color = spotLight.color * spotAttenuation;\n\t\t\tlight.color *= getDistanceAttenuation( lightDistance, spotLight.distance, spotLight.decay );\n\t\t\tlight.visible = ( light.color != vec3( 0.0 ) );\n\t\t} else {\n\t\t\tlight.color = vec3( 0.0 );\n\t\t\tlight.visible = false;\n\t\t}\n\t}\n#endif\n#if NUM_RECT_AREA_LIGHTS > 0\n\tstruct RectAreaLight {\n\t\tvec3 color;\n\t\tvec3 position;\n\t\tvec3 halfWidth;\n\t\tvec3 halfHeight;\n\t};\n\tuniform sampler2D ltc_1;\tuniform sampler2D ltc_2;\n\tuniform RectAreaLight rectAreaLights[ NUM_RECT_AREA_LIGHTS ];\n#endif\n#if NUM_HEMI_LIGHTS > 0\n\tstruct HemisphereLight {\n\t\tvec3 direction;\n\t\tvec3 skyColor;\n\t\tvec3 groundColor;\n\t};\n\tuniform HemisphereLight hemisphereLights[ NUM_HEMI_LIGHTS ];\n\tvec3 getHemisphereLightIrradiance( const in HemisphereLight hemiLight, const in vec3 normal ) {\n\t\tfloat dotNL = dot( normal, hemiLight.direction );\n\t\tfloat hemiDiffuseWeight = 0.5 * dotNL + 0.5;\n\t\tvec3 irradiance = mix( hemiLight.groundColor, hemiLight.skyColor, hemiDiffuseWeight );\n\t\treturn irradiance;\n\t}\n#endif",envmap_physical_pars_fragment="#ifdef USE_ENVMAP\n\tvec3 getIBLIrradiance( const in vec3 normal ) {\n\t\t#ifdef ENVMAP_TYPE_CUBE_UV\n\t\t\tvec3 worldNormal = inverseTransformDirection( normal, viewMatrix );\n\t\t\tvec4 envMapColor = textureCubeUV( envMap, envMapRotation * worldNormal, 1.0 );\n\t\t\treturn PI * envMapColor.rgb * envMapIntensity;\n\t\t#else\n\t\t\treturn vec3( 0.0 );\n\t\t#endif\n\t}\n\tvec3 getIBLRadiance( const in vec3 viewDir, const in vec3 normal, const in float roughness ) {\n\t\t#ifdef ENVMAP_TYPE_CUBE_UV\n\t\t\tvec3 reflectVec = reflect( - viewDir, normal );\n\t\t\treflectVec = normalize( mix( reflectVec, normal, roughness * roughness) );\n\t\t\treflectVec = inverseTransformDirection( reflectVec, viewMatrix );\n\t\t\tvec4 envMapColor = textureCubeUV( envMap, envMapRotation * reflectVec, roughness );\n\t\t\treturn envMapColor.rgb * envMapIntensity;\n\t\t#else\n\t\t\treturn vec3( 0.0 );\n\t\t#endif\n\t}\n\t#ifdef USE_ANISOTROPY\n\t\tvec3 getIBLAnisotropyRadiance( const in vec3 viewDir, const in vec3 normal, const in float roughness, const in vec3 bitangent, const in float anisotropy ) {\n\t\t\t#ifdef ENVMAP_TYPE_CUBE_UV\n\t\t\t\tvec3 bentNormal = cross( bitangent, viewDir );\n\t\t\t\tbentNormal = normalize( cross( bentNormal, bitangent ) );\n\t\t\t\tbentNormal = normalize( mix( bentNormal, normal, pow2( pow2( 1.0 - anisotropy * ( 1.0 - roughness ) ) ) ) );\n\t\t\t\treturn getIBLRadiance( viewDir, bentNormal, roughness );\n\t\t\t#else\n\t\t\t\treturn vec3( 0.0 );\n\t\t\t#endif\n\t\t}\n\t#endif\n#endif",lights_toon_fragment="ToonMaterial material;\nmaterial.diffuseColor = diffuseColor.rgb;",lights_toon_pars_fragment="varying vec3 vViewPosition;\nstruct ToonMaterial {\n\tvec3 diffuseColor;\n};\nvoid RE_Direct_Toon( const in IncidentLight directLight, const in vec3 geometryPosition, const in vec3 geometryNormal, const in vec3 geometryViewDir, const in vec3 geometryClearcoatNormal, const in ToonMaterial material, inout ReflectedLight reflectedLight ) {\n\tvec3 irradiance = getGradientIrradiance( geometryNormal, directLight.direction ) * directLight.color;\n\treflectedLight.directDiffuse += irradiance * BRDF_Lambert( material.diffuseColor );\n}\nvoid RE_IndirectDiffuse_Toon( const in vec3 irradiance, const in vec3 geometryPosition, const in vec3 geometryNormal, const in vec3 geometryViewDir, const in vec3 geometryClearcoatNormal, const in ToonMaterial material, inout ReflectedLight reflectedLight ) {\n\treflectedLight.indirectDiffuse += irradiance * BRDF_Lambert( material.diffuseColor );\n}\n#define RE_Direct\t\t\t\tRE_Direct_Toon\n#define RE_IndirectDiffuse\t\tRE_IndirectDiffuse_Toon",lights_phong_fragment="BlinnPhongMaterial material;\nmaterial.diffuseColor = diffuseColor.rgb;\nmaterial.specularColor = specular;\nmaterial.specularShininess = shininess;\nmaterial.specularStrength = specularStrength;",lights_phong_pars_fragment="varying vec3 vViewPosition;\nstruct BlinnPhongMaterial {\n\tvec3 diffuseColor;\n\tvec3 specularColor;\n\tfloat specularShininess;\n\tfloat specularStrength;\n};\nvoid RE_Direct_BlinnPhong( const in IncidentLight directLight, const in vec3 geometryPosition, const in vec3 geometryNormal, const in vec3 geometryViewDir, const in vec3 geometryClearcoatNormal, const in BlinnPhongMaterial material, inout ReflectedLight reflectedLight ) {\n\tfloat dotNL = saturate( dot( geometryNormal, directLight.direction ) );\n\tvec3 irradiance = dotNL * directLight.color;\n\treflectedLight.directDiffuse += irradiance * BRDF_Lambert( material.diffuseColor );\n\treflectedLight.directSpecular += irradiance * BRDF_BlinnPhong( directLight.direction, geometryViewDir, geometryNormal, material.specularColor, material.specularShininess ) * material.specularStrength;\n}\nvoid RE_IndirectDiffuse_BlinnPhong( const in vec3 irradiance, const in vec3 geometryPosition, const in vec3 geometryNormal, const in vec3 geometryViewDir, const in vec3 geometryClearcoatNormal, const in BlinnPhongMaterial material, inout ReflectedLight reflectedLight ) {\n\treflectedLight.indirectDiffuse += irradiance * BRDF_Lambert( material.diffuseColor );\n}\n#define RE_Direct\t\t\t\tRE_Direct_BlinnPhong\n#define RE_IndirectDiffuse\t\tRE_IndirectDiffuse_BlinnPhong",lights_physical_fragment="PhysicalMaterial material;\nmaterial.diffuseColor = diffuseColor.rgb * ( 1.0 - metalnessFactor );\nvec3 dxy = max( abs( dFdx( nonPerturbedNormal ) ), abs( dFdy( nonPerturbedNormal ) ) );\nfloat geometryRoughness = max( max( dxy.x, dxy.y ), dxy.z );\nmaterial.roughness = max( roughnessFactor, 0.0525 );material.roughness += geometryRoughness;\nmaterial.roughness = min( material.roughness, 1.0 );\n#ifdef IOR\n\tmaterial.ior = ior;\n\t#ifdef USE_SPECULAR\n\t\tfloat specularIntensityFactor = specularIntensity;\n\t\tvec3 specularColorFactor = specularColor;\n\t\t#ifdef USE_SPECULAR_COLORMAP\n\t\t\tspecularColorFactor *= texture2D( specularColorMap, vSpecularColorMapUv ).rgb;\n\t\t#endif\n\t\t#ifdef USE_SPECULAR_INTENSITYMAP\n\t\t\tspecularIntensityFactor *= texture2D( specularIntensityMap, vSpecularIntensityMapUv ).a;\n\t\t#endif\n\t\tmaterial.specularF90 = mix( specularIntensityFactor, 1.0, metalnessFactor );\n\t#else\n\t\tfloat specularIntensityFactor = 1.0;\n\t\tvec3 specularColorFactor = vec3( 1.0 );\n\t\tmaterial.specularF90 = 1.0;\n\t#endif\n\tmaterial.specularColor = mix( min( pow2( ( material.ior - 1.0 ) / ( material.ior + 1.0 ) ) * specularColorFactor, vec3( 1.0 ) ) * specularIntensityFactor, diffuseColor.rgb, metalnessFactor );\n#else\n\tmaterial.specularColor = mix( vec3( 0.04 ), diffuseColor.rgb, metalnessFactor );\n\tmaterial.specularF90 = 1.0;\n#endif\n#ifdef USE_CLEARCOAT\n\tmaterial.clearcoat = clearcoat;\n\tmaterial.clearcoatRoughness = clearcoatRoughness;\n\tmaterial.clearcoatF0 = vec3( 0.04 );\n\tmaterial.clearcoatF90 = 1.0;\n\t#ifdef USE_CLEARCOATMAP\n\t\tmaterial.clearcoat *= texture2D( clearcoatMap, vClearcoatMapUv ).x;\n\t#endif\n\t#ifdef USE_CLEARCOAT_ROUGHNESSMAP\n\t\tmaterial.clearcoatRoughness *= texture2D( clearcoatRoughnessMap, vClearcoatRoughnessMapUv ).y;\n\t#endif\n\tmaterial.clearcoat = saturate( material.clearcoat );\tmaterial.clearcoatRoughness = max( material.clearcoatRoughness, 0.0525 );\n\tmaterial.clearcoatRoughness += geometryRoughness;\n\tmaterial.clearcoatRoughness = min( material.clearcoatRoughness, 1.0 );\n#endif\n#ifdef USE_DISPERSION\n\tmaterial.dispersion = dispersion;\n#endif\n#ifdef USE_IRIDESCENCE\n\tmaterial.iridescence = iridescence;\n\tmaterial.iridescenceIOR = iridescenceIOR;\n\t#ifdef USE_IRIDESCENCEMAP\n\t\tmaterial.iridescence *= texture2D( iridescenceMap, vIridescenceMapUv ).r;\n\t#endif\n\t#ifdef USE_IRIDESCENCE_THICKNESSMAP\n\t\tmaterial.iridescenceThickness = (iridescenceThicknessMaximum - iridescenceThicknessMinimum) * texture2D( iridescenceThicknessMap, vIridescenceThicknessMapUv ).g + iridescenceThicknessMinimum;\n\t#else\n\t\tmaterial.iridescenceThickness = iridescenceThicknessMaximum;\n\t#endif\n#endif\n#ifdef USE_SHEEN\n\tmaterial.sheenColor = sheenColor;\n\t#ifdef USE_SHEEN_COLORMAP\n\t\tmaterial.sheenColor *= texture2D( sheenColorMap, vSheenColorMapUv ).rgb;\n\t#endif\n\tmaterial.sheenRoughness = clamp( sheenRoughness, 0.07, 1.0 );\n\t#ifdef USE_SHEEN_ROUGHNESSMAP\n\t\tmaterial.sheenRoughness *= texture2D( sheenRoughnessMap, vSheenRoughnessMapUv ).a;\n\t#endif\n#endif\n#ifdef USE_ANISOTROPY\n\t#ifdef USE_ANISOTROPYMAP\n\t\tmat2 anisotropyMat = mat2( anisotropyVector.x, anisotropyVector.y, - anisotropyVector.y, anisotropyVector.x );\n\t\tvec3 anisotropyPolar = texture2D( anisotropyMap, vAnisotropyMapUv ).rgb;\n\t\tvec2 anisotropyV = anisotropyMat * normalize( 2.0 * anisotropyPolar.rg - vec2( 1.0 ) ) * anisotropyPolar.b;\n\t#else\n\t\tvec2 anisotropyV = anisotropyVector;\n\t#endif\n\tmaterial.anisotropy = length( anisotropyV );\n\tif( material.anisotropy == 0.0 ) {\n\t\tanisotropyV = vec2( 1.0, 0.0 );\n\t} else {\n\t\tanisotropyV /= material.anisotropy;\n\t\tmaterial.anisotropy = saturate( material.anisotropy );\n\t}\n\tmaterial.alphaT = mix( pow2( material.roughness ), 1.0, pow2( material.anisotropy ) );\n\tmaterial.anisotropyT = tbn[ 0 ] * anisotropyV.x + tbn[ 1 ] * anisotropyV.y;\n\tmaterial.anisotropyB = tbn[ 1 ] * anisotropyV.x - tbn[ 0 ] * anisotropyV.y;\n#endif",lights_physical_pars_fragment="struct PhysicalMaterial {\n\tvec3 diffuseColor;\n\tfloat roughness;\n\tvec3 specularColor;\n\tfloat specularF90;\n\tfloat dispersion;\n\t#ifdef USE_CLEARCOAT\n\t\tfloat clearcoat;\n\t\tfloat clearcoatRoughness;\n\t\tvec3 clearcoatF0;\n\t\tfloat clearcoatF90;\n\t#endif\n\t#ifdef USE_IRIDESCENCE\n\t\tfloat iridescence;\n\t\tfloat iridescenceIOR;\n\t\tfloat iridescenceThickness;\n\t\tvec3 iridescenceFresnel;\n\t\tvec3 iridescenceF0;\n\t#endif\n\t#ifdef USE_SHEEN\n\t\tvec3 sheenColor;\n\t\tfloat sheenRoughness;\n\t#endif\n\t#ifdef IOR\n\t\tfloat ior;\n\t#endif\n\t#ifdef USE_TRANSMISSION\n\t\tfloat transmission;\n\t\tfloat transmissionAlpha;\n\t\tfloat thickness;\n\t\tfloat attenuationDistance;\n\t\tvec3 attenuationColor;\n\t#endif\n\t#ifdef USE_ANISOTROPY\n\t\tfloat anisotropy;\n\t\tfloat alphaT;\n\t\tvec3 anisotropyT;\n\t\tvec3 anisotropyB;\n\t#endif\n};\nvec3 clearcoatSpecularDirect = vec3( 0.0 );\nvec3 clearcoatSpecularIndirect = vec3( 0.0 );\nvec3 sheenSpecularDirect = vec3( 0.0 );\nvec3 sheenSpecularIndirect = vec3(0.0 );\nvec3 Schlick_to_F0( const in vec3 f, const in float f90, const in float dotVH ) {\n    float x = clamp( 1.0 - dotVH, 0.0, 1.0 );\n    float x2 = x * x;\n    float x5 = clamp( x * x2 * x2, 0.0, 0.9999 );\n    return ( f - vec3( f90 ) * x5 ) / ( 1.0 - x5 );\n}\nfloat V_GGX_SmithCorrelated( const in float alpha, const in float dotNL, const in float dotNV ) {\n\tfloat a2 = pow2( alpha );\n\tfloat gv = dotNL * sqrt( a2 + ( 1.0 - a2 ) * pow2( dotNV ) );\n\tfloat gl = dotNV * sqrt( a2 + ( 1.0 - a2 ) * pow2( dotNL ) );\n\treturn 0.5 / max( gv + gl, EPSILON );\n}\nfloat D_GGX( const in float alpha, const in float dotNH ) {\n\tfloat a2 = pow2( alpha );\n\tfloat denom = pow2( dotNH ) * ( a2 - 1.0 ) + 1.0;\n\treturn RECIPROCAL_PI * a2 / pow2( denom );\n}\n#ifdef USE_ANISOTROPY\n\tfloat V_GGX_SmithCorrelated_Anisotropic( const in float alphaT, const in float alphaB, const in float dotTV, const in float dotBV, const in float dotTL, const in float dotBL, const in float dotNV, const in float dotNL ) {\n\t\tfloat gv = dotNL * length( vec3( alphaT * dotTV, alphaB * dotBV, dotNV ) );\n\t\tfloat gl = dotNV * length( vec3( alphaT * dotTL, alphaB * dotBL, dotNL ) );\n\t\tfloat v = 0.5 / ( gv + gl );\n\t\treturn saturate(v);\n\t}\n\tfloat D_GGX_Anisotropic( const in float alphaT, const in float alphaB, const in float dotNH, const in float dotTH, const in float dotBH ) {\n\t\tfloat a2 = alphaT * alphaB;\n\t\thighp vec3 v = vec3( alphaB * dotTH, alphaT * dotBH, a2 * dotNH );\n\t\thighp float v2 = dot( v, v );\n\t\tfloat w2 = a2 / v2;\n\t\treturn RECIPROCAL_PI * a2 * pow2 ( w2 );\n\t}\n#endif\n#ifdef USE_CLEARCOAT\n\tvec3 BRDF_GGX_Clearcoat( const in vec3 lightDir, const in vec3 viewDir, const in vec3 normal, const in PhysicalMaterial material) {\n\t\tvec3 f0 = material.clearcoatF0;\n\t\tfloat f90 = material.clearcoatF90;\n\t\tfloat roughness = material.clearcoatRoughness;\n\t\tfloat alpha = pow2( roughness );\n\t\tvec3 halfDir = normalize( lightDir + viewDir );\n\t\tfloat dotNL = saturate( dot( normal, lightDir ) );\n\t\tfloat dotNV = saturate( dot( normal, viewDir ) );\n\t\tfloat dotNH = saturate( dot( normal, halfDir ) );\n\t\tfloat dotVH = saturate( dot( viewDir, halfDir ) );\n\t\tvec3 F = F_Schlick( f0, f90, dotVH );\n\t\tfloat V = V_GGX_SmithCorrelated( alpha, dotNL, dotNV );\n\t\tfloat D = D_GGX( alpha, dotNH );\n\t\treturn F * ( V * D );\n\t}\n#endif\nvec3 BRDF_GGX( const in vec3 lightDir, const in vec3 viewDir, const in vec3 normal, const in PhysicalMaterial material ) {\n\tvec3 f0 = material.specularColor;\n\tfloat f90 = material.specularF90;\n\tfloat roughness = material.roughness;\n\tfloat alpha = pow2( roughness );\n\tvec3 halfDir = normalize( lightDir + viewDir );\n\tfloat dotNL = saturate( dot( normal, lightDir ) );\n\tfloat dotNV = saturate( dot( normal, viewDir ) );\n\tfloat dotNH = saturate( dot( normal, halfDir ) );\n\tfloat dotVH = saturate( dot( viewDir, halfDir ) );\n\tvec3 F = F_Schlick( f0, f90, dotVH );\n\t#ifdef USE_IRIDESCENCE\n\t\tF = mix( F, material.iridescenceFresnel, material.iridescence );\n\t#endif\n\t#ifdef USE_ANISOTROPY\n\t\tfloat dotTL = dot( material.anisotropyT, lightDir );\n\t\tfloat dotTV = dot( material.anisotropyT, viewDir );\n\t\tfloat dotTH = dot( material.anisotropyT, halfDir );\n\t\tfloat dotBL = dot( material.anisotropyB, lightDir );\n\t\tfloat dotBV = dot( material.anisotropyB, viewDir );\n\t\tfloat dotBH = dot( material.anisotropyB, halfDir );\n\t\tfloat V = V_GGX_SmithCorrelated_Anisotropic( material.alphaT, alpha, dotTV, dotBV, dotTL, dotBL, dotNV, dotNL );\n\t\tfloat D = D_GGX_Anisotropic( material.alphaT, alpha, dotNH, dotTH, dotBH );\n\t#else\n\t\tfloat V = V_GGX_SmithCorrelated( alpha, dotNL, dotNV );\n\t\tfloat D = D_GGX( alpha, dotNH );\n\t#endif\n\treturn F * ( V * D );\n}\nvec2 LTC_Uv( const in vec3 N, const in vec3 V, const in float roughness ) {\n\tconst float LUT_SIZE = 64.0;\n\tconst float LUT_SCALE = ( LUT_SIZE - 1.0 ) / LUT_SIZE;\n\tconst float LUT_BIAS = 0.5 / LUT_SIZE;\n\tfloat dotNV = saturate( dot( N, V ) );\n\tvec2 uv = vec2( roughness, sqrt( 1.0 - dotNV ) );\n\tuv = uv * LUT_SCALE + LUT_BIAS;\n\treturn uv;\n}\nfloat LTC_ClippedSphereFormFactor( const in vec3 f ) {\n\tfloat l = length( f );\n\treturn max( ( l * l + f.z ) / ( l + 1.0 ), 0.0 );\n}\nvec3 LTC_EdgeVectorFormFactor( const in vec3 v1, const in vec3 v2 ) {\n\tfloat x = dot( v1, v2 );\n\tfloat y = abs( x );\n\tfloat a = 0.8543985 + ( 0.4965155 + 0.0145206 * y ) * y;\n\tfloat b = 3.4175940 + ( 4.1616724 + y ) * y;\n\tfloat v = a / b;\n\tfloat theta_sintheta = ( x > 0.0 ) ? v : 0.5 * inversesqrt( max( 1.0 - x * x, 1e-7 ) ) - v;\n\treturn cross( v1, v2 ) * theta_sintheta;\n}\nvec3 LTC_Evaluate( const in vec3 N, const in vec3 V, const in vec3 P, const in mat3 mInv, const in vec3 rectCoords[ 4 ] ) {\n\tvec3 v1 = rectCoords[ 1 ] - rectCoords[ 0 ];\n\tvec3 v2 = rectCoords[ 3 ] - rectCoords[ 0 ];\n\tvec3 lightNormal = cross( v1, v2 );\n\tif( dot( lightNormal, P - rectCoords[ 0 ] ) < 0.0 ) return vec3( 0.0 );\n\tvec3 T1, T2;\n\tT1 = normalize( V - N * dot( V, N ) );\n\tT2 = - cross( N, T1 );\n\tmat3 mat = mInv * transposeMat3( mat3( T1, T2, N ) );\n\tvec3 coords[ 4 ];\n\tcoords[ 0 ] = mat * ( rectCoords[ 0 ] - P );\n\tcoords[ 1 ] = mat * ( rectCoords[ 1 ] - P );\n\tcoords[ 2 ] = mat * ( rectCoords[ 2 ] - P );\n\tcoords[ 3 ] = mat * ( rectCoords[ 3 ] - P );\n\tcoords[ 0 ] = normalize( coords[ 0 ] );\n\tcoords[ 1 ] = normalize( coords[ 1 ] );\n\tcoords[ 2 ] = normalize( coords[ 2 ] );\n\tcoords[ 3 ] = normalize( coords[ 3 ] );\n\tvec3 vectorFormFactor = vec3( 0.0 );\n\tvectorFormFactor += LTC_EdgeVectorFormFactor( coords[ 0 ], coords[ 1 ] );\n\tvectorFormFactor += LTC_EdgeVectorFormFactor( coords[ 1 ], coords[ 2 ] );\n\tvectorFormFactor += LTC_EdgeVectorFormFactor( coords[ 2 ], coords[ 3 ] );\n\tvectorFormFactor += LTC_EdgeVectorFormFactor( coords[ 3 ], coords[ 0 ] );\n\tfloat result = LTC_ClippedSphereFormFactor( vectorFormFactor );\n\treturn vec3( result );\n}\n#if defined( USE_SHEEN )\nfloat D_Charlie( float roughness, float dotNH ) {\n\tfloat alpha = pow2( roughness );\n\tfloat invAlpha = 1.0 / alpha;\n\tfloat cos2h = dotNH * dotNH;\n\tfloat sin2h = max( 1.0 - cos2h, 0.0078125 );\n\treturn ( 2.0 + invAlpha ) * pow( sin2h, invAlpha * 0.5 ) / ( 2.0 * PI );\n}\nfloat V_Neubelt( float dotNV, float dotNL ) {\n\treturn saturate( 1.0 / ( 4.0 * ( dotNL + dotNV - dotNL * dotNV ) ) );\n}\nvec3 BRDF_Sheen( const in vec3 lightDir, const in vec3 viewDir, const in vec3 normal, vec3 sheenColor, const in float sheenRoughness ) {\n\tvec3 halfDir = normalize( lightDir + viewDir );\n\tfloat dotNL = saturate( dot( normal, lightDir ) );\n\tfloat dotNV = saturate( dot( normal, viewDir ) );\n\tfloat dotNH = saturate( dot( normal, halfDir ) );\n\tfloat D = D_Charlie( sheenRoughness, dotNH );\n\tfloat V = V_Neubelt( dotNV, dotNL );\n\treturn sheenColor * ( D * V );\n}\n#endif\nfloat IBLSheenBRDF( const in vec3 normal, const in vec3 viewDir, const in float roughness ) {\n\tfloat dotNV = saturate( dot( normal, viewDir ) );\n\tfloat r2 = roughness * roughness;\n\tfloat a = roughness < 0.25 ? -339.2 * r2 + 161.4 * roughness - 25.9 : -8.48 * r2 + 14.3 * roughness - 9.95;\n\tfloat b = roughness < 0.25 ? 44.0 * r2 - 23.7 * roughness + 3.26 : 1.97 * r2 - 3.27 * roughness + 0.72;\n\tfloat DG = exp( a * dotNV + b ) + ( roughness < 0.25 ? 0.0 : 0.1 * ( roughness - 0.25 ) );\n\treturn saturate( DG * RECIPROCAL_PI );\n}\nvec2 DFGApprox( const in vec3 normal, const in vec3 viewDir, const in float roughness ) {\n\tfloat dotNV = saturate( dot( normal, viewDir ) );\n\tconst vec4 c0 = vec4( - 1, - 0.0275, - 0.572, 0.022 );\n\tconst vec4 c1 = vec4( 1, 0.0425, 1.04, - 0.04 );\n\tvec4 r = roughness * c0 + c1;\n\tfloat a004 = min( r.x * r.x, exp2( - 9.28 * dotNV ) ) * r.x + r.y;\n\tvec2 fab = vec2( - 1.04, 1.04 ) * a004 + r.zw;\n\treturn fab;\n}\nvec3 EnvironmentBRDF( const in vec3 normal, const in vec3 viewDir, const in vec3 specularColor, const in float specularF90, const in float roughness ) {\n\tvec2 fab = DFGApprox( normal, viewDir, roughness );\n\treturn specularColor * fab.x + specularF90 * fab.y;\n}\n#ifdef USE_IRIDESCENCE\nvoid computeMultiscatteringIridescence( const in vec3 normal, const in vec3 viewDir, const in vec3 specularColor, const in float specularF90, const in float iridescence, const in vec3 iridescenceF0, const in float roughness, inout vec3 singleScatter, inout vec3 multiScatter ) {\n#else\nvoid computeMultiscattering( const in vec3 normal, const in vec3 viewDir, const in vec3 specularColor, const in float specularF90, const in float roughness, inout vec3 singleScatter, inout vec3 multiScatter ) {\n#endif\n\tvec2 fab = DFGApprox( normal, viewDir, roughness );\n\t#ifdef USE_IRIDESCENCE\n\t\tvec3 Fr = mix( specularColor, iridescenceF0, iridescence );\n\t#else\n\t\tvec3 Fr = specularColor;\n\t#endif\n\tvec3 FssEss = Fr * fab.x + specularF90 * fab.y;\n\tfloat Ess = fab.x + fab.y;\n\tfloat Ems = 1.0 - Ess;\n\tvec3 Favg = Fr + ( 1.0 - Fr ) * 0.047619;\tvec3 Fms = FssEss * Favg / ( 1.0 - Ems * Favg );\n\tsingleScatter += FssEss;\n\tmultiScatter += Fms * Ems;\n}\n#if NUM_RECT_AREA_LIGHTS > 0\n\tvoid RE_Direct_RectArea_Physical( const in RectAreaLight rectAreaLight, const in vec3 geometryPosition, const in vec3 geometryNormal, const in vec3 geometryViewDir, const in vec3 geometryClearcoatNormal, const in PhysicalMaterial material, inout ReflectedLight reflectedLight ) {\n\t\tvec3 normal = geometryNormal;\n\t\tvec3 viewDir = geometryViewDir;\n\t\tvec3 position = geometryPosition;\n\t\tvec3 lightPos = rectAreaLight.position;\n\t\tvec3 halfWidth = rectAreaLight.halfWidth;\n\t\tvec3 halfHeight = rectAreaLight.halfHeight;\n\t\tvec3 lightColor = rectAreaLight.color;\n\t\tfloat roughness = material.roughness;\n\t\tvec3 rectCoords[ 4 ];\n\t\trectCoords[ 0 ] = lightPos + halfWidth - halfHeight;\t\trectCoords[ 1 ] = lightPos - halfWidth - halfHeight;\n\t\trectCoords[ 2 ] = lightPos - halfWidth + halfHeight;\n\t\trectCoords[ 3 ] = lightPos + halfWidth + halfHeight;\n\t\tvec2 uv = LTC_Uv( normal, viewDir, roughness );\n\t\tvec4 t1 = texture2D( ltc_1, uv );\n\t\tvec4 t2 = texture2D( ltc_2, uv );\n\t\tmat3 mInv = mat3(\n\t\t\tvec3( t1.x, 0, t1.y ),\n\t\t\tvec3(    0, 1,    0 ),\n\t\t\tvec3( t1.z, 0, t1.w )\n\t\t);\n\t\tvec3 fresnel = ( material.specularColor * t2.x + ( vec3( 1.0 ) - material.specularColor ) * t2.y );\n\t\treflectedLight.directSpecular += lightColor * fresnel * LTC_Evaluate( normal, viewDir, position, mInv, rectCoords );\n\t\treflectedLight.directDiffuse += lightColor * material.diffuseColor * LTC_Evaluate( normal, viewDir, position, mat3( 1.0 ), rectCoords );\n\t}\n#endif\nvoid RE_Direct_Physical( const in IncidentLight directLight, const in vec3 geometryPosition, const in vec3 geometryNormal, const in vec3 geometryViewDir, const in vec3 geometryClearcoatNormal, const in PhysicalMaterial material, inout ReflectedLight reflectedLight ) {\n\tfloat dotNL = saturate( dot( geometryNormal, directLight.direction ) );\n\tvec3 irradiance = dotNL * directLight.color;\n\t#ifdef USE_CLEARCOAT\n\t\tfloat dotNLcc = saturate( dot( geometryClearcoatNormal, directLight.direction ) );\n\t\tvec3 ccIrradiance = dotNLcc * directLight.color;\n\t\tclearcoatSpecularDirect += ccIrradiance * BRDF_GGX_Clearcoat( directLight.direction, geometryViewDir, geometryClearcoatNormal, material );\n\t#endif\n\t#ifdef USE_SHEEN\n\t\tsheenSpecularDirect += irradiance * BRDF_Sheen( directLight.direction, geometryViewDir, geometryNormal, material.sheenColor, material.sheenRoughness );\n\t#endif\n\treflectedLight.directSpecular += irradiance * BRDF_GGX( directLight.direction, geometryViewDir, geometryNormal, material );\n\treflectedLight.directDiffuse += irradiance * BRDF_Lambert( material.diffuseColor );\n}\nvoid RE_IndirectDiffuse_Physical( const in vec3 irradiance, const in vec3 geometryPosition, const in vec3 geometryNormal, const in vec3 geometryViewDir, const in vec3 geometryClearcoatNormal, const in PhysicalMaterial material, inout ReflectedLight reflectedLight ) {\n\treflectedLight.indirectDiffuse += irradiance * BRDF_Lambert( material.diffuseColor );\n}\nvoid RE_IndirectSpecular_Physical( const in vec3 radiance, const in vec3 irradiance, const in vec3 clearcoatRadiance, const in vec3 geometryPosition, const in vec3 geometryNormal, const in vec3 geometryViewDir, const in vec3 geometryClearcoatNormal, const in PhysicalMaterial material, inout ReflectedLight reflectedLight) {\n\t#ifdef USE_CLEARCOAT\n\t\tclearcoatSpecularIndirect += clearcoatRadiance * EnvironmentBRDF( geometryClearcoatNormal, geometryViewDir, material.clearcoatF0, material.clearcoatF90, material.clearcoatRoughness );\n\t#endif\n\t#ifdef USE_SHEEN\n\t\tsheenSpecularIndirect += irradiance * material.sheenColor * IBLSheenBRDF( geometryNormal, geometryViewDir, material.sheenRoughness );\n\t#endif\n\tvec3 singleScattering = vec3( 0.0 );\n\tvec3 multiScattering = vec3( 0.0 );\n\tvec3 cosineWeightedIrradiance = irradiance * RECIPROCAL_PI;\n\t#ifdef USE_IRIDESCENCE\n\t\tcomputeMultiscatteringIridescence( geometryNormal, geometryViewDir, material.specularColor, material.specularF90, material.iridescence, material.iridescenceFresnel, material.roughness, singleScattering, multiScattering );\n\t#else\n\t\tcomputeMultiscattering( geometryNormal, geometryViewDir, material.specularColor, material.specularF90, material.roughness, singleScattering, multiScattering );\n\t#endif\n\tvec3 totalScattering = singleScattering + multiScattering;\n\tvec3 diffuse = material.diffuseColor * ( 1.0 - max( max( totalScattering.r, totalScattering.g ), totalScattering.b ) );\n\treflectedLight.indirectSpecular += radiance * singleScattering;\n\treflectedLight.indirectSpecular += multiScattering * cosineWeightedIrradiance;\n\treflectedLight.indirectDiffuse += diffuse * cosineWeightedIrradiance;\n}\n#define RE_Direct\t\t\t\tRE_Direct_Physical\n#define RE_Direct_RectArea\t\tRE_Direct_RectArea_Physical\n#define RE_IndirectDiffuse\t\tRE_IndirectDiffuse_Physical\n#define RE_IndirectSpecular\t\tRE_IndirectSpecular_Physical\nfloat computeSpecularOcclusion( const in float dotNV, const in float ambientOcclusion, const in float roughness ) {\n\treturn saturate( pow( dotNV + ambientOcclusion, exp2( - 16.0 * roughness - 1.0 ) ) - 1.0 + ambientOcclusion );\n}",lights_fragment_begin="\nvec3 geometryPosition = - vViewPosition;\nvec3 geometryNormal = normal;\nvec3 geometryViewDir = ( isOrthographic ) ? vec3( 0, 0, 1 ) : normalize( vViewPosition );\nvec3 geometryClearcoatNormal = vec3( 0.0 );\n#ifdef USE_CLEARCOAT\n\tgeometryClearcoatNormal = clearcoatNormal;\n#endif\n#ifdef USE_IRIDESCENCE\n\tfloat dotNVi = saturate( dot( normal, geometryViewDir ) );\n\tif ( material.iridescenceThickness == 0.0 ) {\n\t\tmaterial.iridescence = 0.0;\n\t} else {\n\t\tmaterial.iridescence = saturate( material.iridescence );\n\t}\n\tif ( material.iridescence > 0.0 ) {\n\t\tmaterial.iridescenceFresnel = evalIridescence( 1.0, material.iridescenceIOR, dotNVi, material.iridescenceThickness, material.specularColor );\n\t\tmaterial.iridescenceF0 = Schlick_to_F0( material.iridescenceFresnel, 1.0, dotNVi );\n\t}\n#endif\nIncidentLight directLight;\n#if ( NUM_POINT_LIGHTS > 0 ) && defined( RE_Direct )\n\tPointLight pointLight;\n\t#if defined( USE_SHADOWMAP ) && NUM_POINT_LIGHT_SHADOWS > 0\n\tPointLightShadow pointLightShadow;\n\t#endif\n\t#pragma unroll_loop_start\n\tfor ( int i = 0; i < NUM_POINT_LIGHTS; i ++ ) {\n\t\tpointLight = pointLights[ i ];\n\t\tgetPointLightInfo( pointLight, geometryPosition, directLight );\n\t\t#if defined( USE_SHADOWMAP ) && ( UNROLLED_LOOP_INDEX < NUM_POINT_LIGHT_SHADOWS )\n\t\tpointLightShadow = pointLightShadows[ i ];\n\t\tdirectLight.color *= ( directLight.visible && receiveShadow ) ? getPointShadow( pointShadowMap[ i ], pointLightShadow.shadowMapSize, pointLightShadow.shadowIntensity, pointLightShadow.shadowBias, pointLightShadow.shadowRadius, vPointShadowCoord[ i ], pointLightShadow.shadowCameraNear, pointLightShadow.shadowCameraFar ) : 1.0;\n\t\t#endif\n\t\tRE_Direct( directLight, geometryPosition, geometryNormal, geometryViewDir, geometryClearcoatNormal, material, reflectedLight );\n\t}\n\t#pragma unroll_loop_end\n#endif\n#if ( NUM_SPOT_LIGHTS > 0 ) && defined( RE_Direct )\n\tSpotLight spotLight;\n\tvec4 spotColor;\n\tvec3 spotLightCoord;\n\tbool inSpotLightMap;\n\t#if defined( USE_SHADOWMAP ) && NUM_SPOT_LIGHT_SHADOWS > 0\n\tSpotLightShadow spotLightShadow;\n\t#endif\n\t#pragma unroll_loop_start\n\tfor ( int i = 0; i < NUM_SPOT_LIGHTS; i ++ ) {\n\t\tspotLight = spotLights[ i ];\n\t\tgetSpotLightInfo( spotLight, geometryPosition, directLight );\n\t\t#if ( UNROLLED_LOOP_INDEX < NUM_SPOT_LIGHT_SHADOWS_WITH_MAPS )\n\t\t#define SPOT_LIGHT_MAP_INDEX UNROLLED_LOOP_INDEX\n\t\t#elif ( UNROLLED_LOOP_INDEX < NUM_SPOT_LIGHT_SHADOWS )\n\t\t#define SPOT_LIGHT_MAP_INDEX NUM_SPOT_LIGHT_MAPS\n\t\t#else\n\t\t#define SPOT_LIGHT_MAP_INDEX ( UNROLLED_LOOP_INDEX - NUM_SPOT_LIGHT_SHADOWS + NUM_SPOT_LIGHT_SHADOWS_WITH_MAPS )\n\t\t#endif\n\t\t#if ( SPOT_LIGHT_MAP_INDEX < NUM_SPOT_LIGHT_MAPS )\n\t\t\tspotLightCoord = vSpotLightCoord[ i ].xyz / vSpotLightCoord[ i ].w;\n\t\t\tinSpotLightMap = all( lessThan( abs( spotLightCoord * 2. - 1. ), vec3( 1.0 ) ) );\n\t\t\tspotColor = texture2D( spotLightMap[ SPOT_LIGHT_MAP_INDEX ], spotLightCoord.xy );\n\t\t\tdirectLight.color = inSpotLightMap ? directLight.color * spotColor.rgb : directLight.color;\n\t\t#endif\n\t\t#undef SPOT_LIGHT_MAP_INDEX\n\t\t#if defined( USE_SHADOWMAP ) && ( UNROLLED_LOOP_INDEX < NUM_SPOT_LIGHT_SHADOWS )\n\t\tspotLightShadow = spotLightShadows[ i ];\n\t\tdirectLight.color *= ( directLight.visible && receiveShadow ) ? getShadow( spotShadowMap[ i ], spotLightShadow.shadowMapSize, spotLightShadow.shadowIntensity, spotLightShadow.shadowBias, spotLightShadow.shadowRadius, vSpotLightCoord[ i ] ) : 1.0;\n\t\t#endif\n\t\tRE_Direct( directLight, geometryPosition, geometryNormal, geometryViewDir, geometryClearcoatNormal, material, reflectedLight );\n\t}\n\t#pragma unroll_loop_end\n#endif\n#if ( NUM_DIR_LIGHTS > 0 ) && defined( RE_Direct )\n\tDirectionalLight directionalLight;\n\t#if defined( USE_SHADOWMAP ) && NUM_DIR_LIGHT_SHADOWS > 0\n\tDirectionalLightShadow directionalLightShadow;\n\t#endif\n\t#pragma unroll_loop_start\n\tfor ( int i = 0; i < NUM_DIR_LIGHTS; i ++ ) {\n\t\tdirectionalLight = directionalLights[ i ];\n\t\tgetDirectionalLightInfo( directionalLight, directLight );\n\t\t#if defined( USE_SHADOWMAP ) && ( UNROLLED_LOOP_INDEX < NUM_DIR_LIGHT_SHADOWS )\n\t\tdirectionalLightShadow = directionalLightShadows[ i ];\n\t\tdirectLight.color *= ( directLight.visible && receiveShadow ) ? getShadow( directionalShadowMap[ i ], directionalLightShadow.shadowMapSize, directionalLightShadow.shadowIntensity, directionalLightShadow.shadowBias, directionalLightShadow.shadowRadius, vDirectionalShadowCoord[ i ] ) : 1.0;\n\t\t#endif\n\t\tRE_Direct( directLight, geometryPosition, geometryNormal, geometryViewDir, geometryClearcoatNormal, material, reflectedLight );\n\t}\n\t#pragma unroll_loop_end\n#endif\n#if ( NUM_RECT_AREA_LIGHTS > 0 ) && defined( RE_Direct_RectArea )\n\tRectAreaLight rectAreaLight;\n\t#pragma unroll_loop_start\n\tfor ( int i = 0; i < NUM_RECT_AREA_LIGHTS; i ++ ) {\n\t\trectAreaLight = rectAreaLights[ i ];\n\t\tRE_Direct_RectArea( rectAreaLight, geometryPosition, geometryNormal, geometryViewDir, geometryClearcoatNormal, material, reflectedLight );\n\t}\n\t#pragma unroll_loop_end\n#endif\n#if defined( RE_IndirectDiffuse )\n\tvec3 iblIrradiance = vec3( 0.0 );\n\tvec3 irradiance = getAmbientLightIrradiance( ambientLightColor );\n\t#if defined( USE_LIGHT_PROBES )\n\t\tirradiance += getLightProbeIrradiance( lightProbe, geometryNormal );\n\t#endif\n\t#if ( NUM_HEMI_LIGHTS > 0 )\n\t\t#pragma unroll_loop_start\n\t\tfor ( int i = 0; i < NUM_HEMI_LIGHTS; i ++ ) {\n\t\t\tirradiance += getHemisphereLightIrradiance( hemisphereLights[ i ], geometryNormal );\n\t\t}\n\t\t#pragma unroll_loop_end\n\t#endif\n#endif\n#if defined( RE_IndirectSpecular )\n\tvec3 radiance = vec3( 0.0 );\n\tvec3 clearcoatRadiance = vec3( 0.0 );\n#endif",lights_fragment_maps="#if defined( RE_IndirectDiffuse )\n\t#ifdef USE_LIGHTMAP\n\t\tvec4 lightMapTexel = texture2D( lightMap, vLightMapUv );\n\t\tvec3 lightMapIrradiance = lightMapTexel.rgb * lightMapIntensity;\n\t\tirradiance += lightMapIrradiance;\n\t#endif\n\t#if defined( USE_ENVMAP ) && defined( STANDARD ) && defined( ENVMAP_TYPE_CUBE_UV )\n\t\tiblIrradiance += getIBLIrradiance( geometryNormal );\n\t#endif\n#endif\n#if defined( USE_ENVMAP ) && defined( RE_IndirectSpecular )\n\t#ifdef USE_ANISOTROPY\n\t\tradiance += getIBLAnisotropyRadiance( geometryViewDir, geometryNormal, material.roughness, material.anisotropyB, material.anisotropy );\n\t#else\n\t\tradiance += getIBLRadiance( geometryViewDir, geometryNormal, material.roughness );\n\t#endif\n\t#ifdef USE_CLEARCOAT\n\t\tclearcoatRadiance += getIBLRadiance( geometryViewDir, geometryClearcoatNormal, material.clearcoatRoughness );\n\t#endif\n#endif",lights_fragment_end="#if defined( RE_IndirectDiffuse )\n\tRE_IndirectDiffuse( irradiance, geometryPosition, geometryNormal, geometryViewDir, geometryClearcoatNormal, material, reflectedLight );\n#endif\n#if defined( RE_IndirectSpecular )\n\tRE_IndirectSpecular( radiance, iblIrradiance, clearcoatRadiance, geometryPosition, geometryNormal, geometryViewDir, geometryClearcoatNormal, material, reflectedLight );\n#endif",logdepthbuf_fragment="#if defined( USE_LOGDEPTHBUF )\n\tgl_FragDepth = vIsPerspective == 0.0 ? gl_FragCoord.z : log2( vFragDepth ) * logDepthBufFC * 0.5;\n#endif",logdepthbuf_pars_fragment="#if defined( USE_LOGDEPTHBUF )\n\tuniform float logDepthBufFC;\n\tvarying float vFragDepth;\n\tvarying float vIsPerspective;\n#endif",logdepthbuf_pars_vertex="#ifdef USE_LOGDEPTHBUF\n\tvarying float vFragDepth;\n\tvarying float vIsPerspective;\n#endif",logdepthbuf_vertex="#ifdef USE_LOGDEPTHBUF\n\tvFragDepth = 1.0 + gl_Position.w;\n\tvIsPerspective = float( isPerspectiveMatrix( projectionMatrix ) );\n#endif",map_fragment="#ifdef USE_MAP\n\tvec4 sampledDiffuseColor = texture2D( map, vMapUv );\n\t#ifdef DECODE_VIDEO_TEXTURE\n\t\tsampledDiffuseColor = sRGBTransferEOTF( sampledDiffuseColor );\n\t#endif\n\tdiffuseColor *= sampledDiffuseColor;\n#endif",map_pars_fragment="#ifdef USE_MAP\n\tuniform sampler2D map;\n#endif",map_particle_fragment="#if defined( USE_MAP ) || defined( USE_ALPHAMAP )\n\t#if defined( USE_POINTS_UV )\n\t\tvec2 uv = vUv;\n\t#else\n\t\tvec2 uv = ( uvTransform * vec3( gl_PointCoord.x, 1.0 - gl_PointCoord.y, 1 ) ).xy;\n\t#endif\n#endif\n#ifdef USE_MAP\n\tdiffuseColor *= texture2D( map, uv );\n#endif\n#ifdef USE_ALPHAMAP\n\tdiffuseColor.a *= texture2D( alphaMap, uv ).g;\n#endif",map_particle_pars_fragment="#if defined( USE_POINTS_UV )\n\tvarying vec2 vUv;\n#else\n\t#if defined( USE_MAP ) || defined( USE_ALPHAMAP )\n\t\tuniform mat3 uvTransform;\n\t#endif\n#endif\n#ifdef USE_MAP\n\tuniform sampler2D map;\n#endif\n#ifdef USE_ALPHAMAP\n\tuniform sampler2D alphaMap;\n#endif",metalnessmap_fragment="float metalnessFactor = metalness;\n#ifdef USE_METALNESSMAP\n\tvec4 texelMetalness = texture2D( metalnessMap, vMetalnessMapUv );\n\tmetalnessFactor *= texelMetalness.b;\n#endif",metalnessmap_pars_fragment="#ifdef USE_METALNESSMAP\n\tuniform sampler2D metalnessMap;\n#endif",morphinstance_vertex="#ifdef USE_INSTANCING_MORPH\n\tfloat morphTargetInfluences[ MORPHTARGETS_COUNT ];\n\tfloat morphTargetBaseInfluence = texelFetch( morphTexture, ivec2( 0, gl_InstanceID ), 0 ).r;\n\tfor ( int i = 0; i < MORPHTARGETS_COUNT; i ++ ) {\n\t\tmorphTargetInfluences[i] =  texelFetch( morphTexture, ivec2( i + 1, gl_InstanceID ), 0 ).r;\n\t}\n#endif",morphcolor_vertex="#if defined( USE_MORPHCOLORS )\n\tvColor *= morphTargetBaseInfluence;\n\tfor ( int i = 0; i < MORPHTARGETS_COUNT; i ++ ) {\n\t\t#if defined( USE_COLOR_ALPHA )\n\t\t\tif ( morphTargetInfluences[ i ] != 0.0 ) vColor += getMorph( gl_VertexID, i, 2 ) * morphTargetInfluences[ i ];\n\t\t#elif defined( USE_COLOR )\n\t\t\tif ( morphTargetInfluences[ i ] != 0.0 ) vColor += getMorph( gl_VertexID, i, 2 ).rgb * morphTargetInfluences[ i ];\n\t\t#endif\n\t}\n#endif",morphnormal_vertex="#ifdef USE_MORPHNORMALS\n\tobjectNormal *= morphTargetBaseInfluence;\n\tfor ( int i = 0; i < MORPHTARGETS_COUNT; i ++ ) {\n\t\tif ( morphTargetInfluences[ i ] != 0.0 ) objectNormal += getMorph( gl_VertexID, i, 1 ).xyz * morphTargetInfluences[ i ];\n\t}\n#endif",morphtarget_pars_vertex="#ifdef USE_MORPHTARGETS\n\t#ifndef USE_INSTANCING_MORPH\n\t\tuniform float morphTargetBaseInfluence;\n\t\tuniform float morphTargetInfluences[ MORPHTARGETS_COUNT ];\n\t#endif\n\tuniform sampler2DArray morphTargetsTexture;\n\tuniform ivec2 morphTargetsTextureSize;\n\tvec4 getMorph( const in int vertexIndex, const in int morphTargetIndex, const in int offset ) {\n\t\tint texelIndex = vertexIndex * MORPHTARGETS_TEXTURE_STRIDE + offset;\n\t\tint y = texelIndex / morphTargetsTextureSize.x;\n\t\tint x = texelIndex - y * morphTargetsTextureSize.x;\n\t\tivec3 morphUV = ivec3( x, y, morphTargetIndex );\n\t\treturn texelFetch( morphTargetsTexture, morphUV, 0 );\n\t}\n#endif",morphtarget_vertex="#ifdef USE_MORPHTARGETS\n\ttransformed *= morphTargetBaseInfluence;\n\tfor ( int i = 0; i < MORPHTARGETS_COUNT; i ++ ) {\n\t\tif ( morphTargetInfluences[ i ] != 0.0 ) transformed += getMorph( gl_VertexID, i, 0 ).xyz * morphTargetInfluences[ i ];\n\t}\n#endif",normal_fragment_begin="float faceDirection = gl_FrontFacing ? 1.0 : - 1.0;\n#ifdef FLAT_SHADED\n\tvec3 fdx = dFdx( vViewPosition );\n\tvec3 fdy = dFdy( vViewPosition );\n\tvec3 normal = normalize( cross( fdx, fdy ) );\n#else\n\tvec3 normal = normalize( vNormal );\n\t#ifdef DOUBLE_SIDED\n\t\tnormal *= faceDirection;\n\t#endif\n#endif\n#if defined( USE_NORMALMAP_TANGENTSPACE ) || defined( USE_CLEARCOAT_NORMALMAP ) || defined( USE_ANISOTROPY )\n\t#ifdef USE_TANGENT\n\t\tmat3 tbn = mat3( normalize( vTangent ), normalize( vBitangent ), normal );\n\t#else\n\t\tmat3 tbn = getTangentFrame( - vViewPosition, normal,\n\t\t#if defined( USE_NORMALMAP )\n\t\t\tvNormalMapUv\n\t\t#elif defined( USE_CLEARCOAT_NORMALMAP )\n\t\t\tvClearcoatNormalMapUv\n\t\t#else\n\t\t\tvUv\n\t\t#endif\n\t\t);\n\t#endif\n\t#if defined( DOUBLE_SIDED ) && ! defined( FLAT_SHADED )\n\t\ttbn[0] *= faceDirection;\n\t\ttbn[1] *= faceDirection;\n\t#endif\n#endif\n#ifdef USE_CLEARCOAT_NORMALMAP\n\t#ifdef USE_TANGENT\n\t\tmat3 tbn2 = mat3( normalize( vTangent ), normalize( vBitangent ), normal );\n\t#else\n\t\tmat3 tbn2 = getTangentFrame( - vViewPosition, normal, vClearcoatNormalMapUv );\n\t#endif\n\t#if defined( DOUBLE_SIDED ) && ! defined( FLAT_SHADED )\n\t\ttbn2[0] *= faceDirection;\n\t\ttbn2[1] *= faceDirection;\n\t#endif\n#endif\nvec3 nonPerturbedNormal = normal;",normal_fragment_maps="#ifdef USE_NORMALMAP_OBJECTSPACE\n\tnormal = texture2D( normalMap, vNormalMapUv ).xyz * 2.0 - 1.0;\n\t#ifdef FLIP_SIDED\n\t\tnormal = - normal;\n\t#endif\n\t#ifdef DOUBLE_SIDED\n\t\tnormal = normal * faceDirection;\n\t#endif\n\tnormal = normalize( normalMatrix * normal );\n#elif defined( USE_NORMALMAP_TANGENTSPACE )\n\tvec3 mapN = texture2D( normalMap, vNormalMapUv ).xyz * 2.0 - 1.0;\n\tmapN.xy *= normalScale;\n\tnormal = normalize( tbn * mapN );\n#elif defined( USE_BUMPMAP )\n\tnormal = perturbNormalArb( - vViewPosition, normal, dHdxy_fwd(), faceDirection );\n#endif",normal_pars_fragment="#ifndef FLAT_SHADED\n\tvarying vec3 vNormal;\n\t#ifdef USE_TANGENT\n\t\tvarying vec3 vTangent;\n\t\tvarying vec3 vBitangent;\n\t#endif\n#endif",normal_pars_vertex="#ifndef FLAT_SHADED\n\tvarying vec3 vNormal;\n\t#ifdef USE_TANGENT\n\t\tvarying vec3 vTangent;\n\t\tvarying vec3 vBitangent;\n\t#endif\n#endif",normal_vertex="#ifndef FLAT_SHADED\n\tvNormal = normalize( transformedNormal );\n\t#ifdef USE_TANGENT\n\t\tvTangent = normalize( transformedTangent );\n\t\tvBitangent = normalize( cross( vNormal, vTangent ) * tangent.w );\n\t#endif\n#endif",normalmap_pars_fragment="#ifdef USE_NORMALMAP\n\tuniform sampler2D normalMap;\n\tuniform vec2 normalScale;\n#endif\n#ifdef USE_NORMALMAP_OBJECTSPACE\n\tuniform mat3 normalMatrix;\n#endif\n#if ! defined ( USE_TANGENT ) && ( defined ( USE_NORMALMAP_TANGENTSPACE ) || defined ( USE_CLEARCOAT_NORMALMAP ) || defined( USE_ANISOTROPY ) )\n\tmat3 getTangentFrame( vec3 eye_pos, vec3 surf_norm, vec2 uv ) {\n\t\tvec3 q0 = dFdx( eye_pos.xyz );\n\t\tvec3 q1 = dFdy( eye_pos.xyz );\n\t\tvec2 st0 = dFdx( uv.st );\n\t\tvec2 st1 = dFdy( uv.st );\n\t\tvec3 N = surf_norm;\n\t\tvec3 q1perp = cross( q1, N );\n\t\tvec3 q0perp = cross( N, q0 );\n\t\tvec3 T = q1perp * st0.x + q0perp * st1.x;\n\t\tvec3 B = q1perp * st0.y + q0perp * st1.y;\n\t\tfloat det = max( dot( T, T ), dot( B, B ) );\n\t\tfloat scale = ( det == 0.0 ) ? 0.0 : inversesqrt( det );\n\t\treturn mat3( T * scale, B * scale, N );\n\t}\n#endif",clearcoat_normal_fragment_begin="#ifdef USE_CLEARCOAT\n\tvec3 clearcoatNormal = nonPerturbedNormal;\n#endif",clearcoat_normal_fragment_maps="#ifdef USE_CLEARCOAT_NORMALMAP\n\tvec3 clearcoatMapN = texture2D( clearcoatNormalMap, vClearcoatNormalMapUv ).xyz * 2.0 - 1.0;\n\tclearcoatMapN.xy *= clearcoatNormalScale;\n\tclearcoatNormal = normalize( tbn2 * clearcoatMapN );\n#endif",clearcoat_pars_fragment="#ifdef USE_CLEARCOATMAP\n\tuniform sampler2D clearcoatMap;\n#endif\n#ifdef USE_CLEARCOAT_NORMALMAP\n\tuniform sampler2D clearcoatNormalMap;\n\tuniform vec2 clearcoatNormalScale;\n#endif\n#ifdef USE_CLEARCOAT_ROUGHNESSMAP\n\tuniform sampler2D clearcoatRoughnessMap;\n#endif",iridescence_pars_fragment="#ifdef USE_IRIDESCENCEMAP\n\tuniform sampler2D iridescenceMap;\n#endif\n#ifdef USE_IRIDESCENCE_THICKNESSMAP\n\tuniform sampler2D iridescenceThicknessMap;\n#endif",opaque_fragment="#ifdef OPAQUE\ndiffuseColor.a = 1.0;\n#endif\n#ifdef USE_TRANSMISSION\ndiffuseColor.a *= material.transmissionAlpha;\n#endif\ngl_FragColor = vec4( outgoingLight, diffuseColor.a );",packing="vec3 packNormalToRGB( const in vec3 normal ) {\n\treturn normalize( normal ) * 0.5 + 0.5;\n}\nvec3 unpackRGBToNormal( const in vec3 rgb ) {\n\treturn 2.0 * rgb.xyz - 1.0;\n}\nconst float PackUpscale = 256. / 255.;const float UnpackDownscale = 255. / 256.;const float ShiftRight8 = 1. / 256.;\nconst float Inv255 = 1. / 255.;\nconst vec4 PackFactors = vec4( 1.0, 256.0, 256.0 * 256.0, 256.0 * 256.0 * 256.0 );\nconst vec2 UnpackFactors2 = vec2( UnpackDownscale, 1.0 / PackFactors.g );\nconst vec3 UnpackFactors3 = vec3( UnpackDownscale / PackFactors.rg, 1.0 / PackFactors.b );\nconst vec4 UnpackFactors4 = vec4( UnpackDownscale / PackFactors.rgb, 1.0 / PackFactors.a );\nvec4 packDepthToRGBA( const in float v ) {\n\tif( v <= 0.0 )\n\t\treturn vec4( 0., 0., 0., 0. );\n\tif( v >= 1.0 )\n\t\treturn vec4( 1., 1., 1., 1. );\n\tfloat vuf;\n\tfloat af = modf( v * PackFactors.a, vuf );\n\tfloat bf = modf( vuf * ShiftRight8, vuf );\n\tfloat gf = modf( vuf * ShiftRight8, vuf );\n\treturn vec4( vuf * Inv255, gf * PackUpscale, bf * PackUpscale, af );\n}\nvec3 packDepthToRGB( const in float v ) {\n\tif( v <= 0.0 )\n\t\treturn vec3( 0., 0., 0. );\n\tif( v >= 1.0 )\n\t\treturn vec3( 1., 1., 1. );\n\tfloat vuf;\n\tfloat bf = modf( v * PackFactors.b, vuf );\n\tfloat gf = modf( vuf * ShiftRight8, vuf );\n\treturn vec3( vuf * Inv255, gf * PackUpscale, bf );\n}\nvec2 packDepthToRG( const in float v ) {\n\tif( v <= 0.0 )\n\t\treturn vec2( 0., 0. );\n\tif( v >= 1.0 )\n\t\treturn vec2( 1., 1. );\n\tfloat vuf;\n\tfloat gf = modf( v * 256., vuf );\n\treturn vec2( vuf * Inv255, gf );\n}\nfloat unpackRGBAToDepth( const in vec4 v ) {\n\treturn dot( v, UnpackFactors4 );\n}\nfloat unpackRGBToDepth( const in vec3 v ) {\n\treturn dot( v, UnpackFactors3 );\n}\nfloat unpackRGToDepth( const in vec2 v ) {\n\treturn v.r * UnpackFactors2.r + v.g * UnpackFactors2.g;\n}\nvec4 pack2HalfToRGBA( const in vec2 v ) {\n\tvec4 r = vec4( v.x, fract( v.x * 255.0 ), v.y, fract( v.y * 255.0 ) );\n\treturn vec4( r.x - r.y / 255.0, r.y, r.z - r.w / 255.0, r.w );\n}\nvec2 unpackRGBATo2Half( const in vec4 v ) {\n\treturn vec2( v.x + ( v.y / 255.0 ), v.z + ( v.w / 255.0 ) );\n}\nfloat viewZToOrthographicDepth( const in float viewZ, const in float near, const in float far ) {\n\treturn ( viewZ + near ) / ( near - far );\n}\nfloat orthographicDepthToViewZ( const in float depth, const in float near, const in float far ) {\n\treturn depth * ( near - far ) - near;\n}\nfloat viewZToPerspectiveDepth( const in float viewZ, const in float near, const in float far ) {\n\treturn ( ( near + viewZ ) * far ) / ( ( far - near ) * viewZ );\n}\nfloat perspectiveDepthToViewZ( const in float depth, const in float near, const in float far ) {\n\treturn ( near * far ) / ( ( far - near ) * depth - far );\n}",premultiplied_alpha_fragment="#ifdef PREMULTIPLIED_ALPHA\n\tgl_FragColor.rgb *= gl_FragColor.a;\n#endif",project_vertex="vec4 mvPosition = vec4( transformed, 1.0 );\n#ifdef USE_BATCHING\n\tmvPosition = batchingMatrix * mvPosition;\n#endif\n#ifdef USE_INSTANCING\n\tmvPosition = instanceMatrix * mvPosition;\n#endif\nmvPosition = modelViewMatrix * mvPosition;\ngl_Position = projectionMatrix * mvPosition;",dithering_fragment="#ifdef DITHERING\n\tgl_FragColor.rgb = dithering( gl_FragColor.rgb );\n#endif",dithering_pars_fragment="#ifdef DITHERING\n\tvec3 dithering( vec3 color ) {\n\t\tfloat grid_position = rand( gl_FragCoord.xy );\n\t\tvec3 dither_shift_RGB = vec3( 0.25 / 255.0, -0.25 / 255.0, 0.25 / 255.0 );\n\t\tdither_shift_RGB = mix( 2.0 * dither_shift_RGB, -2.0 * dither_shift_RGB, grid_position );\n\t\treturn color + dither_shift_RGB;\n\t}\n#endif",roughnessmap_fragment="float roughnessFactor = roughness;\n#ifdef USE_ROUGHNESSMAP\n\tvec4 texelRoughness = texture2D( roughnessMap, vRoughnessMapUv );\n\troughnessFactor *= texelRoughness.g;\n#endif",roughnessmap_pars_fragment="#ifdef USE_ROUGHNESSMAP\n\tuniform sampler2D roughnessMap;\n#endif",shadowmap_pars_fragment="#if NUM_SPOT_LIGHT_COORDS > 0\n\tvarying vec4 vSpotLightCoord[ NUM_SPOT_LIGHT_COORDS ];\n#endif\n#if NUM_SPOT_LIGHT_MAPS > 0\n\tuniform sampler2D spotLightMap[ NUM_SPOT_LIGHT_MAPS ];\n#endif\n#ifdef USE_SHADOWMAP\n\t#if NUM_DIR_LIGHT_SHADOWS > 0\n\t\tuniform sampler2D directionalShadowMap[ NUM_DIR_LIGHT_SHADOWS ];\n\t\tvarying vec4 vDirectionalShadowCoord[ NUM_DIR_LIGHT_SHADOWS ];\n\t\tstruct DirectionalLightShadow {\n\t\t\tfloat shadowIntensity;\n\t\t\tfloat shadowBias;\n\t\t\tfloat shadowNormalBias;\n\t\t\tfloat shadowRadius;\n\t\t\tvec2 shadowMapSize;\n\t\t};\n\t\tuniform DirectionalLightShadow directionalLightShadows[ NUM_DIR_LIGHT_SHADOWS ];\n\t#endif\n\t#if NUM_SPOT_LIGHT_SHADOWS > 0\n\t\tuniform sampler2D spotShadowMap[ NUM_SPOT_LIGHT_SHADOWS ];\n\t\tstruct SpotLightShadow {\n\t\t\tfloat shadowIntensity;\n\t\t\tfloat shadowBias;\n\t\t\tfloat shadowNormalBias;\n\t\t\tfloat shadowRadius;\n\t\t\tvec2 shadowMapSize;\n\t\t};\n\t\tuniform SpotLightShadow spotLightShadows[ NUM_SPOT_LIGHT_SHADOWS ];\n\t#endif\n\t#if NUM_POINT_LIGHT_SHADOWS > 0\n\t\tuniform sampler2D pointShadowMap[ NUM_POINT_LIGHT_SHADOWS ];\n\t\tvarying vec4 vPointShadowCoord[ NUM_POINT_LIGHT_SHADOWS ];\n\t\tstruct PointLightShadow {\n\t\t\tfloat shadowIntensity;\n\t\t\tfloat shadowBias;\n\t\t\tfloat shadowNormalBias;\n\t\t\tfloat shadowRadius;\n\t\t\tvec2 shadowMapSize;\n\t\t\tfloat shadowCameraNear;\n\t\t\tfloat shadowCameraFar;\n\t\t};\n\t\tuniform PointLightShadow pointLightShadows[ NUM_POINT_LIGHT_SHADOWS ];\n\t#endif\n\tfloat texture2DCompare( sampler2D depths, vec2 uv, float compare ) {\n\t\treturn step( compare, unpackRGBAToDepth( texture2D( depths, uv ) ) );\n\t}\n\tvec2 texture2DDistribution( sampler2D shadow, vec2 uv ) {\n\t\treturn unpackRGBATo2Half( texture2D( shadow, uv ) );\n\t}\n\tfloat VSMShadow (sampler2D shadow, vec2 uv, float compare ){\n\t\tfloat occlusion = 1.0;\n\t\tvec2 distribution = texture2DDistribution( shadow, uv );\n\t\tfloat hard_shadow = step( compare , distribution.x );\n\t\tif (hard_shadow != 1.0 ) {\n\t\t\tfloat distance = compare - distribution.x ;\n\t\t\tfloat variance = max( 0.00000, distribution.y * distribution.y );\n\t\t\tfloat softness_probability = variance / (variance + distance * distance );\t\t\tsoftness_probability = clamp( ( softness_probability - 0.3 ) / ( 0.95 - 0.3 ), 0.0, 1.0 );\t\t\tocclusion = clamp( max( hard_shadow, softness_probability ), 0.0, 1.0 );\n\t\t}\n\t\treturn occlusion;\n\t}\n\tfloat getShadow( sampler2D shadowMap, vec2 shadowMapSize, float shadowIntensity, float shadowBias, float shadowRadius, vec4 shadowCoord ) {\n\t\tfloat shadow = 1.0;\n\t\tshadowCoord.xyz /= shadowCoord.w;\n\t\tshadowCoord.z += shadowBias;\n\t\tbool inFrustum = shadowCoord.x >= 0.0 && shadowCoord.x <= 1.0 && shadowCoord.y >= 0.0 && shadowCoord.y <= 1.0;\n\t\tbool frustumTest = inFrustum && shadowCoord.z <= 1.0;\n\t\tif ( frustumTest ) {\n\t\t#if defined( SHADOWMAP_TYPE_PCF )\n\t\t\tvec2 texelSize = vec2( 1.0 ) / shadowMapSize;\n\t\t\tfloat dx0 = - texelSize.x * shadowRadius;\n\t\t\tfloat dy0 = - texelSize.y * shadowRadius;\n\t\t\tfloat dx1 = + texelSize.x * shadowRadius;\n\t\t\tfloat dy1 = + texelSize.y * shadowRadius;\n\t\t\tfloat dx2 = dx0 / 2.0;\n\t\t\tfloat dy2 = dy0 / 2.0;\n\t\t\tfloat dx3 = dx1 / 2.0;\n\t\t\tfloat dy3 = dy1 / 2.0;\n\t\t\tshadow = (\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx0, dy0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( 0.0, dy0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx1, dy0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx2, dy2 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( 0.0, dy2 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx3, dy2 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx0, 0.0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx2, 0.0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy, shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx3, 0.0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx1, 0.0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx2, dy3 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( 0.0, dy3 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx3, dy3 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx0, dy1 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( 0.0, dy1 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx1, dy1 ), shadowCoord.z )\n\t\t\t) * ( 1.0 / 17.0 );\n\t\t#elif defined( SHADOWMAP_TYPE_PCF_SOFT )\n\t\t\tvec2 texelSize = vec2( 1.0 ) / shadowMapSize;\n\t\t\tfloat dx = texelSize.x;\n\t\t\tfloat dy = texelSize.y;\n\t\t\tvec2 uv = shadowCoord.xy;\n\t\t\tvec2 f = fract( uv * shadowMapSize + 0.5 );\n\t\t\tuv -= f * texelSize;\n\t\t\tshadow = (\n\t\t\t\ttexture2DCompare( shadowMap, uv, shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, uv + vec2( dx, 0.0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, uv + vec2( 0.0, dy ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, uv + texelSize, shadowCoord.z ) +\n\t\t\t\tmix( texture2DCompare( shadowMap, uv + vec2( -dx, 0.0 ), shadowCoord.z ),\n\t\t\t\t\t texture2DCompare( shadowMap, uv + vec2( 2.0 * dx, 0.0 ), shadowCoord.z ),\n\t\t\t\t\t f.x ) +\n\t\t\t\tmix( texture2DCompare( shadowMap, uv + vec2( -dx, dy ), shadowCoord.z ),\n\t\t\t\t\t texture2DCompare( shadowMap, uv + vec2( 2.0 * dx, dy ), shadowCoord.z ),\n\t\t\t\t\t f.x ) +\n\t\t\t\tmix( texture2DCompare( shadowMap, uv + vec2( 0.0, -dy ), shadowCoord.z ),\n\t\t\t\t\t texture2DCompare( shadowMap, uv + vec2( 0.0, 2.0 * dy ), shadowCoord.z ),\n\t\t\t\t\t f.y ) +\n\t\t\t\tmix( texture2DCompare( shadowMap, uv + vec2( dx, -dy ), shadowCoord.z ),\n\t\t\t\t\t texture2DCompare( shadowMap, uv + vec2( dx, 2.0 * dy ), shadowCoord.z ),\n\t\t\t\t\t f.y ) +\n\t\t\t\tmix( mix( texture2DCompare( shadowMap, uv + vec2( -dx, -dy ), shadowCoord.z ),\n\t\t\t\t\t\t  texture2DCompare( shadowMap, uv + vec2( 2.0 * dx, -dy ), shadowCoord.z ),\n\t\t\t\t\t\t  f.x ),\n\t\t\t\t\t mix( texture2DCompare( shadowMap, uv + vec2( -dx, 2.0 * dy ), shadowCoord.z ),\n\t\t\t\t\t\t  texture2DCompare( shadowMap, uv + vec2( 2.0 * dx, 2.0 * dy ), shadowCoord.z ),\n\t\t\t\t\t\t  f.x ),\n\t\t\t\t\t f.y )\n\t\t\t) * ( 1.0 / 9.0 );\n\t\t#elif defined( SHADOWMAP_TYPE_VSM )\n\t\t\tshadow = VSMShadow( shadowMap, shadowCoord.xy, shadowCoord.z );\n\t\t#else\n\t\t\tshadow = texture2DCompare( shadowMap, shadowCoord.xy, shadowCoord.z );\n\t\t#endif\n\t\t}\n\t\treturn mix( 1.0, shadow, shadowIntensity );\n\t}\n\tvec2 cubeToUV( vec3 v, float texelSizeY ) {\n\t\tvec3 absV = abs( v );\n\t\tfloat scaleToCube = 1.0 / max( absV.x, max( absV.y, absV.z ) );\n\t\tabsV *= scaleToCube;\n\t\tv *= scaleToCube * ( 1.0 - 2.0 * texelSizeY );\n\t\tvec2 planar = v.xy;\n\t\tfloat almostATexel = 1.5 * texelSizeY;\n\t\tfloat almostOne = 1.0 - almostATexel;\n\t\tif ( absV.z >= almostOne ) {\n\t\t\tif ( v.z > 0.0 )\n\t\t\t\tplanar.x = 4.0 - v.x;\n\t\t} else if ( absV.x >= almostOne ) {\n\t\t\tfloat signX = sign( v.x );\n\t\t\tplanar.x = v.z * signX + 2.0 * signX;\n\t\t} else if ( absV.y >= almostOne ) {\n\t\t\tfloat signY = sign( v.y );\n\t\t\tplanar.x = v.x + 2.0 * signY + 2.0;\n\t\t\tplanar.y = v.z * signY - 2.0;\n\t\t}\n\t\treturn vec2( 0.125, 0.25 ) * planar + vec2( 0.375, 0.75 );\n\t}\n\tfloat getPointShadow( sampler2D shadowMap, vec2 shadowMapSize, float shadowIntensity, float shadowBias, float shadowRadius, vec4 shadowCoord, float shadowCameraNear, float shadowCameraFar ) {\n\t\tfloat shadow = 1.0;\n\t\tvec3 lightToPosition = shadowCoord.xyz;\n\t\t\n\t\tfloat lightToPositionLength = length( lightToPosition );\n\t\tif ( lightToPositionLength - shadowCameraFar <= 0.0 && lightToPositionLength - shadowCameraNear >= 0.0 ) {\n\t\t\tfloat dp = ( lightToPositionLength - shadowCameraNear ) / ( shadowCameraFar - shadowCameraNear );\t\t\tdp += shadowBias;\n\t\t\tvec3 bd3D = normalize( lightToPosition );\n\t\t\tvec2 texelSize = vec2( 1.0 ) / ( shadowMapSize * vec2( 4.0, 2.0 ) );\n\t\t\t#if defined( SHADOWMAP_TYPE_PCF ) || defined( SHADOWMAP_TYPE_PCF_SOFT ) || defined( SHADOWMAP_TYPE_VSM )\n\t\t\t\tvec2 offset = vec2( - 1, 1 ) * shadowRadius * texelSize.y;\n\t\t\t\tshadow = (\n\t\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.xyy, texelSize.y ), dp ) +\n\t\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.yyy, texelSize.y ), dp ) +\n\t\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.xyx, texelSize.y ), dp ) +\n\t\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.yyx, texelSize.y ), dp ) +\n\t\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D, texelSize.y ), dp ) +\n\t\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.xxy, texelSize.y ), dp ) +\n\t\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.yxy, texelSize.y ), dp ) +\n\t\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.xxx, texelSize.y ), dp ) +\n\t\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.yxx, texelSize.y ), dp )\n\t\t\t\t) * ( 1.0 / 9.0 );\n\t\t\t#else\n\t\t\t\tshadow = texture2DCompare( shadowMap, cubeToUV( bd3D, texelSize.y ), dp );\n\t\t\t#endif\n\t\t}\n\t\treturn mix( 1.0, shadow, shadowIntensity );\n\t}\n#endif",shadowmap_pars_vertex="#if NUM_SPOT_LIGHT_COORDS > 0\n\tuniform mat4 spotLightMatrix[ NUM_SPOT_LIGHT_COORDS ];\n\tvarying vec4 vSpotLightCoord[ NUM_SPOT_LIGHT_COORDS ];\n#endif\n#ifdef USE_SHADOWMAP\n\t#if NUM_DIR_LIGHT_SHADOWS > 0\n\t\tuniform mat4 directionalShadowMatrix[ NUM_DIR_LIGHT_SHADOWS ];\n\t\tvarying vec4 vDirectionalShadowCoord[ NUM_DIR_LIGHT_SHADOWS ];\n\t\tstruct DirectionalLightShadow {\n\t\t\tfloat shadowIntensity;\n\t\t\tfloat shadowBias;\n\t\t\tfloat shadowNormalBias;\n\t\t\tfloat shadowRadius;\n\t\t\tvec2 shadowMapSize;\n\t\t};\n\t\tuniform DirectionalLightShadow directionalLightShadows[ NUM_DIR_LIGHT_SHADOWS ];\n\t#endif\n\t#if NUM_SPOT_LIGHT_SHADOWS > 0\n\t\tstruct SpotLightShadow {\n\t\t\tfloat shadowIntensity;\n\t\t\tfloat shadowBias;\n\t\t\tfloat shadowNormalBias;\n\t\t\tfloat shadowRadius;\n\t\t\tvec2 shadowMapSize;\n\t\t};\n\t\tuniform SpotLightShadow spotLightShadows[ NUM_SPOT_LIGHT_SHADOWS ];\n\t#endif\n\t#if NUM_POINT_LIGHT_SHADOWS > 0\n\t\tuniform mat4 pointShadowMatrix[ NUM_POINT_LIGHT_SHADOWS ];\n\t\tvarying vec4 vPointShadowCoord[ NUM_POINT_LIGHT_SHADOWS ];\n\t\tstruct PointLightShadow {\n\t\t\tfloat shadowIntensity;\n\t\t\tfloat shadowBias;\n\t\t\tfloat shadowNormalBias;\n\t\t\tfloat shadowRadius;\n\t\t\tvec2 shadowMapSize;\n\t\t\tfloat shadowCameraNear;\n\t\t\tfloat shadowCameraFar;\n\t\t};\n\t\tuniform PointLightShadow pointLightShadows[ NUM_POINT_LIGHT_SHADOWS ];\n\t#endif\n#endif",shadowmap_vertex="#if ( defined( USE_SHADOWMAP ) && ( NUM_DIR_LIGHT_SHADOWS > 0 || NUM_POINT_LIGHT_SHADOWS > 0 ) ) || ( NUM_SPOT_LIGHT_COORDS > 0 )\n\tvec3 shadowWorldNormal = inverseTransformDirection( transformedNormal, viewMatrix );\n\tvec4 shadowWorldPosition;\n#endif\n#if defined( USE_SHADOWMAP )\n\t#if NUM_DIR_LIGHT_SHADOWS > 0\n\t\t#pragma unroll_loop_start\n\t\tfor ( int i = 0; i < NUM_DIR_LIGHT_SHADOWS; i ++ ) {\n\t\t\tshadowWorldPosition = worldPosition + vec4( shadowWorldNormal * directionalLightShadows[ i ].shadowNormalBias, 0 );\n\t\t\tvDirectionalShadowCoord[ i ] = directionalShadowMatrix[ i ] * shadowWorldPosition;\n\t\t}\n\t\t#pragma unroll_loop_end\n\t#endif\n\t#if NUM_POINT_LIGHT_SHADOWS > 0\n\t\t#pragma unroll_loop_start\n\t\tfor ( int i = 0; i < NUM_POINT_LIGHT_SHADOWS; i ++ ) {\n\t\t\tshadowWorldPosition = worldPosition + vec4( shadowWorldNormal * pointLightShadows[ i ].shadowNormalBias, 0 );\n\t\t\tvPointShadowCoord[ i ] = pointShadowMatrix[ i ] * shadowWorldPosition;\n\t\t}\n\t\t#pragma unroll_loop_end\n\t#endif\n#endif\n#if NUM_SPOT_LIGHT_COORDS > 0\n\t#pragma unroll_loop_start\n\tfor ( int i = 0; i < NUM_SPOT_LIGHT_COORDS; i ++ ) {\n\t\tshadowWorldPosition = worldPosition;\n\t\t#if ( defined( USE_SHADOWMAP ) && UNROLLED_LOOP_INDEX < NUM_SPOT_LIGHT_SHADOWS )\n\t\t\tshadowWorldPosition.xyz += shadowWorldNormal * spotLightShadows[ i ].shadowNormalBias;\n\t\t#endif\n\t\tvSpotLightCoord[ i ] = spotLightMatrix[ i ] * shadowWorldPosition;\n\t}\n\t#pragma unroll_loop_end\n#endif",shadowmask_pars_fragment="float getShadowMask() {\n\tfloat shadow = 1.0;\n\t#ifdef USE_SHADOWMAP\n\t#if NUM_DIR_LIGHT_SHADOWS > 0\n\tDirectionalLightShadow directionalLight;\n\t#pragma unroll_loop_start\n\tfor ( int i = 0; i < NUM_DIR_LIGHT_SHADOWS; i ++ ) {\n\t\tdirectionalLight = directionalLightShadows[ i ];\n\t\tshadow *= receiveShadow ? getShadow( directionalShadowMap[ i ], directionalLight.shadowMapSize, directionalLight.shadowIntensity, directionalLight.shadowBias, directionalLight.shadowRadius, vDirectionalShadowCoord[ i ] ) : 1.0;\n\t}\n\t#pragma unroll_loop_end\n\t#endif\n\t#if NUM_SPOT_LIGHT_SHADOWS > 0\n\tSpotLightShadow spotLight;\n\t#pragma unroll_loop_start\n\tfor ( int i = 0; i < NUM_SPOT_LIGHT_SHADOWS; i ++ ) {\n\t\tspotLight = spotLightShadows[ i ];\n\t\tshadow *= receiveShadow ? getShadow( spotShadowMap[ i ], spotLight.shadowMapSize, spotLight.shadowIntensity, spotLight.shadowBias, spotLight.shadowRadius, vSpotLightCoord[ i ] ) : 1.0;\n\t}\n\t#pragma unroll_loop_end\n\t#endif\n\t#if NUM_POINT_LIGHT_SHADOWS > 0\n\tPointLightShadow pointLight;\n\t#pragma unroll_loop_start\n\tfor ( int i = 0; i < NUM_POINT_LIGHT_SHADOWS; i ++ ) {\n\t\tpointLight = pointLightShadows[ i ];\n\t\tshadow *= receiveShadow ? getPointShadow( pointShadowMap[ i ], pointLight.shadowMapSize, pointLight.shadowIntensity, pointLight.shadowBias, pointLight.shadowRadius, vPointShadowCoord[ i ], pointLight.shadowCameraNear, pointLight.shadowCameraFar ) : 1.0;\n\t}\n\t#pragma unroll_loop_end\n\t#endif\n\t#endif\n\treturn shadow;\n}",skinbase_vertex="#ifdef USE_SKINNING\n\tmat4 boneMatX = getBoneMatrix( skinIndex.x );\n\tmat4 boneMatY = getBoneMatrix( skinIndex.y );\n\tmat4 boneMatZ = getBoneMatrix( skinIndex.z );\n\tmat4 boneMatW = getBoneMatrix( skinIndex.w );\n#endif",skinning_pars_vertex="#ifdef USE_SKINNING\n\tuniform mat4 bindMatrix;\n\tuniform mat4 bindMatrixInverse;\n\tuniform highp sampler2D boneTexture;\n\tmat4 getBoneMatrix( const in float i ) {\n\t\tint size = textureSize( boneTexture, 0 ).x;\n\t\tint j = int( i ) * 4;\n\t\tint x = j % size;\n\t\tint y = j / size;\n\t\tvec4 v1 = texelFetch( boneTexture, ivec2( x, y ), 0 );\n\t\tvec4 v2 = texelFetch( boneTexture, ivec2( x + 1, y ), 0 );\n\t\tvec4 v3 = texelFetch( boneTexture, ivec2( x + 2, y ), 0 );\n\t\tvec4 v4 = texelFetch( boneTexture, ivec2( x + 3, y ), 0 );\n\t\treturn mat4( v1, v2, v3, v4 );\n\t}\n#endif",skinning_vertex="#ifdef USE_SKINNING\n\tvec4 skinVertex = bindMatrix * vec4( transformed, 1.0 );\n\tvec4 skinned = vec4( 0.0 );\n\tskinned += boneMatX * skinVertex * skinWeight.x;\n\tskinned += boneMatY * skinVertex * skinWeight.y;\n\tskinned += boneMatZ * skinVertex * skinWeight.z;\n\tskinned += boneMatW * skinVertex * skinWeight.w;\n\ttransformed = ( bindMatrixInverse * skinned ).xyz;\n#endif",skinnormal_vertex="#ifdef USE_SKINNING\n\tmat4 skinMatrix = mat4( 0.0 );\n\tskinMatrix += skinWeight.x * boneMatX;\n\tskinMatrix += skinWeight.y * boneMatY;\n\tskinMatrix += skinWeight.z * boneMatZ;\n\tskinMatrix += skinWeight.w * boneMatW;\n\tskinMatrix = bindMatrixInverse * skinMatrix * bindMatrix;\n\tobjectNormal = vec4( skinMatrix * vec4( objectNormal, 0.0 ) ).xyz;\n\t#ifdef USE_TANGENT\n\t\tobjectTangent = vec4( skinMatrix * vec4( objectTangent, 0.0 ) ).xyz;\n\t#endif\n#endif",specularmap_fragment="float specularStrength;\n#ifdef USE_SPECULARMAP\n\tvec4 texelSpecular = texture2D( specularMap, vSpecularMapUv );\n\tspecularStrength = texelSpecular.r;\n#else\n\tspecularStrength = 1.0;\n#endif",specularmap_pars_fragment="#ifdef USE_SPECULARMAP\n\tuniform sampler2D specularMap;\n#endif",tonemapping_fragment="#if defined( TONE_MAPPING )\n\tgl_FragColor.rgb = toneMapping( gl_FragColor.rgb );\n#endif",tonemapping_pars_fragment="#ifndef saturate\n#define saturate( a ) clamp( a, 0.0, 1.0 )\n#endif\nuniform float toneMappingExposure;\nvec3 LinearToneMapping( vec3 color ) {\n\treturn saturate( toneMappingExposure * color );\n}\nvec3 ReinhardToneMapping( vec3 color ) {\n\tcolor *= toneMappingExposure;\n\treturn saturate( color / ( vec3( 1.0 ) + color ) );\n}\nvec3 CineonToneMapping( vec3 color ) {\n\tcolor *= toneMappingExposure;\n\tcolor = max( vec3( 0.0 ), color - 0.004 );\n\treturn pow( ( color * ( 6.2 * color + 0.5 ) ) / ( color * ( 6.2 * color + 1.7 ) + 0.06 ), vec3( 2.2 ) );\n}\nvec3 RRTAndODTFit( vec3 v ) {\n\tvec3 a = v * ( v + 0.0245786 ) - 0.000090537;\n\tvec3 b = v * ( 0.983729 * v + 0.4329510 ) + 0.238081;\n\treturn a / b;\n}\nvec3 ACESFilmicToneMapping( vec3 color ) {\n\tconst mat3 ACESInputMat = mat3(\n\t\tvec3( 0.59719, 0.07600, 0.02840 ),\t\tvec3( 0.35458, 0.90834, 0.13383 ),\n\t\tvec3( 0.04823, 0.01566, 0.83777 )\n\t);\n\tconst mat3 ACESOutputMat = mat3(\n\t\tvec3(  1.60475, -0.10208, -0.00327 ),\t\tvec3( -0.53108,  1.10813, -0.07276 ),\n\t\tvec3( -0.07367, -0.00605,  1.07602 )\n\t);\n\tcolor *= toneMappingExposure / 0.6;\n\tcolor = ACESInputMat * color;\n\tcolor = RRTAndODTFit( color );\n\tcolor = ACESOutputMat * color;\n\treturn saturate( color );\n}\nconst mat3 LINEAR_REC2020_TO_LINEAR_SRGB = mat3(\n\tvec3( 1.6605, - 0.1246, - 0.0182 ),\n\tvec3( - 0.5876, 1.1329, - 0.1006 ),\n\tvec3( - 0.0728, - 0.0083, 1.1187 )\n);\nconst mat3 LINEAR_SRGB_TO_LINEAR_REC2020 = mat3(\n\tvec3( 0.6274, 0.0691, 0.0164 ),\n\tvec3( 0.3293, 0.9195, 0.0880 ),\n\tvec3( 0.0433, 0.0113, 0.8956 )\n);\nvec3 agxDefaultContrastApprox( vec3 x ) {\n\tvec3 x2 = x * x;\n\tvec3 x4 = x2 * x2;\n\treturn + 15.5 * x4 * x2\n\t\t- 40.14 * x4 * x\n\t\t+ 31.96 * x4\n\t\t- 6.868 * x2 * x\n\t\t+ 0.4298 * x2\n\t\t+ 0.1191 * x\n\t\t- 0.00232;\n}\nvec3 AgXToneMapping( vec3 color ) {\n\tconst mat3 AgXInsetMatrix = mat3(\n\t\tvec3( 0.856627153315983, 0.137318972929847, 0.11189821299995 ),\n\t\tvec3( 0.0951212405381588, 0.761241990602591, 0.0767994186031903 ),\n\t\tvec3( 0.0482516061458583, 0.101439036467562, 0.811302368396859 )\n\t);\n\tconst mat3 AgXOutsetMatrix = mat3(\n\t\tvec3( 1.1271005818144368, - 0.1413297634984383, - 0.14132976349843826 ),\n\t\tvec3( - 0.11060664309660323, 1.157823702216272, - 0.11060664309660294 ),\n\t\tvec3( - 0.016493938717834573, - 0.016493938717834257, 1.2519364065950405 )\n\t);\n\tconst float AgxMinEv = - 12.47393;\tconst float AgxMaxEv = 4.026069;\n\tcolor *= toneMappingExposure;\n\tcolor = LINEAR_SRGB_TO_LINEAR_REC2020 * color;\n\tcolor = AgXInsetMatrix * color;\n\tcolor = max( color, 1e-10 );\tcolor = log2( color );\n\tcolor = ( color - AgxMinEv ) / ( AgxMaxEv - AgxMinEv );\n\tcolor = clamp( color, 0.0, 1.0 );\n\tcolor = agxDefaultContrastApprox( color );\n\tcolor = AgXOutsetMatrix * color;\n\tcolor = pow( max( vec3( 0.0 ), color ), vec3( 2.2 ) );\n\tcolor = LINEAR_REC2020_TO_LINEAR_SRGB * color;\n\tcolor = clamp( color, 0.0, 1.0 );\n\treturn color;\n}\nvec3 NeutralToneMapping( vec3 color ) {\n\tconst float StartCompression = 0.8 - 0.04;\n\tconst float Desaturation = 0.15;\n\tcolor *= toneMappingExposure;\n\tfloat x = min( color.r, min( color.g, color.b ) );\n\tfloat offset = x < 0.08 ? x - 6.25 * x * x : 0.04;\n\tcolor -= offset;\n\tfloat peak = max( color.r, max( color.g, color.b ) );\n\tif ( peak < StartCompression ) return color;\n\tfloat d = 1. - StartCompression;\n\tfloat newPeak = 1. - d * d / ( peak + d - StartCompression );\n\tcolor *= newPeak / peak;\n\tfloat g = 1. - 1. / ( Desaturation * ( peak - newPeak ) + 1. );\n\treturn mix( color, vec3( newPeak ), g );\n}\nvec3 CustomToneMapping( vec3 color ) { return color; }",transmission_fragment="#ifdef USE_TRANSMISSION\n\tmaterial.transmission = transmission;\n\tmaterial.transmissionAlpha = 1.0;\n\tmaterial.thickness = thickness;\n\tmaterial.attenuationDistance = attenuationDistance;\n\tmaterial.attenuationColor = attenuationColor;\n\t#ifdef USE_TRANSMISSIONMAP\n\t\tmaterial.transmission *= texture2D( transmissionMap, vTransmissionMapUv ).r;\n\t#endif\n\t#ifdef USE_THICKNESSMAP\n\t\tmaterial.thickness *= texture2D( thicknessMap, vThicknessMapUv ).g;\n\t#endif\n\tvec3 pos = vWorldPosition;\n\tvec3 v = normalize( cameraPosition - pos );\n\tvec3 n = inverseTransformDirection( normal, viewMatrix );\n\tvec4 transmitted = getIBLVolumeRefraction(\n\t\tn, v, material.roughness, material.diffuseColor, material.specularColor, material.specularF90,\n\t\tpos, modelMatrix, viewMatrix, projectionMatrix, material.dispersion, material.ior, material.thickness,\n\t\tmaterial.attenuationColor, material.attenuationDistance );\n\tmaterial.transmissionAlpha = mix( material.transmissionAlpha, transmitted.a, material.transmission );\n\ttotalDiffuse = mix( totalDiffuse, transmitted.rgb, material.transmission );\n#endif",transmission_pars_fragment="#ifdef USE_TRANSMISSION\n\tuniform float transmission;\n\tuniform float thickness;\n\tuniform float attenuationDistance;\n\tuniform vec3 attenuationColor;\n\t#ifdef USE_TRANSMISSIONMAP\n\t\tuniform sampler2D transmissionMap;\n\t#endif\n\t#ifdef USE_THICKNESSMAP\n\t\tuniform sampler2D thicknessMap;\n\t#endif\n\tuniform vec2 transmissionSamplerSize;\n\tuniform sampler2D transmissionSamplerMap;\n\tuniform mat4 modelMatrix;\n\tuniform mat4 projectionMatrix;\n\tvarying vec3 vWorldPosition;\n\tfloat w0( float a ) {\n\t\treturn ( 1.0 / 6.0 ) * ( a * ( a * ( - a + 3.0 ) - 3.0 ) + 1.0 );\n\t}\n\tfloat w1( float a ) {\n\t\treturn ( 1.0 / 6.0 ) * ( a *  a * ( 3.0 * a - 6.0 ) + 4.0 );\n\t}\n\tfloat w2( float a ){\n\t\treturn ( 1.0 / 6.0 ) * ( a * ( a * ( - 3.0 * a + 3.0 ) + 3.0 ) + 1.0 );\n\t}\n\tfloat w3( float a ) {\n\t\treturn ( 1.0 / 6.0 ) * ( a * a * a );\n\t}\n\tfloat g0( float a ) {\n\t\treturn w0( a ) + w1( a );\n\t}\n\tfloat g1( float a ) {\n\t\treturn w2( a ) + w3( a );\n\t}\n\tfloat h0( float a ) {\n\t\treturn - 1.0 + w1( a ) / ( w0( a ) + w1( a ) );\n\t}\n\tfloat h1( float a ) {\n\t\treturn 1.0 + w3( a ) / ( w2( a ) + w3( a ) );\n\t}\n\tvec4 bicubic( sampler2D tex, vec2 uv, vec4 texelSize, float lod ) {\n\t\tuv = uv * texelSize.zw + 0.5;\n\t\tvec2 iuv = floor( uv );\n\t\tvec2 fuv = fract( uv );\n\t\tfloat g0x = g0( fuv.x );\n\t\tfloat g1x = g1( fuv.x );\n\t\tfloat h0x = h0( fuv.x );\n\t\tfloat h1x = h1( fuv.x );\n\t\tfloat h0y = h0( fuv.y );\n\t\tfloat h1y = h1( fuv.y );\n\t\tvec2 p0 = ( vec2( iuv.x + h0x, iuv.y + h0y ) - 0.5 ) * texelSize.xy;\n\t\tvec2 p1 = ( vec2( iuv.x + h1x, iuv.y + h0y ) - 0.5 ) * texelSize.xy;\n\t\tvec2 p2 = ( vec2( iuv.x + h0x, iuv.y + h1y ) - 0.5 ) * texelSize.xy;\n\t\tvec2 p3 = ( vec2( iuv.x + h1x, iuv.y + h1y ) - 0.5 ) * texelSize.xy;\n\t\treturn g0( fuv.y ) * ( g0x * textureLod( tex, p0, lod ) + g1x * textureLod( tex, p1, lod ) ) +\n\t\t\tg1( fuv.y ) * ( g0x * textureLod( tex, p2, lod ) + g1x * textureLod( tex, p3, lod ) );\n\t}\n\tvec4 textureBicubic( sampler2D sampler, vec2 uv, float lod ) {\n\t\tvec2 fLodSize = vec2( textureSize( sampler, int( lod ) ) );\n\t\tvec2 cLodSize = vec2( textureSize( sampler, int( lod + 1.0 ) ) );\n\t\tvec2 fLodSizeInv = 1.0 / fLodSize;\n\t\tvec2 cLodSizeInv = 1.0 / cLodSize;\n\t\tvec4 fSample = bicubic( sampler, uv, vec4( fLodSizeInv, fLodSize ), floor( lod ) );\n\t\tvec4 cSample = bicubic( sampler, uv, vec4( cLodSizeInv, cLodSize ), ceil( lod ) );\n\t\treturn mix( fSample, cSample, fract( lod ) );\n\t}\n\tvec3 getVolumeTransmissionRay( const in vec3 n, const in vec3 v, const in float thickness, const in float ior, const in mat4 modelMatrix ) {\n\t\tvec3 refractionVector = refract( - v, normalize( n ), 1.0 / ior );\n\t\tvec3 modelScale;\n\t\tmodelScale.x = length( vec3( modelMatrix[ 0 ].xyz ) );\n\t\tmodelScale.y = length( vec3( modelMatrix[ 1 ].xyz ) );\n\t\tmodelScale.z = length( vec3( modelMatrix[ 2 ].xyz ) );\n\t\treturn normalize( refractionVector ) * thickness * modelScale;\n\t}\n\tfloat applyIorToRoughness( const in float roughness, const in float ior ) {\n\t\treturn roughness * clamp( ior * 2.0 - 2.0, 0.0, 1.0 );\n\t}\n\tvec4 getTransmissionSample( const in vec2 fragCoord, const in float roughness, const in float ior ) {\n\t\tfloat lod = log2( transmissionSamplerSize.x ) * applyIorToRoughness( roughness, ior );\n\t\treturn textureBicubic( transmissionSamplerMap, fragCoord.xy, lod );\n\t}\n\tvec3 volumeAttenuation( const in float transmissionDistance, const in vec3 attenuationColor, const in float attenuationDistance ) {\n\t\tif ( isinf( attenuationDistance ) ) {\n\t\t\treturn vec3( 1.0 );\n\t\t} else {\n\t\t\tvec3 attenuationCoefficient = -log( attenuationColor ) / attenuationDistance;\n\t\t\tvec3 transmittance = exp( - attenuationCoefficient * transmissionDistance );\t\t\treturn transmittance;\n\t\t}\n\t}\n\tvec4 getIBLVolumeRefraction( const in vec3 n, const in vec3 v, const in float roughness, const in vec3 diffuseColor,\n\t\tconst in vec3 specularColor, const in float specularF90, const in vec3 position, const in mat4 modelMatrix,\n\t\tconst in mat4 viewMatrix, const in mat4 projMatrix, const in float dispersion, const in float ior, const in float thickness,\n\t\tconst in vec3 attenuationColor, const in float attenuationDistance ) {\n\t\tvec4 transmittedLight;\n\t\tvec3 transmittance;\n\t\t#ifdef USE_DISPERSION\n\t\t\tfloat halfSpread = ( ior - 1.0 ) * 0.025 * dispersion;\n\t\t\tvec3 iors = vec3( ior - halfSpread, ior, ior + halfSpread );\n\t\t\tfor ( int i = 0; i < 3; i ++ ) {\n\t\t\t\tvec3 transmissionRay = getVolumeTransmissionRay( n, v, thickness, iors[ i ], modelMatrix );\n\t\t\t\tvec3 refractedRayExit = position + transmissionRay;\n\t\t\t\tvec4 ndcPos = projMatrix * viewMatrix * vec4( refractedRayExit, 1.0 );\n\t\t\t\tvec2 refractionCoords = ndcPos.xy / ndcPos.w;\n\t\t\t\trefractionCoords += 1.0;\n\t\t\t\trefractionCoords /= 2.0;\n\t\t\t\tvec4 transmissionSample = getTransmissionSample( refractionCoords, roughness, iors[ i ] );\n\t\t\t\ttransmittedLight[ i ] = transmissionSample[ i ];\n\t\t\t\ttransmittedLight.a += transmissionSample.a;\n\t\t\t\ttransmittance[ i ] = diffuseColor[ i ] * volumeAttenuation( length( transmissionRay ), attenuationColor, attenuationDistance )[ i ];\n\t\t\t}\n\t\t\ttransmittedLight.a /= 3.0;\n\t\t#else\n\t\t\tvec3 transmissionRay = getVolumeTransmissionRay( n, v, thickness, ior, modelMatrix );\n\t\t\tvec3 refractedRayExit = position + transmissionRay;\n\t\t\tvec4 ndcPos = projMatrix * viewMatrix * vec4( refractedRayExit, 1.0 );\n\t\t\tvec2 refractionCoords = ndcPos.xy / ndcPos.w;\n\t\t\trefractionCoords += 1.0;\n\t\t\trefractionCoords /= 2.0;\n\t\t\ttransmittedLight = getTransmissionSample( refractionCoords, roughness, ior );\n\t\t\ttransmittance = diffuseColor * volumeAttenuation( length( transmissionRay ), attenuationColor, attenuationDistance );\n\t\t#endif\n\t\tvec3 attenuatedColor = transmittance * transmittedLight.rgb;\n\t\tvec3 F = EnvironmentBRDF( n, v, specularColor, specularF90, roughness );\n\t\tfloat transmittanceFactor = ( transmittance.r + transmittance.g + transmittance.b ) / 3.0;\n\t\treturn vec4( ( 1.0 - F ) * attenuatedColor, 1.0 - ( 1.0 - transmittedLight.a ) * transmittanceFactor );\n\t}\n#endif",uv_pars_fragment="#if defined( USE_UV ) || defined( USE_ANISOTROPY )\n\tvarying vec2 vUv;\n#endif\n#ifdef USE_MAP\n\tvarying vec2 vMapUv;\n#endif\n#ifdef USE_ALPHAMAP\n\tvarying vec2 vAlphaMapUv;\n#endif\n#ifdef USE_LIGHTMAP\n\tvarying vec2 vLightMapUv;\n#endif\n#ifdef USE_AOMAP\n\tvarying vec2 vAoMapUv;\n#endif\n#ifdef USE_BUMPMAP\n\tvarying vec2 vBumpMapUv;\n#endif\n#ifdef USE_NORMALMAP\n\tvarying vec2 vNormalMapUv;\n#endif\n#ifdef USE_EMISSIVEMAP\n\tvarying vec2 vEmissiveMapUv;\n#endif\n#ifdef USE_METALNESSMAP\n\tvarying vec2 vMetalnessMapUv;\n#endif\n#ifdef USE_ROUGHNESSMAP\n\tvarying vec2 vRoughnessMapUv;\n#endif\n#ifdef USE_ANISOTROPYMAP\n\tvarying vec2 vAnisotropyMapUv;\n#endif\n#ifdef USE_CLEARCOATMAP\n\tvarying vec2 vClearcoatMapUv;\n#endif\n#ifdef USE_CLEARCOAT_NORMALMAP\n\tvarying vec2 vClearcoatNormalMapUv;\n#endif\n#ifdef USE_CLEARCOAT_ROUGHNESSMAP\n\tvarying vec2 vClearcoatRoughnessMapUv;\n#endif\n#ifdef USE_IRIDESCENCEMAP\n\tvarying vec2 vIridescenceMapUv;\n#endif\n#ifdef USE_IRIDESCENCE_THICKNESSMAP\n\tvarying vec2 vIridescenceThicknessMapUv;\n#endif\n#ifdef USE_SHEEN_COLORMAP\n\tvarying vec2 vSheenColorMapUv;\n#endif\n#ifdef USE_SHEEN_ROUGHNESSMAP\n\tvarying vec2 vSheenRoughnessMapUv;\n#endif\n#ifdef USE_SPECULARMAP\n\tvarying vec2 vSpecularMapUv;\n#endif\n#ifdef USE_SPECULAR_COLORMAP\n\tvarying vec2 vSpecularColorMapUv;\n#endif\n#ifdef USE_SPECULAR_INTENSITYMAP\n\tvarying vec2 vSpecularIntensityMapUv;\n#endif\n#ifdef USE_TRANSMISSIONMAP\n\tuniform mat3 transmissionMapTransform;\n\tvarying vec2 vTransmissionMapUv;\n#endif\n#ifdef USE_THICKNESSMAP\n\tuniform mat3 thicknessMapTransform;\n\tvarying vec2 vThicknessMapUv;\n#endif",uv_pars_vertex="#if defined( USE_UV ) || defined( USE_ANISOTROPY )\n\tvarying vec2 vUv;\n#endif\n#ifdef USE_MAP\n\tuniform mat3 mapTransform;\n\tvarying vec2 vMapUv;\n#endif\n#ifdef USE_ALPHAMAP\n\tuniform mat3 alphaMapTransform;\n\tvarying vec2 vAlphaMapUv;\n#endif\n#ifdef USE_LIGHTMAP\n\tuniform mat3 lightMapTransform;\n\tvarying vec2 vLightMapUv;\n#endif\n#ifdef USE_AOMAP\n\tuniform mat3 aoMapTransform;\n\tvarying vec2 vAoMapUv;\n#endif\n#ifdef USE_BUMPMAP\n\tuniform mat3 bumpMapTransform;\n\tvarying vec2 vBumpMapUv;\n#endif\n#ifdef USE_NORMALMAP\n\tuniform mat3 normalMapTransform;\n\tvarying vec2 vNormalMapUv;\n#endif\n#ifdef USE_DISPLACEMENTMAP\n\tuniform mat3 displacementMapTransform;\n\tvarying vec2 vDisplacementMapUv;\n#endif\n#ifdef USE_EMISSIVEMAP\n\tuniform mat3 emissiveMapTransform;\n\tvarying vec2 vEmissiveMapUv;\n#endif\n#ifdef USE_METALNESSMAP\n\tuniform mat3 metalnessMapTransform;\n\tvarying vec2 vMetalnessMapUv;\n#endif\n#ifdef USE_ROUGHNESSMAP\n\tuniform mat3 roughnessMapTransform;\n\tvarying vec2 vRoughnessMapUv;\n#endif\n#ifdef USE_ANISOTROPYMAP\n\tuniform mat3 anisotropyMapTransform;\n\tvarying vec2 vAnisotropyMapUv;\n#endif\n#ifdef USE_CLEARCOATMAP\n\tuniform mat3 clearcoatMapTransform;\n\tvarying vec2 vClearcoatMapUv;\n#endif\n#ifdef USE_CLEARCOAT_NORMALMAP\n\tuniform mat3 clearcoatNormalMapTransform;\n\tvarying vec2 vClearcoatNormalMapUv;\n#endif\n#ifdef USE_CLEARCOAT_ROUGHNESSMAP\n\tuniform mat3 clearcoatRoughnessMapTransform;\n\tvarying vec2 vClearcoatRoughnessMapUv;\n#endif\n#ifdef USE_SHEEN_COLORMAP\n\tuniform mat3 sheenColorMapTransform;\n\tvarying vec2 vSheenColorMapUv;\n#endif\n#ifdef USE_SHEEN_ROUGHNESSMAP\n\tuniform mat3 sheenRoughnessMapTransform;\n\tvarying vec2 vSheenRoughnessMapUv;\n#endif\n#ifdef USE_IRIDESCENCEMAP\n\tuniform mat3 iridescenceMapTransform;\n\tvarying vec2 vIridescenceMapUv;\n#endif\n#ifdef USE_IRIDESCENCE_THICKNESSMAP\n\tuniform mat3 iridescenceThicknessMapTransform;\n\tvarying vec2 vIridescenceThicknessMapUv;\n#endif\n#ifdef USE_SPECULARMAP\n\tuniform mat3 specularMapTransform;\n\tvarying vec2 vSpecularMapUv;\n#endif\n#ifdef USE_SPECULAR_COLORMAP\n\tuniform mat3 specularColorMapTransform;\n\tvarying vec2 vSpecularColorMapUv;\n#endif\n#ifdef USE_SPECULAR_INTENSITYMAP\n\tuniform mat3 specularIntensityMapTransform;\n\tvarying vec2 vSpecularIntensityMapUv;\n#endif\n#ifdef USE_TRANSMISSIONMAP\n\tuniform mat3 transmissionMapTransform;\n\tvarying vec2 vTransmissionMapUv;\n#endif\n#ifdef USE_THICKNESSMAP\n\tuniform mat3 thicknessMapTransform;\n\tvarying vec2 vThicknessMapUv;\n#endif",uv_vertex="#if defined( USE_UV ) || defined( USE_ANISOTROPY )\n\tvUv = vec3( uv, 1 ).xy;\n#endif\n#ifdef USE_MAP\n\tvMapUv = ( mapTransform * vec3( MAP_UV, 1 ) ).xy;\n#endif\n#ifdef USE_ALPHAMAP\n\tvAlphaMapUv = ( alphaMapTransform * vec3( ALPHAMAP_UV, 1 ) ).xy;\n#endif\n#ifdef USE_LIGHTMAP\n\tvLightMapUv = ( lightMapTransform * vec3( LIGHTMAP_UV, 1 ) ).xy;\n#endif\n#ifdef USE_AOMAP\n\tvAoMapUv = ( aoMapTransform * vec3( AOMAP_UV, 1 ) ).xy;\n#endif\n#ifdef USE_BUMPMAP\n\tvBumpMapUv = ( bumpMapTransform * vec3( BUMPMAP_UV, 1 ) ).xy;\n#endif\n#ifdef USE_NORMALMAP\n\tvNormalMapUv = ( normalMapTransform * vec3( NORMALMAP_UV, 1 ) ).xy;\n#endif\n#ifdef USE_DISPLACEMENTMAP\n\tvDisplacementMapUv = ( displacementMapTransform * vec3( DISPLACEMENTMAP_UV, 1 ) ).xy;\n#endif\n#ifdef USE_EMISSIVEMAP\n\tvEmissiveMapUv = ( emissiveMapTransform * vec3( EMISSIVEMAP_UV, 1 ) ).xy;\n#endif\n#ifdef USE_METALNESSMAP\n\tvMetalnessMapUv = ( metalnessMapTransform * vec3( METALNESSMAP_UV, 1 ) ).xy;\n#endif\n#ifdef USE_ROUGHNESSMAP\n\tvRoughnessMapUv = ( roughnessMapTransform * vec3( ROUGHNESSMAP_UV, 1 ) ).xy;\n#endif\n#ifdef USE_ANISOTROPYMAP\n\tvAnisotropyMapUv = ( anisotropyMapTransform * vec3( ANISOTROPYMAP_UV, 1 ) ).xy;\n#endif\n#ifdef USE_CLEARCOATMAP\n\tvClearcoatMapUv = ( clearcoatMapTransform * vec3( CLEARCOATMAP_UV, 1 ) ).xy;\n#endif\n#ifdef USE_CLEARCOAT_NORMALMAP\n\tvClearcoatNormalMapUv = ( clearcoatNormalMapTransform * vec3( CLEARCOAT_NORMALMAP_UV, 1 ) ).xy;\n#endif\n#ifdef USE_CLEARCOAT_ROUGHNESSMAP\n\tvClearcoatRoughnessMapUv = ( clearcoatRoughnessMapTransform * vec3( CLEARCOAT_ROUGHNESSMAP_UV, 1 ) ).xy;\n#endif\n#ifdef USE_IRIDESCENCEMAP\n\tvIridescenceMapUv = ( iridescenceMapTransform * vec3( IRIDESCENCEMAP_UV, 1 ) ).xy;\n#endif\n#ifdef USE_IRIDESCENCE_THICKNESSMAP\n\tvIridescenceThicknessMapUv = ( iridescenceThicknessMapTransform * vec3( IRIDESCENCE_THICKNESSMAP_UV, 1 ) ).xy;\n#endif\n#ifdef USE_SHEEN_COLORMAP\n\tvSheenColorMapUv = ( sheenColorMapTransform * vec3( SHEEN_COLORMAP_UV, 1 ) ).xy;\n#endif\n#ifdef USE_SHEEN_ROUGHNESSMAP\n\tvSheenRoughnessMapUv = ( sheenRoughnessMapTransform * vec3( SHEEN_ROUGHNESSMAP_UV, 1 ) ).xy;\n#endif\n#ifdef USE_SPECULARMAP\n\tvSpecularMapUv = ( specularMapTransform * vec3( SPECULARMAP_UV, 1 ) ).xy;\n#endif\n#ifdef USE_SPECULAR_COLORMAP\n\tvSpecularColorMapUv = ( specularColorMapTransform * vec3( SPECULAR_COLORMAP_UV, 1 ) ).xy;\n#endif\n#ifdef USE_SPECULAR_INTENSITYMAP\n\tvSpecularIntensityMapUv = ( specularIntensityMapTransform * vec3( SPECULAR_INTENSITYMAP_UV, 1 ) ).xy;\n#endif\n#ifdef USE_TRANSMISSIONMAP\n\tvTransmissionMapUv = ( transmissionMapTransform * vec3( TRANSMISSIONMAP_UV, 1 ) ).xy;\n#endif\n#ifdef USE_THICKNESSMAP\n\tvThicknessMapUv = ( thicknessMapTransform * vec3( THICKNESSMAP_UV, 1 ) ).xy;\n#endif",worldpos_vertex="#if defined( USE_ENVMAP ) || defined( DISTANCE ) || defined ( USE_SHADOWMAP ) || defined ( USE_TRANSMISSION ) || NUM_SPOT_LIGHT_COORDS > 0\n\tvec4 worldPosition = vec4( transformed, 1.0 );\n\t#ifdef USE_BATCHING\n\t\tworldPosition = batchingMatrix * worldPosition;\n\t#endif\n\t#ifdef USE_INSTANCING\n\t\tworldPosition = instanceMatrix * worldPosition;\n\t#endif\n\tworldPosition = modelMatrix * worldPosition;\n#endif";const vertex$h="varying vec2 vUv;\nuniform mat3 uvTransform;\nvoid main() {\n\tvUv = ( uvTransform * vec3( uv, 1 ) ).xy;\n\tgl_Position = vec4( position.xy, 1.0, 1.0 );\n}",fragment$h="uniform sampler2D t2D;\nuniform float backgroundIntensity;\nvarying vec2 vUv;\nvoid main() {\n\tvec4 texColor = texture2D( t2D, vUv );\n\t#ifdef DECODE_VIDEO_TEXTURE\n\t\ttexColor = vec4( mix( pow( texColor.rgb * 0.9478672986 + vec3( 0.0521327014 ), vec3( 2.4 ) ), texColor.rgb * 0.0773993808, vec3( lessThanEqual( texColor.rgb, vec3( 0.04045 ) ) ) ), texColor.w );\n\t#endif\n\ttexColor.rgb *= backgroundIntensity;\n\tgl_FragColor = texColor;\n\t#include <tonemapping_fragment>\n\t#include <colorspace_fragment>\n}",vertex$g="varying vec3 vWorldDirection;\n#include <common>\nvoid main() {\n\tvWorldDirection = transformDirection( position, modelMatrix );\n\t#include <begin_vertex>\n\t#include <project_vertex>\n\tgl_Position.z = gl_Position.w;\n}",fragment$g="#ifdef ENVMAP_TYPE_CUBE\n\tuniform samplerCube envMap;\n#elif defined( ENVMAP_TYPE_CUBE_UV )\n\tuniform sampler2D envMap;\n#endif\nuniform float flipEnvMap;\nuniform float backgroundBlurriness;\nuniform float backgroundIntensity;\nuniform mat3 backgroundRotation;\nvarying vec3 vWorldDirection;\n#include <cube_uv_reflection_fragment>\nvoid main() {\n\t#ifdef ENVMAP_TYPE_CUBE\n\t\tvec4 texColor = textureCube( envMap, backgroundRotation * vec3( flipEnvMap * vWorldDirection.x, vWorldDirection.yz ) );\n\t#elif defined( ENVMAP_TYPE_CUBE_UV )\n\t\tvec4 texColor = textureCubeUV( envMap, backgroundRotation * vWorldDirection, backgroundBlurriness );\n\t#else\n\t\tvec4 texColor = vec4( 0.0, 0.0, 0.0, 1.0 );\n\t#endif\n\ttexColor.rgb *= backgroundIntensity;\n\tgl_FragColor = texColor;\n\t#include <tonemapping_fragment>\n\t#include <colorspace_fragment>\n}",vertex$f="varying vec3 vWorldDirection;\n#include <common>\nvoid main() {\n\tvWorldDirection = transformDirection( position, modelMatrix );\n\t#include <begin_vertex>\n\t#include <project_vertex>\n\tgl_Position.z = gl_Position.w;\n}",fragment$f="uniform samplerCube tCube;\nuniform float tFlip;\nuniform float opacity;\nvarying vec3 vWorldDirection;\nvoid main() {\n\tvec4 texColor = textureCube( tCube, vec3( tFlip * vWorldDirection.x, vWorldDirection.yz ) );\n\tgl_FragColor = texColor;\n\tgl_FragColor.a *= opacity;\n\t#include <tonemapping_fragment>\n\t#include <colorspace_fragment>\n}",vertex$e="#include <common>\n#include <batching_pars_vertex>\n#include <uv_pars_vertex>\n#include <displacementmap_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvarying vec2 vHighPrecisionZW;\nvoid main() {\n\t#include <uv_vertex>\n\t#include <batching_vertex>\n\t#include <skinbase_vertex>\n\t#include <morphinstance_vertex>\n\t#ifdef USE_DISPLACEMENTMAP\n\t\t#include <beginnormal_vertex>\n\t\t#include <morphnormal_vertex>\n\t\t#include <skinnormal_vertex>\n\t#endif\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <displacementmap_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\tvHighPrecisionZW = gl_Position.zw;\n}",fragment$e="#if DEPTH_PACKING == 3200\n\tuniform float opacity;\n#endif\n#include <common>\n#include <packing>\n#include <uv_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <alphatest_pars_fragment>\n#include <alphahash_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvarying vec2 vHighPrecisionZW;\nvoid main() {\n\tvec4 diffuseColor = vec4( 1.0 );\n\t#include <clipping_planes_fragment>\n\t#if DEPTH_PACKING == 3200\n\t\tdiffuseColor.a = opacity;\n\t#endif\n\t#include <map_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\t#include <alphahash_fragment>\n\t#include <logdepthbuf_fragment>\n\tfloat fragCoordZ = 0.5 * vHighPrecisionZW[0] / vHighPrecisionZW[1] + 0.5;\n\t#if DEPTH_PACKING == 3200\n\t\tgl_FragColor = vec4( vec3( 1.0 - fragCoordZ ), opacity );\n\t#elif DEPTH_PACKING == 3201\n\t\tgl_FragColor = packDepthToRGBA( fragCoordZ );\n\t#elif DEPTH_PACKING == 3202\n\t\tgl_FragColor = vec4( packDepthToRGB( fragCoordZ ), 1.0 );\n\t#elif DEPTH_PACKING == 3203\n\t\tgl_FragColor = vec4( packDepthToRG( fragCoordZ ), 0.0, 1.0 );\n\t#endif\n}",vertex$d="#define DISTANCE\nvarying vec3 vWorldPosition;\n#include <common>\n#include <batching_pars_vertex>\n#include <uv_pars_vertex>\n#include <displacementmap_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\t#include <batching_vertex>\n\t#include <skinbase_vertex>\n\t#include <morphinstance_vertex>\n\t#ifdef USE_DISPLACEMENTMAP\n\t\t#include <beginnormal_vertex>\n\t\t#include <morphnormal_vertex>\n\t\t#include <skinnormal_vertex>\n\t#endif\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <displacementmap_vertex>\n\t#include <project_vertex>\n\t#include <worldpos_vertex>\n\t#include <clipping_planes_vertex>\n\tvWorldPosition = worldPosition.xyz;\n}",fragment$d="#define DISTANCE\nuniform vec3 referencePosition;\nuniform float nearDistance;\nuniform float farDistance;\nvarying vec3 vWorldPosition;\n#include <common>\n#include <packing>\n#include <uv_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <alphatest_pars_fragment>\n#include <alphahash_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main () {\n\tvec4 diffuseColor = vec4( 1.0 );\n\t#include <clipping_planes_fragment>\n\t#include <map_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\t#include <alphahash_fragment>\n\tfloat dist = length( vWorldPosition - referencePosition );\n\tdist = ( dist - nearDistance ) / ( farDistance - nearDistance );\n\tdist = saturate( dist );\n\tgl_FragColor = packDepthToRGBA( dist );\n}",vertex$c="varying vec3 vWorldDirection;\n#include <common>\nvoid main() {\n\tvWorldDirection = transformDirection( position, modelMatrix );\n\t#include <begin_vertex>\n\t#include <project_vertex>\n}",fragment$c="uniform sampler2D tEquirect;\nvarying vec3 vWorldDirection;\n#include <common>\nvoid main() {\n\tvec3 direction = normalize( vWorldDirection );\n\tvec2 sampleUV = equirectUv( direction );\n\tgl_FragColor = texture2D( tEquirect, sampleUV );\n\t#include <tonemapping_fragment>\n\t#include <colorspace_fragment>\n}",vertex$b="uniform float scale;\nattribute float lineDistance;\nvarying float vLineDistance;\n#include <common>\n#include <uv_pars_vertex>\n#include <color_pars_vertex>\n#include <fog_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\tvLineDistance = scale * lineDistance;\n\t#include <uv_vertex>\n\t#include <color_vertex>\n\t#include <morphinstance_vertex>\n\t#include <morphcolor_vertex>\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\t#include <fog_vertex>\n}",fragment$b="uniform vec3 diffuse;\nuniform float opacity;\nuniform float dashSize;\nuniform float totalSize;\nvarying float vLineDistance;\n#include <common>\n#include <color_pars_fragment>\n#include <uv_pars_fragment>\n#include <map_pars_fragment>\n#include <fog_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\t#include <clipping_planes_fragment>\n\tif ( mod( vLineDistance, totalSize ) > dashSize ) {\n\t\tdiscard;\n\t}\n\tvec3 outgoingLight = vec3( 0.0 );\n\t#include <logdepthbuf_fragment>\n\t#include <map_fragment>\n\t#include <color_fragment>\n\toutgoingLight = diffuseColor.rgb;\n\t#include <opaque_fragment>\n\t#include <tonemapping_fragment>\n\t#include <colorspace_fragment>\n\t#include <fog_fragment>\n\t#include <premultiplied_alpha_fragment>\n}",vertex$a="#include <common>\n#include <batching_pars_vertex>\n#include <uv_pars_vertex>\n#include <envmap_pars_vertex>\n#include <color_pars_vertex>\n#include <fog_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\t#include <color_vertex>\n\t#include <morphinstance_vertex>\n\t#include <morphcolor_vertex>\n\t#include <batching_vertex>\n\t#if defined ( USE_ENVMAP ) || defined ( USE_SKINNING )\n\t\t#include <beginnormal_vertex>\n\t\t#include <morphnormal_vertex>\n\t\t#include <skinbase_vertex>\n\t\t#include <skinnormal_vertex>\n\t\t#include <defaultnormal_vertex>\n\t#endif\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\t#include <worldpos_vertex>\n\t#include <envmap_vertex>\n\t#include <fog_vertex>\n}",fragment$a="uniform vec3 diffuse;\nuniform float opacity;\n#ifndef FLAT_SHADED\n\tvarying vec3 vNormal;\n#endif\n#include <common>\n#include <dithering_pars_fragment>\n#include <color_pars_fragment>\n#include <uv_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <alphatest_pars_fragment>\n#include <alphahash_pars_fragment>\n#include <aomap_pars_fragment>\n#include <lightmap_pars_fragment>\n#include <envmap_common_pars_fragment>\n#include <envmap_pars_fragment>\n#include <fog_pars_fragment>\n#include <specularmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\t#include <clipping_planes_fragment>\n\t#include <logdepthbuf_fragment>\n\t#include <map_fragment>\n\t#include <color_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\t#include <alphahash_fragment>\n\t#include <specularmap_fragment>\n\tReflectedLight reflectedLight = ReflectedLight( vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ) );\n\t#ifdef USE_LIGHTMAP\n\t\tvec4 lightMapTexel = texture2D( lightMap, vLightMapUv );\n\t\treflectedLight.indirectDiffuse += lightMapTexel.rgb * lightMapIntensity * RECIPROCAL_PI;\n\t#else\n\t\treflectedLight.indirectDiffuse += vec3( 1.0 );\n\t#endif\n\t#include <aomap_fragment>\n\treflectedLight.indirectDiffuse *= diffuseColor.rgb;\n\tvec3 outgoingLight = reflectedLight.indirectDiffuse;\n\t#include <envmap_fragment>\n\t#include <opaque_fragment>\n\t#include <tonemapping_fragment>\n\t#include <colorspace_fragment>\n\t#include <fog_fragment>\n\t#include <premultiplied_alpha_fragment>\n\t#include <dithering_fragment>\n}",vertex$9="#define LAMBERT\nvarying vec3 vViewPosition;\n#include <common>\n#include <batching_pars_vertex>\n#include <uv_pars_vertex>\n#include <displacementmap_pars_vertex>\n#include <envmap_pars_vertex>\n#include <color_pars_vertex>\n#include <fog_pars_vertex>\n#include <normal_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <shadowmap_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\t#include <color_vertex>\n\t#include <morphinstance_vertex>\n\t#include <morphcolor_vertex>\n\t#include <batching_vertex>\n\t#include <beginnormal_vertex>\n\t#include <morphnormal_vertex>\n\t#include <skinbase_vertex>\n\t#include <skinnormal_vertex>\n\t#include <defaultnormal_vertex>\n\t#include <normal_vertex>\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <displacementmap_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\tvViewPosition = - mvPosition.xyz;\n\t#include <worldpos_vertex>\n\t#include <envmap_vertex>\n\t#include <shadowmap_vertex>\n\t#include <fog_vertex>\n}",fragment$9="#define LAMBERT\nuniform vec3 diffuse;\nuniform vec3 emissive;\nuniform float opacity;\n#include <common>\n#include <packing>\n#include <dithering_pars_fragment>\n#include <color_pars_fragment>\n#include <uv_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <alphatest_pars_fragment>\n#include <alphahash_pars_fragment>\n#include <aomap_pars_fragment>\n#include <lightmap_pars_fragment>\n#include <emissivemap_pars_fragment>\n#include <envmap_common_pars_fragment>\n#include <envmap_pars_fragment>\n#include <fog_pars_fragment>\n#include <bsdfs>\n#include <lights_pars_begin>\n#include <normal_pars_fragment>\n#include <lights_lambert_pars_fragment>\n#include <shadowmap_pars_fragment>\n#include <bumpmap_pars_fragment>\n#include <normalmap_pars_fragment>\n#include <specularmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\t#include <clipping_planes_fragment>\n\tReflectedLight reflectedLight = ReflectedLight( vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ) );\n\tvec3 totalEmissiveRadiance = emissive;\n\t#include <logdepthbuf_fragment>\n\t#include <map_fragment>\n\t#include <color_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\t#include <alphahash_fragment>\n\t#include <specularmap_fragment>\n\t#include <normal_fragment_begin>\n\t#include <normal_fragment_maps>\n\t#include <emissivemap_fragment>\n\t#include <lights_lambert_fragment>\n\t#include <lights_fragment_begin>\n\t#include <lights_fragment_maps>\n\t#include <lights_fragment_end>\n\t#include <aomap_fragment>\n\tvec3 outgoingLight = reflectedLight.directDiffuse + reflectedLight.indirectDiffuse + totalEmissiveRadiance;\n\t#include <envmap_fragment>\n\t#include <opaque_fragment>\n\t#include <tonemapping_fragment>\n\t#include <colorspace_fragment>\n\t#include <fog_fragment>\n\t#include <premultiplied_alpha_fragment>\n\t#include <dithering_fragment>\n}",vertex$8="#define MATCAP\nvarying vec3 vViewPosition;\n#include <common>\n#include <batching_pars_vertex>\n#include <uv_pars_vertex>\n#include <color_pars_vertex>\n#include <displacementmap_pars_vertex>\n#include <fog_pars_vertex>\n#include <normal_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\t#include <color_vertex>\n\t#include <morphinstance_vertex>\n\t#include <morphcolor_vertex>\n\t#include <batching_vertex>\n\t#include <beginnormal_vertex>\n\t#include <morphnormal_vertex>\n\t#include <skinbase_vertex>\n\t#include <skinnormal_vertex>\n\t#include <defaultnormal_vertex>\n\t#include <normal_vertex>\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <displacementmap_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\t#include <fog_vertex>\n\tvViewPosition = - mvPosition.xyz;\n}",fragment$8="#define MATCAP\nuniform vec3 diffuse;\nuniform float opacity;\nuniform sampler2D matcap;\nvarying vec3 vViewPosition;\n#include <common>\n#include <dithering_pars_fragment>\n#include <color_pars_fragment>\n#include <uv_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <alphatest_pars_fragment>\n#include <alphahash_pars_fragment>\n#include <fog_pars_fragment>\n#include <normal_pars_fragment>\n#include <bumpmap_pars_fragment>\n#include <normalmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\t#include <clipping_planes_fragment>\n\t#include <logdepthbuf_fragment>\n\t#include <map_fragment>\n\t#include <color_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\t#include <alphahash_fragment>\n\t#include <normal_fragment_begin>\n\t#include <normal_fragment_maps>\n\tvec3 viewDir = normalize( vViewPosition );\n\tvec3 x = normalize( vec3( viewDir.z, 0.0, - viewDir.x ) );\n\tvec3 y = cross( viewDir, x );\n\tvec2 uv = vec2( dot( x, normal ), dot( y, normal ) ) * 0.495 + 0.5;\n\t#ifdef USE_MATCAP\n\t\tvec4 matcapColor = texture2D( matcap, uv );\n\t#else\n\t\tvec4 matcapColor = vec4( vec3( mix( 0.2, 0.8, uv.y ) ), 1.0 );\n\t#endif\n\tvec3 outgoingLight = diffuseColor.rgb * matcapColor.rgb;\n\t#include <opaque_fragment>\n\t#include <tonemapping_fragment>\n\t#include <colorspace_fragment>\n\t#include <fog_fragment>\n\t#include <premultiplied_alpha_fragment>\n\t#include <dithering_fragment>\n}",vertex$7="#define NORMAL\n#if defined( FLAT_SHADED ) || defined( USE_BUMPMAP ) || defined( USE_NORMALMAP_TANGENTSPACE )\n\tvarying vec3 vViewPosition;\n#endif\n#include <common>\n#include <batching_pars_vertex>\n#include <uv_pars_vertex>\n#include <displacementmap_pars_vertex>\n#include <normal_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\t#include <batching_vertex>\n\t#include <beginnormal_vertex>\n\t#include <morphinstance_vertex>\n\t#include <morphnormal_vertex>\n\t#include <skinbase_vertex>\n\t#include <skinnormal_vertex>\n\t#include <defaultnormal_vertex>\n\t#include <normal_vertex>\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <displacementmap_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n#if defined( FLAT_SHADED ) || defined( USE_BUMPMAP ) || defined( USE_NORMALMAP_TANGENTSPACE )\n\tvViewPosition = - mvPosition.xyz;\n#endif\n}",fragment$7="#define NORMAL\nuniform float opacity;\n#if defined( FLAT_SHADED ) || defined( USE_BUMPMAP ) || defined( USE_NORMALMAP_TANGENTSPACE )\n\tvarying vec3 vViewPosition;\n#endif\n#include <packing>\n#include <uv_pars_fragment>\n#include <normal_pars_fragment>\n#include <bumpmap_pars_fragment>\n#include <normalmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\tvec4 diffuseColor = vec4( 0.0, 0.0, 0.0, opacity );\n\t#include <clipping_planes_fragment>\n\t#include <logdepthbuf_fragment>\n\t#include <normal_fragment_begin>\n\t#include <normal_fragment_maps>\n\tgl_FragColor = vec4( packNormalToRGB( normal ), diffuseColor.a );\n\t#ifdef OPAQUE\n\t\tgl_FragColor.a = 1.0;\n\t#endif\n}",vertex$6="#define PHONG\nvarying vec3 vViewPosition;\n#include <common>\n#include <batching_pars_vertex>\n#include <uv_pars_vertex>\n#include <displacementmap_pars_vertex>\n#include <envmap_pars_vertex>\n#include <color_pars_vertex>\n#include <fog_pars_vertex>\n#include <normal_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <shadowmap_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\t#include <color_vertex>\n\t#include <morphcolor_vertex>\n\t#include <batching_vertex>\n\t#include <beginnormal_vertex>\n\t#include <morphinstance_vertex>\n\t#include <morphnormal_vertex>\n\t#include <skinbase_vertex>\n\t#include <skinnormal_vertex>\n\t#include <defaultnormal_vertex>\n\t#include <normal_vertex>\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <displacementmap_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\tvViewPosition = - mvPosition.xyz;\n\t#include <worldpos_vertex>\n\t#include <envmap_vertex>\n\t#include <shadowmap_vertex>\n\t#include <fog_vertex>\n}",fragment$6="#define PHONG\nuniform vec3 diffuse;\nuniform vec3 emissive;\nuniform vec3 specular;\nuniform float shininess;\nuniform float opacity;\n#include <common>\n#include <packing>\n#include <dithering_pars_fragment>\n#include <color_pars_fragment>\n#include <uv_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <alphatest_pars_fragment>\n#include <alphahash_pars_fragment>\n#include <aomap_pars_fragment>\n#include <lightmap_pars_fragment>\n#include <emissivemap_pars_fragment>\n#include <envmap_common_pars_fragment>\n#include <envmap_pars_fragment>\n#include <fog_pars_fragment>\n#include <bsdfs>\n#include <lights_pars_begin>\n#include <normal_pars_fragment>\n#include <lights_phong_pars_fragment>\n#include <shadowmap_pars_fragment>\n#include <bumpmap_pars_fragment>\n#include <normalmap_pars_fragment>\n#include <specularmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\t#include <clipping_planes_fragment>\n\tReflectedLight reflectedLight = ReflectedLight( vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ) );\n\tvec3 totalEmissiveRadiance = emissive;\n\t#include <logdepthbuf_fragment>\n\t#include <map_fragment>\n\t#include <color_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\t#include <alphahash_fragment>\n\t#include <specularmap_fragment>\n\t#include <normal_fragment_begin>\n\t#include <normal_fragment_maps>\n\t#include <emissivemap_fragment>\n\t#include <lights_phong_fragment>\n\t#include <lights_fragment_begin>\n\t#include <lights_fragment_maps>\n\t#include <lights_fragment_end>\n\t#include <aomap_fragment>\n\tvec3 outgoingLight = reflectedLight.directDiffuse + reflectedLight.indirectDiffuse + reflectedLight.directSpecular + reflectedLight.indirectSpecular + totalEmissiveRadiance;\n\t#include <envmap_fragment>\n\t#include <opaque_fragment>\n\t#include <tonemapping_fragment>\n\t#include <colorspace_fragment>\n\t#include <fog_fragment>\n\t#include <premultiplied_alpha_fragment>\n\t#include <dithering_fragment>\n}",vertex$5="#define STANDARD\nvarying vec3 vViewPosition;\n#ifdef USE_TRANSMISSION\n\tvarying vec3 vWorldPosition;\n#endif\n#include <common>\n#include <batching_pars_vertex>\n#include <uv_pars_vertex>\n#include <displacementmap_pars_vertex>\n#include <color_pars_vertex>\n#include <fog_pars_vertex>\n#include <normal_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <shadowmap_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\t#include <color_vertex>\n\t#include <morphinstance_vertex>\n\t#include <morphcolor_vertex>\n\t#include <batching_vertex>\n\t#include <beginnormal_vertex>\n\t#include <morphnormal_vertex>\n\t#include <skinbase_vertex>\n\t#include <skinnormal_vertex>\n\t#include <defaultnormal_vertex>\n\t#include <normal_vertex>\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <displacementmap_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\tvViewPosition = - mvPosition.xyz;\n\t#include <worldpos_vertex>\n\t#include <shadowmap_vertex>\n\t#include <fog_vertex>\n#ifdef USE_TRANSMISSION\n\tvWorldPosition = worldPosition.xyz;\n#endif\n}",fragment$5="#define STANDARD\n#ifdef PHYSICAL\n\t#define IOR\n\t#define USE_SPECULAR\n#endif\nuniform vec3 diffuse;\nuniform vec3 emissive;\nuniform float roughness;\nuniform float metalness;\nuniform float opacity;\n#ifdef IOR\n\tuniform float ior;\n#endif\n#ifdef USE_SPECULAR\n\tuniform float specularIntensity;\n\tuniform vec3 specularColor;\n\t#ifdef USE_SPECULAR_COLORMAP\n\t\tuniform sampler2D specularColorMap;\n\t#endif\n\t#ifdef USE_SPECULAR_INTENSITYMAP\n\t\tuniform sampler2D specularIntensityMap;\n\t#endif\n#endif\n#ifdef USE_CLEARCOAT\n\tuniform float clearcoat;\n\tuniform float clearcoatRoughness;\n#endif\n#ifdef USE_DISPERSION\n\tuniform float dispersion;\n#endif\n#ifdef USE_IRIDESCENCE\n\tuniform float iridescence;\n\tuniform float iridescenceIOR;\n\tuniform float iridescenceThicknessMinimum;\n\tuniform float iridescenceThicknessMaximum;\n#endif\n#ifdef USE_SHEEN\n\tuniform vec3 sheenColor;\n\tuniform float sheenRoughness;\n\t#ifdef USE_SHEEN_COLORMAP\n\t\tuniform sampler2D sheenColorMap;\n\t#endif\n\t#ifdef USE_SHEEN_ROUGHNESSMAP\n\t\tuniform sampler2D sheenRoughnessMap;\n\t#endif\n#endif\n#ifdef USE_ANISOTROPY\n\tuniform vec2 anisotropyVector;\n\t#ifdef USE_ANISOTROPYMAP\n\t\tuniform sampler2D anisotropyMap;\n\t#endif\n#endif\nvarying vec3 vViewPosition;\n#include <common>\n#include <packing>\n#include <dithering_pars_fragment>\n#include <color_pars_fragment>\n#include <uv_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <alphatest_pars_fragment>\n#include <alphahash_pars_fragment>\n#include <aomap_pars_fragment>\n#include <lightmap_pars_fragment>\n#include <emissivemap_pars_fragment>\n#include <iridescence_fragment>\n#include <cube_uv_reflection_fragment>\n#include <envmap_common_pars_fragment>\n#include <envmap_physical_pars_fragment>\n#include <fog_pars_fragment>\n#include <lights_pars_begin>\n#include <normal_pars_fragment>\n#include <lights_physical_pars_fragment>\n#include <transmission_pars_fragment>\n#include <shadowmap_pars_fragment>\n#include <bumpmap_pars_fragment>\n#include <normalmap_pars_fragment>\n#include <clearcoat_pars_fragment>\n#include <iridescence_pars_fragment>\n#include <roughnessmap_pars_fragment>\n#include <metalnessmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\t#include <clipping_planes_fragment>\n\tReflectedLight reflectedLight = ReflectedLight( vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ) );\n\tvec3 totalEmissiveRadiance = emissive;\n\t#include <logdepthbuf_fragment>\n\t#include <map_fragment>\n\t#include <color_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\t#include <alphahash_fragment>\n\t#include <roughnessmap_fragment>\n\t#include <metalnessmap_fragment>\n\t#include <normal_fragment_begin>\n\t#include <normal_fragment_maps>\n\t#include <clearcoat_normal_fragment_begin>\n\t#include <clearcoat_normal_fragment_maps>\n\t#include <emissivemap_fragment>\n\t#include <lights_physical_fragment>\n\t#include <lights_fragment_begin>\n\t#include <lights_fragment_maps>\n\t#include <lights_fragment_end>\n\t#include <aomap_fragment>\n\tvec3 totalDiffuse = reflectedLight.directDiffuse + reflectedLight.indirectDiffuse;\n\tvec3 totalSpecular = reflectedLight.directSpecular + reflectedLight.indirectSpecular;\n\t#include <transmission_fragment>\n\tvec3 outgoingLight = totalDiffuse + totalSpecular + totalEmissiveRadiance;\n\t#ifdef USE_SHEEN\n\t\tfloat sheenEnergyComp = 1.0 - 0.157 * max3( material.sheenColor );\n\t\toutgoingLight = outgoingLight * sheenEnergyComp + sheenSpecularDirect + sheenSpecularIndirect;\n\t#endif\n\t#ifdef USE_CLEARCOAT\n\t\tfloat dotNVcc = saturate( dot( geometryClearcoatNormal, geometryViewDir ) );\n\t\tvec3 Fcc = F_Schlick( material.clearcoatF0, material.clearcoatF90, dotNVcc );\n\t\toutgoingLight = outgoingLight * ( 1.0 - material.clearcoat * Fcc ) + ( clearcoatSpecularDirect + clearcoatSpecularIndirect ) * material.clearcoat;\n\t#endif\n\t#include <opaque_fragment>\n\t#include <tonemapping_fragment>\n\t#include <colorspace_fragment>\n\t#include <fog_fragment>\n\t#include <premultiplied_alpha_fragment>\n\t#include <dithering_fragment>\n}",vertex$4="#define TOON\nvarying vec3 vViewPosition;\n#include <common>\n#include <batching_pars_vertex>\n#include <uv_pars_vertex>\n#include <displacementmap_pars_vertex>\n#include <color_pars_vertex>\n#include <fog_pars_vertex>\n#include <normal_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <shadowmap_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\t#include <color_vertex>\n\t#include <morphinstance_vertex>\n\t#include <morphcolor_vertex>\n\t#include <batching_vertex>\n\t#include <beginnormal_vertex>\n\t#include <morphnormal_vertex>\n\t#include <skinbase_vertex>\n\t#include <skinnormal_vertex>\n\t#include <defaultnormal_vertex>\n\t#include <normal_vertex>\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <displacementmap_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\tvViewPosition = - mvPosition.xyz;\n\t#include <worldpos_vertex>\n\t#include <shadowmap_vertex>\n\t#include <fog_vertex>\n}",fragment$4="#define TOON\nuniform vec3 diffuse;\nuniform vec3 emissive;\nuniform float opacity;\n#include <common>\n#include <packing>\n#include <dithering_pars_fragment>\n#include <color_pars_fragment>\n#include <uv_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <alphatest_pars_fragment>\n#include <alphahash_pars_fragment>\n#include <aomap_pars_fragment>\n#include <lightmap_pars_fragment>\n#include <emissivemap_pars_fragment>\n#include <gradientmap_pars_fragment>\n#include <fog_pars_fragment>\n#include <bsdfs>\n#include <lights_pars_begin>\n#include <normal_pars_fragment>\n#include <lights_toon_pars_fragment>\n#include <shadowmap_pars_fragment>\n#include <bumpmap_pars_fragment>\n#include <normalmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\t#include <clipping_planes_fragment>\n\tReflectedLight reflectedLight = ReflectedLight( vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ) );\n\tvec3 totalEmissiveRadiance = emissive;\n\t#include <logdepthbuf_fragment>\n\t#include <map_fragment>\n\t#include <color_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\t#include <alphahash_fragment>\n\t#include <normal_fragment_begin>\n\t#include <normal_fragment_maps>\n\t#include <emissivemap_fragment>\n\t#include <lights_toon_fragment>\n\t#include <lights_fragment_begin>\n\t#include <lights_fragment_maps>\n\t#include <lights_fragment_end>\n\t#include <aomap_fragment>\n\tvec3 outgoingLight = reflectedLight.directDiffuse + reflectedLight.indirectDiffuse + totalEmissiveRadiance;\n\t#include <opaque_fragment>\n\t#include <tonemapping_fragment>\n\t#include <colorspace_fragment>\n\t#include <fog_fragment>\n\t#include <premultiplied_alpha_fragment>\n\t#include <dithering_fragment>\n}",vertex$3="uniform float size;\nuniform float scale;\n#include <common>\n#include <color_pars_vertex>\n#include <fog_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\n#ifdef USE_POINTS_UV\n\tvarying vec2 vUv;\n\tuniform mat3 uvTransform;\n#endif\nvoid main() {\n\t#ifdef USE_POINTS_UV\n\t\tvUv = ( uvTransform * vec3( uv, 1 ) ).xy;\n\t#endif\n\t#include <color_vertex>\n\t#include <morphinstance_vertex>\n\t#include <morphcolor_vertex>\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <project_vertex>\n\tgl_PointSize = size;\n\t#ifdef USE_SIZEATTENUATION\n\t\tbool isPerspective = isPerspectiveMatrix( projectionMatrix );\n\t\tif ( isPerspective ) gl_PointSize *= ( scale / - mvPosition.z );\n\t#endif\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\t#include <worldpos_vertex>\n\t#include <fog_vertex>\n}",fragment$3="uniform vec3 diffuse;\nuniform float opacity;\n#include <common>\n#include <color_pars_fragment>\n#include <map_particle_pars_fragment>\n#include <alphatest_pars_fragment>\n#include <alphahash_pars_fragment>\n#include <fog_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\t#include <clipping_planes_fragment>\n\tvec3 outgoingLight = vec3( 0.0 );\n\t#include <logdepthbuf_fragment>\n\t#include <map_particle_fragment>\n\t#include <color_fragment>\n\t#include <alphatest_fragment>\n\t#include <alphahash_fragment>\n\toutgoingLight = diffuseColor.rgb;\n\t#include <opaque_fragment>\n\t#include <tonemapping_fragment>\n\t#include <colorspace_fragment>\n\t#include <fog_fragment>\n\t#include <premultiplied_alpha_fragment>\n}",vertex$2="#include <common>\n#include <batching_pars_vertex>\n#include <fog_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <shadowmap_pars_vertex>\nvoid main() {\n\t#include <batching_vertex>\n\t#include <beginnormal_vertex>\n\t#include <morphinstance_vertex>\n\t#include <morphnormal_vertex>\n\t#include <skinbase_vertex>\n\t#include <skinnormal_vertex>\n\t#include <defaultnormal_vertex>\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <worldpos_vertex>\n\t#include <shadowmap_vertex>\n\t#include <fog_vertex>\n}",fragment$2="uniform vec3 color;\nuniform float opacity;\n#include <common>\n#include <packing>\n#include <fog_pars_fragment>\n#include <bsdfs>\n#include <lights_pars_begin>\n#include <logdepthbuf_pars_fragment>\n#include <shadowmap_pars_fragment>\n#include <shadowmask_pars_fragment>\nvoid main() {\n\t#include <logdepthbuf_fragment>\n\tgl_FragColor = vec4( color, opacity * ( 1.0 - getShadowMask() ) );\n\t#include <tonemapping_fragment>\n\t#include <colorspace_fragment>\n\t#include <fog_fragment>\n}",vertex$1="uniform float rotation;\nuniform vec2 center;\n#include <common>\n#include <uv_pars_vertex>\n#include <fog_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\tvec4 mvPosition = modelViewMatrix[ 3 ];\n\tvec2 scale = vec2( length( modelMatrix[ 0 ].xyz ), length( modelMatrix[ 1 ].xyz ) );\n\t#ifndef USE_SIZEATTENUATION\n\t\tbool isPerspective = isPerspectiveMatrix( projectionMatrix );\n\t\tif ( isPerspective ) scale *= - mvPosition.z;\n\t#endif\n\tvec2 alignedPosition = ( position.xy - ( center - vec2( 0.5 ) ) ) * scale;\n\tvec2 rotatedPosition;\n\trotatedPosition.x = cos( rotation ) * alignedPosition.x - sin( rotation ) * alignedPosition.y;\n\trotatedPosition.y = sin( rotation ) * alignedPosition.x + cos( rotation ) * alignedPosition.y;\n\tmvPosition.xy += rotatedPosition;\n\tgl_Position = projectionMatrix * mvPosition;\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\t#include <fog_vertex>\n}",fragment$1="uniform vec3 diffuse;\nuniform float opacity;\n#include <common>\n#include <uv_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <alphatest_pars_fragment>\n#include <alphahash_pars_fragment>\n#include <fog_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\t#include <clipping_planes_fragment>\n\tvec3 outgoingLight = vec3( 0.0 );\n\t#include <logdepthbuf_fragment>\n\t#include <map_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\t#include <alphahash_fragment>\n\toutgoingLight = diffuseColor.rgb;\n\t#include <opaque_fragment>\n\t#include <tonemapping_fragment>\n\t#include <colorspace_fragment>\n\t#include <fog_fragment>\n}",ShaderChunk={alphahash_fragment,alphahash_pars_fragment,alphamap_fragment,alphamap_pars_fragment,alphatest_fragment,alphatest_pars_fragment,aomap_fragment,aomap_pars_fragment,batching_pars_vertex,batching_vertex,begin_vertex,beginnormal_vertex,bsdfs,iridescence_fragment,bumpmap_pars_fragment,clipping_planes_fragment,clipping_planes_pars_fragment,clipping_planes_pars_vertex,clipping_planes_vertex,color_fragment,color_pars_fragment,color_pars_vertex,color_vertex,common,cube_uv_reflection_fragment,defaultnormal_vertex,displacementmap_pars_vertex,displacementmap_vertex,emissivemap_fragment,emissivemap_pars_fragment,colorspace_fragment,colorspace_pars_fragment,envmap_fragment,envmap_common_pars_fragment,envmap_pars_fragment,envmap_pars_vertex,envmap_physical_pars_fragment,envmap_vertex,fog_vertex,fog_pars_vertex,fog_fragment,fog_pars_fragment,gradientmap_pars_fragment,lightmap_pars_fragment,lights_lambert_fragment,lights_lambert_pars_fragment,lights_pars_begin,lights_toon_fragment,lights_toon_pars_fragment,lights_phong_fragment,lights_phong_pars_fragment,lights_physical_fragment,lights_physical_pars_fragment,lights_fragment_begin,lights_fragment_maps,lights_fragment_end,logdepthbuf_fragment,logdepthbuf_pars_fragment,logdepthbuf_pars_vertex,logdepthbuf_vertex,map_fragment,map_pars_fragment,map_particle_fragment,map_particle_pars_fragment,metalnessmap_fragment,metalnessmap_pars_fragment,morphinstance_vertex,morphcolor_vertex,morphnormal_vertex,morphtarget_pars_vertex,morphtarget_vertex,normal_fragment_begin,normal_fragment_maps,normal_pars_fragment,normal_pars_vertex,normal_vertex,normalmap_pars_fragment,clearcoat_normal_fragment_begin,clearcoat_normal_fragment_maps,clearcoat_pars_fragment,iridescence_pars_fragment,opaque_fragment,packing,premultiplied_alpha_fragment,project_vertex,dithering_fragment,dithering_pars_fragment,roughnessmap_fragment,roughnessmap_pars_fragment,shadowmap_pars_fragment,shadowmap_pars_vertex,shadowmap_vertex,shadowmask_pars_fragment,skinbase_vertex,skinning_pars_vertex,skinning_vertex,skinnormal_vertex,specularmap_fragment,specularmap_pars_fragment,tonemapping_fragment,tonemapping_pars_fragment,transmission_fragment,transmission_pars_fragment,uv_pars_fragment,uv_pars_vertex,uv_vertex,worldpos_vertex,background_vert:vertex$h,background_frag:fragment$h,backgroundCube_vert:vertex$g,backgroundCube_frag:fragment$g,cube_vert:vertex$f,cube_frag:fragment$f,depth_vert:vertex$e,depth_frag:fragment$e,distanceRGBA_vert:vertex$d,distanceRGBA_frag:fragment$d,equirect_vert:vertex$c,equirect_frag:fragment$c,linedashed_vert:vertex$b,linedashed_frag:fragment$b,meshbasic_vert:vertex$a,meshbasic_frag:fragment$a,meshlambert_vert:vertex$9,meshlambert_frag:fragment$9,meshmatcap_vert:vertex$8,meshmatcap_frag:fragment$8,meshnormal_vert:vertex$7,meshnormal_frag:fragment$7,meshphong_vert:vertex$6,meshphong_frag:fragment$6,meshphysical_vert:vertex$5,meshphysical_frag:fragment$5,meshtoon_vert:vertex$4,meshtoon_frag:fragment$4,points_vert:vertex$3,points_frag:fragment$3,shadow_vert:vertex$2,shadow_frag:fragment$2,sprite_vert:vertex$1,sprite_frag:fragment$1},UniformsLib={common:{diffuse:{value:new Color(16777215)},opacity:{value:1},map:{value:null},mapTransform:{value:new Matrix3},alphaMap:{value:null},alphaMapTransform:{value:new Matrix3},alphaTest:{value:0}},specularmap:{specularMap:{value:null},specularMapTransform:{value:new Matrix3}},envmap:{envMap:{value:null},envMapRotation:{value:new Matrix3},flipEnvMap:{value:-1},reflectivity:{value:1},ior:{value:1.5},refractionRatio:{value:.98}},aomap:{aoMap:{value:null},aoMapIntensity:{value:1},aoMapTransform:{value:new Matrix3}},lightmap:{lightMap:{value:null},lightMapIntensity:{value:1},lightMapTransform:{value:new Matrix3}},bumpmap:{bumpMap:{value:null},bumpMapTransform:{value:new Matrix3},bumpScale:{value:1}},normalmap:{normalMap:{value:null},normalMapTransform:{value:new Matrix3},normalScale:{value:new Vector2(1,1)}},displacementmap:{displacementMap:{value:null},displacementMapTransform:{value:new Matrix3},displacementScale:{value:1},displacementBias:{value:0}},emissivemap:{emissiveMap:{value:null},emissiveMapTransform:{value:new Matrix3}},metalnessmap:{metalnessMap:{value:null},metalnessMapTransform:{value:new Matrix3}},roughnessmap:{roughnessMap:{value:null},roughnessMapTransform:{value:new Matrix3}},gradientmap:{gradientMap:{value:null}},fog:{fogDensity:{value:25e-5},fogNear:{value:1},fogFar:{value:2e3},fogColor:{value:new Color(16777215)}},lights:{ambientLightColor:{value:[]},lightProbe:{value:[]},directionalLights:{value:[],properties:{direction:{},color:{}}},directionalLightShadows:{value:[],properties:{shadowIntensity:1,shadowBias:{},shadowNormalBias:{},shadowRadius:{},shadowMapSize:{}}},directionalShadowMap:{value:[]},directionalShadowMatrix:{value:[]},spotLights:{value:[],properties:{color:{},position:{},direction:{},distance:{},coneCos:{},penumbraCos:{},decay:{}}},spotLightShadows:{value:[],properties:{shadowIntensity:1,shadowBias:{},shadowNormalBias:{},shadowRadius:{},shadowMapSize:{}}},spotLightMap:{value:[]},spotShadowMap:{value:[]},spotLightMatrix:{value:[]},pointLights:{value:[],properties:{color:{},position:{},decay:{},distance:{}}},pointLightShadows:{value:[],properties:{shadowIntensity:1,shadowBias:{},shadowNormalBias:{},shadowRadius:{},shadowMapSize:{},shadowCameraNear:{},shadowCameraFar:{}}},pointShadowMap:{value:[]},pointShadowMatrix:{value:[]},hemisphereLights:{value:[],properties:{direction:{},skyColor:{},groundColor:{}}},rectAreaLights:{value:[],properties:{color:{},position:{},width:{},height:{}}},ltc_1:{value:null},ltc_2:{value:null}},points:{diffuse:{value:new Color(16777215)},opacity:{value:1},size:{value:1},scale:{value:1},map:{value:null},alphaMap:{value:null},alphaMapTransform:{value:new Matrix3},alphaTest:{value:0},uvTransform:{value:new Matrix3}},sprite:{diffuse:{value:new Color(16777215)},opacity:{value:1},center:{value:new Vector2(.5,.5)},rotation:{value:0},map:{value:null},mapTransform:{value:new Matrix3},alphaMap:{value:null},alphaMapTransform:{value:new Matrix3},alphaTest:{value:0}}},ShaderLib={basic:{uniforms:mergeUniforms([UniformsLib.common,UniformsLib.specularmap,UniformsLib.envmap,UniformsLib.aomap,UniformsLib.lightmap,UniformsLib.fog]),vertexShader:ShaderChunk.meshbasic_vert,fragmentShader:ShaderChunk.meshbasic_frag},lambert:{uniforms:mergeUniforms([UniformsLib.common,UniformsLib.specularmap,UniformsLib.envmap,UniformsLib.aomap,UniformsLib.lightmap,UniformsLib.emissivemap,UniformsLib.bumpmap,UniformsLib.normalmap,UniformsLib.displacementmap,UniformsLib.fog,UniformsLib.lights,{emissive:{value:new Color(0)}}]),vertexShader:ShaderChunk.meshlambert_vert,fragmentShader:ShaderChunk.meshlambert_frag},phong:{uniforms:mergeUniforms([UniformsLib.common,UniformsLib.specularmap,UniformsLib.envmap,UniformsLib.aomap,UniformsLib.lightmap,UniformsLib.emissivemap,UniformsLib.bumpmap,UniformsLib.normalmap,UniformsLib.displacementmap,UniformsLib.fog,UniformsLib.lights,{emissive:{value:new Color(0)},specular:{value:new Color(1118481)},shininess:{value:30}}]),vertexShader:ShaderChunk.meshphong_vert,fragmentShader:ShaderChunk.meshphong_frag},standard:{uniforms:mergeUniforms([UniformsLib.common,UniformsLib.envmap,UniformsLib.aomap,UniformsLib.lightmap,UniformsLib.emissivemap,UniformsLib.bumpmap,UniformsLib.normalmap,UniformsLib.displacementmap,UniformsLib.roughnessmap,UniformsLib.metalnessmap,UniformsLib.fog,UniformsLib.lights,{emissive:{value:new Color(0)},roughness:{value:1},metalness:{value:0},envMapIntensity:{value:1}}]),vertexShader:ShaderChunk.meshphysical_vert,fragmentShader:ShaderChunk.meshphysical_frag},toon:{uniforms:mergeUniforms([UniformsLib.common,UniformsLib.aomap,UniformsLib.lightmap,UniformsLib.emissivemap,UniformsLib.bumpmap,UniformsLib.normalmap,UniformsLib.displacementmap,UniformsLib.gradientmap,UniformsLib.fog,UniformsLib.lights,{emissive:{value:new Color(0)}}]),vertexShader:ShaderChunk.meshtoon_vert,fragmentShader:ShaderChunk.meshtoon_frag},matcap:{uniforms:mergeUniforms([UniformsLib.common,UniformsLib.bumpmap,UniformsLib.normalmap,UniformsLib.displacementmap,UniformsLib.fog,{matcap:{value:null}}]),vertexShader:ShaderChunk.meshmatcap_vert,fragmentShader:ShaderChunk.meshmatcap_frag},points:{uniforms:mergeUniforms([UniformsLib.points,UniformsLib.fog]),vertexShader:ShaderChunk.points_vert,fragmentShader:ShaderChunk.points_frag},dashed:{uniforms:mergeUniforms([UniformsLib.common,UniformsLib.fog,{scale:{value:1},dashSize:{value:1},totalSize:{value:2}}]),vertexShader:ShaderChunk.linedashed_vert,fragmentShader:ShaderChunk.linedashed_frag},depth:{uniforms:mergeUniforms([UniformsLib.common,UniformsLib.displacementmap]),vertexShader:ShaderChunk.depth_vert,fragmentShader:ShaderChunk.depth_frag},normal:{uniforms:mergeUniforms([UniformsLib.common,UniformsLib.bumpmap,UniformsLib.normalmap,UniformsLib.displacementmap,{opacity:{value:1}}]),vertexShader:ShaderChunk.meshnormal_vert,fragmentShader:ShaderChunk.meshnormal_frag},sprite:{uniforms:mergeUniforms([UniformsLib.sprite,UniformsLib.fog]),vertexShader:ShaderChunk.sprite_vert,fragmentShader:ShaderChunk.sprite_frag},background:{uniforms:{uvTransform:{value:new Matrix3},t2D:{value:null},backgroundIntensity:{value:1}},vertexShader:ShaderChunk.background_vert,fragmentShader:ShaderChunk.background_frag},backgroundCube:{uniforms:{envMap:{value:null},flipEnvMap:{value:-1},backgroundBlurriness:{value:0},backgroundIntensity:{value:1},backgroundRotation:{value:new Matrix3}},vertexShader:ShaderChunk.backgroundCube_vert,fragmentShader:ShaderChunk.backgroundCube_frag},cube:{uniforms:{tCube:{value:null},tFlip:{value:-1},opacity:{value:1}},vertexShader:ShaderChunk.cube_vert,fragmentShader:ShaderChunk.cube_frag},equirect:{uniforms:{tEquirect:{value:null}},vertexShader:ShaderChunk.equirect_vert,fragmentShader:ShaderChunk.equirect_frag},distanceRGBA:{uniforms:mergeUniforms([UniformsLib.common,UniformsLib.displacementmap,{referencePosition:{value:new Vector3},nearDistance:{value:1},farDistance:{value:1e3}}]),vertexShader:ShaderChunk.distanceRGBA_vert,fragmentShader:ShaderChunk.distanceRGBA_frag},shadow:{uniforms:mergeUniforms([UniformsLib.lights,UniformsLib.fog,{color:{value:new Color(0)},opacity:{value:1}}]),vertexShader:ShaderChunk.shadow_vert,fragmentShader:ShaderChunk.shadow_frag}};ShaderLib.physical={uniforms:mergeUniforms([ShaderLib.standard.uniforms,{clearcoat:{value:0},clearcoatMap:{value:null},clearcoatMapTransform:{value:new Matrix3},clearcoatNormalMap:{value:null},clearcoatNormalMapTransform:{value:new Matrix3},clearcoatNormalScale:{value:new Vector2(1,1)},clearcoatRoughness:{value:0},clearcoatRoughnessMap:{value:null},clearcoatRoughnessMapTransform:{value:new Matrix3},dispersion:{value:0},iridescence:{value:0},iridescenceMap:{value:null},iridescenceMapTransform:{value:new Matrix3},iridescenceIOR:{value:1.3},iridescenceThicknessMinimum:{value:100},iridescenceThicknessMaximum:{value:400},iridescenceThicknessMap:{value:null},iridescenceThicknessMapTransform:{value:new Matrix3},sheen:{value:0},sheenColor:{value:new Color(0)},sheenColorMap:{value:null},sheenColorMapTransform:{value:new Matrix3},sheenRoughness:{value:1},sheenRoughnessMap:{value:null},sheenRoughnessMapTransform:{value:new Matrix3},transmission:{value:0},transmissionMap:{value:null},transmissionMapTransform:{value:new Matrix3},transmissionSamplerSize:{value:new Vector2},transmissionSamplerMap:{value:null},thickness:{value:0},thicknessMap:{value:null},thicknessMapTransform:{value:new Matrix3},attenuationDistance:{value:0},attenuationColor:{value:new Color(0)},specularColor:{value:new Color(1,1,1)},specularColorMap:{value:null},specularColorMapTransform:{value:new Matrix3},specularIntensity:{value:1},specularIntensityMap:{value:null},specularIntensityMapTransform:{value:new Matrix3},anisotropyVector:{value:new Vector2},anisotropyMap:{value:null},anisotropyMapTransform:{value:new Matrix3}}]),vertexShader:ShaderChunk.meshphysical_vert,fragmentShader:ShaderChunk.meshphysical_frag};const _rgb={r:0,b:0,g:0},_e1$1=new Euler,_m1$1=new Matrix4;function WebGLBackground(e,t,r,n,i,a,s){const o=new Color(0);let l,c,h=!0===a?0:1,u=null,d=0,p=null;function m(e){let n=!0===e.isScene?e.background:null;if(n&&n.isTexture){n=(e.backgroundBlurriness>0?r:t).get(n)}return n}function f(t,r){t.getRGB(_rgb,getUnlitUniformColorSpace(e)),n.buffers.color.setClear(_rgb.r,_rgb.g,_rgb.b,r,s)}return{getClearColor:function(){return o},setClearColor:function(e,t=1){o.set(e),h=t,f(o,h)},getClearAlpha:function(){return h},setClearAlpha:function(e){h=e,f(o,h)},render:function(t){let r=!1;const i=m(t);null===i?f(o,h):i&&i.isColor&&(f(i,1),r=!0);const a=e.xr.getEnvironmentBlendMode();"additive"===a?n.buffers.color.setClear(0,0,0,1,s):"alpha-blend"===a&&n.buffers.color.setClear(0,0,0,0,s),(e.autoClear||r)&&(n.buffers.depth.setTest(!0),n.buffers.depth.setMask(!0),n.buffers.color.setMask(!0),e.clear(e.autoClearColor,e.autoClearDepth,e.autoClearStencil))},addToRenderList:function(t,r){const n=m(r);n&&(n.isCubeTexture||306===n.mapping)?(void 0===c&&(c=new Mesh(new BoxGeometry(1,1,1),new ShaderMaterial({name:"BackgroundCubeMaterial",uniforms:cloneUniforms(ShaderLib.backgroundCube.uniforms),vertexShader:ShaderLib.backgroundCube.vertexShader,fragmentShader:ShaderLib.backgroundCube.fragmentShader,side:1,depthTest:!1,depthWrite:!1,fog:!1,allowOverride:!1})),c.geometry.deleteAttribute("normal"),c.geometry.deleteAttribute("uv"),c.onBeforeRender=function(e,t,r){this.matrixWorld.copyPosition(r.matrixWorld)},Object.defineProperty(c.material,"envMap",{get:function(){return this.uniforms.envMap.value}}),i.update(c)),_e1$1.copy(r.backgroundRotation),_e1$1.x*=-1,_e1$1.y*=-1,_e1$1.z*=-1,n.isCubeTexture&&!1===n.isRenderTargetTexture&&(_e1$1.y*=-1,_e1$1.z*=-1),c.material.uniforms.envMap.value=n,c.material.uniforms.flipEnvMap.value=n.isCubeTexture&&!1===n.isRenderTargetTexture?-1:1,c.material.uniforms.backgroundBlurriness.value=r.backgroundBlurriness,c.material.uniforms.backgroundIntensity.value=r.backgroundIntensity,c.material.uniforms.backgroundRotation.value.setFromMatrix4(_m1$1.makeRotationFromEuler(_e1$1)),c.material.toneMapped="srgb"!==ColorManagement.getTransfer(n.colorSpace),u===n&&d===n.version&&p===e.toneMapping||(c.material.needsUpdate=!0,u=n,d=n.version,p=e.toneMapping),c.layers.enableAll(),t.unshift(c,c.geometry,c.material,0,0,null)):n&&n.isTexture&&(void 0===l&&(l=new Mesh(new PlaneGeometry(2,2),new ShaderMaterial({name:"BackgroundMaterial",uniforms:cloneUniforms(ShaderLib.background.uniforms),vertexShader:ShaderLib.background.vertexShader,fragmentShader:ShaderLib.background.fragmentShader,side:0,depthTest:!1,depthWrite:!1,fog:!1,allowOverride:!1})),l.geometry.deleteAttribute("normal"),Object.defineProperty(l.material,"map",{get:function(){return this.uniforms.t2D.value}}),i.update(l)),l.material.uniforms.t2D.value=n,l.material.uniforms.backgroundIntensity.value=r.backgroundIntensity,l.material.toneMapped="srgb"!==ColorManagement.getTransfer(n.colorSpace),!0===n.matrixAutoUpdate&&n.updateMatrix(),l.material.uniforms.uvTransform.value.copy(n.matrix),u===n&&d===n.version&&p===e.toneMapping||(l.material.needsUpdate=!0,u=n,d=n.version,p=e.toneMapping),l.layers.enableAll(),t.unshift(l,l.geometry,l.material,0,0,null))},dispose:function(){void 0!==c&&(c.geometry.dispose(),c.material.dispose(),c=void 0),void 0!==l&&(l.geometry.dispose(),l.material.dispose(),l=void 0)}}}function WebGLBindingStates(e,t){const r=e.getParameter(e.MAX_VERTEX_ATTRIBS),n={},i=c(null);let a=i,s=!1;function o(t){return e.bindVertexArray(t)}function l(t){return e.deleteVertexArray(t)}function c(e){const t=[],n=[],i=[];for(let e=0;e<r;e++)t[e]=0,n[e]=0,i[e]=0;return{geometry:null,program:null,wireframe:!1,newAttributes:t,enabledAttributes:n,attributeDivisors:i,object:e,attributes:{},index:null}}function h(){const e=a.newAttributes;for(let t=0,r=e.length;t<r;t++)e[t]=0}function u(e){d(e,0)}function d(t,r){const n=a.newAttributes,i=a.enabledAttributes,s=a.attributeDivisors;n[t]=1,0===i[t]&&(e.enableVertexAttribArray(t),i[t]=1),s[t]!==r&&(e.vertexAttribDivisor(t,r),s[t]=r)}function p(){const t=a.newAttributes,r=a.enabledAttributes;for(let n=0,i=r.length;n<i;n++)r[n]!==t[n]&&(e.disableVertexAttribArray(n),r[n]=0)}function m(t,r,n,i,a,s,o){!0===o?e.vertexAttribIPointer(t,r,n,a,s):e.vertexAttribPointer(t,r,n,i,a,s)}function f(){g(),s=!0,a!==i&&(a=i,o(a.object))}function g(){i.geometry=null,i.program=null,i.wireframe=!1}return{setup:function(r,i,l,f,g){let _=!1;const v=function(t,r,i){const a=!0===i.wireframe;let s=n[t.id];void 0===s&&(s={},n[t.id]=s);let o=s[r.id];void 0===o&&(o={},s[r.id]=o);let l=o[a];void 0===l&&(l=c(e.createVertexArray()),o[a]=l);return l}(f,l,i);a!==v&&(a=v,o(a.object)),_=function(e,t,r,n){const i=a.attributes,s=t.attributes;let o=0;const l=r.getAttributes();for(const t in l){if(l[t].location>=0){const r=i[t];let n=s[t];if(void 0===n&&("instanceMatrix"===t&&e.instanceMatrix&&(n=e.instanceMatrix),"instanceColor"===t&&e.instanceColor&&(n=e.instanceColor)),void 0===r)return!0;if(r.attribute!==n)return!0;if(n&&r.data!==n.data)return!0;o++}}return a.attributesNum!==o||a.index!==n}(r,f,l,g),_&&function(e,t,r,n){const i={},s=t.attributes;let o=0;const l=r.getAttributes();for(const t in l){if(l[t].location>=0){let r=s[t];void 0===r&&("instanceMatrix"===t&&e.instanceMatrix&&(r=e.instanceMatrix),"instanceColor"===t&&e.instanceColor&&(r=e.instanceColor));const n={};n.attribute=r,r&&r.data&&(n.data=r.data),i[t]=n,o++}}a.attributes=i,a.attributesNum=o,a.index=n}(r,f,l,g),null!==g&&t.update(g,e.ELEMENT_ARRAY_BUFFER),(_||s)&&(s=!1,function(r,n,i,a){h();const s=a.attributes,o=i.getAttributes(),l=n.defaultAttributeValues;for(const n in o){const i=o[n];if(i.location>=0){let o=s[n];if(void 0===o&&("instanceMatrix"===n&&r.instanceMatrix&&(o=r.instanceMatrix),"instanceColor"===n&&r.instanceColor&&(o=r.instanceColor)),void 0!==o){const n=o.normalized,s=o.itemSize,l=t.get(o);if(void 0===l)continue;const c=l.buffer,h=l.type,p=l.bytesPerElement,f=h===e.INT||h===e.UNSIGNED_INT||1013===o.gpuType;if(o.isInterleavedBufferAttribute){const t=o.data,l=t.stride,g=o.offset;if(t.isInstancedInterleavedBuffer){for(let e=0;e<i.locationSize;e++)d(i.location+e,t.meshPerAttribute);!0!==r.isInstancedMesh&&void 0===a._maxInstanceCount&&(a._maxInstanceCount=t.meshPerAttribute*t.count)}else for(let e=0;e<i.locationSize;e++)u(i.location+e);e.bindBuffer(e.ARRAY_BUFFER,c);for(let e=0;e<i.locationSize;e++)m(i.location+e,s/i.locationSize,h,n,l*p,(g+s/i.locationSize*e)*p,f)}else{if(o.isInstancedBufferAttribute){for(let e=0;e<i.locationSize;e++)d(i.location+e,o.meshPerAttribute);!0!==r.isInstancedMesh&&void 0===a._maxInstanceCount&&(a._maxInstanceCount=o.meshPerAttribute*o.count)}else for(let e=0;e<i.locationSize;e++)u(i.location+e);e.bindBuffer(e.ARRAY_BUFFER,c);for(let e=0;e<i.locationSize;e++)m(i.location+e,s/i.locationSize,h,n,s*p,s/i.locationSize*e*p,f)}}else if(void 0!==l){const t=l[n];if(void 0!==t)switch(t.length){case 2:e.vertexAttrib2fv(i.location,t);break;case 3:e.vertexAttrib3fv(i.location,t);break;case 4:e.vertexAttrib4fv(i.location,t);break;default:e.vertexAttrib1fv(i.location,t)}}}}p()}(r,i,l,f),null!==g&&e.bindBuffer(e.ELEMENT_ARRAY_BUFFER,t.get(g).buffer))},reset:f,resetDefaultState:g,dispose:function(){f();for(const e in n){const t=n[e];for(const e in t){const r=t[e];for(const e in r)l(r[e].object),delete r[e];delete t[e]}delete n[e]}},releaseStatesOfGeometry:function(e){if(void 0===n[e.id])return;const t=n[e.id];for(const e in t){const r=t[e];for(const e in r)l(r[e].object),delete r[e];delete t[e]}delete n[e.id]},releaseStatesOfProgram:function(e){for(const t in n){const r=n[t];if(void 0===r[e.id])continue;const i=r[e.id];for(const e in i)l(i[e].object),delete i[e];delete r[e.id]}},initAttributes:h,enableAttribute:u,disableUnusedAttributes:p}}function WebGLBufferRenderer(e,t,r){let n;function i(t,i,a){0!==a&&(e.drawArraysInstanced(n,t,i,a),r.update(i,n,a))}this.setMode=function(e){n=e},this.render=function(t,i){e.drawArrays(n,t,i),r.update(i,n,1)},this.renderInstances=i,this.renderMultiDraw=function(e,i,a){if(0===a)return;t.get("WEBGL_multi_draw").multiDrawArraysWEBGL(n,e,0,i,0,a);let s=0;for(let e=0;e<a;e++)s+=i[e];r.update(s,n,1)},this.renderMultiDrawInstances=function(e,a,s,o){if(0===s)return;const l=t.get("WEBGL_multi_draw");if(null===l)for(let t=0;t<e.length;t++)i(e[t],a[t],o[t]);else{l.multiDrawArraysInstancedWEBGL(n,e,0,a,0,o,0,s);let t=0;for(let e=0;e<s;e++)t+=a[e]*o[e];r.update(t,n,1)}}}function WebGLCapabilities(e,t,r,n){let i;function a(t){if("highp"===t){if(e.getShaderPrecisionFormat(e.VERTEX_SHADER,e.HIGH_FLOAT).precision>0&&e.getShaderPrecisionFormat(e.FRAGMENT_SHADER,e.HIGH_FLOAT).precision>0)return"highp";t="mediump"}return"mediump"===t&&e.getShaderPrecisionFormat(e.VERTEX_SHADER,e.MEDIUM_FLOAT).precision>0&&e.getShaderPrecisionFormat(e.FRAGMENT_SHADER,e.MEDIUM_FLOAT).precision>0?"mediump":"lowp"}let s=void 0!==r.precision?r.precision:"highp";const o=a(s);o!==s&&(console.warn("THREE.WebGLRenderer:",s,"not supported, using",o,"instead."),s=o);const l=!0===r.logarithmicDepthBuffer,c=!0===r.reverseDepthBuffer&&t.has("EXT_clip_control"),h=e.getParameter(e.MAX_TEXTURE_IMAGE_UNITS),u=e.getParameter(e.MAX_VERTEX_TEXTURE_IMAGE_UNITS);return{isWebGL2:!0,getMaxAnisotropy:function(){if(void 0!==i)return i;if(!0===t.has("EXT_texture_filter_anisotropic")){const r=t.get("EXT_texture_filter_anisotropic");i=e.getParameter(r.MAX_TEXTURE_MAX_ANISOTROPY_EXT)}else i=0;return i},getMaxPrecision:a,textureFormatReadable:function(t){return 1023===t||n.convert(t)===e.getParameter(e.IMPLEMENTATION_COLOR_READ_FORMAT)},textureTypeReadable:function(r){const i=1016===r&&(t.has("EXT_color_buffer_half_float")||t.has("EXT_color_buffer_float"));return!(1009!==r&&n.convert(r)!==e.getParameter(e.IMPLEMENTATION_COLOR_READ_TYPE)&&1015!==r&&!i)},precision:s,logarithmicDepthBuffer:l,reverseDepthBuffer:c,maxTextures:h,maxVertexTextures:u,maxTextureSize:e.getParameter(e.MAX_TEXTURE_SIZE),maxCubemapSize:e.getParameter(e.MAX_CUBE_MAP_TEXTURE_SIZE),maxAttributes:e.getParameter(e.MAX_VERTEX_ATTRIBS),maxVertexUniforms:e.getParameter(e.MAX_VERTEX_UNIFORM_VECTORS),maxVaryings:e.getParameter(e.MAX_VARYING_VECTORS),maxFragmentUniforms:e.getParameter(e.MAX_FRAGMENT_UNIFORM_VECTORS),vertexTextures:u>0,maxSamples:e.getParameter(e.MAX_SAMPLES)}}function WebGLClipping(e){const t=this;let r=null,n=0,i=!1,a=!1;const s=new Plane,o=new Matrix3,l={value:null,needsUpdate:!1};function c(e,r,n,i){const a=null!==e?e.length:0;let c=null;if(0!==a){if(c=l.value,!0!==i||null===c){const t=n+4*a,i=r.matrixWorldInverse;o.getNormalMatrix(i),(null===c||c.length<t)&&(c=new Float32Array(t));for(let t=0,r=n;t!==a;++t,r+=4)s.copy(e[t]).applyMatrix4(i,o),s.normal.toArray(c,r),c[r+3]=s.constant}l.value=c,l.needsUpdate=!0}return t.numPlanes=a,t.numIntersection=0,c}this.uniform=l,this.numPlanes=0,this.numIntersection=0,this.init=function(e,t){const r=0!==e.length||t||0!==n||i;return i=t,n=e.length,r},this.beginShadows=function(){a=!0,c(null)},this.endShadows=function(){a=!1},this.setGlobalState=function(e,t){r=c(e,t,0)},this.setState=function(s,o,h){const u=s.clippingPlanes,d=s.clipIntersection,p=s.clipShadows,m=e.get(s);if(!i||null===u||0===u.length||a&&!p)a?c(null):function(){l.value!==r&&(l.value=r,l.needsUpdate=n>0);t.numPlanes=n,t.numIntersection=0}();else{const e=a?0:n,t=4*e;let i=m.clippingState||null;l.value=i,i=c(u,o,t,h);for(let e=0;e!==t;++e)i[e]=r[e];m.clippingState=i,this.numIntersection=d?this.numPlanes:0,this.numPlanes+=e}}}function WebGLCubeMaps(e){let t=new WeakMap;function r(e,t){return 303===t?e.mapping=301:304===t&&(e.mapping=302),e}function n(e){const r=e.target;r.removeEventListener("dispose",n);const i=t.get(r);void 0!==i&&(t.delete(r),i.dispose())}return{get:function(i){if(i&&i.isTexture){const a=i.mapping;if(303===a||304===a){if(t.has(i)){return r(t.get(i).texture,i.mapping)}{const a=i.image;if(a&&a.height>0){const s=new WebGLCubeRenderTarget(a.height);return s.fromEquirectangularTexture(e,i),t.set(i,s),i.addEventListener("dispose",n),r(s.texture,i.mapping)}return null}}}return i},dispose:function(){t=new WeakMap}}}const LOD_MIN=4,EXTRA_LOD_SIGMA=[.125,.215,.35,.446,.526,.582],MAX_SAMPLES=20,_flatCamera=new OrthographicCamera,_clearColor=new Color;let _oldTarget=null,_oldActiveCubeFace=0,_oldActiveMipmapLevel=0,_oldXrEnabled=!1;const PHI=(1+Math.sqrt(5))/2,INV_PHI=1/PHI,_axisDirections=[new Vector3(-PHI,INV_PHI,0),new Vector3(PHI,INV_PHI,0),new Vector3(-INV_PHI,0,PHI),new Vector3(INV_PHI,0,PHI),new Vector3(0,PHI,-INV_PHI),new Vector3(0,PHI,INV_PHI),new Vector3(-1,1,-1),new Vector3(1,1,-1),new Vector3(-1,1,1),new Vector3(1,1,1)],_origin=new Vector3;class PMREMGenerator{constructor(e){this._renderer=e,this._pingPongRenderTarget=null,this._lodMax=0,this._cubeSize=0,this._lodPlanes=[],this._sizeLods=[],this._sigmas=[],this._blurMaterial=null,this._cubemapMaterial=null,this._equirectMaterial=null,this._compileMaterial(this._blurMaterial)}fromScene(e,t=0,r=.1,n=100,i={}){const{size:a=256,position:s=_origin}=i;_oldTarget=this._renderer.getRenderTarget(),_oldActiveCubeFace=this._renderer.getActiveCubeFace(),_oldActiveMipmapLevel=this._renderer.getActiveMipmapLevel(),_oldXrEnabled=this._renderer.xr.enabled,this._renderer.xr.enabled=!1,this._setSize(a);const o=this._allocateTargets();return o.depthBuffer=!0,this._sceneToCubeUV(e,r,n,o,s),t>0&&this._blur(o,0,0,t),this._applyPMREM(o),this._cleanup(o),o}fromEquirectangular(e,t=null){return this._fromTexture(e,t)}fromCubemap(e,t=null){return this._fromTexture(e,t)}compileCubemapShader(){null===this._cubemapMaterial&&(this._cubemapMaterial=_getCubemapMaterial(),this._compileMaterial(this._cubemapMaterial))}compileEquirectangularShader(){null===this._equirectMaterial&&(this._equirectMaterial=_getEquirectMaterial(),this._compileMaterial(this._equirectMaterial))}dispose(){this._dispose(),null!==this._cubemapMaterial&&this._cubemapMaterial.dispose(),null!==this._equirectMaterial&&this._equirectMaterial.dispose()}_setSize(e){this._lodMax=Math.floor(Math.log2(e)),this._cubeSize=Math.pow(2,this._lodMax)}_dispose(){null!==this._blurMaterial&&this._blurMaterial.dispose(),null!==this._pingPongRenderTarget&&this._pingPongRenderTarget.dispose();for(let e=0;e<this._lodPlanes.length;e++)this._lodPlanes[e].dispose()}_cleanup(e){this._renderer.setRenderTarget(_oldTarget,_oldActiveCubeFace,_oldActiveMipmapLevel),this._renderer.xr.enabled=_oldXrEnabled,e.scissorTest=!1,_setViewport(e,0,0,e.width,e.height)}_fromTexture(e,t){301===e.mapping||302===e.mapping?this._setSize(0===e.image.length?16:e.image[0].width||e.image[0].image.width):this._setSize(e.image.width/4),_oldTarget=this._renderer.getRenderTarget(),_oldActiveCubeFace=this._renderer.getActiveCubeFace(),_oldActiveMipmapLevel=this._renderer.getActiveMipmapLevel(),_oldXrEnabled=this._renderer.xr.enabled,this._renderer.xr.enabled=!1;const r=t||this._allocateTargets();return this._textureToCubeUV(e,r),this._applyPMREM(r),this._cleanup(r),r}_allocateTargets(){const e=3*Math.max(this._cubeSize,112),t=4*this._cubeSize,r={magFilter:1006,minFilter:1006,generateMipmaps:!1,type:1016,format:1023,colorSpace:"srgb-linear",depthBuffer:!1},n=_createRenderTarget(e,t,r);if(null===this._pingPongRenderTarget||this._pingPongRenderTarget.width!==e||this._pingPongRenderTarget.height!==t){null!==this._pingPongRenderTarget&&this._dispose(),this._pingPongRenderTarget=_createRenderTarget(e,t,r);const{_lodMax:n}=this;({sizeLods:this._sizeLods,lodPlanes:this._lodPlanes,sigmas:this._sigmas}=_createPlanes(n)),this._blurMaterial=_getBlurShader(n,e,t)}return n}_compileMaterial(e){const t=new Mesh(this._lodPlanes[0],e);this._renderer.compile(t,_flatCamera)}_sceneToCubeUV(e,t,r,n,i){const a=new PerspectiveCamera(90,1,t,r),s=[1,-1,1,1,1,1],o=[1,1,1,-1,-1,-1],l=this._renderer,c=l.autoClear,h=l.toneMapping;l.getClearColor(_clearColor),l.toneMapping=0,l.autoClear=!1;const u=new MeshBasicMaterial({name:"PMREM.Background",side:1,depthWrite:!1,depthTest:!1}),d=new Mesh(new BoxGeometry,u);let p=!1;const m=e.background;m?m.isColor&&(u.color.copy(m),e.background=null,p=!0):(u.color.copy(_clearColor),p=!0);for(let t=0;t<6;t++){const r=t%3;0===r?(a.up.set(0,s[t],0),a.position.set(i.x,i.y,i.z),a.lookAt(i.x+o[t],i.y,i.z)):1===r?(a.up.set(0,0,s[t]),a.position.set(i.x,i.y,i.z),a.lookAt(i.x,i.y+o[t],i.z)):(a.up.set(0,s[t],0),a.position.set(i.x,i.y,i.z),a.lookAt(i.x,i.y,i.z+o[t]));const c=this._cubeSize;_setViewport(n,r*c,t>2?c:0,c,c),l.setRenderTarget(n),p&&l.render(d,a),l.render(e,a)}d.geometry.dispose(),d.material.dispose(),l.toneMapping=h,l.autoClear=c,e.background=m}_textureToCubeUV(e,t){const r=this._renderer,n=301===e.mapping||302===e.mapping;n?(null===this._cubemapMaterial&&(this._cubemapMaterial=_getCubemapMaterial()),this._cubemapMaterial.uniforms.flipEnvMap.value=!1===e.isRenderTargetTexture?-1:1):null===this._equirectMaterial&&(this._equirectMaterial=_getEquirectMaterial());const i=n?this._cubemapMaterial:this._equirectMaterial,a=new Mesh(this._lodPlanes[0],i);i.uniforms.envMap.value=e;const s=this._cubeSize;_setViewport(t,0,0,3*s,2*s),r.setRenderTarget(t),r.render(a,_flatCamera)}_applyPMREM(e){const t=this._renderer,r=t.autoClear;t.autoClear=!1;const n=this._lodPlanes.length;for(let t=1;t<n;t++){const r=Math.sqrt(this._sigmas[t]*this._sigmas[t]-this._sigmas[t-1]*this._sigmas[t-1]),i=_axisDirections[(n-t-1)%_axisDirections.length];this._blur(e,t-1,t,r,i)}t.autoClear=r}_blur(e,t,r,n,i){const a=this._pingPongRenderTarget;this._halfBlur(e,a,t,r,n,"latitudinal",i),this._halfBlur(a,e,r,r,n,"longitudinal",i)}_halfBlur(e,t,r,n,i,a,s){const o=this._renderer,l=this._blurMaterial;"latitudinal"!==a&&"longitudinal"!==a&&console.error("blur direction must be either latitudinal or longitudinal!");const c=new Mesh(this._lodPlanes[n],l),h=l.uniforms,u=this._sizeLods[r]-1,d=isFinite(i)?Math.PI/(2*u):2*Math.PI/39,p=i/d,m=isFinite(i)?1+Math.floor(3*p):20;m>20&&console.warn(`sigmaRadians, ${i}, is too large and will clip, as it requested ${m} samples when the maximum is set to 20`);const f=[];let g=0;for(let e=0;e<20;++e){const t=e/p,r=Math.exp(-t*t/2);f.push(r),0===e?g+=r:e<m&&(g+=2*r)}for(let e=0;e<f.length;e++)f[e]=f[e]/g;h.envMap.value=e.texture,h.samples.value=m,h.weights.value=f,h.latitudinal.value="latitudinal"===a,s&&(h.poleAxis.value=s);const{_lodMax:_}=this;h.dTheta.value=d,h.mipInt.value=_-r;const v=this._sizeLods[n];_setViewport(t,3*v*(n>_-4?n-_+4:0),4*(this._cubeSize-v),3*v,2*v),o.setRenderTarget(t),o.render(c,_flatCamera)}}function _createPlanes(e){const t=[],r=[],n=[];let i=e;const a=e-4+1+EXTRA_LOD_SIGMA.length;for(let s=0;s<a;s++){const a=Math.pow(2,i);r.push(a);let o=1/a;s>e-4?o=EXTRA_LOD_SIGMA[s-e+4-1]:0===s&&(o=0),n.push(o);const l=1/(a-2),c=-l,h=1+l,u=[c,c,h,c,h,h,c,c,h,h,c,h],d=6,p=6,m=3,f=2,g=1,_=new Float32Array(m*p*d),v=new Float32Array(f*p*d),x=new Float32Array(g*p*d);for(let e=0;e<d;e++){const t=e%3*2/3-1,r=e>2?0:-1,n=[t,r,0,t+2/3,r,0,t+2/3,r+1,0,t,r,0,t+2/3,r+1,0,t,r+1,0];_.set(n,m*p*e),v.set(u,f*p*e);const i=[e,e,e,e,e,e];x.set(i,g*p*e)}const y=new BufferGeometry;y.setAttribute("position",new BufferAttribute(_,m)),y.setAttribute("uv",new BufferAttribute(v,f)),y.setAttribute("faceIndex",new BufferAttribute(x,g)),t.push(y),i>4&&i--}return{lodPlanes:t,sizeLods:r,sigmas:n}}function _createRenderTarget(e,t,r){const n=new WebGLRenderTarget(e,t,r);return n.texture.mapping=306,n.texture.name="PMREM.cubeUv",n.scissorTest=!0,n}function _setViewport(e,t,r,n,i){e.viewport.set(t,r,n,i),e.scissor.set(t,r,n,i)}function _getBlurShader(e,t,r){const n=new Float32Array(20),i=new Vector3(0,1,0);return new ShaderMaterial({name:"SphericalGaussianBlur",defines:{n:20,CUBEUV_TEXEL_WIDTH:1/t,CUBEUV_TEXEL_HEIGHT:1/r,CUBEUV_MAX_MIP:`${e}.0`},uniforms:{envMap:{value:null},samples:{value:1},weights:{value:n},latitudinal:{value:!1},dTheta:{value:0},mipInt:{value:0},poleAxis:{value:i}},vertexShader:_getCommonVertexShader(),fragmentShader:"\n\n\t\t\tprecision mediump float;\n\t\t\tprecision mediump int;\n\n\t\t\tvarying vec3 vOutputDirection;\n\n\t\t\tuniform sampler2D envMap;\n\t\t\tuniform int samples;\n\t\t\tuniform float weights[ n ];\n\t\t\tuniform bool latitudinal;\n\t\t\tuniform float dTheta;\n\t\t\tuniform float mipInt;\n\t\t\tuniform vec3 poleAxis;\n\n\t\t\t#define ENVMAP_TYPE_CUBE_UV\n\t\t\t#include <cube_uv_reflection_fragment>\n\n\t\t\tvec3 getSample( float theta, vec3 axis ) {\n\n\t\t\t\tfloat cosTheta = cos( theta );\n\t\t\t\t// Rodrigues' axis-angle rotation\n\t\t\t\tvec3 sampleDirection = vOutputDirection * cosTheta\n\t\t\t\t\t+ cross( axis, vOutputDirection ) * sin( theta )\n\t\t\t\t\t+ axis * dot( axis, vOutputDirection ) * ( 1.0 - cosTheta );\n\n\t\t\t\treturn bilinearCubeUV( envMap, sampleDirection, mipInt );\n\n\t\t\t}\n\n\t\t\tvoid main() {\n\n\t\t\t\tvec3 axis = latitudinal ? poleAxis : cross( poleAxis, vOutputDirection );\n\n\t\t\t\tif ( all( equal( axis, vec3( 0.0 ) ) ) ) {\n\n\t\t\t\t\taxis = vec3( vOutputDirection.z, 0.0, - vOutputDirection.x );\n\n\t\t\t\t}\n\n\t\t\t\taxis = normalize( axis );\n\n\t\t\t\tgl_FragColor = vec4( 0.0, 0.0, 0.0, 1.0 );\n\t\t\t\tgl_FragColor.rgb += weights[ 0 ] * getSample( 0.0, axis );\n\n\t\t\t\tfor ( int i = 1; i < n; i++ ) {\n\n\t\t\t\t\tif ( i >= samples ) {\n\n\t\t\t\t\t\tbreak;\n\n\t\t\t\t\t}\n\n\t\t\t\t\tfloat theta = dTheta * float( i );\n\t\t\t\t\tgl_FragColor.rgb += weights[ i ] * getSample( -1.0 * theta, axis );\n\t\t\t\t\tgl_FragColor.rgb += weights[ i ] * getSample( theta, axis );\n\n\t\t\t\t}\n\n\t\t\t}\n\t\t",blending:0,depthTest:!1,depthWrite:!1})}function _getEquirectMaterial(){return new ShaderMaterial({name:"EquirectangularToCubeUV",uniforms:{envMap:{value:null}},vertexShader:_getCommonVertexShader(),fragmentShader:"\n\n\t\t\tprecision mediump float;\n\t\t\tprecision mediump int;\n\n\t\t\tvarying vec3 vOutputDirection;\n\n\t\t\tuniform sampler2D envMap;\n\n\t\t\t#include <common>\n\n\t\t\tvoid main() {\n\n\t\t\t\tvec3 outputDirection = normalize( vOutputDirection );\n\t\t\t\tvec2 uv = equirectUv( outputDirection );\n\n\t\t\t\tgl_FragColor = vec4( texture2D ( envMap, uv ).rgb, 1.0 );\n\n\t\t\t}\n\t\t",blending:0,depthTest:!1,depthWrite:!1})}function _getCubemapMaterial(){return new ShaderMaterial({name:"CubemapToCubeUV",uniforms:{envMap:{value:null},flipEnvMap:{value:-1}},vertexShader:_getCommonVertexShader(),fragmentShader:"\n\n\t\t\tprecision mediump float;\n\t\t\tprecision mediump int;\n\n\t\t\tuniform float flipEnvMap;\n\n\t\t\tvarying vec3 vOutputDirection;\n\n\t\t\tuniform samplerCube envMap;\n\n\t\t\tvoid main() {\n\n\t\t\t\tgl_FragColor = textureCube( envMap, vec3( flipEnvMap * vOutputDirection.x, vOutputDirection.yz ) );\n\n\t\t\t}\n\t\t",blending:0,depthTest:!1,depthWrite:!1})}function _getCommonVertexShader(){return"\n\n\t\tprecision mediump float;\n\t\tprecision mediump int;\n\n\t\tattribute float faceIndex;\n\n\t\tvarying vec3 vOutputDirection;\n\n\t\t// RH coordinate system; PMREM face-indexing convention\n\t\tvec3 getDirection( vec2 uv, float face ) {\n\n\t\t\tuv = 2.0 * uv - 1.0;\n\n\t\t\tvec3 direction = vec3( uv, 1.0 );\n\n\t\t\tif ( face == 0.0 ) {\n\n\t\t\t\tdirection = direction.zyx; // ( 1, v, u ) pos x\n\n\t\t\t} else if ( face == 1.0 ) {\n\n\t\t\t\tdirection = direction.xzy;\n\t\t\t\tdirection.xz *= -1.0; // ( -u, 1, -v ) pos y\n\n\t\t\t} else if ( face == 2.0 ) {\n\n\t\t\t\tdirection.x *= -1.0; // ( -u, v, 1 ) pos z\n\n\t\t\t} else if ( face == 3.0 ) {\n\n\t\t\t\tdirection = direction.zyx;\n\t\t\t\tdirection.xz *= -1.0; // ( -1, v, -u ) neg x\n\n\t\t\t} else if ( face == 4.0 ) {\n\n\t\t\t\tdirection = direction.xzy;\n\t\t\t\tdirection.xy *= -1.0; // ( -u, -1, v ) neg y\n\n\t\t\t} else if ( face == 5.0 ) {\n\n\t\t\t\tdirection.z *= -1.0; // ( u, v, -1 ) neg z\n\n\t\t\t}\n\n\t\t\treturn direction;\n\n\t\t}\n\n\t\tvoid main() {\n\n\t\t\tvOutputDirection = getDirection( uv, faceIndex );\n\t\t\tgl_Position = vec4( position, 1.0 );\n\n\t\t}\n\t"}function WebGLCubeUVMaps(e){let t=new WeakMap,r=null;function n(e){const r=e.target;r.removeEventListener("dispose",n);const i=t.get(r);void 0!==i&&(t.delete(r),i.dispose())}return{get:function(i){if(i&&i.isTexture){const a=i.mapping,s=303===a||304===a,o=301===a||302===a;if(s||o){let a=t.get(i);const l=void 0!==a?a.texture.pmremVersion:0;if(i.isRenderTargetTexture&&i.pmremVersion!==l)return null===r&&(r=new PMREMGenerator(e)),a=s?r.fromEquirectangular(i,a):r.fromCubemap(i,a),a.texture.pmremVersion=i.pmremVersion,t.set(i,a),a.texture;if(void 0!==a)return a.texture;{const l=i.image;return s&&l&&l.height>0||o&&l&&function(e){let t=0;const r=6;for(let n=0;n<r;n++)void 0!==e[n]&&t++;return t===r}(l)?(null===r&&(r=new PMREMGenerator(e)),a=s?r.fromEquirectangular(i):r.fromCubemap(i),a.texture.pmremVersion=i.pmremVersion,t.set(i,a),i.addEventListener("dispose",n),a.texture):null}}}return i},dispose:function(){t=new WeakMap,null!==r&&(r.dispose(),r=null)}}}function WebGLExtensions(e){const t={};function r(r){if(void 0!==t[r])return t[r];let n;switch(r){case"WEBGL_depth_texture":n=e.getExtension("WEBGL_depth_texture")||e.getExtension("MOZ_WEBGL_depth_texture")||e.getExtension("WEBKIT_WEBGL_depth_texture");break;case"EXT_texture_filter_anisotropic":n=e.getExtension("EXT_texture_filter_anisotropic")||e.getExtension("MOZ_EXT_texture_filter_anisotropic")||e.getExtension("WEBKIT_EXT_texture_filter_anisotropic");break;case"WEBGL_compressed_texture_s3tc":n=e.getExtension("WEBGL_compressed_texture_s3tc")||e.getExtension("MOZ_WEBGL_compressed_texture_s3tc")||e.getExtension("WEBKIT_WEBGL_compressed_texture_s3tc");break;case"WEBGL_compressed_texture_pvrtc":n=e.getExtension("WEBGL_compressed_texture_pvrtc")||e.getExtension("WEBKIT_WEBGL_compressed_texture_pvrtc");break;default:n=e.getExtension(r)}return t[r]=n,n}return{has:function(e){return null!==r(e)},init:function(){r("EXT_color_buffer_float"),r("WEBGL_clip_cull_distance"),r("OES_texture_float_linear"),r("EXT_color_buffer_half_float"),r("WEBGL_multisampled_render_to_texture"),r("WEBGL_render_shared_exponent")},get:function(e){const t=r(e);return null===t&&warnOnce("THREE.WebGLRenderer: "+e+" extension not supported."),t}}}function WebGLGeometries(e,t,r,n){const i={},a=new WeakMap;function s(e){const o=e.target;null!==o.index&&t.remove(o.index);for(const e in o.attributes)t.remove(o.attributes[e]);o.removeEventListener("dispose",s),delete i[o.id];const l=a.get(o);l&&(t.remove(l),a.delete(o)),n.releaseStatesOfGeometry(o),!0===o.isInstancedBufferGeometry&&delete o._maxInstanceCount,r.memory.geometries--}function o(e){const r=[],n=e.index,i=e.attributes.position;let s=0;if(null!==n){const e=n.array;s=n.version;for(let t=0,n=e.length;t<n;t+=3){const n=e[t+0],i=e[t+1],a=e[t+2];r.push(n,i,i,a,a,n)}}else{if(void 0===i)return;{const e=i.array;s=i.version;for(let t=0,n=e.length/3-1;t<n;t+=3){const e=t+0,n=t+1,i=t+2;r.push(e,n,n,i,i,e)}}}const o=new(arrayNeedsUint32(r)?Uint32BufferAttribute:Uint16BufferAttribute)(r,1);o.version=s;const l=a.get(e);l&&t.remove(l),a.set(e,o)}return{get:function(e,t){return!0===i[t.id]||(t.addEventListener("dispose",s),i[t.id]=!0,r.memory.geometries++),t},update:function(r){const n=r.attributes;for(const r in n)t.update(n[r],e.ARRAY_BUFFER)},getWireframeAttribute:function(e){const t=a.get(e);if(t){const r=e.index;null!==r&&t.version<r.version&&o(e)}else o(e);return a.get(e)}}}function WebGLIndexedBufferRenderer(e,t,r){let n,i,a;function s(t,s,o){0!==o&&(e.drawElementsInstanced(n,s,i,t*a,o),r.update(s,n,o))}this.setMode=function(e){n=e},this.setIndex=function(e){i=e.type,a=e.bytesPerElement},this.render=function(t,s){e.drawElements(n,s,i,t*a),r.update(s,n,1)},this.renderInstances=s,this.renderMultiDraw=function(e,a,s){if(0===s)return;t.get("WEBGL_multi_draw").multiDrawElementsWEBGL(n,a,0,i,e,0,s);let o=0;for(let e=0;e<s;e++)o+=a[e];r.update(o,n,1)},this.renderMultiDrawInstances=function(e,o,l,c){if(0===l)return;const h=t.get("WEBGL_multi_draw");if(null===h)for(let t=0;t<e.length;t++)s(e[t]/a,o[t],c[t]);else{h.multiDrawElementsInstancedWEBGL(n,o,0,i,e,0,c,0,l);let t=0;for(let e=0;e<l;e++)t+=o[e]*c[e];r.update(t,n,1)}}}function WebGLInfo(e){const t={frame:0,calls:0,triangles:0,points:0,lines:0};return{memory:{geometries:0,textures:0},render:t,programs:null,autoReset:!0,reset:function(){t.calls=0,t.triangles=0,t.points=0,t.lines=0},update:function(r,n,i){switch(t.calls++,n){case e.TRIANGLES:t.triangles+=i*(r/3);break;case e.LINES:t.lines+=i*(r/2);break;case e.LINE_STRIP:t.lines+=i*(r-1);break;case e.LINE_LOOP:t.lines+=i*r;break;case e.POINTS:t.points+=i*r;break;default:console.error("THREE.WebGLInfo: Unknown draw mode:",n)}}}}function WebGLMorphtargets(e,t,r){const n=new WeakMap,i=new Vector4;return{update:function(a,s,o){const l=a.morphTargetInfluences,c=s.morphAttributes.position||s.morphAttributes.normal||s.morphAttributes.color,h=void 0!==c?c.length:0;let u=n.get(s);if(void 0===u||u.count!==h){void 0!==u&&u.texture.dispose();const d=void 0!==s.morphAttributes.position,p=void 0!==s.morphAttributes.normal,m=void 0!==s.morphAttributes.color,f=s.morphAttributes.position||[],g=s.morphAttributes.normal||[],_=s.morphAttributes.color||[];let v=0;!0===d&&(v=1),!0===p&&(v=2),!0===m&&(v=3);let x=s.attributes.position.count*v,y=1;x>t.maxTextureSize&&(y=Math.ceil(x/t.maxTextureSize),x=t.maxTextureSize);const M=new Float32Array(x*y*4*h),S=new DataArrayTexture(M,x,y,h);S.type=1015,S.needsUpdate=!0;const b=4*v;for(let E=0;E<h;E++){const A=f[E],w=g[E],C=_[E],R=x*y*4*E;for(let L=0;L<A.count;L++){const P=L*b;!0===d&&(i.fromBufferAttribute(A,L),M[R+P+0]=i.x,M[R+P+1]=i.y,M[R+P+2]=i.z,M[R+P+3]=0),!0===p&&(i.fromBufferAttribute(w,L),M[R+P+4]=i.x,M[R+P+5]=i.y,M[R+P+6]=i.z,M[R+P+7]=0),!0===m&&(i.fromBufferAttribute(C,L),M[R+P+8]=i.x,M[R+P+9]=i.y,M[R+P+10]=i.z,M[R+P+11]=4===C.itemSize?i.w:1)}}function T(){S.dispose(),n.delete(s),s.removeEventListener("dispose",T)}u={count:h,texture:S,size:new Vector2(x,y)},n.set(s,u),s.addEventListener("dispose",T)}if(!0===a.isInstancedMesh&&null!==a.morphTexture)o.getUniforms().setValue(e,"morphTexture",a.morphTexture,r);else{let I=0;for(let D=0;D<l.length;D++)I+=l[D];const U=s.morphTargetsRelative?1:1-I;o.getUniforms().setValue(e,"morphTargetBaseInfluence",U),o.getUniforms().setValue(e,"morphTargetInfluences",l)}o.getUniforms().setValue(e,"morphTargetsTexture",u.texture,r),o.getUniforms().setValue(e,"morphTargetsTextureSize",u.size)}}}function WebGLObjects(e,t,r,n){let i=new WeakMap;function a(e){const t=e.target;t.removeEventListener("dispose",a),r.remove(t.instanceMatrix),null!==t.instanceColor&&r.remove(t.instanceColor)}return{update:function(s){const o=n.render.frame,l=s.geometry,c=t.get(s,l);if(i.get(c)!==o&&(t.update(c),i.set(c,o)),s.isInstancedMesh&&(!1===s.hasEventListener("dispose",a)&&s.addEventListener("dispose",a),i.get(s)!==o&&(r.update(s.instanceMatrix,e.ARRAY_BUFFER),null!==s.instanceColor&&r.update(s.instanceColor,e.ARRAY_BUFFER),i.set(s,o))),s.isSkinnedMesh){const e=s.skeleton;i.get(e)!==o&&(e.update(),i.set(e,o))}return c},dispose:function(){i=new WeakMap}}}const emptyTexture=new Texture,emptyShadowTexture=new DepthTexture(1,1),emptyArrayTexture=new DataArrayTexture,empty3dTexture=new Data3DTexture,emptyCubeTexture=new CubeTexture,arrayCacheF32=[],arrayCacheI32=[],mat4array=new Float32Array(16),mat3array=new Float32Array(9),mat2array=new Float32Array(4);function flatten(e,t,r){const n=e[0];if(n<=0||n>0)return e;const i=t*r;let a=arrayCacheF32[i];if(void 0===a&&(a=new Float32Array(i),arrayCacheF32[i]=a),0!==t){n.toArray(a,0);for(let n=1,i=0;n!==t;++n)i+=r,e[n].toArray(a,i)}return a}function arraysEqual(e,t){if(e.length!==t.length)return!1;for(let r=0,n=e.length;r<n;r++)if(e[r]!==t[r])return!1;return!0}function copyArray(e,t){for(let r=0,n=t.length;r<n;r++)e[r]=t[r]}function allocTexUnits(e,t){let r=arrayCacheI32[t];void 0===r&&(r=new Int32Array(t),arrayCacheI32[t]=r);for(let n=0;n!==t;++n)r[n]=e.allocateTextureUnit();return r}function setValueV1f(e,t){const r=this.cache;r[0]!==t&&(e.uniform1f(this.addr,t),r[0]=t)}function setValueV2f(e,t){const r=this.cache;if(void 0!==t.x)r[0]===t.x&&r[1]===t.y||(e.uniform2f(this.addr,t.x,t.y),r[0]=t.x,r[1]=t.y);else{if(arraysEqual(r,t))return;e.uniform2fv(this.addr,t),copyArray(r,t)}}function setValueV3f(e,t){const r=this.cache;if(void 0!==t.x)r[0]===t.x&&r[1]===t.y&&r[2]===t.z||(e.uniform3f(this.addr,t.x,t.y,t.z),r[0]=t.x,r[1]=t.y,r[2]=t.z);else if(void 0!==t.r)r[0]===t.r&&r[1]===t.g&&r[2]===t.b||(e.uniform3f(this.addr,t.r,t.g,t.b),r[0]=t.r,r[1]=t.g,r[2]=t.b);else{if(arraysEqual(r,t))return;e.uniform3fv(this.addr,t),copyArray(r,t)}}function setValueV4f(e,t){const r=this.cache;if(void 0!==t.x)r[0]===t.x&&r[1]===t.y&&r[2]===t.z&&r[3]===t.w||(e.uniform4f(this.addr,t.x,t.y,t.z,t.w),r[0]=t.x,r[1]=t.y,r[2]=t.z,r[3]=t.w);else{if(arraysEqual(r,t))return;e.uniform4fv(this.addr,t),copyArray(r,t)}}function setValueM2(e,t){const r=this.cache,n=t.elements;if(void 0===n){if(arraysEqual(r,t))return;e.uniformMatrix2fv(this.addr,!1,t),copyArray(r,t)}else{if(arraysEqual(r,n))return;mat2array.set(n),e.uniformMatrix2fv(this.addr,!1,mat2array),copyArray(r,n)}}function setValueM3(e,t){const r=this.cache,n=t.elements;if(void 0===n){if(arraysEqual(r,t))return;e.uniformMatrix3fv(this.addr,!1,t),copyArray(r,t)}else{if(arraysEqual(r,n))return;mat3array.set(n),e.uniformMatrix3fv(this.addr,!1,mat3array),copyArray(r,n)}}function setValueM4(e,t){const r=this.cache,n=t.elements;if(void 0===n){if(arraysEqual(r,t))return;e.uniformMatrix4fv(this.addr,!1,t),copyArray(r,t)}else{if(arraysEqual(r,n))return;mat4array.set(n),e.uniformMatrix4fv(this.addr,!1,mat4array),copyArray(r,n)}}function setValueV1i(e,t){const r=this.cache;r[0]!==t&&(e.uniform1i(this.addr,t),r[0]=t)}function setValueV2i(e,t){const r=this.cache;if(void 0!==t.x)r[0]===t.x&&r[1]===t.y||(e.uniform2i(this.addr,t.x,t.y),r[0]=t.x,r[1]=t.y);else{if(arraysEqual(r,t))return;e.uniform2iv(this.addr,t),copyArray(r,t)}}function setValueV3i(e,t){const r=this.cache;if(void 0!==t.x)r[0]===t.x&&r[1]===t.y&&r[2]===t.z||(e.uniform3i(this.addr,t.x,t.y,t.z),r[0]=t.x,r[1]=t.y,r[2]=t.z);else{if(arraysEqual(r,t))return;e.uniform3iv(this.addr,t),copyArray(r,t)}}function setValueV4i(e,t){const r=this.cache;if(void 0!==t.x)r[0]===t.x&&r[1]===t.y&&r[2]===t.z&&r[3]===t.w||(e.uniform4i(this.addr,t.x,t.y,t.z,t.w),r[0]=t.x,r[1]=t.y,r[2]=t.z,r[3]=t.w);else{if(arraysEqual(r,t))return;e.uniform4iv(this.addr,t),copyArray(r,t)}}function setValueV1ui(e,t){const r=this.cache;r[0]!==t&&(e.uniform1ui(this.addr,t),r[0]=t)}function setValueV2ui(e,t){const r=this.cache;if(void 0!==t.x)r[0]===t.x&&r[1]===t.y||(e.uniform2ui(this.addr,t.x,t.y),r[0]=t.x,r[1]=t.y);else{if(arraysEqual(r,t))return;e.uniform2uiv(this.addr,t),copyArray(r,t)}}function setValueV3ui(e,t){const r=this.cache;if(void 0!==t.x)r[0]===t.x&&r[1]===t.y&&r[2]===t.z||(e.uniform3ui(this.addr,t.x,t.y,t.z),r[0]=t.x,r[1]=t.y,r[2]=t.z);else{if(arraysEqual(r,t))return;e.uniform3uiv(this.addr,t),copyArray(r,t)}}function setValueV4ui(e,t){const r=this.cache;if(void 0!==t.x)r[0]===t.x&&r[1]===t.y&&r[2]===t.z&&r[3]===t.w||(e.uniform4ui(this.addr,t.x,t.y,t.z,t.w),r[0]=t.x,r[1]=t.y,r[2]=t.z,r[3]=t.w);else{if(arraysEqual(r,t))return;e.uniform4uiv(this.addr,t),copyArray(r,t)}}function setValueT1(e,t,r){const n=this.cache,i=r.allocateTextureUnit();let a;n[0]!==i&&(e.uniform1i(this.addr,i),n[0]=i),this.type===e.SAMPLER_2D_SHADOW?(emptyShadowTexture.compareFunction=515,a=emptyShadowTexture):a=emptyTexture,r.setTexture2D(t||a,i)}function setValueT3D1(e,t,r){const n=this.cache,i=r.allocateTextureUnit();n[0]!==i&&(e.uniform1i(this.addr,i),n[0]=i),r.setTexture3D(t||empty3dTexture,i)}function setValueT6(e,t,r){const n=this.cache,i=r.allocateTextureUnit();n[0]!==i&&(e.uniform1i(this.addr,i),n[0]=i),r.setTextureCube(t||emptyCubeTexture,i)}function setValueT2DArray1(e,t,r){const n=this.cache,i=r.allocateTextureUnit();n[0]!==i&&(e.uniform1i(this.addr,i),n[0]=i),r.setTexture2DArray(t||emptyArrayTexture,i)}function getSingularSetter(e){switch(e){case 5126:return setValueV1f;case 35664:return setValueV2f;case 35665:return setValueV3f;case 35666:return setValueV4f;case 35674:return setValueM2;case 35675:return setValueM3;case 35676:return setValueM4;case 5124:case 35670:return setValueV1i;case 35667:case 35671:return setValueV2i;case 35668:case 35672:return setValueV3i;case 35669:case 35673:return setValueV4i;case 5125:return setValueV1ui;case 36294:return setValueV2ui;case 36295:return setValueV3ui;case 36296:return setValueV4ui;case 35678:case 36198:case 36298:case 36306:case 35682:return setValueT1;case 35679:case 36299:case 36307:return setValueT3D1;case 35680:case 36300:case 36308:case 36293:return setValueT6;case 36289:case 36303:case 36311:case 36292:return setValueT2DArray1}}function setValueV1fArray(e,t){e.uniform1fv(this.addr,t)}function setValueV2fArray(e,t){const r=flatten(t,this.size,2);e.uniform2fv(this.addr,r)}function setValueV3fArray(e,t){const r=flatten(t,this.size,3);e.uniform3fv(this.addr,r)}function setValueV4fArray(e,t){const r=flatten(t,this.size,4);e.uniform4fv(this.addr,r)}function setValueM2Array(e,t){const r=flatten(t,this.size,4);e.uniformMatrix2fv(this.addr,!1,r)}function setValueM3Array(e,t){const r=flatten(t,this.size,9);e.uniformMatrix3fv(this.addr,!1,r)}function setValueM4Array(e,t){const r=flatten(t,this.size,16);e.uniformMatrix4fv(this.addr,!1,r)}function setValueV1iArray(e,t){e.uniform1iv(this.addr,t)}function setValueV2iArray(e,t){e.uniform2iv(this.addr,t)}function setValueV3iArray(e,t){e.uniform3iv(this.addr,t)}function setValueV4iArray(e,t){e.uniform4iv(this.addr,t)}function setValueV1uiArray(e,t){e.uniform1uiv(this.addr,t)}function setValueV2uiArray(e,t){e.uniform2uiv(this.addr,t)}function setValueV3uiArray(e,t){e.uniform3uiv(this.addr,t)}function setValueV4uiArray(e,t){e.uniform4uiv(this.addr,t)}function setValueT1Array(e,t,r){const n=this.cache,i=t.length,a=allocTexUnits(r,i);arraysEqual(n,a)||(e.uniform1iv(this.addr,a),copyArray(n,a));for(let e=0;e!==i;++e)r.setTexture2D(t[e]||emptyTexture,a[e])}function setValueT3DArray(e,t,r){const n=this.cache,i=t.length,a=allocTexUnits(r,i);arraysEqual(n,a)||(e.uniform1iv(this.addr,a),copyArray(n,a));for(let e=0;e!==i;++e)r.setTexture3D(t[e]||empty3dTexture,a[e])}function setValueT6Array(e,t,r){const n=this.cache,i=t.length,a=allocTexUnits(r,i);arraysEqual(n,a)||(e.uniform1iv(this.addr,a),copyArray(n,a));for(let e=0;e!==i;++e)r.setTextureCube(t[e]||emptyCubeTexture,a[e])}function setValueT2DArrayArray(e,t,r){const n=this.cache,i=t.length,a=allocTexUnits(r,i);arraysEqual(n,a)||(e.uniform1iv(this.addr,a),copyArray(n,a));for(let e=0;e!==i;++e)r.setTexture2DArray(t[e]||emptyArrayTexture,a[e])}function getPureArraySetter(e){switch(e){case 5126:return setValueV1fArray;case 35664:return setValueV2fArray;case 35665:return setValueV3fArray;case 35666:return setValueV4fArray;case 35674:return setValueM2Array;case 35675:return setValueM3Array;case 35676:return setValueM4Array;case 5124:case 35670:return setValueV1iArray;case 35667:case 35671:return setValueV2iArray;case 35668:case 35672:return setValueV3iArray;case 35669:case 35673:return setValueV4iArray;case 5125:return setValueV1uiArray;case 36294:return setValueV2uiArray;case 36295:return setValueV3uiArray;case 36296:return setValueV4uiArray;case 35678:case 36198:case 36298:case 36306:case 35682:return setValueT1Array;case 35679:case 36299:case 36307:return setValueT3DArray;case 35680:case 36300:case 36308:case 36293:return setValueT6Array;case 36289:case 36303:case 36311:case 36292:return setValueT2DArrayArray}}class SingleUniform{constructor(e,t,r){this.id=e,this.addr=r,this.cache=[],this.type=t.type,this.setValue=getSingularSetter(t.type)}}class PureArrayUniform{constructor(e,t,r){this.id=e,this.addr=r,this.cache=[],this.type=t.type,this.size=t.size,this.setValue=getPureArraySetter(t.type)}}class StructuredUniform{constructor(e){this.id=e,this.seq=[],this.map={}}setValue(e,t,r){const n=this.seq;for(let i=0,a=n.length;i!==a;++i){const a=n[i];a.setValue(e,t[a.id],r)}}}const RePathPart=/(\w+)(\])?(\[|\.)?/g;function addUniform(e,t){e.seq.push(t),e.map[t.id]=t}function parseUniform(e,t,r){const n=e.name,i=n.length;for(RePathPart.lastIndex=0;;){const a=RePathPart.exec(n),s=RePathPart.lastIndex;let o=a[1];const l="]"===a[2],c=a[3];if(l&&(o|=0),void 0===c||"["===c&&s+2===i){addUniform(r,void 0===c?new SingleUniform(o,e,t):new PureArrayUniform(o,e,t));break}{let e=r.map[o];void 0===e&&(e=new StructuredUniform(o),addUniform(r,e)),r=e}}}class WebGLUniforms{constructor(e,t){this.seq=[],this.map={};const r=e.getProgramParameter(t,e.ACTIVE_UNIFORMS);for(let n=0;n<r;++n){const r=e.getActiveUniform(t,n);parseUniform(r,e.getUniformLocation(t,r.name),this)}}setValue(e,t,r,n){const i=this.map[t];void 0!==i&&i.setValue(e,r,n)}setOptional(e,t,r){const n=t[r];void 0!==n&&this.setValue(e,r,n)}static upload(e,t,r,n){for(let i=0,a=t.length;i!==a;++i){const a=t[i],s=r[a.id];!1!==s.needsUpdate&&a.setValue(e,s.value,n)}}static seqWithValue(e,t){const r=[];for(let n=0,i=e.length;n!==i;++n){const i=e[n];i.id in t&&r.push(i)}return r}}function WebGLShader(e,t,r){const n=e.createShader(t);return e.shaderSource(n,r),e.compileShader(n),n}const COMPLETION_STATUS_KHR=37297;let programIdCount=0;function handleSource(e,t){const r=e.split("\n"),n=[],i=Math.max(t-6,0),a=Math.min(t+6,r.length);for(let e=i;e<a;e++){const i=e+1;n.push(`${i===t?">":" "} ${i}: ${r[e]}`)}return n.join("\n")}const _m0=new Matrix3;function getEncodingComponents(e){ColorManagement._getMatrix(_m0,ColorManagement.workingColorSpace,e);const t=`mat3( ${_m0.elements.map((e=>e.toFixed(4)))} )`;switch(ColorManagement.getTransfer(e)){case"linear":return[t,"LinearTransferOETF"];case"srgb":return[t,"sRGBTransferOETF"];default:return console.warn("THREE.WebGLProgram: Unsupported color space: ",e),[t,"LinearTransferOETF"]}}function getShaderErrors(e,t,r){const n=e.getShaderParameter(t,e.COMPILE_STATUS),i=e.getShaderInfoLog(t).trim();if(n&&""===i)return"";const a=/ERROR: 0:(\d+)/.exec(i);if(a){const n=parseInt(a[1]);return r.toUpperCase()+"\n\n"+i+"\n\n"+handleSource(e.getShaderSource(t),n)}return i}function getTexelEncodingFunction(e,t){const r=getEncodingComponents(t);return[`vec4 ${e}( vec4 value ) {`,`\treturn ${r[1]}( vec4( value.rgb * ${r[0]}, value.a ) );`,"}"].join("\n")}function getToneMappingFunction(e,t){let r;switch(t){case 1:r="Linear";break;case 2:r="Reinhard";break;case 3:r="Cineon";break;case 4:r="ACESFilmic";break;case 6:r="AgX";break;case 7:r="Neutral";break;case 5:r="Custom";break;default:console.warn("THREE.WebGLProgram: Unsupported toneMapping:",t),r="Linear"}return"vec3 "+e+"( vec3 color ) { return "+r+"ToneMapping( color ); }"}const _v0=new Vector3;function getLuminanceFunction(){ColorManagement.getLuminanceCoefficients(_v0);return["float luminance( const in vec3 rgb ) {",`\tconst vec3 weights = vec3( ${_v0.x.toFixed(4)}, ${_v0.y.toFixed(4)}, ${_v0.z.toFixed(4)} );`,"\treturn dot( weights, rgb );","}"].join("\n")}function generateVertexExtensions(e){return[e.extensionClipCullDistance?"#extension GL_ANGLE_clip_cull_distance : require":"",e.extensionMultiDraw?"#extension GL_ANGLE_multi_draw : require":""].filter(filterEmptyLine).join("\n")}function generateDefines(e){const t=[];for(const r in e){const n=e[r];!1!==n&&t.push("#define "+r+" "+n)}return t.join("\n")}function fetchAttributeLocations(e,t){const r={},n=e.getProgramParameter(t,e.ACTIVE_ATTRIBUTES);for(let i=0;i<n;i++){const n=e.getActiveAttrib(t,i),a=n.name;let s=1;n.type===e.FLOAT_MAT2&&(s=2),n.type===e.FLOAT_MAT3&&(s=3),n.type===e.FLOAT_MAT4&&(s=4),r[a]={type:n.type,location:e.getAttribLocation(t,a),locationSize:s}}return r}function filterEmptyLine(e){return""!==e}function replaceLightNums(e,t){const r=t.numSpotLightShadows+t.numSpotLightMaps-t.numSpotLightShadowsWithMaps;return e.replace(/NUM_DIR_LIGHTS/g,t.numDirLights).replace(/NUM_SPOT_LIGHTS/g,t.numSpotLights).replace(/NUM_SPOT_LIGHT_MAPS/g,t.numSpotLightMaps).replace(/NUM_SPOT_LIGHT_COORDS/g,r).replace(/NUM_RECT_AREA_LIGHTS/g,t.numRectAreaLights).replace(/NUM_POINT_LIGHTS/g,t.numPointLights).replace(/NUM_HEMI_LIGHTS/g,t.numHemiLights).replace(/NUM_DIR_LIGHT_SHADOWS/g,t.numDirLightShadows).replace(/NUM_SPOT_LIGHT_SHADOWS_WITH_MAPS/g,t.numSpotLightShadowsWithMaps).replace(/NUM_SPOT_LIGHT_SHADOWS/g,t.numSpotLightShadows).replace(/NUM_POINT_LIGHT_SHADOWS/g,t.numPointLightShadows)}function replaceClippingPlaneNums(e,t){return e.replace(/NUM_CLIPPING_PLANES/g,t.numClippingPlanes).replace(/UNION_CLIPPING_PLANES/g,t.numClippingPlanes-t.numClipIntersection)}const includePattern=/^[ \t]*#include +<([\w\d./]+)>/gm;function resolveIncludes(e){return e.replace(includePattern,includeReplacer)}const shaderChunkMap=new Map;function includeReplacer(e,t){let r=ShaderChunk[t];if(void 0===r){const e=shaderChunkMap.get(t);if(void 0===e)throw new Error("Can not resolve #include <"+t+">");r=ShaderChunk[e],console.warn('THREE.WebGLRenderer: Shader chunk "%s" has been deprecated. Use "%s" instead.',t,e)}return resolveIncludes(r)}const unrollLoopPattern=/#pragma unroll_loop_start\s+for\s*\(\s*int\s+i\s*=\s*(\d+)\s*;\s*i\s*<\s*(\d+)\s*;\s*i\s*\+\+\s*\)\s*{([\s\S]+?)}\s+#pragma unroll_loop_end/g;function unrollLoops(e){return e.replace(unrollLoopPattern,loopReplacer)}function loopReplacer(e,t,r,n){let i="";for(let e=parseInt(t);e<parseInt(r);e++)i+=n.replace(/\[\s*i\s*\]/g,"[ "+e+" ]").replace(/UNROLLED_LOOP_INDEX/g,e);return i}function generatePrecision(e){let t=`precision ${e.precision} float;\n\tprecision ${e.precision} int;\n\tprecision ${e.precision} sampler2D;\n\tprecision ${e.precision} samplerCube;\n\tprecision ${e.precision} sampler3D;\n\tprecision ${e.precision} sampler2DArray;\n\tprecision ${e.precision} sampler2DShadow;\n\tprecision ${e.precision} samplerCubeShadow;\n\tprecision ${e.precision} sampler2DArrayShadow;\n\tprecision ${e.precision} isampler2D;\n\tprecision ${e.precision} isampler3D;\n\tprecision ${e.precision} isamplerCube;\n\tprecision ${e.precision} isampler2DArray;\n\tprecision ${e.precision} usampler2D;\n\tprecision ${e.precision} usampler3D;\n\tprecision ${e.precision} usamplerCube;\n\tprecision ${e.precision} usampler2DArray;\n\t`;return"highp"===e.precision?t+="\n#define HIGH_PRECISION":"mediump"===e.precision?t+="\n#define MEDIUM_PRECISION":"lowp"===e.precision&&(t+="\n#define LOW_PRECISION"),t}function generateShadowMapTypeDefine(e){let t="SHADOWMAP_TYPE_BASIC";return 1===e.shadowMapType?t="SHADOWMAP_TYPE_PCF":2===e.shadowMapType?t="SHADOWMAP_TYPE_PCF_SOFT":3===e.shadowMapType&&(t="SHADOWMAP_TYPE_VSM"),t}function generateEnvMapTypeDefine(e){let t="ENVMAP_TYPE_CUBE";if(e.envMap)switch(e.envMapMode){case 301:case 302:t="ENVMAP_TYPE_CUBE";break;case 306:t="ENVMAP_TYPE_CUBE_UV"}return t}function generateEnvMapModeDefine(e){let t="ENVMAP_MODE_REFLECTION";if(e.envMap&&302===e.envMapMode)t="ENVMAP_MODE_REFRACTION";return t}function generateEnvMapBlendingDefine(e){let t="ENVMAP_BLENDING_NONE";if(e.envMap)switch(e.combine){case 0:t="ENVMAP_BLENDING_MULTIPLY";break;case 1:t="ENVMAP_BLENDING_MIX";break;case 2:t="ENVMAP_BLENDING_ADD"}return t}function generateCubeUVSize(e){const t=e.envMapCubeUVHeight;if(null===t)return null;const r=Math.log2(t)-2,n=1/t;return{texelWidth:1/(3*Math.max(Math.pow(2,r),112)),texelHeight:n,maxMip:r}}function WebGLProgram(e,t,r,n){const i=e.getContext(),a=r.defines;let s=r.vertexShader,o=r.fragmentShader;const l=generateShadowMapTypeDefine(r),c=generateEnvMapTypeDefine(r),h=generateEnvMapModeDefine(r),u=generateEnvMapBlendingDefine(r),d=generateCubeUVSize(r),p=generateVertexExtensions(r),m=generateDefines(a),f=i.createProgram();let g,_,v=r.glslVersion?"#version "+r.glslVersion+"\n":"";r.isRawShaderMaterial?(g=["#define SHADER_TYPE "+r.shaderType,"#define SHADER_NAME "+r.shaderName,m].filter(filterEmptyLine).join("\n"),g.length>0&&(g+="\n"),_=["#define SHADER_TYPE "+r.shaderType,"#define SHADER_NAME "+r.shaderName,m].filter(filterEmptyLine).join("\n"),_.length>0&&(_+="\n")):(g=[generatePrecision(r),"#define SHADER_TYPE "+r.shaderType,"#define SHADER_NAME "+r.shaderName,m,r.extensionClipCullDistance?"#define USE_CLIP_DISTANCE":"",r.batching?"#define USE_BATCHING":"",r.batchingColor?"#define USE_BATCHING_COLOR":"",r.instancing?"#define USE_INSTANCING":"",r.instancingColor?"#define USE_INSTANCING_COLOR":"",r.instancingMorph?"#define USE_INSTANCING_MORPH":"",r.useFog&&r.fog?"#define USE_FOG":"",r.useFog&&r.fogExp2?"#define FOG_EXP2":"",r.map?"#define USE_MAP":"",r.envMap?"#define USE_ENVMAP":"",r.envMap?"#define "+h:"",r.lightMap?"#define USE_LIGHTMAP":"",r.aoMap?"#define USE_AOMAP":"",r.bumpMap?"#define USE_BUMPMAP":"",r.normalMap?"#define USE_NORMALMAP":"",r.normalMapObjectSpace?"#define USE_NORMALMAP_OBJECTSPACE":"",r.normalMapTangentSpace?"#define USE_NORMALMAP_TANGENTSPACE":"",r.displacementMap?"#define USE_DISPLACEMENTMAP":"",r.emissiveMap?"#define USE_EMISSIVEMAP":"",r.anisotropy?"#define USE_ANISOTROPY":"",r.anisotropyMap?"#define USE_ANISOTROPYMAP":"",r.clearcoatMap?"#define USE_CLEARCOATMAP":"",r.clearcoatRoughnessMap?"#define USE_CLEARCOAT_ROUGHNESSMAP":"",r.clearcoatNormalMap?"#define USE_CLEARCOAT_NORMALMAP":"",r.iridescenceMap?"#define USE_IRIDESCENCEMAP":"",r.iridescenceThicknessMap?"#define USE_IRIDESCENCE_THICKNESSMAP":"",r.specularMap?"#define USE_SPECULARMAP":"",r.specularColorMap?"#define USE_SPECULAR_COLORMAP":"",r.specularIntensityMap?"#define USE_SPECULAR_INTENSITYMAP":"",r.roughnessMap?"#define USE_ROUGHNESSMAP":"",r.metalnessMap?"#define USE_METALNESSMAP":"",r.alphaMap?"#define USE_ALPHAMAP":"",r.alphaHash?"#define USE_ALPHAHASH":"",r.transmission?"#define USE_TRANSMISSION":"",r.transmissionMap?"#define USE_TRANSMISSIONMAP":"",r.thicknessMap?"#define USE_THICKNESSMAP":"",r.sheenColorMap?"#define USE_SHEEN_COLORMAP":"",r.sheenRoughnessMap?"#define USE_SHEEN_ROUGHNESSMAP":"",r.mapUv?"#define MAP_UV "+r.mapUv:"",r.alphaMapUv?"#define ALPHAMAP_UV "+r.alphaMapUv:"",r.lightMapUv?"#define LIGHTMAP_UV "+r.lightMapUv:"",r.aoMapUv?"#define AOMAP_UV "+r.aoMapUv:"",r.emissiveMapUv?"#define EMISSIVEMAP_UV "+r.emissiveMapUv:"",r.bumpMapUv?"#define BUMPMAP_UV "+r.bumpMapUv:"",r.normalMapUv?"#define NORMALMAP_UV "+r.normalMapUv:"",r.displacementMapUv?"#define DISPLACEMENTMAP_UV "+r.displacementMapUv:"",r.metalnessMapUv?"#define METALNESSMAP_UV "+r.metalnessMapUv:"",r.roughnessMapUv?"#define ROUGHNESSMAP_UV "+r.roughnessMapUv:"",r.anisotropyMapUv?"#define ANISOTROPYMAP_UV "+r.anisotropyMapUv:"",r.clearcoatMapUv?"#define CLEARCOATMAP_UV "+r.clearcoatMapUv:"",r.clearcoatNormalMapUv?"#define CLEARCOAT_NORMALMAP_UV "+r.clearcoatNormalMapUv:"",r.clearcoatRoughnessMapUv?"#define CLEARCOAT_ROUGHNESSMAP_UV "+r.clearcoatRoughnessMapUv:"",r.iridescenceMapUv?"#define IRIDESCENCEMAP_UV "+r.iridescenceMapUv:"",r.iridescenceThicknessMapUv?"#define IRIDESCENCE_THICKNESSMAP_UV "+r.iridescenceThicknessMapUv:"",r.sheenColorMapUv?"#define SHEEN_COLORMAP_UV "+r.sheenColorMapUv:"",r.sheenRoughnessMapUv?"#define SHEEN_ROUGHNESSMAP_UV "+r.sheenRoughnessMapUv:"",r.specularMapUv?"#define SPECULARMAP_UV "+r.specularMapUv:"",r.specularColorMapUv?"#define SPECULAR_COLORMAP_UV "+r.specularColorMapUv:"",r.specularIntensityMapUv?"#define SPECULAR_INTENSITYMAP_UV "+r.specularIntensityMapUv:"",r.transmissionMapUv?"#define TRANSMISSIONMAP_UV "+r.transmissionMapUv:"",r.thicknessMapUv?"#define THICKNESSMAP_UV "+r.thicknessMapUv:"",r.vertexTangents&&!1===r.flatShading?"#define USE_TANGENT":"",r.vertexColors?"#define USE_COLOR":"",r.vertexAlphas?"#define USE_COLOR_ALPHA":"",r.vertexUv1s?"#define USE_UV1":"",r.vertexUv2s?"#define USE_UV2":"",r.vertexUv3s?"#define USE_UV3":"",r.pointsUvs?"#define USE_POINTS_UV":"",r.flatShading?"#define FLAT_SHADED":"",r.skinning?"#define USE_SKINNING":"",r.morphTargets?"#define USE_MORPHTARGETS":"",r.morphNormals&&!1===r.flatShading?"#define USE_MORPHNORMALS":"",r.morphColors?"#define USE_MORPHCOLORS":"",r.morphTargetsCount>0?"#define MORPHTARGETS_TEXTURE_STRIDE "+r.morphTextureStride:"",r.morphTargetsCount>0?"#define MORPHTARGETS_COUNT "+r.morphTargetsCount:"",r.doubleSided?"#define DOUBLE_SIDED":"",r.flipSided?"#define FLIP_SIDED":"",r.shadowMapEnabled?"#define USE_SHADOWMAP":"",r.shadowMapEnabled?"#define "+l:"",r.sizeAttenuation?"#define USE_SIZEATTENUATION":"",r.numLightProbes>0?"#define USE_LIGHT_PROBES":"",r.logarithmicDepthBuffer?"#define USE_LOGDEPTHBUF":"",r.reverseDepthBuffer?"#define USE_REVERSEDEPTHBUF":"","uniform mat4 modelMatrix;","uniform mat4 modelViewMatrix;","uniform mat4 projectionMatrix;","uniform mat4 viewMatrix;","uniform mat3 normalMatrix;","uniform vec3 cameraPosition;","uniform bool isOrthographic;","#ifdef USE_INSTANCING","\tattribute mat4 instanceMatrix;","#endif","#ifdef USE_INSTANCING_COLOR","\tattribute vec3 instanceColor;","#endif","#ifdef USE_INSTANCING_MORPH","\tuniform sampler2D morphTexture;","#endif","attribute vec3 position;","attribute vec3 normal;","attribute vec2 uv;","#ifdef USE_UV1","\tattribute vec2 uv1;","#endif","#ifdef USE_UV2","\tattribute vec2 uv2;","#endif","#ifdef USE_UV3","\tattribute vec2 uv3;","#endif","#ifdef USE_TANGENT","\tattribute vec4 tangent;","#endif","#if defined( USE_COLOR_ALPHA )","\tattribute vec4 color;","#elif defined( USE_COLOR )","\tattribute vec3 color;","#endif","#ifdef USE_SKINNING","\tattribute vec4 skinIndex;","\tattribute vec4 skinWeight;","#endif","\n"].filter(filterEmptyLine).join("\n"),_=[generatePrecision(r),"#define SHADER_TYPE "+r.shaderType,"#define SHADER_NAME "+r.shaderName,m,r.useFog&&r.fog?"#define USE_FOG":"",r.useFog&&r.fogExp2?"#define FOG_EXP2":"",r.alphaToCoverage?"#define ALPHA_TO_COVERAGE":"",r.map?"#define USE_MAP":"",r.matcap?"#define USE_MATCAP":"",r.envMap?"#define USE_ENVMAP":"",r.envMap?"#define "+c:"",r.envMap?"#define "+h:"",r.envMap?"#define "+u:"",d?"#define CUBEUV_TEXEL_WIDTH "+d.texelWidth:"",d?"#define CUBEUV_TEXEL_HEIGHT "+d.texelHeight:"",d?"#define CUBEUV_MAX_MIP "+d.maxMip+".0":"",r.lightMap?"#define USE_LIGHTMAP":"",r.aoMap?"#define USE_AOMAP":"",r.bumpMap?"#define USE_BUMPMAP":"",r.normalMap?"#define USE_NORMALMAP":"",r.normalMapObjectSpace?"#define USE_NORMALMAP_OBJECTSPACE":"",r.normalMapTangentSpace?"#define USE_NORMALMAP_TANGENTSPACE":"",r.emissiveMap?"#define USE_EMISSIVEMAP":"",r.anisotropy?"#define USE_ANISOTROPY":"",r.anisotropyMap?"#define USE_ANISOTROPYMAP":"",r.clearcoat?"#define USE_CLEARCOAT":"",r.clearcoatMap?"#define USE_CLEARCOATMAP":"",r.clearcoatRoughnessMap?"#define USE_CLEARCOAT_ROUGHNESSMAP":"",r.clearcoatNormalMap?"#define USE_CLEARCOAT_NORMALMAP":"",r.dispersion?"#define USE_DISPERSION":"",r.iridescence?"#define USE_IRIDESCENCE":"",r.iridescenceMap?"#define USE_IRIDESCENCEMAP":"",r.iridescenceThicknessMap?"#define USE_IRIDESCENCE_THICKNESSMAP":"",r.specularMap?"#define USE_SPECULARMAP":"",r.specularColorMap?"#define USE_SPECULAR_COLORMAP":"",r.specularIntensityMap?"#define USE_SPECULAR_INTENSITYMAP":"",r.roughnessMap?"#define USE_ROUGHNESSMAP":"",r.metalnessMap?"#define USE_METALNESSMAP":"",r.alphaMap?"#define USE_ALPHAMAP":"",r.alphaTest?"#define USE_ALPHATEST":"",r.alphaHash?"#define USE_ALPHAHASH":"",r.sheen?"#define USE_SHEEN":"",r.sheenColorMap?"#define USE_SHEEN_COLORMAP":"",r.sheenRoughnessMap?"#define USE_SHEEN_ROUGHNESSMAP":"",r.transmission?"#define USE_TRANSMISSION":"",r.transmissionMap?"#define USE_TRANSMISSIONMAP":"",r.thicknessMap?"#define USE_THICKNESSMAP":"",r.vertexTangents&&!1===r.flatShading?"#define USE_TANGENT":"",r.vertexColors||r.instancingColor||r.batchingColor?"#define USE_COLOR":"",r.vertexAlphas?"#define USE_COLOR_ALPHA":"",r.vertexUv1s?"#define USE_UV1":"",r.vertexUv2s?"#define USE_UV2":"",r.vertexUv3s?"#define USE_UV3":"",r.pointsUvs?"#define USE_POINTS_UV":"",r.gradientMap?"#define USE_GRADIENTMAP":"",r.flatShading?"#define FLAT_SHADED":"",r.doubleSided?"#define DOUBLE_SIDED":"",r.flipSided?"#define FLIP_SIDED":"",r.shadowMapEnabled?"#define USE_SHADOWMAP":"",r.shadowMapEnabled?"#define "+l:"",r.premultipliedAlpha?"#define PREMULTIPLIED_ALPHA":"",r.numLightProbes>0?"#define USE_LIGHT_PROBES":"",r.decodeVideoTexture?"#define DECODE_VIDEO_TEXTURE":"",r.decodeVideoTextureEmissive?"#define DECODE_VIDEO_TEXTURE_EMISSIVE":"",r.logarithmicDepthBuffer?"#define USE_LOGDEPTHBUF":"",r.reverseDepthBuffer?"#define USE_REVERSEDEPTHBUF":"","uniform mat4 viewMatrix;","uniform vec3 cameraPosition;","uniform bool isOrthographic;",0!==r.toneMapping?"#define TONE_MAPPING":"",0!==r.toneMapping?ShaderChunk.tonemapping_pars_fragment:"",0!==r.toneMapping?getToneMappingFunction("toneMapping",r.toneMapping):"",r.dithering?"#define DITHERING":"",r.opaque?"#define OPAQUE":"",ShaderChunk.colorspace_pars_fragment,getTexelEncodingFunction("linearToOutputTexel",r.outputColorSpace),getLuminanceFunction(),r.useDepthPacking?"#define DEPTH_PACKING "+r.depthPacking:"","\n"].filter(filterEmptyLine).join("\n")),s=resolveIncludes(s),s=replaceLightNums(s,r),s=replaceClippingPlaneNums(s,r),o=resolveIncludes(o),o=replaceLightNums(o,r),o=replaceClippingPlaneNums(o,r),s=unrollLoops(s),o=unrollLoops(o),!0!==r.isRawShaderMaterial&&(v="#version 300 es\n",g=[p,"#define attribute in","#define varying out","#define texture2D texture"].join("\n")+"\n"+g,_=["#define varying in",r.glslVersion===GLSL3?"":"layout(location = 0) out highp vec4 pc_fragColor;",r.glslVersion===GLSL3?"":"#define gl_FragColor pc_fragColor","#define gl_FragDepthEXT gl_FragDepth","#define texture2D texture","#define textureCube texture","#define texture2DProj textureProj","#define texture2DLodEXT textureLod","#define texture2DProjLodEXT textureProjLod","#define textureCubeLodEXT textureLod","#define texture2DGradEXT textureGrad","#define texture2DProjGradEXT textureProjGrad","#define textureCubeGradEXT textureGrad"].join("\n")+"\n"+_);const x=v+g+s,y=v+_+o,M=WebGLShader(i,i.VERTEX_SHADER,x),S=WebGLShader(i,i.FRAGMENT_SHADER,y);function b(t){if(e.debug.checkShaderErrors){const r=i.getProgramInfoLog(f).trim(),n=i.getShaderInfoLog(M).trim(),a=i.getShaderInfoLog(S).trim();let s=!0,o=!0;if(!1===i.getProgramParameter(f,i.LINK_STATUS))if(s=!1,"function"==typeof e.debug.onShaderError)e.debug.onShaderError(i,f,M,S);else{const e=getShaderErrors(i,M,"vertex"),n=getShaderErrors(i,S,"fragment");console.error("THREE.WebGLProgram: Shader Error "+i.getError()+" - VALIDATE_STATUS "+i.getProgramParameter(f,i.VALIDATE_STATUS)+"\n\nMaterial Name: "+t.name+"\nMaterial Type: "+t.type+"\n\nProgram Info Log: "+r+"\n"+e+"\n"+n)}else""!==r?console.warn("THREE.WebGLProgram: Program Info Log:",r):""!==n&&""!==a||(o=!1);o&&(t.diagnostics={runnable:s,programLog:r,vertexShader:{log:n,prefix:g},fragmentShader:{log:a,prefix:_}})}i.deleteShader(M),i.deleteShader(S),T=new WebGLUniforms(i,f),E=fetchAttributeLocations(i,f)}let T,E;i.attachShader(f,M),i.attachShader(f,S),void 0!==r.index0AttributeName?i.bindAttribLocation(f,0,r.index0AttributeName):!0===r.morphTargets&&i.bindAttribLocation(f,0,"position"),i.linkProgram(f),this.getUniforms=function(){return void 0===T&&b(this),T},this.getAttributes=function(){return void 0===E&&b(this),E};let A=!1===r.rendererExtensionParallelShaderCompile;return this.isReady=function(){return!1===A&&(A=i.getProgramParameter(f,37297)),A},this.destroy=function(){n.releaseStatesOfProgram(this),i.deleteProgram(f),this.program=void 0},this.type=r.shaderType,this.name=r.shaderName,this.id=programIdCount++,this.cacheKey=t,this.usedTimes=1,this.program=f,this.vertexShader=M,this.fragmentShader=S,this}let _id=0;class WebGLShaderCache{constructor(){this.shaderCache=new Map,this.materialCache=new Map}update(e){const t=e.vertexShader,r=e.fragmentShader,n=this._getShaderStage(t),i=this._getShaderStage(r),a=this._getShaderCacheForMaterial(e);return!1===a.has(n)&&(a.add(n),n.usedTimes++),!1===a.has(i)&&(a.add(i),i.usedTimes++),this}remove(e){const t=this.materialCache.get(e);for(const e of t)e.usedTimes--,0===e.usedTimes&&this.shaderCache.delete(e.code);return this.materialCache.delete(e),this}getVertexShaderID(e){return this._getShaderStage(e.vertexShader).id}getFragmentShaderID(e){return this._getShaderStage(e.fragmentShader).id}dispose(){this.shaderCache.clear(),this.materialCache.clear()}_getShaderCacheForMaterial(e){const t=this.materialCache;let r=t.get(e);return void 0===r&&(r=new Set,t.set(e,r)),r}_getShaderStage(e){const t=this.shaderCache;let r=t.get(e);return void 0===r&&(r=new WebGLShaderStage(e),t.set(e,r)),r}}class WebGLShaderStage{constructor(e){this.id=_id++,this.code=e,this.usedTimes=0}}function WebGLPrograms(e,t,r,n,i,a,s){const o=new Layers,l=new WebGLShaderCache,c=new Set,h=[],u=i.logarithmicDepthBuffer,d=i.vertexTextures;let p=i.precision;const m={MeshDepthMaterial:"depth",MeshDistanceMaterial:"distanceRGBA",MeshNormalMaterial:"normal",MeshBasicMaterial:"basic",MeshLambertMaterial:"lambert",MeshPhongMaterial:"phong",MeshToonMaterial:"toon",MeshStandardMaterial:"physical",MeshPhysicalMaterial:"physical",MeshMatcapMaterial:"matcap",LineBasicMaterial:"basic",LineDashedMaterial:"dashed",PointsMaterial:"points",ShadowMaterial:"shadow",SpriteMaterial:"sprite"};function f(e){return c.add(e),0===e?"uv":`uv${e}`}return{getParameters:function(a,o,h,g,_){const v=g.fog,x=_.geometry,y=a.isMeshStandardMaterial?g.environment:null,M=(a.isMeshStandardMaterial?r:t).get(a.envMap||y),S=M&&306===M.mapping?M.image.height:null,b=m[a.type];null!==a.precision&&(p=i.getMaxPrecision(a.precision),p!==a.precision&&console.warn("THREE.WebGLProgram.getParameters:",a.precision,"not supported, using",p,"instead."));const T=x.morphAttributes.position||x.morphAttributes.normal||x.morphAttributes.color,E=void 0!==T?T.length:0;let A,w,C,R,L=0;if(void 0!==x.morphAttributes.position&&(L=1),void 0!==x.morphAttributes.normal&&(L=2),void 0!==x.morphAttributes.color&&(L=3),b){const e=ShaderLib[b];A=e.vertexShader,w=e.fragmentShader}else A=a.vertexShader,w=a.fragmentShader,l.update(a),C=l.getVertexShaderID(a),R=l.getFragmentShaderID(a);const P=e.getRenderTarget(),I=e.state.buffers.depth.getReversed(),U=!0===_.isInstancedMesh,D=!0===_.isBatchedMesh,N=!!a.map,B=!!a.matcap,F=!!M,O=!!a.aoMap,V=!!a.lightMap,z=!!a.bumpMap,G=!!a.normalMap,k=!!a.displacementMap,H=!!a.emissiveMap,W=!!a.metalnessMap,$=!!a.roughnessMap,X=a.anisotropy>0,j=a.clearcoat>0,q=a.dispersion>0,Y=a.iridescence>0,Z=a.sheen>0,J=a.transmission>0,K=X&&!!a.anisotropyMap,Q=j&&!!a.clearcoatMap,ee=j&&!!a.clearcoatNormalMap,te=j&&!!a.clearcoatRoughnessMap,re=Y&&!!a.iridescenceMap,ne=Y&&!!a.iridescenceThicknessMap,ie=Z&&!!a.sheenColorMap,ae=Z&&!!a.sheenRoughnessMap,se=!!a.specularMap,oe=!!a.specularColorMap,le=!!a.specularIntensityMap,ce=J&&!!a.transmissionMap,he=J&&!!a.thicknessMap,ue=!!a.gradientMap,de=!!a.alphaMap,pe=a.alphaTest>0,me=!!a.alphaHash,fe=!!a.extensions;let ge=0;a.toneMapped&&(null!==P&&!0!==P.isXRRenderTarget||(ge=e.toneMapping));const _e={shaderID:b,shaderType:a.type,shaderName:a.name,vertexShader:A,fragmentShader:w,defines:a.defines,customVertexShaderID:C,customFragmentShaderID:R,isRawShaderMaterial:!0===a.isRawShaderMaterial,glslVersion:a.glslVersion,precision:p,batching:D,batchingColor:D&&null!==_._colorsTexture,instancing:U,instancingColor:U&&null!==_.instanceColor,instancingMorph:U&&null!==_.morphTexture,supportsVertexTextures:d,outputColorSpace:null===P?e.outputColorSpace:!0===P.isXRRenderTarget?P.texture.colorSpace:"srgb-linear",alphaToCoverage:!!a.alphaToCoverage,map:N,matcap:B,envMap:F,envMapMode:F&&M.mapping,envMapCubeUVHeight:S,aoMap:O,lightMap:V,bumpMap:z,normalMap:G,displacementMap:d&&k,emissiveMap:H,normalMapObjectSpace:G&&1===a.normalMapType,normalMapTangentSpace:G&&0===a.normalMapType,metalnessMap:W,roughnessMap:$,anisotropy:X,anisotropyMap:K,clearcoat:j,clearcoatMap:Q,clearcoatNormalMap:ee,clearcoatRoughnessMap:te,dispersion:q,iridescence:Y,iridescenceMap:re,iridescenceThicknessMap:ne,sheen:Z,sheenColorMap:ie,sheenRoughnessMap:ae,specularMap:se,specularColorMap:oe,specularIntensityMap:le,transmission:J,transmissionMap:ce,thicknessMap:he,gradientMap:ue,opaque:!1===a.transparent&&1===a.blending&&!1===a.alphaToCoverage,alphaMap:de,alphaTest:pe,alphaHash:me,combine:a.combine,mapUv:N&&f(a.map.channel),aoMapUv:O&&f(a.aoMap.channel),lightMapUv:V&&f(a.lightMap.channel),bumpMapUv:z&&f(a.bumpMap.channel),normalMapUv:G&&f(a.normalMap.channel),displacementMapUv:k&&f(a.displacementMap.channel),emissiveMapUv:H&&f(a.emissiveMap.channel),metalnessMapUv:W&&f(a.metalnessMap.channel),roughnessMapUv:$&&f(a.roughnessMap.channel),anisotropyMapUv:K&&f(a.anisotropyMap.channel),clearcoatMapUv:Q&&f(a.clearcoatMap.channel),clearcoatNormalMapUv:ee&&f(a.clearcoatNormalMap.channel),clearcoatRoughnessMapUv:te&&f(a.clearcoatRoughnessMap.channel),iridescenceMapUv:re&&f(a.iridescenceMap.channel),iridescenceThicknessMapUv:ne&&f(a.iridescenceThicknessMap.channel),sheenColorMapUv:ie&&f(a.sheenColorMap.channel),sheenRoughnessMapUv:ae&&f(a.sheenRoughnessMap.channel),specularMapUv:se&&f(a.specularMap.channel),specularColorMapUv:oe&&f(a.specularColorMap.channel),specularIntensityMapUv:le&&f(a.specularIntensityMap.channel),transmissionMapUv:ce&&f(a.transmissionMap.channel),thicknessMapUv:he&&f(a.thicknessMap.channel),alphaMapUv:de&&f(a.alphaMap.channel),vertexTangents:!!x.attributes.tangent&&(G||X),vertexColors:a.vertexColors,vertexAlphas:!0===a.vertexColors&&!!x.attributes.color&&4===x.attributes.color.itemSize,pointsUvs:!0===_.isPoints&&!!x.attributes.uv&&(N||de),fog:!!v,useFog:!0===a.fog,fogExp2:!!v&&v.isFogExp2,flatShading:!0===a.flatShading,sizeAttenuation:!0===a.sizeAttenuation,logarithmicDepthBuffer:u,reverseDepthBuffer:I,skinning:!0===_.isSkinnedMesh,morphTargets:void 0!==x.morphAttributes.position,morphNormals:void 0!==x.morphAttributes.normal,morphColors:void 0!==x.morphAttributes.color,morphTargetsCount:E,morphTextureStride:L,numDirLights:o.directional.length,numPointLights:o.point.length,numSpotLights:o.spot.length,numSpotLightMaps:o.spotLightMap.length,numRectAreaLights:o.rectArea.length,numHemiLights:o.hemi.length,numDirLightShadows:o.directionalShadowMap.length,numPointLightShadows:o.pointShadowMap.length,numSpotLightShadows:o.spotShadowMap.length,numSpotLightShadowsWithMaps:o.numSpotLightShadowsWithMaps,numLightProbes:o.numLightProbes,numClippingPlanes:s.numPlanes,numClipIntersection:s.numIntersection,dithering:a.dithering,shadowMapEnabled:e.shadowMap.enabled&&h.length>0,shadowMapType:e.shadowMap.type,toneMapping:ge,decodeVideoTexture:N&&!0===a.map.isVideoTexture&&"srgb"===ColorManagement.getTransfer(a.map.colorSpace),decodeVideoTextureEmissive:H&&!0===a.emissiveMap.isVideoTexture&&"srgb"===ColorManagement.getTransfer(a.emissiveMap.colorSpace),premultipliedAlpha:a.premultipliedAlpha,doubleSided:2===a.side,flipSided:1===a.side,useDepthPacking:a.depthPacking>=0,depthPacking:a.depthPacking||0,index0AttributeName:a.index0AttributeName,extensionClipCullDistance:fe&&!0===a.extensions.clipCullDistance&&n.has("WEBGL_clip_cull_distance"),extensionMultiDraw:(fe&&!0===a.extensions.multiDraw||D)&&n.has("WEBGL_multi_draw"),rendererExtensionParallelShaderCompile:n.has("KHR_parallel_shader_compile"),customProgramCacheKey:a.customProgramCacheKey()};return _e.vertexUv1s=c.has(1),_e.vertexUv2s=c.has(2),_e.vertexUv3s=c.has(3),c.clear(),_e},getProgramCacheKey:function(t){const r=[];if(t.shaderID?r.push(t.shaderID):(r.push(t.customVertexShaderID),r.push(t.customFragmentShaderID)),void 0!==t.defines)for(const e in t.defines)r.push(e),r.push(t.defines[e]);return!1===t.isRawShaderMaterial&&(!function(e,t){e.push(t.precision),e.push(t.outputColorSpace),e.push(t.envMapMode),e.push(t.envMapCubeUVHeight),e.push(t.mapUv),e.push(t.alphaMapUv),e.push(t.lightMapUv),e.push(t.aoMapUv),e.push(t.bumpMapUv),e.push(t.normalMapUv),e.push(t.displacementMapUv),e.push(t.emissiveMapUv),e.push(t.metalnessMapUv),e.push(t.roughnessMapUv),e.push(t.anisotropyMapUv),e.push(t.clearcoatMapUv),e.push(t.clearcoatNormalMapUv),e.push(t.clearcoatRoughnessMapUv),e.push(t.iridescenceMapUv),e.push(t.iridescenceThicknessMapUv),e.push(t.sheenColorMapUv),e.push(t.sheenRoughnessMapUv),e.push(t.specularMapUv),e.push(t.specularColorMapUv),e.push(t.specularIntensityMapUv),e.push(t.transmissionMapUv),e.push(t.thicknessMapUv),e.push(t.combine),e.push(t.fogExp2),e.push(t.sizeAttenuation),e.push(t.morphTargetsCount),e.push(t.morphAttributeCount),e.push(t.numDirLights),e.push(t.numPointLights),e.push(t.numSpotLights),e.push(t.numSpotLightMaps),e.push(t.numHemiLights),e.push(t.numRectAreaLights),e.push(t.numDirLightShadows),e.push(t.numPointLightShadows),e.push(t.numSpotLightShadows),e.push(t.numSpotLightShadowsWithMaps),e.push(t.numLightProbes),e.push(t.shadowMapType),e.push(t.toneMapping),e.push(t.numClippingPlanes),e.push(t.numClipIntersection),e.push(t.depthPacking)}(r,t),function(e,t){o.disableAll(),t.supportsVertexTextures&&o.enable(0);t.instancing&&o.enable(1);t.instancingColor&&o.enable(2);t.instancingMorph&&o.enable(3);t.matcap&&o.enable(4);t.envMap&&o.enable(5);t.normalMapObjectSpace&&o.enable(6);t.normalMapTangentSpace&&o.enable(7);t.clearcoat&&o.enable(8);t.iridescence&&o.enable(9);t.alphaTest&&o.enable(10);t.vertexColors&&o.enable(11);t.vertexAlphas&&o.enable(12);t.vertexUv1s&&o.enable(13);t.vertexUv2s&&o.enable(14);t.vertexUv3s&&o.enable(15);t.vertexTangents&&o.enable(16);t.anisotropy&&o.enable(17);t.alphaHash&&o.enable(18);t.batching&&o.enable(19);t.dispersion&&o.enable(20);t.batchingColor&&o.enable(21);e.push(o.mask),o.disableAll(),t.fog&&o.enable(0);t.useFog&&o.enable(1);t.flatShading&&o.enable(2);t.logarithmicDepthBuffer&&o.enable(3);t.reverseDepthBuffer&&o.enable(4);t.skinning&&o.enable(5);t.morphTargets&&o.enable(6);t.morphNormals&&o.enable(7);t.morphColors&&o.enable(8);t.premultipliedAlpha&&o.enable(9);t.shadowMapEnabled&&o.enable(10);t.doubleSided&&o.enable(11);t.flipSided&&o.enable(12);t.useDepthPacking&&o.enable(13);t.dithering&&o.enable(14);t.transmission&&o.enable(15);t.sheen&&o.enable(16);t.opaque&&o.enable(17);t.pointsUvs&&o.enable(18);t.decodeVideoTexture&&o.enable(19);t.decodeVideoTextureEmissive&&o.enable(20);t.alphaToCoverage&&o.enable(21);e.push(o.mask)}(r,t),r.push(e.outputColorSpace)),r.push(t.customProgramCacheKey),r.join()},getUniforms:function(e){const t=m[e.type];let r;if(t){const e=ShaderLib[t];r=UniformsUtils.clone(e.uniforms)}else r=e.uniforms;return r},acquireProgram:function(t,r){let n;for(let e=0,t=h.length;e<t;e++){const t=h[e];if(t.cacheKey===r){n=t,++n.usedTimes;break}}return void 0===n&&(n=new WebGLProgram(e,r,t,a),h.push(n)),n},releaseProgram:function(e){if(0==--e.usedTimes){const t=h.indexOf(e);h[t]=h[h.length-1],h.pop(),e.destroy()}},releaseShaderCache:function(e){l.remove(e)},programs:h,dispose:function(){l.dispose()}}}function WebGLProperties(){let e=new WeakMap;return{has:function(t){return e.has(t)},get:function(t){let r=e.get(t);return void 0===r&&(r={},e.set(t,r)),r},remove:function(t){e.delete(t)},update:function(t,r,n){e.get(t)[r]=n},dispose:function(){e=new WeakMap}}}function painterSortStable(e,t){return e.groupOrder!==t.groupOrder?e.groupOrder-t.groupOrder:e.renderOrder!==t.renderOrder?e.renderOrder-t.renderOrder:e.material.id!==t.material.id?e.material.id-t.material.id:e.z!==t.z?e.z-t.z:e.id-t.id}function reversePainterSortStable(e,t){return e.groupOrder!==t.groupOrder?e.groupOrder-t.groupOrder:e.renderOrder!==t.renderOrder?e.renderOrder-t.renderOrder:e.z!==t.z?t.z-e.z:e.id-t.id}function WebGLRenderList(){const e=[];let t=0;const r=[],n=[],i=[];function a(r,n,i,a,s,o){let l=e[t];return void 0===l?(l={id:r.id,object:r,geometry:n,material:i,groupOrder:a,renderOrder:r.renderOrder,z:s,group:o},e[t]=l):(l.id=r.id,l.object=r,l.geometry=n,l.material=i,l.groupOrder=a,l.renderOrder=r.renderOrder,l.z=s,l.group=o),t++,l}return{opaque:r,transmissive:n,transparent:i,init:function(){t=0,r.length=0,n.length=0,i.length=0},push:function(e,t,s,o,l,c){const h=a(e,t,s,o,l,c);s.transmission>0?n.push(h):!0===s.transparent?i.push(h):r.push(h)},unshift:function(e,t,s,o,l,c){const h=a(e,t,s,o,l,c);s.transmission>0?n.unshift(h):!0===s.transparent?i.unshift(h):r.unshift(h)},finish:function(){for(let r=t,n=e.length;r<n;r++){const t=e[r];if(null===t.id)break;t.id=null,t.object=null,t.geometry=null,t.material=null,t.group=null}},sort:function(e,t){r.length>1&&r.sort(e||painterSortStable),n.length>1&&n.sort(t||reversePainterSortStable),i.length>1&&i.sort(t||reversePainterSortStable)}}}function WebGLRenderLists(){let e=new WeakMap;return{get:function(t,r){const n=e.get(t);let i;return void 0===n?(i=new WebGLRenderList,e.set(t,[i])):r>=n.length?(i=new WebGLRenderList,n.push(i)):i=n[r],i},dispose:function(){e=new WeakMap}}}function UniformsCache(){const e={};return{get:function(t){if(void 0!==e[t.id])return e[t.id];let r;switch(t.type){case"DirectionalLight":r={direction:new Vector3,color:new Color};break;case"SpotLight":r={position:new Vector3,direction:new Vector3,color:new Color,distance:0,coneCos:0,penumbraCos:0,decay:0};break;case"PointLight":r={position:new Vector3,color:new Color,distance:0,decay:0};break;case"HemisphereLight":r={direction:new Vector3,skyColor:new Color,groundColor:new Color};break;case"RectAreaLight":r={color:new Color,position:new Vector3,halfWidth:new Vector3,halfHeight:new Vector3}}return e[t.id]=r,r}}}function ShadowUniformsCache(){const e={};return{get:function(t){if(void 0!==e[t.id])return e[t.id];let r;switch(t.type){case"DirectionalLight":case"SpotLight":r={shadowIntensity:1,shadowBias:0,shadowNormalBias:0,shadowRadius:1,shadowMapSize:new Vector2};break;case"PointLight":r={shadowIntensity:1,shadowBias:0,shadowNormalBias:0,shadowRadius:1,shadowMapSize:new Vector2,shadowCameraNear:1,shadowCameraFar:1e3}}return e[t.id]=r,r}}}let nextVersion=0;function shadowCastingAndTexturingLightsFirst(e,t){return(t.castShadow?2:0)-(e.castShadow?2:0)+(t.map?1:0)-(e.map?1:0)}function WebGLLights(e){const t=new UniformsCache,r=ShadowUniformsCache(),n={version:0,hash:{directionalLength:-1,pointLength:-1,spotLength:-1,rectAreaLength:-1,hemiLength:-1,numDirectionalShadows:-1,numPointShadows:-1,numSpotShadows:-1,numSpotMaps:-1,numLightProbes:-1},ambient:[0,0,0],probe:[],directional:[],directionalShadow:[],directionalShadowMap:[],directionalShadowMatrix:[],spot:[],spotLightMap:[],spotShadow:[],spotShadowMap:[],spotLightMatrix:[],rectArea:[],rectAreaLTC1:null,rectAreaLTC2:null,point:[],pointShadow:[],pointShadowMap:[],pointShadowMatrix:[],hemi:[],numSpotLightShadowsWithMaps:0,numLightProbes:0};for(let e=0;e<9;e++)n.probe.push(new Vector3);const i=new Vector3,a=new Matrix4,s=new Matrix4;return{setup:function(i){let a=0,s=0,o=0;for(let e=0;e<9;e++)n.probe[e].set(0,0,0);let l=0,c=0,h=0,u=0,d=0,p=0,m=0,f=0,g=0,_=0,v=0;i.sort(shadowCastingAndTexturingLightsFirst);for(let e=0,x=i.length;e<x;e++){const x=i[e],y=x.color,M=x.intensity,S=x.distance,b=x.shadow&&x.shadow.map?x.shadow.map.texture:null;if(x.isAmbientLight)a+=y.r*M,s+=y.g*M,o+=y.b*M;else if(x.isLightProbe){for(let e=0;e<9;e++)n.probe[e].addScaledVector(x.sh.coefficients[e],M);v++}else if(x.isDirectionalLight){const e=t.get(x);if(e.color.copy(x.color).multiplyScalar(x.intensity),x.castShadow){const e=x.shadow,t=r.get(x);t.shadowIntensity=e.intensity,t.shadowBias=e.bias,t.shadowNormalBias=e.normalBias,t.shadowRadius=e.radius,t.shadowMapSize=e.mapSize,n.directionalShadow[l]=t,n.directionalShadowMap[l]=b,n.directionalShadowMatrix[l]=x.shadow.matrix,p++}n.directional[l]=e,l++}else if(x.isSpotLight){const e=t.get(x);e.position.setFromMatrixPosition(x.matrixWorld),e.color.copy(y).multiplyScalar(M),e.distance=S,e.coneCos=Math.cos(x.angle),e.penumbraCos=Math.cos(x.angle*(1-x.penumbra)),e.decay=x.decay,n.spot[h]=e;const i=x.shadow;if(x.map&&(n.spotLightMap[g]=x.map,g++,i.updateMatrices(x),x.castShadow&&_++),n.spotLightMatrix[h]=i.matrix,x.castShadow){const e=r.get(x);e.shadowIntensity=i.intensity,e.shadowBias=i.bias,e.shadowNormalBias=i.normalBias,e.shadowRadius=i.radius,e.shadowMapSize=i.mapSize,n.spotShadow[h]=e,n.spotShadowMap[h]=b,f++}h++}else if(x.isRectAreaLight){const e=t.get(x);e.color.copy(y).multiplyScalar(M),e.halfWidth.set(.5*x.width,0,0),e.halfHeight.set(0,.5*x.height,0),n.rectArea[u]=e,u++}else if(x.isPointLight){const e=t.get(x);if(e.color.copy(x.color).multiplyScalar(x.intensity),e.distance=x.distance,e.decay=x.decay,x.castShadow){const e=x.shadow,t=r.get(x);t.shadowIntensity=e.intensity,t.shadowBias=e.bias,t.shadowNormalBias=e.normalBias,t.shadowRadius=e.radius,t.shadowMapSize=e.mapSize,t.shadowCameraNear=e.camera.near,t.shadowCameraFar=e.camera.far,n.pointShadow[c]=t,n.pointShadowMap[c]=b,n.pointShadowMatrix[c]=x.shadow.matrix,m++}n.point[c]=e,c++}else if(x.isHemisphereLight){const e=t.get(x);e.skyColor.copy(x.color).multiplyScalar(M),e.groundColor.copy(x.groundColor).multiplyScalar(M),n.hemi[d]=e,d++}}u>0&&(!0===e.has("OES_texture_float_linear")?(n.rectAreaLTC1=UniformsLib.LTC_FLOAT_1,n.rectAreaLTC2=UniformsLib.LTC_FLOAT_2):(n.rectAreaLTC1=UniformsLib.LTC_HALF_1,n.rectAreaLTC2=UniformsLib.LTC_HALF_2)),n.ambient[0]=a,n.ambient[1]=s,n.ambient[2]=o;const x=n.hash;x.directionalLength===l&&x.pointLength===c&&x.spotLength===h&&x.rectAreaLength===u&&x.hemiLength===d&&x.numDirectionalShadows===p&&x.numPointShadows===m&&x.numSpotShadows===f&&x.numSpotMaps===g&&x.numLightProbes===v||(n.directional.length=l,n.spot.length=h,n.rectArea.length=u,n.point.length=c,n.hemi.length=d,n.directionalShadow.length=p,n.directionalShadowMap.length=p,n.pointShadow.length=m,n.pointShadowMap.length=m,n.spotShadow.length=f,n.spotShadowMap.length=f,n.directionalShadowMatrix.length=p,n.pointShadowMatrix.length=m,n.spotLightMatrix.length=f+g-_,n.spotLightMap.length=g,n.numSpotLightShadowsWithMaps=_,n.numLightProbes=v,x.directionalLength=l,x.pointLength=c,x.spotLength=h,x.rectAreaLength=u,x.hemiLength=d,x.numDirectionalShadows=p,x.numPointShadows=m,x.numSpotShadows=f,x.numSpotMaps=g,x.numLightProbes=v,n.version=nextVersion++)},setupView:function(e,t){let r=0,o=0,l=0,c=0,h=0;const u=t.matrixWorldInverse;for(let t=0,d=e.length;t<d;t++){const d=e[t];if(d.isDirectionalLight){const e=n.directional[r];e.direction.setFromMatrixPosition(d.matrixWorld),i.setFromMatrixPosition(d.target.matrixWorld),e.direction.sub(i),e.direction.transformDirection(u),r++}else if(d.isSpotLight){const e=n.spot[l];e.position.setFromMatrixPosition(d.matrixWorld),e.position.applyMatrix4(u),e.direction.setFromMatrixPosition(d.matrixWorld),i.setFromMatrixPosition(d.target.matrixWorld),e.direction.sub(i),e.direction.transformDirection(u),l++}else if(d.isRectAreaLight){const e=n.rectArea[c];e.position.setFromMatrixPosition(d.matrixWorld),e.position.applyMatrix4(u),s.identity(),a.copy(d.matrixWorld),a.premultiply(u),s.extractRotation(a),e.halfWidth.set(.5*d.width,0,0),e.halfHeight.set(0,.5*d.height,0),e.halfWidth.applyMatrix4(s),e.halfHeight.applyMatrix4(s),c++}else if(d.isPointLight){const e=n.point[o];e.position.setFromMatrixPosition(d.matrixWorld),e.position.applyMatrix4(u),o++}else if(d.isHemisphereLight){const e=n.hemi[h];e.direction.setFromMatrixPosition(d.matrixWorld),e.direction.transformDirection(u),h++}}},state:n}}function WebGLRenderState(e){const t=new WebGLLights(e),r=[],n=[];const i={lightsArray:r,shadowsArray:n,camera:null,lights:t,transmissionRenderTarget:{}};return{init:function(e){i.camera=e,r.length=0,n.length=0},state:i,setupLights:function(){t.setup(r)},setupLightsView:function(e){t.setupView(r,e)},pushLight:function(e){r.push(e)},pushShadow:function(e){n.push(e)}}}function WebGLRenderStates(e){let t=new WeakMap;return{get:function(r,n=0){const i=t.get(r);let a;return void 0===i?(a=new WebGLRenderState(e),t.set(r,[a])):n>=i.length?(a=new WebGLRenderState(e),i.push(a)):a=i[n],a},dispose:function(){t=new WeakMap}}}const vertex="void main() {\n\tgl_Position = vec4( position, 1.0 );\n}",fragment="uniform sampler2D shadow_pass;\nuniform vec2 resolution;\nuniform float radius;\n#include <packing>\nvoid main() {\n\tconst float samples = float( VSM_SAMPLES );\n\tfloat mean = 0.0;\n\tfloat squared_mean = 0.0;\n\tfloat uvStride = samples <= 1.0 ? 0.0 : 2.0 / ( samples - 1.0 );\n\tfloat uvStart = samples <= 1.0 ? 0.0 : - 1.0;\n\tfor ( float i = 0.0; i < samples; i ++ ) {\n\t\tfloat uvOffset = uvStart + i * uvStride;\n\t\t#ifdef HORIZONTAL_PASS\n\t\t\tvec2 distribution = unpackRGBATo2Half( texture2D( shadow_pass, ( gl_FragCoord.xy + vec2( uvOffset, 0.0 ) * radius ) / resolution ) );\n\t\t\tmean += distribution.x;\n\t\t\tsquared_mean += distribution.y * distribution.y + distribution.x * distribution.x;\n\t\t#else\n\t\t\tfloat depth = unpackRGBAToDepth( texture2D( shadow_pass, ( gl_FragCoord.xy + vec2( 0.0, uvOffset ) * radius ) / resolution ) );\n\t\t\tmean += depth;\n\t\t\tsquared_mean += depth * depth;\n\t\t#endif\n\t}\n\tmean = mean / samples;\n\tsquared_mean = squared_mean / samples;\n\tfloat std_dev = sqrt( squared_mean - mean * mean );\n\tgl_FragColor = pack2HalfToRGBA( vec2( mean, std_dev ) );\n}";function WebGLShadowMap(e,t,r){let n=new Frustum;const i=new Vector2,a=new Vector2,s=new Vector4,o=new MeshDepthMaterial({depthPacking:3201}),l=new MeshDistanceMaterial,c={},h=r.maxTextureSize,u={[FrontSide]:1,[BackSide]:0,[DoubleSide]:2},d=new ShaderMaterial({defines:{VSM_SAMPLES:8},uniforms:{shadow_pass:{value:null},resolution:{value:new Vector2},radius:{value:4}},vertexShader:vertex,fragmentShader:fragment}),p=d.clone();p.defines.HORIZONTAL_PASS=1;const m=new BufferGeometry;m.setAttribute("position",new BufferAttribute(new Float32Array([-1,-1,.5,3,-1,.5,-1,3,.5]),3));const f=new Mesh(m,d),g=this;this.enabled=!1,this.autoUpdate=!0,this.needsUpdate=!1,this.type=1;let _=this.type;function v(r,n){const a=t.update(f);d.defines.VSM_SAMPLES!==r.blurSamples&&(d.defines.VSM_SAMPLES=r.blurSamples,p.defines.VSM_SAMPLES=r.blurSamples,d.needsUpdate=!0,p.needsUpdate=!0),null===r.mapPass&&(r.mapPass=new WebGLRenderTarget(i.x,i.y)),d.uniforms.shadow_pass.value=r.map.texture,d.uniforms.resolution.value=r.mapSize,d.uniforms.radius.value=r.radius,e.setRenderTarget(r.mapPass),e.clear(),e.renderBufferDirect(n,null,a,d,f,null),p.uniforms.shadow_pass.value=r.mapPass.texture,p.uniforms.resolution.value=r.mapSize,p.uniforms.radius.value=r.radius,e.setRenderTarget(r.map),e.clear(),e.renderBufferDirect(n,null,a,p,f,null)}function x(t,r,n,i){let a=null;const s=!0===n.isPointLight?t.customDistanceMaterial:t.customDepthMaterial;if(void 0!==s)a=s;else if(a=!0===n.isPointLight?l:o,e.localClippingEnabled&&!0===r.clipShadows&&Array.isArray(r.clippingPlanes)&&0!==r.clippingPlanes.length||r.displacementMap&&0!==r.displacementScale||r.alphaMap&&r.alphaTest>0||r.map&&r.alphaTest>0||!0===r.alphaToCoverage){const e=a.uuid,t=r.uuid;let n=c[e];void 0===n&&(n={},c[e]=n);let i=n[t];void 0===i&&(i=a.clone(),n[t]=i,r.addEventListener("dispose",M)),a=i}if(a.visible=r.visible,a.wireframe=r.wireframe,a.side=3===i?null!==r.shadowSide?r.shadowSide:r.side:null!==r.shadowSide?r.shadowSide:u[r.side],a.alphaMap=r.alphaMap,a.alphaTest=!0===r.alphaToCoverage?.5:r.alphaTest,a.map=r.map,a.clipShadows=r.clipShadows,a.clippingPlanes=r.clippingPlanes,a.clipIntersection=r.clipIntersection,a.displacementMap=r.displacementMap,a.displacementScale=r.displacementScale,a.displacementBias=r.displacementBias,a.wireframeLinewidth=r.wireframeLinewidth,a.linewidth=r.linewidth,!0===n.isPointLight&&!0===a.isMeshDistanceMaterial){e.properties.get(a).light=n}return a}function y(r,i,a,s,o){if(!1===r.visible)return;if(r.layers.test(i.layers)&&(r.isMesh||r.isLine||r.isPoints)&&(r.castShadow||r.receiveShadow&&3===o)&&(!r.frustumCulled||n.intersectsObject(r))){r.modelViewMatrix.multiplyMatrices(a.matrixWorldInverse,r.matrixWorld);const n=t.update(r),l=r.material;if(Array.isArray(l)){const t=n.groups;for(let c=0,h=t.length;c<h;c++){const h=t[c],u=l[h.materialIndex];if(u&&u.visible){const t=x(r,u,s,o);r.onBeforeShadow(e,r,i,a,n,t,h),e.renderBufferDirect(a,null,n,t,r,h),r.onAfterShadow(e,r,i,a,n,t,h)}}}else if(l.visible){const t=x(r,l,s,o);r.onBeforeShadow(e,r,i,a,n,t,null),e.renderBufferDirect(a,null,n,t,r,null),r.onAfterShadow(e,r,i,a,n,t,null)}}const l=r.children;for(let e=0,t=l.length;e<t;e++)y(l[e],i,a,s,o)}function M(e){e.target.removeEventListener("dispose",M);for(const t in c){const r=c[t],n=e.target.uuid;if(n in r){r[n].dispose(),delete r[n]}}}this.render=function(t,r,o){if(!1===g.enabled)return;if(!1===g.autoUpdate&&!1===g.needsUpdate)return;if(0===t.length)return;const l=e.getRenderTarget(),c=e.getActiveCubeFace(),u=e.getActiveMipmapLevel(),d=e.state;d.setBlending(0),d.buffers.color.setClear(1,1,1,1),d.buffers.depth.setTest(!0),d.setScissorTest(!1);const p=3!==_&&3===this.type,m=3===_&&3!==this.type;for(let l=0,c=t.length;l<c;l++){const c=t[l],u=c.shadow;if(void 0===u){console.warn("THREE.WebGLShadowMap:",c,"has no shadow.");continue}if(!1===u.autoUpdate&&!1===u.needsUpdate)continue;i.copy(u.mapSize);const f=u.getFrameExtents();if(i.multiply(f),a.copy(u.mapSize),(i.x>h||i.y>h)&&(i.x>h&&(a.x=Math.floor(h/f.x),i.x=a.x*f.x,u.mapSize.x=a.x),i.y>h&&(a.y=Math.floor(h/f.y),i.y=a.y*f.y,u.mapSize.y=a.y)),null===u.map||!0===p||!0===m){const e=3!==this.type?{minFilter:1003,magFilter:1003}:{};null!==u.map&&u.map.dispose(),u.map=new WebGLRenderTarget(i.x,i.y,e),u.map.texture.name=c.name+".shadowMap",u.camera.updateProjectionMatrix()}e.setRenderTarget(u.map),e.clear();const g=u.getViewportCount();for(let e=0;e<g;e++){const t=u.getViewport(e);s.set(a.x*t.x,a.y*t.y,a.x*t.z,a.y*t.w),d.viewport(s),u.updateMatrices(c,e),n=u.getFrustum(),y(r,o,u.camera,c,this.type)}!0!==u.isPointLightShadow&&3===this.type&&v(u,o),u.needsUpdate=!1}_=this.type,g.needsUpdate=!1,e.setRenderTarget(l,c,u)}}const reversedFuncs={[NeverDepth]:1,[LessDepth]:6,[EqualDepth]:7,[LessEqualDepth]:5,[AlwaysDepth]:0,[GreaterDepth]:2,[NotEqualDepth]:4,[GreaterEqualDepth]:3};function WebGLState(e,t){const r=new function(){let t=!1;const r=new Vector4;let n=null;const i=new Vector4(0,0,0,0);return{setMask:function(r){n===r||t||(e.colorMask(r,r,r,r),n=r)},setLocked:function(e){t=e},setClear:function(t,n,a,s,o){!0===o&&(t*=s,n*=s,a*=s),r.set(t,n,a,s),!1===i.equals(r)&&(e.clearColor(t,n,a,s),i.copy(r))},reset:function(){t=!1,n=null,i.set(-1,0,0,0)}}},n=new function(){let r=!1,n=!1,i=null,a=null,s=null;return{setReversed:function(e){if(n!==e){const r=t.get("EXT_clip_control");e?r.clipControlEXT(r.LOWER_LEFT_EXT,r.ZERO_TO_ONE_EXT):r.clipControlEXT(r.LOWER_LEFT_EXT,r.NEGATIVE_ONE_TO_ONE_EXT),n=e;const i=s;s=null,this.setClear(i)}},getReversed:function(){return n},setTest:function(t){t?z(e.DEPTH_TEST):G(e.DEPTH_TEST)},setMask:function(t){i===t||r||(e.depthMask(t),i=t)},setFunc:function(t){if(n&&(t=reversedFuncs[t]),a!==t){switch(t){case 0:e.depthFunc(e.NEVER);break;case 1:e.depthFunc(e.ALWAYS);break;case 2:e.depthFunc(e.LESS);break;case 3:default:e.depthFunc(e.LEQUAL);break;case 4:e.depthFunc(e.EQUAL);break;case 5:e.depthFunc(e.GEQUAL);break;case 6:e.depthFunc(e.GREATER);break;case 7:e.depthFunc(e.NOTEQUAL)}a=t}},setLocked:function(e){r=e},setClear:function(t){s!==t&&(n&&(t=1-t),e.clearDepth(t),s=t)},reset:function(){r=!1,i=null,a=null,s=null,n=!1}}},i=new function(){let t=!1,r=null,n=null,i=null,a=null,s=null,o=null,l=null,c=null;return{setTest:function(r){t||(r?z(e.STENCIL_TEST):G(e.STENCIL_TEST))},setMask:function(n){r===n||t||(e.stencilMask(n),r=n)},setFunc:function(t,r,s){n===t&&i===r&&a===s||(e.stencilFunc(t,r,s),n=t,i=r,a=s)},setOp:function(t,r,n){s===t&&o===r&&l===n||(e.stencilOp(t,r,n),s=t,o=r,l=n)},setLocked:function(e){t=e},setClear:function(t){c!==t&&(e.clearStencil(t),c=t)},reset:function(){t=!1,r=null,n=null,i=null,a=null,s=null,o=null,l=null,c=null}}},a=new WeakMap,s=new WeakMap;let o={},l={},c=new WeakMap,h=[],u=null,d=!1,p=null,m=null,f=null,g=null,_=null,v=null,x=null,y=new Color(0,0,0),M=0,S=!1,b=null,T=null,E=null,A=null,w=null;const C=e.getParameter(e.MAX_COMBINED_TEXTURE_IMAGE_UNITS);let R=!1,L=0;const P=e.getParameter(e.VERSION);-1!==P.indexOf("WebGL")?(L=parseFloat(/^WebGL (\d)/.exec(P)[1]),R=L>=1):-1!==P.indexOf("OpenGL ES")&&(L=parseFloat(/^OpenGL ES (\d)/.exec(P)[1]),R=L>=2);let I=null,U={};const D=e.getParameter(e.SCISSOR_BOX),N=e.getParameter(e.VIEWPORT),B=(new Vector4).fromArray(D),F=(new Vector4).fromArray(N);function O(t,r,n,i){const a=new Uint8Array(4),s=e.createTexture();e.bindTexture(t,s),e.texParameteri(t,e.TEXTURE_MIN_FILTER,e.NEAREST),e.texParameteri(t,e.TEXTURE_MAG_FILTER,e.NEAREST);for(let s=0;s<n;s++)t===e.TEXTURE_3D||t===e.TEXTURE_2D_ARRAY?e.texImage3D(r,0,e.RGBA,1,1,i,0,e.RGBA,e.UNSIGNED_BYTE,a):e.texImage2D(r+s,0,e.RGBA,1,1,0,e.RGBA,e.UNSIGNED_BYTE,a);return s}const V={};function z(t){!0!==o[t]&&(e.enable(t),o[t]=!0)}function G(t){!1!==o[t]&&(e.disable(t),o[t]=!1)}V[e.TEXTURE_2D]=O(e.TEXTURE_2D,e.TEXTURE_2D,1),V[e.TEXTURE_CUBE_MAP]=O(e.TEXTURE_CUBE_MAP,e.TEXTURE_CUBE_MAP_POSITIVE_X,6),V[e.TEXTURE_2D_ARRAY]=O(e.TEXTURE_2D_ARRAY,e.TEXTURE_2D_ARRAY,1,1),V[e.TEXTURE_3D]=O(e.TEXTURE_3D,e.TEXTURE_3D,1,1),r.setClear(0,0,0,1),n.setClear(1),i.setClear(0),z(e.DEPTH_TEST),n.setFunc(3),$(!1),X(1),z(e.CULL_FACE),W(0);const k={[AddEquation]:e.FUNC_ADD,[SubtractEquation]:e.FUNC_SUBTRACT,[ReverseSubtractEquation]:e.FUNC_REVERSE_SUBTRACT};k[103]=e.MIN,k[104]=e.MAX;const H={[ZeroFactor]:e.ZERO,[OneFactor]:e.ONE,[SrcColorFactor]:e.SRC_COLOR,[SrcAlphaFactor]:e.SRC_ALPHA,[SrcAlphaSaturateFactor]:e.SRC_ALPHA_SATURATE,[DstColorFactor]:e.DST_COLOR,[DstAlphaFactor]:e.DST_ALPHA,[OneMinusSrcColorFactor]:e.ONE_MINUS_SRC_COLOR,[OneMinusSrcAlphaFactor]:e.ONE_MINUS_SRC_ALPHA,[OneMinusDstColorFactor]:e.ONE_MINUS_DST_COLOR,[OneMinusDstAlphaFactor]:e.ONE_MINUS_DST_ALPHA,[ConstantColorFactor]:e.CONSTANT_COLOR,[OneMinusConstantColorFactor]:e.ONE_MINUS_CONSTANT_COLOR,[ConstantAlphaFactor]:e.CONSTANT_ALPHA,[OneMinusConstantAlphaFactor]:e.ONE_MINUS_CONSTANT_ALPHA};function W(t,r,n,i,a,s,o,l,c,h){if(0!==t){if(!1===d&&(z(e.BLEND),d=!0),5===t)a=a||r,s=s||n,o=o||i,r===m&&a===_||(e.blendEquationSeparate(k[r],k[a]),m=r,_=a),n===f&&i===g&&s===v&&o===x||(e.blendFuncSeparate(H[n],H[i],H[s],H[o]),f=n,g=i,v=s,x=o),!1!==l.equals(y)&&c===M||(e.blendColor(l.r,l.g,l.b,c),y.copy(l),M=c),p=t,S=!1;else if(t!==p||h!==S){if(100===m&&100===_||(e.blendEquation(e.FUNC_ADD),m=100,_=100),h)switch(t){case 1:e.blendFuncSeparate(e.ONE,e.ONE_MINUS_SRC_ALPHA,e.ONE,e.ONE_MINUS_SRC_ALPHA);break;case 2:e.blendFunc(e.ONE,e.ONE);break;case 3:e.blendFuncSeparate(e.ZERO,e.ONE_MINUS_SRC_COLOR,e.ZERO,e.ONE);break;case 4:e.blendFuncSeparate(e.ZERO,e.SRC_COLOR,e.ZERO,e.SRC_ALPHA);break;default:console.error("THREE.WebGLState: Invalid blending: ",t)}else switch(t){case 1:e.blendFuncSeparate(e.SRC_ALPHA,e.ONE_MINUS_SRC_ALPHA,e.ONE,e.ONE_MINUS_SRC_ALPHA);break;case 2:e.blendFunc(e.SRC_ALPHA,e.ONE);break;case 3:e.blendFuncSeparate(e.ZERO,e.ONE_MINUS_SRC_COLOR,e.ZERO,e.ONE);break;case 4:e.blendFunc(e.ZERO,e.SRC_COLOR);break;default:console.error("THREE.WebGLState: Invalid blending: ",t)}f=null,g=null,v=null,x=null,y.set(0,0,0),M=0,p=t,S=h}}else!0===d&&(G(e.BLEND),d=!1)}function $(t){b!==t&&(t?e.frontFace(e.CW):e.frontFace(e.CCW),b=t)}function X(t){0!==t?(z(e.CULL_FACE),t!==T&&(1===t?e.cullFace(e.BACK):2===t?e.cullFace(e.FRONT):e.cullFace(e.FRONT_AND_BACK))):G(e.CULL_FACE),T=t}function j(t,r,n){t?(z(e.POLYGON_OFFSET_FILL),A===r&&w===n||(e.polygonOffset(r,n),A=r,w=n)):G(e.POLYGON_OFFSET_FILL)}return{buffers:{color:r,depth:n,stencil:i},enable:z,disable:G,bindFramebuffer:function(t,r){return l[t]!==r&&(e.bindFramebuffer(t,r),l[t]=r,t===e.DRAW_FRAMEBUFFER&&(l[e.FRAMEBUFFER]=r),t===e.FRAMEBUFFER&&(l[e.DRAW_FRAMEBUFFER]=r),!0)},drawBuffers:function(t,r){let n=h,i=!1;if(t){n=c.get(r),void 0===n&&(n=[],c.set(r,n));const a=t.textures;if(n.length!==a.length||n[0]!==e.COLOR_ATTACHMENT0){for(let t=0,r=a.length;t<r;t++)n[t]=e.COLOR_ATTACHMENT0+t;n.length=a.length,i=!0}}else n[0]!==e.BACK&&(n[0]=e.BACK,i=!0);i&&e.drawBuffers(n)},useProgram:function(t){return u!==t&&(e.useProgram(t),u=t,!0)},setBlending:W,setMaterial:function(t,a){2===t.side?G(e.CULL_FACE):z(e.CULL_FACE);let s=1===t.side;a&&(s=!s),$(s),1===t.blending&&!1===t.transparent?W(0):W(t.blending,t.blendEquation,t.blendSrc,t.blendDst,t.blendEquationAlpha,t.blendSrcAlpha,t.blendDstAlpha,t.blendColor,t.blendAlpha,t.premultipliedAlpha),n.setFunc(t.depthFunc),n.setTest(t.depthTest),n.setMask(t.depthWrite),r.setMask(t.colorWrite);const o=t.stencilWrite;i.setTest(o),o&&(i.setMask(t.stencilWriteMask),i.setFunc(t.stencilFunc,t.stencilRef,t.stencilFuncMask),i.setOp(t.stencilFail,t.stencilZFail,t.stencilZPass)),j(t.polygonOffset,t.polygonOffsetFactor,t.polygonOffsetUnits),!0===t.alphaToCoverage?z(e.SAMPLE_ALPHA_TO_COVERAGE):G(e.SAMPLE_ALPHA_TO_COVERAGE)},setFlipSided:$,setCullFace:X,setLineWidth:function(t){t!==E&&(R&&e.lineWidth(t),E=t)},setPolygonOffset:j,setScissorTest:function(t){t?z(e.SCISSOR_TEST):G(e.SCISSOR_TEST)},activeTexture:function(t){void 0===t&&(t=e.TEXTURE0+C-1),I!==t&&(e.activeTexture(t),I=t)},bindTexture:function(t,r,n){void 0===n&&(n=null===I?e.TEXTURE0+C-1:I);let i=U[n];void 0===i&&(i={type:void 0,texture:void 0},U[n]=i),i.type===t&&i.texture===r||(I!==n&&(e.activeTexture(n),I=n),e.bindTexture(t,r||V[t]),i.type=t,i.texture=r)},unbindTexture:function(){const t=U[I];void 0!==t&&void 0!==t.type&&(e.bindTexture(t.type,null),t.type=void 0,t.texture=void 0)},compressedTexImage2D:function(){try{e.compressedTexImage2D(...arguments)}catch(e){console.error("THREE.WebGLState:",e)}},compressedTexImage3D:function(){try{e.compressedTexImage3D(...arguments)}catch(e){console.error("THREE.WebGLState:",e)}},texImage2D:function(){try{e.texImage2D(...arguments)}catch(e){console.error("THREE.WebGLState:",e)}},texImage3D:function(){try{e.texImage3D(...arguments)}catch(e){console.error("THREE.WebGLState:",e)}},updateUBOMapping:function(t,r){let n=s.get(r);void 0===n&&(n=new WeakMap,s.set(r,n));let i=n.get(t);void 0===i&&(i=e.getUniformBlockIndex(r,t.name),n.set(t,i))},uniformBlockBinding:function(t,r){const n=s.get(r).get(t);a.get(r)!==n&&(e.uniformBlockBinding(r,n,t.__bindingPointIndex),a.set(r,n))},texStorage2D:function(){try{e.texStorage2D(...arguments)}catch(e){console.error("THREE.WebGLState:",e)}},texStorage3D:function(){try{e.texStorage3D(...arguments)}catch(e){console.error("THREE.WebGLState:",e)}},texSubImage2D:function(){try{e.texSubImage2D(...arguments)}catch(e){console.error("THREE.WebGLState:",e)}},texSubImage3D:function(){try{e.texSubImage3D(...arguments)}catch(e){console.error("THREE.WebGLState:",e)}},compressedTexSubImage2D:function(){try{e.compressedTexSubImage2D(...arguments)}catch(e){console.error("THREE.WebGLState:",e)}},compressedTexSubImage3D:function(){try{e.compressedTexSubImage3D(...arguments)}catch(e){console.error("THREE.WebGLState:",e)}},scissor:function(t){!1===B.equals(t)&&(e.scissor(t.x,t.y,t.z,t.w),B.copy(t))},viewport:function(t){!1===F.equals(t)&&(e.viewport(t.x,t.y,t.z,t.w),F.copy(t))},reset:function(){e.disable(e.BLEND),e.disable(e.CULL_FACE),e.disable(e.DEPTH_TEST),e.disable(e.POLYGON_OFFSET_FILL),e.disable(e.SCISSOR_TEST),e.disable(e.STENCIL_TEST),e.disable(e.SAMPLE_ALPHA_TO_COVERAGE),e.blendEquation(e.FUNC_ADD),e.blendFunc(e.ONE,e.ZERO),e.blendFuncSeparate(e.ONE,e.ZERO,e.ONE,e.ZERO),e.blendColor(0,0,0,0),e.colorMask(!0,!0,!0,!0),e.clearColor(0,0,0,0),e.depthMask(!0),e.depthFunc(e.LESS),n.setReversed(!1),e.clearDepth(1),e.stencilMask(4294967295),e.stencilFunc(e.ALWAYS,0,4294967295),e.stencilOp(e.KEEP,e.KEEP,e.KEEP),e.clearStencil(0),e.cullFace(e.BACK),e.frontFace(e.CCW),e.polygonOffset(0,0),e.activeTexture(e.TEXTURE0),e.bindFramebuffer(e.FRAMEBUFFER,null),e.bindFramebuffer(e.DRAW_FRAMEBUFFER,null),e.bindFramebuffer(e.READ_FRAMEBUFFER,null),e.useProgram(null),e.lineWidth(1),e.scissor(0,0,e.canvas.width,e.canvas.height),e.viewport(0,0,e.canvas.width,e.canvas.height),o={},I=null,U={},l={},c=new WeakMap,h=[],u=null,d=!1,p=null,m=null,f=null,g=null,_=null,v=null,x=null,y=new Color(0,0,0),M=0,S=!1,b=null,T=null,E=null,A=null,w=null,B.set(0,0,e.canvas.width,e.canvas.height),F.set(0,0,e.canvas.width,e.canvas.height),r.reset(),n.reset(),i.reset()}}}function WebGLTextures(e,t,r,n,i,a,s){const o=t.has("WEBGL_multisampled_render_to_texture")?t.get("WEBGL_multisampled_render_to_texture"):null,l="undefined"!=typeof navigator&&/OculusBrowser/g.test(navigator.userAgent),c=new Vector2,h=new WeakMap;let u;const d=new WeakMap;let p=!1;try{p="undefined"!=typeof OffscreenCanvas&&null!==new OffscreenCanvas(1,1).getContext("2d")}catch(e){}function m(e,t){return p?new OffscreenCanvas(e,t):createElementNS("canvas")}function f(e,t,r){let n=1;const i=k(e);if((i.width>r||i.height>r)&&(n=r/Math.max(i.width,i.height)),n<1){if("undefined"!=typeof HTMLImageElement&&e instanceof HTMLImageElement||"undefined"!=typeof HTMLCanvasElement&&e instanceof HTMLCanvasElement||"undefined"!=typeof ImageBitmap&&e instanceof ImageBitmap||"undefined"!=typeof VideoFrame&&e instanceof VideoFrame){const r=Math.floor(n*i.width),a=Math.floor(n*i.height);void 0===u&&(u=m(r,a));const s=t?m(r,a):u;s.width=r,s.height=a;return s.getContext("2d").drawImage(e,0,0,r,a),console.warn("THREE.WebGLRenderer: Texture has been resized from ("+i.width+"x"+i.height+") to ("+r+"x"+a+")."),s}return"data"in e&&console.warn("THREE.WebGLRenderer: Image in DataTexture is too big ("+i.width+"x"+i.height+")."),e}return e}function g(e){return e.generateMipmaps}function _(t){e.generateMipmap(t)}function v(t){return t.isWebGLCubeRenderTarget?e.TEXTURE_CUBE_MAP:t.isWebGL3DRenderTarget?e.TEXTURE_3D:t.isWebGLArrayRenderTarget||t.isCompressedArrayTexture?e.TEXTURE_2D_ARRAY:e.TEXTURE_2D}function x(r,n,i,a,s=!1){if(null!==r){if(void 0!==e[r])return e[r];console.warn("THREE.WebGLRenderer: Attempt to use non-existing WebGL internal format '"+r+"'")}let o=n;if(n===e.RED&&(i===e.FLOAT&&(o=e.R32F),i===e.HALF_FLOAT&&(o=e.R16F),i===e.UNSIGNED_BYTE&&(o=e.R8)),n===e.RED_INTEGER&&(i===e.UNSIGNED_BYTE&&(o=e.R8UI),i===e.UNSIGNED_SHORT&&(o=e.R16UI),i===e.UNSIGNED_INT&&(o=e.R32UI),i===e.BYTE&&(o=e.R8I),i===e.SHORT&&(o=e.R16I),i===e.INT&&(o=e.R32I)),n===e.RG&&(i===e.FLOAT&&(o=e.RG32F),i===e.HALF_FLOAT&&(o=e.RG16F),i===e.UNSIGNED_BYTE&&(o=e.RG8)),n===e.RG_INTEGER&&(i===e.UNSIGNED_BYTE&&(o=e.RG8UI),i===e.UNSIGNED_SHORT&&(o=e.RG16UI),i===e.UNSIGNED_INT&&(o=e.RG32UI),i===e.BYTE&&(o=e.RG8I),i===e.SHORT&&(o=e.RG16I),i===e.INT&&(o=e.RG32I)),n===e.RGB_INTEGER&&(i===e.UNSIGNED_BYTE&&(o=e.RGB8UI),i===e.UNSIGNED_SHORT&&(o=e.RGB16UI),i===e.UNSIGNED_INT&&(o=e.RGB32UI),i===e.BYTE&&(o=e.RGB8I),i===e.SHORT&&(o=e.RGB16I),i===e.INT&&(o=e.RGB32I)),n===e.RGBA_INTEGER&&(i===e.UNSIGNED_BYTE&&(o=e.RGBA8UI),i===e.UNSIGNED_SHORT&&(o=e.RGBA16UI),i===e.UNSIGNED_INT&&(o=e.RGBA32UI),i===e.BYTE&&(o=e.RGBA8I),i===e.SHORT&&(o=e.RGBA16I),i===e.INT&&(o=e.RGBA32I)),n===e.RGB&&i===e.UNSIGNED_INT_5_9_9_9_REV&&(o=e.RGB9_E5),n===e.RGBA){const t=s?"linear":ColorManagement.getTransfer(a);i===e.FLOAT&&(o=e.RGBA32F),i===e.HALF_FLOAT&&(o=e.RGBA16F),i===e.UNSIGNED_BYTE&&(o="srgb"===t?e.SRGB8_ALPHA8:e.RGBA8),i===e.UNSIGNED_SHORT_4_4_4_4&&(o=e.RGBA4),i===e.UNSIGNED_SHORT_5_5_5_1&&(o=e.RGB5_A1)}return o!==e.R16F&&o!==e.R32F&&o!==e.RG16F&&o!==e.RG32F&&o!==e.RGBA16F&&o!==e.RGBA32F||t.get("EXT_color_buffer_float"),o}function y(t,r){let n;return t?null===r||1014===r||1020===r?n=e.DEPTH24_STENCIL8:1015===r?n=e.DEPTH32F_STENCIL8:1012===r&&(n=e.DEPTH24_STENCIL8,console.warn("DepthTexture: 16 bit depth attachment is not supported with stencil. Using 24-bit attachment.")):null===r||1014===r||1020===r?n=e.DEPTH_COMPONENT24:1015===r?n=e.DEPTH_COMPONENT32F:1012===r&&(n=e.DEPTH_COMPONENT16),n}function M(e,t){return!0===g(e)||e.isFramebufferTexture&&1003!==e.minFilter&&1006!==e.minFilter?Math.log2(Math.max(t.width,t.height))+1:void 0!==e.mipmaps&&e.mipmaps.length>0?e.mipmaps.length:e.isCompressedTexture&&Array.isArray(e.image)?t.mipmaps.length:1}function S(e){const t=e.target;t.removeEventListener("dispose",S),function(e){const t=n.get(e);if(void 0===t.__webglInit)return;const r=e.source,i=d.get(r);if(i){const n=i[t.__cacheKey];n.usedTimes--,0===n.usedTimes&&T(e),0===Object.keys(i).length&&d.delete(r)}n.remove(e)}(t),t.isVideoTexture&&h.delete(t)}function b(t){const r=t.target;r.removeEventListener("dispose",b),function(t){const r=n.get(t);t.depthTexture&&(t.depthTexture.dispose(),n.remove(t.depthTexture));if(t.isWebGLCubeRenderTarget)for(let t=0;t<6;t++){if(Array.isArray(r.__webglFramebuffer[t]))for(let n=0;n<r.__webglFramebuffer[t].length;n++)e.deleteFramebuffer(r.__webglFramebuffer[t][n]);else e.deleteFramebuffer(r.__webglFramebuffer[t]);r.__webglDepthbuffer&&e.deleteRenderbuffer(r.__webglDepthbuffer[t])}else{if(Array.isArray(r.__webglFramebuffer))for(let t=0;t<r.__webglFramebuffer.length;t++)e.deleteFramebuffer(r.__webglFramebuffer[t]);else e.deleteFramebuffer(r.__webglFramebuffer);if(r.__webglDepthbuffer&&e.deleteRenderbuffer(r.__webglDepthbuffer),r.__webglMultisampledFramebuffer&&e.deleteFramebuffer(r.__webglMultisampledFramebuffer),r.__webglColorRenderbuffer)for(let t=0;t<r.__webglColorRenderbuffer.length;t++)r.__webglColorRenderbuffer[t]&&e.deleteRenderbuffer(r.__webglColorRenderbuffer[t]);r.__webglDepthRenderbuffer&&e.deleteRenderbuffer(r.__webglDepthRenderbuffer)}const i=t.textures;for(let t=0,r=i.length;t<r;t++){const r=n.get(i[t]);r.__webglTexture&&(e.deleteTexture(r.__webglTexture),s.memory.textures--),n.remove(i[t])}n.remove(t)}(r)}function T(t){const r=n.get(t);e.deleteTexture(r.__webglTexture);const i=t.source;delete d.get(i)[r.__cacheKey],s.memory.textures--}let E=0;function A(t,i){const a=n.get(t);if(t.isVideoTexture&&function(e){const t=s.render.frame;h.get(e)!==t&&(h.set(e,t),e.update())}(t),!1===t.isRenderTargetTexture&&t.version>0&&a.__version!==t.version){const e=t.image;if(null===e)console.warn("THREE.WebGLRenderer: Texture marked for update but no image data found.");else{if(!1!==e.complete)return void I(a,t,i);console.warn("THREE.WebGLRenderer: Texture marked for update but image is incomplete")}}r.bindTexture(e.TEXTURE_2D,a.__webglTexture,e.TEXTURE0+i)}const w={[RepeatWrapping]:e.REPEAT,[ClampToEdgeWrapping]:e.CLAMP_TO_EDGE,[MirroredRepeatWrapping]:e.MIRRORED_REPEAT},C={[NearestFilter]:e.NEAREST,[NearestMipmapNearestFilter]:e.NEAREST_MIPMAP_NEAREST,[NearestMipmapLinearFilter]:e.NEAREST_MIPMAP_LINEAR,[LinearFilter]:e.LINEAR,[LinearMipmapNearestFilter]:e.LINEAR_MIPMAP_NEAREST,[LinearMipmapLinearFilter]:e.LINEAR_MIPMAP_LINEAR},R={[NeverCompare]:e.NEVER,[AlwaysCompare]:e.ALWAYS,[LessCompare]:e.LESS,[LessEqualCompare]:e.LEQUAL,[EqualCompare]:e.EQUAL,[GreaterEqualCompare]:e.GEQUAL,[GreaterCompare]:e.GREATER,[NotEqualCompare]:e.NOTEQUAL};function L(r,a){if(1015!==a.type||!1!==t.has("OES_texture_float_linear")||1006!==a.magFilter&&1007!==a.magFilter&&1005!==a.magFilter&&1008!==a.magFilter&&1006!==a.minFilter&&1007!==a.minFilter&&1005!==a.minFilter&&1008!==a.minFilter||console.warn("THREE.WebGLRenderer: Unable to use linear filtering with floating point textures. OES_texture_float_linear not supported on this device."),e.texParameteri(r,e.TEXTURE_WRAP_S,w[a.wrapS]),e.texParameteri(r,e.TEXTURE_WRAP_T,w[a.wrapT]),r!==e.TEXTURE_3D&&r!==e.TEXTURE_2D_ARRAY||e.texParameteri(r,e.TEXTURE_WRAP_R,w[a.wrapR]),e.texParameteri(r,e.TEXTURE_MAG_FILTER,C[a.magFilter]),e.texParameteri(r,e.TEXTURE_MIN_FILTER,C[a.minFilter]),a.compareFunction&&(e.texParameteri(r,e.TEXTURE_COMPARE_MODE,e.COMPARE_REF_TO_TEXTURE),e.texParameteri(r,e.TEXTURE_COMPARE_FUNC,R[a.compareFunction])),!0===t.has("EXT_texture_filter_anisotropic")){if(1003===a.magFilter)return;if(1005!==a.minFilter&&1008!==a.minFilter)return;if(1015===a.type&&!1===t.has("OES_texture_float_linear"))return;if(a.anisotropy>1||n.get(a).__currentAnisotropy){const s=t.get("EXT_texture_filter_anisotropic");e.texParameterf(r,s.TEXTURE_MAX_ANISOTROPY_EXT,Math.min(a.anisotropy,i.getMaxAnisotropy())),n.get(a).__currentAnisotropy=a.anisotropy}}}function P(t,r){let n=!1;void 0===t.__webglInit&&(t.__webglInit=!0,r.addEventListener("dispose",S));const i=r.source;let a=d.get(i);void 0===a&&(a={},d.set(i,a));const o=function(e){const t=[];return t.push(e.wrapS),t.push(e.wrapT),t.push(e.wrapR||0),t.push(e.magFilter),t.push(e.minFilter),t.push(e.anisotropy),t.push(e.internalFormat),t.push(e.format),t.push(e.type),t.push(e.generateMipmaps),t.push(e.premultiplyAlpha),t.push(e.flipY),t.push(e.unpackAlignment),t.push(e.colorSpace),t.join()}(r);if(o!==t.__cacheKey){void 0===a[o]&&(a[o]={texture:e.createTexture(),usedTimes:0},s.memory.textures++,n=!0),a[o].usedTimes++;const i=a[t.__cacheKey];void 0!==i&&(a[t.__cacheKey].usedTimes--,0===i.usedTimes&&T(r)),t.__cacheKey=o,t.__webglTexture=a[o].texture}return n}function I(t,s,o){let l=e.TEXTURE_2D;(s.isDataArrayTexture||s.isCompressedArrayTexture)&&(l=e.TEXTURE_2D_ARRAY),s.isData3DTexture&&(l=e.TEXTURE_3D);const c=P(t,s),h=s.source;r.bindTexture(l,t.__webglTexture,e.TEXTURE0+o);const u=n.get(h);if(h.version!==u.__version||!0===c){r.activeTexture(e.TEXTURE0+o);const t=ColorManagement.getPrimaries(ColorManagement.workingColorSpace),n=""===s.colorSpace?null:ColorManagement.getPrimaries(s.colorSpace),d=""===s.colorSpace||t===n?e.NONE:e.BROWSER_DEFAULT_WEBGL;e.pixelStorei(e.UNPACK_FLIP_Y_WEBGL,s.flipY),e.pixelStorei(e.UNPACK_PREMULTIPLY_ALPHA_WEBGL,s.premultiplyAlpha),e.pixelStorei(e.UNPACK_ALIGNMENT,s.unpackAlignment),e.pixelStorei(e.UNPACK_COLORSPACE_CONVERSION_WEBGL,d);let p=f(s.image,!1,i.maxTextureSize);p=G(s,p);const m=a.convert(s.format,s.colorSpace),v=a.convert(s.type);let S,b=x(s.internalFormat,m,v,s.colorSpace,s.isVideoTexture);L(l,s);const T=s.mipmaps,E=!0!==s.isVideoTexture,A=void 0===u.__version||!0===c,w=h.dataReady,C=M(s,p);if(s.isDepthTexture)b=y(1027===s.format,s.type),A&&(E?r.texStorage2D(e.TEXTURE_2D,1,b,p.width,p.height):r.texImage2D(e.TEXTURE_2D,0,b,p.width,p.height,0,m,v,null));else if(s.isDataTexture)if(T.length>0){E&&A&&r.texStorage2D(e.TEXTURE_2D,C,b,T[0].width,T[0].height);for(let t=0,n=T.length;t<n;t++)S=T[t],E?w&&r.texSubImage2D(e.TEXTURE_2D,t,0,0,S.width,S.height,m,v,S.data):r.texImage2D(e.TEXTURE_2D,t,b,S.width,S.height,0,m,v,S.data);s.generateMipmaps=!1}else E?(A&&r.texStorage2D(e.TEXTURE_2D,C,b,p.width,p.height),w&&r.texSubImage2D(e.TEXTURE_2D,0,0,0,p.width,p.height,m,v,p.data)):r.texImage2D(e.TEXTURE_2D,0,b,p.width,p.height,0,m,v,p.data);else if(s.isCompressedTexture)if(s.isCompressedArrayTexture){E&&A&&r.texStorage3D(e.TEXTURE_2D_ARRAY,C,b,T[0].width,T[0].height,p.depth);for(let t=0,n=T.length;t<n;t++)if(S=T[t],1023!==s.format)if(null!==m)if(E){if(w)if(s.layerUpdates.size>0){const n=getByteLength(S.width,S.height,s.format,s.type);for(const i of s.layerUpdates){const a=S.data.subarray(i*n/S.data.BYTES_PER_ELEMENT,(i+1)*n/S.data.BYTES_PER_ELEMENT);r.compressedTexSubImage3D(e.TEXTURE_2D_ARRAY,t,0,0,i,S.width,S.height,1,m,a)}s.clearLayerUpdates()}else r.compressedTexSubImage3D(e.TEXTURE_2D_ARRAY,t,0,0,0,S.width,S.height,p.depth,m,S.data)}else r.compressedTexImage3D(e.TEXTURE_2D_ARRAY,t,b,S.width,S.height,p.depth,0,S.data,0,0);else console.warn("THREE.WebGLRenderer: Attempt to load unsupported compressed texture format in .uploadTexture()");else E?w&&r.texSubImage3D(e.TEXTURE_2D_ARRAY,t,0,0,0,S.width,S.height,p.depth,m,v,S.data):r.texImage3D(e.TEXTURE_2D_ARRAY,t,b,S.width,S.height,p.depth,0,m,v,S.data)}else{E&&A&&r.texStorage2D(e.TEXTURE_2D,C,b,T[0].width,T[0].height);for(let t=0,n=T.length;t<n;t++)S=T[t],1023!==s.format?null!==m?E?w&&r.compressedTexSubImage2D(e.TEXTURE_2D,t,0,0,S.width,S.height,m,S.data):r.compressedTexImage2D(e.TEXTURE_2D,t,b,S.width,S.height,0,S.data):console.warn("THREE.WebGLRenderer: Attempt to load unsupported compressed texture format in .uploadTexture()"):E?w&&r.texSubImage2D(e.TEXTURE_2D,t,0,0,S.width,S.height,m,v,S.data):r.texImage2D(e.TEXTURE_2D,t,b,S.width,S.height,0,m,v,S.data)}else if(s.isDataArrayTexture)if(E){if(A&&r.texStorage3D(e.TEXTURE_2D_ARRAY,C,b,p.width,p.height,p.depth),w)if(s.layerUpdates.size>0){const t=getByteLength(p.width,p.height,s.format,s.type);for(const n of s.layerUpdates){const i=p.data.subarray(n*t/p.data.BYTES_PER_ELEMENT,(n+1)*t/p.data.BYTES_PER_ELEMENT);r.texSubImage3D(e.TEXTURE_2D_ARRAY,0,0,0,n,p.width,p.height,1,m,v,i)}s.clearLayerUpdates()}else r.texSubImage3D(e.TEXTURE_2D_ARRAY,0,0,0,0,p.width,p.height,p.depth,m,v,p.data)}else r.texImage3D(e.TEXTURE_2D_ARRAY,0,b,p.width,p.height,p.depth,0,m,v,p.data);else if(s.isData3DTexture)E?(A&&r.texStorage3D(e.TEXTURE_3D,C,b,p.width,p.height,p.depth),w&&r.texSubImage3D(e.TEXTURE_3D,0,0,0,0,p.width,p.height,p.depth,m,v,p.data)):r.texImage3D(e.TEXTURE_3D,0,b,p.width,p.height,p.depth,0,m,v,p.data);else if(s.isFramebufferTexture){if(A)if(E)r.texStorage2D(e.TEXTURE_2D,C,b,p.width,p.height);else{let t=p.width,n=p.height;for(let i=0;i<C;i++)r.texImage2D(e.TEXTURE_2D,i,b,t,n,0,m,v,null),t>>=1,n>>=1}}else if(T.length>0){if(E&&A){const t=k(T[0]);r.texStorage2D(e.TEXTURE_2D,C,b,t.width,t.height)}for(let t=0,n=T.length;t<n;t++)S=T[t],E?w&&r.texSubImage2D(e.TEXTURE_2D,t,0,0,m,v,S):r.texImage2D(e.TEXTURE_2D,t,b,m,v,S);s.generateMipmaps=!1}else if(E){if(A){const t=k(p);r.texStorage2D(e.TEXTURE_2D,C,b,t.width,t.height)}w&&r.texSubImage2D(e.TEXTURE_2D,0,0,0,m,v,p)}else r.texImage2D(e.TEXTURE_2D,0,b,m,v,p);g(s)&&_(l),u.__version=h.version,s.onUpdate&&s.onUpdate(s)}t.__version=s.version}function U(t,i,s,l,c,h){const u=a.convert(s.format,s.colorSpace),d=a.convert(s.type),p=x(s.internalFormat,u,d,s.colorSpace),m=n.get(i),f=n.get(s);if(f.__renderTarget=i,!m.__hasExternalTextures){const t=Math.max(1,i.width>>h),n=Math.max(1,i.height>>h);c===e.TEXTURE_3D||c===e.TEXTURE_2D_ARRAY?r.texImage3D(c,h,p,t,n,i.depth,0,u,d,null):r.texImage2D(c,h,p,t,n,0,u,d,null)}r.bindFramebuffer(e.FRAMEBUFFER,t),z(i)?o.framebufferTexture2DMultisampleEXT(e.FRAMEBUFFER,l,c,f.__webglTexture,0,V(i)):(c===e.TEXTURE_2D||c>=e.TEXTURE_CUBE_MAP_POSITIVE_X&&c<=e.TEXTURE_CUBE_MAP_NEGATIVE_Z)&&e.framebufferTexture2D(e.FRAMEBUFFER,l,c,f.__webglTexture,h),r.bindFramebuffer(e.FRAMEBUFFER,null)}function D(t,r,n){if(e.bindRenderbuffer(e.RENDERBUFFER,t),r.depthBuffer){const i=r.depthTexture,a=i&&i.isDepthTexture?i.type:null,s=y(r.stencilBuffer,a),l=r.stencilBuffer?e.DEPTH_STENCIL_ATTACHMENT:e.DEPTH_ATTACHMENT,c=V(r);z(r)?o.renderbufferStorageMultisampleEXT(e.RENDERBUFFER,c,s,r.width,r.height):n?e.renderbufferStorageMultisample(e.RENDERBUFFER,c,s,r.width,r.height):e.renderbufferStorage(e.RENDERBUFFER,s,r.width,r.height),e.framebufferRenderbuffer(e.FRAMEBUFFER,l,e.RENDERBUFFER,t)}else{const t=r.textures;for(let i=0;i<t.length;i++){const s=t[i],l=a.convert(s.format,s.colorSpace),c=a.convert(s.type),h=x(s.internalFormat,l,c,s.colorSpace),u=V(r);n&&!1===z(r)?e.renderbufferStorageMultisample(e.RENDERBUFFER,u,h,r.width,r.height):z(r)?o.renderbufferStorageMultisampleEXT(e.RENDERBUFFER,u,h,r.width,r.height):e.renderbufferStorage(e.RENDERBUFFER,h,r.width,r.height)}}e.bindRenderbuffer(e.RENDERBUFFER,null)}function N(t,i){if(i&&i.isWebGLCubeRenderTarget)throw new Error("Depth Texture with cube render targets is not supported");if(r.bindFramebuffer(e.FRAMEBUFFER,t),!i.depthTexture||!i.depthTexture.isDepthTexture)throw new Error("renderTarget.depthTexture must be an instance of THREE.DepthTexture");const a=n.get(i.depthTexture);a.__renderTarget=i,a.__webglTexture&&i.depthTexture.image.width===i.width&&i.depthTexture.image.height===i.height||(i.depthTexture.image.width=i.width,i.depthTexture.image.height=i.height,i.depthTexture.needsUpdate=!0),A(i.depthTexture,0);const s=a.__webglTexture,l=V(i);if(1026===i.depthTexture.format)z(i)?o.framebufferTexture2DMultisampleEXT(e.FRAMEBUFFER,e.DEPTH_ATTACHMENT,e.TEXTURE_2D,s,0,l):e.framebufferTexture2D(e.FRAMEBUFFER,e.DEPTH_ATTACHMENT,e.TEXTURE_2D,s,0);else{if(1027!==i.depthTexture.format)throw new Error("Unknown depthTexture format");z(i)?o.framebufferTexture2DMultisampleEXT(e.FRAMEBUFFER,e.DEPTH_STENCIL_ATTACHMENT,e.TEXTURE_2D,s,0,l):e.framebufferTexture2D(e.FRAMEBUFFER,e.DEPTH_STENCIL_ATTACHMENT,e.TEXTURE_2D,s,0)}}function B(t){const i=n.get(t),a=!0===t.isWebGLCubeRenderTarget;if(i.__boundDepthTexture!==t.depthTexture){const e=t.depthTexture;if(i.__depthDisposeCallback&&i.__depthDisposeCallback(),e){const t=()=>{delete i.__boundDepthTexture,delete i.__depthDisposeCallback,e.removeEventListener("dispose",t)};e.addEventListener("dispose",t),i.__depthDisposeCallback=t}i.__boundDepthTexture=e}if(t.depthTexture&&!i.__autoAllocateDepthBuffer){if(a)throw new Error("target.depthTexture not supported in Cube render targets");const e=t.texture.mipmaps;e&&e.length>0?N(i.__webglFramebuffer[0],t):N(i.__webglFramebuffer,t)}else if(a){i.__webglDepthbuffer=[];for(let n=0;n<6;n++)if(r.bindFramebuffer(e.FRAMEBUFFER,i.__webglFramebuffer[n]),void 0===i.__webglDepthbuffer[n])i.__webglDepthbuffer[n]=e.createRenderbuffer(),D(i.__webglDepthbuffer[n],t,!1);else{const r=t.stencilBuffer?e.DEPTH_STENCIL_ATTACHMENT:e.DEPTH_ATTACHMENT,a=i.__webglDepthbuffer[n];e.bindRenderbuffer(e.RENDERBUFFER,a),e.framebufferRenderbuffer(e.FRAMEBUFFER,r,e.RENDERBUFFER,a)}}else{const n=t.texture.mipmaps;if(n&&n.length>0?r.bindFramebuffer(e.FRAMEBUFFER,i.__webglFramebuffer[0]):r.bindFramebuffer(e.FRAMEBUFFER,i.__webglFramebuffer),void 0===i.__webglDepthbuffer)i.__webglDepthbuffer=e.createRenderbuffer(),D(i.__webglDepthbuffer,t,!1);else{const r=t.stencilBuffer?e.DEPTH_STENCIL_ATTACHMENT:e.DEPTH_ATTACHMENT,n=i.__webglDepthbuffer;e.bindRenderbuffer(e.RENDERBUFFER,n),e.framebufferRenderbuffer(e.FRAMEBUFFER,r,e.RENDERBUFFER,n)}}r.bindFramebuffer(e.FRAMEBUFFER,null)}const F=[],O=[];function V(e){return Math.min(i.maxSamples,e.samples)}function z(e){const r=n.get(e);return e.samples>0&&!0===t.has("WEBGL_multisampled_render_to_texture")&&!1!==r.__useRenderToTexture}function G(e,t){const r=e.colorSpace,n=e.format,i=e.type;return!0===e.isCompressedTexture||!0===e.isVideoTexture||"srgb-linear"!==r&&""!==r&&("srgb"===ColorManagement.getTransfer(r)?1023===n&&1009===i||console.warn("THREE.WebGLTextures: sRGB encoded textures have to use RGBAFormat and UnsignedByteType."):console.error("THREE.WebGLTextures: Unsupported texture color space:",r)),t}function k(e){return"undefined"!=typeof HTMLImageElement&&e instanceof HTMLImageElement?(c.width=e.naturalWidth||e.width,c.height=e.naturalHeight||e.height):"undefined"!=typeof VideoFrame&&e instanceof VideoFrame?(c.width=e.displayWidth,c.height=e.displayHeight):(c.width=e.width,c.height=e.height),c}this.allocateTextureUnit=function(){const e=E;return e>=i.maxTextures&&console.warn("THREE.WebGLTextures: Trying to use "+e+" texture units while this GPU supports only "+i.maxTextures),E+=1,e},this.resetTextureUnits=function(){E=0},this.setTexture2D=A,this.setTexture2DArray=function(t,i){const a=n.get(t);t.version>0&&a.__version!==t.version?I(a,t,i):r.bindTexture(e.TEXTURE_2D_ARRAY,a.__webglTexture,e.TEXTURE0+i)},this.setTexture3D=function(t,i){const a=n.get(t);t.version>0&&a.__version!==t.version?I(a,t,i):r.bindTexture(e.TEXTURE_3D,a.__webglTexture,e.TEXTURE0+i)},this.setTextureCube=function(t,s){const o=n.get(t);t.version>0&&o.__version!==t.version?function(t,s,o){if(6!==s.image.length)return;const l=P(t,s),c=s.source;r.bindTexture(e.TEXTURE_CUBE_MAP,t.__webglTexture,e.TEXTURE0+o);const h=n.get(c);if(c.version!==h.__version||!0===l){r.activeTexture(e.TEXTURE0+o);const t=ColorManagement.getPrimaries(ColorManagement.workingColorSpace),n=""===s.colorSpace?null:ColorManagement.getPrimaries(s.colorSpace),u=""===s.colorSpace||t===n?e.NONE:e.BROWSER_DEFAULT_WEBGL;e.pixelStorei(e.UNPACK_FLIP_Y_WEBGL,s.flipY),e.pixelStorei(e.UNPACK_PREMULTIPLY_ALPHA_WEBGL,s.premultiplyAlpha),e.pixelStorei(e.UNPACK_ALIGNMENT,s.unpackAlignment),e.pixelStorei(e.UNPACK_COLORSPACE_CONVERSION_WEBGL,u);const d=s.isCompressedTexture||s.image[0].isCompressedTexture,p=s.image[0]&&s.image[0].isDataTexture,m=[];for(let e=0;e<6;e++)m[e]=d||p?p?s.image[e].image:s.image[e]:f(s.image[e],!0,i.maxCubemapSize),m[e]=G(s,m[e]);const v=m[0],y=a.convert(s.format,s.colorSpace),S=a.convert(s.type),b=x(s.internalFormat,y,S,s.colorSpace),T=!0!==s.isVideoTexture,E=void 0===h.__version||!0===l,A=c.dataReady;let w,C=M(s,v);if(L(e.TEXTURE_CUBE_MAP,s),d){T&&E&&r.texStorage2D(e.TEXTURE_CUBE_MAP,C,b,v.width,v.height);for(let t=0;t<6;t++){w=m[t].mipmaps;for(let n=0;n<w.length;n++){const i=w[n];1023!==s.format?null!==y?T?A&&r.compressedTexSubImage2D(e.TEXTURE_CUBE_MAP_POSITIVE_X+t,n,0,0,i.width,i.height,y,i.data):r.compressedTexImage2D(e.TEXTURE_CUBE_MAP_POSITIVE_X+t,n,b,i.width,i.height,0,i.data):console.warn("THREE.WebGLRenderer: Attempt to load unsupported compressed texture format in .setTextureCube()"):T?A&&r.texSubImage2D(e.TEXTURE_CUBE_MAP_POSITIVE_X+t,n,0,0,i.width,i.height,y,S,i.data):r.texImage2D(e.TEXTURE_CUBE_MAP_POSITIVE_X+t,n,b,i.width,i.height,0,y,S,i.data)}}}else{if(w=s.mipmaps,T&&E){w.length>0&&C++;const t=k(m[0]);r.texStorage2D(e.TEXTURE_CUBE_MAP,C,b,t.width,t.height)}for(let t=0;t<6;t++)if(p){T?A&&r.texSubImage2D(e.TEXTURE_CUBE_MAP_POSITIVE_X+t,0,0,0,m[t].width,m[t].height,y,S,m[t].data):r.texImage2D(e.TEXTURE_CUBE_MAP_POSITIVE_X+t,0,b,m[t].width,m[t].height,0,y,S,m[t].data);for(let n=0;n<w.length;n++){const i=w[n].image[t].image;T?A&&r.texSubImage2D(e.TEXTURE_CUBE_MAP_POSITIVE_X+t,n+1,0,0,i.width,i.height,y,S,i.data):r.texImage2D(e.TEXTURE_CUBE_MAP_POSITIVE_X+t,n+1,b,i.width,i.height,0,y,S,i.data)}}else{T?A&&r.texSubImage2D(e.TEXTURE_CUBE_MAP_POSITIVE_X+t,0,0,0,y,S,m[t]):r.texImage2D(e.TEXTURE_CUBE_MAP_POSITIVE_X+t,0,b,y,S,m[t]);for(let n=0;n<w.length;n++){const i=w[n];T?A&&r.texSubImage2D(e.TEXTURE_CUBE_MAP_POSITIVE_X+t,n+1,0,0,y,S,i.image[t]):r.texImage2D(e.TEXTURE_CUBE_MAP_POSITIVE_X+t,n+1,b,y,S,i.image[t])}}}g(s)&&_(e.TEXTURE_CUBE_MAP),h.__version=c.version,s.onUpdate&&s.onUpdate(s)}t.__version=s.version}(o,t,s):r.bindTexture(e.TEXTURE_CUBE_MAP,o.__webglTexture,e.TEXTURE0+s)},this.rebindTextures=function(t,r,i){const a=n.get(t);void 0!==r&&U(a.__webglFramebuffer,t,t.texture,e.COLOR_ATTACHMENT0,e.TEXTURE_2D,0),void 0!==i&&B(t)},this.setupRenderTarget=function(t){const i=t.texture,o=n.get(t),l=n.get(i);t.addEventListener("dispose",b);const c=t.textures,h=!0===t.isWebGLCubeRenderTarget,u=c.length>1;if(u||(void 0===l.__webglTexture&&(l.__webglTexture=e.createTexture()),l.__version=i.version,s.memory.textures++),h){o.__webglFramebuffer=[];for(let t=0;t<6;t++)if(i.mipmaps&&i.mipmaps.length>0){o.__webglFramebuffer[t]=[];for(let r=0;r<i.mipmaps.length;r++)o.__webglFramebuffer[t][r]=e.createFramebuffer()}else o.__webglFramebuffer[t]=e.createFramebuffer()}else{if(i.mipmaps&&i.mipmaps.length>0){o.__webglFramebuffer=[];for(let t=0;t<i.mipmaps.length;t++)o.__webglFramebuffer[t]=e.createFramebuffer()}else o.__webglFramebuffer=e.createFramebuffer();if(u)for(let t=0,r=c.length;t<r;t++){const r=n.get(c[t]);void 0===r.__webglTexture&&(r.__webglTexture=e.createTexture(),s.memory.textures++)}if(t.samples>0&&!1===z(t)){o.__webglMultisampledFramebuffer=e.createFramebuffer(),o.__webglColorRenderbuffer=[],r.bindFramebuffer(e.FRAMEBUFFER,o.__webglMultisampledFramebuffer);for(let r=0;r<c.length;r++){const n=c[r];o.__webglColorRenderbuffer[r]=e.createRenderbuffer(),e.bindRenderbuffer(e.RENDERBUFFER,o.__webglColorRenderbuffer[r]);const i=a.convert(n.format,n.colorSpace),s=a.convert(n.type),l=x(n.internalFormat,i,s,n.colorSpace,!0===t.isXRRenderTarget),h=V(t);e.renderbufferStorageMultisample(e.RENDERBUFFER,h,l,t.width,t.height),e.framebufferRenderbuffer(e.FRAMEBUFFER,e.COLOR_ATTACHMENT0+r,e.RENDERBUFFER,o.__webglColorRenderbuffer[r])}e.bindRenderbuffer(e.RENDERBUFFER,null),t.depthBuffer&&(o.__webglDepthRenderbuffer=e.createRenderbuffer(),D(o.__webglDepthRenderbuffer,t,!0)),r.bindFramebuffer(e.FRAMEBUFFER,null)}}if(h){r.bindTexture(e.TEXTURE_CUBE_MAP,l.__webglTexture),L(e.TEXTURE_CUBE_MAP,i);for(let r=0;r<6;r++)if(i.mipmaps&&i.mipmaps.length>0)for(let n=0;n<i.mipmaps.length;n++)U(o.__webglFramebuffer[r][n],t,i,e.COLOR_ATTACHMENT0,e.TEXTURE_CUBE_MAP_POSITIVE_X+r,n);else U(o.__webglFramebuffer[r],t,i,e.COLOR_ATTACHMENT0,e.TEXTURE_CUBE_MAP_POSITIVE_X+r,0);g(i)&&_(e.TEXTURE_CUBE_MAP),r.unbindTexture()}else if(u){for(let i=0,a=c.length;i<a;i++){const a=c[i],s=n.get(a);r.bindTexture(e.TEXTURE_2D,s.__webglTexture),L(e.TEXTURE_2D,a),U(o.__webglFramebuffer,t,a,e.COLOR_ATTACHMENT0+i,e.TEXTURE_2D,0),g(a)&&_(e.TEXTURE_2D)}r.unbindTexture()}else{let n=e.TEXTURE_2D;if((t.isWebGL3DRenderTarget||t.isWebGLArrayRenderTarget)&&(n=t.isWebGL3DRenderTarget?e.TEXTURE_3D:e.TEXTURE_2D_ARRAY),r.bindTexture(n,l.__webglTexture),L(n,i),i.mipmaps&&i.mipmaps.length>0)for(let r=0;r<i.mipmaps.length;r++)U(o.__webglFramebuffer[r],t,i,e.COLOR_ATTACHMENT0,n,r);else U(o.__webglFramebuffer,t,i,e.COLOR_ATTACHMENT0,n,0);g(i)&&_(n),r.unbindTexture()}t.depthBuffer&&B(t)},this.updateRenderTargetMipmap=function(e){const t=e.textures;for(let i=0,a=t.length;i<a;i++){const a=t[i];if(g(a)){const t=v(e),i=n.get(a).__webglTexture;r.bindTexture(t,i),_(t),r.unbindTexture()}}},this.updateMultisampleRenderTarget=function(t){if(t.samples>0)if(!1===z(t)){const i=t.textures,a=t.width,s=t.height;let o=e.COLOR_BUFFER_BIT;const c=t.stencilBuffer?e.DEPTH_STENCIL_ATTACHMENT:e.DEPTH_ATTACHMENT,h=n.get(t),u=i.length>1;if(u)for(let t=0;t<i.length;t++)r.bindFramebuffer(e.FRAMEBUFFER,h.__webglMultisampledFramebuffer),e.framebufferRenderbuffer(e.FRAMEBUFFER,e.COLOR_ATTACHMENT0+t,e.RENDERBUFFER,null),r.bindFramebuffer(e.FRAMEBUFFER,h.__webglFramebuffer),e.framebufferTexture2D(e.DRAW_FRAMEBUFFER,e.COLOR_ATTACHMENT0+t,e.TEXTURE_2D,null,0);r.bindFramebuffer(e.READ_FRAMEBUFFER,h.__webglMultisampledFramebuffer);const d=t.texture.mipmaps;d&&d.length>0?r.bindFramebuffer(e.DRAW_FRAMEBUFFER,h.__webglFramebuffer[0]):r.bindFramebuffer(e.DRAW_FRAMEBUFFER,h.__webglFramebuffer);for(let r=0;r<i.length;r++){if(t.resolveDepthBuffer&&(t.depthBuffer&&(o|=e.DEPTH_BUFFER_BIT),t.stencilBuffer&&t.resolveStencilBuffer&&(o|=e.STENCIL_BUFFER_BIT)),u){e.framebufferRenderbuffer(e.READ_FRAMEBUFFER,e.COLOR_ATTACHMENT0,e.RENDERBUFFER,h.__webglColorRenderbuffer[r]);const t=n.get(i[r]).__webglTexture;e.framebufferTexture2D(e.DRAW_FRAMEBUFFER,e.COLOR_ATTACHMENT0,e.TEXTURE_2D,t,0)}e.blitFramebuffer(0,0,a,s,0,0,a,s,o,e.NEAREST),!0===l&&(F.length=0,O.length=0,F.push(e.COLOR_ATTACHMENT0+r),t.depthBuffer&&!1===t.resolveDepthBuffer&&(F.push(c),O.push(c),e.invalidateFramebuffer(e.DRAW_FRAMEBUFFER,O)),e.invalidateFramebuffer(e.READ_FRAMEBUFFER,F))}if(r.bindFramebuffer(e.READ_FRAMEBUFFER,null),r.bindFramebuffer(e.DRAW_FRAMEBUFFER,null),u)for(let t=0;t<i.length;t++){r.bindFramebuffer(e.FRAMEBUFFER,h.__webglMultisampledFramebuffer),e.framebufferRenderbuffer(e.FRAMEBUFFER,e.COLOR_ATTACHMENT0+t,e.RENDERBUFFER,h.__webglColorRenderbuffer[t]);const a=n.get(i[t]).__webglTexture;r.bindFramebuffer(e.FRAMEBUFFER,h.__webglFramebuffer),e.framebufferTexture2D(e.DRAW_FRAMEBUFFER,e.COLOR_ATTACHMENT0+t,e.TEXTURE_2D,a,0)}r.bindFramebuffer(e.DRAW_FRAMEBUFFER,h.__webglMultisampledFramebuffer)}else if(t.depthBuffer&&!1===t.resolveDepthBuffer&&l){const r=t.stencilBuffer?e.DEPTH_STENCIL_ATTACHMENT:e.DEPTH_ATTACHMENT;e.invalidateFramebuffer(e.DRAW_FRAMEBUFFER,[r])}},this.setupDepthRenderbuffer=B,this.setupFrameBufferTexture=U,this.useMultisampledRTT=z}function WebGLUtils(e,t){return{convert:function(r,n=""){let i;const a=ColorManagement.getTransfer(n);if(1009===r)return e.UNSIGNED_BYTE;if(1017===r)return e.UNSIGNED_SHORT_4_4_4_4;if(1018===r)return e.UNSIGNED_SHORT_5_5_5_1;if(35902===r)return e.UNSIGNED_INT_5_9_9_9_REV;if(1010===r)return e.BYTE;if(1011===r)return e.SHORT;if(1012===r)return e.UNSIGNED_SHORT;if(1013===r)return e.INT;if(1014===r)return e.UNSIGNED_INT;if(1015===r)return e.FLOAT;if(1016===r)return e.HALF_FLOAT;if(1021===r)return e.ALPHA;if(1022===r)return e.RGB;if(1023===r)return e.RGBA;if(1026===r)return e.DEPTH_COMPONENT;if(1027===r)return e.DEPTH_STENCIL;if(1028===r)return e.RED;if(1029===r)return e.RED_INTEGER;if(1030===r)return e.RG;if(1031===r)return e.RG_INTEGER;if(1033===r)return e.RGBA_INTEGER;if(33776===r||33777===r||33778===r||33779===r)if("srgb"===a){if(i=t.get("WEBGL_compressed_texture_s3tc_srgb"),null===i)return null;if(33776===r)return i.COMPRESSED_SRGB_S3TC_DXT1_EXT;if(33777===r)return i.COMPRESSED_SRGB_ALPHA_S3TC_DXT1_EXT;if(33778===r)return i.COMPRESSED_SRGB_ALPHA_S3TC_DXT3_EXT;if(33779===r)return i.COMPRESSED_SRGB_ALPHA_S3TC_DXT5_EXT}else{if(i=t.get("WEBGL_compressed_texture_s3tc"),null===i)return null;if(33776===r)return i.COMPRESSED_RGB_S3TC_DXT1_EXT;if(33777===r)return i.COMPRESSED_RGBA_S3TC_DXT1_EXT;if(33778===r)return i.COMPRESSED_RGBA_S3TC_DXT3_EXT;if(33779===r)return i.COMPRESSED_RGBA_S3TC_DXT5_EXT}if(35840===r||35841===r||35842===r||35843===r){if(i=t.get("WEBGL_compressed_texture_pvrtc"),null===i)return null;if(35840===r)return i.COMPRESSED_RGB_PVRTC_4BPPV1_IMG;if(35841===r)return i.COMPRESSED_RGB_PVRTC_2BPPV1_IMG;if(35842===r)return i.COMPRESSED_RGBA_PVRTC_4BPPV1_IMG;if(35843===r)return i.COMPRESSED_RGBA_PVRTC_2BPPV1_IMG}if(36196===r||37492===r||37496===r){if(i=t.get("WEBGL_compressed_texture_etc"),null===i)return null;if(36196===r||37492===r)return"srgb"===a?i.COMPRESSED_SRGB8_ETC2:i.COMPRESSED_RGB8_ETC2;if(37496===r)return"srgb"===a?i.COMPRESSED_SRGB8_ALPHA8_ETC2_EAC:i.COMPRESSED_RGBA8_ETC2_EAC}if(37808===r||37809===r||37810===r||37811===r||37812===r||37813===r||37814===r||37815===r||37816===r||37817===r||37818===r||37819===r||37820===r||37821===r){if(i=t.get("WEBGL_compressed_texture_astc"),null===i)return null;if(37808===r)return"srgb"===a?i.COMPRESSED_SRGB8_ALPHA8_ASTC_4x4_KHR:i.COMPRESSED_RGBA_ASTC_4x4_KHR;if(37809===r)return"srgb"===a?i.COMPRESSED_SRGB8_ALPHA8_ASTC_5x4_KHR:i.COMPRESSED_RGBA_ASTC_5x4_KHR;if(37810===r)return"srgb"===a?i.COMPRESSED_SRGB8_ALPHA8_ASTC_5x5_KHR:i.COMPRESSED_RGBA_ASTC_5x5_KHR;if(37811===r)return"srgb"===a?i.COMPRESSED_SRGB8_ALPHA8_ASTC_6x5_KHR:i.COMPRESSED_RGBA_ASTC_6x5_KHR;if(37812===r)return"srgb"===a?i.COMPRESSED_SRGB8_ALPHA8_ASTC_6x6_KHR:i.COMPRESSED_RGBA_ASTC_6x6_KHR;if(37813===r)return"srgb"===a?i.COMPRESSED_SRGB8_ALPHA8_ASTC_8x5_KHR:i.COMPRESSED_RGBA_ASTC_8x5_KHR;if(37814===r)return"srgb"===a?i.COMPRESSED_SRGB8_ALPHA8_ASTC_8x6_KHR:i.COMPRESSED_RGBA_ASTC_8x6_KHR;if(37815===r)return"srgb"===a?i.COMPRESSED_SRGB8_ALPHA8_ASTC_8x8_KHR:i.COMPRESSED_RGBA_ASTC_8x8_KHR;if(37816===r)return"srgb"===a?i.COMPRESSED_SRGB8_ALPHA8_ASTC_10x5_KHR:i.COMPRESSED_RGBA_ASTC_10x5_KHR;if(37817===r)return"srgb"===a?i.COMPRESSED_SRGB8_ALPHA8_ASTC_10x6_KHR:i.COMPRESSED_RGBA_ASTC_10x6_KHR;if(37818===r)return"srgb"===a?i.COMPRESSED_SRGB8_ALPHA8_ASTC_10x8_KHR:i.COMPRESSED_RGBA_ASTC_10x8_KHR;if(37819===r)return"srgb"===a?i.COMPRESSED_SRGB8_ALPHA8_ASTC_10x10_KHR:i.COMPRESSED_RGBA_ASTC_10x10_KHR;if(37820===r)return"srgb"===a?i.COMPRESSED_SRGB8_ALPHA8_ASTC_12x10_KHR:i.COMPRESSED_RGBA_ASTC_12x10_KHR;if(37821===r)return"srgb"===a?i.COMPRESSED_SRGB8_ALPHA8_ASTC_12x12_KHR:i.COMPRESSED_RGBA_ASTC_12x12_KHR}if(36492===r||36494===r||36495===r){if(i=t.get("EXT_texture_compression_bptc"),null===i)return null;if(36492===r)return"srgb"===a?i.COMPRESSED_SRGB_ALPHA_BPTC_UNORM_EXT:i.COMPRESSED_RGBA_BPTC_UNORM_EXT;if(36494===r)return i.COMPRESSED_RGB_BPTC_SIGNED_FLOAT_EXT;if(36495===r)return i.COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT_EXT}if(36283===r||36284===r||36285===r||36286===r){if(i=t.get("EXT_texture_compression_rgtc"),null===i)return null;if(36492===r)return i.COMPRESSED_RED_RGTC1_EXT;if(36284===r)return i.COMPRESSED_SIGNED_RED_RGTC1_EXT;if(36285===r)return i.COMPRESSED_RED_GREEN_RGTC2_EXT;if(36286===r)return i.COMPRESSED_SIGNED_RED_GREEN_RGTC2_EXT}return 1020===r?e.UNSIGNED_INT_24_8:void 0!==e[r]?e[r]:null}}}const _occlusion_vertex="\nvoid main() {\n\n\tgl_Position = vec4( position, 1.0 );\n\n}",_occlusion_fragment="\nuniform sampler2DArray depthColor;\nuniform float depthWidth;\nuniform float depthHeight;\n\nvoid main() {\n\n\tvec2 coord = vec2( gl_FragCoord.x / depthWidth, gl_FragCoord.y / depthHeight );\n\n\tif ( coord.x >= 1.0 ) {\n\n\t\tgl_FragDepth = texture( depthColor, vec3( coord.x - 1.0, coord.y, 1 ) ).r;\n\n\t} else {\n\n\t\tgl_FragDepth = texture( depthColor, vec3( coord.x, coord.y, 0 ) ).r;\n\n\t}\n\n}";class WebXRDepthSensing{constructor(){this.texture=null,this.mesh=null,this.depthNear=0,this.depthFar=0}init(e,t,r){if(null===this.texture){const n=new Texture;e.properties.get(n).__webglTexture=t.texture,t.depthNear===r.depthNear&&t.depthFar===r.depthFar||(this.depthNear=t.depthNear,this.depthFar=t.depthFar),this.texture=n}}getMesh(e){if(null!==this.texture&&null===this.mesh){const t=e.cameras[0].viewport,r=new ShaderMaterial({vertexShader:_occlusion_vertex,fragmentShader:_occlusion_fragment,uniforms:{depthColor:{value:this.texture},depthWidth:{value:t.z},depthHeight:{value:t.w}}});this.mesh=new Mesh(new PlaneGeometry(20,20),r)}return this.mesh}reset(){this.texture=null,this.mesh=null}getDepthTexture(){return this.texture}}class WebXRManager extends EventDispatcher{constructor(e,t){super();const r=this;let n=null,i=1,a=null,s="local-floor",o=1,l=null,c=null,h=null,u=null,d=null,p=null;const m=new WebXRDepthSensing,f=t.getContextAttributes();let g=null,_=null;const v=[],x=[],y=new Vector2;let M=null;const S=new PerspectiveCamera;S.viewport=new Vector4;const b=new PerspectiveCamera;b.viewport=new Vector4;const T=[S,b],E=new ArrayCamera;let A=null,w=null;function C(e){const t=x.indexOf(e.inputSource);if(-1===t)return;const r=v[t];void 0!==r&&(r.update(e.inputSource,e.frame,l||a),r.dispatchEvent({type:e.type,data:e.inputSource}))}function R(){n.removeEventListener("select",C),n.removeEventListener("selectstart",C),n.removeEventListener("selectend",C),n.removeEventListener("squeeze",C),n.removeEventListener("squeezestart",C),n.removeEventListener("squeezeend",C),n.removeEventListener("end",R),n.removeEventListener("inputsourceschange",L);for(let e=0;e<v.length;e++){const t=x[e];null!==t&&(x[e]=null,v[e].disconnect(t))}A=null,w=null,m.reset(),e.setRenderTarget(g),d=null,u=null,h=null,n=null,_=null,N.stop(),r.isPresenting=!1,e.setPixelRatio(M),e.setSize(y.width,y.height,!1),r.dispatchEvent({type:"sessionend"})}function L(e){for(let t=0;t<e.removed.length;t++){const r=e.removed[t],n=x.indexOf(r);n>=0&&(x[n]=null,v[n].disconnect(r))}for(let t=0;t<e.added.length;t++){const r=e.added[t];let n=x.indexOf(r);if(-1===n){for(let e=0;e<v.length;e++){if(e>=x.length){x.push(r),n=e;break}if(null===x[e]){x[e]=r,n=e;break}}if(-1===n)break}const i=v[n];i&&i.connect(r)}}this.cameraAutoUpdate=!0,this.enabled=!1,this.isPresenting=!1,this.getController=function(e){let t=v[e];return void 0===t&&(t=new WebXRController,v[e]=t),t.getTargetRaySpace()},this.getControllerGrip=function(e){let t=v[e];return void 0===t&&(t=new WebXRController,v[e]=t),t.getGripSpace()},this.getHand=function(e){let t=v[e];return void 0===t&&(t=new WebXRController,v[e]=t),t.getHandSpace()},this.setFramebufferScaleFactor=function(e){i=e,!0===r.isPresenting&&console.warn("THREE.WebXRManager: Cannot change framebuffer scale while presenting.")},this.setReferenceSpaceType=function(e){s=e,!0===r.isPresenting&&console.warn("THREE.WebXRManager: Cannot change reference space type while presenting.")},this.getReferenceSpace=function(){return l||a},this.setReferenceSpace=function(e){l=e},this.getBaseLayer=function(){return null!==u?u:d},this.getBinding=function(){return h},this.getFrame=function(){return p},this.getSession=function(){return n},this.setSession=async function(c){if(n=c,null!==n){g=e.getRenderTarget(),n.addEventListener("select",C),n.addEventListener("selectstart",C),n.addEventListener("selectend",C),n.addEventListener("squeeze",C),n.addEventListener("squeezestart",C),n.addEventListener("squeezeend",C),n.addEventListener("end",R),n.addEventListener("inputsourceschange",L),!0!==f.xrCompatible&&await t.makeXRCompatible(),M=e.getPixelRatio(),e.getSize(y);if("undefined"!=typeof XRWebGLBinding&&"createProjectionLayer"in XRWebGLBinding.prototype){let r=null,a=null,s=null;f.depth&&(s=f.stencil?t.DEPTH24_STENCIL8:t.DEPTH_COMPONENT24,r=f.stencil?1027:1026,a=f.stencil?1020:1014);const o={colorFormat:t.RGBA8,depthFormat:s,scaleFactor:i};h=new XRWebGLBinding(n,t),u=h.createProjectionLayer(o),n.updateRenderState({layers:[u]}),e.setPixelRatio(1),e.setSize(u.textureWidth,u.textureHeight,!1),_=new WebGLRenderTarget(u.textureWidth,u.textureHeight,{format:1023,type:1009,depthTexture:new DepthTexture(u.textureWidth,u.textureHeight,a,void 0,void 0,void 0,void 0,void 0,void 0,r),stencilBuffer:f.stencil,colorSpace:e.outputColorSpace,samples:f.antialias?4:0,resolveDepthBuffer:!1===u.ignoreDepthValues,resolveStencilBuffer:!1===u.ignoreDepthValues})}else{const r={antialias:f.antialias,alpha:!0,depth:f.depth,stencil:f.stencil,framebufferScaleFactor:i};d=new XRWebGLLayer(n,t,r),n.updateRenderState({baseLayer:d}),e.setPixelRatio(1),e.setSize(d.framebufferWidth,d.framebufferHeight,!1),_=new WebGLRenderTarget(d.framebufferWidth,d.framebufferHeight,{format:1023,type:1009,colorSpace:e.outputColorSpace,stencilBuffer:f.stencil,resolveDepthBuffer:!1===d.ignoreDepthValues,resolveStencilBuffer:!1===d.ignoreDepthValues})}_.isXRRenderTarget=!0,this.setFoveation(o),l=null,a=await n.requestReferenceSpace(s),N.setContext(n),N.start(),r.isPresenting=!0,r.dispatchEvent({type:"sessionstart"})}},this.getEnvironmentBlendMode=function(){if(null!==n)return n.environmentBlendMode},this.getDepthTexture=function(){return m.getDepthTexture()};const P=new Vector3,I=new Vector3;function U(e,t){null===t?e.matrixWorld.copy(e.matrix):e.matrixWorld.multiplyMatrices(t.matrixWorld,e.matrix),e.matrixWorldInverse.copy(e.matrixWorld).invert()}this.updateCamera=function(e){if(null===n)return;let t=e.near,r=e.far;null!==m.texture&&(m.depthNear>0&&(t=m.depthNear),m.depthFar>0&&(r=m.depthFar)),E.near=b.near=S.near=t,E.far=b.far=S.far=r,A===E.near&&w===E.far||(n.updateRenderState({depthNear:E.near,depthFar:E.far}),A=E.near,w=E.far),S.layers.mask=2|e.layers.mask,b.layers.mask=4|e.layers.mask,E.layers.mask=S.layers.mask|b.layers.mask;const i=e.parent,a=E.cameras;U(E,i);for(let e=0;e<a.length;e++)U(a[e],i);2===a.length?function(e,t,r){P.setFromMatrixPosition(t.matrixWorld),I.setFromMatrixPosition(r.matrixWorld);const n=P.distanceTo(I),i=t.projectionMatrix.elements,a=r.projectionMatrix.elements,s=i[14]/(i[10]-1),o=i[14]/(i[10]+1),l=(i[9]+1)/i[5],c=(i[9]-1)/i[5],h=(i[8]-1)/i[0],u=(a[8]+1)/a[0],d=s*h,p=s*u,m=n/(-h+u),f=m*-h;if(t.matrixWorld.decompose(e.position,e.quaternion,e.scale),e.translateX(f),e.translateZ(m),e.matrixWorld.compose(e.position,e.quaternion,e.scale),e.matrixWorldInverse.copy(e.matrixWorld).invert(),-1===i[10])e.projectionMatrix.copy(t.projectionMatrix),e.projectionMatrixInverse.copy(t.projectionMatrixInverse);else{const t=s+m,r=o+m,i=d-f,a=p+(n-f),h=l*o/r*t,u=c*o/r*t;e.projectionMatrix.makePerspective(i,a,h,u,t,r),e.projectionMatrixInverse.copy(e.projectionMatrix).invert()}}(E,S,b):E.projectionMatrix.copy(S.projectionMatrix),function(e,t,r){null===r?e.matrix.copy(t.matrixWorld):(e.matrix.copy(r.matrixWorld),e.matrix.invert(),e.matrix.multiply(t.matrixWorld));e.matrix.decompose(e.position,e.quaternion,e.scale),e.updateMatrixWorld(!0),e.projectionMatrix.copy(t.projectionMatrix),e.projectionMatrixInverse.copy(t.projectionMatrixInverse),e.isPerspectiveCamera&&(e.fov=2*RAD2DEG*Math.atan(1/e.projectionMatrix.elements[5]),e.zoom=1)}(e,E,i)},this.getCamera=function(){return E},this.getFoveation=function(){if(null!==u||null!==d)return o},this.setFoveation=function(e){o=e,null!==u&&(u.fixedFoveation=e),null!==d&&void 0!==d.fixedFoveation&&(d.fixedFoveation=e)},this.hasDepthSensing=function(){return null!==m.texture},this.getDepthSensingMesh=function(){return m.getMesh(E)};let D=null;const N=new WebGLAnimation;N.setAnimationLoop((function(t,i){if(c=i.getViewerPose(l||a),p=i,null!==c){const t=c.views;null!==d&&(e.setRenderTargetFramebuffer(_,d.framebuffer),e.setRenderTarget(_));let r=!1;t.length!==E.cameras.length&&(E.cameras.length=0,r=!0);for(let n=0;n<t.length;n++){const i=t[n];let a=null;if(null!==d)a=d.getViewport(i);else{const t=h.getViewSubImage(u,i);a=t.viewport,0===n&&(e.setRenderTargetTextures(_,t.colorTexture,t.depthStencilTexture),e.setRenderTarget(_))}let s=T[n];void 0===s&&(s=new PerspectiveCamera,s.layers.enable(n),s.viewport=new Vector4,T[n]=s),s.matrix.fromArray(i.transform.matrix),s.matrix.decompose(s.position,s.quaternion,s.scale),s.projectionMatrix.fromArray(i.projectionMatrix),s.projectionMatrixInverse.copy(s.projectionMatrix).invert(),s.viewport.set(a.x,a.y,a.width,a.height),0===n&&(E.matrix.copy(s.matrix),E.matrix.decompose(E.position,E.quaternion,E.scale)),!0===r&&E.cameras.push(s)}const i=n.enabledFeatures;if(i&&i.includes("depth-sensing")&&"gpu-optimized"==n.depthUsage&&h){const r=h.getDepthInformation(t[0]);r&&r.isValid&&r.texture&&m.init(e,r,n.renderState)}}for(let e=0;e<v.length;e++){const t=x[e],r=v[e];null!==t&&void 0!==r&&r.update(t,i,l||a)}D&&D(t,i),i.detectedPlanes&&r.dispatchEvent({type:"planesdetected",data:i}),p=null})),this.setAnimationLoop=function(e){D=e},this.dispose=function(){}}}const _e1=new Euler,_m1=new Matrix4;function WebGLMaterials(e,t){function r(e,t){!0===e.matrixAutoUpdate&&e.updateMatrix(),t.value.copy(e.matrix)}function n(e,n){e.opacity.value=n.opacity,n.color&&e.diffuse.value.copy(n.color),n.emissive&&e.emissive.value.copy(n.emissive).multiplyScalar(n.emissiveIntensity),n.map&&(e.map.value=n.map,r(n.map,e.mapTransform)),n.alphaMap&&(e.alphaMap.value=n.alphaMap,r(n.alphaMap,e.alphaMapTransform)),n.bumpMap&&(e.bumpMap.value=n.bumpMap,r(n.bumpMap,e.bumpMapTransform),e.bumpScale.value=n.bumpScale,1===n.side&&(e.bumpScale.value*=-1)),n.normalMap&&(e.normalMap.value=n.normalMap,r(n.normalMap,e.normalMapTransform),e.normalScale.value.copy(n.normalScale),1===n.side&&e.normalScale.value.negate()),n.displacementMap&&(e.displacementMap.value=n.displacementMap,r(n.displacementMap,e.displacementMapTransform),e.displacementScale.value=n.displacementScale,e.displacementBias.value=n.displacementBias),n.emissiveMap&&(e.emissiveMap.value=n.emissiveMap,r(n.emissiveMap,e.emissiveMapTransform)),n.specularMap&&(e.specularMap.value=n.specularMap,r(n.specularMap,e.specularMapTransform)),n.alphaTest>0&&(e.alphaTest.value=n.alphaTest);const i=t.get(n),a=i.envMap,s=i.envMapRotation;a&&(e.envMap.value=a,_e1.copy(s),_e1.x*=-1,_e1.y*=-1,_e1.z*=-1,a.isCubeTexture&&!1===a.isRenderTargetTexture&&(_e1.y*=-1,_e1.z*=-1),e.envMapRotation.value.setFromMatrix4(_m1.makeRotationFromEuler(_e1)),e.flipEnvMap.value=a.isCubeTexture&&!1===a.isRenderTargetTexture?-1:1,e.reflectivity.value=n.reflectivity,e.ior.value=n.ior,e.refractionRatio.value=n.refractionRatio),n.lightMap&&(e.lightMap.value=n.lightMap,e.lightMapIntensity.value=n.lightMapIntensity,r(n.lightMap,e.lightMapTransform)),n.aoMap&&(e.aoMap.value=n.aoMap,e.aoMapIntensity.value=n.aoMapIntensity,r(n.aoMap,e.aoMapTransform))}return{refreshFogUniforms:function(t,r){r.color.getRGB(t.fogColor.value,getUnlitUniformColorSpace(e)),r.isFog?(t.fogNear.value=r.near,t.fogFar.value=r.far):r.isFogExp2&&(t.fogDensity.value=r.density)},refreshMaterialUniforms:function(e,i,a,s,o){i.isMeshBasicMaterial||i.isMeshLambertMaterial?n(e,i):i.isMeshToonMaterial?(n(e,i),function(e,t){t.gradientMap&&(e.gradientMap.value=t.gradientMap)}(e,i)):i.isMeshPhongMaterial?(n(e,i),function(e,t){e.specular.value.copy(t.specular),e.shininess.value=Math.max(t.shininess,1e-4)}(e,i)):i.isMeshStandardMaterial?(n(e,i),function(e,t){e.metalness.value=t.metalness,t.metalnessMap&&(e.metalnessMap.value=t.metalnessMap,r(t.metalnessMap,e.metalnessMapTransform));e.roughness.value=t.roughness,t.roughnessMap&&(e.roughnessMap.value=t.roughnessMap,r(t.roughnessMap,e.roughnessMapTransform));t.envMap&&(e.envMapIntensity.value=t.envMapIntensity)}(e,i),i.isMeshPhysicalMaterial&&function(e,t,n){e.ior.value=t.ior,t.sheen>0&&(e.sheenColor.value.copy(t.sheenColor).multiplyScalar(t.sheen),e.sheenRoughness.value=t.sheenRoughness,t.sheenColorMap&&(e.sheenColorMap.value=t.sheenColorMap,r(t.sheenColorMap,e.sheenColorMapTransform)),t.sheenRoughnessMap&&(e.sheenRoughnessMap.value=t.sheenRoughnessMap,r(t.sheenRoughnessMap,e.sheenRoughnessMapTransform)));t.clearcoat>0&&(e.clearcoat.value=t.clearcoat,e.clearcoatRoughness.value=t.clearcoatRoughness,t.clearcoatMap&&(e.clearcoatMap.value=t.clearcoatMap,r(t.clearcoatMap,e.clearcoatMapTransform)),t.clearcoatRoughnessMap&&(e.clearcoatRoughnessMap.value=t.clearcoatRoughnessMap,r(t.clearcoatRoughnessMap,e.clearcoatRoughnessMapTransform)),t.clearcoatNormalMap&&(e.clearcoatNormalMap.value=t.clearcoatNormalMap,r(t.clearcoatNormalMap,e.clearcoatNormalMapTransform),e.clearcoatNormalScale.value.copy(t.clearcoatNormalScale),1===t.side&&e.clearcoatNormalScale.value.negate()));t.dispersion>0&&(e.dispersion.value=t.dispersion);t.iridescence>0&&(e.iridescence.value=t.iridescence,e.iridescenceIOR.value=t.iridescenceIOR,e.iridescenceThicknessMinimum.value=t.iridescenceThicknessRange[0],e.iridescenceThicknessMaximum.value=t.iridescenceThicknessRange[1],t.iridescenceMap&&(e.iridescenceMap.value=t.iridescenceMap,r(t.iridescenceMap,e.iridescenceMapTransform)),t.iridescenceThicknessMap&&(e.iridescenceThicknessMap.value=t.iridescenceThicknessMap,r(t.iridescenceThicknessMap,e.iridescenceThicknessMapTransform)));t.transmission>0&&(e.transmission.value=t.transmission,e.transmissionSamplerMap.value=n.texture,e.transmissionSamplerSize.value.set(n.width,n.height),t.transmissionMap&&(e.transmissionMap.value=t.transmissionMap,r(t.transmissionMap,e.transmissionMapTransform)),e.thickness.value=t.thickness,t.thicknessMap&&(e.thicknessMap.value=t.thicknessMap,r(t.thicknessMap,e.thicknessMapTransform)),e.attenuationDistance.value=t.attenuationDistance,e.attenuationColor.value.copy(t.attenuationColor));t.anisotropy>0&&(e.anisotropyVector.value.set(t.anisotropy*Math.cos(t.anisotropyRotation),t.anisotropy*Math.sin(t.anisotropyRotation)),t.anisotropyMap&&(e.anisotropyMap.value=t.anisotropyMap,r(t.anisotropyMap,e.anisotropyMapTransform)));e.specularIntensity.value=t.specularIntensity,e.specularColor.value.copy(t.specularColor),t.specularColorMap&&(e.specularColorMap.value=t.specularColorMap,r(t.specularColorMap,e.specularColorMapTransform));t.specularIntensityMap&&(e.specularIntensityMap.value=t.specularIntensityMap,r(t.specularIntensityMap,e.specularIntensityMapTransform))}(e,i,o)):i.isMeshMatcapMaterial?(n(e,i),function(e,t){t.matcap&&(e.matcap.value=t.matcap)}(e,i)):i.isMeshDepthMaterial?n(e,i):i.isMeshDistanceMaterial?(n(e,i),function(e,r){const n=t.get(r).light;e.referencePosition.value.setFromMatrixPosition(n.matrixWorld),e.nearDistance.value=n.shadow.camera.near,e.farDistance.value=n.shadow.camera.far}(e,i)):i.isMeshNormalMaterial?n(e,i):i.isLineBasicMaterial?(function(e,t){e.diffuse.value.copy(t.color),e.opacity.value=t.opacity,t.map&&(e.map.value=t.map,r(t.map,e.mapTransform))}(e,i),i.isLineDashedMaterial&&function(e,t){e.dashSize.value=t.dashSize,e.totalSize.value=t.dashSize+t.gapSize,e.scale.value=t.scale}(e,i)):i.isPointsMaterial?function(e,t,n,i){e.diffuse.value.copy(t.color),e.opacity.value=t.opacity,e.size.value=t.size*n,e.scale.value=.5*i,t.map&&(e.map.value=t.map,r(t.map,e.uvTransform));t.alphaMap&&(e.alphaMap.value=t.alphaMap,r(t.alphaMap,e.alphaMapTransform));t.alphaTest>0&&(e.alphaTest.value=t.alphaTest)}(e,i,a,s):i.isSpriteMaterial?function(e,t){e.diffuse.value.copy(t.color),e.opacity.value=t.opacity,e.rotation.value=t.rotation,t.map&&(e.map.value=t.map,r(t.map,e.mapTransform));t.alphaMap&&(e.alphaMap.value=t.alphaMap,r(t.alphaMap,e.alphaMapTransform));t.alphaTest>0&&(e.alphaTest.value=t.alphaTest)}(e,i):i.isShadowMaterial?(e.color.value.copy(i.color),e.opacity.value=i.opacity):i.isShaderMaterial&&(i.uniformsNeedUpdate=!1)}}}function WebGLUniformsGroups(e,t,r,n){let i={},a={},s=[];const o=e.getParameter(e.MAX_UNIFORM_BUFFER_BINDINGS);function l(e,t,r,n){const i=e.value,a=t+"_"+r;if(void 0===n[a])return n[a]="number"==typeof i||"boolean"==typeof i?i:i.clone(),!0;{const e=n[a];if("number"==typeof i||"boolean"==typeof i){if(e!==i)return n[a]=i,!0}else if(!1===e.equals(i))return e.copy(i),!0}return!1}function c(e){const t={boundary:0,storage:0};return"number"==typeof e||"boolean"==typeof e?(t.boundary=4,t.storage=4):e.isVector2?(t.boundary=8,t.storage=8):e.isVector3||e.isColor?(t.boundary=16,t.storage=12):e.isVector4?(t.boundary=16,t.storage=16):e.isMatrix3?(t.boundary=48,t.storage=48):e.isMatrix4?(t.boundary=64,t.storage=64):e.isTexture?console.warn("THREE.WebGLRenderer: Texture samplers can not be part of an uniforms group."):console.warn("THREE.WebGLRenderer: Unsupported uniform value type.",e),t}function h(t){const r=t.target;r.removeEventListener("dispose",h);const n=s.indexOf(r.__bindingPointIndex);s.splice(n,1),e.deleteBuffer(i[r.id]),delete i[r.id],delete a[r.id]}return{bind:function(e,t){const r=t.program;n.uniformBlockBinding(e,r)},update:function(r,u){let d=i[r.id];void 0===d&&(!function(e){const t=e.uniforms;let r=0;const n=16;for(let e=0,i=t.length;e<i;e++){const i=Array.isArray(t[e])?t[e]:[t[e]];for(let e=0,t=i.length;e<t;e++){const t=i[e],a=Array.isArray(t.value)?t.value:[t.value];for(let e=0,i=a.length;e<i;e++){const i=c(a[e]),s=r%n,o=s%i.boundary,l=s+o;r+=o,0!==l&&n-l<i.storage&&(r+=n-l),t.__data=new Float32Array(i.storage/Float32Array.BYTES_PER_ELEMENT),t.__offset=r,r+=i.storage}}}const i=r%n;i>0&&(r+=n-i);e.__size=r,e.__cache={}}(r),d=function(t){const r=function(){for(let e=0;e<o;e++)if(-1===s.indexOf(e))return s.push(e),e;return console.error("THREE.WebGLRenderer: Maximum number of simultaneously usable uniforms groups reached."),0}();t.__bindingPointIndex=r;const n=e.createBuffer(),i=t.__size,a=t.usage;return e.bindBuffer(e.UNIFORM_BUFFER,n),e.bufferData(e.UNIFORM_BUFFER,i,a),e.bindBuffer(e.UNIFORM_BUFFER,null),e.bindBufferBase(e.UNIFORM_BUFFER,r,n),n}(r),i[r.id]=d,r.addEventListener("dispose",h));const p=u.program;n.updateUBOMapping(r,p);const m=t.render.frame;a[r.id]!==m&&(!function(t){const r=i[t.id],n=t.uniforms,a=t.__cache;e.bindBuffer(e.UNIFORM_BUFFER,r);for(let t=0,r=n.length;t<r;t++){const r=Array.isArray(n[t])?n[t]:[n[t]];for(let n=0,i=r.length;n<i;n++){const i=r[n];if(!0===l(i,t,n,a)){const t=i.__offset,r=Array.isArray(i.value)?i.value:[i.value];let n=0;for(let a=0;a<r.length;a++){const s=r[a],o=c(s);"number"==typeof s||"boolean"==typeof s?(i.__data[0]=s,e.bufferSubData(e.UNIFORM_BUFFER,t+n,i.__data)):s.isMatrix3?(i.__data[0]=s.elements[0],i.__data[1]=s.elements[1],i.__data[2]=s.elements[2],i.__data[3]=0,i.__data[4]=s.elements[3],i.__data[5]=s.elements[4],i.__data[6]=s.elements[5],i.__data[7]=0,i.__data[8]=s.elements[6],i.__data[9]=s.elements[7],i.__data[10]=s.elements[8],i.__data[11]=0):(s.toArray(i.__data,n),n+=o.storage/Float32Array.BYTES_PER_ELEMENT)}e.bufferSubData(e.UNIFORM_BUFFER,t,i.__data)}}}e.bindBuffer(e.UNIFORM_BUFFER,null)}(r),a[r.id]=m)},dispose:function(){for(const t in i)e.deleteBuffer(i[t]);s=[],i={},a={}}}}class WebGLRenderer{constructor(e={}){const{canvas:t=createCanvasElement(),context:r=null,depth:n=!0,stencil:i=!1,alpha:a=!1,antialias:s=!1,premultipliedAlpha:o=!0,preserveDrawingBuffer:l=!1,powerPreference:c="default",failIfMajorPerformanceCaveat:h=!1,reverseDepthBuffer:u=!1}=e;let d;if(this.isWebGLRenderer=!0,null!==r){if("undefined"!=typeof WebGLRenderingContext&&r instanceof WebGLRenderingContext)throw new Error("THREE.WebGLRenderer: WebGL 1 is not supported since r163.");d=r.getContextAttributes().alpha}else d=a;const p=new Uint32Array(4),m=new Int32Array(4);let f=null,g=null;const _=[],v=[];this.domElement=t,this.debug={checkShaderErrors:!0,onShaderError:null},this.autoClear=!0,this.autoClearColor=!0,this.autoClearDepth=!0,this.autoClearStencil=!0,this.sortObjects=!0,this.clippingPlanes=[],this.localClippingEnabled=!1,this.toneMapping=0,this.toneMappingExposure=1,this.transmissionResolutionScale=1;const x=this;let y=!1;this._outputColorSpace="srgb";let M=0,S=0,b=null,T=-1,E=null;const A=new Vector4,w=new Vector4;let C=null;const R=new Color(0);let L=0,P=t.width,I=t.height,U=1,D=null,N=null;const B=new Vector4(0,0,P,I),F=new Vector4(0,0,P,I);let O=!1;const V=new Frustum;let z=!1,G=!1;const k=new Matrix4,H=new Matrix4,W=new Vector3,$=new Vector4,X={background:null,fog:null,environment:null,overrideMaterial:null,isScene:!0};let j=!1;function q(){return null===b?U:1}let Y,Z,J,K,Q,ee,te,re,ne,ie,ae,se,oe,le,ce,he,ue,de,pe,me,fe,ge,_e,ve,xe=r;function ye(e,r){return t.getContext(e,r)}try{const e={alpha:!0,depth:n,stencil:i,antialias:s,premultipliedAlpha:o,preserveDrawingBuffer:l,powerPreference:c,failIfMajorPerformanceCaveat:h};if("setAttribute"in t&&t.setAttribute("data-engine","three.js r176"),t.addEventListener("webglcontextlost",be,!1),t.addEventListener("webglcontextrestored",Te,!1),t.addEventListener("webglcontextcreationerror",Ee,!1),null===xe){const t="webgl2";if(xe=ye(t,e),null===xe)throw ye(t)?new Error("Error creating WebGL context with your selected attributes."):new Error("Error creating WebGL context.")}}catch(e){throw console.error("THREE.WebGLRenderer: "+e.message),e}function Me(){Y=new WebGLExtensions(xe),Y.init(),ge=new WebGLUtils(xe,Y),Z=new WebGLCapabilities(xe,Y,e,ge),J=new WebGLState(xe,Y),Z.reverseDepthBuffer&&u&&J.buffers.depth.setReversed(!0),K=new WebGLInfo(xe),Q=new WebGLProperties,ee=new WebGLTextures(xe,Y,J,Q,Z,ge,K),te=new WebGLCubeMaps(x),re=new WebGLCubeUVMaps(x),ne=new WebGLAttributes(xe),_e=new WebGLBindingStates(xe,ne),ie=new WebGLGeometries(xe,ne,K,_e),ae=new WebGLObjects(xe,ie,ne,K),pe=new WebGLMorphtargets(xe,Z,ee),he=new WebGLClipping(Q),se=new WebGLPrograms(x,te,re,Y,Z,_e,he),oe=new WebGLMaterials(x,Q),le=new WebGLRenderLists,ce=new WebGLRenderStates(Y),de=new WebGLBackground(x,te,re,J,ae,d,o),ue=new WebGLShadowMap(x,ae,Z),ve=new WebGLUniformsGroups(xe,K,Z,J),me=new WebGLBufferRenderer(xe,Y,K),fe=new WebGLIndexedBufferRenderer(xe,Y,K),K.programs=se.programs,x.capabilities=Z,x.extensions=Y,x.properties=Q,x.renderLists=le,x.shadowMap=ue,x.state=J,x.info=K}Me();const Se=new WebXRManager(x,xe);function be(e){e.preventDefault(),console.log("THREE.WebGLRenderer: Context Lost."),y=!0}function Te(){console.log("THREE.WebGLRenderer: Context Restored."),y=!1;const e=K.autoReset,t=ue.enabled,r=ue.autoUpdate,n=ue.needsUpdate,i=ue.type;Me(),K.autoReset=e,ue.enabled=t,ue.autoUpdate=r,ue.needsUpdate=n,ue.type=i}function Ee(e){console.error("THREE.WebGLRenderer: A WebGL context could not be created. Reason: ",e.statusMessage)}function Ae(e){const t=e.target;t.removeEventListener("dispose",Ae),function(e){(function(e){const t=Q.get(e).programs;void 0!==t&&(t.forEach((function(e){se.releaseProgram(e)})),e.isShaderMaterial&&se.releaseShaderCache(e))})(e),Q.remove(e)}(t)}function we(e,t,r){!0===e.transparent&&2===e.side&&!1===e.forceSinglePass?(e.side=1,e.needsUpdate=!0,Fe(e,t,r),e.side=0,e.needsUpdate=!0,Fe(e,t,r),e.side=2):Fe(e,t,r)}this.xr=Se,this.getContext=function(){return xe},this.getContextAttributes=function(){return xe.getContextAttributes()},this.forceContextLoss=function(){const e=Y.get("WEBGL_lose_context");e&&e.loseContext()},this.forceContextRestore=function(){const e=Y.get("WEBGL_lose_context");e&&e.restoreContext()},this.getPixelRatio=function(){return U},this.setPixelRatio=function(e){void 0!==e&&(U=e,this.setSize(P,I,!1))},this.getSize=function(e){return e.set(P,I)},this.setSize=function(e,r,n=!0){Se.isPresenting?console.warn("THREE.WebGLRenderer: Can't change size while VR device is presenting."):(P=e,I=r,t.width=Math.floor(e*U),t.height=Math.floor(r*U),!0===n&&(t.style.width=e+"px",t.style.height=r+"px"),this.setViewport(0,0,e,r))},this.getDrawingBufferSize=function(e){return e.set(P*U,I*U).floor()},this.setDrawingBufferSize=function(e,r,n){P=e,I=r,U=n,t.width=Math.floor(e*n),t.height=Math.floor(r*n),this.setViewport(0,0,e,r)},this.getCurrentViewport=function(e){return e.copy(A)},this.getViewport=function(e){return e.copy(B)},this.setViewport=function(e,t,r,n){e.isVector4?B.set(e.x,e.y,e.z,e.w):B.set(e,t,r,n),J.viewport(A.copy(B).multiplyScalar(U).round())},this.getScissor=function(e){return e.copy(F)},this.setScissor=function(e,t,r,n){e.isVector4?F.set(e.x,e.y,e.z,e.w):F.set(e,t,r,n),J.scissor(w.copy(F).multiplyScalar(U).round())},this.getScissorTest=function(){return O},this.setScissorTest=function(e){J.setScissorTest(O=e)},this.setOpaqueSort=function(e){D=e},this.setTransparentSort=function(e){N=e},this.getClearColor=function(e){return e.copy(de.getClearColor())},this.setClearColor=function(){de.setClearColor(...arguments)},this.getClearAlpha=function(){return de.getClearAlpha()},this.setClearAlpha=function(){de.setClearAlpha(...arguments)},this.clear=function(e=!0,t=!0,r=!0){let n=0;if(e){let e=!1;if(null!==b){const t=b.texture.format;e=1033===t||1031===t||1029===t}if(e){const e=b.texture.type,t=1009===e||1014===e||1012===e||1020===e||1017===e||1018===e,r=de.getClearColor(),n=de.getClearAlpha(),i=r.r,a=r.g,s=r.b;t?(p[0]=i,p[1]=a,p[2]=s,p[3]=n,xe.clearBufferuiv(xe.COLOR,0,p)):(m[0]=i,m[1]=a,m[2]=s,m[3]=n,xe.clearBufferiv(xe.COLOR,0,m))}else n|=xe.COLOR_BUFFER_BIT}t&&(n|=xe.DEPTH_BUFFER_BIT),r&&(n|=xe.STENCIL_BUFFER_BIT,this.state.buffers.stencil.setMask(4294967295)),xe.clear(n)},this.clearColor=function(){this.clear(!0,!1,!1)},this.clearDepth=function(){this.clear(!1,!0,!1)},this.clearStencil=function(){this.clear(!1,!1,!0)},this.dispose=function(){t.removeEventListener("webglcontextlost",be,!1),t.removeEventListener("webglcontextrestored",Te,!1),t.removeEventListener("webglcontextcreationerror",Ee,!1),de.dispose(),le.dispose(),ce.dispose(),Q.dispose(),te.dispose(),re.dispose(),ae.dispose(),_e.dispose(),ve.dispose(),se.dispose(),Se.dispose(),Se.removeEventListener("sessionstart",Re),Se.removeEventListener("sessionend",Le),Pe.stop()},this.renderBufferDirect=function(e,t,r,n,i,a){null===t&&(t=X);const s=i.isMesh&&i.matrixWorld.determinant()<0,o=function(e,t,r,n,i){!0!==t.isScene&&(t=X);ee.resetTextureUnits();const a=t.fog,s=n.isMeshStandardMaterial?t.environment:null,o=null===b?x.outputColorSpace:!0===b.isXRRenderTarget?b.texture.colorSpace:"srgb-linear",l=(n.isMeshStandardMaterial?re:te).get(n.envMap||s),c=!0===n.vertexColors&&!!r.attributes.color&&4===r.attributes.color.itemSize,h=!!r.attributes.tangent&&(!!n.normalMap||n.anisotropy>0),u=!!r.morphAttributes.position,d=!!r.morphAttributes.normal,p=!!r.morphAttributes.color;let m=0;n.toneMapped&&(null!==b&&!0!==b.isXRRenderTarget||(m=x.toneMapping));const f=r.morphAttributes.position||r.morphAttributes.normal||r.morphAttributes.color,_=void 0!==f?f.length:0,v=Q.get(n),y=g.state.lights;if(!0===z&&(!0===G||e!==E)){const t=e===E&&n.id===T;he.setState(n,e,t)}let M=!1;n.version===v.__version?v.needsLights&&v.lightsStateVersion!==y.state.version||v.outputColorSpace!==o||i.isBatchedMesh&&!1===v.batching?M=!0:i.isBatchedMesh||!0!==v.batching?i.isBatchedMesh&&!0===v.batchingColor&&null===i.colorTexture||i.isBatchedMesh&&!1===v.batchingColor&&null!==i.colorTexture||i.isInstancedMesh&&!1===v.instancing?M=!0:i.isInstancedMesh||!0!==v.instancing?i.isSkinnedMesh&&!1===v.skinning?M=!0:i.isSkinnedMesh||!0!==v.skinning?i.isInstancedMesh&&!0===v.instancingColor&&null===i.instanceColor||i.isInstancedMesh&&!1===v.instancingColor&&null!==i.instanceColor||i.isInstancedMesh&&!0===v.instancingMorph&&null===i.morphTexture||i.isInstancedMesh&&!1===v.instancingMorph&&null!==i.morphTexture||v.envMap!==l||!0===n.fog&&v.fog!==a?M=!0:void 0===v.numClippingPlanes||v.numClippingPlanes===he.numPlanes&&v.numIntersection===he.numIntersection?(v.vertexAlphas!==c||v.vertexTangents!==h||v.morphTargets!==u||v.morphNormals!==d||v.morphColors!==p||v.toneMapping!==m||v.morphTargetsCount!==_)&&(M=!0):M=!0:M=!0:M=!0:M=!0:(M=!0,v.__version=n.version);let S=v.currentProgram;!0===M&&(S=Fe(n,t,i));let A=!1,w=!1,C=!1;const R=S.getUniforms(),L=v.uniforms;J.useProgram(S.program)&&(A=!0,w=!0,C=!0);n.id!==T&&(T=n.id,w=!0);if(A||E!==e){J.buffers.depth.getReversed()?(k.copy(e.projectionMatrix),toNormalizedProjectionMatrix(k),toReversedProjectionMatrix(k),R.setValue(xe,"projectionMatrix",k)):R.setValue(xe,"projectionMatrix",e.projectionMatrix),R.setValue(xe,"viewMatrix",e.matrixWorldInverse);const t=R.map.cameraPosition;void 0!==t&&t.setValue(xe,W.setFromMatrixPosition(e.matrixWorld)),Z.logarithmicDepthBuffer&&R.setValue(xe,"logDepthBufFC",2/(Math.log(e.far+1)/Math.LN2)),(n.isMeshPhongMaterial||n.isMeshToonMaterial||n.isMeshLambertMaterial||n.isMeshBasicMaterial||n.isMeshStandardMaterial||n.isShaderMaterial)&&R.setValue(xe,"isOrthographic",!0===e.isOrthographicCamera),E!==e&&(E=e,w=!0,C=!0)}if(i.isSkinnedMesh){R.setOptional(xe,i,"bindMatrix"),R.setOptional(xe,i,"bindMatrixInverse");const e=i.skeleton;e&&(null===e.boneTexture&&e.computeBoneTexture(),R.setValue(xe,"boneTexture",e.boneTexture,ee))}i.isBatchedMesh&&(R.setOptional(xe,i,"batchingTexture"),R.setValue(xe,"batchingTexture",i._matricesTexture,ee),R.setOptional(xe,i,"batchingIdTexture"),R.setValue(xe,"batchingIdTexture",i._indirectTexture,ee),R.setOptional(xe,i,"batchingColorTexture"),null!==i._colorsTexture&&R.setValue(xe,"batchingColorTexture",i._colorsTexture,ee));const P=r.morphAttributes;void 0===P.position&&void 0===P.normal&&void 0===P.color||pe.update(i,r,S);(w||v.receiveShadow!==i.receiveShadow)&&(v.receiveShadow=i.receiveShadow,R.setValue(xe,"receiveShadow",i.receiveShadow));n.isMeshGouraudMaterial&&null!==n.envMap&&(L.envMap.value=l,L.flipEnvMap.value=l.isCubeTexture&&!1===l.isRenderTargetTexture?-1:1);n.isMeshStandardMaterial&&null===n.envMap&&null!==t.environment&&(L.envMapIntensity.value=t.environmentIntensity);w&&(R.setValue(xe,"toneMappingExposure",x.toneMappingExposure),v.needsLights&&(N=C,(D=L).ambientLightColor.needsUpdate=N,D.lightProbe.needsUpdate=N,D.directionalLights.needsUpdate=N,D.directionalLightShadows.needsUpdate=N,D.pointLights.needsUpdate=N,D.pointLightShadows.needsUpdate=N,D.spotLights.needsUpdate=N,D.spotLightShadows.needsUpdate=N,D.rectAreaLights.needsUpdate=N,D.hemisphereLights.needsUpdate=N),a&&!0===n.fog&&oe.refreshFogUniforms(L,a),oe.refreshMaterialUniforms(L,n,U,I,g.state.transmissionRenderTarget[e.id]),WebGLUniforms.upload(xe,Oe(v),L,ee));var D,N;n.isShaderMaterial&&!0===n.uniformsNeedUpdate&&(WebGLUniforms.upload(xe,Oe(v),L,ee),n.uniformsNeedUpdate=!1);n.isSpriteMaterial&&R.setValue(xe,"center",i.center);if(R.setValue(xe,"modelViewMatrix",i.modelViewMatrix),R.setValue(xe,"normalMatrix",i.normalMatrix),R.setValue(xe,"modelMatrix",i.matrixWorld),n.isShaderMaterial||n.isRawShaderMaterial){const e=n.uniformsGroups;for(let t=0,r=e.length;t<r;t++){const r=e[t];ve.update(r,S),ve.bind(r,S)}}return S}(e,t,r,n,i);J.setMaterial(n,s);let l=r.index,c=1;if(!0===n.wireframe){if(l=ie.getWireframeAttribute(r),void 0===l)return;c=2}const h=r.drawRange,u=r.attributes.position;let d=h.start*c,p=(h.start+h.count)*c;null!==a&&(d=Math.max(d,a.start*c),p=Math.min(p,(a.start+a.count)*c)),null!==l?(d=Math.max(d,0),p=Math.min(p,l.count)):null!=u&&(d=Math.max(d,0),p=Math.min(p,u.count));const m=p-d;if(m<0||m===1/0)return;let f;_e.setup(i,n,o,r,l);let _=me;if(null!==l&&(f=ne.get(l),_=fe,_.setIndex(f)),i.isMesh)!0===n.wireframe?(J.setLineWidth(n.wireframeLinewidth*q()),_.setMode(xe.LINES)):_.setMode(xe.TRIANGLES);else if(i.isLine){let e=n.linewidth;void 0===e&&(e=1),J.setLineWidth(e*q()),i.isLineSegments?_.setMode(xe.LINES):i.isLineLoop?_.setMode(xe.LINE_LOOP):_.setMode(xe.LINE_STRIP)}else i.isPoints?_.setMode(xe.POINTS):i.isSprite&&_.setMode(xe.TRIANGLES);if(i.isBatchedMesh)if(null!==i._multiDrawInstances)warnOnce("THREE.WebGLRenderer: renderMultiDrawInstances has been deprecated and will be removed in r184. Append to renderMultiDraw arguments and use indirection."),_.renderMultiDrawInstances(i._multiDrawStarts,i._multiDrawCounts,i._multiDrawCount,i._multiDrawInstances);else if(Y.get("WEBGL_multi_draw"))_.renderMultiDraw(i._multiDrawStarts,i._multiDrawCounts,i._multiDrawCount);else{const e=i._multiDrawStarts,t=i._multiDrawCounts,r=i._multiDrawCount,a=l?ne.get(l).bytesPerElement:1,s=Q.get(n).currentProgram.getUniforms();for(let n=0;n<r;n++)s.setValue(xe,"_gl_DrawID",n),_.render(e[n]/a,t[n])}else if(i.isInstancedMesh)_.renderInstances(d,m,i.count);else if(r.isInstancedBufferGeometry){const e=void 0!==r._maxInstanceCount?r._maxInstanceCount:1/0,t=Math.min(r.instanceCount,e);_.renderInstances(d,m,t)}else _.render(d,m)},this.compile=function(e,t,r=null){null===r&&(r=e),g=ce.get(r),g.init(t),v.push(g),r.traverseVisible((function(e){e.isLight&&e.layers.test(t.layers)&&(g.pushLight(e),e.castShadow&&g.pushShadow(e))})),e!==r&&e.traverseVisible((function(e){e.isLight&&e.layers.test(t.layers)&&(g.pushLight(e),e.castShadow&&g.pushShadow(e))})),g.setupLights();const n=new Set;return e.traverse((function(e){if(!(e.isMesh||e.isPoints||e.isLine||e.isSprite))return;const t=e.material;if(t)if(Array.isArray(t))for(let i=0;i<t.length;i++){const a=t[i];we(a,r,e),n.add(a)}else we(t,r,e),n.add(t)})),g=v.pop(),n},this.compileAsync=function(e,t,r=null){const n=this.compile(e,t,r);return new Promise((t=>{function r(){n.forEach((function(e){Q.get(e).currentProgram.isReady()&&n.delete(e)})),0!==n.size?setTimeout(r,10):t(e)}null!==Y.get("KHR_parallel_shader_compile")?r():setTimeout(r,10)}))};let Ce=null;function Re(){Pe.stop()}function Le(){Pe.start()}const Pe=new WebGLAnimation;function Ie(e,t,r,n){if(!1===e.visible)return;if(e.layers.test(t.layers))if(e.isGroup)r=e.renderOrder;else if(e.isLOD)!0===e.autoUpdate&&e.update(t);else if(e.isLight)g.pushLight(e),e.castShadow&&g.pushShadow(e);else if(e.isSprite){if(!e.frustumCulled||V.intersectsSprite(e)){n&&$.setFromMatrixPosition(e.matrixWorld).applyMatrix4(H);const t=ae.update(e),i=e.material;i.visible&&f.push(e,t,i,r,$.z,null)}}else if((e.isMesh||e.isLine||e.isPoints)&&(!e.frustumCulled||V.intersectsObject(e))){const t=ae.update(e),i=e.material;if(n&&(void 0!==e.boundingSphere?(null===e.boundingSphere&&e.computeBoundingSphere(),$.copy(e.boundingSphere.center)):(null===t.boundingSphere&&t.computeBoundingSphere(),$.copy(t.boundingSphere.center)),$.applyMatrix4(e.matrixWorld).applyMatrix4(H)),Array.isArray(i)){const n=t.groups;for(let a=0,s=n.length;a<s;a++){const s=n[a],o=i[s.materialIndex];o&&o.visible&&f.push(e,t,o,r,$.z,s)}}else i.visible&&f.push(e,t,i,r,$.z,null)}const i=e.children;for(let e=0,a=i.length;e<a;e++)Ie(i[e],t,r,n)}function Ue(e,t,r,n){const i=e.opaque,a=e.transmissive,s=e.transparent;g.setupLightsView(r),!0===z&&he.setGlobalState(x.clippingPlanes,r),n&&J.viewport(A.copy(n)),i.length>0&&Ne(i,t,r),a.length>0&&Ne(a,t,r),s.length>0&&Ne(s,t,r),J.buffers.depth.setTest(!0),J.buffers.depth.setMask(!0),J.buffers.color.setMask(!0),J.setPolygonOffset(!1)}function De(e,t,r,n){if(null!==(!0===r.isScene?r.overrideMaterial:null))return;void 0===g.state.transmissionRenderTarget[n.id]&&(g.state.transmissionRenderTarget[n.id]=new WebGLRenderTarget(1,1,{generateMipmaps:!0,type:Y.has("EXT_color_buffer_half_float")||Y.has("EXT_color_buffer_float")?1016:1009,minFilter:1008,samples:4,stencilBuffer:i,resolveDepthBuffer:!1,resolveStencilBuffer:!1,colorSpace:ColorManagement.workingColorSpace}));const a=g.state.transmissionRenderTarget[n.id],s=n.viewport||A;a.setSize(s.z*x.transmissionResolutionScale,s.w*x.transmissionResolutionScale);const o=x.getRenderTarget();x.setRenderTarget(a),x.getClearColor(R),L=x.getClearAlpha(),L<1&&x.setClearColor(16777215,.5),x.clear(),j&&de.render(r);const l=x.toneMapping;x.toneMapping=0;const c=n.viewport;if(void 0!==n.viewport&&(n.viewport=void 0),g.setupLightsView(n),!0===z&&he.setGlobalState(x.clippingPlanes,n),Ne(e,r,n),ee.updateMultisampleRenderTarget(a),ee.updateRenderTargetMipmap(a),!1===Y.has("WEBGL_multisampled_render_to_texture")){let e=!1;for(let i=0,a=t.length;i<a;i++){const a=t[i],s=a.object,o=a.geometry,l=a.material,c=a.group;if(2===l.side&&s.layers.test(n.layers)){const t=l.side;l.side=1,l.needsUpdate=!0,Be(s,r,n,o,l,c),l.side=t,l.needsUpdate=!0,e=!0}}!0===e&&(ee.updateMultisampleRenderTarget(a),ee.updateRenderTargetMipmap(a))}x.setRenderTarget(o),x.setClearColor(R,L),void 0!==c&&(n.viewport=c),x.toneMapping=l}function Ne(e,t,r){const n=!0===t.isScene?t.overrideMaterial:null;for(let i=0,a=e.length;i<a;i++){const a=e[i],s=a.object,o=a.geometry,l=a.group;let c=a.material;!0===c.allowOverride&&null!==n&&(c=n),s.layers.test(r.layers)&&Be(s,t,r,o,c,l)}}function Be(e,t,r,n,i,a){e.onBeforeRender(x,t,r,n,i,a),e.modelViewMatrix.multiplyMatrices(r.matrixWorldInverse,e.matrixWorld),e.normalMatrix.getNormalMatrix(e.modelViewMatrix),i.onBeforeRender(x,t,r,n,e,a),!0===i.transparent&&2===i.side&&!1===i.forceSinglePass?(i.side=1,i.needsUpdate=!0,x.renderBufferDirect(r,t,n,i,e,a),i.side=0,i.needsUpdate=!0,x.renderBufferDirect(r,t,n,i,e,a),i.side=2):x.renderBufferDirect(r,t,n,i,e,a),e.onAfterRender(x,t,r,n,i,a)}function Fe(e,t,r){!0!==t.isScene&&(t=X);const n=Q.get(e),i=g.state.lights,a=g.state.shadowsArray,s=i.state.version,o=se.getParameters(e,i.state,a,t,r),l=se.getProgramCacheKey(o);let c=n.programs;n.environment=e.isMeshStandardMaterial?t.environment:null,n.fog=t.fog,n.envMap=(e.isMeshStandardMaterial?re:te).get(e.envMap||n.environment),n.envMapRotation=null!==n.environment&&null===e.envMap?t.environmentRotation:e.envMapRotation,void 0===c&&(e.addEventListener("dispose",Ae),c=new Map,n.programs=c);let h=c.get(l);if(void 0!==h){if(n.currentProgram===h&&n.lightsStateVersion===s)return Ve(e,o),h}else o.uniforms=se.getUniforms(e),e.onBeforeCompile(o,x),h=se.acquireProgram(o,l),c.set(l,h),n.uniforms=o.uniforms;const u=n.uniforms;return(e.isShaderMaterial||e.isRawShaderMaterial)&&!0!==e.clipping||(u.clippingPlanes=he.uniform),Ve(e,o),n.needsLights=function(e){return e.isMeshLambertMaterial||e.isMeshToonMaterial||e.isMeshPhongMaterial||e.isMeshStandardMaterial||e.isShadowMaterial||e.isShaderMaterial&&!0===e.lights}(e),n.lightsStateVersion=s,n.needsLights&&(u.ambientLightColor.value=i.state.ambient,u.lightProbe.value=i.state.probe,u.directionalLights.value=i.state.directional,u.directionalLightShadows.value=i.state.directionalShadow,u.spotLights.value=i.state.spot,u.spotLightShadows.value=i.state.spotShadow,u.rectAreaLights.value=i.state.rectArea,u.ltc_1.value=i.state.rectAreaLTC1,u.ltc_2.value=i.state.rectAreaLTC2,u.pointLights.value=i.state.point,u.pointLightShadows.value=i.state.pointShadow,u.hemisphereLights.value=i.state.hemi,u.directionalShadowMap.value=i.state.directionalShadowMap,u.directionalShadowMatrix.value=i.state.directionalShadowMatrix,u.spotShadowMap.value=i.state.spotShadowMap,u.spotLightMatrix.value=i.state.spotLightMatrix,u.spotLightMap.value=i.state.spotLightMap,u.pointShadowMap.value=i.state.pointShadowMap,u.pointShadowMatrix.value=i.state.pointShadowMatrix),n.currentProgram=h,n.uniformsList=null,h}function Oe(e){if(null===e.uniformsList){const t=e.currentProgram.getUniforms();e.uniformsList=WebGLUniforms.seqWithValue(t.seq,e.uniforms)}return e.uniformsList}function Ve(e,t){const r=Q.get(e);r.outputColorSpace=t.outputColorSpace,r.batching=t.batching,r.batchingColor=t.batchingColor,r.instancing=t.instancing,r.instancingColor=t.instancingColor,r.instancingMorph=t.instancingMorph,r.skinning=t.skinning,r.morphTargets=t.morphTargets,r.morphNormals=t.morphNormals,r.morphColors=t.morphColors,r.morphTargetsCount=t.morphTargetsCount,r.numClippingPlanes=t.numClippingPlanes,r.numIntersection=t.numClipIntersection,r.vertexAlphas=t.vertexAlphas,r.vertexTangents=t.vertexTangents,r.toneMapping=t.toneMapping}Pe.setAnimationLoop((function(e){Ce&&Ce(e)})),"undefined"!=typeof self&&Pe.setContext(self),this.setAnimationLoop=function(e){Ce=e,Se.setAnimationLoop(e),null===e?Pe.stop():Pe.start()},Se.addEventListener("sessionstart",Re),Se.addEventListener("sessionend",Le),this.render=function(e,t){if(void 0!==t&&!0!==t.isCamera)return void console.error("THREE.WebGLRenderer.render: camera is not an instance of THREE.Camera.");if(!0===y)return;if(!0===e.matrixWorldAutoUpdate&&e.updateMatrixWorld(),null===t.parent&&!0===t.matrixWorldAutoUpdate&&t.updateMatrixWorld(),!0===Se.enabled&&!0===Se.isPresenting&&(!0===Se.cameraAutoUpdate&&Se.updateCamera(t),t=Se.getCamera()),!0===e.isScene&&e.onBeforeRender(x,e,t,b),g=ce.get(e,v.length),g.init(t),v.push(g),H.multiplyMatrices(t.projectionMatrix,t.matrixWorldInverse),V.setFromProjectionMatrix(H),G=this.localClippingEnabled,z=he.init(this.clippingPlanes,G),f=le.get(e,_.length),f.init(),_.push(f),!0===Se.enabled&&!0===Se.isPresenting){const e=x.xr.getDepthSensingMesh();null!==e&&Ie(e,t,-1/0,x.sortObjects)}Ie(e,t,0,x.sortObjects),f.finish(),!0===x.sortObjects&&f.sort(D,N),j=!1===Se.enabled||!1===Se.isPresenting||!1===Se.hasDepthSensing(),j&&de.addToRenderList(f,e),this.info.render.frame++,!0===z&&he.beginShadows();const r=g.state.shadowsArray;ue.render(r,e,t),!0===z&&he.endShadows(),!0===this.info.autoReset&&this.info.reset();const n=f.opaque,i=f.transmissive;if(g.setupLights(),t.isArrayCamera){const r=t.cameras;if(i.length>0)for(let t=0,a=r.length;t<a;t++){De(n,i,e,r[t])}j&&de.render(e);for(let t=0,n=r.length;t<n;t++){const n=r[t];Ue(f,e,n,n.viewport)}}else i.length>0&&De(n,i,e,t),j&&de.render(e),Ue(f,e,t);null!==b&&0===S&&(ee.updateMultisampleRenderTarget(b),ee.updateRenderTargetMipmap(b)),!0===e.isScene&&e.onAfterRender(x,e,t),_e.resetDefaultState(),T=-1,E=null,v.pop(),v.length>0?(g=v[v.length-1],!0===z&&he.setGlobalState(x.clippingPlanes,g.state.camera)):g=null,_.pop(),f=_.length>0?_[_.length-1]:null},this.getActiveCubeFace=function(){return M},this.getActiveMipmapLevel=function(){return S},this.getRenderTarget=function(){return b},this.setRenderTargetTextures=function(e,t,r){const n=Q.get(e);n.__autoAllocateDepthBuffer=!1===e.resolveDepthBuffer,!1===n.__autoAllocateDepthBuffer&&(n.__useRenderToTexture=!1),Q.get(e.texture).__webglTexture=t,Q.get(e.depthTexture).__webglTexture=n.__autoAllocateDepthBuffer?void 0:r,n.__hasExternalTextures=!0},this.setRenderTargetFramebuffer=function(e,t){const r=Q.get(e);r.__webglFramebuffer=t,r.__useDefaultFramebuffer=void 0===t};const ze=xe.createFramebuffer();this.setRenderTarget=function(e,t=0,r=0){b=e,M=t,S=r;let n=!0,i=null,a=!1,s=!1;if(e){const o=Q.get(e);if(void 0!==o.__useDefaultFramebuffer)J.bindFramebuffer(xe.FRAMEBUFFER,null),n=!1;else if(void 0===o.__webglFramebuffer)ee.setupRenderTarget(e);else if(o.__hasExternalTextures)ee.rebindTextures(e,Q.get(e.texture).__webglTexture,Q.get(e.depthTexture).__webglTexture);else if(e.depthBuffer){const t=e.depthTexture;if(o.__boundDepthTexture!==t){if(null!==t&&Q.has(t)&&(e.width!==t.image.width||e.height!==t.image.height))throw new Error("WebGLRenderTarget: Attached DepthTexture is initialized to the incorrect size.");ee.setupDepthRenderbuffer(e)}}const l=e.texture;(l.isData3DTexture||l.isDataArrayTexture||l.isCompressedArrayTexture)&&(s=!0);const c=Q.get(e).__webglFramebuffer;e.isWebGLCubeRenderTarget?(i=Array.isArray(c[t])?c[t][r]:c[t],a=!0):i=e.samples>0&&!1===ee.useMultisampledRTT(e)?Q.get(e).__webglMultisampledFramebuffer:Array.isArray(c)?c[r]:c,A.copy(e.viewport),w.copy(e.scissor),C=e.scissorTest}else A.copy(B).multiplyScalar(U).floor(),w.copy(F).multiplyScalar(U).floor(),C=O;0!==r&&(i=ze);if(J.bindFramebuffer(xe.FRAMEBUFFER,i)&&n&&J.drawBuffers(e,i),J.viewport(A),J.scissor(w),J.setScissorTest(C),a){const n=Q.get(e.texture);xe.framebufferTexture2D(xe.FRAMEBUFFER,xe.COLOR_ATTACHMENT0,xe.TEXTURE_CUBE_MAP_POSITIVE_X+t,n.__webglTexture,r)}else if(s){const n=Q.get(e.texture),i=t;xe.framebufferTextureLayer(xe.FRAMEBUFFER,xe.COLOR_ATTACHMENT0,n.__webglTexture,r,i)}else if(null!==e&&0!==r){const t=Q.get(e.texture);xe.framebufferTexture2D(xe.FRAMEBUFFER,xe.COLOR_ATTACHMENT0,xe.TEXTURE_2D,t.__webglTexture,r)}T=-1},this.readRenderTargetPixels=function(e,t,r,n,i,a,s){if(!e||!e.isWebGLRenderTarget)return void console.error("THREE.WebGLRenderer.readRenderTargetPixels: renderTarget is not THREE.WebGLRenderTarget.");let o=Q.get(e).__webglFramebuffer;if(e.isWebGLCubeRenderTarget&&void 0!==s&&(o=o[s]),o){J.bindFramebuffer(xe.FRAMEBUFFER,o);try{const s=e.texture,o=s.format,l=s.type;if(!Z.textureFormatReadable(o))return void console.error("THREE.WebGLRenderer.readRenderTargetPixels: renderTarget is not in RGBA or implementation defined format.");if(!Z.textureTypeReadable(l))return void console.error("THREE.WebGLRenderer.readRenderTargetPixels: renderTarget is not in UnsignedByteType or implementation defined type.");t>=0&&t<=e.width-n&&r>=0&&r<=e.height-i&&xe.readPixels(t,r,n,i,ge.convert(o),ge.convert(l),a)}finally{const e=null!==b?Q.get(b).__webglFramebuffer:null;J.bindFramebuffer(xe.FRAMEBUFFER,e)}}},this.readRenderTargetPixelsAsync=async function(e,t,r,n,i,a,s){if(!e||!e.isWebGLRenderTarget)throw new Error("THREE.WebGLRenderer.readRenderTargetPixels: renderTarget is not THREE.WebGLRenderTarget.");let o=Q.get(e).__webglFramebuffer;if(e.isWebGLCubeRenderTarget&&void 0!==s&&(o=o[s]),o){if(t>=0&&t<=e.width-n&&r>=0&&r<=e.height-i){J.bindFramebuffer(xe.FRAMEBUFFER,o);const s=e.texture,l=s.format,c=s.type;if(!Z.textureFormatReadable(l))throw new Error("THREE.WebGLRenderer.readRenderTargetPixelsAsync: renderTarget is not in RGBA or implementation defined format.");if(!Z.textureTypeReadable(c))throw new Error("THREE.WebGLRenderer.readRenderTargetPixelsAsync: renderTarget is not in UnsignedByteType or implementation defined type.");const h=xe.createBuffer();xe.bindBuffer(xe.PIXEL_PACK_BUFFER,h),xe.bufferData(xe.PIXEL_PACK_BUFFER,a.byteLength,xe.STREAM_READ),xe.readPixels(t,r,n,i,ge.convert(l),ge.convert(c),0);const u=null!==b?Q.get(b).__webglFramebuffer:null;J.bindFramebuffer(xe.FRAMEBUFFER,u);const d=xe.fenceSync(xe.SYNC_GPU_COMMANDS_COMPLETE,0);return xe.flush(),await probeAsync(xe,d,4),xe.bindBuffer(xe.PIXEL_PACK_BUFFER,h),xe.getBufferSubData(xe.PIXEL_PACK_BUFFER,0,a),xe.deleteBuffer(h),xe.deleteSync(d),a}throw new Error("THREE.WebGLRenderer.readRenderTargetPixelsAsync: requested read bounds are out of range.")}},this.copyFramebufferToTexture=function(e,t=null,r=0){const n=Math.pow(2,-r),i=Math.floor(e.image.width*n),a=Math.floor(e.image.height*n),s=null!==t?t.x:0,o=null!==t?t.y:0;ee.setTexture2D(e,0),xe.copyTexSubImage2D(xe.TEXTURE_2D,r,0,0,s,o,i,a),J.unbindTexture()};const Ge=xe.createFramebuffer(),ke=xe.createFramebuffer();this.copyTextureToTexture=function(e,t,r=null,n=null,i=0,a=null){let s,o,l,c,h,u,d,p,m;null===a&&(0!==i?(warnOnce("WebGLRenderer: copyTextureToTexture function signature has changed to support src and dst mipmap levels."),a=i,i=0):a=0);const f=e.isCompressedTexture?e.mipmaps[a]:e.image;if(null!==r)s=r.max.x-r.min.x,o=r.max.y-r.min.y,l=r.isBox3?r.max.z-r.min.z:1,c=r.min.x,h=r.min.y,u=r.isBox3?r.min.z:0;else{const t=Math.pow(2,-i);s=Math.floor(f.width*t),o=Math.floor(f.height*t),l=e.isDataArrayTexture?f.depth:e.isData3DTexture?Math.floor(f.depth*t):1,c=0,h=0,u=0}null!==n?(d=n.x,p=n.y,m=n.z):(d=0,p=0,m=0);const g=ge.convert(t.format),_=ge.convert(t.type);let v;t.isData3DTexture?(ee.setTexture3D(t,0),v=xe.TEXTURE_3D):t.isDataArrayTexture||t.isCompressedArrayTexture?(ee.setTexture2DArray(t,0),v=xe.TEXTURE_2D_ARRAY):(ee.setTexture2D(t,0),v=xe.TEXTURE_2D),xe.pixelStorei(xe.UNPACK_FLIP_Y_WEBGL,t.flipY),xe.pixelStorei(xe.UNPACK_PREMULTIPLY_ALPHA_WEBGL,t.premultiplyAlpha),xe.pixelStorei(xe.UNPACK_ALIGNMENT,t.unpackAlignment);const x=xe.getParameter(xe.UNPACK_ROW_LENGTH),y=xe.getParameter(xe.UNPACK_IMAGE_HEIGHT),M=xe.getParameter(xe.UNPACK_SKIP_PIXELS),S=xe.getParameter(xe.UNPACK_SKIP_ROWS),b=xe.getParameter(xe.UNPACK_SKIP_IMAGES);xe.pixelStorei(xe.UNPACK_ROW_LENGTH,f.width),xe.pixelStorei(xe.UNPACK_IMAGE_HEIGHT,f.height),xe.pixelStorei(xe.UNPACK_SKIP_PIXELS,c),xe.pixelStorei(xe.UNPACK_SKIP_ROWS,h),xe.pixelStorei(xe.UNPACK_SKIP_IMAGES,u);const T=e.isDataArrayTexture||e.isData3DTexture,E=t.isDataArrayTexture||t.isData3DTexture;if(e.isDepthTexture){const r=Q.get(e),n=Q.get(t),f=Q.get(r.__renderTarget),g=Q.get(n.__renderTarget);J.bindFramebuffer(xe.READ_FRAMEBUFFER,f.__webglFramebuffer),J.bindFramebuffer(xe.DRAW_FRAMEBUFFER,g.__webglFramebuffer);for(let r=0;r<l;r++)T&&(xe.framebufferTextureLayer(xe.READ_FRAMEBUFFER,xe.COLOR_ATTACHMENT0,Q.get(e).__webglTexture,i,u+r),xe.framebufferTextureLayer(xe.DRAW_FRAMEBUFFER,xe.COLOR_ATTACHMENT0,Q.get(t).__webglTexture,a,m+r)),xe.blitFramebuffer(c,h,s,o,d,p,s,o,xe.DEPTH_BUFFER_BIT,xe.NEAREST);J.bindFramebuffer(xe.READ_FRAMEBUFFER,null),J.bindFramebuffer(xe.DRAW_FRAMEBUFFER,null)}else if(0!==i||e.isRenderTargetTexture||Q.has(e)){const r=Q.get(e),n=Q.get(t);J.bindFramebuffer(xe.READ_FRAMEBUFFER,Ge),J.bindFramebuffer(xe.DRAW_FRAMEBUFFER,ke);for(let e=0;e<l;e++)T?xe.framebufferTextureLayer(xe.READ_FRAMEBUFFER,xe.COLOR_ATTACHMENT0,r.__webglTexture,i,u+e):xe.framebufferTexture2D(xe.READ_FRAMEBUFFER,xe.COLOR_ATTACHMENT0,xe.TEXTURE_2D,r.__webglTexture,i),E?xe.framebufferTextureLayer(xe.DRAW_FRAMEBUFFER,xe.COLOR_ATTACHMENT0,n.__webglTexture,a,m+e):xe.framebufferTexture2D(xe.DRAW_FRAMEBUFFER,xe.COLOR_ATTACHMENT0,xe.TEXTURE_2D,n.__webglTexture,a),0!==i?xe.blitFramebuffer(c,h,s,o,d,p,s,o,xe.COLOR_BUFFER_BIT,xe.NEAREST):E?xe.copyTexSubImage3D(v,a,d,p,m+e,c,h,s,o):xe.copyTexSubImage2D(v,a,d,p,c,h,s,o);J.bindFramebuffer(xe.READ_FRAMEBUFFER,null),J.bindFramebuffer(xe.DRAW_FRAMEBUFFER,null)}else E?e.isDataTexture||e.isData3DTexture?xe.texSubImage3D(v,a,d,p,m,s,o,l,g,_,f.data):t.isCompressedArrayTexture?xe.compressedTexSubImage3D(v,a,d,p,m,s,o,l,g,f.data):xe.texSubImage3D(v,a,d,p,m,s,o,l,g,_,f):e.isDataTexture?xe.texSubImage2D(xe.TEXTURE_2D,a,d,p,s,o,g,_,f.data):e.isCompressedTexture?xe.compressedTexSubImage2D(xe.TEXTURE_2D,a,d,p,f.width,f.height,g,f.data):xe.texSubImage2D(xe.TEXTURE_2D,a,d,p,s,o,g,_,f);xe.pixelStorei(xe.UNPACK_ROW_LENGTH,x),xe.pixelStorei(xe.UNPACK_IMAGE_HEIGHT,y),xe.pixelStorei(xe.UNPACK_SKIP_PIXELS,M),xe.pixelStorei(xe.UNPACK_SKIP_ROWS,S),xe.pixelStorei(xe.UNPACK_SKIP_IMAGES,b),0===a&&t.generateMipmaps&&xe.generateMipmap(v),J.unbindTexture()},this.copyTextureToTexture3D=function(e,t,r=null,n=null,i=0){return warnOnce('WebGLRenderer: copyTextureToTexture3D function has been deprecated. Use "copyTextureToTexture" instead.'),this.copyTextureToTexture(e,t,r,n,i)},this.initRenderTarget=function(e){void 0===Q.get(e).__webglFramebuffer&&ee.setupRenderTarget(e)},this.initTexture=function(e){e.isCubeTexture?ee.setTextureCube(e,0):e.isData3DTexture?ee.setTexture3D(e,0):e.isDataArrayTexture||e.isCompressedArrayTexture?ee.setTexture2DArray(e,0):ee.setTexture2D(e,0),J.unbindTexture()},this.resetState=function(){M=0,S=0,b=null,J.reset(),_e.reset()},"undefined"!=typeof __THREE_DEVTOOLS__&&__THREE_DEVTOOLS__.dispatchEvent(new CustomEvent("observe",{detail:this}))}get coordinateSystem(){return 2e3}get outputColorSpace(){return this._outputColorSpace}set outputColorSpace(e){this._outputColorSpace=e;const t=this.getContext();t.drawingBufferColorSpace=ColorManagement._getDrawingBufferColorSpace(e),t.unpackColorSpace=ColorManagement._getUnpackColorSpace()}}exports.ACESFilmicToneMapping=4,exports.AddEquation=100,exports.AddOperation=2,exports.AdditiveAnimationBlendMode=2501,exports.AdditiveBlending=2,exports.AgXToneMapping=6,exports.AlphaFormat=1021,exports.AlwaysCompare=519,exports.AlwaysDepth=1,exports.AlwaysStencilFunc=519,exports.AmbientLight=AmbientLight,exports.AnimationAction=AnimationAction,exports.AnimationClip=AnimationClip,exports.AnimationLoader=AnimationLoader,exports.AnimationMixer=AnimationMixer,exports.AnimationObjectGroup=AnimationObjectGroup,exports.AnimationUtils=AnimationUtils,exports.ArcCurve=ArcCurve,exports.ArrayCamera=ArrayCamera,exports.ArrowHelper=ArrowHelper,exports.AttachedBindMode="attached",exports.Audio=Audio,exports.AudioAnalyser=AudioAnalyser,exports.AudioContext=AudioContext,exports.AudioListener=AudioListener,exports.AudioLoader=AudioLoader,exports.AxesHelper=AxesHelper,exports.BackSide=1,exports.BasicDepthPacking=3200,exports.BasicShadowMap=0,exports.BatchedMesh=BatchedMesh,exports.Bone=Bone,exports.BooleanKeyframeTrack=BooleanKeyframeTrack,exports.Box2=Box2,exports.Box3=Box3,exports.Box3Helper=Box3Helper,exports.BoxGeometry=BoxGeometry,exports.BoxHelper=BoxHelper,exports.BufferAttribute=BufferAttribute,exports.BufferGeometry=BufferGeometry,exports.BufferGeometryLoader=BufferGeometryLoader,exports.ByteType=1010,exports.Cache=Cache,exports.Camera=Camera,exports.CameraHelper=CameraHelper,exports.CanvasTexture=CanvasTexture,exports.CapsuleGeometry=CapsuleGeometry,exports.CatmullRomCurve3=CatmullRomCurve3,exports.CineonToneMapping=3,exports.CircleGeometry=CircleGeometry,exports.ClampToEdgeWrapping=1001,exports.Clock=Clock,exports.Color=Color,exports.ColorKeyframeTrack=ColorKeyframeTrack,exports.ColorManagement=ColorManagement,exports.CompressedArrayTexture=CompressedArrayTexture,exports.CompressedCubeTexture=CompressedCubeTexture,exports.CompressedTexture=CompressedTexture,exports.CompressedTextureLoader=CompressedTextureLoader,exports.ConeGeometry=ConeGeometry,exports.ConstantAlphaFactor=213,exports.ConstantColorFactor=211,exports.Controls=Controls,exports.CubeCamera=CubeCamera,exports.CubeReflectionMapping=301,exports.CubeRefractionMapping=302,exports.CubeTexture=CubeTexture,exports.CubeTextureLoader=CubeTextureLoader,exports.CubeUVReflectionMapping=306,exports.CubicBezierCurve=CubicBezierCurve,exports.CubicBezierCurve3=CubicBezierCurve3,exports.CubicInterpolant=CubicInterpolant,exports.CullFaceBack=1,exports.CullFaceFront=2,exports.CullFaceFrontBack=3,exports.CullFaceNone=0,exports.Curve=Curve,exports.CurvePath=CurvePath,exports.CustomBlending=5,exports.CustomToneMapping=5,exports.CylinderGeometry=CylinderGeometry,exports.Cylindrical=Cylindrical,exports.Data3DTexture=Data3DTexture,exports.DataArrayTexture=DataArrayTexture,exports.DataTexture=DataTexture,exports.DataTextureLoader=DataTextureLoader,exports.DataUtils=DataUtils,exports.DecrementStencilOp=7683,exports.DecrementWrapStencilOp=34056,exports.DefaultLoadingManager=DefaultLoadingManager,exports.DepthArrayTexture=DepthArrayTexture,exports.DepthFormat=1026,exports.DepthStencilFormat=1027,exports.DepthTexture=DepthTexture,exports.DetachedBindMode="detached",exports.DirectionalLight=DirectionalLight,exports.DirectionalLightHelper=DirectionalLightHelper,exports.DiscreteInterpolant=DiscreteInterpolant,exports.DodecahedronGeometry=DodecahedronGeometry,exports.DoubleSide=2,exports.DstAlphaFactor=206,exports.DstColorFactor=208,exports.DynamicCopyUsage=35050,exports.DynamicDrawUsage=35048,exports.DynamicReadUsage=35049,exports.EdgesGeometry=EdgesGeometry,exports.EllipseCurve=EllipseCurve,exports.EqualCompare=514,exports.EqualDepth=4,exports.EqualStencilFunc=514,exports.EquirectangularReflectionMapping=303,exports.EquirectangularRefractionMapping=304,exports.Euler=Euler,exports.EventDispatcher=EventDispatcher,exports.ExtrudeGeometry=ExtrudeGeometry,exports.FileLoader=FileLoader,exports.Float16BufferAttribute=Float16BufferAttribute,exports.Float32BufferAttribute=Float32BufferAttribute,exports.FloatType=1015,exports.Fog=Fog,exports.FogExp2=FogExp2,exports.FramebufferTexture=FramebufferTexture,exports.FrontSide=0,exports.Frustum=Frustum,exports.FrustumArray=FrustumArray,exports.GLBufferAttribute=GLBufferAttribute,exports.GLSL1="100",exports.GLSL3=GLSL3,exports.GreaterCompare=516,exports.GreaterDepth=6,exports.GreaterEqualCompare=518,exports.GreaterEqualDepth=5,exports.GreaterEqualStencilFunc=518,exports.GreaterStencilFunc=516,exports.GridHelper=GridHelper,exports.Group=Group,exports.HalfFloatType=1016,exports.HemisphereLight=HemisphereLight,exports.HemisphereLightHelper=HemisphereLightHelper,exports.IcosahedronGeometry=IcosahedronGeometry,exports.ImageBitmapLoader=ImageBitmapLoader,exports.ImageLoader=ImageLoader,exports.ImageUtils=ImageUtils,exports.IncrementStencilOp=7682,exports.IncrementWrapStencilOp=34055,exports.InstancedBufferAttribute=InstancedBufferAttribute,exports.InstancedBufferGeometry=InstancedBufferGeometry,exports.InstancedInterleavedBuffer=InstancedInterleavedBuffer,exports.InstancedMesh=InstancedMesh,exports.Int16BufferAttribute=Int16BufferAttribute,exports.Int32BufferAttribute=Int32BufferAttribute,exports.Int8BufferAttribute=Int8BufferAttribute,exports.IntType=1013,exports.InterleavedBuffer=InterleavedBuffer,exports.InterleavedBufferAttribute=InterleavedBufferAttribute,exports.Interpolant=Interpolant,exports.InterpolateDiscrete=2300,exports.InterpolateLinear=2301,exports.InterpolateSmooth=2302,exports.InterpolationSamplingMode=InterpolationSamplingMode,exports.InterpolationSamplingType=InterpolationSamplingType,exports.InvertStencilOp=5386,exports.KeepStencilOp=7680,exports.KeyframeTrack=KeyframeTrack,exports.LOD=LOD,exports.LatheGeometry=LatheGeometry,exports.Layers=Layers,exports.LessCompare=513,exports.LessDepth=2,exports.LessEqualCompare=515,exports.LessEqualDepth=3,exports.LessEqualStencilFunc=515,exports.LessStencilFunc=513,exports.Light=Light,exports.LightProbe=LightProbe,exports.Line=Line,exports.Line3=Line3,exports.LineBasicMaterial=LineBasicMaterial,exports.LineCurve=LineCurve,exports.LineCurve3=LineCurve3,exports.LineDashedMaterial=LineDashedMaterial,exports.LineLoop=LineLoop,exports.LineSegments=LineSegments,exports.LinearFilter=1006,exports.LinearInterpolant=LinearInterpolant,exports.LinearMipMapLinearFilter=1008,exports.LinearMipMapNearestFilter=1007,exports.LinearMipmapLinearFilter=1008,exports.LinearMipmapNearestFilter=1007,exports.LinearSRGBColorSpace="srgb-linear",exports.LinearToneMapping=1,exports.LinearTransfer="linear",exports.Loader=Loader,exports.LoaderUtils=LoaderUtils,exports.LoadingManager=LoadingManager,exports.LoopOnce=2200,exports.LoopPingPong=2202,exports.LoopRepeat=2201,exports.MOUSE=MOUSE,exports.Material=Material,exports.MaterialLoader=MaterialLoader,exports.MathUtils=MathUtils,exports.Matrix2=Matrix2,exports.Matrix3=Matrix3,exports.Matrix4=Matrix4,exports.MaxEquation=104,exports.Mesh=Mesh,exports.MeshBasicMaterial=MeshBasicMaterial,exports.MeshDepthMaterial=MeshDepthMaterial,exports.MeshDistanceMaterial=MeshDistanceMaterial,exports.MeshLambertMaterial=MeshLambertMaterial,exports.MeshMatcapMaterial=MeshMatcapMaterial,exports.MeshNormalMaterial=MeshNormalMaterial,exports.MeshPhongMaterial=MeshPhongMaterial,exports.MeshPhysicalMaterial=MeshPhysicalMaterial,exports.MeshStandardMaterial=MeshStandardMaterial,exports.MeshToonMaterial=MeshToonMaterial,exports.MinEquation=103,exports.MirroredRepeatWrapping=1002,exports.MixOperation=1,exports.MultiplyBlending=4,exports.MultiplyOperation=0,exports.NearestFilter=1003,exports.NearestMipMapLinearFilter=1005,exports.NearestMipMapNearestFilter=1004,exports.NearestMipmapLinearFilter=1005,exports.NearestMipmapNearestFilter=1004,exports.NeutralToneMapping=7,exports.NeverCompare=512,exports.NeverDepth=0,exports.NeverStencilFunc=512,exports.NoBlending=0,exports.NoColorSpace="",exports.NoToneMapping=0,exports.NormalAnimationBlendMode=2500,exports.NormalBlending=1,exports.NotEqualCompare=517,exports.NotEqualDepth=7,exports.NotEqualStencilFunc=517,exports.NumberKeyframeTrack=NumberKeyframeTrack,exports.Object3D=Object3D,exports.ObjectLoader=ObjectLoader,exports.ObjectSpaceNormalMap=1,exports.OctahedronGeometry=OctahedronGeometry,exports.OneFactor=201,exports.OneMinusConstantAlphaFactor=214,exports.OneMinusConstantColorFactor=212,exports.OneMinusDstAlphaFactor=207,exports.OneMinusDstColorFactor=209,exports.OneMinusSrcAlphaFactor=205,exports.OneMinusSrcColorFactor=203,exports.OrthographicCamera=OrthographicCamera,exports.PCFShadowMap=1,exports.PCFSoftShadowMap=2,exports.PMREMGenerator=PMREMGenerator,exports.Path=Path,exports.PerspectiveCamera=PerspectiveCamera,exports.Plane=Plane,exports.PlaneGeometry=PlaneGeometry,exports.PlaneHelper=PlaneHelper,exports.PointLight=PointLight,exports.PointLightHelper=PointLightHelper,exports.Points=Points,exports.PointsMaterial=PointsMaterial,exports.PolarGridHelper=PolarGridHelper,exports.PolyhedronGeometry=PolyhedronGeometry,exports.PositionalAudio=PositionalAudio,exports.PropertyBinding=PropertyBinding,exports.PropertyMixer=PropertyMixer,exports.QuadraticBezierCurve=QuadraticBezierCurve,exports.QuadraticBezierCurve3=QuadraticBezierCurve3,exports.Quaternion=Quaternion,exports.QuaternionKeyframeTrack=QuaternionKeyframeTrack,exports.QuaternionLinearInterpolant=QuaternionLinearInterpolant,exports.RED_GREEN_RGTC2_Format=36285,exports.RED_RGTC1_Format=36283,exports.REVISION="176",exports.RGBADepthPacking=3201,exports.RGBAFormat=1023,exports.RGBAIntegerFormat=1033,exports.RGBA_ASTC_10x10_Format=37819,exports.RGBA_ASTC_10x5_Format=37816,exports.RGBA_ASTC_10x6_Format=37817,exports.RGBA_ASTC_10x8_Format=37818,exports.RGBA_ASTC_12x10_Format=37820,exports.RGBA_ASTC_12x12_Format=37821,exports.RGBA_ASTC_4x4_Format=37808,exports.RGBA_ASTC_5x4_Format=37809,exports.RGBA_ASTC_5x5_Format=37810,exports.RGBA_ASTC_6x5_Format=37811,exports.RGBA_ASTC_6x6_Format=37812,exports.RGBA_ASTC_8x5_Format=37813,exports.RGBA_ASTC_8x6_Format=37814,exports.RGBA_ASTC_8x8_Format=37815,exports.RGBA_BPTC_Format=36492,exports.RGBA_ETC2_EAC_Format=37496,exports.RGBA_PVRTC_2BPPV1_Format=35843,exports.RGBA_PVRTC_4BPPV1_Format=35842,exports.RGBA_S3TC_DXT1_Format=33777,exports.RGBA_S3TC_DXT3_Format=33778,exports.RGBA_S3TC_DXT5_Format=33779,exports.RGBDepthPacking=3202,exports.RGBFormat=1022,exports.RGBIntegerFormat=1032,exports.RGB_BPTC_SIGNED_Format=36494,exports.RGB_BPTC_UNSIGNED_Format=36495,exports.RGB_ETC1_Format=36196,exports.RGB_ETC2_Format=37492,exports.RGB_PVRTC_2BPPV1_Format=35841,exports.RGB_PVRTC_4BPPV1_Format=35840,exports.RGB_S3TC_DXT1_Format=33776,exports.RGDepthPacking=3203,exports.RGFormat=1030,exports.RGIntegerFormat=1031,exports.RawShaderMaterial=RawShaderMaterial,exports.Ray=Ray,exports.Raycaster=Raycaster,exports.RectAreaLight=RectAreaLight,exports.RedFormat=1028,exports.RedIntegerFormat=1029,exports.ReinhardToneMapping=2,exports.RenderTarget=RenderTarget,exports.RenderTarget3D=RenderTarget3D,exports.RenderTargetArray=RenderTargetArray,exports.RepeatWrapping=1e3,exports.ReplaceStencilOp=7681,exports.ReverseSubtractEquation=102,exports.RingGeometry=RingGeometry,exports.SIGNED_RED_GREEN_RGTC2_Format=36286,exports.SIGNED_RED_RGTC1_Format=36284,exports.SRGBColorSpace="srgb",exports.SRGBTransfer="srgb",exports.Scene=Scene,exports.ShaderChunk=ShaderChunk,exports.ShaderLib=ShaderLib,exports.ShaderMaterial=ShaderMaterial,exports.ShadowMaterial=ShadowMaterial,exports.Shape=Shape,exports.ShapeGeometry=ShapeGeometry,exports.ShapePath=ShapePath,exports.ShapeUtils=ShapeUtils,exports.ShortType=1011,exports.Skeleton=Skeleton,exports.SkeletonHelper=SkeletonHelper,exports.SkinnedMesh=SkinnedMesh,exports.Source=Source,exports.Sphere=Sphere,exports.SphereGeometry=SphereGeometry,exports.Spherical=Spherical,exports.SphericalHarmonics3=SphericalHarmonics3,exports.SplineCurve=SplineCurve,exports.SpotLight=SpotLight,exports.SpotLightHelper=SpotLightHelper,exports.Sprite=Sprite,exports.SpriteMaterial=SpriteMaterial,exports.SrcAlphaFactor=204,exports.SrcAlphaSaturateFactor=210,exports.SrcColorFactor=202,exports.StaticCopyUsage=35046,exports.StaticDrawUsage=35044,exports.StaticReadUsage=35045,exports.StereoCamera=StereoCamera,exports.StreamCopyUsage=35042,exports.StreamDrawUsage=35040,exports.StreamReadUsage=35041,exports.StringKeyframeTrack=StringKeyframeTrack,exports.SubtractEquation=101,exports.SubtractiveBlending=3,exports.TOUCH=TOUCH,exports.TangentSpaceNormalMap=0,exports.TetrahedronGeometry=TetrahedronGeometry,exports.Texture=Texture,exports.TextureLoader=TextureLoader,exports.TextureUtils=TextureUtils,exports.TimestampQuery=TimestampQuery,exports.TorusGeometry=TorusGeometry,exports.TorusKnotGeometry=TorusKnotGeometry,exports.Triangle=Triangle,exports.TriangleFanDrawMode=2,exports.TriangleStripDrawMode=1,exports.TrianglesDrawMode=0,exports.TubeGeometry=TubeGeometry,exports.UVMapping=300,exports.Uint16BufferAttribute=Uint16BufferAttribute,exports.Uint32BufferAttribute=Uint32BufferAttribute,exports.Uint8BufferAttribute=Uint8BufferAttribute,exports.Uint8ClampedBufferAttribute=Uint8ClampedBufferAttribute,exports.Uniform=Uniform,exports.UniformsGroup=UniformsGroup,exports.UniformsLib=UniformsLib,exports.UniformsUtils=UniformsUtils,exports.UnsignedByteType=1009,exports.UnsignedInt248Type=1020,exports.UnsignedInt5999Type=35902,exports.UnsignedIntType=1014,exports.UnsignedShort4444Type=1017,exports.UnsignedShort5551Type=1018,exports.UnsignedShortType=1012,exports.VSMShadowMap=3,exports.Vector2=Vector2,exports.Vector3=Vector3,exports.Vector4=Vector4,exports.VectorKeyframeTrack=VectorKeyframeTrack,exports.VideoFrameTexture=VideoFrameTexture,exports.VideoTexture=VideoTexture,exports.WebGL3DRenderTarget=WebGL3DRenderTarget,exports.WebGLArrayRenderTarget=WebGLArrayRenderTarget,exports.WebGLCoordinateSystem=2e3,exports.WebGLCubeRenderTarget=WebGLCubeRenderTarget,exports.WebGLRenderTarget=WebGLRenderTarget,exports.WebGLRenderer=WebGLRenderer,exports.WebGLUtils=WebGLUtils,exports.WebGPUCoordinateSystem=2001,exports.WebXRController=WebXRController,exports.WireframeGeometry=WireframeGeometry,exports.WrapAroundEnding=2402,exports.ZeroCurvatureEnding=2400,exports.ZeroFactor=200,exports.ZeroSlopeEnding=2401,exports.ZeroStencilOp=0,exports.createCanvasElement=createCanvasElement;